#!/bin/bash
##################################################################
# Filename: CheckEnv.sh
# Function: Check Environment for GBase 8s install.
# Write by: liaosnet@gbasedbt.com
# Version : 1.4.8   update date: 2023-12-04
##################################################################
##### Defind env
export LANG=C
loginfo(){
  echo -e "[$(date +'%Y-%m-%d %H:%M:%S')] $*"
}

# ping CNNIC SDNS
ping -c 5 1.2.4.8
PINGOK=$?
##### yum install 
if [ ${PINGOK} = 0 -a -x /usr/bin/yum ]; then
  loginfo "Try to execute yum install.."
  yum -y install unzip tar java-1.8.0-openjdk glibc-devel ncurses-libs ncurses-compat-libs libnsl libaio
elif [ ${PINGOK} = 0 -a -x /usr/bin/apt ]; then
  loginfo "Try to execute apt install.."
  apt -y install unzip tar openjdk-8-jdk glibc-tools libncurses5 libnsl-dev libaio-dev
fi

##### Tool Check
TOOLS="tar timeout unzip"
QPATH="/usr/bin /usr/sbin /bin /sbin"
for TOOL in $TOOLS
do
  FIND=""
  for QP in $QPATH
  do
    FIND=$(cd $QP && find . -name $TOOL)
    if [ ! x"${FIND}" = x ];then
      break;
    fi
  done
  if [ x"${FIND}" = x ];then
    loginfo "$TOOL not found."
    exit 1
  fi
done

##### Lib Check
ARCH=$(lscpu | awk '/Architecture:/{print $2}')
LIBS="libc.so.6 libm.so.6 libnsl.so.1 libncurses.so.5 libtinfo.so.5"
QPATH=""

case $ARCH in 
  x86_64)
    # libs in /usr/lib64 (CentOS), or in /lib/x86_64-linux-gnu (Ubuntu 18.04)
    QPATH="/usr/lib64 /usr/lib /lib64 /lib"
    ;;
  aarch64)
    # libs in /lib/aarch64-linux-gnu
    QPATH="/lib /lib64 /usr/lib /usr/lib64"
    ;;
  *)
    QPATH="/lib64 /lib"
    ;;
esac

for LIB in $LIBS
do
  FIND=""
  for QP in $QPATH
  do
    if [ -d $QP ]; then
      FIND=$(cd $QP && find . -name $LIB)
    fi
    if [ ! x"${FIND}" = x ];then
      break;
    fi
  done 
  if [ x"${FIND}" = x ];then
    loginfo "$LIB not found."
    if [ "x${LIB}" = "xlibnsl.so.1" ]; then
      loginfo "libnsl.so.1 missing, if install need JDK/JRE may failue !"
    else
      exit 1
    fi
  fi
done

##### hostname 
HOSTNAME=$(hostname)
HOST=$(grep -i ${HOSTNAME} /etc/hosts)
if [ x"${HOST}" = x ];then
  loginfo "${HOSTNAME} not define in /etc/hosts, auto add it."
  echo "127.0.0.1 ${HOSTNAME}" >> /etc/hosts
fi

exit 0
