#!/usr/bin/perl
#
#   @(#)$Id: t51getinfo.t,v 2014.1 2014/04/21 06:38:37 jleffler Exp $
#
#   Test get_info metadata function for DBD::GBasedbt
#
#   Copyright 2002-03 IBM
#   Copyright 2013-14 Jonathan Leffler

use strict;
use warnings;
use DBD::GBasedbt::TestHarness;

# This test generates the number of tests at the end!

my %sql_info_type_map =
(
    SQL_ACCESSIBLE_PROCEDURES           => [    20, "value" ],
    SQL_ACCESSIBLE_TABLES               => [    19, "value" ],
    SQL_ACTIVE_CONNECTIONS              => [     0, "value" ],
    SQL_ACTIVE_ENVIRONMENTS             => [   116, "value" ],
    SQL_ACTIVE_STATEMENTS               => [     1, "value" ],
    SQL_AGGREGATE_FUNCTIONS             => [   169, "value" ],
    SQL_ALTER_DOMAIN                    => [   117, "value" ],
    SQL_ALTER_TABLE                     => [    86, "value" ],
    SQL_ASYNC_MODE                      => [ 10021, "value" ],
    SQL_BATCH_ROW_COUNT                 => [   120, "value" ],
    SQL_BATCH_SUPPORT                   => [   121, "value" ],
    SQL_BOOKMARK_PERSISTENCE            => [    82, "value" ],
    SQL_CATALOG_LOCATION                => [   114, "value" ],
    SQL_CATALOG_NAME                    => [ 10003, "value" ],
    SQL_CATALOG_NAME_SEPARATOR          => [    41, "value" ],
    SQL_CATALOG_TERM                    => [    42, "value" ],
    SQL_CATALOG_USAGE                   => [    92, "value" ],
    SQL_COLLATING_SEQUENCE              => [ 10004, "value" ],
    SQL_COLLATION_SEQ                   => [ 10004, "value" ],
    SQL_COLUMN_ALIAS                    => [    87, "value" ],
    SQL_CONCAT_NULL_BEHAVIOR            => [    22, "value" ],
    SQL_CONVERT_BIGINT                  => [    53, "value" ],
    SQL_CONVERT_BINARY                  => [    54, "value" ],
    SQL_CONVERT_BIT                     => [    55, "value" ],
    SQL_CONVERT_CHAR                    => [    56, "value" ],
    SQL_CONVERT_DATE                    => [    57, "value" ],
    SQL_CONVERT_DECIMAL                 => [    58, "value" ],
    SQL_CONVERT_DOUBLE                  => [    59, "value" ],
    SQL_CONVERT_FLOAT                   => [    60, "value" ],
    SQL_CONVERT_FUNCTIONS               => [    48, "value" ],
    SQL_CONVERT_INTEGER                 => [    61, "value" ],
    SQL_CONVERT_INTERVAL_DAY_TIME       => [   123, "value" ],
    SQL_CONVERT_INTERVAL_YEAR_MONTH     => [   124, "value" ],
    SQL_CONVERT_LONGVARBINARY           => [    71, "value" ],
    SQL_CONVERT_LONGVARCHAR             => [    62, "value" ],
    SQL_CONVERT_NUMERIC                 => [    63, "value" ],
    SQL_CONVERT_REAL                    => [    64, "value" ],
    SQL_CONVERT_SMALLINT                => [    65, "value" ],
    SQL_CONVERT_TIME                    => [    66, "value" ],
    SQL_CONVERT_TIMESTAMP               => [    67, "value" ],
    SQL_CONVERT_TINYINT                 => [    68, "value" ],
    SQL_CONVERT_VARBINARY               => [    69, "value" ],
    SQL_CONVERT_VARCHAR                 => [    70, "value" ],
    SQL_CONVERT_WCHAR                   => [   122, "value" ],
    SQL_CONVERT_WLONGVARCHAR            => [   125, "value" ],
    SQL_CONVERT_WVARCHAR                => [   126, "value" ],
    SQL_CORRELATION_NAME                => [    74, "value" ],
    SQL_CREATE_ASSERTION                => [   127, "value" ],
    SQL_CREATE_CHARACTER_SET            => [   128, "value" ],
    SQL_CREATE_COLLATION                => [   129, "value" ],
    SQL_CREATE_DOMAIN                   => [   130, "value" ],
    SQL_CREATE_SCHEMA                   => [   131, "value" ],
    SQL_CREATE_TABLE                    => [   132, "value" ],
    SQL_CREATE_TRANSLATION              => [   133, "value" ],
    SQL_CREATE_VIEW                     => [   134, "value" ],
    SQL_CURSOR_COMMIT_BEHAVIOR          => [    23, "value" ],
    SQL_CURSOR_ROLLBACK_BEHAVIOR        => [    24, "value" ],
    SQL_CURSOR_SENSITIVITY              => [ 10001, "value" ],
    SQL_DATA_SOURCE_NAME                => [     2, "value" ],
    SQL_DATA_SOURCE_READ_ONLY           => [    25, "value" ],
    SQL_DATETIME_LITERALS               => [   119, "value" ],
    SQL_DBMS_NAME                       => [    17, "value" ],
    SQL_DBMS_VER                        => [    18, "value" ],
    SQL_DBMS_VERSION                    => [    18, "value" ],
    SQL_DDL_INDEX                       => [   170, "value" ],
    SQL_DEFAULT_TXN_ISOLATION           => [    26, "value" ],
    SQL_DESCRIBE_PARAMETER              => [ 10002, "value" ],
    SQL_DRIVER_HDBC                     => [     3, "undef" ],
    SQL_DRIVER_HENV                     => [     4, "undef" ],
    SQL_DRIVER_NAME                     => [     6, "value" ],
    SQL_DRIVER_ODBC_VER                 => [    77, "undef" ],
    SQL_DRIVER_VER                      => [     7, "value" ],
    SQL_DROP_ASSERTION                  => [   136, "value" ],
    SQL_DROP_CHARACTER_SET              => [   137, "value" ],
    SQL_DROP_COLLATION                  => [   138, "value" ],
    SQL_DROP_DOMAIN                     => [   139, "value" ],
    SQL_DROP_SCHEMA                     => [   140, "value" ],
    SQL_DROP_TABLE                      => [   141, "value" ],
    SQL_DROP_TRANSLATION                => [   142, "value" ],
    SQL_DROP_VIEW                       => [   143, "value" ],
    SQL_DYNAMIC_CURSOR_ATTRIBUTES1      => [   144, "value" ],
    SQL_DYNAMIC_CURSOR_ATTRIBUTES2      => [   145, "value" ],
    SQL_EXPRESSIONS_IN_ORDERBY          => [    27, "value" ],
    SQL_FETCH_DIRECTION                 => [     8, "value" ],
    SQL_FILE_USAGE                      => [    84, "value" ],
    SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES1 => [   146, "value" ],
    SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES2 => [   147, "value" ],
    SQL_GETDATA_EXTENSIONS              => [    81, "value" ],
    SQL_GROUP_BY                        => [    88, "value" ],
    SQL_IDENTIFIER_CASE                 => [    28, "value" ],
    SQL_IDENTIFIER_QUOTE_CHAR           => [    29, "value" ],
    SQL_INDEX_KEYWORDS                  => [   148, "value" ],
    SQL_INFO_SCHEMA_VIEWS               => [   149, "value" ],
    SQL_INSERT_STATEMENT                => [   172, "value" ],
    SQL_INTEGRITY                       => [    73, "value" ],
    SQL_KEYSET_CURSOR_ATTRIBUTES1       => [   150, "value" ],
    SQL_KEYSET_CURSOR_ATTRIBUTES2       => [   151, "value" ],
    SQL_LIKE_ESCAPE_CLAUSE              => [   113, "value" ],
    SQL_LOCK_TYPES                      => [    78, "value" ],
    SQL_MAXIMUM_CATALOG_NAME_LENGTH     => [    34, "value" ],
    SQL_MAXIMUM_COLUMNS_IN_GROUP_BY     => [    97, "value" ],
    SQL_MAXIMUM_COLUMNS_IN_INDEX        => [    98, "value" ],
    SQL_MAXIMUM_COLUMNS_IN_ORDER_BY     => [    99, "value" ],
    SQL_MAXIMUM_COLUMNS_IN_SELECT       => [   100, "value" ],
    SQL_MAXIMUM_COLUMNS_IN_TABLE        => [   101, "value" ],
    SQL_MAXIMUM_COLUMN_NAME_LENGTH      => [    30, "value" ],
    SQL_MAXIMUM_CONCURRENT_ACTIVITIES   => [     1, "value" ],
    SQL_MAXIMUM_CURSOR_NAME_LENGTH      => [    31, "value" ],
    SQL_MAXIMUM_DRIVER_CONNECTIONS      => [     0, "value" ],
    SQL_MAXIMUM_IDENTIFIER_LENGTH       => [ 10005, "value" ],
    SQL_MAXIMUM_INDEX_SIZE              => [   102, "value" ],
    SQL_MAXIMUM_ROW_SIZE                => [   104, "value" ],
    SQL_MAXIMUM_SCHEMA_NAME_LENGTH      => [    32, "value" ],
    SQL_MAXIMUM_STATEMENT_LENGTH        => [   105, "value" ],
    SQL_MAXIMUM_TABLES_IN_SELECT        => [   106, "value" ],
    SQL_MAXIMUM_TABLE_NAME_LENGTH       => [    35, "value" ],
    SQL_MAXIMUM_USER_NAME_LENGTH        => [   107, "value" ],
    SQL_MAX_ASYNC_CONCURRENT_STATEMENTS => [ 10022, "value" ],
    SQL_MAX_BINARY_LITERAL_LEN          => [   112, "value" ],
    SQL_MAX_CATALOG_NAME_LEN            => [    34, "value" ],
    SQL_MAX_CHAR_LITERAL_LEN            => [   108, "value" ],
    SQL_MAX_COLUMNS_IN_GROUP_BY         => [    97, "value" ],
    SQL_MAX_COLUMNS_IN_INDEX            => [    98, "value" ],
    SQL_MAX_COLUMNS_IN_ORDER_BY         => [    99, "value" ],
    SQL_MAX_COLUMNS_IN_SELECT           => [   100, "value" ],
    SQL_MAX_COLUMNS_IN_TABLE            => [   101, "value" ],
    SQL_MAX_COLUMN_NAME_LEN             => [    30, "value" ],
    SQL_MAX_CONCURRENT_ACTIVITIES       => [     1, "value" ],
    SQL_MAX_CURSOR_NAME_LEN             => [    31, "value" ],
    SQL_MAX_DRIVER_CONNECTIONS          => [     0, "value" ],
    SQL_MAX_IDENTIFIER_LEN              => [ 10005, "value" ],
    SQL_MAX_INDEX_SIZE                  => [   102, "value" ],
    SQL_MAX_OWNER_NAME_LEN              => [    32, "value" ],
    SQL_MAX_PROCEDURE_NAME_LEN          => [    33, "value" ],
    SQL_MAX_QUALIFIER_NAME_LEN          => [    34, "value" ],
    SQL_MAX_ROW_SIZE                    => [   104, "value" ],
    SQL_MAX_ROW_SIZE_INCLUDES_LONG      => [   103, "value" ],
    SQL_MAX_SCHEMA_NAME_LEN             => [    32, "value" ],
    SQL_MAX_STATEMENT_LEN               => [   105, "value" ],
    SQL_MAX_TABLES_IN_SELECT            => [   106, "value" ],
    SQL_MAX_TABLE_NAME_LEN              => [    35, "value" ],
    SQL_MAX_USER_NAME_LEN               => [   107, "value" ],
    SQL_MULTIPLE_ACTIVE_TXN             => [    37, "value" ],
    SQL_MULT_RESULT_SETS                => [    36, "value" ],
    SQL_NEED_LONG_DATA_LEN              => [   111, "value" ],
    SQL_NON_NULLABLE_COLUMNS            => [    75, "value" ],
    SQL_NULL_COLLATION                  => [    85, "value" ],
    SQL_NUMERIC_FUNCTIONS               => [    49, "value" ],
    SQL_ODBC_API_CONFORMANCE            => [     9, "value" ],
    SQL_ODBC_INTERFACE_CONFORMANCE      => [   152, "value" ],
    SQL_ODBC_SAG_CLI_CONFORMANCE        => [    12, "value" ],
    SQL_ODBC_SQL_CONFORMANCE            => [    15, "value" ],
    SQL_ODBC_SQL_OPT_IEF                => [    73, "value" ],
    SQL_ODBC_VER                        => [    10, "undef" ],
    SQL_OJ_CAPABILITIES                 => [   115, "value" ],
    SQL_ORDER_BY_COLUMNS_IN_SELECT      => [    90, "value" ],
    SQL_OUTER_JOINS                     => [    38, "value" ],
    SQL_OUTER_JOIN_CAPABILITIES         => [   115, "value" ],
    SQL_OWNER_TERM                      => [    39, "value" ],
    SQL_OWNER_USAGE                     => [    91, "value" ],
    SQL_PARAM_ARRAY_ROW_COUNTS          => [   153, "value" ],
    SQL_PARAM_ARRAY_SELECTS             => [   154, "value" ],
    SQL_POSITIONED_STATEMENTS           => [    80, "value" ],
    SQL_POS_OPERATIONS                  => [    79, "value" ],
    SQL_PROCEDURES                      => [    21, "value" ],
    SQL_PROCEDURE_TERM                  => [    40, "value" ],
    SQL_QUALIFIER_LOCATION              => [   114, "value" ],
    SQL_QUALIFIER_NAME_SEPARATOR        => [    41, "value" ],
    SQL_QUALIFIER_TERM                  => [    42, "value" ],
    SQL_QUALIFIER_USAGE                 => [    92, "value" ],
    SQL_QUOTED_IDENTIFIER_CASE          => [    93, "value" ],
    SQL_ROW_UPDATES                     => [    11, "value" ],
    SQL_SCHEMA_TERM                     => [    39, "value" ],
    SQL_SCHEMA_USAGE                    => [    91, "value" ],
    SQL_SCROLL_CONCURRENCY              => [    43, "value" ],
    SQL_SCROLL_OPTIONS                  => [    44, "value" ],
    SQL_SEARCH_PATTERN_ESCAPE           => [    14, "value" ],
    SQL_SERVER_NAME                     => [    13, "value" ],
    SQL_SPECIAL_CHARACTERS              => [    94, "value" ],
    SQL_SQL92_DATETIME_FUNCTIONS        => [   155, "value" ],
    SQL_SQL92_FOREIGN_KEY_DELETE_RULE   => [   156, "value" ],
    SQL_SQL92_FOREIGN_KEY_UPDATE_RULE   => [   157, "value" ],
    SQL_SQL92_GRANT                     => [   158, "value" ],
    SQL_SQL92_NUMERIC_VALUE_FUNCTIONS   => [   159, "value" ],
    SQL_SQL92_PREDICATES                => [   160, "value" ],
    SQL_SQL92_RELATIONAL_JOIN_OPERATORS => [   161, "value" ],
    SQL_SQL92_REVOKE                    => [   162, "value" ],
    SQL_SQL92_ROW_VALUE_CONSTRUCTOR     => [   163, "value" ],
    SQL_SQL92_STRING_FUNCTIONS          => [   164, "value" ],
    SQL_SQL92_VALUE_EXPRESSIONS         => [   165, "value" ],
    SQL_SQL_CONFORMANCE                 => [   118, "value" ],
    SQL_STANDARD_CLI_CONFORMANCE        => [   166, "value" ],
    SQL_STATIC_CURSOR_ATTRIBUTES1       => [   167, "value" ],
    SQL_STATIC_CURSOR_ATTRIBUTES2       => [   168, "value" ],
    SQL_STATIC_SENSITIVITY              => [    83, "value" ],
    SQL_STRING_FUNCTIONS                => [    50, "value" ],
    SQL_SUBQUERIES                      => [    95, "value" ],
    SQL_SYSTEM_FUNCTIONS                => [    51, "value" ],
    SQL_TABLE_TERM                      => [    45, "value" ],
    SQL_TIMEDATE_ADD_INTERVALS          => [   109, "value" ],
    SQL_TIMEDATE_DIFF_INTERVALS         => [   110, "value" ],
    SQL_TIMEDATE_FUNCTIONS              => [    52, "value" ],
    SQL_TRANSACTION_CAPABLE             => [    46, "value" ],
    SQL_TRANSACTION_ISOLATION_OPTION    => [    72, "value" ],
    SQL_TXN_CAPABLE                     => [    46, "value" ],
    SQL_TXN_ISOLATION_OPTION            => [    72, "value" ],
    SQL_UNION                           => [    96, "value" ],
    SQL_UNION_STATEMENT                 => [    96, "value" ],
    SQL_USER_NAME                       => [    47, "value" ],
    SQL_XOPEN_CLI_YEAR                  => [ 10000, "undef" ],
);

my($dbname, $dbuser, $dbpass) = ("","","");
foreach my $connector (\&primary_connection, \&secondary_connection, \&tertiary_connection)
{
    # Test connection
    my ($newname, $newuser, $newpass) = &$connector();
    if ($newname ne $dbname)
    {
        ($dbname, $dbuser, $dbpass) = ($newname, $newuser, $newpass);
        my $dbh = connect_controllably(1, { AutoCommit => 1, PrintError => 1 }, $connector);
        print_dbinfo($dbh);

        foreach my $key (sort keys %sql_info_type_map)
        {
            my @arr = @{$sql_info_type_map{$key}};
            my $idx = $arr[0];
            my $val = $dbh->get_info($idx);
            $val = 'undef' unless defined $val;
            printf "# %-35s = %5d => <<%s>>\n", $key, $idx, $val;
            ($val ne 'undef' || $arr[1] eq 'undef') ? stmt_ok : stmt_nok;
        }

        $dbh->disconnect ? stmt_ok : stmt_nok;
    }
}

my $cnt = stmt_counter;

print "1..$cnt\n";

all_ok();
