#!/usr/bin/env python

from setuptools import setup
import os
import re


v = open(os.path.join(os.path.dirname(__file__), 'DbtAlchemy', '__init__.py'))
VERSION = re.compile(r".*__version__ = '(.*?)'", re.S).match(v.read()).group(1)
v.close()

readme = os.path.join(os.path.dirname(__file__), 'README.rst')
if 'USE_PYODBC' in os.environ and os.environ['USE_PYODBC'] == '1':
    require = ['sqlalchemy>=0.7.3,<2.0','typing-extensions<3.10']
else:
    require = ['sqlalchemy>=0.7.3,<2.0','typing-extensions<3.10','DbtPy>=3.0.3']


setup(
         name='DbtAlchemy',
         version=VERSION,
         license='Apache License 2.0',
         description='SQLAlchemy support for GBase 8s Servers',
         url='https://gbasedbt.com',
         author='Development Team',
         author_email='dbt@gbasebdt.com',
         keywords='sqlalchemy database interface for GBase 8s servers',
         long_description_content_type='text/markdown',
         classifiers=[
            'Development Status :: 4 - Beta',
            'Intended Audience :: Developers',
            'License :: OSI Approved :: Apache Software License',
            'Operating System :: OS Independent',
            'Topic :: Database :: Front-Ends'
        ],
         long_description=open(readme).read(),
         platforms='All',
         install_requires= require,
         packages=['DbtAlchemy'],
        entry_points={
         'sqlalchemy.dialects': [
                     'Dbt=DbtAlchemy.DbtPy:DbtDialect_DbtPy',
                     'Dbt.DbtPy=DbtAlchemy.DbtPy:DbtDialect_DbtPy',
                     # older "DbtAlchemy://" style for backwards
                     # compatibility
                     'DbtAlchemy=DbtAlchemy.DbtPy:DbtDialect_DbtPy',
                     'DbtAlchemy.pyodbc=DbtAlchemy.pyodbc:DbtDialect_pyodbc',
                    ]
       },
       zip_safe=False,
       tests_require=['nose >= 0.11'],
     )
