using System;
using System.Data;
using System.Data.Odbc;

namespace TestCsODBC
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("\n  测试Linux下dotnet通过ODBC方式连接到数据库\n");
            String connStr = "Driver={GBase ODBC DRIVER};DSN=testdb";

            /*
            // 缩写
            String connStr = "Driver=/opt/gbase8s-odbc-driver/lib/cli/iclit09b.so;" +
	                     "Host=192.168.0.57;SERV=9088;PROT=onsoctcp;SRVR=gbase01;" +
			     "DB=testdb;DLOC=zh_CN.utf8;CLOC=zh_CN.utf8;" +
                             "UID=gbasedbt;PWD=GBase123;" + 
			     "TDLL=/opt/gbase8s-odbc-driver/lib/esql/igo4a304.so" ;
             */
            OdbcConnection odbcconn = new OdbcConnection(connStr);
            try
            {
                odbcconn.Open();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }

            using (OdbcCommand odbccmd = odbcconn.CreateCommand())
            {
                // drop table
		odbccmd.CommandText = "drop table if exists company";
                odbccmd.ExecuteNonQuery();

                // create table 
		odbccmd.CommandText = "create table company(coid serial,coname varchar(255),coaddr varchar(255))";
                odbccmd.ExecuteNonQuery();
				
		// insert rows
		odbccmd.CommandText = "insert into company values (0,'南大通用','天津市海泰绿色产业基地')";
                odbccmd.ExecuteNonQuery();

                odbccmd.CommandText = "insert into company values (0,'南大通用北京分公司','北京市朝阳区太阳宫')";
                odbccmd.ExecuteNonQuery();

                // update row
		odbccmd.CommandText = "update company set coaddr = '天津市普天创新园' where coid = 1";
                odbccmd.ExecuteNonQuery();
				
		// select rows
		odbccmd.CommandText = "select * from company";
                OdbcDataReader dr = odbccmd.ExecuteReader();
                while (dr.Read())
                {
                    Console.WriteLine("  " + dr[0] + "\t" + dr[1] + "\t" + dr[2]);
                }
            }			
			
            Console.WriteLine("\n  测试Linux下dotnet通过ODBC方式连接到数据库 结束\n");
        }
    }
}
