﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using GBS.Data.GBasedbt;

namespace TestDotNet
{
    public partial class Form1 : Form
    {
        IfxConnection ifxconn;
        DataSet ds;

        public Form1()
        {
            InitializeComponent();
            IfxConnectionStringBuilder build = new IfxConnectionStringBuilder();
            build.Host = "bd.gbasedbt.com";     // 主机名或者IP地址
            build.Service = "9088";             // 数据库服务器使用的端口号
            build.Server = "gbase01";           // 数据库服务名称
            build.Database = "utf8";            // 数据库名（DBNAME)
            build.UID = "gbasedbt";             // 用户
            build.Pwd = "GBase123";             // 密码
            build.DbLocale = "zh_CN.utf8";      // 数据库字符集
            build.ClientLocale = "zh_CN.utf8";  // 客户端字符集
            build.PersistSecurityInfo = true;   // 保存安全信息
            ifxconn = new IfxConnection(build.ConnectionString);
            ifxconn.Open();

            using (IfxCommand ifxcmd = ifxconn.CreateCommand())
            {
                ifxcmd.CommandText = "drop table if exists company";
                ifxcmd.ExecuteNonQuery();

                ifxcmd.CommandText = "create table company(coid serial,coname varchar(255),coaddr varchar(255))";
                ifxcmd.ExecuteNonQuery();

                ifxcmd.CommandText = "insert into company values (0,'南大通用','天津市海泰绿色产业基地')";
                ifxcmd.ExecuteNonQuery();

                ifxcmd.CommandText = "insert into company values (0,'南大通用北京分公司','北京市朝阳区太阳宫')";
                ifxcmd.ExecuteNonQuery();

                ifxcmd.CommandText = "update company set coaddr = '天津市普天创新园' where coid = 1";
                ifxcmd.ExecuteNonQuery();

                ifxcmd.CommandText = "select dbinfo('version','full') from dual";
                IfxDataReader dr = ifxcmd.ExecuteReader();
                if (dr.Read())
                {
                    this.label1.Text = "数据库版本号为： " + dr[0];
                }
            }
        }
    

        private void btnSelect_Click(object sender, EventArgs e)
        {
            IfxDataAdapter ifxadpt = new IfxDataAdapter("select * from company", ifxconn);
            ds = new DataSet();
            ifxadpt.Fill(ds);
            this.dataGridView1.DataSource = ds.Tables[0];
            MessageBox.Show("DotNet 方式操作数据库成功！ \n");
        }
    }
}
