package main

import (
        "fmt"
        "database/sql"
        _ "odbc/driver"
)

func main() {
        fmt.Printf("GO ODBC测试程序开始运行.\n\n");
        db, err := sql.Open("odbc", "DSN=utf8;UID=gbasedbt;PWD=GBase123")
        if err != nil {
                panic(err)
        }
        defer db.Close()

        rows, err := db.Query("SELECT tabid,tabname FROM systables where tabid < 10")
        checkErr(err)

        for rows.Next() {
               var tabid int
               var tabname string
               err = rows.Scan(&tabid, &tabname)
               checkErr(err)
               fmt.Printf("%d\t%s\n", tabid, tabname)
        }
        rows.Close()

        fmt.Printf("\nGO ODBC测试程序结束运行.\n");
}

func checkErr(err error) {
        if err != nil {
               panic(err)
        }
}
