/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.asf;

import com.gbasedbt.lang.IntervalDF;
import com.gbasedbt.lang.IntervalYM;
import com.gbasedbt.lang.JavaToIfxType;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;

public class IfxDataOutputStream
extends FilterOutputStream {
    protected int written = 0;
    private int byteCountAtEOT;
    private OutputStream os;
    private boolean usestrenc = false;
    static final int one = 1;
    private JavaToIfxType javatoifx = new JavaToIfxType();

    public IfxDataOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.os = outputStream;
    }

    public IfxDataOutputStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        this.os = outputStream;
        this.usestrenc = bl;
    }

    @Override
    public void write(int n2) throws IOException {
        this.os.write(n2);
        ++this.written;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.os.write(byArray, n2, n3);
        this.written += n3;
    }

    public void writeWithoutTrace(byte[] byArray, int n2, int n3) throws IOException {
        this.os.write(byArray, n2, n3);
        this.written += n3;
    }

    public void writePadded(byte[] byArray, int n2, int n3) throws IOException {
        this.os.write(byArray, n2, n3);
        this.written += n3;
        if ((n3 & 1) >= 1) {
            this.write(0);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void writeWithMangledTrace(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void writePadded(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeInt(int n2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxInt(n2);
        this.write(byArray);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    public void writeByte(int n2) throws IOException {
        this.write(n2);
    }

    public void writeBytes(byte[] byArray) throws IOException {
        this.write(byArray, 2, byArray.length - 2);
    }

    public void writeBytesConstant(String string) throws IOException, SQLException {
        byte[] byArray = this.javatoifx.JavaToIfxChar(string, this.usestrenc);
        this.write(byArray, 2, byArray.length - 2);
    }

    public byte[] getJavaToIfxChar(String string, String string2) throws IOException, SQLException {
        return this.javatoifx.JavaToIfxChar(string, string2, this.usestrenc);
    }

    public byte[] getJavaToIfxChar(String string) throws IOException, SQLException {
        return this.javatoifx.JavaToIfxChar(string, this.usestrenc);
    }

    public byte[] getJavaToIfx4BytesChar(String string) throws IOException, SQLException {
        return this.javatoifx.JavaToIfx4BytesChar(string, this.usestrenc);
    }

    public byte[] getJavaToIfx4BytesChar(String string, String string2) throws IOException, SQLException {
        return this.javatoifx.JavaToIfx4BytesChar(string, string2, this.usestrenc);
    }

    public void writeChar(byte[] byArray) throws IOException {
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeDate(Date date) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDate(date);
        this.write(byArray);
    }

    public void writeDateTime(Timestamp timestamp) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDateTime(timestamp);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeInterval(IntervalDF intervalDF) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxInterval(intervalDF);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeInterval(IntervalYM intervalYM) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxInterval(intervalYM);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeDecimal(BigDecimal bigDecimal) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDecimal(bigDecimal);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeDouble(double d2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxDouble(d2);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeReal(float f2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxReal(f2);
        this.write(byArray);
        if ((byArray.length & 1) >= 1) {
            this.write(0);
        }
    }

    public void writeSmallInt(short s2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxSmallInt(s2);
        this.write(byArray);
    }

    public void writeShort(int n2) throws IOException {
        short s2 = (short)n2;
        this.writeSmallInt(s2);
    }

    public void writeShort(short s2) throws IOException {
        this.writeSmallInt(s2);
    }

    public void writeLongInt(long l2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxLongInt(l2);
        this.write(byArray);
    }

    public void writeLongBigint(long l2) throws IOException {
        byte[] byArray = JavaToIfxType.JavaToIfxLongBigInt(l2);
        this.write(byArray);
    }

    public void writeLong(long l2) throws IOException {
        this.writeLongInt(l2);
    }

    public void setByteCntAtEOT() {
        this.byteCountAtEOT = this.written;
    }

    public int getBytesSentSinceLastEOT() {
        return this.written - this.byteCountAtEOT;
    }

    protected void clearTrace() {
    }
}

