/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.jdbc.IfxUDT;
import com.gbasedbt.jdbc.IfxUDTInput;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.BasicBSONObject;

public class IfxBSONObject
extends IfxUDT
implements SQLData,
BSONObject {
    protected byte[] bsonObjectBytes;
    protected BSONObject bsonObject;
    protected int bsonObjectHashCode;

    public IfxBSONObject() {
        this.bsonObjectBytes = null;
        this.bsonObject = null;
        this.bsonObjectHashCode = 0;
        this.a(26);
        this.bsonObjectBytes = null;
        this.bsonObject = null;
        this.bsonObjectHashCode = 0;
    }

    public IfxBSONObject(byte[] byArray) {
        this(byArray, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IfxBSONObject(byte[] byArray, boolean bl) {
        block4: {
            block3: {
                this.bsonObjectBytes = null;
                this.bsonObject = null;
                this.bsonObjectHashCode = 0;
                this.a(26);
                if (!bl) break block3;
                this.bsonObjectBytes = new byte[byArray.length];
                System.arraycopy(byArray, 0, this.bsonObjectBytes, 0, byArray.length);
                if (!IfxSqliConnect.b4) break block4;
            }
            this.bsonObjectBytes = byArray;
        }
        this.bsonObject = null;
        this.bsonObjectHashCode = 0;
    }

    public IfxBSONObject(BSONObject bSONObject) {
        this.bsonObjectBytes = null;
        this.bsonObject = null;
        this.bsonObjectHashCode = 0;
        this.a(26);
        this.bsonObject = bSONObject;
        this.bsonObjectHashCode = this.bsonObject.hashCode();
        this.bsonObjectBytes = null;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return "bson";
    }

    @Override
    public void readSQL(SQLInput sQLInput, String string) throws SQLException {
        this.unsafeSetBSONObject(null);
        IfxUDTInput ifxUDTInput = (IfxUDTInput)sQLInput;
        this.bsonObjectBytes = ifxUDTInput.readBytes(ifxUDTInput.length());
    }

    @Override
    public void writeSQL(SQLOutput sQLOutput) throws SQLException {
        this.ensureBsonObjectBytes();
        if (this.bsonObjectBytes == null) {
            throw new NullPointerException("the BSON byte array must not be null");
        }
        sQLOutput.writeBytes(this.bsonObjectBytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ensureBsonObjectBytes() {
        if (this.bsonObjectBytes == null) {
            if (this.bsonObject == null) {
                this.unsafeSetBSONObject(new BasicBSONObject());
            }
            this.bsonObjectBytes = new BasicBSONEncoder().encode(this.bsonObject);
            if (!IfxSqliConnect.b4) return;
        }
        if (this.bsonObject == null) return;
        if (this.bsonObjectHashCode == this.bsonObject.hashCode()) return;
        this.bsonObjectBytes = new BasicBSONEncoder().encode(this.bsonObject);
        this.bsonObjectHashCode = this.bsonObject.hashCode();
    }

    protected void ensureBsonObject() {
        block6: {
            block7: {
                if (this.bsonObject != null) break block6;
                if (this.bsonObjectBytes == null) break block7;
                this.unsafeSetBSONObject(new BasicBSONDecoder().readObject(this.bsonObjectBytes));
                if (!IfxSqliConnect.b4) break block6;
            }
            this.unsafeSetBSONObject(new BasicBSONObject());
        }
    }

    public byte[] getBytes() {
        this.ensureBsonObjectBytes();
        return this.bsonObjectBytes;
    }

    public void setBytes(byte[] byArray) {
        this.unsafeSetBSONObject(null);
        this.bsonObjectBytes = byArray;
    }

    public void setBSONObject(BSONObject bSONObject) {
        if (bSONObject == null) {
            throw new NullPointerException("The bsonObject must not be null");
        }
        this.unsafeSetBSONObject(bSONObject);
        this.bsonObjectBytes = null;
    }

    protected void unsafeSetBSONObject(BSONObject bSONObject) {
        block5: {
            block4: {
                this.bsonObject = bSONObject;
                if (bSONObject != null) break block4;
                this.bsonObjectHashCode = 0;
                if (!IfxSqliConnect.b4) break block5;
            }
            this.bsonObjectHashCode = bSONObject.hashCode();
        }
    }

    public static IfxBSONObject ensureIfxBSONObject(Object object) {
        if (object == null) {
            throw new NullPointerException("The object must not be null");
        }
        if (object instanceof IfxBSONObject) {
            return (IfxBSONObject)object;
        }
        if (object instanceof BSONObject) {
            return new IfxBSONObject((BSONObject)object);
        }
        throw new IllegalArgumentException(MessageFormat.format("The specified object is not of type {0} and does not implement the interface {1}", IfxBSONObject.class.getSimpleName(), BSONObject.class.getSimpleName()));
    }

    @Override
    public String toString() {
        this.ensureBsonObject();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(IfxBSONObject.class.getSimpleName());
        stringBuilder.append(" ");
        stringBuilder.append(this.bsonObject.toString());
        return stringBuilder.toString();
    }

    @Override
    public Object put(String string, Object object) {
        this.ensureBsonObject();
        this.bsonObjectBytes = null;
        return this.bsonObject.put(string, object);
    }

    @Override
    public void putAll(BSONObject bSONObject) {
        this.ensureBsonObject();
        this.bsonObjectBytes = null;
        this.bsonObject.putAll(bSONObject);
    }

    @Override
    public void putAll(Map<String, Object> map) {
        this.ensureBsonObject();
        this.bsonObjectBytes = null;
        this.bsonObject.putAll(map);
    }

    @Override
    public Object get(String string) {
        this.ensureBsonObject();
        return this.bsonObject.get(string);
    }

    @Override
    public Map<String, Object> toMap() {
        this.ensureBsonObject();
        return this.bsonObject.toMap();
    }

    @Override
    public Object removeField(String string) {
        this.ensureBsonObject();
        this.bsonObjectBytes = null;
        return this.bsonObject.removeField(string);
    }

    @Override
    @Deprecated
    public boolean containsKey(String string) {
        this.ensureBsonObject();
        return this.bsonObject.containsKey(string);
    }

    @Override
    public boolean containsField(String string) {
        this.ensureBsonObject();
        return this.bsonObject.containsField(string);
    }

    @Override
    public Set<String> keySet() {
        this.ensureBsonObject();
        return this.bsonObject.keySet();
    }

    public int hashCode() {
        if (this.bsonObject != null) {
            return this.bsonObject.hashCode();
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof BSONObject) {
            this.ensureBsonObject();
            return this.bsonObject.equals(object);
        }
        return false;
    }
}

