/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.BasicBSONList;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public class BasicBSONCallback
implements BSONCallback {
    private Object a;
    private final LinkedList<BSONObject> b = new LinkedList();
    private final LinkedList<String> c = new LinkedList();

    public BasicBSONCallback() {
        this.reset();
    }

    public BSONObject create() {
        return new BasicBSONObject();
    }

    protected BSONObject createList() {
        return new BasicBSONList();
    }

    @Override
    public BSONCallback createBSONCallback() {
        return new BasicBSONCallback();
    }

    public BSONObject create(boolean bl, List<String> list) {
        if (bl) {
            return this.createList();
        }
        return this.create();
    }

    @Override
    public void objectStart() {
        if (this.b.size() > 0) {
            throw new IllegalStateException("something is wrong");
        }
        this.objectStart(false);
    }

    @Override
    public void objectStart(boolean bl) {
        this.a = this.create(bl, null);
        this.b.add((BSONObject)this.a);
    }

    @Override
    public void objectStart(String string) {
        this.objectStart(false, string);
    }

    public void objectStart(boolean bl, String string) {
        this.c.addLast(string);
        BSONObject bSONObject = this.create(bl, this.c);
        this.b.getLast().put(string, bSONObject);
        this.b.addLast(bSONObject);
    }

    @Override
    public Object objectDone() {
        BSONObject bSONObject;
        block9: {
            block8: {
                bSONObject = this.b.removeLast();
                if (this.c.size() <= 0) break block8;
                this.c.removeLast();
                if (BasicBSONObject.b == 0) break block9;
            }
            if (this.b.size() <= 0) break block9;
            throw new IllegalStateException("something is wrong");
        }
        BSONObject bSONObject2 = !BSON.hasDecodeHooks() ? bSONObject : (BSONObject)BSON.applyDecodingHooks(bSONObject);
        return bSONObject2;
    }

    @Override
    public void arrayStart() {
        this.objectStart(true);
    }

    @Override
    public void arrayStart(String string) {
        this.objectStart(true, string);
    }

    @Override
    public Object arrayDone() {
        return this.objectDone();
    }

    @Override
    public void gotNull(String string) {
        this.cur().put(string, null);
    }

    @Override
    public void gotUndefined(String string) {
    }

    @Override
    public void gotMinKey(String string) {
        this.cur().put(string, new MinKey());
    }

    @Override
    public void gotMaxKey(String string) {
        this.cur().put(string, new MaxKey());
    }

    @Override
    public void gotBoolean(String string, boolean bl) {
        this._put(string, bl);
    }

    @Override
    public void gotDouble(String string, double d2) {
        this._put(string, d2);
    }

    @Override
    public void gotInt(String string, int n2) {
        this._put(string, n2);
    }

    @Override
    public void gotLong(String string, long l2) {
        this._put(string, l2);
    }

    @Override
    public void gotDate(String string, long l2) {
        this._put(string, new Date(l2));
    }

    @Override
    public void gotRegex(String string, String string2, String string3) {
        this._put(string, Pattern.compile(string2, BSON.regexFlags(string3)));
    }

    @Override
    public void gotString(String string, String string2) {
        this._put(string, string2);
    }

    @Override
    public void gotSymbol(String string, String string2) {
        this._put(string, string2);
    }

    @Override
    public void gotTimestamp(String string, int n2, int n3) {
        this._put(string, new BSONTimestamp(n2, n3));
    }

    @Override
    public void gotObjectId(String string, ObjectId objectId) {
        this._put(string, objectId);
    }

    @Override
    public void gotDBRef(String string, String string2, ObjectId objectId) {
        this._put(string, new BasicBSONObject("$ns", string2).append("$id", objectId));
    }

    @Override
    @Deprecated
    public void gotBinaryArray(String string, byte[] byArray) {
        this.gotBinary(string, (byte)0, byArray);
    }

    @Override
    public void gotBinary(String string, byte by, byte[] byArray) {
        block7: {
            block6: {
                if (by != 0 && by != 2) break block6;
                this._put(string, byArray);
                if (BasicBSONObject.b == 0) break block7;
            }
            this._put(string, new Binary(by, byArray));
        }
    }

    @Override
    public void gotUUID(String string, long l2, long l3) {
        this._put(string, new UUID(l2, l3));
    }

    @Override
    public void gotCode(String string, String string2) {
        this._put(string, new Code(string2));
    }

    @Override
    public void gotCodeWScope(String string, String string2, Object object) {
        this._put(string, new CodeWScope(string2, (BSONObject)object));
    }

    protected void _put(String string, Object object) {
        BSONObject bSONObject = this.cur();
        String string2 = string;
        Object object2 = !BSON.hasDecodeHooks() ? object : BSON.applyDecodingHooks(object);
        bSONObject.put(string2, object2);
    }

    protected BSONObject cur() {
        return this.b.getLast();
    }

    protected String curName() {
        String string = !this.c.isEmpty() ? this.c.getLast() : null;
        return string;
    }

    @Override
    public Object get() {
        return this.a;
    }

    protected void setRoot(Object object) {
        this.a = object;
    }

    protected boolean isStackEmpty() {
        boolean bl = this.b.size() < 1;
        return bl;
    }

    @Override
    public void reset() {
        this.a = null;
        this.b.clear();
        this.c.clear();
    }
}

