/*
 * Decompiled with CFR 0.152.
 */
package sqlj.framework;

import java.util.Hashtable;
import sqlj.framework.BaseJSClass;
import sqlj.framework.JSClass;

public interface ClassResolver {
    public static final ClassResolver SYSTEM_CLASSES = new SystemClassResolver();

    public BaseJSClass getClass(String var1) throws ClassNotFoundException;

    public BaseJSClass getQualifiedClass(String var1);

    public void addClass(BaseJSClass var1);

    public boolean isLoadedClass(String var1);

    public static class SystemClassResolver
    implements ClassResolver {
        private Hashtable m_classes = new Hashtable();

        SystemClassResolver() {
        }

        @Override
        public BaseJSClass getClass(String string) throws ClassNotFoundException {
            BaseJSClass baseJSClass = this.getQualifiedClass(string);
            if (baseJSClass == null) {
                throw new ClassNotFoundException(string);
            }
            return baseJSClass;
        }

        @Override
        public BaseJSClass getQualifiedClass(String string) {
            JSClass.loadSystemClasses();
            return (BaseJSClass)this.m_classes.get(string);
        }

        @Override
        public void addClass(BaseJSClass baseJSClass) {
            JSClass.loadSystemClasses();
            BaseJSClass baseJSClass2 = this.m_classes.put(baseJSClass.getName(), baseJSClass);
            if (baseJSClass2 != null && baseJSClass2 != baseJSClass) {
                throw new ClassCircularityError("class already exists with name " + baseJSClass.getName());
            }
        }

        @Override
        public boolean isLoadedClass(String string) {
            return this.m_classes.containsKey(string);
        }
    }
}

