/*
 * Decompiled with CFR 0.152.
 */
package sqlj.framework.options;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.Info;
import sqlj.framework.error.Warning;
import sqlj.framework.ide.TranslationOptionsQuery;
import sqlj.mesg.SemanticErrors;
import sqlj.mesg.SemanticOptions;

public class ConnectionFactory {
    public static final String URL_OPTION = "url";
    public static final String USER_OPTION = "user";
    public static final String DRIVER_OPTION = "driver";
    public static final String PASSWORD_OPTION = "password";
    public static final String URL_PREFIX_OPTION = "default-url-prefix";
    public static final String URL_DEFAULT = ConnectionFactory.getDefaultValue("url");
    public static final String USER_DEFAULT = ConnectionFactory.getDefaultValue("user");
    public static final String DRIVER_DEFAULT = ConnectionFactory.getDefaultValue("driver");
    public static final String PASSWORD_DEFAULT = ConnectionFactory.getDefaultValue("password");
    public static final String URL_PREFIX_DEFAULT = ConnectionFactory.getDefaultValue("default-url-prefix");
    public static final String EMPTY_PASSWORD = "EMPTY.PASSWORD";
    public static final String URL_CONNECT = "URL.CONNECT";
    public static final String JDBC_URL_PREFIX = "jdbc:";
    public static final String PASSWORD_SEPARATOR = "/";
    public static final String URL_SEPARATOR = "@";
    private static final TranslationOptionsQuery DEFAULT_OPTIONS_QUERY = new GetPassword();
    private TranslationOptionsQuery m_queryPassword = DEFAULT_OPTIONS_QUERY;
    private String m_user = USER_DEFAULT;
    private String m_url = URL_DEFAULT;
    private String m_urlPrefix = URL_PREFIX_DEFAULT;
    private String m_password = PASSWORD_DEFAULT;
    private Vector m_drivers = new Vector();
    private boolean m_driversRegistered = false;
    private boolean m_isVerbose = false;

    private static String getDefaultValue(String string) {
        return SemanticOptions.getOptionInfo(string)[2];
    }

    public void setOptionsQuery(TranslationOptionsQuery translationOptionsQuery) {
        if (translationOptionsQuery == null) {
            translationOptionsQuery = DEFAULT_OPTIONS_QUERY;
        }
        this.m_queryPassword = translationOptionsQuery;
    }

    public TranslationOptionsQuery getOptionsQuery() {
        return this.m_queryPassword;
    }

    public void setUser(String string) {
        if (string != null) {
            int n2 = string.indexOf(PASSWORD_SEPARATOR);
            if (n2 != -1) {
                String string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
                int n3 = string2.indexOf(URL_SEPARATOR);
                if (n3 != -1) {
                    String string3 = string2.substring(n3 + 1);
                    string2 = string2.substring(0, n3);
                    this.setURL(string3);
                }
                this.setPassword(string2);
            } else {
                int n4 = string.indexOf(URL_SEPARATOR);
                if (n4 != -1) {
                    String string4 = string.substring(n4 + 1);
                    string = string.substring(0, n4);
                    this.setURL(string4);
                }
            }
        }
        this.m_user = string;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setURL(String string) {
        this.m_url = string;
    }

    public String getURL() {
        return this.m_url;
    }

    public String getFullURL() {
        String string = this.getURL();
        if (string != null && !string.equals("") && !string.startsWith(JDBC_URL_PREFIX)) {
            string = this.getURLPrefix() + string;
        }
        return string;
    }

    public void setURLPrefix(String string) {
        if (string == null) {
            string = "";
        }
        this.m_urlPrefix = string;
    }

    public String getURLPrefix() {
        return this.m_urlPrefix;
    }

    public void setPassword(String string) {
        this.m_password = string;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setDrivers(Enumeration enumeration) {
        this.m_driversRegistered = false;
        this.m_drivers.removeAllElements();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                this.m_drivers.addElement(e2);
            }
        }
    }

    public Enumeration getDrivers() {
        return this.m_drivers.elements();
    }

    public void resetConnectData() {
        this.setUser(null);
        this.setPassword(null);
        this.setURL(null);
    }

    public void setVerbose(boolean bl) {
        this.m_isVerbose = bl;
    }

    public boolean isVerbose() {
        return this.m_isVerbose;
    }

    public String toString() {
        return this.getUser() + URL_SEPARATOR + this.getFullURL();
    }

    public Connection getConnection(ErrorLog errorLog) throws SQLException {
        String string = this.getUser();
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = this.getFullURL();
        String string3 = this.getPassword();
        if (!string.equals(URL_CONNECT)) {
            if ((string3 == null || string3.equals("")) && !string.equals(URL_CONNECT)) {
                string3 = this.m_queryPassword.getPassword(string, string2);
            }
            if (EMPTY_PASSWORD.equals(string3)) {
                string3 = "";
            }
        }
        this.registerJDBCDrivers(errorLog);
        Connection connection = string.equals(URL_CONNECT) ? DriverManager.getConnection(string2) : DriverManager.getConnection(string2, string, string3);
        if (this.isVerbose()) {
            errorLog.addEntry(new Info(SemanticErrors.connectingTo(string, string2)));
        }
        return connection;
    }

    private void registerJDBCDrivers(ErrorLog errorLog) {
        if (this.m_driversRegistered) {
            return;
        }
        this.m_driversRegistered = true;
        Enumeration enumeration = this.getDrivers();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                Driver driver = (Driver)Class.forName(string).newInstance();
                DriverManager.registerDriver(driver);
                if (this.isVerbose()) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(string);
                }
                ++n2;
            }
            catch (Exception exception) {
                errorLog.addEntry(new Warning(SemanticErrors.cannotLoadJDBCDriver(string)));
            }
        }
        if (this.isVerbose()) {
            errorLog.addEntry(new Info(SemanticErrors.registeredJDBCDrivers(stringBuffer.toString())));
        }
    }

    public static class GetPassword
    implements TranslationOptionsQuery {
        @Override
        public String getPassword(String string, String string2) {
            String string3 = null;
            System.out.print(SemanticErrors.promptForPassword(string, string2));
            System.out.println("");
            System.out.println("passwd request from subprocess");
            System.out.flush();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            try {
                string3 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                return null;
            }
            return string3;
        }

        @Override
        public String getURL(String string) {
            return null;
        }
    }
}

