/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import java.io.IOException;
import sqlj.framework.BaseJSClass;
import sqlj.framework.JSClass;
import sqlj.framework.JSField;
import sqlj.framework.JSMethod;
import sqlj.javac.ArgumentListNode;
import sqlj.javac.ErrorConstants;
import sqlj.javac.ErrorDescriptor;
import sqlj.javac.JavaParserImpl;
import sqlj.javac.LinefeedFilter;
import sqlj.javac.NameNode;
import sqlj.javac.Node;
import sqlj.mesg.JavacErrors;
import sqlj.util.ArrayAccessDescriptor;
import sqlj.util.ClassDescriptor;
import sqlj.util.ClassNameResolver;
import sqlj.util.ExpressionDescriptor;
import sqlj.util.ExpressionMetaData;
import sqlj.util.FieldAccessDescriptor;
import sqlj.util.LValueDescriptor;
import sqlj.util.OutputContext;
import sqlj.util.Parselet;
import sqlj.util.TypeDescriptor;

public abstract class ExpressionNode
implements Parselet,
ErrorConstants,
ExpressionMetaData {
    private JavaParserImpl javaParser = null;
    private Parselet scope = null;
    private Object info = null;
    private TypeDescriptor desc = null;
    private Node javaScope = null;
    private static final boolean debug = false;
    private JSClass caller = null;

    ExpressionNode(JavaParserImpl javaParserImpl) {
        this.javaParser = javaParserImpl;
    }

    @Override
    public final void setScope(Parselet parselet) {
        if (this.scope != parselet) {
            this.scope = parselet;
            this.scopeChanged();
        }
    }

    @Override
    public final Parselet getScope() {
        return this.scope;
    }

    @Override
    public final Parselet getEnclosingClass() {
        return this.getJavaScope().getEnclosingClass();
    }

    @Override
    public final Parselet getDefiningUnit() {
        return this.getJavaScope().getDefiningUnit();
    }

    @Override
    public final void setInfo(Object object) {
        this.info = object;
    }

    @Override
    public final Object getInfo() {
        return this.info;
    }

    @Override
    public final TypeDescriptor getDescriptor() {
        if (this.desc == null) {
            try {
                BaseJSClass baseJSClass = this.getType().getBaseJSClass();
                NameNode nameNode = this.getNameNode();
                ExpressionNode expressionNode = this.getBaseObject();
                this.desc = nameNode == null ? (expressionNode == null ? new ExpressionDescriptor(this, baseJSClass) : new ArrayAccessDescriptor(this, baseJSClass, expressionNode, this.getArrayIndex())) : (expressionNode == null ? new LValueDescriptor(this, baseJSClass, nameNode.getText()) : new FieldAccessDescriptor(this, baseJSClass, nameNode.getText(), expressionNode));
            }
            catch (NullPointerException nullPointerException) {
                return new ErrorDescriptor(JavacErrors.get(45));
            }
        }
        return this.desc;
    }

    @Override
    public final ClassNameResolver getClassResolver() {
        return this.getJavaScope().getClassResolver();
    }

    @Override
    public final boolean generate(OutputContext outputContext) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        LinefeedFilter linefeedFilter = new LinefeedFilter(outputContext.getWriter());
        this.getTextTo(stringBuffer);
        linefeedFilter.write(stringBuffer.toString());
        return true;
    }

    abstract void scopeChanged();

    protected final Node getJavaScope() {
        if (this.javaScope == null) {
            Parselet parselet = this;
            while (!((parselet = parselet.getScope()) instanceof Node)) {
            }
            this.javaScope = (Node)parselet;
        }
        return this.javaScope;
    }

    abstract JSClass getType();

    NameNode getNameNode() {
        return null;
    }

    ExpressionNode getBaseObject() {
        return null;
    }

    ExpressionNode getArrayIndex() {
        return null;
    }

    abstract int getRow();

    abstract int getColumn();

    final void Error(String string) {
        this.Error(string, this.getRow(), this.getColumn());
    }

    final void Error(int n2) {
        this.Error(JavacErrors.get(n2));
    }

    final void Error(String string, int n2, int n3) {
        if (this.javaParser != null) {
            this.javaParser.Error(string, n2, n3);
        }
    }

    final void Error(int n2, int n3, int n4) {
        this.Error(JavacErrors.get(n2), n3, n4);
    }

    final void Error(int n2, String string) {
        this.Error(JavacErrors.get(n2, string));
    }

    public abstract void getTextTo(StringBuffer var1);

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public final boolean isAssignable() {
        boolean bl = this.isLeftHandSide() && !this.isFinal();
        return bl;
    }

    @Override
    public boolean isConstant() {
        return this.isFinal();
    }

    boolean isLeftHandSide() {
        return false;
    }

    boolean isFinal() {
        return false;
    }

    JSField getField(String string) throws ClassNotFoundException {
        JSField jSField = null;
        JSField[] jSFieldArray = this.getType().resolveField(string, this.getCaller());
        if (jSFieldArray.length == 1) {
            jSField = jSFieldArray[0];
        } else if (jSFieldArray.length > 1) {
            this.Error(12);
        }
        return jSField;
    }

    JSClass lookupField(String string) {
        JSClass jSClass = null;
        try {
            JSField jSField = this.getField(string);
            if (jSField != null && (jSClass = jSField.getType()) == null) {
                this.Error(25);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return jSClass;
    }

    JSClass lookupMethod(ArgumentListNode argumentListNode) {
        JSClass jSClass = null;
        JSClass jSClass2 = this.getBaseType();
        NameNode nameNode = this.getNameNode();
        if (jSClass2 != null && nameNode != null) {
            String string = nameNode.getSimpleName();
            if (string != null) {
                try {
                    JSMethod[] jSMethodArray = jSClass2.resolveMethod(string, argumentListNode.getTypeList(), this.getCaller());
                    if (jSMethodArray.length < 1) {
                        this.Error(30);
                    } else if (jSMethodArray.length > 1) {
                        this.Error(13);
                    } else {
                        jSClass = jSMethodArray[0].getReturnType();
                        if (jSClass == null) {
                            this.Error(29);
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.Error(36, string);
                }
            } else {
                this.Error(36, this.getSimpleName());
            }
        } else {
            this.Error(37);
        }
        return jSClass;
    }

    String getSimpleName() {
        return this.getNameNode().getText();
    }

    final JSClass getCaller() throws ClassNotFoundException {
        if (this.caller == null) {
            try {
                ClassDescriptor classDescriptor = (ClassDescriptor)this.getScope().getEnclosingClass().getDescriptor();
                this.caller = classDescriptor.getReflection();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.Error(39);
                throw classNotFoundException;
            }
        }
        return this.caller;
    }

    JSClass getBaseType() {
        ExpressionNode expressionNode = this.getBaseObject();
        return expressionNode == null ? null : expressionNode.getType();
    }

    final boolean isBooleanType() {
        return this.getType() == JSClass.boolean_TYPE;
    }

    final boolean isIntegralType() {
        return this.getType().isIntegralType();
    }

    final boolean isFloatingPointType() {
        return this.getType().isFloatingPointType();
    }

    final boolean isNumericType() {
        return this.getType().isNumericType();
    }

    final boolean isPrimitiveType() {
        return this.isNumericType() || this.isBooleanType();
    }
}

