/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.SQLNullException;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.ref.RTStatementJDBCBase;

public class RTResultSetJDBC
implements RTResultSet {
    protected ResultSet rs;
    private boolean m_isClosed = false;
    private boolean m_isValidRow = false;
    private RTStatementJDBCBase m_parent = null;

    public RTResultSetJDBC(ResultSet resultSet) {
        this.rs = resultSet;
    }

    RTResultSetJDBC(ResultSet resultSet, RTStatementJDBCBase rTStatementJDBCBase) {
        this.rs = resultSet;
        this.m_parent = rTStatementJDBCBase;
    }

    @Override
    public ResultSet getJDBCResultSet() {
        return this.rs;
    }

    @Override
    public boolean next() throws SQLException {
        this.m_isValidRow = this.rs.next();
        return this.m_isValidRow;
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.rs.findColumn(string);
    }

    @Override
    public String getString(int n2) throws SQLException {
        return this.rs.getString(n2);
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        return this.rs.getBytes(n2);
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        return this.rs.getDate(n2);
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        return this.rs.getTime(n2);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.rs.getTimestamp(n2);
    }

    @Override
    public boolean getBooleanNoNull(int n2) throws SQLException {
        boolean bl = this.rs.getBoolean(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return bl;
    }

    @Override
    public byte getByteNoNull(int n2) throws SQLException {
        byte by = this.rs.getByte(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return by;
    }

    @Override
    public short getShortNoNull(int n2) throws SQLException {
        short s2 = this.rs.getShort(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return s2;
    }

    @Override
    public int getIntNoNull(int n2) throws SQLException {
        int n3 = this.rs.getInt(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return n3;
    }

    @Override
    public long getLongNoNull(int n2) throws SQLException {
        long l2 = this.rs.getLong(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return l2;
    }

    @Override
    public float getFloatNoNull(int n2) throws SQLException {
        float f2 = this.rs.getFloat(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return f2;
    }

    @Override
    public double getDoubleNoNull(int n2) throws SQLException {
        double d2 = this.rs.getDouble(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return d2;
    }

    @Override
    public Boolean getBooleanWrapper(int n2) throws SQLException {
        boolean bl = this.rs.getBoolean(n2);
        return this.rs.wasNull() ? null : new Boolean(bl);
    }

    @Override
    public Byte getByteWrapper(int n2) throws SQLException {
        byte by = this.rs.getByte(n2);
        return this.rs.wasNull() ? null : new Byte(by);
    }

    @Override
    public Short getShortWrapper(int n2) throws SQLException {
        short s2 = this.rs.getShort(n2);
        return this.rs.wasNull() ? null : new Short(s2);
    }

    @Override
    public Integer getIntWrapper(int n2) throws SQLException {
        int n3 = this.rs.getInt(n2);
        return this.rs.wasNull() ? null : new Integer(n3);
    }

    @Override
    public Long getLongWrapper(int n2) throws SQLException {
        long l2 = this.rs.getLong(n2);
        return this.rs.wasNull() ? null : new Long(l2);
    }

    @Override
    public Float getFloatWrapper(int n2) throws SQLException {
        float f2 = this.rs.getFloat(n2);
        return this.rs.wasNull() ? null : new Float(f2);
    }

    @Override
    public Double getDoubleWrapper(int n2) throws SQLException {
        double d2 = this.rs.getDouble(n2);
        return this.rs.wasNull() ? null : new Double(d2);
    }

    @Override
    public AsciiStream getAsciiStreamWrapper(int n2) throws SQLException {
        InputStream inputStream = this.rs.getAsciiStream(n2);
        return inputStream == null || this.rs.wasNull() ? null : new AsciiStream(inputStream);
    }

    @Override
    public BinaryStream getBinaryStreamWrapper(int n2) throws SQLException {
        InputStream inputStream = this.rs.getBinaryStream(n2);
        return inputStream == null || this.rs.wasNull() ? null : new BinaryStream(inputStream);
    }

    @Override
    public UnicodeStream getUnicodeStreamWrapper(int n2) throws SQLException {
        InputStream inputStream = this.rs.getBinaryStream(n2);
        return inputStream == null || this.rs.wasNull() ? null : new UnicodeStream(inputStream);
    }

    @Override
    public Object getObject(int n2, Class clazz) throws SQLException {
        Object object = this.rs.getObject(n2);
        if (object == null) {
            return object;
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            ProfileRefErrors.raise_INCOMPATIBLE_TYPE(clazz, object.getClass());
        }
        return object;
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return (BigDecimal)this.getObject(n2, BigDecimal.class);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.rs.getMetaData().getColumnCount();
    }

    @Override
    public boolean isValidRow() throws SQLException {
        return this.m_isValidRow;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_isClosed;
    }

    @Override
    public void close() throws SQLException {
        if (!this.m_isClosed) {
            try {
                this.m_isClosed = true;
                this.rs.close();
            }
            finally {
                if (this.m_parent != null) {
                    this.m_parent.notifyClosed(this);
                }
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.rs.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.rs.clearWarnings();
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            if (!this.m_isClosed) {
                this.close();
            }
        }
    }
}

