/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.ref.RTResultSetJDBC;

public class RTStatementJDBCBase {
    protected PreparedStatement preparedStmt;
    private boolean m_executeComplete = false;
    private RTResultSetJDBC m_openResultSet = null;
    private boolean m_isClosed = false;

    public RTStatementJDBCBase(PreparedStatement preparedStatement) {
        this.preparedStmt = preparedStatement;
    }

    public PreparedStatement getJDBCPreparedStatement() {
        return this.preparedStmt;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.preparedStmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int n2) throws SQLException {
        this.preparedStmt.setMaxFieldSize(n2);
    }

    public int getMaxRows() throws SQLException {
        return this.preparedStmt.getMaxRows();
    }

    public void setMaxRows(int n2) throws SQLException {
        this.preparedStmt.setMaxRows(n2);
    }

    public int getQueryTimeout() throws SQLException {
        return this.preparedStmt.getQueryTimeout();
    }

    public void setQueryTimeout(int n2) throws SQLException {
        this.preparedStmt.setQueryTimeout(n2);
    }

    public void cancel() throws SQLException {
        this.preparedStmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.preparedStmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.preparedStmt.clearWarnings();
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.m_openResultSet != null) {
            this.m_openResultSet.close();
            this.m_openResultSet = null;
        }
        return this.preparedStmt.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.preparedStmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.preparedStmt.getMoreResults();
    }

    public RTResultSet executeRTQuery() throws SQLException {
        RTResultSetJDBC rTResultSetJDBC;
        this.m_openResultSet = rTResultSetJDBC = new RTResultSetJDBC(this.preparedStmt.executeQuery(), this);
        return rTResultSetJDBC;
    }

    public int executeUpdate() throws SQLException {
        return this.preparedStmt.executeUpdate();
    }

    public void setBoolean(int n2, boolean bl) throws SQLException {
        this.preparedStmt.setBoolean(n2, bl);
    }

    public void setByte(int n2, byte by) throws SQLException {
        this.preparedStmt.setByte(n2, by);
    }

    public void setShort(int n2, short s2) throws SQLException {
        this.preparedStmt.setShort(n2, s2);
    }

    public void setInt(int n2, int n3) throws SQLException {
        this.preparedStmt.setInt(n2, n3);
    }

    public void setLong(int n2, long l2) throws SQLException {
        this.preparedStmt.setLong(n2, l2);
    }

    public void setFloat(int n2, float f2) throws SQLException {
        this.preparedStmt.setFloat(n2, f2);
    }

    public void setDouble(int n2, double d2) throws SQLException {
        this.preparedStmt.setDouble(n2, d2);
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.preparedStmt.setBigDecimal(n2, bigDecimal);
    }

    public void setString(int n2, String string) throws SQLException {
        this.preparedStmt.setString(n2, string);
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        this.preparedStmt.setBytes(n2, byArray);
    }

    public void setDate(int n2, Date date) throws SQLException {
        this.preparedStmt.setDate(n2, date);
    }

    public void setTime(int n2, Time time) throws SQLException {
        this.preparedStmt.setTime(n2, time);
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.preparedStmt.setTimestamp(n2, timestamp);
    }

    public void setObject(int n2, Object object) throws SQLException {
        this.preparedStmt.setObject(n2, object);
    }

    public boolean execute() throws SQLException {
        return this.preparedStmt.execute();
    }

    public void executeComplete() throws SQLException {
        this.m_executeComplete = true;
        this.checkClose();
    }

    void notifyClosed(RTResultSetJDBC rTResultSetJDBC) throws SQLException {
        this.m_openResultSet = null;
        this.checkClose();
    }

    private void checkClose() throws SQLException {
        if (!this.m_isClosed && this.m_executeComplete && this.m_openResultSet == null) {
            this.m_isClosed = true;
            this.preparedStmt.close();
        }
    }

    public void setBooleanWrapper(int n2, Boolean bl) throws SQLException {
        if (bl == null) {
            this.preparedStmt.setNull(n2, -7);
        } else {
            this.preparedStmt.setBoolean(n2, bl);
        }
    }

    public void setByteWrapper(int n2, Byte by) throws SQLException {
        if (by == null) {
            this.preparedStmt.setNull(n2, -6);
        } else {
            this.preparedStmt.setByte(n2, by);
        }
    }

    public void setShortWrapper(int n2, Short s2) throws SQLException {
        if (s2 == null) {
            this.preparedStmt.setNull(n2, 5);
        } else {
            this.preparedStmt.setShort(n2, s2);
        }
    }

    public void setIntWrapper(int n2, Integer n3) throws SQLException {
        if (n3 == null) {
            this.preparedStmt.setNull(n2, 4);
        } else {
            this.preparedStmt.setInt(n2, n3);
        }
    }

    public void setLongWrapper(int n2, Long l2) throws SQLException {
        if (l2 == null) {
            this.preparedStmt.setNull(n2, -5);
        } else {
            this.preparedStmt.setLong(n2, l2);
        }
    }

    public void setFloatWrapper(int n2, Float f2) throws SQLException {
        if (f2 == null) {
            this.preparedStmt.setNull(n2, 6);
        } else {
            this.preparedStmt.setFloat(n2, f2.floatValue());
        }
    }

    public void setDoubleWrapper(int n2, Double d2) throws SQLException {
        if (d2 == null) {
            this.preparedStmt.setNull(n2, 8);
        } else {
            this.preparedStmt.setDouble(n2, d2);
        }
    }

    public void setAsciiStreamWrapper(int n2, AsciiStream asciiStream) throws SQLException {
        if (asciiStream == null) {
            this.preparedStmt.setNull(n2, -1);
        } else {
            this.preparedStmt.setAsciiStream(n2, asciiStream.getInputStream(), asciiStream.getLength());
        }
    }

    public void setBinaryStreamWrapper(int n2, BinaryStream binaryStream) throws SQLException {
        if (binaryStream == null) {
            this.preparedStmt.setNull(n2, -4);
        } else {
            this.preparedStmt.setBinaryStream(n2, binaryStream.getInputStream(), binaryStream.getLength());
        }
    }

    public void setUnicodeStreamWrapper(int n2, UnicodeStream unicodeStream) throws SQLException {
        if (unicodeStream == null) {
            this.preparedStmt.setNull(n2, -1);
        } else {
            this.preparedStmt.setUnicodeStream(n2, unicodeStream.getInputStream(), unicodeStream.getLength());
        }
    }
}

