﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.Odbc;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace TestODBC
{
    public partial class Form1 : Form
    {
        OdbcConnection odbcconn;
        DataSet ds;
        public Form1()
        {
            InitializeComponent();
            OdbcConnectionStringBuilder build = new OdbcConnectionStringBuilder();
            build.Driver = "GBase ODBC DRIVER (64-Bit)";    // 在系统中注册的驱动名称
            build.Add("Host", "bd.gbasedbt.com");           // 主机地址或者IP地址
            build.Add("Service", "9088");                   // 数据库服务器的使用的端口号
            build.Add("Server", "gbase01");                 // 数据库服务名称
            build.Add("Database", "utf8");                  // 数据库名（DBNAME）
            build.Add("Protocol", "onsoctcp");              // 网络协议名称
            build.Add("Uid", "gbasedbt");                   // 用户
            build.Add("Pwd", "GBase123");                   // 密码
            build.Add("Db_locale", "zh_CN.utf8");           // 数据库字符集
            build.Add("Client_locale", "zh_CN.utf8");       // 客户端字符集
            odbcconn = new OdbcConnection(build.ConnectionString);
            odbcconn.Open();
            using (OdbcCommand odbccmd = odbcconn.CreateCommand())
            {
                odbccmd.CommandText = "drop table if exists company";
                odbccmd.ExecuteNonQuery();

                odbccmd.CommandText = "create table company(coid serial,coname varchar(255),coaddr varchar(255))";
                odbccmd.ExecuteNonQuery();

                odbccmd.CommandText = "insert into company values (0,'南大通用','天津市海泰绿色产业基地')";
                odbccmd.ExecuteNonQuery();

                odbccmd.CommandText = "insert into company values (0,'南大通用北京分公司','北京市朝阳区太阳宫')";
                odbccmd.ExecuteNonQuery();

                odbccmd.CommandText = "update company set coaddr = '天津市普天创新园' where coid = 1";
                odbccmd.ExecuteNonQuery();

                odbccmd.CommandText = "select dbinfo('version','full') from dual";
                OdbcDataReader dr = odbccmd.ExecuteReader();
                if (dr.Read())
                {
                    this.label1.Text = "数据库版本号为： " + dr[0];
                }
            }
        }

        private void btnSelect_Click(object sender, EventArgs e)
        {
            OdbcDataAdapter odbcadpt = new OdbcDataAdapter("select * from company", odbcconn);
            ds = new DataSet();
            odbcadpt.Fill(ds);
            this.dataGridView1.DataSource = ds.Tables[0];
            MessageBox.Show("ODBC 方式操作数据库成功！ \n");
        }
    }
}
