#   Default Environment Variables for GBasedbt Database Driver for Perl DBI Version 2018.1031 (2018-10-31)
#
#   Copyright 2002-03 IBM
#   Copyright 2004-10 Jonathan Leffler
#
#   You may distribute under the terms of either the GNU General Public
#   License or the Artistic License, as specified in the Perl README file.

{
    package DBD::GBasedbt::Defaults;

    require Exporter;
    @ISA = qw(Exporter);
    @EXPORT = qw(default_GBASEDBTDIR default_GBASEDBTSERVER);
    $VERSION = "2018.1031";
    $VERSION = "0.97002" if ($VERSION =~ m%[:]VERSION[:]%);

	sub default_GBASEDBTDIR
	{
		return '/opt/gbase';
	}
	sub default_GBASEDBTSERVER
	{
		return 'gbase01';
	}
    1;
}

__END__

=head1 NAME

DBD::GBasedbt::Defaults - Default values for GBASEDBTDIR and GBASEDBTSERVER

=head1 SYNOPSIS

use DBD::GBasedbt::Defaults;

=head1 DESCRIPTION

This module was generated automatically by DBD::GBasedbt
(GBasedbt Database Driver for Perl DBI Version 2018.1031 (2018-10-31)).
It records the default values of GBASEDBTDIR and GBASEDBTSERVER
that were in use when DBD::GBasedbt was built.
You can edit the returned values if you need to,
but worry about where the GBasedbt libraries are loaded from.

Because DBD::GBasedbt was built without a relocatable GBASEDBTDIR,
if you edit GBASEDBTDIR here, you will need to keep the libraries
in the original location because those path names are hard-linked.

The recorded default values are:

    GBASEDBTDIR    = "/opt/gbase"
    GBASEDBTSERVER = "gbase01"

You will seldom if ever have cause to use this module directly.
You should seldom have cause to use it indirectly either because
you will always set GBASEDBTDIR and GBASEDBTSERVER in the
environment before using DBD::GBasedbt.

This module increases the chances of DBD::GBasedbt working
with Apache and mod_perl without attention modifying the Apache configuration.

=head1 AUTHOR

Jonathan Leffler

=cut
