#!/bin/perl
#
# @(#)$Id: t98pod.t,v 2014.1 2014/04/21 06:38:37 jleffler Exp $
#
# Check the POD files for DBD::GBasedbt
#
# Copyright 2003-14 Jonathan Leffler

use Test::Pod tests => 10;
use strict;
use warnings;

my $prefix = "./blib/lib";

my @podlist = (
    "Bundle/DBD/GBasedbt.pm",
    "DBD/GBasedbt.pm",
    "DBD/GBasedbt/Configure.pm",
    "DBD/GBasedbt/Defaults.pm",
    "DBD/GBasedbt/GetInfo.pm",
    "DBD/GBasedbt/Metadata.pm",
    "DBD/GBasedbt/Summary.pm",
    "DBD/GBasedbt/TechSupport.pm",
    "DBD/GBasedbt/TestHarness.pm",
    "DBD/GBasedbt/TypeInfo.pm"
);

foreach my $name (@podlist)
{
    my $file = "$prefix/$name";
    my $test = $name;
    $test =~ s%/%::%go;
    $test =~ s%\.pm$%%o;
    pod_file_ok($file, "POD for $test");
}
