#!/usr/bin/perl
 
use warnings;
use strict;
use DBI;

print "Perl ODBC测试程序开始运行.\n\n"; 
# 通过ODBC连接到数据库 utf8
my $dbh = DBI->connect
          (
             "DBI:ODBC:utf8",
             'gbasedbt',
             'GBase123'
          );
 
# 开始事务
$dbh->do("begin");
 
# 删除表及创建表
my $sth_d_tab = $dbh->prepare("drop table if exists company");
$sth_d_tab->execute();
 
my $sth_c_tab = $dbh->prepare("create table company(coid serial,coname varchar(255),coaddr varchar(255))");
$sth_c_tab->execute();
 
# 插入数据
my $sth_i_tab = $dbh->prepare("insert into company values (0,'南大通用','天津市海泰绿色产业基地')");
$sth_i_tab->execute();

$sth_i_tab = $dbh->prepare("insert into company values (0,'南大通用北京分公司','北京市朝阳区太阳宫')");
$sth_i_tab->execute();
 
# 更新数据
my $sth_u_tab = $dbh->prepare("update company set coaddr = '天津市普天创新园' where coid = 1");
$sth_u_tab->execute();
 
# 查询数据
my $sth_s_tab = $dbh->prepare("select * from company");
$sth_s_tab->execute();
 
while (my $row = $sth_s_tab->fetchrow_hashref())
{
   print sprintf("%d\t%s\t%s\n", $row->{coid}, $row->{coname}, $row->{coaddr});
}
 
# 提交事务，关闭数据库连接
$dbh->do("commit");
$dbh->disconnect();

print "\nPerl ODBC测试程序结束运行.\n"; 
 
exit 0;
