/***************************************************************************
*	Licensed Materials - Property of GBase
*
*
*	"Restricted Materials of GBase"
*
*
*
*	GBase 8s GCI Interface demo
*
*
*	(C) Copyright GBase Corporation 2015 All rights reserved.
*
*
*
*
*
*  Title:          test_connect.c
*
*  Description:    Test connect to database by Logon or Attach.
*                  
*
***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gci.h"


int TestInit()
{
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;
	GCIStmt *stmthp1 = NULL;

	int rc = GCI_SUCCESS;

	GCItext *dbname = (GCItext*)"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";

	
	fprintf(stdout, "!!!Begin testing connect to database using GCIEnvInit().\n\n");
	rc = GCIInitialize(GCI_DEFAULT, (dvoid *)0, 0, 0, 0);
	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvInit(&envhp, GCI_THREADED|GCI_OBJECT, 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvInit: create env handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 1 done...GCIEnvCreate: create env handle success.\n");
	
	
	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
			GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 2 done...GCIHandleAlloc: allocate error handle success.\n");
	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
			GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 3 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 3 done...GCIHandleAlloc: allocate svcctx handle success.\n");
	

	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
			pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
            	sb1 errmsg[256] = {0}, errstate[256] = {0};
				sb4 errcode;
				GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
				fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 4 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto EXIT;
	}


	fprintf(stdout, "Step 4 done...GCILogon: logon to database success.\n");
	ub1         verInfoBuffer[512];
	rc = GCIServerVersion(svchp, errhp, verInfoBuffer, 512, GCI_DEFAULT);	
	
    printf("version %s\n",verInfoBuffer);
	/* Allocate the statement handle */    
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp1, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	rc = GCICloseSvcSocket(svchp);
	if(rc != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 4.5 -- GCICloseSvcSocket: failed.\nExiting!!\n");
		goto EXIT;
	}
	if(stmthp1)
		GCIHandleFree((dvoid *)stmthp1, GCI_HTYPE_STMT);

	if(rc = GCILogoff(svchp, errhp) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 5 -- GCILogoff: logoff from database failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 5 done...GCILogoff: logoff from database success.\n");
	fprintf(stdout, "\n\n\n");

EXIT:
	
	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);
	
	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);

	return rc;	
}
int TestLogon()
{
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;

	int rc = GCI_SUCCESS;

	GCItext *dbname = (GCItext*)"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";

	
	fprintf(stdout, "!!!Begin testing connect to database using GCILogon().\n\n");
	
	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
			0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 1 done...GCIEnvCreate: create env handle success.\n");
	
	
	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
			GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 2 done...GCIHandleAlloc: allocate error handle success.\n");
	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
			GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 3 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 3 done...GCIHandleAlloc: allocate svcctx handle success.\n");
	

	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
			pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
            	sb1 errmsg[256] = {0}, errstate[256] = {0};
				sb4 errcode;
				GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
				fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 4 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 4 done...GCILogon: logon to database success.\n");
	

	if(rc = GCILogoff(svchp, errhp) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 5 -- GCILogoff: logoff from database failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 5 done...GCILogoff: logoff from database success.\n");
	fprintf(stdout, "\n\n\n");

EXIT:
	
	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);
	
	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);

	return rc;	
}


#if 1
int TestAttach()
{
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIServer *srvhp = NULL;
	GCIError *errhp = NULL;
	GCISession *usrhp = NULL;

	int rc = GCI_SUCCESS;

	GCItext *dbname = (GCItext*)"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";

	GCItext connStr[1024] = {0};
	
	fprintf(stdout, "!!!Begin testing connect to database use GCIServerAttach() and GCISessionBegin().\n\n");
	
	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
			0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 1 done...GCIEnvCreate: create env handle success.\n");
	
	
	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
			GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 2 done...GCIHandleAlloc: allocate error handle success.\n");
	
	
	if(rc = GCIHandleAlloc((dvoid*)envhp, (dvoid**)&srvhp, GCI_HTYPE_SERVER, (size_t)0, (dvoid**) 0))
	{
		fprintf(stdout, "Error in Step 3 -- GCIHandleAlloc: allocate server handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 3 done...GCIHandleAlloc: allocate server handle success.\n");	
	
	
	if(rc = GCIServerAttach(srvhp, errhp, (GCItext*)dbname, strlen(dbname), GCI_DEFAULT))
	{
		fprintf(stdout, "Error in Step 4 -- GCIServerAttach: attach to server failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 4 done...GCIServerAttach: attach to server success.\n");
	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
			GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 5 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 5 done...GCIHandleAlloc: allocate svcctx handle success.\n");

	GCIAttrSet((dvoid*)svchp, GCI_HTYPE_SVCCTX, (dvoid*)srvhp, (ub4)0, GCI_ATTR_SERVER, errhp);	
	
	
	if(rc = GCIHandleAlloc((dvoid*)envhp, (dvoid**)&usrhp, GCI_HTYPE_SESSION, (size_t)0, (dvoid**) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 6 -- GCIHandleAlloc: allocate session handle failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 6 done...GCIHandleAlloc: allocate session handle success.\n");

	GCIAttrSet((dvoid*)usrhp, GCI_HTYPE_SESSION, (dvoid*)user, (ub4)strlen(user), GCI_ATTR_USERNAME, errhp);
	GCIAttrSet((dvoid*)usrhp, GCI_HTYPE_SESSION, (dvoid*)pswd, (ub4)strlen(pswd), GCI_ATTR_PASSWORD, errhp);	
	
	
	if(rc = GCISessionBegin(svchp, errhp, usrhp, GCI_CRED_RDBMS, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 7 -- GCISessionBegin: connect to database by session failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 7 done...GCISessionBegin: connect to database by session success.\n");
	
	GCIAttrSet((dvoid*)svchp, GCI_HTYPE_SVCCTX, (dvoid*)usrhp, (ub4)0, GCI_ATTR_SESSION, errhp);	
	
	
	if(rc = GCISessionEnd(svchp, errhp, usrhp, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 8 -- GGISessionEnd: disconnect from database by session failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 8 done...GGISessionEnd: disconnect from database by session success.\n");	
	

	if(rc = GCIServerDetach(srvhp, errhp, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 9 -- GCIServerDetach: detach from server failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 9 done...GCIServerDetach: detach from server success.\n");	

EXIT:
	
	if(usrhp)
		GCIHandleFree((dvoid *)usrhp, GCI_HTYPE_SESSION);
	
	if(srvhp)
		GCIHandleFree((dvoid *)srvhp, GCI_HTYPE_SERVER);
	
	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);
	
	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);
	
	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);

	return rc;		
}
#endif
#define _strlwr(pstr)  do \
{\
	char * _str = (char*)pstr;\
	while (*_str) \
	{ \
	if (isupper(*_str)) \
	*_str = tolower(*_str);\
	_str++;\
	}\
} while(0)
void testddlreplace()
{	
    char sqltext[] = "create table testdb(vt2 varchar2(100)  not null premary key,vt21_varchar2 VARCHAR2(100) default 'varchar2(100)',NT1_number NUMBER(20),NT2_NUMBER number(20),nt3 number(10,2),nt4 NUMBER(10,4),nt5_timestamp timestamp(0),nt6_number number,nt7_varchar2 varchar2  not null,nt8_varchar2 varchar2(1000),   nt9 number ( 10, 2)  ) ";	
    char sqltext1[] = "create table testdb(vt2 varchar2(100)  not null premary key,vt21_varchar2 VARCHAR2(100) default 'varchar2(100)',NT1_number NUMBER(20),NT2_NUMBER number(20),nt3 number(10,2),nt4 NUMBER(10,4),nt5_timestamp timestamp(0),nt6_number number,nt7_varchar2 varchar2  not null,nt8_varchar2 varchar2(1000),   nt9 number ( 10, 2) ) ";	
    char sqltextB[] = "CREATE TABLE testdb(vt2 varchar2(100),vt21_varchar2 VARCHAR2(100),NT1_number NUMBER(20),NT2_NUMBER number(20),nt3 number(10,2),nt4 NUMBER(10,4),nt5_timestamp timestamp(0),nt6_number number,nt7_varchar2 varchar2,nt8_number number,nt9 float(24),nt10 float(50)  not null,nt11 float(30)  )";	
    char sqltextB1[] = "CREATE TABLE testdb(vt2 varchar2(100),vt21_varchar2 VARCHAR2(100),NT1_number NUMBER(20),NT2_NUMBER number(20),nt3 number(10,2),nt4 NUMBER(10,4),nt5_timestamp timestamp(0),nt6_number number,nt7_varchar2 varchar2,nt8_number number,nt9 float(24),nt10 float(50)  not null,nt11 float(30)  )";	

    char sqltext2[] = "create table testdb(vt2 varchar2(100),vt21_varchar2 VARCHAR2(100),NT1_number NUMBER(20),NT2_NUMBER number(20),nt3 number(10,2),nt4 NUMBER(10,4),nt5_timestamp timestamp(0),nt6_number number,nt7_varchar2 varchar2,nt8_varchar2 varchar2(1000)  not null,   nt9 number ( 10, 2)  ,nt10 number ( 10 ) ) ";	
    char sqltext21[] = "create table testdb(vt2 varchar2(100),vt21_varchar2 VARCHAR2(100),NT1_number NUMBER(20),NT2_NUMBER number(20),nt3 number(10,2),nt4 NUMBER(10,4),nt5_timestamp timestamp(0),nt6_number number,nt7_varchar2 varchar2,nt8_varchar2 varchar2(1000)  not null,   nt9 number ( 10, 2)  ,nt10 number ( 10 ) ) ";	

    char sqltexta2[] = "alter table add(vt2 varchar2(100),vt21_varchar2 VARCHAR2(100),NT1_number NUMBER(20) not null,NT2_NUMBER number(20),nt3 number(10,2) not null,nt4 NUMBER(10,4),nt5_timestamp timestamp(0) not null,nt6_number number not null,nt7_varchar2 varchar2,nt8_varchar2 varchar2(1000),   nt9 number ( 10, 2)  ,nt10 number ( 10 ) ) ";	
    char sqltexta21[] = "alter table add(vt2 varchar2(100),vt21_varchar2 VARCHAR2(100),NT1_number NUMBER(20) not null,NT2_NUMBER number(20),nt3 number(10,2) not null,nt4 NUMBER(10,4),nt5_timestamp timestamp(0) not null,nt6_number number not null,nt7_varchar2 varchar2,nt8_varchar2 varchar2(1000),   nt9 number ( 10, 2)  ,nt10 number ( 10 ) ) ";	

    

    char sqltextainterval2[] = "create table add(c1 interval day  to second(0) not null,c2 interval day ( 1 ) to second( 0 )  not null,c3 char(199) ,c4  interval day  to second(0))                         ";	
    char sqltextainterval21[] = "create table add(c1 interval day  to second(0) not null,c2 interval day ( 1 ) to second( 0 )  not null,c3 char(199) ,c4  interval day  to second(0))                         ";	



    _strlwr(sqltext1);
    _strlwr(sqltextB1);
    _strlwr(sqltext21);    
    _strlwr(sqltexta21);    
    _strlwr(sqltextainterval21);       
    printf("replace :%s\n",sqltext);	
    _GCIStmtReplayVarchar2(sqltext1,sqltext);	
    printf("replaced :%s\n",sqltext);

    printf("replace :%s\n",sqltextB);	
    _GCIStmtReplayVarchar2(sqltextB1,sqltextB);	
   printf("replace :%s\n",sqltextB);

    printf("replace :%s\n",sqltext2);	
    _GCIStmtReplayVarchar2(sqltext21,sqltext2);	
 printf("replace :%s\n",sqltext2);	
 
    printf("replace :%s\n",sqltexta2);	
    _GCIStmtReplayVarchar2(sqltexta21,sqltexta2);	
  printf("replace :%s\n",sqltexta2);
  
    printf("replace :%s\n",sqltextainterval2);	    
    _GCIStmtReplayVarchar2(sqltextainterval21,sqltextainterval2);	

    printf("replace :%s\n",sqltextainterval2);	        
}
void testdmlreplace()
{	
    char sqltext[] = "update testlobtable set lob1=EMPTY_blob(),lob2=empty_clob() ,lob3= empty_blob() where item_num=1001";	

    char *littleStmt = NULL;

//for(;;)
{
    printf("==replace :%s\n",sqltext);	
    
    _GCIReplaUpdateLob(&littleStmt,sqltext);	
    printf("--replace :%s\n",littleStmt);
    free(littleStmt);
}
    
    littleStmt = NULL;

    
}	
char sqltexta[][512] =
{
    "update testlobtable set :1=EMPTY_blob(),:2=empty_clob() ,lob3= empty_blob() where :3>item_num",
    "select * from unionview_directives@myserver2:t1 as t where :2<t.a and t.b=:3||:4",
    "select * from myserver2:t1,myserver1:t2 as t where :2<t.a and t.b=:3||:4",
    "select * from user.myserver2:t1,user.myserver1:t2 as t where :2<t.a and :3||:4= t.b",
    "create table test (t1 int -- test :de \n\
                        t2 int -- ':test'\n\
                        )",
    "insert into t2 values(set{:1,:2},array[:4,:3])",
    "select * from database:t1.user as t,user.database1:t2 as ta where  :1!=':test' and (:2+col1)<>\":test\"",
    "select * from database:t1 union select  * from database1:t2 where col1::varchar(10) =:1 and :2\n=col2",
    "insert into t3 values(':testaaa',\":testaaa\",:2,:3)",
    "select * from t1 where (:2  +col1)=(:3+col2)",
    "select * from database:t1 union select  * from database1:t2 where col1 ::varchar(11) =:1 and :2\n=col2",
    "select * from database:t1 union select  * from database1:t2 where col1 : :varchar(11) =:1 and :2\n=col2",
    "select * from database:t1 union select  * from database1:t2 where col1 :=varchar(11) =:1 and :2\n=col2",
    "select * from database:t1 union select  * from database1:t2 where col1 :: varchar(11) =:1 and :2\n=col2",
    "select * from unionview_directives@myserver2 :t1 as t where :2<t.a and t.b=:3||:4",
    "select * from add :add where 1<>1 and  :add > add :add.d",
    "update add :add set d=:1 where 1<>1 and  :add > :1",
    "update dd set d=:1,d.t=:2 where 1<>1 and  :add > :1",
   /* "update 4 set h\316 = xx where . =? ",*/
    "",
};
void testplacereplace()
{	
        GCIEnv *envhp = NULL;
        GCISvcCtx *svchp = NULL;
        GCIError *errhp = NULL;
        GCIStmt *stmthp1 = NULL;
    	GCIStmt *stmt = NULL;   
        int loop = 0;
        char sqltext[] = "update testlobtable set :1=EMPTY_blob(),:2=empty_clob() ,lob3= empty_blob() where :3>item_num";   
        char sqltext1[] = "select * from unionview_directives@myserver2:t1 as t where :2<t.a and t.b=:3||:4";   
        char sqltext2[] = "select * from myserver2:t1,myserver1:t2 as t where :2<t.a and t.b=:3||:4";   
        char sqltext3[] = "select * from myserver2:t1.user,myserver1:t2.user as t where :2<t.a and t.b=:3||:4";   


        
        int rc = GCI_SUCCESS;
    
        GCItext *dbname = (GCItext*)"gci_demodb";
        GCItext *user = (GCItext*)"gbasedbt";
        GCItext *pswd = (GCItext*)"Big4ifmx";
    
        
        fprintf(stdout, "!!!Begin testing connect to database using GCIEnvInit().\n\n");
        rc = GCIInitialize(GCI_DEFAULT, (dvoid *)0, 0, 0, 0);
        /* initialize the mode to be the threaded and object environment */
        if(rc = GCIEnvInit(&envhp, GCI_THREADED|GCI_OBJECT, 0, (dvoid **)0) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 1 -- GCIEnvInit: create env handle failed.\nExiting!!\n");
            goto EXIT;
        }
        
        fprintf(stdout, "Step 1 done...GCIEnvCreate: create env handle success.\n");
        
        
        /* allocate an error handle */
        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
                GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
            goto EXIT;
        }
        
        fprintf(stdout, "Step 2 done...GCIHandleAlloc: allocate error handle success.\n");
        
        
        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
                GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 3 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
            goto EXIT;
        }
    
        fprintf(stdout, "Step 3 done...GCIHandleAlloc: allocate svcctx handle success.\n");
        
    if(rc = GCILogonNoDb(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
                pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed\nExiting!!\n");
            goto EXIT;
        }

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto EXIT;
	}
    rc = GCIStmtPrepare(stmt, errhp, sqltext, strlen(sqltext), 0, GCI_DEFAULT);
    rc = GCIStmtPrepare(stmt, errhp, sqltext1, strlen(sqltext), 0, GCI_DEFAULT);
    rc = GCIStmtPrepare(stmt, errhp, sqltext2, strlen(sqltext2), 0, GCI_DEFAULT);
    rc = GCIStmtPrepare(stmt, errhp, sqltext3, strlen(sqltext3), 0, GCI_DEFAULT);
    
    printf("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");

    while(1)
    {
        if (strlen(sqltexta[loop]))
        {
            printf("=================== %d \n",loop);
            rc = GCIStmtPrepare(stmt, errhp, sqltexta[loop], strlen(sqltexta[loop]), 0, GCI_DEFAULT);
        }
        else
        {
            break;
        }
        loop++;
    }

EXIT:
    return -1;    

    
}	

void testconnectout()
{	
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;

	int rc = GCI_SUCCESS;

	GCItext *dbname = (GCItext*)"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifm";

	
	fprintf(stdout, "!!!Begin testing connect to database using GCILogon().\n\n");
	
	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
			0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 1 done...GCIEnvCreate: create env handle success.\n");
	
	
	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
			GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 2 done...GCIHandleAlloc: allocate error handle success.\n");
	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
			GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 3 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 3 done...GCIHandleAlloc: allocate svcctx handle success.\n");
	int timeout = 5;
        if ((rc = GCIAttrSet(svchp,GCI_HTYPE_SVCCTX,&timeout,0,GCI_ATTR_CONN_TIMEOUT,errhp)) != GCI_SUCCESS)
        {
            	sb1 errmsg[30] = {0}, errstate[30] = {0};
				sb4 errcode;
				GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 30, GCI_HTYPE_ERROR);
				fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 4 -- GCILogon: logon to database LOGIN TO.\nExiting!!\n");
		goto EXIT;        
        }
	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
			pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
            	sb1 errmsg[256] = {0}, errstate[256] = {0};
				sb4 errcode;
				GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
				fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 4 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 4 done...GCILogon: logon to database success.\n");
	

	if(rc = GCILogoff(svchp, errhp) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 5 -- GCILogoff: logoff from database failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 5 done...GCILogoff: logoff from database success.\n");
	fprintf(stdout, "\n\n\n");

EXIT:
	
	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);
	
	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);

	return rc;	
    
}
void testchangepass()
{	
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;

	int rc = GCI_SUCCESS;

	GCItext *dbname = (GCItext*)"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";

	
	fprintf(stdout, "!!!Begin testing connect to database using GCILogon().\n\n");
	
	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
			0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 1 done...GCIEnvCreate: create env handle success.\n");
	
	
	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
			GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 2 done...GCIHandleAlloc: allocate error handle success.\n");
	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
			GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 3 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 3 done...GCIHandleAlloc: allocate svcctx handle success.\n");
	int timeout = 5;
        if ((rc = GCIAttrSet(svchp,GCI_HTYPE_SVCCTX,&timeout,0,GCI_ATTR_CONN_TIMEOUT,errhp)) != GCI_SUCCESS)
        {
            	sb1 errmsg[256] = {0}, errstate[256] = {0};
				sb4 errcode;
				GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
				fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 4 -- GCILogon: logon to database LOGIN TO.\nExiting!!\n");
		goto EXIT;        
        }
	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
			pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
            	sb1 errmsg[256] = {0}, errstate[256] = {0};
				sb4 errcode;
				GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
				fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 4 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 4 done...GCILogon: logon to database success.\n");
        fprintf(stdout, "Step 5 done...GCILogon:change pass.\n");
	if(rc = GCIPasswordChange(svchp,errhp, (char *)"lengweijie2", (ub4)strlen((char*)"lengweijie2"),
			"222222", (ub4)strlen((char*)"111111"), "333333", (ub4)strlen((char*)"222222"),GCI_DEFAULT) != GCI_SUCCESS)
	{
            	sb1 errmsg[256] = {0}, errstate[256] = {0};
				sb4 errcode;
				GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
				fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 4 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto EXIT;
	}	
        
	if(rc = GCILogoff(svchp, errhp) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 5 -- GCILogoff: logoff from database failed.\nExiting!!\n");
		goto EXIT;
	}


	if(rc = GCILogon(envhp, errhp, &svchp, "lengweijie2", (ub4)strlen((char*)"lengweijie2"),
			"333333", (ub4)strlen((char*)"333333"), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
            	sb1 errmsg[256] = {0}, errstate[256] = {0};
				sb4 errcode;
				GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
				fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 4 -- GCILogon: logon to change pass failed.\nExiting!!\n");
		goto EXIT;
	}
	fprintf(stdout, "Step 8 done...GCILogoff : change pass success.\n");
	fprintf(stdout, "\n\n\n");

EXIT:
	
	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);
	
	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);

	return rc;	
    
}


int testlogonnodb()
{
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;
	GCIStmt *stmthp1 = NULL;

	int rc = GCI_SUCCESS;

	GCItext *dbname = (GCItext*)"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";

	
	fprintf(stdout, "!!!Begin testing connect to database using GCIEnvInit().\n\n");
	rc = GCIInitialize(GCI_DEFAULT, (dvoid *)0, 0, 0, 0);
	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvInit(&envhp, GCI_THREADED|GCI_OBJECT, 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvInit: create env handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 1 done...GCIEnvCreate: create env handle success.\n");
	
	
	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
			GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf(stdout, "Step 2 done...GCIHandleAlloc: allocate error handle success.\n");
	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
			GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 3 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 3 done...GCIHandleAlloc: allocate svcctx handle success.\n");
	
if(rc = GCILogonNoDb(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
			pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
	            	sb1 errmsg[256] = {0}, errstate[256] = {0};
				sb4 errcode;
				GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
				fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed\nExiting!!\n");
		goto EXIT;
	}

    
	if(rc = GCIStmtExecDirect(svchp, (ub1*) "DATABASE gci_demodb", errhp, 0, 0, 0, 0, GCI_DEFAULT))
	{
	        fprintf (stdout, "DATABASE: database failed..\n");
	}
	else
	{
        	fprintf (stdout, "DATABASE: database successed.\n");
		
	}
    	if(rc = GCIStmtExecDirect(svchp, (ub1*) "select * from item", errhp, 0, 0, 0, 0, GCI_DEFAULT))
	{
	        fprintf (stdout, "select: database failed..\n");
	}
	else
	{
        	fprintf (stdout, "select: database successed.\n");
		
	}

	fprintf(stdout, "Step 4 done...GCILogon: logon to database success.\n");
	ub1         verInfoBuffer[512];
	rc = GCIServerVersion(svchp, errhp, verInfoBuffer, 512, GCI_DEFAULT);	
	
    printf("version %s\n",verInfoBuffer);
	/* Allocate the statement handle */    
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp1, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	rc = GCICloseSvcSocket(svchp);
	if(rc != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 4.5 -- GCICloseSvcSocket: failed.\nExiting!!\n");
		goto EXIT;
	}
	if(stmthp1)
		GCIHandleFree((dvoid *)stmthp1, GCI_HTYPE_STMT);

	if(rc = GCILogoff(svchp, errhp) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 5 -- GCILogoff: logoff from database failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf(stdout, "Step 5 done...GCILogoff: logoff from database success.\n");
	fprintf(stdout, "\n\n\n");

EXIT:
	
	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);
	
	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);

	return rc;	
}

int main(long         argc,
         char*        argv[])
{
	int in;
        int loop = 0;
        char *fchar = "1234567890123456789012";
        long lchar = 1234567890123456789;
        double f = 0;
        double lf = 0;
        double lft = 1.0e-7;
        float ff = 0.0;
	testddlreplace();
	testdmlreplace();

        f = atof(fchar);
       lf = strtold(fchar,NULL);
        ff = (float)lft;

        printf("===============double %.130lf,float %.130f\n",lft,ff);
        printf("===============double precision %lf,%lf\n",f,lf);
        lf = f = lchar;
        printf("===============double precision %lf,%lf\n",f,lf);        
        testconnectout();
        testchangepass();
	TestInit();
	TestLogon();
	TestAttach();
    testlogonnodb();
	
    testplacereplace();


	fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
	in = getchar ();
    
	return 0;
}
