/*
     DMLs on the following columns of employees is done.
     If the table structure changes in releases beyond 10iR1, the 
     demo *may* need to be changed accordingly.

     Name                                      Null?    Type
     ----------------------------------------- -------- ------------
     EMPLOYEE_ID                               NOT NULL INT
     LAST_NAME                                 NOT NULL VARCHAR2(25)
     SALARY                                             INT
     DEPARTMENT_ID                             NOT NULL VARCHAR2(10)
     JOB_ID                                    NOT NULL VARCHAR2(10)
     EMAIL                                     NOT NULL VARCHAR2(25)
     HIRE_DATE                                 NOT NULL DATE

    Create Table SQL Statement:
        create table employees(EMPLOYEE_ID INT,LAST_NAME VARCHAR2(25), SALARY INT,DEPARTMENT_ID VARCHAR2(10),
        JOB_ID VARCHAR2(10), EMAIL VARCHAR2(26), HIRE_DATE DATE)
*/

#include <oci.h>
#include <stdio.h> 
#include <stdlib.h>
#include <string.h> 
//#include <gci.h>


/* Maximum number of threads  */ 
#define MAXTHREAD 10
/* Number of columns in select list */
#define MAXBINDS 7
 
static GCIError   *errhp;
static GCIEnv     *envhp;
static GCICPool   *poolhp;
static GCIText    *poolName;
static sb4         poolNameLen;

static int employeeNum[MAXTHREAD];

static CONST GCIText *database = (GCIText *)"gci_test";
static CONST GCIText *username = (GCIText *)"gbasedbt";
static CONST GCIText *password = (GCIText *)"Big4ifmx";
static CONST GCIText *appusername = (GCIText *)"gbasedbt"; 
static CONST GCIText *apppassword = (GCIText *)"Big4ifmx";

/*  Values to be inserted into employees table */
static char ename[MAXTHREAD][26]=
    {"LASTNAME1","LASTNAME2","LASTNAME3","LASTNAME4","LASTNAME5",
     "LASTNAME6","LASTNAME7","LASTNAME8","LASTNAME9","LASTNAME10"};

static char ejob[MAXTHREAD][11]=
          {"AD_PRES", "AD_VP", "AD_ASST", "FI_MGR", "FI_ACCOUNT",
           "AC_MGR", "AC_ACCOUNT", "SA_MAN", "SA_REP", "PU_MAN"};

static float esal[MAXTHREAD]={1000.00, 2000.00, 3000.00, 4000.00, 5000.00,
                              6000.00, 7000.00, 8000.00, 9000.00, 10000.00};
static unsigned int edept[MAXTHREAD] = {10,20,10,20,30,10,30,20,10,20};

static char email[MAXTHREAD][25]= 
   {"name1@oracle.com", "name2@oracle.com", "name3@oracle.com",
    "name4@oracle.com", "name5@oracle.com", "name6@oracle.com",
    "name7@oracle.com", "name8@oracle.com", "name9@oracle.com",
    "name10@oracle.com"};

static char hdate[MAXTHREAD][10]= 
   {"21-DEC-01", "22-DEC-01", "23-DEC-01", "24-DEC-01", "25-DEC-01",
    "26-DEC-01", "27-DEC-01", "28-DEC-01", "29-DEC-01", "30-DEC-01"};

/* Max, min and increment connections */
static ub4 conMin = 1;
static ub4 conMax = 3;
static ub4 conIncr = 1;
 
/* Local functions */
static void checkerr (GCIError *errhp, sword status);
static void threadFunction (dvoid *arg);
//static void threadFunction (int);
static void queryRows();
static void deleteRows();
int main();
 
/*- main -------------------------------------------------------------------*/
int main()
{
    int i = 0;
    sword lstat;
    int timeout = 10;

    GCIEnvCreate (&envhp, GCI_THREADED | GCI_OBJECT, (dvoid *)0,  NULL,
      NULL, NULL, 0, (dvoid *)0);
 
    (void) GCIHandleAlloc((dvoid *) envhp, (dvoid **) &errhp, GCI_HTYPE_ERROR,
                     (size_t) 0, (dvoid **) 0);
 
    (void) GCIHandleAlloc((dvoid *) envhp, (dvoid **) &poolhp, GCI_HTYPE_CPOOL,
                          (size_t) 0, (dvoid **) 0);

    GCIAttrSet((dvoid*)poolhp, GCI_HTYPE_CPOOL, (dvoid*)&timeout, (ub4)sizeof(ub4), GCI_ATTR_CONN_TIMEOUT, errhp);
 
    /* CREATE THE CONNECTION POOL */
    if (lstat = GCIConnectionPoolCreate(envhp,
                     errhp,poolhp, &poolName, &poolNameLen,
                     database,(sb4)strlen((const signed char *)database),
                     conMin, conMax, conIncr,
                     appusername,(sb4)strlen((const signed char *)appusername),
                     apppassword,(sb4)strlen((const signed char *)apppassword)
                     ,GCI_DEFAULT))
    {
      checkerr(errhp,lstat);
      exit(1);
    }

    if (lstat = GCIConnectionPoolCreate(envhp,
                     errhp,poolhp, &poolName, &poolNameLen,
                     database,(sb4)strlen((const signed char *)database),
                     0, conMax, conIncr,
                     appusername,(sb4)strlen((const signed char *)appusername),
                     apppassword,(sb4)strlen((const signed char *)apppassword)
                     ,GCI_CPOOL_REINITIALIZE))
    {
      checkerr(errhp,lstat);
      exit(1);
    }

    if (lstat = GCIConnectionPoolCreate(envhp,
                     errhp,poolhp, &poolName, &poolNameLen,
                     database,(sb4)strlen((const signed char *)database),
                     2, conMax, conIncr,
                     appusername,(sb4)strlen((const signed char *)appusername),
                     apppassword,(sb4)strlen((const signed char *)apppassword)
                     ,GCI_CPOOL_REINITIALIZE))
    {
      checkerr(errhp,lstat);
      exit(1);
    }

    if (lstat = GCIConnectionPoolCreate(envhp,
                     errhp,poolhp, &poolName, &poolNameLen,
                     database,(sb4)strlen((const signed char *)database),
                     1, 6, 2,
                     appusername,(sb4)strlen((const signed char *)appusername),
                     apppassword,(sb4)strlen((const signed char *)apppassword)
                     ,GCI_CPOOL_REINITIALIZE))
    {
      checkerr(errhp,lstat);
      exit(1);
    }

    if (lstat = GCIConnectionPoolCreate(envhp,
                     errhp,poolhp, &poolName, &poolNameLen,
                     database,(sb4)strlen((const signed char *)database),
                     3, 3, 0,
                     appusername,(sb4)strlen((const signed char *)appusername),
                     apppassword,(sb4)strlen((const signed char *)apppassword)
                     ,GCI_CPOOL_REINITIALIZE))
    {
      checkerr(errhp,lstat);
      exit(1);
    }

//sleep(30);

    /*  Delete rows that are already inserted by this demo */ 
    deleteRows();

    /* Multiple threads using the connection pool */
    {
      GCIThreadId     *thrid[MAXTHREAD];
      GCIThreadHandle *thrhp[MAXTHREAD];
 
      GCIThreadProcessInit ();
      checkerr (errhp, GCIThreadInit (envhp, errhp));
      for (i = 0; i < MAXTHREAD; ++i)
      {
        checkerr (errhp, GCIThreadIdInit (envhp, errhp, &thrid[i]));
        checkerr (errhp, GCIThreadHndInit (envhp, errhp, &thrhp[i]));
      }
      printf("Multiple threads inserting rows into employees table\n");
      for (i = 0; i < MAXTHREAD; ++i)
      {
        employeeNum[i]=i;
        /* Insert into hr.employees table */
        checkerr (errhp, GCIThreadCreate (envhp, errhp, threadFunction,
            (dvoid *) &employeeNum[i], thrid[i], thrhp[i]));
      }
      for (i = 0; i < MAXTHREAD; ++i)
      {
        checkerr (errhp, GCIThreadJoin (envhp, errhp, thrhp[i]));
        checkerr (errhp, GCIThreadClose (envhp, errhp, thrhp[i]));
        checkerr (errhp, GCIThreadIdDestroy (envhp, errhp, &(thrid[i])));
        checkerr (errhp, GCIThreadHndDestroy (envhp, errhp, &(thrhp[i])));
      }
      checkerr (errhp, GCIThreadTerm (envhp, errhp));
    } /* ALL THE THREADS ARE COMPLETE */

    /* Display inserted rows */ 
    queryRows();

    checkerr(errhp, GCIConnectionPoolDestroy(poolhp, errhp, GCI_DEFAULT));
    checkerr(errhp, GCIHandleFree((dvoid *)poolhp, GCI_HTYPE_CPOOL));
    checkerr(errhp, GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR));
    return 0;
} 
/* - end of main -----------------------------------------------------------*/


/* - Insert records into employees table -----------------------------------*/ 
static void threadFunction (dvoid *arg)
//static void threadFunction (int empno)
{
    GCISvcCtx *svchp  = (GCISvcCtx *) 0;
    GCIStmt   *stmthp = (GCIStmt *)0;
    GCIError  *errhp2 = (GCIError *) 0;
    int        empno  = *(int *)arg;
    sword      lstat  = 0;
    text       insertst1[256];
 
    (void) GCIHandleAlloc((dvoid *) envhp, (dvoid **) &errhp2, GCI_HTYPE_ERROR,
                     (size_t) 0, (dvoid **) 0);

    if (lstat = GCILogon2(envhp, errhp2, &svchp,
      (CONST GCIText *)username, (ub4)strlen((const signed char *)username),
      (CONST GCIText *)password, (ub4)strlen((const signed char *)password),
      (CONST GCIText *)poolName, (ub4)poolNameLen,
                          GCI_CPOOL))
    {
      checkerr(errhp2,lstat);
      exit(1);
    }
    (void) sprintf(insertst1,
      "INSERT INTO employees(employee_id, last_name, job_id, salary, \
         department_id, email, hire_date) \
         VALUES (%d,'%s','%s',%7.2f,%d,'%s','%s')",
         empno+1,ename[empno],ejob[empno],
         esal[empno],edept[empno], email[empno], hdate[empno]);
    
    printf("Inserting details of %s\n",ename[empno]);
 
    GCIHandleAlloc(envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, (size_t)0,
                   (dvoid **)0);
 
    checkerr(errhp2, GCIStmtPrepare (stmthp, errhp2, (GCIText *)insertst1,
             (ub4)strlen((const signed char *)insertst1), GCI_NTV_SYNTAX, 
             GCI_DEFAULT));
 
    checkerr(errhp2, GCIStmtExecute (svchp, stmthp, errhp2, (ub4)1, (ub4)0,
             (GCISnapshot *)0, (GCISnapshot *)0, GCI_DEFAULT ));
 
    //checkerr(errhp2, GCITransCommit(svchp,errhp2,(ub4)0));
 
//sleep(10);
    checkerr(errhp2, GCIHandleFree((dvoid *) stmthp, GCI_HTYPE_STMT));
    checkerr(errhp2, GCILogoff((dvoid *) svchp, errhp2));
printf("logoff end\n");
//sleep(20);
    GCIHandleFree((dvoid *)errhp2, GCI_HTYPE_ERROR);
} 
/*- end of threadFunction --------------------------------------------------*/


/* Delete rows which are inserted in the previous invocation of this demo --*/
static void deleteRows()
{
    GCISvcCtx *svchp = (GCISvcCtx *) 0;
    sword status = 0;
    text deletest1[256];
    sword lstat;
    GCIStmt *stmthp = (GCIStmt *)0;
    if (lstat = GCILogon2(envhp, errhp, &svchp,
       (CONST GCIText *)username, (ub4)strlen((const signed char *)username),
       (CONST GCIText *)password, (ub4)strlen((const signed char *)password),
       (CONST GCIText *)poolName, (ub4)poolNameLen,
                          GCI_CPOOL))
    {
      checkerr(errhp,lstat);
      exit(1);
    }

    (void) sprintf(deletest1,
     "DELETE FROM employees WHERE employee_id BETWEEN 1 AND %d",MAXTHREAD); 
    GCIHandleAlloc(envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, (size_t)0,
                   (dvoid **)0);

    checkerr(errhp, GCIStmtPrepare (stmthp, errhp, (text *)deletest1,
             (ub4)strlen((const signed char *)deletest1), GCI_NTV_SYNTAX, 
             GCI_DEFAULT));
    checkerr(errhp, GCIStmtExecute (svchp, stmthp, errhp, (ub4)1, (ub4)0,
             (GCISnapshot *)0, (GCISnapshot *)0, GCI_DEFAULT ));
    //checkerr(errhp, GCITransCommit(svchp,errhp,(ub4)0));

    checkerr(errhp, GCIHandleFree((dvoid *) stmthp, GCI_HTYPE_STMT));
    checkerr(errhp, GCILogoff((dvoid *) svchp, errhp));
    printf("Deleted all rows between 1 and %d\n", MAXTHREAD); 

} 
/*- end of deleteRows ------------------------------------------------------*/


/*- Display the contents of hr.employees table -----------------------------*/
#define DBUFLEN 20
static void queryRows() 
{
    GCISvcCtx *svchp  = (GCISvcCtx *) 0;
    GCIStmt   *stmthp = (GCIStmt *)0;
    GCIDefine *defhp[MAXBINDS];
    GCIDate    emp_hdate;
    sword      status = 0;
    sword      lstat  = 0;
    text       selectst1[256];
    text       emp_name[26];   
    text       emp_job[11]; 
    text       emp_email[26];
    text       datebuf[DBUFLEN];
    ub4        emp_no = 0;
    ub4        emp_dept = 0;
    ub4        datebuflen = DBUFLEN;
    float      emp_sal = 0.0;
    int        i = 0;

    /* Logon in Connection Pool mode */
    if (lstat = GCILogon2(envhp, errhp, &svchp,
      (CONST GCIText *)username, (ub4)strlen((const signed char *)username),
      (CONST GCIText *)password, (ub4)strlen((const signed char *)password),
      (CONST GCIText *)poolName, (ub4)poolNameLen,
      GCI_CPOOL))
    {
      checkerr(errhp,lstat);
      exit(1);
    }

    (void) sprintf(selectst1,
       "SELECT employee_id, last_name, job_id, salary, department_id, \
               email, hire_date \
        FROM employees WHERE employee_id between 1 and %d",MAXTHREAD);

    GCIHandleAlloc(envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, (size_t)0,
                   (dvoid **)0);

    checkerr(errhp, GCIStmtPrepare (stmthp, errhp, (text *)selectst1,
            (ub4)strlen((const signed char *)selectst1), GCI_NTV_SYNTAX, 
            GCI_DEFAULT));
    checkerr(errhp,GCIDefineByPos (stmthp, &defhp[0], errhp, (ub4)1,
            (dvoid *)&emp_no, (sb4)sizeof(ub4), (ub2)SQLT_INT, (dvoid *)0,
            (ub2 *)0, (ub2 *)0, GCI_DEFAULT));
    checkerr(errhp,GCIDefineByPos (stmthp, &defhp[1], errhp, (ub4)2,
            (dvoid *)&emp_name, (sb4)sizeof(emp_name), (ub2)SQLT_STR, 
            (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT));
    checkerr(errhp,GCIDefineByPos (stmthp, &defhp[2], errhp, (ub4)3,
            (dvoid *)&emp_job, (sb4)sizeof(emp_job), (ub2)SQLT_STR, 
            (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT));
    checkerr(errhp,GCIDefineByPos (stmthp, &defhp[3], errhp, (ub4)4,
            (dvoid *)&emp_sal,(sb4)sizeof(float),(ub2)SQLT_FLT,(dvoid *)0,
            (ub2 *)0, (ub2 *)0, GCI_DEFAULT));
    checkerr(errhp,GCIDefineByPos (stmthp, &defhp[4], errhp, (ub4)5,
            (dvoid *)&emp_dept,(sb4)sizeof(ub4),(ub2)SQLT_INT,(dvoid *)0,
            (ub2 *)0, (ub2 *)0, GCI_DEFAULT));
    checkerr(errhp,GCIDefineByPos (stmthp, &defhp[5], errhp, (ub4)6,
            (dvoid *)&emp_email,(sb4)sizeof(emp_email),(ub2)SQLT_STR,
            (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT));
    checkerr(errhp,GCIDefineByPos (stmthp, &defhp[6], errhp, (ub4)7,
            (dvoid *)&emp_hdate,(sb4)sizeof(emp_hdate),(ub2)SQLT_ODT,
            (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT));

    /* Execute the Query and Fetch MAXTHREAD records */
    if (lstat = GCIStmtExecute (svchp, stmthp, errhp, (ub4)0, 
            (ub4)0, (GCISnapshot *)0, (GCISnapshot *)0, GCI_DEFAULT ))
    {
      checkerr(errhp,lstat);
      exit(1);
    }
    /* Printing the values */

    printf("Displaying the inserted records\n");
    status = GCIStmtFetch(stmthp,errhp,1,GCI_FETCH_NEXT,GCI_DEFAULT);
    while (status != GCI_NO_DATA)
    {
       /* Convert GCIDate into text format for printing */
       lstat = GCIDateToText(errhp, &emp_hdate, (text *)"yyyy-mm-dd", (ub1)strlen("yyyy-mm-dd"),
                             (text*)"American", (ub4)8, &datebuflen, datebuf);
       if (lstat)
        checkerr(errhp, lstat);
       printf(
        "Empno:%u Name:%s Job:%s Sal:%7.2f Deptno:%u Email:%s Hiredate:%s\n",
         emp_no,emp_name,emp_job,emp_sal,emp_dept, emp_email, datebuf); 
       status = GCIStmtFetch(stmthp,errhp,1,GCI_FETCH_NEXT,GCI_DEFAULT);
    }

    checkerr(errhp, GCIHandleFree((dvoid *) stmthp, GCI_HTYPE_STMT));
    checkerr(errhp, GCILogoff((dvoid *) svchp, errhp));
} 
/*- end of queryRows --------------------------------------------------------*/
#undef  DBUFLEN
 

/* Handle oci error ---------------------------------------------------------*/
void checkerr(errhp, status)
GCIError *errhp;
sword status;
{
    text errbuf[512];
    sb4 errcode = 0;
 
    switch (status)
    {
    case GCI_SUCCESS:
      break;
    case GCI_SUCCESS_WITH_INFO:
      (void) printf("Error - GCI_SUCCESS_WITH_INFO\n");
      break;
    case GCI_NEED_DATA:
      (void) printf("Error - GCI_NEED_DATA\n");
      break;
    case GCI_NO_DATA:
      (void) printf("Error - GCI_NODATA\n");
      break;
    case GCI_ERROR:
      (void) GCIErrorGet((dvoid *)errhp, (ub4) 1, (text *) NULL, &errcode,
                          errbuf, (ub4) sizeof(errbuf), GCI_HTYPE_ERROR);
      (void) printf("Error - %.*s\n", 512, errbuf);
      break;
    case GCI_INVALID_HANDLE:
      (void) printf("Error - GCI_INVALID_HANDLE\n");
      break;
    case GCI_STILL_EXECUTING:
      (void) printf("Error - GCI_STILL_EXECUTE\n");
      break;
    case GCI_CONTINUE:
      (void) printf("Error - GCI_CONTINUE\n");
      break;
    default:
      break;
    }
}
/* end of demo -------------------------------------------------------------*/
