/***************************************************************************
*	Licensed Materials - Property of GBase
*
*
*	"Restricted Materials of GBase"
*
*
*
*	GBase 8s DCI Interface demo
*
*
*	Copyright GBase Corporation 2015 All rights reserved.
*
*
*
*
*
*  Title:          test_iudssql_dci.c
*
*  Description:    Testing insert, update, delete func by bind and define.
*
***************************************************************************
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "dci.h"

#define SELSQL_LEN     25
#define ERRMSG_LEN     200


/*
**  Executes the given select statement and assumes the results will be
**  stored by column buffer.
**
*/
int do_select_storebycol (  DCISvcCtx *svchp,
							DCIStmt *stmthp,
							DCIError *errhp)
{
	int rc = 0;
	
    /*  STEP A. Allocate the buffer memory used to retrieve the results,
    *        and stored by column buffer.
    */
	sb4  *key = (sb4 *)malloc(sizeof(sb4) * 100);
	sb1  *desc = (sb1 *)malloc(sizeof(sb1) * 20 * 100);
	sb2  *stock = (sb2 *)malloc(sizeof(sb2) * 100);
	sb1  *ship = (sb1 *)malloc(sizeof(sb1) * 20 * 100);
    sb4 starown = 0;
	DCIDefine *bndhp[4];	
	
	memset(key, 0, sizeof(sb4) * 100);
	memset(desc, 0, sizeof(sb1) * 20 * 100);
	memset(stock, 0, sizeof(sb2) * 100);
	memset(ship, 0, sizeof(sb1) * 20 * 100);

	/**Bind the result set columns -
    **          --  col1 = item_num
    **              col2 = description
    **              col3 = stock
    **              col4 = ship_unit
    */
	if (rc = DCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)key, (sb4)sizeof(sb4), (ub2)SQLT_INT,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- DCIDefineByPos: define handle by pos 1 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = DCIDefineByPos(stmthp, &bndhp[1], errhp, 2, (dvoid *)desc, (sb1)20, (ub2)SQLT_STR,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- DCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = DCIDefineByPos(stmthp, &bndhp[2], errhp, 3, (dvoid *)stock, (sb2)sizeof(sb2), (ub2)SQLT_INT,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- DCIDefineByPos: define handle by pos 3 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = DCIDefineByPos(stmthp, &bndhp[3], errhp, 4, (dvoid *)ship, (sb1)20, (ub2)SQLT_STR,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- DCIDefineByPos: define handle by pos 4 failed.\nExiting!!\n");
		goto EXIT;
	}	

	fprintf (stdout, "\tStep A done...DCIDefineByPos: Define handle by pos success.\n");
	
	
	/*  STEP B. Define array of struct.
    */
/*	if (rc = DCIDefineArrayOfStruct(bndhp[0], errhp, sizeof(sb4), 0, 0, 0) != DCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- DCIDefineArrayOfStruct: define array of struct 1 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = DCIDefineArrayOfStruct(bndhp[1], errhp, 20, 0, 0, 0) != DCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- DCIDefineArrayOfStruct: define array of struct 2 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = DCIDefineArrayOfStruct(bndhp[2], errhp, sizeof(sb2), 0, 0, 0) != DCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- DCIDefineArrayOfStruct: define array of struct 3 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = DCIDefineArrayOfStruct(bndhp[3], errhp, 20, 0, 0, 0) != DCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- DCIDefineArrayOfStruct: define array of struct 4 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf (stdout, "\tStep B done...DCIDefineArrayOfStruct: Define array of struct success.\n");
*/	
	
	/*  STEP C. Execut the select statement    
    */   
	if (rc = DCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST DCISnapshot*)0, (DCISnapshot*)0,
			DCI_DEFAULT) != DCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step C -- DCIStmtExecute: execute select statement failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf (stdout, "\tStep C done...DCIStmtExecute: Execute select statement success.\n");
	
	
	/*  STEP D. Retrieve the results
    */
    
    
	while(1) 
	{
		ub4 rownum = 0;
		int i;
		if (rc = DCIStmtFetch(stmthp, errhp, 100, DCI_FETCH_NEXT, 0) == DCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...DCIStmtFetch: No data found...\n");
			rc = DCI_SUCCESS;
			goto SUCCESS_EXIT;		
			break;
		}
		DCIAttrGet(stmthp, DCI_HTYPE_STMT, &rownum, 0, DCI_ATTR_ROW_COUNT, errhp);
		
		if(starown == rownum)
			break;
			
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving row number %d:\n", i + 1);
			fprintf(stdout, "\t\titem_num -- %d\n", *(key + i));
			fprintf(stdout, "\t\tdescription -- %s\n", desc + i * 20);
			fprintf(stdout, "\t\tstock -- %d\n", *(stock + i));
			fprintf(stdout, "\t\tship_unit -- %s\n", ship + i * 20);	
		}
		
		starown = rownum;
	}


SUCCESS_EXIT:

    fprintf (stdout, "\tStep D done...DCIStmtFetch: Retrieve the results success.\n");

EXIT:
	free(key);
	free(desc);	
	free(stock);	
	free(ship);	
	
    return rc; /* no error */
}



/*
 * This function allocates the row and collection buffers, passes
 * them to the do_select_storebyxxx() function, along with an appropriate select
 * statement and then frees all allocated handles.
 */
int main (long argc,
          char* argv[])
{
   /* Declare variables */

    ub4			i, in;

    ub1         verInfoBuffer[SELSQL_LEN];
    ub4			verInfoLen;
    ub1         majorVer[3];
    ub4      	isUdoEnabled;
   
    ub1		sqlStmt[1000] = {0};
    
    ub1  nonUdoItem[1000] = {"(9001,'Testing shoes',250,'Pair','270.00',\
 'Super shock-absorbing gel pads disperse vertical energy into a horizontal plane\
 for extraordinary cushioned comfort. Great motion control. Mens only. Specify size.')"};

    /* Handles */
	DCIEnv *envhp = NULL;
	DCISvcCtx *svchp = NULL;
	DCIError *errhp = NULL;
	DCIStmt *stmthp = NULL;
	
	int rc = DCI_SUCCESS;
	sb4 param = 9001;
	sb4 value = 450;
	DCIBind *hbind[2] = {NULL};
	DCItext *dbname = (DCItext*)"GCI_DEMODB";
	DCItext *user = (DCItext*)"gbasedbt";
	DCItext *pswd = (DCItext*)"Big4ifmx";

    /*  STEP 1. Get data source name from command line (or use default)
    **          Allocate the environment handle and set ODBC version
    **          Allocate the connection handle
    **          Establish the database connection
    **          Allocate the statement handle
    **          Drop demo database if it already exists
    */

	/* initialize the mode to be the threaded and object environment */
	if(rc = DCIEnvCreate(&envhp, DCI_THREADED|DCI_OBJECT, (dvoid *)0,
			0, 0, 0, (size_t) 0, (dvoid **)0) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- DCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	/* allocate an error handle */
	if(rc = DCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
			DCI_HTYPE_ERROR, 0, (dvoid **) 0) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- DCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if(rc = DCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
			DCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- DCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto EXIT;
	}

	if(rc = DCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
			pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != DCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		DCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, DCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 1 -- DCILogon: logon to database failed.\nExiting!!\n");
		goto EXIT;
	}
	
    /* Get version information from the database server
       If version < 9.x (not UDO enabled), exit with error message */
	/*
    if(rc = DCIServerVersion(svchp, errhp, verInfoBuffer, SELSQL_LEN, DCI_DEFAULT) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- DCIServerVersion: get database server version failed\nExiting!!\n");
		goto EXIT;
	}    
	
    if ((strncmp ((char *) verInfoBuffer, "09", 2)) < 0 )
    {
        fprintf (stdout, "\n** This test can only be run against UDO-enabled database server -- version 9 or higher **\n");
        goto EXIT;
    }
	*/
	
    fprintf (stdout, "Step 1 done...connected to database.\n");
    
    fprintf (stdout, "\n!!!Begin SELECT and retrieve RAW results stored by row buffer.\n");
    
    
    /* Allocate the statement handle */    
	if(rc = DCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, DCI_HTYPE_STMT, 0, (dvoid **) 0) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- DCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
    
    
    memset(sqlStmt, 0, 1000);
	sprintf((char *)sqlStmt, "SELECT item_num, description, stock, ship_unit FROM item");
    
    if(rc = DCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		DCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, DCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- DCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
    
    /* Retrieve databse rows containing a list */
    if (do_select_storebycol (svchp, stmthp, errhp))
    {
    	fprintf (stdout, "Error in Step 2...select and retrieve results failed.\nExiting!!\n");	
        goto EXIT;
	}
    
    fprintf (stdout, "Step 2 done...select and retrieve results success.\n");
	
	DCIHandleFree((dvoid *)stmthp, DCI_HTYPE_STMT);
	/* Allocate the statement handle */    
	if(rc = DCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, DCI_HTYPE_STMT, 0, (dvoid **) 0) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 3 -- DCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
    
    
    
    fprintf (stdout, "\n!!!Begin INSERT into table item a new record where item_num = 9001.\n");	
    
    memset(sqlStmt, 0, 1000);
    strcat((char *)sqlStmt, "INSERT INTO item VALUES ");
    strcat((char *)sqlStmt,(char *) nonUdoItem);
	
	if(rc = DCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		DCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, DCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 3 -- DCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = DCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST DCISnapshot*)0, (DCISnapshot*)0,
			DCI_DEFAULT) != DCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		DCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, DCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 3 -- DCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf (stdout, "Step 3 done...DCIStmtExecute: Execute insert statement success, insert a new record.\n");
	
	
	
	fprintf (stdout, "\n!!!Begin SELECT and retrieve INSERTED results stored by row buffer.\n");

	memset(sqlStmt, 0, 1000);
	sprintf(sqlStmt, "SELECT item_num, description, stock, ship_unit FROM item where item_num = :Param");

	if(rc = DCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		DCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, DCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 4 -- DCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if(rc = DCIBindByPos(stmthp, &hbind[0], errhp, 1, (dvoid *)&param, sizeof(param), SQLT_INT, (dvoid *)0, 
			(ub2 *)0, (ub2 *)0, 0, (ub4 *)0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		DCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, DCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 4 -- DCIBindByPos: bind by pos failed.\nExiting!!\n");
		goto EXIT;
	}
	
	/* Retrieve databse rows containing a list */
    if (do_select_storebycol (svchp, stmthp, errhp))
    {
    	fprintf (stdout, "Error in Step 4...select and retrieve results failed.\nExiting!!\n");	
        goto EXIT;
	}
	
    fprintf (stdout, "Step 4 done...select and retrieve results using DCIBindByPos success.\n");

	
	DCIHandleFree((dvoid *)stmthp, DCI_HTYPE_STMT);
	/* Allocate the statement handle */    
	if(rc = DCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, DCI_HTYPE_STMT, 0, (dvoid **) 0) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 5 -- DCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
    
    
    fprintf (stdout, "\n!!!Begin UPDATE the record where item_num = 9001 set stork to 450.\n");	
        
	memset(sqlStmt, 0, 1000);
	sprintf(sqlStmt, "UPDATE item set stock = :Value where item_num = :Param");

	if(rc = DCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		DCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, DCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 5 -- DCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if(rc = DCIBindByPos(stmthp, &hbind[0], errhp, 1, (dvoid *)&value, sizeof(sb4), SQLT_INT, (dvoid *)0, 
			(ub2 *)0, (ub2 *)0, 0, (ub4 *)0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 5 -- DCIBindByPos: bind by pos failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if(rc = DCIBindByPos(stmthp, &hbind[1], errhp, 2, (dvoid *)&param, sizeof(param), SQLT_INT, (dvoid *)0, 
			(ub2 *)0, (ub2 *)0, 0, (ub4 *)0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 5 -- DCIBindByPos: bind by pos failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = DCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST DCISnapshot*)0, (DCISnapshot*)0,
			DCI_DEFAULT) != DCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		DCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, DCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 5 -- DCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf (stdout, "Step 5 done...DCIStmtExecute: Execute update statement success, update a record.\n");
	
	
	
	fprintf (stdout, "\n!!!Begin SELECT and retrieve UPDATED results stored by row buffer.\n");
    	
	memset(sqlStmt, 0, 1000);
	sprintf(sqlStmt, "SELECT item_num, description, stock, ship_unit FROM item where item_num = :Param");

	if(rc = DCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 6 -- DCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if(rc = DCIBindByName(stmthp, &hbind[0], errhp, (sb1 *)"Param", strlen("Param"), (dvoid *)&param, sizeof(param), SQLT_INT, (dvoid *)0, 
			(ub2 *)0, (ub2 *)0, 0, (ub4 *)0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		DCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, DCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 6 -- DCIBindByName: bind by name failed.\nExiting!!\n");
		goto EXIT;
	}
	
	/* Retrieve databse rows containing a list */
    if (do_select_storebycol (svchp, stmthp, errhp))
    {
    	fprintf (stdout, "Error in Step 6...select and retrieve results failed.\nExiting!!\n");	
        goto EXIT;
	}
	
    fprintf (stdout, "Step 6 done...select and retrieve results using DCIBindByName success.\n");



	DCIHandleFree((dvoid *)stmthp, DCI_HTYPE_STMT);
	/* Allocate the statement handle */    
	if(rc = DCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, DCI_HTYPE_STMT, 0, (dvoid **) 0) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 5 -- DCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	
	
	fprintf (stdout, "\n!!!Begin DELETE the record where item_num = 9001.\n");	
    	
	memset(sqlStmt, 0, 1000);	
	sprintf(sqlStmt, "DELETE FROM item where item_num = :Param");

	if(rc = DCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 7 -- DCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if(rc = DCIBindByPos(stmthp, &hbind[0], errhp, 1, (dvoid *)&param, sizeof(param), SQLT_INT, (dvoid *)0, 
			(ub2 *)0, (ub2 *)0, 0, (ub4 *)0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 7 -- DCIBindByPos: bind by pos failed.\nExiting!!\n");
		goto EXIT;
	}	

	if (rc = DCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST DCISnapshot*)0, (DCISnapshot*)0,
			DCI_DEFAULT) != DCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		DCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, DCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 7 -- DCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf (stdout, "Step 7 done...DCIStmtExecute: Execute delete statement success, delete a record.\n");
	
	
	
	fprintf (stdout, "\n!!!Begin SELECT and retrieve DELETED results stored by row buffer.\n");
    	
	memset(sqlStmt, 0, 1000);
	sprintf(sqlStmt, "SELECT item_num, description, stock, ship_unit FROM item where item_num = :Param");

	if(rc = DCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 8 -- DCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if(rc = DCIBindByName(stmthp, &hbind[0], errhp, (sb1 *)"Param", sizeof("Param"), (dvoid *)&param, sizeof(param), SQLT_INT, (dvoid *)0, 
			(ub2 *)0, (ub2 *)0, 0, (ub4 *)0, DCI_DEFAULT) != DCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 8 -- DCIBindByName: bind by name failed.\nExiting!!\n");
		goto EXIT;
	}
	
	/* Retrieve databse rows containing a list */
    if (do_select_storebycol (svchp, stmthp, errhp))
    {
    	fprintf (stdout, "Error in Step 8...select and retrieve results failed.\nExiting!!\n");	
        goto EXIT;
	}
	
    fprintf (stdout, "Step 8 done...select and retrieve results success, no data found.\n");
		

EXIT:

    /* CLEANUP: Close the statement handle
    **          Free the statement handle
    **          Disconnect from the datasource
    **          Free the connection and environment handles
    **          Exit
    */

    	
	if(stmthp)
		DCIHandleFree((dvoid *)stmthp, DCI_HTYPE_STMT);	
		
	DCILogoff(svchp, errhp);
	
	if(svchp)
		DCIHandleFree((dvoid *)svchp, DCI_HTYPE_SVCCTX);
	
	if(errhp)
		DCIHandleFree((dvoid *)errhp, DCI_HTYPE_ERROR);
	
	if(envhp)
		DCIHandleFree((dvoid *)envhp, DCI_HTYPE_ENV);
	
    fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
    in = getchar ();
    
    return (rc);
}
