/***************************************************************************
 *	Licensed Materials - Property of GBase
 *
 *
 *	"Restricted Materials of GBase"
 *
 *
 *
 *	GBase 8s GCI Interface demo
 *
 *
 *	Copyright GBase Corporation 2015 All rights reserved.
 *
 *
 *
 *
 *
 *  Title:          test_rcselect.c
 *
 *  Description:    To retrieve results from the database and display it. 
 *                  This example also illustrates the fact
 *                  that the same client functions can use row and column
 *                  store buffer.
 *
 ***************************************************************************
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "gci.h"

#define SELSQL_LEN     25
#define ERRMSG_LEN     200

int
read_from_loc(GCISvcCtx *svchp,
		GCIError *errhp,
		GCILobLocator *lobp)
{
	ub1 *buf;
	ub4 amtp;
	ub4 lenp=0;
	ub4 readsize = 0;
	sb4 err;

	err = GCILobGetLength(svchp, errhp, lobp, &lenp);
	if(err != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		return err;
	}
	if(0 == lenp)
	{
		printf("lob data is null \n");
		return err;
	}
	buf = (ub1 *)malloc(sizeof(ub1)*(lenp+1));
	buf[lenp] = '\0';
	
	do
	{
	
		amtp = 1;
		err = GCILobRead(svchp, errhp, lobp, &amtp,0,
				buf+readsize,lenp-readsize,NULL,
				NULL,0,0);

		if(err == GCI_SUCCESS || err == GCI_NEED_DATA)
			readsize += amtp;
	}while(err == GCI_NEED_DATA);

	fprintf (stdout, "Smart large object contents are.....\n\n\n%s\n\n\n", buf);

	free(buf);

	return GCI_SUCCESS;



}

/*
 **  Executes the given select statement and assumes the results will be
 **  stored by row buffer.
 **
 */
int do_select_storebyrow (  GCISvcCtx *svchp,
		GCIStmt *stmthp,
		GCIError *errhp,
		GCILobLocator *lobp)
{
	int rc = 0;
	sb2 ind[20];
	GCIDefine *bndhp[1];
	sb4 starown = 0;
	int i = 0;

	/**Bind the result set columns -
	 **          --  col1 = item_num
	 **              col2 = description
	 **              col3 = stock
	 **              col4 = ship_unit
	 */
	if (rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)&lobp, sizeof(GCILobLocator *), (ub2)SQLT_CLOB,
				(dvoid *)ind, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 1 failed.\nExiting!!\n");
		goto EXIT;
	}


	fprintf (stdout, "\tStep A done...GCIDefineByPos: Define handle by pos success.\n");


	/*  STEP C. Execut the select statement    
	*/
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step C -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf (stdout, "\tStep C done...GCIStmtExecute: Execute select statement success.\n");


	/*  STEP D. Retrieve the results
	*/

	while(1) 
	{//ֻһ¼¼Ҫlob
		ub4 rownum = 0;
		if ((rc = GCIStmtFetch(stmthp, errhp,1, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;

		fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
			rc = GCI_SUCCESS;
			//goto SUCCESS_EXIT;	
			break;
		}
		if(rc == -1)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;

			fprintf (stdout, "\tStep D done...GCIStmtFetch: fetch error...\n");
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
        rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			
			break;			
		}		
		GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
		if(starown == rownum)
			break;
		starown= rownum;
		if(rownum > 1)
		i++;
		printf("loop %d\n",i);
		if(-1 == ind[0])
		{
			printf("lob data is null %d\n",i);
		}
		else
			read_from_loc(svchp, errhp, lobp);		
	}




SUCCESS_EXIT:

	fprintf (stdout, "\tStep D done...GCIStmtFetch: Retrieve the results success.\n");

EXIT:

	return rc; /* no error */
}




/*
 * This function allocates the row and collection buffers, passes
 * them to the do_select_storebyxxx() function, along with an appropriate select
 * statement and then frees all allocated handles.
 */
int main (long argc,
		char* argv[])
{
	/* Declare variables */

	ub4			i, in;

	ub1         verInfoBuffer[SELSQL_LEN];
	ub4			verInfoLen;
	ub1         majorVer[3];
	ub4      	isUdoEnabled;

	ub1*		selectStmt =(ub1*) "SELECT advert FROM item WHERE item_num = 1001";

	/* Handles */
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;
	GCIStmt *stmthp1 = NULL;
	GCIStmt *stmthp2 = NULL;

	int rc = GCI_SUCCESS;

	GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";//"gbasedbt";
	GCILobLocator *lobp[5];

	/*  STEP 1. Get data source name from command line (or use default)
	 **          Allocate the environment handle and set ODBC version
	 **          Allocate the connection handle
	 **          Establish the database connection
	 **          Allocate the statement handle
	 **          Drop demo database if it already exists
	 */


	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
				0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto EXIT;
	}

	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
				GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto EXIT;
	}	

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
				GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto EXIT;
	}

	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
				pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto EXIT;
	}

	/* Get version information from the database server
	   If version < 9.x (not UDO enabled), exit with error message */
	/*
	   if(rc = GCIServerVersion(svchp, errhp, verInfoBuffer, SELSQL_LEN, GCI_DEFAULT) != GCI_SUCCESS)
	   {
	   fprintf(stdout, "Error in Step 1 -- GCIServerVersion: get database server version failed\nExiting!!\n");
	   goto EXIT;
	   }    

	   if ((strncmp ((char *) verInfoBuffer, "09", 2)) < 0 )
	   {
	   fprintf (stdout, "\n** This test can only be run against UDO-enabled database server -- version 9 or higher **\n");
	   goto EXIT;
	   }
	   */

	fprintf (stdout, "Step 1 done...connected to database.\n");


	fprintf (stdout, "\n!!!Begin SELECT and retrieve results stored by row buffer.\n");


	/* Allocate the statement handle */    
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp1, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}	

	if(rc = GCIStmtPrepare(stmthp1, errhp, selectStmt, sizeof(selectStmt), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}	

	fprintf (stdout, "Step 2 done...alloc and prepare stmp handle 1 success.\n");

	for( i = 0;i < 5;i++)
	{
		lobp[i] = (GCILobLocator *)0;
		GCIDescriptorAlloc(envhp,(void **)&lobp[i] , GCI_DTYPE_LOB, 0, NULL);
	}
	//GCIDescriptorAlloc(envhp,&lobp[0] , GCI_DTYPE_LOB, 0, NULL);
	
	/* Retrieve databse rows containing a list */
	if (do_select_storebyrow (svchp, stmthp1, errhp,lobp[0]))
	{
		fprintf (stdout, "Error in Step 2...select and retrieve results stored by row buffer failed.\nExiting!!\n");	
		goto EXIT;
	}

	fprintf (stdout, "Step 3 done...select and retrieve results stored by row buffer success.\n");
	fprintf (stdout,"\nHit <Enter> to continue...");
	in = getchar ();


EXIT:

	/* CLEANUP: Close the statement handle
	 **          Free the statement handle
	 **          Disconnect from the datasource
	 **          Free the connection and environment handles
	 **          Exit
	 */


	if(stmthp1)
		GCIHandleFree((dvoid *)stmthp1, GCI_HTYPE_STMT);

	if(stmthp2)
		GCIHandleFree((dvoid *)stmthp2, GCI_HTYPE_STMT);

	GCILogoff(svchp, errhp);

	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);

	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);

	fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
	in = getchar ();

	return (rc);
}
