/***************************************************************************
*	Licensed Materials - Property of GBase
*
*
*	"Restricted Materials of GBase"
*
*
*
*	GBase 8s GCI Interface demo
*
*
*	Copyright GBase Corporation 2015 All rights reserved.
*
*
*
*
*
*  Title:          test_iudssql.c
*
*  Description:    Testing insert, update, delete func by bind and define.
*
***************************************************************************
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>

#include "gci.h"


#define SELSQL_LEN     25
#define ERRMSG_LEN     200








/*
**  Executes the given select statement and assumes the results will be
**  stored by column buffer.
**
*/
int do_select_storebycol ( GCISvcCtx *svchp,
							GCIStmt *stmthp,
							GCIError *errhp)
{
	int rc = 0;
	
    /*  STEP A. Allocate the buffer memory used to retrieve the results,
    *        and stored by column buffer.
    */
	sb4  *key = (sb4 *)malloc(sizeof(sb4) * 100);
	sb1  *desc = (sb1 *)malloc(sizeof(sb1) * 20 * 100);
	sb2  *stock = (sb2 *)malloc(sizeof(sb2) * 100);
	sb1  *ship = (sb1 *)malloc(sizeof(sb1) * 20 * 100);
	
	GCIDefine *bndhp[4];	
	
	memset(key, 0, sizeof(sb4) * 100);
	memset(desc, 0, sizeof(sb1) * 20 * 100);
	memset(stock, 0, sizeof(sb2) * 100);
	memset(ship, 0, sizeof(sb1) * 20 * 100);

	/**Bind the result set columns -
    **          --  col1 = item_num
    **              col2 = description
    **              col3 = stock
    **              col4 = ship_unit
    */
	if (rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)key, (sb4)sizeof(sb4), (ub2)SQLT_INT,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 1 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 2, (dvoid *)desc, (sb1)20, (ub2)SQLT_STR,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[2], errhp, 3, (dvoid *)stock, (sb2)sizeof(sb2), (ub2)SQLT_INT,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 3 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[3], errhp, 4, (dvoid *)ship, (sb1)20, (ub2)SQLT_STR,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 4 failed.\nExiting!!\n");
		goto EXIT;
	}	

	fprintf (stdout, "\tStep A done...GCIDefineByPos: Define handle by pos success.\n");
	
	
	/*  STEP B. Define array of struct.
    */
	if (rc = GCIDefineArrayOfStruct(bndhp[0], errhp, sizeof(sb4), 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 1 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineArrayOfStruct(bndhp[1], errhp, 20, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 2 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineArrayOfStruct(bndhp[2], errhp, sizeof(sb2), 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 3 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineArrayOfStruct(bndhp[3], errhp, 20, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 4 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf (stdout, "\tStep B done...GCIDefineArrayOfStruct: Define array of struct success.\n");
	
	
	/*  STEP C. Execut the select statement    
    */   
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
			GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step C -- GCIStmtExecute: execute select statement failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf (stdout, "\tStep C done...GCIStmtExecute: Execute select statement success.\n");
	
	
	/*  STEP D. Retrieve the results
    */
    
    sb4 starown = 0;
    
	while(1) 
	{
		ub4 rownum = 0;
		
		if (rc = GCIStmtFetch(stmthp, errhp, 100, GCI_FETCH_NEXT, 0) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;		
			break;
		}
		GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
		
		if(starown == rownum)
			break;
			
		int i;
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving row number %d:\n", i + 1);
			fprintf(stdout, "\t\titem_num -- %d\n", *(key + i));
			fprintf(stdout, "\t\tdescription -- %s\n", desc + i * 20);
			fprintf(stdout, "\t\tstock -- %d\n", *(stock + i));
			fprintf(stdout, "\t\tship_unit -- %s\n", ship + i * 20);	
		}
		
		starown = rownum;
	}


SUCCESS_EXIT:

    fprintf (stdout, "\tStep D done...GCIStmtFetch: Retrieve the results success.\n");

EXIT:
	free(key);
	free(desc);	
	free(stock);	
	free(ship);	
	
    return rc; /* no error */
}
#define BATCH_NUM 2

void *threadup(ub4 *value)
{
     ub4	i, in;

    ub4 param[BATCH_NUM] = {9001,1001};
    ub1         verInfoBuffer[SELSQL_LEN];
    ub4			verInfoLen;
    ub1         majorVer[3];
    ub4      	isUdoEnabled;
    GCIBind *hbind[3] = {NULL};
    ub1		sqlStmt[1000] = {0};
    GCIStmt *stmthp = NULL;
    GCIEnv *envhp = NULL;
    GCISvcCtx *svchp = NULL;
    GCIServer *srvhp = NULL;
    GCIError *errhp = NULL;
    GCISession *usrhp = NULL;
	int loop =0;
	ub4 valuel[BATCH_NUM];

    GCIDateTime *ad[BATCH_NUM] = {NULL,NULL};

    
    GCItext *dbname = (GCItext*)"gci_demodb";//''"gci_demodb";
    GCItext *user = (GCItext*)"gbasedbt";
    GCItext *pswd = (GCItext*)"Big4ifmx";


   
	int rc = GCI_SUCCESS;
         
        if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
                        0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
        {
                fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
                goto EXIT;
        }

        /* allocate an error handle */
        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
                        GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
        {
                fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
                goto EXIT;
        }
        
         if(rc = GCIHandleAlloc((dvoid*)envhp, (dvoid**)&srvhp, GCI_HTYPE_SERVER, (size_t)0, (dvoid**) 0))
        {
                fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate server handle failed.\nExiting!!\n");
                goto EXIT;
        }

        fprintf(stdout, "Step 2 done...GCIHandleAlloc: allocate server handle success.\n");

        if(rc = GCIServerAttach(srvhp, errhp, (GCItext*)dbname, strlen(dbname), GCI_THREADED) != GCI_SUCCESS)
        {
                fprintf(stdout, "Error in Step 3 -- GCIServerAttach: attach to server failed.\nExiting!!\n");
                goto EXIT;
        }

        fprintf(stdout, "Step 3 done...GCIServerAttach: attach to server success.\n");


        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
                        GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
        {
                fprintf(stdout, "Error in Step 4 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
                goto EXIT;
        }

        fprintf(stdout, "Step 4 done...GCIHandleAlloc: allocate svcctx handle success.\n");

        GCIAttrSet((dvoid*)svchp, GCI_HTYPE_SVCCTX, (dvoid*)srvhp, (ub4)0, GCI_ATTR_SERVER, errhp);


        if(rc = GCIHandleAlloc((dvoid*)envhp, (dvoid**)&usrhp, GCI_HTYPE_SESSION, (size_t)0, (dvoid**) 0) != GCI_SUCCESS)
        {
                fprintf(stdout, "Error in Step 4 -- GCIHandleAlloc: allocate session handle failed.\nExiting!!\n");
                goto EXIT;
        }

        fprintf(stdout, "Step 4 done...GCIHandleAlloc: allocate session handle success.\n");

        GCIAttrSet((dvoid*)usrhp, GCI_HTYPE_SESSION, (dvoid*)user, (ub4)strlen(user), GCI_ATTR_USERNAME, errhp);
        GCIAttrSet((dvoid*)usrhp, GCI_HTYPE_SESSION, (dvoid*)pswd, (ub4)strlen(pswd), GCI_ATTR_PASSWORD, errhp);

        if(rc = GCISessionBegin(svchp, errhp, usrhp, GCI_CRED_RDBMS, GCI_THREADED) != GCI_SUCCESS)
        {
                fprintf(stdout, "Error in Step 5 -- GCISessionBegin: connect to database by session failed.\nExiting!!\n");
                goto EXIT;
        }

        fprintf(stdout, "Step 5 done...GCISessionBegin: connect to database by session success.\n");


	
        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 6 -- GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");

		return;
	}	
             

        fprintf (stdout, "\n!!!Begin UPDATE the record where item_num = 9001 set stork to value.\n");	
        
	memset(sqlStmt, 0, 1000);
	
	sprintf(sqlStmt, "UPDATE item set stock = :Value where item_num = :Param");
	sprintf(sqlStmt, "insert into orders(order_num,item_num,order_date) values(:order,:Value,:Param)");

	if(rc = GCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, GCI_THREADED) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 6 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");

		return;
	}	
         
	if(rc = GCIBindByPos(stmthp, &hbind[0], errhp, 1, (dvoid *)valuel, sizeof(sb4), SQLT_INT, (dvoid *)0, 
			(ub2 *)0, (ub2 *)0, 0, (ub4 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 6 -- GCIBindByPos: bind by pos failed.\nExiting!!\n");

		return;
	}
	
	if(rc = GCIBindByPos(stmthp, &hbind[1], errhp, 2, (dvoid *)param, sizeof(sb4), SQLT_INT, (dvoid *)0, 
			(ub2 *)0, (ub2 *)0, 0, (ub4 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 6 -- GCIBindByPos: bind by pos failed.\nExiting!!\n");

		return;
	}
    for (i = 0;i < 2;i++)   
    {
        rc = GCIDescriptorAlloc(envhp,(dvoid **)(GCIDateTime **)&ad[i], GCI_DTYPE_TIMESTAMP, 0, NULL);
        if (rc)
        {
            fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
            goto EXIT;
        }
    }


	if(rc = GCIBindByPos(stmthp, &hbind[2], errhp, 3, (dvoid *)&ad, sizeof(ad), SQLT_TIMESTAMP, (dvoid *)0, 
			(ub2 *)0, (ub2 *)0, 0, (ub4 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 6 -- GCIBindByPos: bind by pos failed.\nExiting!!\n");

		return;
	}

    //construct the timestamp
    for (i = 0;i < 2;i++)
    {
        GCIDateTimeConstruct(stmthp,errhp,ad[i],2000+i+ 10,2,2+1,0,0,0,0,NULL,0);
    }
           /**/
	for (loop = 0;loop < 5000;loop++)
	{
		valuel[0] = *value + loop;
		valuel[1] = *value + loop + 5000;
        

		param[0] = 1001;        
		param[1] = 1002;        

		if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)BATCH_NUM, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_THREADED) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;	
			GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
			fprintf(stdout, "Error in Step 6 -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");

			return;
		}
	}
	fprintf (stdout, "Step 6 done...GCIStmtExecute: Execute update statement success, update a record.\n");
	
	
	#if 0
	fprintf (stdout, "\n!!!Begin SELECT and retrieve UPDATED results stored by row buffer.\n");
    	
	memset(sqlStmt, 0, 1000);
	sprintf(sqlStmt, "SELECT top 10 item_num, description, stock, ship_unit FROM item where item_num = :Param");

	if(rc = GCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 7 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");

		return;
	}	

	if(rc = GCIBindByName(stmthp, &hbind[0], errhp, (sb1 *)"Param", strlen("Param"), (dvoid *)&param, sizeof(param), SQLT_INT, (dvoid *)0, 
			(ub2 *)0, (ub2 *)0, 0, (ub4 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 7 -- GCIBindByName: bind by name failed.\nExiting!!\n");

                return;
	}


	/* Retrieve databse rows containing a list */
    if (do_select_storebycol (svchp, stmthp, errhp))
    {
    	fprintf (stdout, "Error in Step 7...select and retrieve results failed.\nExiting!!\n");	

          return;
	}

    fprintf (stdout, "Step 7 done...select and retrieve results using GCIBindByName success.\n");
	#endif




EXIT:
        if(stmthp)
                GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
        if (ad)
		    GCIDescriptorFree(ad,GCI_DTYPE_TIMESTAMP);

        if(rc = GCISessionEnd(svchp, errhp, usrhp, GCI_THREADED) != GCI_SUCCESS)
        {
                fprintf(stdout, "Error in Step 8 -- GGISessionEnd: disconnect from database by session failed.\nExiting!!\n");
                goto EXIT;
        }

        fprintf(stdout, "Step 8 done...GGISessionEnd: disconnect from database by session success.\n");


        if(rc = GCIServerDetach(srvhp, errhp, GCI_THREADED) != GCI_SUCCESS)
        {
                fprintf(stdout, "Error in Step 9 -- GCIServerDetach: detach from server failed.\nExiting!!\n");
                goto EXIT;
        }

        fprintf(stdout, "Step 9 done...GCIServerDetach: detach from server success.\n");


        if(svchp)
                GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);

        if(errhp)
                GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

        if(envhp)
                GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);
     

        return;

    
}


/*
 * This function allocates the row and collection buffers, passes
 * them to the do_select_storebyxxx() function, along with an appropriate select
 * statement and then frees all allocated handles.
 */
int main (long argc,
          char* argv[])
{
   /* Declare variables */

    ub4			i, in;

    ub1         verInfoBuffer[SELSQL_LEN];
    ub4			verInfoLen;
    ub1         majorVer[3];
    ub4      	isUdoEnabled;
   
    ub1		sqlStmt[1000] = {0};
    
    ub1  nonUdoItem[1000] = {"(9001,'Testing shoes',250,'Pair','270.00',\
 'Super shock-absorbing gel pads disperse vertical energy into a horizontal plane\
 for extraordinary cushioned comfort. Great motion control. Mens only. Specify size.')"};

    /* Handles */
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;
	GCIStmt *stmthp = NULL;

	int rc = GCI_SUCCESS;

	GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";
        ub4 value1 = 10650;
        ub4 value2 = 40700;
        pthread_t thread[2];
	sb4 param = 9001;
	
	GCIBind *hbind[2] = {NULL};
	
	memset(sqlStmt, 0, 1000);
      
    /*  STEP 1. Get data source name from command line (or use default)
    **          Allocate the environment handle and set ODBC version
    **          Allocate the connection handle
    **          Establish the database connection
    **          Allocate the statement handle
    **          Drop demo database if it already exists
    */

	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
			0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
			GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
			GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto EXIT;
	}

	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
			pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto EXIT;
	}
	
   
	
    fprintf (stdout, "Step 1 done...connected to database.\n");
    
    fprintf (stdout, "\n!!!Begin SELECT and retrieve RAW results stored by row buffer.\n");
    
       #if 0
    /* Allocate the statement handle */    
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
    
    
    memset(sqlStmt, 0, 1000);
	sprintf(sqlStmt, "SELECT item_num, description, stock, ship_unit FROM item");
    
    if(rc = GCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, GCI_THREADED) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
    
    /* Retrieve databse rows containing a list */
    if (do_select_storebycol (svchp, stmthp, errhp))
    {
    	fprintf (stdout, "Error in Step 2...select and retrieve results failed.\nExiting!!\n");	
        goto EXIT;
	}
    
    fprintf (stdout, "Step 2 done...select and retrieve results success.\n");
	
	GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
	/* Allocate the statement handle */    
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 3 -- GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
   

   
    fprintf (stdout, "\n!!!Begin INSERT into table item a new record where item_num = 9001.\n");	
  
    memset(sqlStmt, 0, 1000);
    strcat(sqlStmt, "INSERT INTO item VALUES ");
    strcat(sqlStmt, nonUdoItem);	
	
	if(rc = GCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, GCI_THREADED) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 3 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
			GCI_THREADED) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 3 -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf (stdout, "Step 3 done...GCIStmtExecute: Execute insert statement success, insert a new record.\n");
	
	

	fprintf (stdout, "\n!!!Begin SELECT and retrieve INSERTED results stored by row buffer.\n");
    	

	sprintf(sqlStmt, "SELECT item_num, description, stock, ship_unit FROM item where item_num = :Param");

	if(rc = GCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, GCI_THREADED) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 4 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if(rc = GCIBindByPos(stmthp, &hbind[0], errhp, 1, (dvoid *)&param, sizeof(param), SQLT_INT, (dvoid *)0, 
			(ub2 *)0, (ub2 *)0, 0, (ub4 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 4 -- GCIBindByPos: bind by pos failed.\nExiting!!\n");
		goto EXIT;
	}
	
	/* Retrieve databse rows containing a list */
        if (do_select_storebycol (svchp, stmthp, errhp))
        {
    	fprintf (stdout, "Error in Step 4...select and retrieve results failed.\nExiting!!\n");	
        goto EXIT;
	}
	
        fprintf (stdout, "Step 4 done...select and retrieve results using GCIBindByPos success.\n");


	GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
	/* Allocate the statement handle */ 
	#endif

       if(rc=pthread_create(&thread[0],NULL,threadup,(void *)&value1)!=0)
       {
          fprintf(stdout,"thread 1 create error\n");
       }

//      sleep(1);
       if(rc=pthread_create(&thread[1],NULL,threadup,(void *)&value2)!=0)
       {
          fprintf(stdout,"thread 2 create error\n");
       }

        pthread_join(thread[0],NULL);
        pthread_join(thread[1],NULL);
        

#if 0
        /* Allocate the statement handle */
        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
        {
                fprintf(stdout, "Error in Step 5 -- GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
                goto EXIT;
        }

	fprintf (stdout, "\n!!!Begin DELETE the record where item_num = 9001.\n");	
    	
	memset(sqlStmt, 0, 1000);	
	sprintf(sqlStmt, "DELETE FROM item where item_num = :Param");
        
	if(rc = GCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 7 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if(rc = GCIBindByPos(stmthp, &hbind[0], errhp, 1, (dvoid *)&param, sizeof(param), SQLT_INT, (dvoid *)0, 
			(ub2 *)0, (ub2 *)0, 0, (ub4 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 7 -- GCIBindByPos: bind by pos failed.\nExiting!!\n");
		goto EXIT;
	}	
        
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
			GCI_THREADED) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 7 -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf (stdout, "Step 7 done...GCIStmtExecute: Execute delete statement success, delete a record.\n");
	
	
	
	fprintf (stdout, "\n!!!Begin SELECT and retrieve DELETED results stored by row buffer.\n");
    	
	memset(sqlStmt, 0, 1000);
	sprintf(sqlStmt, "SELECT item_num, description, stock, ship_unit FROM item where item_num = :Param");

	if(rc = GCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 8 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if(rc = GCIBindByName(stmthp, &hbind[0], errhp, (sb1 *)"Param", sizeof("Param"), (dvoid *)&param, sizeof(param), SQLT_INT, (dvoid *)0, 
			(ub2 *)0, (ub2 *)0, 0, (ub4 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 8 -- GCIBindByName: bind by name failed.\nExiting!!\n");
		goto EXIT;
	}
	
	/* Retrieve databse rows containing a list */
    if (do_select_storebycol (svchp, stmthp, errhp))
    {
    	fprintf (stdout, "Error in Step 8...select and retrieve results failed.\nExiting!!\n");	
        goto EXIT;
	}
	#endif
    fprintf (stdout, "Step 8 done...select and retrieve results success, no data found.\n");
		

EXIT:

    /* CLEANUP: Close the statement handle
    **          Free the statement handle
    **          Disconnect from the datasource
    **          Free the connection and environment handles
    **          Exit
    */

    	
	if(stmthp)
		GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);	
		
	GCILogoff(svchp, errhp);
	
	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);
	
	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);
	
	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);
	
    fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
    in = getchar ();
    
    return (rc);
}



