/***************************************************************************
*	Licensed Materials - Property of GBase
*
*
*	"Restricted Materials of GBase"
*
*
*
*	GBase 8s GCI Interface demo
*
*
*	Copyright GBase Corporation 2015 All rights reserved.
*
*
*
*
*
*  Title:          test_iudssql.c
*
*  Description:    Testing insert, update, delete func by bind and define.
*
***************************************************************************
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>

#include <sys/syscall.h> 

#include "gci.h"


#define SELSQL_LEN     25
#define ERRMSG_LEN     200

typedef struct
{
   int values;
   GCIEnv *env;
   GCISvcCtx *svc;
   GCIError *err;
}T_tthread;


/*
**  Executes the given select statement and assumes the results will be
**  stored by column buffer.
**
*/
int do_select_storebycol1 ( GCISvcCtx *svchp,
							GCIStmt *stmthp,
							GCIError *errhp)
{
	int rc = 0;
	
    /*  STEP A. Allocate the buffer memory used to retrieve the results,
    *        and stored by column buffer.
    */
	sb4  *key = (sb4 *)malloc(sizeof(sb4) * 100);
	sb1  *desc = (sb1 *)malloc(sizeof(sb4) * 100);

	
	GCIDefine *bndhp[4];	
	
	memset(key, 0, sizeof(sb4) * 100);
	memset(desc, 0, sizeof(sb1) * 20 * 100);

	/**Bind the result set columns -
    **          --  col1 = item_num
    **              col2 = description
    **              col3 = stock
    **              col4 = ship_unit
    */
	if (rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)key, (sb4)sizeof(sb4), (ub2)SQLT_INT,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 1 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 2, (dvoid *)desc, (sb1)4, (ub2)SQLT_INT,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	
	fprintf (stdout, "\tStep A done...GCIDefineByPos: Define handle by pos success.\n");
	
	#if 0
	/*  STEP B. Define array of struct.
    */
	if (rc = GCIDefineArrayOfStruct(bndhp[0], errhp, sizeof(sb4), 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 1 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineArrayOfStruct(bndhp[1], errhp, 20, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 2 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineArrayOfStruct(bndhp[2], errhp, sizeof(sb2), 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 3 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineArrayOfStruct(bndhp[3], errhp, 20, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 4 failed.\nExiting!!\n");
		goto EXIT;
	}
	#endif
	fprintf (stdout, "\tStep B done...GCIDefineArrayOfStruct: Define array of struct success.\n");
	
	
    /*  STEP D. Retrieve the results
    */
    
    sb4 starown = 0;
    
	while(1) 
	{
		ub4 rownum = 0;
		
		if (rc = GCIStmtFetch(stmthp, errhp, 100, GCI_FETCH_NEXT, 0) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;		
			break;
		}
		GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
		
		if(starown == rownum)
			break;
			
		int i;
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving orders row number %d:\n", i + 1);
			fprintf(stdout, "\t\titem_num -- %d\n", *(key + i));
			fprintf(stdout, "\t\tdescription -- %d\n", *(desc + i));


		}
		
		starown = rownum;
	}


SUCCESS_EXIT:

    fprintf (stdout, "\tStep D done...GCIStmtFetch: Retrieve the results success.\n");

EXIT:
	free(key);
	free(desc);	
	
    return rc; /* no error */
}


/*
**  Executes the given select statement and assumes the results will be
**  stored by column buffer.
**
*/
int do_select_storebycol ( GCISvcCtx *svchp,
							GCIStmt *stmthp,
							GCIError *errhp)
{
	int rc = 0;
	
    /*  STEP A. Allocate the buffer memory used to retrieve the results,
    *        and stored by column buffer.
    */
	sb4  *key = (sb4 *)malloc(sizeof(sb4) * 100);
	sb1  *desc = (sb1 *)malloc(sizeof(sb1) * 20 * 100);
	sb2  *stock = (sb2 *)malloc(sizeof(sb2) * 100);
	sb1  *ship = (sb1 *)malloc(sizeof(sb1) * 20 * 100);
	
	GCIDefine *bndhp[4];	
	
	memset(key, 0, sizeof(sb4) * 100);
	memset(desc, 0, sizeof(sb1) * 20 * 100);
	memset(stock, 0, sizeof(sb2) * 100);
	memset(ship, 0, sizeof(sb1) * 20 * 100);

	/**Bind the result set columns -
    **          --  col1 = item_num
    **              col2 = description
    **              col3 = stock
    **              col4 = ship_unit
    */
	if (rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)key, (sb4)sizeof(sb4), (ub2)SQLT_INT,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 1 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 2, (dvoid *)desc, (sb1)20, (ub2)SQLT_STR,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[2], errhp, 3, (dvoid *)stock, (sb2)sizeof(sb2), (ub2)SQLT_INT,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 3 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[3], errhp, 4, (dvoid *)ship, (sb1)20, (ub2)SQLT_STR,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_THREADED) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 4 failed.\nExiting!!\n");
		goto EXIT;
	}	

	fprintf (stdout, "\tStep A done...GCIDefineByPos: Define handle by pos success.\n");
	
	#if 0
	/*  STEP B. Define array of struct.
    */
	if (rc = GCIDefineArrayOfStruct(bndhp[0], errhp, sizeof(sb4), 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 1 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineArrayOfStruct(bndhp[1], errhp, 20, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 2 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineArrayOfStruct(bndhp[2], errhp, sizeof(sb2), 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 3 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineArrayOfStruct(bndhp[3], errhp, 20, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 4 failed.\nExiting!!\n");
		goto EXIT;
	}
	#endif
	fprintf (stdout, "\tStep B done...GCIDefineArrayOfStruct: Define array of struct success.\n");
	
	
    /*  STEP D. Retrieve the results
    */
    
    sb4 starown = 0;
    
	while(1) 
	{
		ub4 rownum = 0;
		
		if (rc = GCIStmtFetch(stmthp, errhp, 100, GCI_FETCH_NEXT, 0) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;		
			break;
		}
		GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
		
		if(starown == rownum)
			break;
			
		int i;
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving row number %d:\n", i + 1);
			fprintf(stdout, "\t\titem_num -- %d\n", *(key + i));
			fprintf(stdout, "\t\tdescription -- %s\n", desc + i * 20);
			fprintf(stdout, "\t\tstock -- %d\n", *(stock + i));
			fprintf(stdout, "\t\tship_unit -- %s\n", ship + i * 20);	
		}
		
		starown = rownum;
	}


SUCCESS_EXIT:

    fprintf (stdout, "\tStep D done...GCIStmtFetch: Retrieve the results success.\n");

EXIT:
	free(key);
	free(desc);	
	free(stock);	
	free(ship);	
	
    return rc; /* no error */
}
void *threadup2(void *value)
{
     ub4    i, in;

    ub1         verInfoBuffer[SELSQL_LEN];
    ub4         verInfoLen;
    ub1         majorVer[3];
    ub4         isUdoEnabled;
    GCIBind *hbind[2] = {NULL};
    ub1     sqlStmt[1000] = {0};
    GCIStmt *stmthp = NULL;
    GCIEnv *envhp = NULL;
    GCISvcCtx *svchp = NULL;
    GCIServer *srvhp = NULL;
    GCIError *errhp = NULL;
    GCISession *usrhp = NULL;
    T_tthread *ttt;
    
    memset(sqlStmt, 0, 1000);
    sprintf(sqlStmt, "SELECT tabid, partnum FROM systables where tabname='orders'");
    ttt = (T_tthread *)value;
    svchp = ttt->svc;
    envhp = ttt->env;
    errhp = ttt->err;
    int rc = GCI_SUCCESS;
    
    
    for (;;)
    {
        printf("++++++++++++++++++++++++++++++++++threadup2 start\n");

        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 6 -- GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");

            return;
        }   
    if(rc = GCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, GCI_THREADED) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;    
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        fprintf(stdout, "Error in Step 6 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");

        return;
    }   
         
       
    if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
            GCI_THREADED) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;    
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        fprintf(stdout, "Error in Step 6 -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");

        return;
    }

    /* Retrieve databse rows containing a list */
    if (do_select_storebycol1 (svchp, stmthp, errhp))
    {
        fprintf (stdout, "Error in Step 7...select and retrieve results failed.\nExiting!!\n"); 

          return;
    }
            if(stmthp)
                GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);

    fprintf (stdout, "Step 7 done...select and retrieve results using GCIBindByName success.\n");
    usleep(5000);
    printf("++++++++++++++++++++++++++++++++++threadup2 end\n");

    }




EXIT:

     

        return;

    
}

void *threadup1(void *value)
{
     ub4    i, in;

    ub1         verInfoBuffer[SELSQL_LEN];
    ub4         verInfoLen;
    ub1         majorVer[3];
    ub4         isUdoEnabled;
    GCIBind *hbind[2] = {NULL};
    ub1     sqlStmt[1000] = {0};
    GCIStmt *stmthp = NULL;
    GCIEnv *envhp = NULL;
    GCISvcCtx *svchp = NULL;
    GCIServer *srvhp = NULL;
    GCIError *errhp = NULL;
    GCISession *usrhp = NULL;
    T_tthread *ttt;
	
	memset(sqlStmt, 0, 1000);
	sprintf(sqlStmt, "SELECT item_num, description,stock,ship_unit FROM item where 1=1");
    ttt = (T_tthread *)value;
    svchp = ttt->svc;
    envhp = ttt->env;
    errhp = ttt->err;
    int rc = GCI_SUCCESS;
    

    for (;;)
    {
        pid_t pid = syscall(SYS_gettid);
        printf("++++++++++++++++++++++++++++++++++threadup1 start  %x\n",(long)pid);
 
        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 6 -- GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");

            return;
        }   
    if(rc = GCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, GCI_THREADED) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;    
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        fprintf(stdout, "Error in Step 6 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");

        return;
    }   
         
       
    if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
            GCI_THREADED) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;    
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        fprintf(stdout, "Error in Step 6 -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");

        return;
    }

    /* Retrieve databse rows containing a list */
    if (do_select_storebycol (svchp, stmthp, errhp))
    {
        fprintf (stdout, "Error in Step 7...select and retrieve results failed.\nExiting!!\n"); 

          return;
    }
            if(stmthp)
                GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);

    fprintf (stdout, "Step 7 done...select and retrieve results using GCIBindByName success.\n");
    //usleep(500);
    printf("++++++++++++++++++++++++++++++++++threadup1 end\n");

    }




EXIT:

     

        return;

    
}

//static char *proc_name = "testproc"
int testprintallprocname(GCIEnv * envhp, GCIError * errhp, GCISvcCtx * svchp)
{
    int rc = 0;
    GCIDescribe * desc = NULL;
    GCIStmt * stmt = NULL;
    char * pkg_name = "test";
    GCIParam * package = NULL;
    GCIParam * subprogs = NULL;
    int nums_progs = 0;

    printf("testprintallprocname entry %d %d\n", envhp, svchp);
    rc = GCIHandleAlloc((dvoid *) envhp, (dvoid * *) &desc, (ub4) GCI_HTYPE_DESCRIBE, (size_t) 0, (dvoid * *) 0);
    if (GCI_SUCCESS != rc)
    {
        printf("get the desc handle failedd\n");
        goto testprintallprocnameEXIT;
    }
    printf("testprintallprocname handle alloc desc %d\n", desc);
    if (rc = GCIHandleAlloc((dvoid *) envhp, (dvoid * *) &stmt, 
        GCI_HTYPE_STMT, 0, (dvoid * *) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto testprintallprocnameEXIT;
    }
    printf("testprintallprocname handle stmt %d\n", stmt);

    //ʼ
    rc = GCIDescribeAny(svchp, errhp, (dvoid *) pkg_name, (ub4) strlen(pkg_name), (ub1) GCI_OTYPE_NAME, 
        (ub1) GCI_DEFAULT, (ub1) GCI_PTYPE_PKG, desc);
    if (rc)
    {
        sb1 errmsg[256] =
        {
            0
        },
        errstate[256] =
        {
            0
        };
        sb4 errcode;

        fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get pkg handle failed.\nExiting!!\n");
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto testprintallprocnameEXIT;
    }
    printf("testprintallprocname GCIAttrGet GCI_HTYPE_DESCRIBE 's GCI_ATTR_PARAM  \n");
    rc = GCIAttrGet((CONST dvoid *) desc, (ub4) GCI_HTYPE_DESCRIBE, (dvoid *) &package, (ub4 *) 0, 
        (ub4) GCI_ATTR_PARAM, (GCIError *) errhp);
    if (rc)
    {
        fprintf(stdout, "Error in test getprocdesc- GCIAttrGet: get pkg param failed.\nExiting!!\n");
        goto testprintallprocnameEXIT;
    }
    if (package) fprintf(stdout, "succ in test getprocdesc- get package param ok %d!!\n", package);
    rc = GCIAttrGet((CONST dvoid *) package, (ub4) GCI_DTYPE_PARAM, (dvoid *) &subprogs, (ub4 *) 0, 
        (ub4) GCI_ATTR_LIST_SUBPROGRAMS, (GCIError *) errhp);
    if (rc)
    {
        fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get pkg handle failed.\nExiting!!\n");
        goto testprintallprocnameEXIT;
    }
    fprintf(stdout, "succ in test getprocdesc- get package param GCI_ATTR_LIST_SUBPROGRAMS ok!!\n");
    rc = GCIAttrGet((CONST dvoid *) subprogs, (ub4) GCI_DTYPE_PARAM, (dvoid *) &nums_progs, (ub4 *) 0, 
        (ub4) GCI_ATTR_NUM_PARAMS, (GCIError *) errhp);
    if (rc)
    {
        fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get progs nums failed.\nExiting!!\n");
        goto testprintallprocnameEXIT;
    }
    fprintf(stdout, "succ in test getprocdesc- get package param GCI_ATTR_LIST_SUBPROGRAMS's nums %d !!\n", 
        nums_progs);
    int i = 0;
    GCIParam * routine = NULL;
    GCIParam * param_list = NULL;
    GCIParam * arg = NULL;
    ub1 type = 0;
    char * name = NULL;
    ub4 namelen = 0;
    ub4 numargs = 0;
    ub1 precision = 0;
    ub1 scale = 0;

    for (i = 0; i < nums_progs; i++)
    {
        rc = GCIParamGet((CONST dvoid *) subprogs, (ub4) GCI_DTYPE_PARAM, (GCIError *) errhp, (dvoid * *) &routine, 
            (ub4) i);
        if (rc)
        {
            fprintf(stdout, "Error in test getprocdesc-GCIParamGet  get progs param pos %d  failed.\nExiting!!\n", i);
            goto testprintallprocnameEXIT;
        }
        rc = GCIAttrGet((CONST dvoid *) routine, (ub4) GCI_DTYPE_PARAM, (dvoid *) &type, (ub4 *) 0, 
            (ub4) GCI_ATTR_PTYPE, (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get progs nums failed.\nExiting!!\n");
            goto testprintallprocnameEXIT;
        }
        rc = GCIAttrGet((CONST dvoid *) routine, (ub4) GCI_DTYPE_PARAM, (dvoid *) &name, (ub4 *) &namelen, 
            (ub4) GCI_ATTR_NAME, (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get progs name failed.\nExiting!!\n");
            goto testprintallprocnameEXIT;
        }
        fprintf(stdout, "testprintallprocname progs name  == %s,type = %d,pos = %d!!\n", name, type, i);
    }
    
testprintallprocnameEXIT:
    if (desc) GCIHandleFree(desc, GCI_HTYPE_DESCRIBE);
    if (stmt) GCIHandleFree((dvoid *) stmt, GCI_HTYPE_STMT);
    fprintf(stdout, "printf all procedures quit!\n");
    return rc;
}


//test 
void *threadup(void *value)
{
     ub4	i, in;

    ub4 param = 9001;
    ub1         verInfoBuffer[SELSQL_LEN];
    ub4			verInfoLen;
    ub1         majorVer[3];
    ub4      	isUdoEnabled;
    GCIBind *hbind[2] = {NULL};
    ub1		sqlStmt[1000] = {0};
    GCIStmt *stmthp = NULL;
    GCIEnv *envhp = NULL;
    GCISvcCtx *svchp = NULL;
    GCIServer *srvhp = NULL;
    GCIError *errhp = NULL;
    GCISession *usrhp = NULL;
    T_tthread *ttt;
    
     
     memset(sqlStmt, 0, 1000);
     sprintf(sqlStmt, "SELECT item_num, description,stock,ship_unit FROM item where 1=1");
     ttt = (T_tthread *)value;
     svchp = ttt->svc;
     envhp = ttt->env;
    errhp = ttt->err;    
 
     int rc = GCI_SUCCESS;
     
    for (;;)
    {
        pid_t pid = syscall(SYS_gettid);
        printf("++++++++++++++++++++++++++++++++++threadup start  %x\n",(long)pid);        
  
        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 6 -- GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
        
            return;
        }  

         //testprintallprocname(envhp, errhp, svchp);
         //execute proc
         char *procexec = "execute procedure tr7in(1)";
        if(rc = GCIStmtPrepare(stmthp, errhp, procexec, sizeof(procexec), 0, GCI_THREADED) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;    
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            fprintf(stdout, "Error in Step 6 -- GCIStmtPrepare: procexec stmp handle failed.\nExiting!!\n");

           // goto EXIT;
        }            
        if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
                GCI_THREADED) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;    
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            fprintf(stdout, "Error in Step 6 -- GCIStmtExecute: procexec sql statement failed.\nExiting!!\n");
           // goto EXIT;

        }         
        
        if(stmthp)
            GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
       
          //usleep(200);

   }
	
EXIT:
        if(stmthp)
            GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
    
        
        return;
    
}


/*
 * This function allocates the row and collection buffers, passes
 * them to the do_select_storebyxxx() function, along with an appropriate select
 * statement and then frees all allocated handles.
 */

int main (long argc,
          char* argv[])
{
   /* Declare variables */

    ub4			i, in;

    ub1         verInfoBuffer[SELSQL_LEN];
    ub4			verInfoLen;
    ub1         majorVer[3];
    ub4      	isUdoEnabled;
   
    ub1		sqlStmt[1000] = {0};
    
    ub1  nonUdoItem[1000] = {"(9001,'Testing shoes',250,'Pair','270.00',\
 'Super shock-absorbing gel pads disperse vertical energy into a horizontal plane\
 for extraordinary cushioned comfort. Great motion control. Mens only. Specify size.')"};

    /* Handles */
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;
	GCIStmt *stmthp = NULL;
    T_tthread tt[2];

	int rc = GCI_SUCCESS;

	GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";
        ub4 value1 = 650;
        ub4 value2 = 700;
        pthread_t thread[2];

      
    /*  STEP 1. Get data source name from command line (or use default)
    **          Allocate the environment handle and set ODBC version
    **          Allocate the connection handle
    **          Establish the database connection
    **          Allocate the statement handle
    **          Drop demo database if it already exists
    */

	/* initialize the mode to be the threaded and object environment */
	if((rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
			0, 0, 0, (size_t) 0, (dvoid **)0) )!= GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
			GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
			GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto EXIT;
	}

	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
			pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto EXIT;
	}
	
   
	
 

	

	/* Allocate the statement handle */ 
    tt[0].values = value1;
    tt[0].svc = svchp;
    tt[0].env = envhp;
    tt[0].err = errhp;

    tt[1].values = value2;
    tt[1].svc = svchp;
        tt[1].env = envhp;
       tt[1].err = errhp;

       if(rc=pthread_create(&thread[0],NULL,threadup,(void *)&tt[0])!=0)
       {
          fprintf(stdout,"thread 1 create error\n");
       }

//      sleep(1);
       if(rc=pthread_create(&thread[1],NULL,threadup1,(void *)&tt[1])!=0)
       {
          fprintf(stdout,"thread 2 create error\n");
       }

        pthread_join(thread[1],NULL);
        pthread_join(thread[0],NULL);
        

    fprintf (stdout, "Step 8 done...select and retrieve results success, no data found.\n");
		

EXIT:

    /* CLEANUP: Close the statement handle
    **          Free the statement handle
    **          Disconnect from the datasource
    **          Free the connection and environment handles
    **          Exit
    */

    	
	if(stmthp)
		GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);	
		
	GCILogoff(svchp, errhp);
	
	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);
	
	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);
	
	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);
	
    fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
    in = getchar ();
    
    return (rc);
}



