/***************************************************************************
 *	Licensed Materials - Property of GBase
 *
 *
 *	"Restricted Materials of GBase"
 *
 *
 *
 *	GBase 8s GCI Interface demo
 *
 *
 *	Copyright GBase Corporation 2015 All rights reserved.
 *
 *
 *
 *
 *
 *  Title:          test_rcselect.c
 *
 *  Description:    To retrieve results from the database and display it. 
 *                  This example also illustrates the fact
 *                  that the same client functions can use row and column
 *                  store buffer.
 *
 ***************************************************************************
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "gci.h"

#define SELSQL_LEN     25
#define ERRMSG_LEN     200



/*
 **  Executes the given select statement and assumes the results will be
 **  stored by column buffer.
 **
 */
int do_select_storebycol (  GCISvcCtx *svchp,
		GCIStmt *stmthp,
		GCIError *errhp)
{
	int rc = 0;

	/*  STEP A. Allocate the buffer memory used to retrieve the results,
	 *        and stored by column buffer.
	 */
	sb4  *key = (sb4 *)malloc(sizeof(sb4) * 100);
	sb1  *desc = (sb1 *)malloc(sizeof(sb1) * 20 * 100);
	sb8  *stock = (sb8 *)malloc(sizeof(sb8) * 100);
	sb1  *ship = (sb1 *)malloc(sizeof(sb1) * 20 * 100);	
	sb4 *rownums = (sb4 *)malloc(sizeof(sb4) * 100);
	GCIDefine *bndhp[5];	
    int starown;
	int i;
	memset(key, 0, sizeof(sb4) * 100);
	memset(desc, 0, sizeof(sb1) * 20 * 100);
	memset(stock, 0, sizeof(sb8) * 100);
	memset(ship, 0, sizeof(sb1) * 20 * 100);	
	memset(rownums, 0, sizeof(sb4) * 100);	

	/**Bind the result set columns -
	 **          --  col1 = item_num
	 **              col2 = description
	 **              col3 = stock
	 **              col4 = ship_unit
	 */
	if (rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)key, (sb4)sizeof(sb4), (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 1 failed.\nExiting!!\n");
		goto EXIT;
	}

	if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 2, (dvoid *)desc, (sb1)20, (ub2)SQLT_STR,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto EXIT;
	}
#if 1
	if (rc = GCIDefineByPos(stmthp, &bndhp[2], errhp, 3, (dvoid *)stock, (sb2)8, (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 3 failed.\nExiting!!\n");
		goto EXIT;
	}

	if (rc = GCIDefineByPos(stmthp, &bndhp[3], errhp, 4, (dvoid *)ship, (sb1)20, (ub2)SQLT_STR,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 4 failed.\nExiting!!\n");
		goto EXIT;
	}	
	if (rc = GCIDefineByPos(stmthp, &bndhp[4], errhp, 5, (dvoid *)rownums,4, (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 3 failed.\nExiting!!\n");
		goto EXIT;
	}
#endif
	fprintf (stdout, "\tStep A done...GCIDefineByPos: Define handle by pos success.\n");


	/*  STEP B. Define array of struct.
	*/
/*	if (rc = GCIDefineArrayOfStruct(bndhp[0], errhp, sizeof(sb4), 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 1 failed.\nExiting!!\n");
		goto EXIT;
	}

	if (rc = GCIDefineArrayOfStruct(bndhp[1], errhp, 20, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 2 failed.\nExiting!!\n");
		goto EXIT;
	}

	if (rc = GCIDefineArrayOfStruct(bndhp[2], errhp, sizeof(sb2), 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 3 failed.\nExiting!!\n");
		goto EXIT;
	}

	if (rc = GCIDefineArrayOfStruct(bndhp[3], errhp, 20, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 4 failed.\nExiting!!\n");
		goto EXIT;
	}	

	fprintf (stdout, "\tStep B done...GCIDefineArrayOfStruct: Define array of struct success.\n");
*/

	/*  STEP C. Execut the select statement    
	*/   
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step C -- GCIStmtExecute: execute select statement failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf (stdout, "\tStep C done...GCIStmtExecute: Execute select statement success.\n");


	/*  STEP D. Retrieve the results
	*/
		fprintf(stdout, "\t show the colname convert!!\n");

	#if 0
	//ȡcolname

	sb4 colnum11 = 0;
	if (rc = GCIAttrGet (stmthp, GCI_HTYPE_STMT,&colnum11, 0,GCI_ATTR_NUM_COLS,errhp) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto EXIT;
	}	
	char *colname = {0};
	printf("show the colname :colnum %d\n",colnum11);
	if (rc = GCIAttrGet (stmthp, GCI_HTYPE_STMT,colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
		{
			ub1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto EXIT;
		}	
	GCIParam *param = NULL;
	for(i = 0;i< colnum11;i++)
	{
		rc = GCIParamGet((CONST dvoid *)stmthp,(ub4)GCI_HTYPE_STMT,(GCIError *)errhp,(dvoid **)&param,(ub4)i+1);

		
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
		{
			ub1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto EXIT;
		}	
		fprintf(stdout, "show the colname %s \n",colname);
		memset(colname,0 ,sizeof(colname));
	}


#endif
	starown = 0;

	while(1) 
	{
		ub4 rownum = 0;

		if ((rc = GCIStmtFetch(stmthp, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep Da jlaksjdf done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;
			break;
		}
		rc = GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		printf("rownum %d\n",rownum);
		if((-1 == rownum )||(starown == rownum))
			break;
			
#if 1
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving row number %d:\n", i + 1);
			fprintf(stdout, "\t\titem_num -- %d\n", *(key + i));
			fprintf(stdout, "\t\tdescription -- %s\n", desc + i * 20);
			fprintf(stdout, "\t\tstock -- %ld\n", (sb8)*(stock + i));
			fprintf(stdout, "\t\tship_unit -- %s\n", ship + i * 20);
                        fprintf(stdout, "\t\trownum -- %d\n", *(rownums + i));
		}
#endif
		starown = rownum;
	}

SUCCESS_EXIT:

	fprintf (stdout, "\tStep D done...GCIStmtFetch: Retrieve the results success.\n");

EXIT:
	free(key);
	key = NULL;
	free(desc);
	desc= NULL;
	free(stock);
	stock = NULL;
	free(ship);
	ship = NULL;
	free(rownums);
	rownums = NULL;

	return rc; /* no error */
}
/*
 **  Executes the given select statement and assumes the results will be
 **  stored by column buffer.
 **
 */
int do_select_storebycol1 (  GCISvcCtx *svchp,
		GCIStmt *stmthp,
		GCIError *errhp)
{
	int rc = 0;

	/*  STEP A. Allocate the buffer memory used to retrieve the results,
	 *        and stored by column buffer.
	 */
	sb4  *key = (sb4 *)malloc(sizeof(sb4) * 100);
	sb1  *desc = (sb1 *)malloc(sizeof(sb1) * 20 * 100);
	sb8  *stock = (sb8 *)malloc(sizeof(sb8) * 100);
	sb1  *ship = (sb1 *)malloc(sizeof(sb1) * 20 * 100);	
	sb4 *rownums = (sb4 *)malloc(sizeof(sb4) * 100);
	GCIDefine *bndhp[5];	
	sb4 starown;

	memset(key, 0, sizeof(sb4) * 100);
	memset(desc, 0, sizeof(sb1) * 20 * 100);
	memset(stock, 0, sizeof(sb8) * 100);
	memset(ship, 0, sizeof(sb1) * 20 * 100);	
	memset(rownums, 0, sizeof(sb4) * 100);	

	/**Bind the result set columns -
	 **          --  col1 = item_num
	 **              col2 = description
	 **              col3 = stock
	 **              col4 = ship_unit
	 */
	if (rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)key, (sb4)sizeof(sb4), (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 1 failed.\nExiting!!\n");
		goto EXIT;
	}

	if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 2, (dvoid *)desc, (sb1)20, (ub2)SQLT_STR,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto EXIT;
	}
	fprintf (stdout, "\tStep A done...GCIDefineByPos: Define handle by pos success.\n");


	/*  STEP B. Define array of struct.
	*/


	/*  STEP C. Execut the select statement    
	*/   
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step C -- GCIStmtExecute: execute select statement failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf (stdout, "\tStep C done...GCIStmtExecute: Execute select statement success.\n");


	/*  STEP D. Retrieve the results
	*/
		fprintf(stdout, "\t show the colname convert!!\n");

	starown = 0;

	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmthp, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep Da jlaksjdf done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;
			break;
		}
		rc = GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		printf("rownum %d\n",rownum);
		if((-1 == rownum )||(starown == rownum))
			break;

#if 1
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving row number %d:\n", i + 1);
			fprintf(stdout, "\t\titem_num -- %d\n", *(key + i));
			fprintf(stdout, "\t\tdescription -- %s\n", desc + i * 20);
                        fprintf(stdout, "\t\trownum -- %d\n", *(rownums + i));
		}
#endif
		starown = rownum;
	}

SUCCESS_EXIT:

	fprintf (stdout, "\tStep D done...GCIStmtFetch: Retrieve the results success.\n");

EXIT:
	free(key);
	key = NULL;
	free(desc);
	desc= NULL;
	free(stock);
	stock = NULL;
	free(ship);
	ship = NULL;
	free(rownums);
	rownums = NULL;

	return rc; /* no error */
}


int do_select_ext_test(GCIEnv *envhp,  GCISvcCtx *svchp,
		GCIStmt *stmthp1,
		GCIError *errhp,
		char *selstr)
{
	GCIDefine *bndhp[5];
	char col[100];
	int rc = 0;
	sb4 starown;
	GCIStmt *stmthp = NULL;
		/* Allocate the statement handle */    
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle 1 failed.\nExiting!!\n");
		goto do_select_ext_testEXIT;
	}	
	if(rc = GCIStmtPrepare(stmthp, errhp, (GCIText *)selstr, sizeof(selstr), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
		goto do_select_ext_testEXIT;
	}	
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step C -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto do_select_ext_testEXIT;
	}	
	if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 1, (dvoid *)col, 100, (ub2)SQLT_CHR,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto do_select_ext_testEXIT;
	}
	if (rc = GCIDefineArrayOfStruct(bndhp[1], errhp, 100, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 1 failed.\nExiting!!\n");
		goto do_select_ext_testEXIT;
	}

	starown = 0;

	while(1) 
	{
		ub4 rownum = 0;
		if (rc = GCIStmtFetch(stmthp, errhp, 100, GCI_FETCH_NEXT, 0) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;

			break;
		}
		GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(starown == rownum)
			break;


		{	
			fprintf(stdout, "\t\t Retrieving selext test time-- %s\n",col );
		}

		starown = rownum;

	}	
	GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
	
	printf("============do_select_ext_test\n %s\n",selstr);
	return rc;
do_select_ext_testEXIT:
	printf("---------------do_select_ext_test failed\n %s\n",selstr);
	GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
	return rc;
	
}
int do_select_ext( GCIEnv *envhp, GCISvcCtx *svchp,
		GCIStmt *stmthp,
		GCIError *errhp)
{
	int i = 0;
	int rc = 0;
	char selext[30];
	
	char selectStmt[][100] ={ "select sysdate+1 units day",
"select MAX(1)",//	char *selectStmt2 = 
"select 12*10 + 1",
"select MAX(1) as largest",
"select sysdate today",
	
"select sysdate as table",
"select sysdate table",
"select sysdate where 1=1",
"select sysdate from dual where 1=1 ",
"select sysdate from gbasedbt.dual where 1=1 "
		};
	
	//for (i = 0;i < 11;i++)
	{
	printf("sel extend syntax test:\n%s\n",selectStmt[8]);		
		do_select_ext_test(envhp,svchp,stmthp,errhp,selectStmt[8]);
	}

	printf("sel extend syntax test end\n");	
	return rc;
}
int do_select_ext_plus( GCIEnv *envhp, GCISvcCtx *svchp,
		GCIStmt *stmthp1,
		GCIError *errhp)
{
	int i = 0;
	int rc = 0;
	char selext[30];
	char * createt1 = "create table t1 as(select 1 as field1 from dual union \
		                                                 select 2 as field1 from dual union \
		                                                  select 3 as field1 from dual)";
	char * createt2 = "create table t2 as(select 1 as field2 from dual union \
		                                                 select 3 as field2 from dual union \
		                                                 select 4 as field2 from dual)";	                                              

	char *selectplus = "select  field2,field1 from t1,t2 where t1.field1 = t2.field2(+)";

 	GCIDefine *bndhp[5];
	
	char col[200],col1[200];
	char *p1 = NULL;
	char * p2 = NULL;
	sb2 aInd[10];
	sb2 aInd1[10];
	char *Ind1 = NULL;
	char *Ind2 = NULL;
	sb4 colnum11;
	GCIStmt *stmthp;
	sb4 starown;
	char colname[64] = {0};
		/* Allocate the statement handle */    
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle 1 failed.\nExiting!!\n");
		goto do_select_ext_plus_testEXIT;
	}	
	if(rc = GCIStmtPrepare(stmthp, errhp, (GCIText *)selectplus, sizeof(selectplus), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
		goto do_select_ext_plus_testEXIT;
	}
	if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 1, (dvoid *)col, 10, (ub2)SQLT_CHR,
				(dvoid *)aInd, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto do_select_ext_plus_testEXIT;
	}
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step C -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto do_select_ext_plus_testEXIT;
	}	

	if (rc = GCIDefineByPos(stmthp, &bndhp[2], errhp, 2, (dvoid *)col1, 10, (ub2)SQLT_CHR,
				(dvoid *)aInd1, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto do_select_ext_plus_testEXIT;
	}	

	//ȡcolname
	fprintf(stdout, "\t show the colname convert!!\n");
	colnum11 = 0;
	if (rc = GCIAttrGet (stmthp, GCI_HTYPE_STMT,&colnum11, 0,GCI_ATTR_COL_COUNT,errhp) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto do_select_ext_plus_testEXIT;
	}	

	for(i = 0;i< colnum11;i++)
	{
		if (rc = GCIAttrGet (stmthp, GCI_DTYPE_PARAM,colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
		{
			ub1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;

			GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto do_select_ext_plus_testEXIT;
		}	
		fprintf(stdout, "show the colname %s \n",colname);
		memset(colname,0 ,sizeof(colname));
	}

	starown = 0;

	while(1) 
	{
		ub4 rownum = 0;
		if ((rc = GCIStmtFetch(stmthp, errhp, 10, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			
			//goto do_select_ext_plus_testEXIT;
			break;
		}
		if(rc == GCI_ERROR)
		{
			ub1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;

			fprintf (stdout, "\tStep D done...GCIStmtFetch: eRROR found...\n");
		    GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		    fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
			
			goto do_select_ext_plus_testEXIT;
		}
		GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(starown == rownum)
			break;
		if(rownum > 10)
		{
			rownum = 10;
		}
		
		for(i = 0;i <rownum;i++)
		{	

			fprintf(stdout, " Retrieving indicator  \t\t--ind1 %d,%d\n",aInd[i],i);
			fprintf(stdout, " Retrieving indicator  \t\t--ind2 %d,%d\n",aInd1[i],i);
			fprintf(stdout, " Retrieving selext plus test \n \t\tcol1-- %s\n",col + i*10 );
			fprintf(stdout, "\t\t col2-- %s\n",col1 + i*10 );
		}

		starown = rownum;

	}	
	//GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
//hang
	fprintf(stdout, "rows test begin\n");
	#if 1
	p1 = col;
	//Ind1 = col+10;
	p2 = col +10;
//	Ind2 = p2 +4;
	//if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	//{
	//	fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle 1 failed.\nExiting!!\n");
	//	goto do_select_ext_plus_testEXIT;
	//}	
	if(rc = GCIStmtPrepare(stmthp, errhp, (GCIText *)selectplus, sizeof(selectplus), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
		goto do_select_ext_plus_testEXIT;
	}
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step C -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto do_select_ext_plus_testEXIT;
	}		
    if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 1, (dvoid *)p1, 10, (ub2)SQLT_CHR,
				(dvoid *)aInd, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto do_select_ext_plus_testEXIT;
	}
    if (rc = GCIDefineByPos(stmthp, &bndhp[2], errhp, 2, (dvoid *)p2, 10, (ub2)SQLT_CHR,
				(dvoid *)aInd1, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto do_select_ext_plus_testEXIT;
	}	
		fprintf(stdout, "rows test begin 3\n");
	if ((rc = GCIDefineArrayOfStruct(bndhp[2], errhp, 28, 0, 0, 0)) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 1 failed.\nExiting!!\n");
		goto do_select_ext_plus_testEXIT;
	}

	starown = 0;

	while(1) 
	{
		sb4 rownum = 0;
		sb4 errcode;
		ub1 errmsg[256] = {0}, errstate[256] = {0};

		if ((rc = GCIStmtFetch(stmthp, errhp, 10, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			
			break;
		}
		if(rc == GCI_ERROR)
		{

			fprintf (stdout, "\tStep D done...GCIStmtFetch: eRROR found...\n");
	        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		    fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
			
			goto do_select_ext_plus_testEXIT;
		
		}
		GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(starown == rownum)
			break;
		
		for(i = 0;i <rownum;i++)
		{	

			fprintf(stdout, " Retrieving indicator  \t\t--ind1 %d\n",aInd[i]);
			fprintf(stdout, " Retrieving indicator  \t\t--ind2 %d\n",aInd1[i]);
			fprintf(stdout, " Retrieving selext plus test \n \t\tcol1-- %s\n",p1+28*i );
			fprintf(stdout, "\t\t col2-- %s\n",p2+28*i );
		}

		starown = rownum;
	}
	#endif
	GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
	
	printf("============do_select_ext_plus_test\n\n");
	
	return 0;
do_select_ext_plus_testEXIT:
	printf("---------------do_select_ext_plus_test failed\n\n");
	//GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
	return rc;


}
int do_select_storebyrow_realloc (  GCISvcCtx *svchp,
		GCIStmt *stmthp,
		GCIError *errhp)
{
	int rc = 0;
	int nmemcount = 1;
	int nrowcount = 2;
	int nfetchcount = 0;
	GCIDefine *bndhp[5] = {0,0,0,0,0};
	
	int rowsize = sizeof(sb4) + sizeof(sb1) * 20 + sizeof(sb8) + sizeof(sb1) * 20+sizeof(sb4);
//	int rowsize = sizeof(sb4) + sizeof(sb1) * 20 + sizeof(sb4) + sizeof(sb1) * 20;
	sb1 *buff = (sb1 *)malloc(rowsize * nrowcount);
	sb2 *indptr = NULL;
	sb2 *indptr1 = NULL;
	sb1 *buff2 = (sb1 *)malloc(rowsize * nrowcount); 
	sb4 *key = (sb4 *)(buff+(nmemcount - 1)* nrowcount* rowsize);
	sb1 *desc = (sb1 *)((sb1 *)key + sizeof(sb4));
	sb8 *stock = (sb8 *)(desc + sizeof(sb1) * 20);
	sb1 *ship = (sb1 *)((sb1 *)stock + sizeof(sb8));	
	sb4 *rownums= (sb4 *)((sb1 *)ship + sizeof(sb1)*20);	
	ub4 rownum = 0;
	int i = 0;
	/*  STEP C. Execut the select statement    
	*/
	indptr = (sb2 *)malloc(sizeof(sb2)*5 * nrowcount);
	indptr1 = indptr;
	memset(buff, 0, rowsize * nrowcount);
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step C -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto EXIT;
	}
	for(rownum = 1;rownum < 5;rownum++)
	{
		sb1 * tmp = buff2;
		buff2 = (sb1 *)realloc(buff2,(rownum+ 1)*rowsize * nrowcount); 
		if(NULL == buff2)
		{
			free(tmp);
		}
	}
	if(buff2)
		free(buff2);
	buff2 = NULL;
	
	while(1) 
	{
		key = (sb4 *)(buff+(nmemcount - 1)* nrowcount* rowsize);

		desc = (sb1 *)((sb1 *)key + sizeof(sb4));
		stock = (sb8 *)(desc + sizeof(sb1) * 20);
		ship = (sb1 *)((sb1 *)stock + sizeof(sb8));	
		rownums= (sb4 *)((sb1 *)ship + sizeof(sb1)*20);	
		indptr1 = (sb2 *)((sb1 *)indptr+ (nmemcount - 1)* sizeof(sb2)*5 * nrowcount);

		/**Bind the result set columns -
		 **          --  col1 = item_num
		 **              col2 = description
		 **              col3 = stock
		 **              col4 = ship_unit
		 */
		if (rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)key, 4, (ub2)SQLT_INT,
					(dvoid *)indptr1, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
		{
			ub1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 1 failed.\nExiting!!\n");
			goto EXIT;
		}

		if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 2, (dvoid *)desc, 20, (ub2)SQLT_STR,
					(dvoid *)(indptr1+1), (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
		{
			ub1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto EXIT;
		}

		if (rc = GCIDefineByPos(stmthp, &bndhp[2], errhp, 3, (dvoid *)stock, 8, (ub2)SQLT_INT,
					(dvoid *)(indptr1+2), (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
		{
			ub1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 3 failed.\nExiting!!\n");
			goto EXIT;
		}

		if (rc = GCIDefineByPos(stmthp, &bndhp[3], errhp, 4, (dvoid *)ship, 20, (ub2)SQLT_STR,
					(dvoid *)(indptr1+3), (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
		{
			ub1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 4 failed.\nExiting!!\n");
			goto EXIT;
		}	
		
		if (rc = GCIDefineByPos(stmthp, &bndhp[4], errhp, 5, (dvoid *)rownums,4, (ub2)SQLT_INT,
					(dvoid *)(indptr1+4), (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
		{
			ub1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 3 failed.\nExiting!!\n");
			goto EXIT;
		}
		fprintf (stdout, "\tStep A done...GCIDefineByPos: Define handle by pos success.\n");


		/*  STEP B. Define array of struct.
		*/
		if (rc = GCIDefineArrayOfStruct(bndhp[0], errhp, rowsize,sizeof(sb2)*5 , 0, 0) != GCI_SUCCESS)
		{
			fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 1 failed.\nExiting!!\n");
			goto EXIT;
		}

		if (rc = GCIDefineArrayOfStruct(bndhp[1], errhp, rowsize,sizeof(sb2)*5 , 0, 0) != GCI_SUCCESS)
		{
			fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 2 failed.\nExiting!!\n");
			goto EXIT;
		}

		if (rc = GCIDefineArrayOfStruct(bndhp[2], errhp, rowsize,sizeof(sb2)*5 , 0, 0) != GCI_SUCCESS)
		{
			fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 3 failed.\nExiting!!\n");
			goto EXIT;
		}

		if (rc = GCIDefineArrayOfStruct(bndhp[3], errhp, rowsize,sizeof(sb2)*5 , 0, 0) != GCI_SUCCESS)
		{
			fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 4 failed.\nExiting!!\n");
			goto EXIT;
		}
		if (rc = GCIDefineArrayOfStruct(bndhp[4], errhp, rowsize,sizeof(sb2)*5 , 0, 0) != GCI_SUCCESS)
		{
			fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 4 failed.\nExiting!!\n");
			goto EXIT;
		}

	/*  STEP D. Retrieve the results
	*/

	       //goto  EXIT;
		//°
		if ((rc = GCIStmtFetch(stmthp, errhp, 2, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
		GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(rc != GCI_NO_DATA &&rc != GCI_ERROR)
		{

			char *tmp = (char *)indptr;		
			char *tmp1 = (char *)buff;
			nmemcount++;
	
			indptr = (sb2 *)realloc((sb1 *)indptr,(nmemcount*sizeof(sb2 )*5 * nrowcount));
			if(!indptr)
			{
				free(tmp);
				break;
			}
			buff = (sb1 *)realloc (buff, nmemcount* nrowcount* rowsize);
			if(!buff)
			{
				free(tmp1);
				break;
			}
			memset(buff+(nmemcount - 1)* nrowcount* rowsize, 0, rowsize * nrowcount); 
			memset((sb1 *)indptr+(nmemcount - 1)*sizeof(sb2)*5 * nrowcount, 0, sizeof(sb2)*5 * nrowcount); 
			printf("current rownum %d nmemcount %d\n",rownum,nmemcount);

		}
	}

SUCCESS_EXIT:

		key = (sb4 *)(buff);

		desc = (sb1 *)((sb1 *)key + sizeof(sb4));
		stock = (sb8 *)(desc + sizeof(sb1) * 20);
		ship = (sb1 *)((sb1 *)stock + sizeof(sb8));	
		rownums= (sb4 *)((sb1 *)ship + sizeof(sb1)*20);		
	for(i=0; i<rownum; i++)
	{	
		fprintf(stdout, "\tRetrieving row number %d:\n", i + 1);
		fprintf(stdout, "\t\titem_num -- %d\n", *(sb4 *)((sb1 *)key + i * rowsize));
		fprintf(stdout, "\t\tdescription -- %s\n", desc + i * rowsize);
		fprintf(stdout, "\t\tstock -- %ld\n", *(sb8 *)((sb1 *)stock + i * rowsize));
		fprintf(stdout, "\t\tship_unit -- %s\n", ship + i * rowsize);
		fprintf(stdout, "\t\trownum -- %d\n", *(sb4 *)((sb1 *)rownums + i * rowsize));
	}	

	fprintf (stdout, "\tStep D done...GCIStmtFetch: Retrieve the results success.\n");

EXIT:
	if(buff)
		free(buff);
	if(indptr)
		free(indptr);
	return rc; /* no error */

}

    int do_select_rownum (  GCISvcCtx *svchp,
		GCIStmt *stmthp,
		GCIError *errhp)
{
	int rowsize = sizeof(sb4);
//	int rowsize = sizeof(sb4) + sizeof(sb1) * 20 + sizeof(sb4) + sizeof(sb1) * 20;
	sb1 *buff = (sb1 *)malloc(rowsize * 100);
	GCIDefine *bndhp[5];
    int  rc = 0;
	sb4  *rownums;
	sb4 starown;

	memset(buff, 0, rowsize * 100);    
    rownums = (sb4 *)buff;	
    /**Bind the result set columns -
	 **          --  col1 = item_num
	 **              col2 = description
	 **              col3 = stock
	 **              col4 = ship_unit
	 */
	if ((rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)rownums, sizeof(sb4), (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) )!= GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 1 failed.\nExiting!!\n");
		goto EXIT;
	}
    
/*  STEP C. Execut the select statement    
	*/
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step C -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf (stdout, "\tStep C done...GCIStmtExecute: Execute select statement success.\n");

	/*  STEP D. Retrieve the results
	*/

	starown = 0;

	while(1) 
	{
		ub4 rownum = 0;
		int i;
		if ((rc = GCIStmtFetch(stmthp, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
		GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(starown == rownum)
			break;

		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving row number %d:\n", i + 1);
			fprintf(stdout, "\t\trownums -- %d\n", *(sb4 *)(rownums + i ));
		}

		starown = rownum;
	}

SUCCESS_EXIT:

	fprintf (stdout, "\tStep D done...GCIStmtFetch: Retrieve the results success.\n");

EXIT:
	free(buff);

	return rc; /* no error */
}
/*
 **  Executes the given select statement and assumes the results will be
 **  stored by row buffer.
 **
 */
int do_select_storebyrow (  GCISvcCtx *svchp,
		GCIStmt *stmthp,
		GCIError *errhp)
{
	/*  STEP A. Allocate the buffer memory used to retrieve the results,
	 *        and stored by row buffer.
	 */
	int rc = 0;
	int rowsize = sizeof(sb4) + sizeof(sb1) * 20 + sizeof(sb8) + sizeof(sb1) * 20+sizeof(sb4);
//	int rowsize = sizeof(sb4) + sizeof(sb1) * 20 + sizeof(sb4) + sizeof(sb1) * 20;
	sb1 *buff = (sb1 *)malloc(rowsize * 100);
	sb4  *key = (sb4 *)buff;
	sb1  *desc = (sb1 *)((sb1 *)key + sizeof(sb4));
	sb8  *stock = (sb8 *)(desc + sizeof(sb1) * 20);
	sb1  *ship = (sb1 *)((sb1 *)stock + sizeof(sb8));	
	sb4  *rownums= (sb4 *)((sb1 *)ship + sizeof(sb1)*20);	
	GCIDefine *bndhp[5];
	sb4 starown;

	memset(buff, 0, rowsize * 100);
	/**Bind the result set columns -
	 **          --  col1 = item_num
	 **              col2 = description
	 **              col3 = stock
	 **              col4 = ship_unit
	 */
	if (rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)key, 4, (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 1 failed.\nExiting!!\n");
		goto EXIT;
	}

	if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 2, (dvoid *)desc, 20, (ub2)SQLT_STR,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto EXIT;
	}

	if (rc = GCIDefineByPos(stmthp, &bndhp[2], errhp, 3, (dvoid *)stock, 8, (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 3 failed.\nExiting!!\n");
		goto EXIT;
	}

	if (rc = GCIDefineByPos(stmthp, &bndhp[3], errhp, 4, (dvoid *)ship, 20, (ub2)SQLT_STR,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 4 failed.\nExiting!!\n");
		goto EXIT;
	}	

	if (rc = GCIDefineByPos(stmthp, &bndhp[4], errhp, 5, (dvoid *)rownums,4, (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 3 failed.\nExiting!!\n");
		goto EXIT;
	}
	fprintf (stdout, "\tStep A done...GCIDefineByPos: Define handle by pos success.\n");


	/*  STEP B. Define array of struct.
	*/
	if (rc = GCIDefineArrayOfStruct(bndhp[0], errhp, rowsize, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 1 failed.\nExiting!!\n");
		goto EXIT;
	}

	if (rc = GCIDefineArrayOfStruct(bndhp[1], errhp, rowsize, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 2 failed.\nExiting!!\n");
		goto EXIT;
	}

	if (rc = GCIDefineArrayOfStruct(bndhp[2], errhp, rowsize, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 3 failed.\nExiting!!\n");
		goto EXIT;
	}

	if (rc = GCIDefineArrayOfStruct(bndhp[3], errhp, rowsize, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 4 failed.\nExiting!!\n");
		goto EXIT;
	}
	if (rc = GCIDefineArrayOfStruct(bndhp[4], errhp, rowsize, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 4 failed.\nExiting!!\n");
		goto EXIT;
	}
	fprintf (stdout, "\tStep B done...GCIDefineArrayOfStruct: Define array of struct success.\n");


	/*  STEP C. Execut the select statement    
	*/
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step C -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto EXIT;
	}

	fprintf (stdout, "\tStep C done...GCIStmtExecute: Execute select statement success.\n");


	/*  STEP D. Retrieve the results
	*/

	starown = 0;

	while(1) 
	{
		ub4 rownum = 0;
		int i;
		if ((rc = GCIStmtFetch(stmthp, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
		GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(starown == rownum)
			break;
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving row number %d:\n", i + 1);
			fprintf(stdout, "\t\titem_num -- %d\n", *(sb4 *)((sb1 *)key + i * rowsize));
			fprintf(stdout, "\t\tdescription -- %s\n", desc + i * rowsize);
			fprintf(stdout, "\t\tstock -- %ld\n", *(sb8 *)((sb1 *)stock + i * rowsize));
			fprintf(stdout, "\t\tship_unit -- %s\n", ship + i * rowsize);
			fprintf(stdout, "\t\trownum -- %ld\n", *(sb4 *)((sb1*)rownums + i * rowsize));
		}

		starown = rownum;
	}

SUCCESS_EXIT:

	fprintf (stdout, "\tStep D done...GCIStmtFetch: Retrieve the results success.\n");

EXIT:
	free(buff);

	return rc; /* no error */
}



char *createsqltest = "create table testtable(id int,date0 date)";
char *insertsqltest = "insert into testtable values (1,'2017-10-31')";
char *altersqltest = "alter table testtable add (addcol int)";
char *deletesqltest = "delete from testtable";
char *trucatesqltest = "truncate table testtable";
char *dropsqltest = "drop table testtable";
char *selectsqltest = "select * from  testtable";

/*
 * This function allocates the row and collection buffers, passes
 * them to the do_select_storebyxxx() function, along with an appropriate select
 * statement and then frees all allocated handles.
 */
int mainloop ()
{
	/* Declare variables */

	ub4			i, in;

	ub1         verInfoBuffer[SELSQL_LEN];
	ub4			verInfoLen;
	ub1         majorVer[3];
	ub4      	isUdoEnabled;

//	ub1*		selectStmt = "SELECT item_num, description, stock, ship_unit FROM item where rownum  < 3";
	//ub1*		selectStmt1 = "SELECT item_num, description, stock, ship_unit,rownum FROM item where rownum  < 3";	
//	ub1*		selectStmt = "SELECT top 1 item_num, description, stock, ship_unit,rownum FROM item where rownum  > 2";	//no data  , stock, ship_unit,rownum 
//	ub1*		selectStmt = "SELECT top 1 item_num, description, stock, ship_unit,rownum FROM item where rownum  < 4";	
	//ub1*		selectStmt1 = "SELECT top 1 item_num, description, stock, ship_unit,rownum FROM item where rownum  < 4";	
//	ub1*		selectStmt = "SELECT top 2 item_num, description, stock, ship_unit,rownum FROM item where rownum  < 4 order by item_num desc";	   //ִorder by
	//ub1*		selectStmt1 = "SELECT top 2 item_num, description, stock, ship_unit,rownum FROM item where rownum  < 4 order by item_num desc";		
	
	ub1*		selectStmt = (ub1 *)"   SELECT top 2 \"item_num\", description FROM item where rownum  < 4 order by item_num asc";	  
	ub1*		selectrownum = (ub1 *)"   SELECT rownum FROM item where rownum  < 4 order by item_num asc";	  

	ub1*		selectStmt1 = (ub1 *)"    SELECT  item_num, description, stock, ship_unit,rownum FROM item where rownum  < 5 order by item_num asc";		
	ub1*        selectsub = (ub1 *)"select description,stock,ship_unit,rownum from item where item_num > (select count(*) from (select sysdate from dual ))";
	ub1*        selectsub1 = (ub1 *)"select count(*) from (select sysdate from dual )";
	ub1*        selectsub2 = (ub1 *)"SELECT description,stock,ship_unit,rownum from item  where item_num <> 0";//(select dbinfo('sessionid') from dual)";		
	/* Handles */
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;
	GCIStmt *stmthp1 = NULL;
	GCIStmt *stmthp2 = NULL;

    GCIStmt *stmthp3 = NULL;
	GCIStmt *stmthp4 = NULL;

    GCIStmt *stmthp5 = NULL;
	GCIStmt *stmthp6 = NULL;
	
	int rc = GCI_SUCCESS;

	GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";
	int colcount;
	int stmttype;
	/*  STEP 1. Get data source name from command line (or use default)
	 **          Allocate the environment handle and set ODBC version
	 **          Allocate the connection handle
	 **          Establish the database connection
	 **          Allocate the statement handle
	 **          Drop demo database if it already exists
	 */
	//usleep(1000);

	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
				0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto EXIT;
	}

	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
				GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto EXIT;
	}	

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
				GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto EXIT;
	}

	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
				pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto EXIT;
	}

	/* Get version information from the database server
	   If version < 9.x (not UDO enabled), exit with error message */
	/*
	   if(rc = GCIServerVersion(svchp, errhp, verInfoBuffer, SELSQL_LEN, GCI_DEFAULT) != GCI_SUCCESS)
	   {
	   fprintf(stdout, "Error in Step 1 -- GCIServerVersion: get database server version failed\nExiting!!\n");
	   goto EXIT;
	   }    

	   if ((strncmp ((char *) verInfoBuffer, "09", 2)) < 0 )
	   {
	   fprintf (stdout, "\n** This test can only be run against UDO-enabled database server -- version 9 or higher **\n");
	   goto EXIT;
	   }
	   */

	fprintf (stdout, "Step 1 done...connected to database.\n");
	fprintf (stdout, "\n!!!Begin SELECT and retrieve results stored by row buffer.\n");
 
	/* Allocate the statement handle */    
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp1, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp2, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}	

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp3, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}	

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp4, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp5, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}		
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp6, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}	

	if(rc = GCIStmtPrepare(stmthp1, errhp, (GCIText *)createsqltest, sizeof(createsqltest), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");

	}	
     
    stmttype = 0;
	if(rc = GCIAttrGet(stmthp1,  GCI_HTYPE_STMT,&stmttype, 0,GCI_ATTR_STMT_TYPE,errhp) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");

	}	
  	
    fprintf(stdout, "create stmt type %d\n",stmttype);
	if(rc = GCIStmtPrepare(stmthp1, errhp, (GCIText *)insertsqltest, sizeof(insertsqltest), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");

	}	
     #if 1     
	if(rc = GCIAttrGet(stmthp1,  GCI_HTYPE_STMT,&stmttype, 0,GCI_ATTR_STMT_TYPE,errhp) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");

	}	    
   
        fprintf(stdout, "insert stmt type %d\n",stmttype);
	if(rc = GCIStmtPrepare(stmthp1, errhp, (GCIText *)altersqltest, sizeof(altersqltest), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
	}	
	if(rc = GCIAttrGet(stmthp1,  GCI_HTYPE_STMT,&stmttype, 0,GCI_ATTR_STMT_TYPE,errhp) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");

	}	        
        fprintf(stdout, "alter stmt type %d\n",stmttype);
	if(rc = GCIStmtPrepare(stmthp1, errhp, (GCIText *)dropsqltest, sizeof(dropsqltest), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
	}
	if(rc = GCIAttrGet(stmthp1,  GCI_HTYPE_STMT,&stmttype, 0,GCI_ATTR_STMT_TYPE,errhp) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");

	}    
        fprintf(stdout, "drop stmt type %d\n",stmttype);
	if(rc = GCIStmtPrepare(stmthp1, errhp, (GCIText *)deletesqltest, sizeof(deletesqltest), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
	}    
	if(rc = GCIAttrGet(stmthp1,  GCI_HTYPE_STMT,&stmttype, 0,GCI_ATTR_STMT_TYPE,errhp) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");

	}      
        fprintf(stdout, "delete stmt type %d\n",stmttype);    
	if(rc = GCIStmtPrepare(stmthp1, errhp, (GCIText *)trucatesqltest, sizeof(trucatesqltest), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
	}    
	if(rc = GCIAttrGet(stmthp1,  GCI_HTYPE_STMT,&stmttype, 0,GCI_ATTR_STMT_TYPE,errhp) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");

	}    
        fprintf(stdout, "truncate stmt type %d\n",stmttype);    
	if(rc = GCIStmtPrepare(stmthp1, errhp, (GCIText *)selectsqltest, sizeof(selectsqltest), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
	}    
	if(rc = GCIAttrGet(stmthp1,  GCI_HTYPE_STMT,&stmttype, 0,GCI_ATTR_STMT_TYPE,errhp) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");

	}    
        fprintf(stdout, "truncate stmt type %d\n",stmttype);   

        if(rc = GCIStmtPrepare(stmthp3, errhp, selectrownum, sizeof(selectrownum), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}   

	if (do_select_rownum (svchp, stmthp3, errhp))
	//if (do_select_storebyrow (svchp, stmthp1, errhp))
	{
		fprintf (stdout, "Error in Step 2...select and retrieve results stored by row buffer failed.\nExiting!!\n");	
		goto EXIT;
	}        

	if(rc = GCIStmtPrepare(stmthp1, errhp, selectStmt1, sizeof(selectStmt1), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}    
        fprintf (stdout, "do_select_storebycol  do ...\n");
        if (do_select_storebycol (svchp, stmthp1, errhp))
        {
		fprintf (stdout, "Error in Step do_select_storebycol...select and retrieve results stored by rownum failed.\nExiting!!\n");	
		goto EXIT;        
        }
	//fprintf (stdout, "Step 2 do_select_storebyrow_realloc  done...alloc and prepare stmp handle 1 success.\n");

	fprintf (stdout, "do_select_storebyrow_realloc  do ...\n");

	/* Retrieve databse rows containing a list */
    

	//if (do_select_storebyrow (svchp, stmthp1, errhp))
	if (do_select_storebyrow_realloc (svchp, stmthp1, errhp))
	{
		fprintf (stdout, "Error in Step 2...select and retrieve results stored by row buffer failed.\nExiting!!\n");	
		goto EXIT;
	}
	fprintf (stdout,"\ndo_select_storebyrow_realloc \nHit <Enter> to continue...");
	
/*
	if(rc = GCIStmtPrepare(stmthp1, errhp, selectStmt1, sizeof(selectStmt1), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}	
	*/
	if (do_select_storebyrow (svchp, stmthp1, errhp))
	//if (do_select_storebyrow (svchp, stmthp1, errhp))
	{
		fprintf (stdout, "Error in Step 2...select and retrieve results stored by row buffer failed.\nExiting!!\n");	
		goto EXIT;
	}
	
	
	fprintf (stdout, "Step 3 done...select and retrieve results stored by row buffer success.\n");
	
/*	GCIParam *colDesc;
//	GCIParam *colDescBak;
//	GCIParamGet(stmthp1, GCI_HTYPE_STMT, errhp, &colDesc, 1);
//	colDescBak = colDesc;
//	ub2 paramGetSize=0;
//	ub2 paramGetType=0;
//	ub2 paramGetPrecision=0;
	ub1 paramGetScale=0;
	sb2 paramGetName[64];
	sb2 paramType[64];

	rc = GCIAttrGet((dvoid *)colDesc, GCI_DTYPE_PARAM, &paramGetName, 0, GCI_ATTR_NAME,errhp);
	fprintf (stdout, "first col's name is: %s.\n",paramGetName);
	rc = GCIAttrGet((CONST dvoid *)colDesc, GCI_DTYPE_PARAM, &paramGetType, 0, GCI_ATTR_DATA_TYPE,errhp);
	switch(paramGetType)
	{
		case SQLT_CHR:
			sprintf((char *)paramType,"SQLT_CHR");
			break;
		case SQLT_INT:
			sprintf((char *)paramType,"SQLT_INT");
			break;
		case SQLT_FLT:
			sprintf((char *)paramType,"SQLT_FLT");
			break;
		case SQLT_ODT:
			sprintf((char *)paramType,"SQLT_ODT");
			break;
		case SQLT_BIN:
			sprintf((char *)paramType,"SQLT_BIN");
			break;
	}
//	fprintf (stdout, "first col's data type is: %s.\n",paramType);
//	rc = GCIAttrGet((CONST dvoid *)colDesc, GCI_DTYPE_PARAM, &paramGetSize, 0, GCI_ATTR_DATA_SIZE,errhp);
//	fprintf (stdout, "first col's data type size is: %d.\n",paramGetSize);
//	rc = GCIAttrGet((CONST dvoid *)colDesc, GCI_DTYPE_PARAM, &paramGetPrecision, 0, GCI_ATTR_PRECISION,errhp);
//	fprintf (stdout, "first col's precision is: %d.\n", paramGetPrecision);
//	rc = GCIAttrGet((CONST dvoid *)colDesc, GCI_DTYPE_PARAM, &paramGetScale, 0, GCI_ATTR_SCALE,errhp);
//	fprintf (stdout, "first col's scale is: %d.\n",paramGetScale);
*/


	fprintf (stdout, "\n!!!Begin SELECT and retrieve results stored by column buffer.\n");

	/* Allocate the statement handle */    
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp2, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 4 -- GCIHandleAlloc: allocate stmp handle 2 failed.\nExiting!!\n");
		goto EXIT;
	}	

	if(rc = GCIStmtPrepare(stmthp2, errhp, selectStmt, sizeof(selectStmt), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 4 -- GCIStmtPrepare: prepare stmp handle 2 failed.\nExiting!!\n");
		goto EXIT;
	}	

	fprintf (stdout, "Step 4 done...alloc and prepare stmp handle 2 success.\n");
    fprintf (stdout, "Step 4 done...do_select_storebycol1.\n");


	/* Retrieve databse rows containing a list */
	if (do_select_storebycol1 (svchp, stmthp2, errhp))
	{
		fprintf (stdout, "Error in Step 5...select and retrieve results stored by column buffer failed.\nExiting!!\n");	
		goto EXIT;
	}

	fprintf (stdout, "Step 5 done...select and retrieve results stored by column buffer success.\n");


	do_select_ext(envhp,svchp, stmthp2, errhp);
#if 1

	fprintf (stdout, "Step 666 done...do_select_ext_plus.\n");


	do_select_ext_plus(envhp,svchp, stmthp2, errhp);

 
	if(rc = GCIStmtPrepare(stmthp6, errhp, selectsub2, sizeof(selectsub2), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle 1 failed.\nExiting!!\n");
		goto EXIT;
	}
	if (rc = GCIStmtExecute(svchp, stmthp6, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step C -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto EXIT;
	}

	colcount = 0;
	
	if (rc = GCIAttrGet (stmthp6, GCI_HTYPE_STMT,&colcount, 0,GCI_ATTR_PARAM_COUNT,errhp) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto EXIT;
	}	

	fprintf(stdout, "\t paramCount after exec %d\n",colcount);
#endif

    #endif       
EXIT:

	/* CLEANUP: Close the statement handle
	 **          Free the statement handle
	 **          Disconnect from the datasource
	 **          Free the connection and environment handles
	 **          Exit
	 */


	if(stmthp1)
		GCIHandleFree((dvoid *)stmthp1, GCI_HTYPE_STMT);
	stmthp1 = NULL;
	if(stmthp2)
		GCIHandleFree((dvoid *)stmthp2, GCI_HTYPE_STMT);
	stmthp2= NULL;	
	if(stmthp3)
		GCIHandleFree((dvoid *)stmthp3, GCI_HTYPE_STMT);
	stmthp3 = NULL;	
	if(stmthp4)
		GCIHandleFree((dvoid *)stmthp4, GCI_HTYPE_STMT);
	stmthp4 = NULL;	
	if(stmthp5)
		GCIHandleFree((dvoid *)stmthp5, GCI_HTYPE_STMT);
	stmthp5 = NULL;	
	if(stmthp6)
		GCIHandleFree((dvoid *)stmthp6, GCI_HTYPE_STMT);	
	stmthp6 = NULL;	
	rc = GCILogoff(svchp, errhp);
	if(rc)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in logoff-- GCILogoff:failed.\nExiting!!\n");	
	}

	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);

	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);


	return (rc);
}
int main (long argc,
		char* argv[])
{
	long loop = 0;
	ub4			i, in;
	for(loop = 0;loop < 1000000;loop++)
		mainloop();
	
	fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
	in = getchar ();

	return 0;	
}