/***************************************************************************
*	Licensed Materials - Property of GBase
*
*
*	"Restricted Materials of GBase"
*
*
*
*	GBase 8s GCI Interface demo
*
*
*	Copyright GBase Corporation 2015 All rights reserved.
*
*
*
*
*
*  Title:          test_trans.c
*
*  Description:    To show how to use the transaction function of the 
*                  database. 
*                  
*
***************************************************************************
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "gci.h"

#define SELSQL_LEN     25
#define ERRMSG_LEN     200



/*
**  Executes the given select statement and assumes the results will be
**  stored by column buffer.
**
*/
int do_select_storebycol (  GCISvcCtx *svchp,
							GCIStmt *stmthp,
							GCIError *errhp)
{
	int rc = 0;
	
    /*  STEP A. Allocate the buffer memory used to retrieve the results,
    *        and stored by column buffer.
    */
	sb8  *key = (sb8 *)malloc(sizeof(sb8) * 100);
	sb1  *desc = (sb1 *)malloc(sizeof(sb1) * 20 * 100);
	sb8  *stock = (sb8 *)malloc(sizeof(sb8) * 100);
	sb1  *ship = (sb1 *)malloc(sizeof(sb1) * 20 * 100);
	sb4 starown = 0;
	GCIDefine *bndhp[4];	
	
	memset(key, 0, sizeof(sb4) * 100);
	memset(desc, 0, sizeof(sb1) * 20 * 100);
	memset(stock, 0, sizeof(sb2) * 100);
	memset(ship, 0, sizeof(sb1) * 20 * 100);

	/**Bind the result set columns -
    **          --  col1 = item_num
    **              col2 = description
    **              col3 = stock
    **              col4 = ship_unit
    */
	if (rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)key, (sb4)sizeof(sb8), (ub2)SQLT_INT,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 1 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 2, (dvoid *)desc, (sb1)20, (ub2)SQLT_STR,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[2], errhp, 3, (dvoid *)stock, (sb2)sizeof(sb8), (ub2)SQLT_INT,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 3 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[3], errhp, 4, (dvoid *)ship, (sb1)20, (ub2)SQLT_STR,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 4 failed.\nExiting!!\n");
		goto EXIT;
	}	

	fprintf (stdout, "\tStep A done...GCIDefineByPos: Define handle by pos success.\n");
	
	
	/*  STEP B. Define array of struct.
    */
/*	if (rc = GCIDefineArrayOfStruct(bndhp[0], errhp, sizeof(sb4), 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 1 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineArrayOfStruct(bndhp[1], errhp, 20, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 2 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineArrayOfStruct(bndhp[2], errhp, sizeof(sb2), 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 3 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineArrayOfStruct(bndhp[3], errhp, 20, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 4 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf (stdout, "\tStep B done...GCIDefineArrayOfStruct: Define array of struct success.\n");
	
*/	
	/*  STEP C. Execut the select statement    
    */   
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
			GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step C -- GCIStmtExecute: execute select statement failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf (stdout, "\tStep C done...GCIStmtExecute: Execute select statement success.\n");
	
	
	/*  STEP D. Retrieve the results
    */
    
	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if (rc = GCIStmtFetch(stmthp, errhp, 100, GCI_FETCH_NEXT, 0) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;		
			break;
		}
		GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
		
		if(starown == rownum)
			break;
			
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving row number %d:\n", i + 1);
			fprintf(stdout, "\t\titem_num -- %ld\n", (long)*(key + i));
			fprintf(stdout, "\t\tdescription -- %s\n", desc + i * 20);
			fprintf(stdout, "\t\tstock -- %ld\n",(long) *(stock + i));
			fprintf(stdout, "\t\tship_unit -- %s\n", ship + i * 20);	
		}
		
		starown = rownum;
	}


SUCCESS_EXIT:
	
    fprintf (stdout, "\tStep D done...GCIStmtFetch: Retrieve the results success.\n");

EXIT:
	free(key);
	free(desc);	
	free(stock);	
	free(ship);	
	
    return rc; /* no error */
}


/* This function start a transaction to edit the database then use the 
 * do_select_storebycol() function to show the result of the commit 
 * function and rollback function.
 */
int main (long argc,
          char* argv[])
{
   /* Declare variables */

    ub4			i, in;

    ub1         ServerSession[20];
    ub1         verInfoBuffer[SELSQL_LEN];
    ub4			verInfoLen;
    ub1         majorVer[3];
    ub4      	isUdoEnabled;
   
    ub1* selectStmt = (ub1 *)"SELECT item_num, description, stock, ship_unit FROM item";
    ub1* updatestmt1 =(ub1 *) "UPDATE item SET stock = 600 where item_num = 1001";
    ub1* updatestmt2 =(ub1 *) "UPDATE item SET stock = 300 WHERE item_num = 1001";
    ub1* insertstmt2 =(ub1 *) "insert into item(item_num,stock) values(1100,100)";
    ub1* insertstmt1 =(ub1 *) "insert into item(item_num,stock) values(1200,100)";
    ub1* insertstmt3 =(ub1 *) "insert into item(item_num,stock) values(2401,100)";
    ub1 *beginwork =(ub1 *) "begin work;update  item SET stock = 666 where item_num = 1001;insert into item(item_num,stock) values(6201,222);commit work;";
	
    /* Handles */
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;
	GCIStmt *stmthp = NULL;

	int rc = GCI_SUCCESS;
    int rownum = 0;
	GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";

    /*  STEP 1. Get data source name from command line (or use default)
    **          Allocate the environment handle and set ODBC version
    **          Allocate the connection handle
    **          Establish the database connection
    **          Allocate the statement handle
    **          Drop demo database if it already exists
    */
    

	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
			0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
			GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
			GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto EXIT;
	}

	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
			pswd, (ub4)strlen((char*)pswd), "gci_demodb", (ub4)strlen((char*)"gci_demodb")) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto EXIT;
	}
	#if 0
	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
			pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto EXIT;
	}
    if(rc = GCIServerSession(svchp, errhp, ServerSession, 20, 0) != GCI_SUCCESS)
    {
		fprintf(stdout, "Error in Step 1 -- GCIServerSession: get server session failed.\nExiting!!\n");
		goto EXIT;
	}	
	#endif

    fprintf (stdout, "Step 1 done...connected to database.\n");
    
    
    
    fprintf (stdout, "\n!!!Begin SELECT and retrieve RAW results stored by row buffer.\n");    
   
	/* Allocate the statement handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}

#if 0
	if (rc = GCIStmtExecDirect(svchp, (ub1 *)"insert into item(item_num,stock) values(5201,100)", errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
	        GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "GCIStmtExecDirect: execute sql statement failed.\nExiting!!\n");

		goto EXIT;
	}			
	#endif
#if 0		
	if(rc = GCIStmtPrepare(NULL, errhp, beginwork, sizeof(beginwork), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}
	if(rc = GCIStmtPrepare(stmthp, errhp, beginwork, sizeof(beginwork), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}
    	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
	        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
                fprintf (stdout, "GCIClosedb: close database failed..\n");
		goto EXIT;
	}	
       #endif 


	if(rc = GCIStmtPrepare(stmthp, errhp, insertstmt1, sizeof(insertstmt1), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
	        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 3 -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto EXIT;
	}	
    	if(rc = GCITransRollback(svchp, errhp, (ub4)0) != GCI_SUCCESS)
	{
		fprintf (stdout, "Error in Step 6...roolback transaction failedssssss.\nExiting!!\n");
		goto EXIT;
	}
         GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);           
         fprintf(stdout, "Error in Step 3 -- GCIStmtExecute: %d\n",rownum);
#if 1
	if(rc = GCIStmtPrepare(stmthp, errhp, selectStmt, sizeof(selectStmt), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if (do_select_storebycol (svchp, stmthp, errhp))
	{
		fprintf (stdout, "Error in Step 2...select and retrieve results stored by column buffer failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf (stdout, "Step 2 done...select and retrieve RAW results stored by column buffer success.\n");

    
	GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
    
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 3 -- GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
        if(rc = GCITransStart(svchp, errhp, 60,(ub4)0) == GCI_ERROR)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;

		fprintf (stdout, "Error in Step 6...roolback transaction failed.\nExiting!!\n");
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 3 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");        
		goto EXIT;
	}
        if(rc = GCITransStart(svchp, errhp, 60,(ub4)0) == GCI_ERROR)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;

		fprintf (stdout, "Error in Step 6...roolback transaction failed.\nExiting!!\n");
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 3 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");        
		goto EXIT;
	}        
        
	if(rc = GCIStmtPrepare(stmthp, errhp, insertstmt2, sizeof(insertstmt2), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 3 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}
        
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
	        GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 3 -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
		goto EXIT;
	}	
 
         GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);    
                 fprintf (stdout, "\n!! not commit insert GCI_ATTR_ROW_COUNT %d .\n",rownum);
	if(rc = GCIStmtPrepare(stmthp, errhp, selectStmt, sizeof(selectStmt), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
        fprintf (stdout, "\n!! not commit insert row .\n");
	if (do_select_storebycol (svchp, stmthp, errhp))
	{
		fprintf (stdout, "Error in Step 2...select and retrieve results stored by column buffer failed.\nExiting!!\n");
		goto EXIT;
	}
	if(rc = GCITransCommit(svchp, errhp, (ub4)0) != GCI_SUCCESS)
	{
		fprintf (stdout, "Error in Step 6...roolback transaction failed.\nExiting!!\n");
		goto EXIT;
	}
	fprintf (stdout, "\n!!!Begin commit transaction111.\n");
	if((rc = GCITransRollback(svchp, errhp, (ub4)0)) != GCI_SUCCESS)
	{
		fprintf (stdout, "Error in Step 6...roolback transaction failed.\nExiting!!\n");
		goto EXIT;
	}
    #if 1
        fprintf (stdout, "\n!! rollback insert row .\n");
	if(rc = GCIStmtPrepare(stmthp, errhp, selectStmt, sizeof(selectStmt), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	        
	if (do_select_storebycol (svchp, stmthp, errhp))
	{
		fprintf (stdout, "Error in Step 2...select and retrieve results stored by column buffer failed.\nExiting!!\n");
		goto EXIT;
	}
    #endif
    #if 1
    	if(rc = GCITransCommit(svchp, errhp, (ub4)0) != GCI_SUCCESS)
	{
		fprintf (stdout, "Error in Step 6...commit transaction failed.\nExiting!!\n");
		goto EXIT;
	}
        #endif
#endif    
	fprintf (stdout, "End commit transaction.\n");	

	fprintf (stdout, "Step 6 done...retrieve results after rollback success.\n");



EXIT:

    /* CLEANUP: Close the statement handle
    **          Free the statement handle
    **          Disconnect from the datasource
    **          Free the connection and environment handles
    **          Exit
    */

	
	if(stmthp)
		GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
	
    rc = GCILogoff(svchp, errhp);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;	
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in logoff-- GCILogoff:failed.\nExiting!!\n");
	}
	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);
	
	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);
	
	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);
	
    fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
    in = getchar ();
    
    return (rc);
}
