#ifndef _GCI_H
#define _GCI_H

#ifdef WIN32
#define GCI_API   __declspec( dllexport )
#else
#define GCI_API
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>
#include "gcierror.h"

#ifdef __cplusplus
extern "C"
	{
#endif

#ifndef TRUE
# define TRUE  1
# define FALSE 0
#endif

//ֽ
#ifndef lint
typedef unsigned char  ub1;
typedef   signed char  sb1;
#else
#define ub1 unsigned char
#define sb1 signed char
#endif

#define UB1MAXVAL ((ub1)UCHAR_MAX)
#define UB1MINVAL ((ub1)        0)
#define SB1MAXVAL ((sb1)SCHAR_MAX)
#define SB1MINVAL ((sb1)SCHAR_MIN)
#define MINUB1MAXVAL ((ub1)  255)
#define MAXUB1MINVAL ((ub1)    0)
#define MINSB1MAXVAL ((sb1)  127)
#define MAXSB1MINVAL ((sb1) -127)

#ifndef lint
typedef unsigned short    ub2;
typedef   signed short    sb2;
#else 
#define ub2  unsigned short
#define sb2  signed short
#endif

#define UB2MAXVAL ((ub2)USHRT_MAX)
#define UB2MINVAL ((ub2)        0)
#define SB2MAXVAL ((sb2) SHRT_MAX)
#define SB2MINVAL ((sb2) SHRT_MIN)
#define MINUB2MAXVAL ((ub2) 65535)
#define MAXUB2MINVAL ((ub2)     0)
#define MINSB2MAXVAL ((sb2) 32767)
#define MAXSB2MINVAL ((sb2)-32768)
//#define MAXSB2MINVAL ((sb2)-32767) 

#ifndef lint
typedef unsigned int  ub4;
typedef   signed int  sb4;
#else
#define eb4 int
#define ub4 unsigned int
#define sb4 signed int
#endif

#define UB4MAXVAL ((ub4)UINT_MAX)
#define UB4MINVAL ((ub4)        0)
#define SB4MAXVAL ((sb4) INT_MAX)
#define SB4MINVAL ((sb4) INT_MIN)
#define MINUB4MAXVAL ((ub4) 4294967295)
#define MAXUB4MINVAL ((ub4)          0)
#define MINSB4MAXVAL ((sb4) 2147483647)
#define MAXSB4MINVAL ((sb4)-2147483647)

#ifdef WIN32
#ifndef lint
typedef unsigned __int64 ub8;
typedef   signed __int64 sb8;
#else
#define ub8 unsigned __int64
#define sb8 signed __int64
#endif
#else
#ifndef lint
typedef unsigned long long  ub8;
typedef   signed long long  sb8;
#else
#define ub8 unsigned long long
#define sb8 signed long long
#endif
#endif                                                             /* _WIN64 */

#define UB8MINVAL    ((ub8)0)
#define UB8MAXVAL    ((ub8)18446744073709551615)
#define SB8MINVAL    ((sb8)-9223372036854775808)
#define SB8MAXVAL    ((sb8) 9223372036854775807)

#define MAXUB8MINVAL ((ub8)0)
#define MINUB8MAXVAL ((ub8)18446744073709551615)
#define MAXSB8MINVAL ((sb8)-9223372036854775807)
#define MINSB8MAXVAL ((sb8) 9223372036854775807)


#define UB1BITS          CHAR_BIT
#define UB1MASK          ((1 << ((uword)CHAR_BIT)) - 1)

#define gbsub8      ub8
#define gbssb8      sb8

#ifdef lint
#define GCItext unsigned char
#else
  typedef  unsigned char GCItext;
#endif

#ifndef lint
  typedef unsigned short utext;
#else
# define utext  unsigned short
#endif

#define GCIText GCItext
#ifdef WIN32
typedef struct ptw32_handle_4_gci_t GCIThreadId;
typedef struct ptw32_handle_4_gci_t GCIThreadHandle;
typedef struct pthread_mutex_t_ *  GCIThreadMutex;
#else
#define GCIThreadId     pthread_t
#define GCIThreadHandle pthread_t
#define GCIThreadMutex  pthread_mutex_t
#endif

#ifndef lint 
typedef          char     eb1;
typedef          short    eb2;
typedef          int      eb4;
#else
# define         eb1      char
# define         eb2      short
# define         eb4      int
#endif

#define EB1MAXVAL      ((eb1)SCHAR_MAX)
#define EB1MINVAL      ((eb1)        0)
#define MINEB1MAXVAL   ((eb1)  127)
#define MAXEB1MINVAL   ((eb1)    0)
#define EB2MAXVAL      ((eb2) SHRT_MAX)
#define EB2MINVAL      ((eb2)        0)
#define MINEB2MAXVAL   ((eb2) 32767)
#define MAXEB2MINVAL   ((eb2)     0)
#define EB4MAXVAL      ((eb4) INT_MAX)
#define EB4MINVAL      ((eb4)        0)
#define MINEB4MAXVAL   ((eb4) 2147483647)
#define MAXEB4MINVAL   ((eb4)          0)


#ifndef lint
typedef         sb1  b1;
#else
#define         b1 sb1
#endif
#define  B1MAXVAL  SB1MAXVAL
#define  B1MINVAL  SB1MINVAL
 
#ifndef lint
typedef         sb2      b2;
#else
#define         b2 sb2
#endif
#define  B2MAXVAL  SB2MAXVAL
#define  B2MINVAL  SB2MINVAL
 
#ifndef lint
typedef         sb4    b4;
#else
#define         b4 sb4
#endif
# define  B4MAXVAL  SB4MAXVAL
# define  B4MINVAL  SB4MINVAL

#ifndef lint
typedef          int eword;
typedef unsigned int uword;
typedef   signed int sword;
#else
#define eword int
#define uword unsigned int
#define sword signed int
#endif

#define  EWORDMAXVAL  ((eword) INT_MAX)
#define  EWORDMINVAL  ((eword)       0)
#define  UWORDMAXVAL  ((uword)UINT_MAX)
#define  UWORDMINVAL  ((uword)       0)
#define  SWORDMAXVAL  ((sword) INT_MAX)
#define  SWORDMINVAL  ((sword) INT_MIN)
#define  MINEWORDMAXVAL  ((eword)  2147483647)
#define  MAXEWORDMINVAL  ((eword)      0)
#define  MINUWORDMAXVAL  ((uword)  4294967295)
#define  MAXUWORDMINVAL  ((uword)           0)
#define  MINSWORDMAXVAL  ((sword)  2147483647)
#define  MAXSWORDMINVAL  ((sword) -2147483647)

//<SMR-LW-2011052501> ===> BEGIN SMR-LW-2011052501
//<SMR-LW-2011042201> ===> BEGIN SMR-LW-2011042201
#if !defined(SOLARIS) && !defined(HP_UX) && !defined(_AIX)
//<SMR-LW-2011042201> ===> END
//<SMR-LW-2011052501> ===> END
#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif
#endif

#undef CONST
#define CONST const

#define dvoid void

typedef void (*lgenfp_t)( void );

#define  SQLT_UNK     0        // UNKNOWN
#define SQLT_CHR  1                        /* (gci TYPE) character string */
#define SQLT_NUM  2                          /* (gci TYPE) gbase numeric */
#define SQLT_INT  3                                 /* (gci TYPE) integer */
#define SQLT_FLT  4                   /* (gci TYPE) Floating point number */
#define SQLT_STR  5                                /* zero terminated string */
#define SQLT_VNU  6                        /* NUM with preceding length byte */
#define SQLT_PDN  7                  /* (gci TYPE) Packed Decimal Numeric */
#define SQLT_LNG  8                                                  /* long */
#define SQLT_VCS  9                             /* Variable character string */
#define SQLT_NON  10                      /* Null/empty PCC Descriptor entry */
#define SQLT_RID  11                                                /* rowid */
#define SQLT_DAT  12                                /* date in gbase format */
#define SQLT_VBI  15                                 /* binary in VCS format */
#define SQLT_BIN  23                                  /* binary data(DTYBIN) */
#define SQLT_LBI  24                                          /* long binary */
#define SQLT_BFLOAT  21       // Native Binary float
#define SQLT_BDOUBLE 22       // Native binary double
#define SQLT_UND     25       // UNDEFINED
#define SQLT_UIN  68                                     /* unsigned integer */
#define SQLT_SLS  91                        /* Display sign leading separate */
#define SQLT_LVC  94                                  /* Longer longs (char) */
#define SQLT_LVB  95                                  /* Longer long binary */ 
#define SQLT_AFC  96                                      /* Ansi fixed char */
#define SQLT_AVC  97                                        /* Ansi Var char */
#define SQLT_IBFLOAT   100      // binary float canonical
#define SQLT_IBDOUBLE  101      // binary double canonical
#define SQLT_CUR  102            /* cursor  type */
#define SQLT_RDD  104            /* rowid descriptor */
#define SQLT_LAB  105                    /* label type */
#define SQLT_OSL  106                  /* oslabel type */
#define SQLT_NTY  108             /* named object type */
#define SQLT_REF  110                      /* ref type */
#define SQLT_CLOB 112                 /* character lob */
#define SQLT_BLOB 113                    /* binary lob */
#define SQLT_BFILEE 114              /* binary file lob */
#define SQLT_CFILEE 115           /* character file lob */
#define SQLT_RSET 116               /* result set type */
#define SQLT_NCO  122      /* named collection type (varray or nested table) */
#define SQLT_VARRAY  123         // ---- // ----   varray 
#define SQLT_VST  155            /* GCIString type */
#define SQLT_ODT  156              /* GCIDate type */
#define SQLT_FILE    SQLT_BFILEE // binary file lob
#define SQLT_CFILE   SQLT_CFILEE
#define SQLT_BFILE   SQLT_BFILEE
/* datetimes and intervals */
#define SQLT_DATE                      184  /* ANSI Date */
#define SQLT_TIME                      185  /* TIME */
#define SQLT_TIME_TZ                   186  /* TIME WITH TIME ZONE */
#define SQLT_TIMESTAMP                 187  /* TIMESTAMP */
#define SQLT_TIMESTAMP_TZ              188  /* TIMESTAMP WITH TIME ZONE */
#define SQLT_INTERVAL_YM               189    /* INTERVAL YEAR TO MONTH */
#define SQLT_INTERVAL_DS               190    /* INTERVAL DAY TO SECOND */
#define SQLT_TIMESTAMP_LTZ             232   /* TIMESTAMP WITH LOCAL TZ */
#define SQLT_PNTY                      241         /* pl/sql representation of named types */

#define  SQLT_REC     250      // PLSQL record
#define  SQLT_TAB     251      // PLSQL indexed table
#define  SQLT_BOL     252      // PLSQL boolean

#define SQLT_INT_8_BITS   30008                  /* (ORANET TYPE)  8 bits integer */
#define SQLT_INT_16_BITS  30016                  /* (ORANET TYPE) 16 bits integer */
#define SQLT_INT_32_BITS  30032                  /* (ORANET TYPE) 32 bits integer */
#define SQLT_INT_64_BITS  30064                  /* (ORANET TYPE) 64 bits integer */

#define SQLT_FLT_32_BITS  40032                  /* (ORANET TYPE) 32 bits float */
#define SQLT_FLT_64_BITS  40064                  /* (ORANET TYPE) 64 bits float */

/*{ CHAR/NCHAR/VARCHAR2/NVARCHAR2/CLOB/NCLOB char set "form" information }*/
#define   SQLCS_IMPLICIT  1/* for CHAR, VARCHAR2, CLOB w/o a specified set */
#define   SQLCS_NCHAR     2/* for NCHAR, NCHAR VARYING, NCLOB */
#define   SQLCS_EXPLICIT  3/* for CHAR, etc, with "CHARACTER SET ..." syntax */
#define   SQLCS_FLEXIBLE  4/* for PL/SQL "flexible" parameters */
#define   SQLCS_LIT_NULL  5/* for typecheck of NULL and empty_clob() lits */

/*--------------------------------------------------------------------------- 
                     PUBLIC TYPES AND CONSTANTS
  ---------------------------------------------------------------------------*/
#define GCI_OBJECT          0x00000002  /* application in object environment */
/*-----------------------------Handle Types----------------------------------*/
#define GCI_HTYPE_ENV            1                     /* environment handle */
#define GCI_HTYPE_ERROR          2                           /* error handle */
#define GCI_HTYPE_SVCCTX         3                         /* service handle */
#define GCI_HTYPE_STMT           4                       /* statement handle */
#define GCI_HTYPE_BIND           5                            /* bind handle */
#define GCI_HTYPE_DEFINE         6                          /* define handle */
#define GCI_HTYPE_DESCRIBE       7                        /* describe handle */
#define GCI_HTYPE_SERVER         8                          /* server handle */
#define GCI_HTYPE_SESSION        9                  /* authentication handle */
//#define GCI_HTYPE_AUTHINFO      GCI_HTYPE_SESSION/* SessionGet auth handle */
#define GCI_HTYPE_AUTHINFO      11                /* SessionGet auth handle */
#define GCI_HTYPE_DIRPATH_CTX   14                    /* direct path context */
#define GCI_HTYPE_DIRPATH_COLUMN_ARRAY 15        /* direct path column array */
#define GCI_HTYPE_DIRPATH_STREAM       16              /* direct path stream */
#define GCI_HTYPE_PROC                 17                  /* process handle */
#define GCI_HTYPE_CPOOL                26          /* connection pool handle */
/*---------------------------------------------------------------------------*/
#define GCI_NTV_SYNTAX 1    /* Use what so ever is the native lang of server */
//<SQLT_INTERVAL_DS> ===> BEGIN SMR-SF-10101101
/*-------------------------Descriptor Types----------------------------------*/
/* descriptor values range from 50 - 255 */
#define GCI_DTYPE_FIRST 50                 /* start value of descriptor type */
#define GCI_DTYPE_LOB 50                                     /* lob  locator */
#define GCI_DTYPE_SNAP 51                             /* snapshot descriptor */
#define GCI_DTYPE_RSET 52                           /* result set descriptor */
#define GCI_DTYPE_PARAM 53  /* a parameter descriptor obtained from gcigparm */
#define GCI_DTYPE_ROWID  54                              /* rowid descriptor */
#define GCI_DTYPE_COMPLEXOBJECTCOMP  55
/* complex object retrieval descriptor */
#define GCI_DTYPE_FILE 56                                /* File Lob locator */
#define GCI_DTYPE_AQENQ_OPTIONS 57                        /* enqueue options */
#define GCI_DTYPE_AQDEQ_OPTIONS 58                        /* dequeue options */
#define GCI_DTYPE_AQMSG_PROPERTIES 59                  /* message properties */
#define GCI_DTYPE_AQAGENT 60                                     /* aq agent */
#define GCI_DTYPE_LOCATOR 61                                  /* LOB locator */
#define GCI_DTYPE_INTERVAL_YM 62                      /* Interval year month */
#define GCI_DTYPE_INTERVAL_DS 63                      /* Interval day second */
#define GCI_DTYPE_AQNFY_DESCRIPTOR  64               /* AQ notify descriptor */
#define GCI_DTYPE_DATE 65                            /* Date */
#define GCI_DTYPE_TIME 66                            /* Time */
#define GCI_DTYPE_TIME_TZ 67                         /* Time with timezone */
#define GCI_DTYPE_TIMESTAMP 68                       /* Timestamp */
#define GCI_DTYPE_TIMESTAMP_TZ 69                /* Timestamp with timezone */
#define GCI_DTYPE_TIMESTAMP_LTZ 70             /* Timestamp with local tz */
#define GCI_DTYPE_UCB           71               /* user callback descriptor */
#define GCI_DTYPE_SRVDN         72              /* server DN list descriptor */
#define GCI_DTYPE_SIGNATURE     73                              /* signature */
#define GCI_DTYPE_RESERVED_1    74              /* reserved for internal use */
#define GCI_DTYPE_LAST          74        /* last value of a descriptor type */
//<SQLT_INTERVAL_DS> ===> END
/*---------------------------------------------------------------------------*/

/*--------------------------------LOB types ---------------------------------*/
#define GCI_TEMP_BLOB 1                /* LOB type - BLOB ------------------ */
#define GCI_TEMP_CLOB 2                /* LOB type - CLOB ------------------ */
/*---------------------------------------------------------------------------*/

/*-------------------------Credential Types----------------------------------*/
#define GCI_CRED_RDBMS      1                  /* database username/password */
#define GCI_CRED_EXT            2                  /*external credantials,ignore the user&pass*/
/*---------------------------------------------------------------------------*/
/*----------------------------Piece Definitions------------------------------*/

#define GCI_ONE_PIECE 0                                         /* one piece */

/*---------------------------------------------------------------------------*/
/*------------------------Bind and Define Options----------------------------*/
#define GCI_SB2_IND_PTR       0x00000001                           /* unused */
#define GCI_DATA_AT_EXEC      0x00000002             /* data at execute time */
#define GCI_DYNAMIC_FETCH     0x00000002                /* fetch dynamically */
#define GCI_PIECEWISE         0x00000004          /* piecewise DMLs or fetch */
#define GCI_DEFINE_RESERVED_1 0x00000008                         /* reserved */
#define GCI_BIND_RESERVED_2   0x00000010                         /* reserved */
#define GCI_DEFINE_RESERVED_2 0x00000020                         /* reserved */
#define GCI_BIND_SOFT         0x00000040              /* soft bind or define */
#define GCI_DEFINE_SOFT       0x00000080              /* soft bind or define */
/*---------------------------------------------------------------------------*/
#ifndef GCI_FLAGS
#define GCI_FLAGS
#define GCI_ONE_PIECE 0                                         /* one piece */
#define GCI_FIRST_PIECE 1                                 /* the first piece */
#define GCI_NEXT_PIECE 2                          /* the next of many pieces */
#define GCI_LAST_PIECE 3                                   /* the last piece */
#endif
//<SMR-YYL-2011062701> ===> BEGIN
/*--------------------------- FILE open modes -------------------------------*/
#define GCI_FILE_READONLY 1             /* readonly mode open for FILE types */
/*---------------------------------------------------------------------------*/
/*--------------------------- LOB open modes --------------------------------*/
#define GCI_LOB_READONLY 1              /* readonly mode open for ILOB types */
#define GCI_LOB_READWRITE 2                /* read write mode open for ILOBs */
#define GCI_LOB_WRITEONLY     3         /* Writeonly mode open for ILOB types*/
#define GCI_LOB_APPENDONLY    4       /* Appendonly mode open for ILOB types */
#define GCI_LOB_FULLOVERWRITE 5                 /* Completely overwrite ILOB */
#define GCI_LOB_FULLREAD      6                 /* Doing a Full Read of ILOB */

//<SMR-YYL-2011062701> ===> END
/*=============================Attribute Types===============================*/
/* 
   Note: All attributes are global.  New attibutes should be added to the end
   of the list. Before you add an attribute see if an existing one can be 
   used for your handle. 

   If you see any holes please use the holes first. 
 
*/
/*===========================================================================*/
#define GCI_ATTR_ENV  5                            /* the environment handle */
#define GCI_ATTR_SERVER 6                               /* the server handle */
#define GCI_ATTR_SESSION 7                        /* the user session handle */
#define GCI_ATTR_ROW_COUNT   9                  /* the rows processed so far */
#define GCI_ATTR_PREFETCH_ROWS  11    /* sets the number of rows to prefetch */
#define GCI_ATTR_DML_ROW_OFFSET 12
#define GCI_ATTR_PREFETCH_MEMORY 13         /* memory limit for rows fetched */

#define GCI_ATTR_PARAM_COUNT 18       /* number of column in the select list */
#define GCI_ATTR_USERNAME 22                           /* username attribute */
#define GCI_ATTR_PASSWORD 23                           /* password attribute */
#define GCI_ATTR_STMT_TYPE   24                            /* statement type */

#define GCI_ATTR_DATEFORMAT             75     /* default date format string */
#define GCI_ATTR_BUF_ADDR               76                 /* buffer address */
#define GCI_ATTR_BUF_SIZE               77                    /* buffer size */
#define GCI_ATTR_NUM_ROWS               81 /* number of rows in column array */
                                  /* NOTE that GCI_ATTR_NUM_COLS is a column
                                   * array attribute too.
                                   */


#define GCI_ATTR_COL_COUNT              82        /* columns of column array
                                                    processed so far.       */
#define GCI_ATTR_NUM_COLS         102                   /* number of columns */
#define GCI_ATTR_LIST_COLUMNS     103        /* parameter of the column list */
#define GCI_ATTR_LIST_ARGUMENTS   108      /* parameter of the argument list */
#define GCI_ATTR_LIST_SUBPROGRAMS 109    /* parameter of the subprogram list */
#define GCI_ATTR_NUM_PARAMS       121                /* number of parameters */
#define GCI_ATTR_OBJID            122       /* object id for a table or view */
#define GCI_ATTR_PTYPE            123           /* type of info described by */
#define GCI_ATTR_PARAM            124                /* parameter descriptor */

#define GCI_ATTR_DIRPATH_INPUT     151     /* input in text or stream format */
#define GCI_ATTR_STMTCACHESIZE     176              /* size of the stm cache */
#define GCI_ATTR_ROWS_FETCHED      197          /* rows fetched in last call */
#define GCI_ATTR_NOCACHE           198
#define GCI_ATTR_BIND_COUNT        199
#define GCI_ATTR_ROWID             200

#define GCI_DIRPATH_INPUT_TEXT     0x01
#define GCI_DIRPATH_INPUT_STREAM   0x02
#define GCI_DIRPATH_INPUT_UNKNOWN  0x04
/*============================== End GCI Attribute Types ====================*/
/*-------------------------Object Ptr Types----------------------------------*/
#define GCI_OTYPE_NAME 1                                      /* object name */
/*---------------------------------------------------------------------------*/
/*------------------------Error Return Values--------------------------------*/
#define GCI_SUCCESS 0                      /* maps to SQL_SUCCESS of SAG CLI */
#define GCI_SUCCESS_WITH_INFO 1             /* maps to SQL_SUCCESS_WITH_INFO */
#define GCI_NO_DATA 100                               /* maps to SQL_NO_DATA */
#define GCI_ERROR -1                                    /* maps to SQL_ERROR */
#define GCI_INVALID_HANDLE -2                  /* maps to SQL_INVALID_HANDLE */
#define GCI_NEED_DATA 99                            /* maps to SQL_NEED_DATA */
#define GCI_STILL_EXECUTING -3123                   /* GCI would block error */
#define GCI_RESERVED_FOR_INT_USE 200                             /* reserved */
/*---------------------------------------------------------------------------*/
/*--------------------- User Callback Return Values -------------------------*/
#define GCI_CONTINUE -24200    /*  Continue with the body of the GCI function */
/*---------------------------------------------------------------------------*/
/*------------------------Scrollable Cursor Fetch Options------------------- 
 * For non-scrollable cursor, the only valid (and default) orientation is 
 * GCI_FETCH_NEXT
 */
#define GCI_FETCH_CURRENT 0x01               /* refetching current position  */
#define GCI_FETCH_NEXT 0x02                                      /* next row */
#define GCI_FETCH_FIRST 0x04                  /* first row of the result set */
#define GCI_FETCH_LAST 0x08                /* the last row of the result set */
#define GCI_FETCH_PRIOR 0x10         /* the previous row relative to current */
#define GCI_FETCH_ABSOLUTE 0x20                /* absolute offset from first */
#define GCI_FETCH_RELATIVE 0x40                /* offset relative to current */

#define GCI_FETCH_RESERVED_1   0x88   /*gci no use*/
#define GCI_FETCH_RESERVED_2   0x89   /*gci no use*/
#define GCI_FETCH_RESERVED_3   0x8a   /*gci no use*/
#define GCI_FETCH_RESERVED_4   0x8b   /*gci no use*/
#define GCI_FETCH_RESERVED_5   0x8c   /*gci no use*/

/*---------------------------------------------------------------------------*/
/*----------------------- Execution Modes -----------------------------------*/
#define GCI_EXACT_FETCH       0x00000002        /* fetch the exact rows specified */
#define GCI_DESCRIBE_ONLY     0x00000004        /* only describe the statement */
#define GCI_COMMIT_ON_SUCCESS 0x00000008        /* commit, if successful execution */
#define GCI_BATCH_MODE        0x00000010        /*no use*/
#define GCI_PARSE_ONLY        0x00000100        /* only parse the statement */

/*---------------------------------------------------------------------------*/

/*------------------------Authentication Modes-------------------------------*/
#define GCI_SYSDBA          0x00000002           /* for SYSDBA authorization */
#define GCI_SYSOPER         0x00000004          /* for SYSOPER authorization */
#define GCI_SYSASM          0x00008000           /* for SYSASM authorization */
/*---------------------------------------------------------------------------*/


/*-----------------------------  Various Modes ------------------------------*/
#define GCI_DEFAULT         0x00000000 
/*---------------------------------------------------------------------------*/
/*-------------GCIInitialize Modes / GCICreateEnvironment Modes -------------*/
#define GCI_THREADED        0x00000001      /* appl. in threaded environment */
/*---------------------------------------------------------------------------*/
/*-------------GCIInitialize Modes / GCIConnectionPoolCreate Modes ----------*/
#define GCI_CPOOL_REINITIALIZE 0x111        /* appl. in create connectionpool*/
/*---------------------------------------------------------------------------*/
/*---------------------GCIStmtRelease Modes----------------------------------*/
#define GCI_STRLS_CACHE_DELETE      0x0010              /* Delete from Cache */
/*---------------------------------------------------------------------------*/

/*-----------Object Types **** Not to be Used **** --------------------------*/
/* Deprecated */
/*
#define GCI_OTYPE_UNK           0
#define GCI_OTYPE_TABLE         1
#define GCI_OTYPE_VIEW          2
#define GCI_OTYPE_SYN           3
#define GCI_OTYPE_PROC          4
#define GCI_OTYPE_FUNC          5
#define GCI_OTYPE_PKG           6
#define GCI_OTYPE_STMT          7
*/
/*---------------------------------------------------------------------------*/
/*------------------------Piece Information----------------------------------*/
#define GCI_PARAM_IN 0x01                                    /* in parameter */
#define GCI_PARAM_OUT 0x02                                  /* out parameter */
/*---------------------------------------------------------------------------*/
/*=======================Describe Handle Parameter Attributes ===============*/
/* 
   These attributes are orthogonal to the other set of attributes defined 
   above.  These attrubutes are tobe used only for the desscribe handle 
*/
/*===========================================================================*/
/* Attributes common to Columns and Stored Procs */
#define GCI_ATTR_DATA_SIZE      1                /* maximum size of the data */
#define GCI_ATTR_DATA_TYPE      2     /* the SQL type of the column/argument */
#define GCI_ATTR_DISP_SIZE      3                        /* the display size */
#define GCI_ATTR_NAME           4         /* the name of the column/argument */
#define GCI_ATTR_PRECISION      5                /* precision if number type */
#define GCI_ATTR_SCALE          6                    /* scale if number type */
#define GCI_ATTR_IS_NULL        7                            /* is it null ? */
#define GCI_ATTR_TYPE_NAME      8
/* name of the named data type or a package name for package private types */
#define GCI_ATTR_SCHEMA_NAME    9             /* the schema name */
#define GCI_ATTR_SUB_NAME       10      /* type name if package private type */
#define GCI_ATTR_POSITION       11
/* relative position of col/arg in the list of cols/args */
/* complex object retrieval parameter attributes */

/* Only Columns */
#define GCI_ATTR_DISP_NAME      100                      /* the display name */
/*Only Stored Procs */
#define GCI_ATTR_NUM_ARGS         215             /* total number of arguments */

#define GCI_ATTR_CONNECTION_CLASS  216
#define GCI_ATTR_MODULE            217
#define GCI_ATTR_CURRENT_SCHEMA    218
#define GCI_ATTR_PURITY            219
#define GCI_ATTR_PURITY_NEW        220
#define GCI_ATTR_PURITY_DEFAULT    221
#define GCI_ATTR_CONN_TIMEOUT      222

#define GCI_ATTR_CHAR_USED         223
#define GCI_ATTR_CHAR_SIZE         224

#define GCI_ATTR_EXTERNAL_NAME         225
#define GCI_ATTR_INTERNAL_NAME         226
#define GCI_ATTR_LOBEMPTY                   227
#define GCI_ATTR_CONN_NOWAIT       178
#define GCI_ATTR_CONN_BUSY_COUNT   179
#define GCI_ATTR_CONN_OPEN_COUNT   180
#define GCI_ATTR_CONN_MIN          183
#define GCI_ATTR_CONN_MAX          184
#define GCI_ATTR_CONN_INCR         185
/*---------------------------------------------------------------------------*/
/*-----------------------Handle Definitions----------------------------------*/
typedef struct GCIEnv           GCIEnv;            /* GCI environment handle */
typedef struct GCIError         GCIError;                /* GCI error handle */
typedef struct GCISvcCtx        GCISvcCtx;             /* GCI service handle */
typedef struct GCIStmt          GCIStmt;             /* GCI statement handle */
typedef struct GCIBind          GCIBind;                  /* GCI bind handle */
typedef struct GCIBind          GCIDefine;              /* GCI Define handle */
typedef struct GCIDescribe      GCIDescribe;          /* GCI Describe handle */
typedef struct GCIServer        GCIServer;              /* GCI Server handle */
typedef struct GCISession       GCISession;     /* GCI Authentication handle */
typedef struct GCITrans         GCITrans;          /* GCI Transaction handle */
typedef struct GCICPool         GCICPool;      /* GCI connection pool handle */
typedef struct GCISession       GCIAuthInfo;
/*-----------------------Descriptor Definitions------------------------------*/
typedef struct GCISnapshot      GCISnapshot;      /* GCI snapshot descriptor */
typedef struct GCILobLocator    GCILobLocator; /* GCI Lob Locator descriptor */
typedef struct GCIParam         GCIParam;        /* GCI PARameter descriptor */

typedef struct GCILobLocator    GCIClobLocator;    /* GCI Character LOB Locator */
typedef struct GCILobLocator    GCIBlobLocator;       /* GCI Binary LOB Locator */
/*---------------------------------------------------------------------------*/
/*--------------------------- GCISessionGet Modes ---------------------------*/
//#define GCI_SESSGET_SPOOL             0x0001/* SessionGet called in SPOOL mode */
//#define GCI_SESSGET_STMTCACHE         0x0004          /* Use statement cache */
//#define GCI_SESSGET_CREDPROXY         0x0008/* SessionGet called in proxy mode */
//#define GCI_SESSGET_CREDEXT           0x0010
//#define GCI_SESSGET_SPOOL_MATCHANY    0x0020
//#define GCI_SESSGET_PURITY_NEW        0x0040
//#define GCI_SESSGET_PURITY_SELF       0x0080
//#define GCI_SESSGET_SYSDBA            0x0100/* SessionGet with SYSDBA privileges */
#define GCI_SESSGET_CPOOL             0x0200/* SessionGet called in CPOOL mode */
//#define GCI_SESSGET_MULTIPROPERTY_TAG 0x0400           /* multi property tag */
//#define GCI_SESSGET_CUSTOM_POOL       0x0800             /* Custom Pool Mode */
/*--------------------------- GCI Parameter Types ---------------------------*/
#define GCI_PTYPE_UNK                 0                         /* unknown   */
#define GCI_PTYPE_TABLE               1                         /* table     */
#define GCI_PTYPE_VIEW                2                         /* view      */
#define GCI_PTYPE_PROC                3                         /* procedure */
#define GCI_PTYPE_FUNC                4                         /* function  */
#define GCI_PTYPE_PKG                 5                         /* package   */
/*no use*/
#define GCI_PTYPE_TYPE                6  /*no use*/
#define GCI_PTYPE_SYN                 7  /*no use*/
#define GCI_PTYPE_SEQ                 8  /*no use*/

#define GCI_PTYPE_ARG                 10 /*no use*/

#define GCI_PTYPE_LIST                11                        /* list      */
/*no use*/
#define GCI_PTYPE_TYPE_ATTR                  12
#define GCI_PTYPE_TYPE_COLL                  13
#define GCI_PTYPE_TYPE_METHOD                14
#define GCI_PTYPE_TYPE_ARG                   15
#define GCI_PTYPE_TYPE_RESULT                16
#define GCI_PTYPE_SCHEMA                     17
#define GCI_PTYPE_DATABASE                   18
#define GCI_PTYPE_RULE                       19
#define GCI_PTYPE_RULE_SET                   20
#define GCI_PTYPE_EVALUATION_CONTEXT         21
#define GCI_PTYPE_TABLE_ALIAS                22
#define GCI_PTYPE_VARIABLE_TYPE              23
#define GCI_PTYPE_NAME_VALUE                 24 /*no use*/


/*---------------------------------------------------------------------------*/
/*--------------------------- GCI Statement Types ---------------------------*/
#define  GCI_STMT_UNKNOWN  0
#define  GCI_STMT_SELECT  1                              /* select statement */
#define  GCI_STMT_UPDATE  2                              /* update statement */
#define  GCI_STMT_DELETE  3                              /* delete statement */
#define  GCI_STMT_INSERT  4                              /* Insert Statement */
#define  GCI_STMT_CREATE  5                              /* create statement */
#define  GCI_STMT_DROP    6                                /* drop statement */
#define  GCI_STMT_ALTER   7                               /* alter statement */
#define  GCI_STMT_BEGIN   8                   /* begin ... (pl/sql statement)*/
#define  GCI_STMT_DECLARE 9                /* declare .. (pl/sql statement ) */
#define  GCI_STMT_CALL    10
/*---------------------------------------------------------------------------*/
#define GCI_ATTR_DIRPATH_INDEX_MAINT_METHOD 138
/*----- values for action parameter to GCIDirPathDataSave -----*/
#define GCI_DIRPATH_DATASAVE_SAVEONLY 0              /* data save point only */
#define GCI_DIRPATH_DATASAVE_FINISH   1           /* execute finishing logic */
/*--------------------------------------------------------------------------- 
/* -------------------- 8.2 dpapi support of ADTs continued ---------------- */
#define GCI_ATTR_DIRPATH_OBJ_CONSTR         206 /* obj type of subst obj tbl */
#define GCI_ATTR_INST_TYPE                  207      /* gbase instance type */
/******USED attribute 208 for  GCI_ATTR_SPOOL_STMTCACHESIZE*******************/
//<SMR-SF-10071202> ===> BEGIN SMR-SF-10071202
#define GCI_ATTR_CHARSET_ID 31                           /* Character Set ID */
#define GCI_ATTR_ENV_CHARSET_ID   GCI_ATTR_CHARSET_ID   /* charset id in env */
//<SMR-SF-10071202> ===> END

#define GCI_TRANS_READONLY     0x00000100   /* starts a readonly transaction */
#define GCI_TRANS_READWRITE    0x00000200 /* starts a read-write transaction */
#define GCI_TRANS_SERIALIZABLE 0x00000400
/*   ---------------------------------------------------------------------------*/
#define GCI_HTYPE_TRANS         10                     /* transaction handle */
#define GCI_ATTR_TRANS   8                         /* the transaction handle */
#define GCI_NUMBER_SIZE 22
#define GCI_BATCH_ERRORS      0x80             /* batch errors in array dmls */

#define GCI_STMT_SCROLLABLE_READONLY 0x81    /*no use*/

#define GCI_PTYPE_COL                 9 
#define GCI_TRANS_NEW          0x00000001 /* starts a new transaction branch */

#define GCI_TRANS_JOIN         0x00000002 /*no use*/
#define GCI_TRANS_RESUME       0x00000003 /*no use*/
#define GCI_TRANS_STARTMASK    0x00000004 /*no use*/

#define GCI_TRANS_ISOLMASK     0x00000005 /*no use*/
#define GCI_TRANS_LOOSE        0x00000006 /*no use*/
#define GCI_TRANS_TIGHT        0x00000007 /*no use*/
#define GCI_TRANS_TYPEMASK     0x00000008 /*no use*/
#define GCI_TRANS_NOMIGRATE    0x00000009 /*no use*/
#define GCI_TRANS_SEPARABLE    0x0000000a /*no use*/
#define GCI_TRANS_OTSRESUME    0x0000000b /*no use*/

#define GCI_TRANS_TWOPHASE       0x0000000c /*no use*/
#define GCI_TRANS_WRITEBATCH     0x0000000d /*no use*/
#define GCI_TRANS_WRITEIMMED     0x0000000e /*no use*/
#define GCI_TRANS_WRITEWAIT      0x0000000f /*no use*/
#define GCI_TRANS_WRITENOWAIT    0x00000010 /*no use*/

#define GCI_NUMBER_UNSIGNED 0                        /* Unsigned type -- ubX */
#define GCI_NUMBER_SIGNED   2                          /* Signed type -- sbX */

#define GCI_ATTR_ENV_STMT_NUM      9999


#define GCI_TYPE_DATE_YEAR_MAX      9999
#define GCI_TYPE_DATE_YEAR_MIN      -4712
#define GCI_TYPE_DATE_MONTH_MAX     12
#define GCI_TYPE_DATE_MONTH_MIN      1
#define GCI_TYPE_DATE_DAY_MAX        31
#define GCI_TYPE_DATE_DAY_MIN        1
#define GCI_TYPE_DATE_DAY_MIN        1

#define GCI_TYPE_INTERVAL_YEAR_MAX      999999999
#define GCI_TYPE_INTERVAL_YEAR_MIN      -999999999
#define GCI_TYPE_INTERVAL_MONTH_MAX     11
#define GCI_TYPE_INTERVAL_MONTH_MIN      -11
#define GCI_TYPE_INTERVAL_DAY_MAX      999999999
#define GCI_TYPE_INTERVAL_DAY_MIN      -999999999
#define GCI_TYPE_INTERVAL_HOUR_MAX      23
#define GCI_TYPE_INTERVAL_HOUR_MIN      -23
#define GCI_TYPE_INTERVAL_MINUTE_MAX      59
#define GCI_TYPE_INTERVAL_MINUTE_MIN      -59
#define GCI_TYPE_INTERVAL_SECOND_MAX      59
#define GCI_TYPE_INTERVAL_SECOND_MIN      -59
#define GCI_TYPE_INTERVAL_FRA_MAX      99999
#define GCI_TYPE_INTERVAL_FRA_MIN      -99999

#define GCI_DATE_INVALID_DAY            0x1
#define GCI_DATE_DAY_BELOW_VALID        0x2
#define GCI_DATE_INVALID_MONTH          0x4
#define GCI_DATE_MONTH_BELOW_VALID      0x8
#define GCI_DATE_INVALID_YEAR           0x10
#define GCI_DATE_YEAR_BELOW_VALID       0x20
#define GCI_DATE_INVALID_HOUR           0x40
#define GCI_DATE_HOUR_BELOW_VALID       0x80
#define GCI_DATE_INVALID_MINUTE         0x100
#define GCI_DATE_MINUTE_BELOW_VALID     0x200
#define GCI_DATE_INVALID_SECOND         0x400
#define GCI_DATE_SECOND_BELOW_VALID     0x800
#define GCI_DATE_DAY_MISSING_FROM_1582  0x1000
#define GCI_DATE_YEAR_ZERO              0x2000
#define GCI_DATE_INVALID_FORMAT         0x8000

#define GCI_INTER_INVALID_DAY           0x1    /*Bad day                                    */
#define GCI_INTER_DAY_BELOW_VALID       0x2    /*Bad day low/high bit (1=low)               */
#define GCI_INTER_INVALID_MONTH         0x4    /*Bad month                                  */
#define GCI_INTER_MONTH_BELOW_VALID     0x8    /*Bad month low/high bit (1=low)             */
#define GCI_INTER_INVALID_YEAR          0x10   /*Bad year                                   */
#define GCI_INTER_YEAR_BELOW_VALID      0x20   /*Bad year low/high bit (1=low)              */
#define GCI_INTER_INVALID_HOUR          0x40   /*Bad hour                                   */
#define GCI_INTER_HOUR_BELOW_VALID      0x80   /*Bad hour low/high bit (1=low)              */
#define GCI_INTER_INVALID_MINUTE        0x100  /*Bad minute                                 */
#define GCI_INTER_MINUTE_BELOW_VALID    0x200  /*Bad minute low/high bit (1=low)            */
#define GCI_INTER_INVALID_SECOND        0x400  /*Bad second                                 */
#define GCI_INTER_SECOND_BELOW_VALID    0x800  /*Bad second low/high bit (1=low)            */
#define GCI_INTER_INVALID_FRACSEC       0x1000 /*Bad fractional second                      */
#define GCI_INTER_FRACSEC_BELOW_VALID   0x2000 /*Bad fractional second low/high bit         */

#define   GCI_DT_INVALID_DAY         0x1                                 /* Bad day */
#define   GCI_DT_INVALID_MONTH       0x4                              /*  Bad MOnth */
#define   GCI_DT_INVALID_YEAR        0x10                               /* Bad YeaR */
#define   GCI_DT_INVALID_HOUR        0x40                              /*  Bad HouR */
#define   GCI_DT_INVALID_MINUTE      0x100                            /* Bad MiNute */
#define   GCI_DT_INVALID_SECOND      0x400                           /*  Bad SeCond */
#define   GCI_DT_INVALID_FRACTION    0x800                           /*  Bad SeCond */
#define   GCI_DT_YEAR_ZERO           0x2000              /* Year may not equal zero */
#define   GCI_DT_INVALID_TIMEZONE    0x4000                        /*  Bad Timezone */
#define   GCI_DT_INVALID_FORMAT      0x8000                /* Bad date format input */
#define   GCI_DT_INVALID_TZHOUR      0x10000     /* Bad timestamp hour format input */
#define   GCI_DT_INVALID_TZMINUTE    0x40000   /* Bad timestamp minute format input */

typedef enum invalid_err_type
{
    E_PARM_IS_NULL=0 ,
    E_DATE_IS_NULL ,
    E_VALID_IS_NULL ,
    E_RESULT_IS_NULL ,
    E_DATE_INVALID,
    E_FMT_INVALID,
    E_DATE_FMT_INVALID,
    E_PARM_IS_INVALID,
    E_DATETIME_IS_NULL,
    E_BUF_TOO_SMALL_INVALID,
    E_WEEK_FORMAT_IS_INVALID,
    E_DATE_YEAR_IS_INVALID,
    E_DATE_MON_IS_INVALID,
    E_DATE_DAY_IS_INVALID,
    E_DATE_HH_IS_INVALID,
    E_DATE_MI_IS_INVALID,
    E_DATE_SS_IS_INVALID,
    E_ERROR_IS_INVALID,
    E_DATETIME_INVALID,
    E_PARM_TYPE_INVALID ,
    E_PARM_TYPE_DIFF ,
    E_FUN,
    E_FUN_YEAR_MONTH,
    E_FUN_DAY_SECOND,
    E_INTERVAL_IS_NULL ,
    E_INTERVAL_INVALID

}invalid_err_type;

struct GCINumber
{
    ub1 GCINumberPart[GCI_NUMBER_SIZE];
};
typedef struct GCINumber GCINumber;

struct GCITime
{
  ub2 GCITimeHH;                     /* hours; range is 0 <= hours <=23 */
  ub2 GCITimeMI;                     /* minutes; range is 0 <= minutes <= 59 */
  ub2 GCITimeSS;                     /* seconds; range is 0 <= seconds <= 59 */
};
typedef struct GCITime GCITime;

/* 
 * GCITime - GCI TiMe portion of date
 *
 * This structure should be treated as an opaque structure as the format
 * of this structure may change. Use GCIDateGetTime/GCIDateSetTime
 * to manipulate time portion of GCIDate.
 */
struct GCIDate
{
  sb2 GCIDateYYYY;         /* gregorian year; range is -4712 <= year <= 9999 */
  ub2 GCIDateMM;                          /* month; range is 1 <= month < 12 */
  ub2 GCIDateDD;                             /* day; range is 1 <= day <= 31 */
  GCITime GCIDateTime;                                               /* time */
};

struct gci_tz_region_offset_map
{
    ub1 tz_region[128];
    ub4 tz_offset;
};

//#define GCIDate struct GCIDate
typedef struct GCIDate GCIDate;
//#define SQL_DATE_STRUCT GCIDate
#define GCIDateGetTime(date, hour, min, sec) \
  { \
     *hour = (date)->GCIDateTime.GCITimeHH; \
     *min = (date)->GCIDateTime.GCITimeMI; \
     *sec = (date)->GCIDateTime.GCITimeSS; \
  }
/*
   NAME: GCIDateGetTime - GCIDate Get Time portion of date
   PARAMETERS:
    date (IN) - date whose time data is retrieved
    hour (OUT) - hour value returned
    min (OUT) - minute value returned
    sec (OUT) - second value returned
   DESCRIPTION:
    Return time inforamtion stored in the given date. The time
    information returned is: hour, minute and seconds.
   RETURNS:
        NONE
 */
typedef struct GCIDateTime GCIDateTime ;           /* GCI DateTime descriptor */
//typedef struct GCIDate GCIDateTime ;           /* GCI DateTime temp for compile */
typedef struct GCIInterval GCIInterval;           /* GCI Interval descriptor */
typedef struct GCIRowid GCIRowid;                 /* GCI rowid descriptor */
typedef struct GCIString GCIString;               /* GCI string descriptor */
typedef ub1     boolean;
/*--------------------------- GCIDateGetDate --------------------------------*/
/* void GCIDateGetDate(/o_ CONST GCIDate *date, sb2 *year, ub1 *month, 
                           ub1 *day _o/); */
#define GCIDateGetDate(date, year, month, day) \
  { \
     *year = (date)->GCIDateYYYY; \
     *month = (date)->GCIDateMM; \
     *day = (date)->GCIDateDD; \
  }
/*
   NAME: GCIDateGetDate - GCIDate Get Date (year, month, day) portion of date
   PARAMETERS:
    date (IN) - date whose year, month, day data is retrieved
    year (OUT) - year value returned
    month (OUT) - month value returned
    day (OUT) - day value returned
   DESCRIPTION:
    Return year, month, day inforamtion stored in the given date.
   RETURNS:
        NONE
 */

/*--------------------------- GCIDateSetTime --------------------------------*/
/* void GCIDateSetTime(/o_ GCIDate *date, ub1 hour, ub1 min, 
                           ub1 sec _o/); */
#define GCIDateSetTime(date, hour, min, sec) \
  { \
     (date)->GCIDateTime.GCITimeHH = hour; \
     (date)->GCIDateTime.GCITimeMI = min; \
     (date)->GCIDateTime.GCITimeSS = sec; \
  }
/*
   NAME: GCIDateSetTime - GCIDate Set Time portion of date
   PARAMETERS:
    date (OUT) - date whose time data is set
    hour (IN) - hour value to be set
    min (IN) - minute value to be set
    sec (IN) - second value to be set
   DESCRIPTION:
    Set the date with the given time inforamtion.
   RETURNS:
        NONE
 */

/*--------------------------- GCIDateSetDate --------------------------------*/
/* void GCIDateSetDate(/o_ GCIDate *date, sb2 year, ub1 month, ub1 day _o/); */
#define GCIDateSetDate(date, year, month, day) \
  { \
     (date)->GCIDateYYYY = year; \
     (date)->GCIDateMM = month; \
     (date)->GCIDateDD = day; \
  }
     /*----- values for cflg argument to GCIDirpathColArrayEntrySet -----*/
#define GCI_DIRPATH_COL_COMPLETE 0                /* column data is complete */
#define GCI_DIRPATH_COL_NULL     1                         /* column is null */
#define GCI_DIRPATH_COL_PARTIAL  2                 /* column data is partial */
#define GCI_DIRPATH_COL_ERROR    3               /* column error, ignore row */

// GCILogon2() api mode
#define CONNECT_DATABASE_NO                0            // connect to server without database name
#define CONNECT_DATABASE_YES               1            // connect to server and open database.
#define CONNECT_DELIMIDENT                 2            // connect to server and support delimident.
#define CONNECT_DELIMIDENT_NODB            3            // connect to server, support delimient and without database name

#define GCI_LOGON2_SPOOL                0x0001
#define GCI_LOGON2_CPOOL                GCI_CPOOL
#define GCI_LOGON2_STMTCACHE            0x0004
#define GCI_LOGON2_PROXY                0x0008


typedef struct GCIDirPathCtx      GCIDirPathCtx;                  /* context */
typedef struct GCIDirPathColArray GCIDirPathColArray;        /* column array */
typedef struct GCIDirPathStream   GCIDirPathStream;                /* stream */

GCI_API sword
GCIInitialize(
    ub4 mode,
    dvoid *ctxp,
    dvoid *(*malocfp)(
        dvoid *ctxp,
        size_t size
        ),
    dvoid *(*ralocfp)(
        dvoid *ctxp,
        dvoid *memptr,
        size_t newsize
        ),
    void (*mfreefp)(
        dvoid *ctxp,
        dvoid *memptr
        )
    );
GCI_API sword
GCIEnvInit(
    GCIEnv **envp, 
    ub4 mode, 
    size_t xtramem_sz, 
    dvoid **usrmempp
    );

GCI_API sword
GCIServerVersion(
    void  *hndlp,
    GCIError *errhp,
    sb1 *bufp, 
    ub4 bufsz,
    ub1 hndltype
    );
GCI_API sword
GCIServerSession(
    void  *hndlp,
    GCIError *errhp,
    sb1 *bufp, 
    ub4 bufsz,
    ub1 hndltype
    );

GCI_API sword    
GCIEnvCreate(
    GCIEnv **envhpp, 
    ub4 mode, 
    CONST dvoid *ctxp, 
    CONST dvoid *(*malocfp)(
        dvoid *ctxp, 
        size_t size
        ), 
    CONST dvoid *(*ralocfp)(
        dvoid *ctxp, 
        dvoid *memptr, 
        size_t newsize
        ), 
    CONST void (*mfreefp)(
        dvoid *ctxp, 
        dvoid *memptr
        ), 
    size_t xtramemsz, 
    dvoid **usrmempp
    );

GCI_API sword   
GCIHandleAlloc(
    dvoid *parenth, 
    dvoid **hndlpp, 
    CONST ub4 type, 
    CONST size_t xtramem_sz, 
    dvoid **usrmempp
    );

GCI_API sword   
GCIHandleFree(
    dvoid *hndlp, 
    CONST ub4 type
    );

GCI_API sword   
GCIAttrSet(
    dvoid *trgthndlp, 
    ub4 trghndltyp, 
    dvoid *attributep,
    ub4 size, 
    ub4 attrtype, 
    GCIError *errhp
    );

GCI_API sword   
GCISessionBegin(
    GCISvcCtx *svchp, 
    GCIError *errhp, 
    GCISession *usrhp,
    ub4 credt, 
    ub4 mode
    );

GCI_API sword   
GCIServerAttach(
    GCIServer *srvhp, 
    GCIError *errhp,
    CONST GCIText *dblink, 
    sb4 dblink_len, 
    ub4 mode
    );
GCI_API sword
GCIStmtPrepareWithSvc(
    GCISvcCtx *svchp,
    GCIStmt *stmtp,
    GCIError *errhp,
    GCIText *stmt,
    ub4 stmt_len,
    ub4 language,
    ub4 mode
    );
GCI_API sword   
GCIStmtPrepare(
    GCIStmt *stmtp, 
    GCIError *errhp, 
    GCIText *stmt,
    ub4 stmt_len, 
    ub4 language, 
    ub4 mode
    );

GCI_API sword   
GCIStmtExecute(
    GCISvcCtx *svchp, 
    GCIStmt *stmtp, 
    GCIError *errhp, 
    ub4 iters, 
    ub4 rowoff, 
    CONST GCISnapshot *snap_in, 
    GCISnapshot *snap_out, 
    ub4 mode
    );
GCI_API sword
GCIStmtFetchWithSvc(
    GCISvcCtx *svchp,
    GCIStmt *stmtp,
    GCIError *errhp,
    ub4 nrows,
    ub2 orientation,
    ub4 mode
);
GCI_API sword   
GCIStmtFetch(
    GCIStmt *stmtp, 
    GCIError *errhp, 
    ub4 nrows, 
    ub2 orientation, 
    ub4 mode
    );

GCI_API sword   
GCIDefineByPos(
    GCIStmt *stmtp, 
    GCIDefine **defnp, 
    GCIError *errhp,
    ub4 position, 
    dvoid *valuep, 
    sb4 value_sz, 
    ub2 dty,
    dvoid *indp, 
    ub2 *rlenp, 
    ub2 *rcodep, 
    ub4 mode
    );

GCI_API sword   
GCIErrorGet(
    dvoid *hndlp, 
    ub4 recordno, 
    GCIText *sqlstate,
    sb4 *errcodep, 
    GCIText *bufp, 
    ub4 bufsiz, 
    ub4 type
    );

GCI_API sword
GCIBindByPos(
    GCIStmt *stmtp, 
    GCIBind **bindp, 
    GCIError *errhp,
    ub4 position, 
    dvoid *valuep, 
    sb4 value_sz,
    ub2 dty, 
    dvoid *indp, 
    ub2 *alenp, 
    ub2 *rcodep,
    ub4 maxarr_len, 
    ub4 *curelep, 
    ub4 mode
    );

GCI_API sword   
GCIBindByName(
    GCIStmt *stmtp, 
    GCIBind **bindp, 
    GCIError *errhp,
    CONST GCIText *placeholder, 
    sb4 placeh_len, 
    dvoid *valuep, 
    sb4 value_sz, 
    ub2 dty, 
    dvoid *indp, 
    ub2 *alenp, 
    ub2 *rcodep, 
    ub4 maxarr_len, 
    ub4 *curelep, 
    ub4 mode
    );

typedef sb4 (*GCICallbackInBind)(
    void  *ictxp,
    GCIBind *bindp,
    ub4 iter,
    ub4 index,
    void  **bufpp,
    ub4 *alenp,
    ub1 *piecep,
    void  **indp
);

typedef sb4 (*GCICallbackOutBind)(
    void  *octxp,
    GCIBind *bindp,
    ub4 iter,
    ub4 index,
    void **bufpp,
    ub4 **alenp,
    ub1 *piecep,
    void  **indp,
    ub2 **rcodep
);

GCI_API sword GCIBindDynamic(
    GCIBind *bindp,
    GCIError *errhp,
    void  *ictxp,
    GCICallbackInBind icbfp,
    void  *octxp,
    GCICallbackOutBind ocbfp
);

typedef sb4 (*GCICallbackDefine)(
    void  *octxp,
    GCIDefine *defnp,
    ub4 iter,
    void  **bufpp,
    ub4 **alenp,
    ub1 *piecep,
    void  **indp,
    ub2 **rcodep
);

GCI_API sword GCIDefineDynamic(
    GCIDefine *defnp,
    GCIError *errhp,
    void *octxp,
    GCICallbackDefine ocbfp
);

GCI_API sword   
GCILogon(
    GCIEnv *envhp, 
    GCIError *errhp, 
    GCISvcCtx **svchp, 
    CONST GCIText *username, 
    ub4 uname_len, 
    CONST GCIText *password, 
    ub4 passwd_len, 
    CONST GCIText *dbname, 
    ub4 dbname_len
    );
GCI_API sword   
GCILogon2(
    GCIEnv *envhp, 
    GCIError *errhp, 
    GCISvcCtx **svchp, 
    CONST GCIText *username, 
    ub4 uname_len, 
    CONST GCIText *password, 
    ub4 passwd_len, 
    CONST GCIText *dbname, 
    ub4 dbname_len,
    ub4 mode
    );

GCI_API sword   
GCILogonNoDb(
    GCIEnv *envhp, 
    GCIError *errhp, 
    GCISvcCtx **svchp, 
    CONST GCIText *username, 
    ub4 uname_len, 
    CONST GCIText *password, 
    ub4 passwd_len, 
    CONST GCIText *dbname, 
    ub4 dbname_len
    );

GCI_API sword   
GCILogoff(
    GCISvcCtx *svchp, 
    GCIError *errhp
    );

GCI_API sword   
GCITransCommit(
    GCISvcCtx *svchp, 
    GCIError *errhp, 
    ub4 flags
    );

GCI_API sword
GCITransRollback(
    GCISvcCtx *svchp, 
    GCIError *errhp, 
    ub4 flags
    );

GCI_API sword   
GCIServerDetach(
    GCIServer *srvhp, 
    GCIError *errhp, 
    ub4 mode
    );

GCI_API sword   
GCISessionEnd(
    GCISvcCtx *svchp, 
    GCIError *errhp, 
    GCISession *usrhp, 
    ub4 mode
    );

GCI_API sword   
GCIAttrGet(
    CONST dvoid *trgthndlp, 
    ub4 trghndltyp, 
    dvoid *attributep, 
    ub4 *sizep, 
    ub4 attrtype, 
    GCIError *errhp
    );

GCI_API sword   
GCIAttrSet(
    dvoid *trgthndlp, 
    ub4 trghndltyp, 
    dvoid *attributep,
    ub4 size, 
    ub4 attrtype, 
    GCIError *errhp
    );

GCI_API sword   
GCIParamGet(
    CONST dvoid *hndlp, 
    ub4 htype, 
    GCIError *errhp, 
    dvoid **parmdpp, 
    ub4 pos
    );

GCI_API sword   
GCIParamSet(
    dvoid *hdlp, 
    ub4 htyp, 
    GCIError *errhp, 
    CONST dvoid *dscp,
    ub4 dtyp, 
    ub4 pos
    );

GCI_API sword   
GCIDescribeAny(
    GCISvcCtx *svchp, 
    GCIError *errhp, 
    dvoid *objptr, 
    ub4 objnm_len, 
    ub1 objptr_typ, 
    ub1 info_level,
    ub1 objtyp, 
    GCIDescribe *dschp
    );

GCI_API sword   
GCIBindArrayOfStruct(
    GCIBind *bindp, 
    GCIError *errhp, 
    ub4 pvskip, 
    ub4 indskip,
    ub4 alskip, 
    ub4 rcskip
    );

GCI_API sword   
GCIDefineArrayOfStruct(
    GCIDefine *defnp, 
    GCIError *errhp, 
    ub4 pvskip,
    ub4 indskip, 
    ub4 rlskip, 
    ub4 rcskip
    );

GCI_API sword   
GCIDescriptorAlloc(
    CONST dvoid *parenth, 
    dvoid **descpp, 
    CONST ub4 type, 
    CONST size_t xtramem_sz, 
    dvoid **usrmempp
    );

GCI_API sword
GCIDescriptorFree(
    dvoid *descp, 
    CONST ub4 type
    );

typedef sb4 (*GCICallbackLobWrite)(void  *ctxp, void  *bufp,
    ub4 *lenp, ub1 *piece);

GCI_API sword   
GCILobWrite(
    GCISvcCtx *svchp, 
    GCIError *errhp, 
    GCILobLocator *locp,
    ub4 *amtp, 
    ub4 offset, 
    dvoid *bufp, 
    ub4 buflen, 
    ub1 piece, 
    dvoid *ctxp,
    GCICallbackLobWrite cbfp,
    ub2 csid, 
    ub1 csfrm
    );

GCI_API sword   
GCILobGetLength(
    GCISvcCtx *svchp, 
    GCIError *errhp,
    GCILobLocator *locp,
    ub4 *lenp
    );

typedef sb4 (*GCICallbackLobRead)(void  *ctxp, const void  *bufp,
        ub4 len, ub1 piece);

GCI_API sword
GCILobRead(
    GCISvcCtx *svchp, 
    GCIError *errhp, 
    GCILobLocator *locp,
    ub4 *amtp, 
    ub4 offset, 
    dvoid *bufp, 
    ub4 bufl, 
    dvoid *ctxp, 
    GCICallbackLobRead cbfp,
    ub2 csid, 
    ub1 csfrm
    );

//gci_3 for test
GCI_API sword 
_GCILobPtrCreate(
    GCIStmt *stmthp,
    GCISvcCtx *svchp,
    GCIError *errhp, 
    GCILobLocator **locp
    );
GCI_API sword _GCIStmtProcKeyword(sb1* stmt,sb1* adaptStmt,ub4 u4stmtlen,ub1 *pu1MatchNum,ub1 *pu1MatchType);
GCI_API sword _GCIStmtLobKeyword(GCIStmt *stmthp,GCISvcCtx* svchp,GCIError *errhp,sb1* stmt,sb1* adaptStmt,ub4 u4stmtlen,ub1 *pu1MatchNum,ub1 *pu1MatchType);
GCI_API sword _GCILobCloselo(GCIError *errhp,GCILobLocator * descpp);
GCI_API sword _GCIReplaUpdateLob(sb1 **littlestmt,sb1* stmt);

//<SMR-YYL-2011062701> ===> BEGIN
GCI_API sword 
GCILobCopy(
     GCISvcCtx        *svchp,
     GCIError         *errhp,
     GCILobLocator    *dst_locp,
     GCILobLocator    *src_locp,
     ub4              amount,
     ub4              dst_offset,
     ub4              src_offset 
);
GCI_API sword 
GCILobTrim(
    GCISvcCtx      *svchp,
    GCIError       *errhp,
    GCILobLocator  *locp,
    ub4            newlen
);

GCI_API sword GCILobAssign(
    GCIEnv              *envhp,
    GCIError            *errhp,
    const GCILobLocator *src_locp,
    GCILobLocator       **dst_locpp
);
GCI_API sword GCILobLocatorAssign(
    GCISvcCtx           *svchp,
    GCIError            *errhp,
    const GCILobLocator *src_locp,
    GCILobLocator       **dst_locpp
);
GCI_API sword GCILobIsEqual(
    GCIEnv              *envhp,
    const GCILobLocator *x,
    const GCILobLocator *y,
    boolean             *is_equal
);
GCI_API sword GCILobGetChunkSize(
    GCISvcCtx       *svchp,
    GCIError        *errhp,
    GCILobLocator   *locp,
    ub4             *chunk_size
);
GCI_API sword GCILobOpen(
    GCISvcCtx       *svchp,
    GCIError        *errhp,
    GCILobLocator   *locp,
    ub1             mode
);
GCI_API sword GCILobGetLength2(
    GCISvcCtx       *svchp,
    GCIError        *errhp,
    GCILobLocator   *locp,
    gbsub8          *lenp
);
typedef sb4(*GCICallbackLobRead2)(
    void        *ctxp,
    const void  *bufp,
    gbsub8      len,
    ub1         piece,
    void        **changed_bufpp,
    gbsub8      *changed_lenp
);
GCI_API sword GCILobRead2(
    GCISvcCtx           *svchp,
    GCIError            *errhp,
    GCILobLocator       *locp,
    gbsub8              *byte_amtp,
    gbsub8              *char_amtp,
    gbsub8              offset,
    void                *bufp,
    gbsub8              bufl,
    ub1                 piece,
    void                *ctxp,
    GCICallbackLobRead2 cbfp,
    ub2                 csid,
    ub1                 csfrm
);
GCI_API sword GCILobCharSetForm(
    GCIEnv              *envhp,
    GCIError            *errhp,
    const GCILobLocator *locp,
    ub1                 *csfrm
);
GCI_API sword GCILobCharSetId (
    GCIEnv              *envhp,
    GCIError            *errhp,
    const GCILobLocator *locp,
    ub2                 *csid
);
GCI_API sword GCILobErase(
    GCISvcCtx       *svchp,
    GCIError        *errhp,
    GCILobLocator   *locp,
    ub4             *amount,
    ub4             offset
);
GCI_API sword GCILobAppend(
    GCISvcCtx       *svchp,
    GCIError        *errhp,
    GCILobLocator   *dst_locp,
    GCILobLocator   *src_locp
);
GCI_API sword GCILobCopy2(
    GCISvcCtx       *svchp,
    GCIError        *errhp,
    GCILobLocator   *dst_locp,
    GCILobLocator   *src_locp,
    gbsub8          amount,
    gbsub8          dst_offset,
    gbsub8          src_offset
);
GCI_API sword GCILobErase2(
    GCISvcCtx       *svchp,
    GCIError        *errhp,
    GCILobLocator   *locp,
    gbsub8          *amount,
    gbsub8          offset
);
GCI_API sword GCILobTrim2(
    GCISvcCtx       *svchp,
    GCIError        *errhp,
    GCILobLocator   *locp,
    gbsub8          newlen
);
typedef sb4(*GCICallbackLobWrite2)(
    void    *ctxp,
    void    *bufp,
    gbsub8  *lenp,
    ub1     *piecep,
    void    **changed_bufpp,
    gbsub8  *changed_lenp
);
GCI_API sword GCILobWrite2(
    GCISvcCtx               *svchp,
    GCIError                *errhp,
    GCILobLocator           *locp,
    gbsub8                  *byte_amtp,
    gbsub8                  *char_amtp,
    gbsub8                  offset,
    void                    *bufp,
    gbsub8                  buflen,
    ub1                     piece,
    void                    *ctxp,
    GCICallbackLobWrite2    cbfp,
    ub2                     csid,
    ub1                     csfrm
);
GCI_API sword GCILobWriteAppend2(
    GCISvcCtx               *svchp,
    GCIError                *errhp,
    GCILobLocator           *locp,
    gbsub8                  *byte_amtp,
    gbsub8                  *char_amtp,
    void                    *bufp,
    gbsub8                  buflen,
    ub1                     piece,
    void                    *ctxp,
    GCICallbackLobWrite2    cbfp,
    ub2                     csid,
    ub1                     csfrm
);
GCI_API sword GCILobWriteAppend(
    GCISvcCtx               *svchp,
    GCIError                *errhp,
    GCILobLocator           *locp,
    ub4                     *amtp,
    void                    *bufp,
    ub4                     buflen,
    ub1                     piece,
    void                    *ctxp,
    GCICallbackLobWrite     cbfp,
    ub2                     csid,
    ub1                     csfrm
);
// copied from ora.h
// used by GCILobCreateTemporary()
typedef ub2 GCIDuration;
#define GCI_DURATION_BEGIN (GCIDuration) 10
#define GCI_DURATION_SESSION (GCIDuration)(GCI_DURATION_BEGIN)
#define GCI_DURATION_CALL (GCIDuration)(GCI_DURATION_BEGIN + 2)
GCI_API sword GCILobCreateTemporary(
    GCISvcCtx       *svchp,
    GCIError        *errhp,
    GCILobLocator   *locp,
    ub2             csid,
    ub1             csfrm,
    ub1             lobtype,
    boolean         cache,
    GCIDuration     duration
);
GCI_API sword GCILobIsTemporary(
    GCIEnv          *envhp,
    GCIError        *errhp,
    GCILobLocator   *locp,
    boolean         *is_temporary
);
GCI_API sword GCILobFreeTemporary(
    GCISvcCtx       *svchp,
    GCIError        *errhp,
    GCILobLocator   *locp
);

GCI_API sword
GCILobLoadFromFile (
    GCISvcCtx    *svchp, 
    GCIError          *errhp, 
    GCILobLocator    *dst_locp, 
    GCILobLocator    *src_locp, 
    ub4                amount, 
    ub4                dst_offset, 
    ub4                src_offset 
); 

GCI_API sword 
GCILobFileExists(
    GCISvcCtx       *svchp,
    GCIError        *errhp,
    GCILobLocator   *filep,
    ub4         *flag 
);
GCI_API sword 
GCILobFileOpen( 
    GCISvcCtx            *svchp,
    GCIError             *errhp,
    GCILobLocator        *filep,
    ub1                  mode 
);
GCI_API sword 
GCILobFileSetName( 
    GCIEnv             *envhp,
    GCIError           *errhp,
    GCILobLocator      **filepp,
    const GCIText      *dir_alias,
    ub2                d_length, 
    const GCIText      *filename, 
    ub2                f_length 
);
GCI_API sword 
GCILobFileClose( 
    GCISvcCtx            *svchp,
    GCIError             *errhp,
    GCILobLocator        *filep 
);
//<SMR-YYL-2011062701> ===> END

GCI_API sword   
GCIStmtFetch2(
    GCIStmt *stmtp, 
    GCIError *errhp, 
    ub4 nrows,
    ub2 orientation, 
    sb4 scrollOffset, 
    ub4 mode
    );

GCI_API sword   
GCIPrepareForUpdate(
    GCISvcCtx *svchp,      //ľ
    GCIStmt *stmtp,        //
    GCIError *errhp,       //Ϣ
    GCIText *db,           //
    ub2 db_len,            //
    GCIText *schema,       //ģʽ
    ub2 schema_len,        //ģʽ
    GCIText *table,        //øúñϱҪΪINT
    ub2 table_len,         //
    GCIText *column,       //µ
    ub2 column_len,        //
    ub4 *itersp            //ؽҪµ
    );

GCI_API sword   
GCIBindParamForUpdate(
    GCISvcCtx *svchp,      //ľ
    GCIStmt *stmtp,        //
    GCIError *errhp,       //Ϣ
    dvoid *value_pkp,      //󶨵ıָ룬ֻintͣҲ˵ֵĴСѾ̶Ϊ4
    ub4 ppkvskip,          //ÿֵֽ֮Ҳֵһֽ
    dvoid *valuep,         //󶨵Ļָ룬ָָдֵڴַ
    sb4 value_sz,          //ֵռֽ
    ub4 pvskip,            //ÿֵļֽҲǸֵһֽ
    ub2 dty,               //еGCI
    dvoid *indp,           //ָʾָ룬ָһsb2ͣŶӦԪĴСֵָΪ-1ʾҪ³һֵ
    ub4 indskip            //ָʾֽҲǸֵһֽ
    );

GCI_API sword   
GCIExecuteForUpdate(
    GCISvcCtx *svchp,      //ľ
    GCIStmt *stmtp,        //
    GCIError *errhp,       //Ϣ
    ub4 rowoff,            //ʼƫƣĬΪ0
    ub4 mode               //µģʽһGCI_DEFAULT(Ҫֶύ),һGCI_COMMIT_ON_SUCCESS³ɹԶύ
    );

GCI_API sword
GCIDirPathPrepare(
    GCIDirPathCtx *dpctx, 
    GCISvcCtx *svchp,
    GCIError  *errhp
    );

GCI_API sword
GCIDirPathColArrayReset(
    GCIDirPathColArray *dpca, 
    GCIError *errhp 
    );

GCI_API sword
GCIDirPathStreamReset(
    GCIDirPathStream *dpstr, 
    GCIError *errhp 
    );

GCI_API sword
GCIDirPathColArrayEntrySet(
    GCIDirPathColArray *dpca, 
    GCIError *errhp,
    ub4 rownum, 
    ub2 colIdx, 
    ub1 *cvalp, 
    ub4 clen,
    ub1 cflg 
    );

GCI_API sword
GCIDirPathDataSave( 
    GCIDirPathCtx *dpctx, 
    GCIError *errhp, 
    ub4 action 
    );

GCI_API sword
GCIDirPathColArrayToStream(
    GCIDirPathColArray *dpca,  
    GCIDirPathCtx *dpctx,
    GCIDirPathStream   *dpstr, 
    GCIError      *errhp,
    ub4 rowcnt, ub4 rowoff
    );

GCI_API sword
GCIDirPathFinish(
    GCIDirPathCtx *dpctx,
    GCIError  *errhp
    );

GCI_API sword
GCIDirPathLoadStream(
    GCIDirPathCtx *dpctx,
    GCIDirPathStream *dpstr,
    GCIError      *errhp
    );

GCI_API sword
GCIDirPathFlushRow(
    GCIDirPathCtx *dpctx,
    GCIError  *errhp
    );

GCI_API sword
GCIDirPathAbort(
    GCIDirPathCtx *dpctx,
    GCIError *errhp
    );

GCI_API sword
GCIStmtGetPieceInfo(
    const GCIStmt *stmtp,
    GCIError *errhp,
    void **hndlpp,
    ub4 *typep,
    ub1 *in_outp,
    ub4 *iterp,
    ub4 *idxp,
    ub1 *piecep);
GCI_API sword
GCIStmtSetPieceInfo(
    void *hndlp,
    ub4 type,
    GCIError *errhp,
    const void *bufp,
    ub4 *alenp,
    ub1 piece,
    const void *indp,
    ub2 *rcodep);
GCI_API sword
GCIPrintMemory();
//<SQLT_INTERVAL_DS> ===> BEGIN SMR-SF-10101101
GCI_API sword 
GCIIntervalGetDaySecond(
    dvoid *hndl, 
    GCIError *err, 
    sb4 *dy, 
    sb4 *hr,
    sb4 *mm,
    sb4 *ss, 
    sb4 *fsec, 
    CONST GCIInterval *result);

GCI_API sword 
GCIIntervalFromText(
    dvoid *hndl, 
    GCIError *err, 
    CONST GCIText *inpstr, 
    size_t str_len, 
    GCIInterval *result);

GCI_API sword 
GCIDateTimeConstruct(
    dvoid  *hndl,
    GCIError *err,
    GCIDateTime *datetime,
    sb2 yr,
    ub1 mnth,
    ub1 dy,
    ub1 hr,
    ub1 mm,
    ub1 ss,
    ub4 fsec,
    GCIText  *timezone,
    size_t timezone_length);
//<SQLT_INTERVAL_DS> ===> END
//<GCITRANS> ===> BEGIN SMR-SF-10101402
GCI_API sword
GCITransStart(
    GCISvcCtx *svchp,
    GCIError *errhp,
    uword timeout,
    ub4 flags);

GCI_API sword
GCITransDetach(
    GCISvcCtx *svchp,
    GCIError *errhp,
    ub4 flags);
//GCITRANS> ===> END

GCI_API sword
GCINumberToReal(
    GCIError *errhp,
    CONST GCINumber *number,
    uword rsl_length,
    dvoid *rsl);

GCI_API sword
GCINumberFromReal(
    GCIError *errhp,
    const void *rnum,
    uword rnum_length,
    GCINumber *number);

GCI_API sword
GCINumberToRealArray(
    GCIError *errhp,
    const GCINumber **number,
    uword elems,
    uword rsl_length,
    void *rsl);

GCI_API sword
GCINumberFromInt(
    GCIError *errhp,
    const void *inum,
    uword inum_length,
    uword inum_s_flag,
    GCINumber *number);

GCI_API sword
GCINumberToInt(
    GCIError *err,
    CONST GCINumber *number,
    uword rsl_length,
    uword rsl_flag,
    dvoid *rsl);

GCI_API sword
GCINumberAdd(
    GCIError *errhp,
    const GCINumber *number1,
    const GCINumber *number2,
    GCINumber *result);

GCI_API sword
GCINumberSub(
    GCIError *errhp,
    const GCINumber *number1,
    const GCINumber *number2,
    GCINumber *result);

GCI_API sword
GCINumberCmp(
    GCIError *errhp,
    const GCINumber *number1,
    const GCINumber *number2,
    sword *result);

GCI_API sword
GCINumberMul(
    GCIError *errhp,
    const GCINumber *number1,
    const GCINumber *number2,
    GCINumber *result);

GCI_API sword
GCINumberDiv(
    GCIError *errhp,
    const GCINumber *number1,
    const GCINumber *number2,
    GCINumber *result);

GCI_API sword
GCINumberTrunc(
    GCIError *errhp,
    const GCINumber *number,
    sword decplace,
    GCINumber *result);

GCI_API sword
GCINumberRound(
    GCIError *errhp,
    const GCINumber *number,
    sword decplace,
    GCINumber *result);

GCI_API sword
GCINumberAbs(
    GCIError *errhp,
    const GCINumber *number,
    GCINumber *result);

GCI_API sword
GCINumberSign(
    GCIError *errhp,
    const GCINumber *number,
    sword *result);

GCI_API sword
GCINumberNeg(
    GCIError *errhp,
    const GCINumber *number,
    GCINumber *result);

GCI_API sword
GCINumberToText(
    GCIError *errhp,
    const GCINumber *number,
    const GCIText *fmt,
    ub4 fmt_length,
    const GCIText *nls_params,
    ub4 nls_p_length,
    ub4 *buf_size,
    GCIText *buf);

GCI_API sword
GCINumberIsInt(
    GCIError *errhp,
    const GCINumber *number,
    boolean *result);

GCI_API sword
GCINumberIsZero(
    GCIError *errhp,
    const GCINumber *number,
    boolean *result);

GCI_API sword
GCINumberSetZero(
    GCIError *errhp,
    GCINumber *number);

GCI_API sword
GCINumberFloor(
    GCIError *errhp,
    const GCINumber *number,
    GCINumber *result);

GCI_API sword
GCINumberSqrt(
    GCIError *errhp,
    const GCINumber *number,
    GCINumber *result);

GCI_API sword
GCINumberCeil(
    GCIError *errhp,
    const GCINumber *number,
    GCINumber *result);

GCI_API sword
GCINumberAssign(
    GCIError *errhp,
    const GCINumber *from,
    GCINumber *to);

GCI_API sword
GCIStringAssign(
    GCIEnv *envhp,
    GCIError *errhp,
    const GCIString *rhs,
    GCIString **lhs
);

GCI_API sword
GCIStringResize(
    GCIEnv *envhp,
    GCIError *errhp,
    ub4 new_size,
    GCIString **str
);

GCI_API sword
GCIStringAssignText(
    GCIEnv *envhp,
    GCIError *errhp,
    const GCIText *rhs,
    ub4 rhs_len,
    GCIString **lhs
);

GCI_API GCIText *
GCIStringPtr(
    GCIEnv *envhp,
    const GCIString *vc
);

GCI_API ub4
GCIStringSize(
    GCIEnv *envhp,
    const GCIString *vc
);

GCI_API sword
GCIStringAllocSize(
    GCIEnv *envhp,
    GCIError *errhp,
    const GCIString *vs,
    ub4 *allocsize
);

GCI_API sword
GCIDateTimeGetDate ( void *hndl,
    GCIError *err,
    const GCIDateTime *datetime,
    sb2 *year,
    ub1 *month,
    ub1 *day );


GCI_API sword
GCIDateTimeGetTime ( void *hndl,
    GCIError *err,
    GCIDateTime *datetime,
    ub1 *hour,
    ub1 *min,
    ub1 *sec,
    ub4 *fsec );

GCI_API sword
GCIDateTimeGetTimeZoneOffset ( void *hndl,
    GCIError *errhp,
    const GCIDateTime *datetime,
    sb1 *hour,
    sb1 *min );

GCI_API sword
GCIDateTimeGetTimeZoneName(void *hndl,
    GCIError *errhp,
    const GCIDateTime *datetime,
    ub1 *buf,
    ub4 *buflen);

GCI_API sword
GCIDateTimeSysTimeStamp(void *hndl,
    GCIError *errhp,
    GCIDateTime *sys_date);

    GCI_API sword
GCIDateTimeConvert(void  *hndl,
    GCIError *errhp,
    GCIDateTime *indate,
    GCIDateTime *outdate
);

GCI_API sword 
GCIIntervalGetDaySecond (void *hndl,
    GCIError *err,
    sb4 *dy,
    sb4 *hr,
    sb4 *mm,
    sb4 *ss,
    sb4 *fsec,
    const GCIInterval *interval );

GCI_API sword 
GCIIntervalGetYearMonth ( void *hndl,
    GCIError *err,
    sb4 *yr,
    sb4 *mnth,
    const GCIInterval *interval );
GCI_API 
sword GCIDateTimeConstruct ( void *hndl,
    GCIError *err,
    GCIDateTime *datetime,
    sb2 year,
    ub1 month,
    ub1 day,
    ub1 hour,
    ub1 min,
    ub1 sec,
    ub4 fsec,
    GCIText *timezone,
    size_t timezone_length );

GCI_API 
sword GCIIntervalFromText ( void *hndl,
    GCIError *err,
    const GCIText *inpstring,
    size_t str_len,
    GCIInterval *result );

GCI_API 
sword GCIIntervalSetDaySecond ( void *hndl,
    GCIError *err,
    sb4 dy,
    sb4 hr,
    sb4 mm,
    sb4 ss,
    sb4 fsec,
    GCIInterval *result );

GCI_API 
sword GCIIntervalSetYearMonth ( void *hndl,
    GCIError *err,
    sb4 yr,
    sb4 mnth,
    GCIInterval *result );

//for test
GCI_API 
sword GCIIntervalSetAll (void *hndl,
    GCIError *err,
    sb4 yr,
    sb4 mnth,
    sb4 dy,
    sb4 hr,
    sb4 mm,
    sb4 ss,
    sb4 fsec,    
    sb4 type,
    GCIInterval *result);
/*
    detatch the shared memory
*/
GCI_API sword GCITerminate ( ub4 mode);
/*
    break the currently gci if of executing
*/

GCI_API sword GCIBreak ( void *hndlp,
    GCIError *errhp );

/*GCIPasswordChange
    para mode :
    GCI_AUTH
*/

#define     GCI_UTF16  2
#define     GCI_AUTH   4
/*
    change the password
*/
GCI_API sword GCIPasswordChange ( GCISvcCtx *svchp,
    GCIError *errhp,
    const GCIText *user_name,
    ub4 usernm_len,
    const GCIText *opasswd,
    ub4 opasswd_len,
    const GCIText *npasswd,
    sb4 npasswd_len,
    ub4 mode );

/*
    lob if inited
*/
GCI_API sword GCILobLocatorIsInit ( GCIEnv *envhp,
    GCIError *errhp,
    const GCILobLocator *locp,
    boolean *is_initialized );

/*
    open a lob 
*/
GCI_API sword GCILobIsOpen ( GCISvcCtx *svchp,
    GCIError *errhp,
    GCILobLocator *locp,
    boolean *flag );
/*
    close a lob
*/
GCI_API sword GCILobClose ( GCISvcCtx *svchp,
    GCIError *errhp,
    GCILobLocator *locp );

/*
    truncate the lob data before newlen length
*/
GCI_API sword GCILobTrim ( GCISvcCtx *svchp,
    GCIError *errhp,
    GCILobLocator *locp,
    ub4 newlen );


//<SMR-SF-2011071201> ===> BEGIN 
GCI_API sword
GCICloseSvcSocket(
    GCISvcCtx *svchp
);

//<SMR-SF-2011071201> ===> END 
GCI_API sword 
GCITransStop( 
    GCISvcCtx *svchp,
    GCIError *errhp
);

GCI_API sword
GCIDateCheck(GCIError *errhp,
    const  GCIDate *date,
    uword *valid
);
GCI_API sword GCIDateAddDays(
    GCIError *errhp,
    const  GCIDate *date,
    sb4 num_days,
    GCIDate *result
);
GCI_API sword
GCIDateAddMonths(GCIError *err,
    const GCIDate *date,
    sb4 num_months,
    GCIDate *result
);
GCI_API sword GCIDateAssign(GCIError *errhp,
    const GCIDate *from,
    GCIDate *to
);
GCI_API sword GCIDateDaysBetween(GCIError *err,
    const GCIDate *date1,
    const GCIDate *date2,
    sb4  *num_days
);
GCI_API sword GCIDateCompare(GCIError *err,
    const GCIDate *date1,
    const GCIDate *date2,
    sword  *result
);
GCI_API sword GCIDateLastDay(GCIError *err,
    const GCIDate *date,
    GCIDate *last_day
);
GCI_API sword GCIDateSysDate(GCIError *err,
    GCIDate *sys_date
);
GCI_API sword GCIDateNextDay(GCIError *err,
    const GCIDate *date,
    const GCItext *day,
    ub4 day_length,
    GCIDate *next_day
);
GCI_API sword GCIDateToText(GCIError *err,
    const GCIDate *date,
    const GCItext *fmt,
    ub1 fmt_length,
    const GCItext *lang_name,
    ub4 lang_length,
    ub4 *buf_size,
    GCItext *buf
);
GCI_API sword GCIDateFromText(GCIError *err,
    const GCItext *date_str,
    ub4 d_str_length,
    const GCItext *fmt,
    ub1 fmt_length,
    const GCItext *lang_name,
    ub4 lang_length,
    GCIDate *date
);

/*
sword _GCIDateToText ( GCIError *err,  const GCIDate *date,const GCItext *fmt,  ub1 fmt_length,
                           ub4 *buf_size, GCItext *buf , invalid_err_type * err_type );
*/

GCI_API sword GCIIntervalCheck(void *hndl,
    GCIError *errhp,
    const  GCIInterval *interval,
    ub4 *valid
);
GCI_API sword GCIIntervalAssign(void *hndl,
    GCIError *errhp,
    const GCIInterval *inpinter,
    GCIInterval *outinter
);
GCI_API sword GCIIntervalCompare(void *hndl,
    GCIError *err,
    const GCIInterval *inter1,
    const GCIInterval *inter2,
    sword *result
);
GCI_API sword GCIIntervalAdd(void *hndl,
    GCIError *errhp,
    GCIInterval *addend1,
    GCIInterval *addend2,
    GCIInterval *result
);
GCI_API sword GCIIntervalSubtract(void *hndl,
    GCIError *errhp,
    GCIInterval *minuend,
    GCIInterval *subtrahend,
    GCIInterval *result
);
GCI_API sword GCIIntervalToText(void *hndl,
    GCIError *err,
    const GCIInterval *interval,
    ub1 lfprec,
    ub1 fsprec,
    GCItext *buffer,
    size_t buflen,
    size_t *resultlen
);
GCI_API sword GCIIntervalDivide(void *hndl,
    GCIError *errhp,
    GCIInterval *dividend,
    GCINumber *divisor,
    GCIInterval *result
);
GCI_API sword GCIIntervalMultiply(void *hndl,
    GCIError *errhp,
    const GCIInterval *inter,
    GCINumber *nfactor,
    GCIInterval *result
);
GCI_API sword GCIIntervalFromNumber(void *hndl,
    GCIError *errhp,
    GCIInterval *interval,
    GCINumber *number
);
GCI_API sword GCIIntervalToNumber(void *hndl,
    GCIError *errhp,
    GCIInterval *interval,
    GCINumber *number
);
GCI_API sword GCIDateZoneToZone(
    GCIError *errhp,
    const GCIDate *date1,
    const GCIText *zon1,
    ub4 zon1_length,
    const GCIText *zon2,
    ub4 zon2_length,
    GCIDate *date2
);
GCI_API sword
GCIDateTimeCheck ( void *hndl,
    GCIError *errhp,
    const GCIDateTime *date,
    ub4 *valid );

GCI_API sword
GCIDateTimeCompare ( void *hndl,
    GCIError *err,
    const GCIDateTime *date1,
    const GCIDateTime *date2,
    sword *result );

GCI_API sword
GCIDateTimeAssign ( void *hndl,
    GCIError *err,
    const GCIDateTime *from,
    GCIDateTime *to );

GCI_API sword
GCIDateTimeToText ( void *hndl,
    GCIError *err,
    const GCIDateTime *date,
    const GCItext *fmt,
    ub1 fmt_length,
    ub1 fsprec,
    const GCItext *lang_name,
    size_t lang_length,
    ub4 *buf_size,
    GCItext *buf );

GCI_API sword
GCIDateTimeToArray ( void *hndl,
    GCIError *errhp,
    const GCIDateTime *datetime,
    const GCIInterval *reftz,
    ub1 *outarray,
    ub4 *len,
    ub1 fsprec );

GCI_API sword
GCIDateTimeIntervalAdd(void *hndl,
    GCIError *errhp,
    GCIDateTime *datetime,
    GCIInterval *interval,
    GCIDateTime *outdatetime );

GCI_API sword
GCIDateTimeIntervalSub(
    void *hndl,
    GCIError *errhp,
    GCIDateTime *datetime,
    GCIInterval *interval,
    GCIDateTime *outdatetime);

GCI_API sword
GCIDateTimeSubtract(
    void *hndl,
    GCIError *errhp,
    GCIDateTime *indate1,
    GCIDateTime *indate2,
    GCIInterval *inter);

GCI_API sword
GCIDateTimeFromText(
    void *hndl,
    GCIError *errhp,
    const GCIText *date_str,
    size_t dstr_length,
    const GCIText *fmt,
    ub1 fmt_length,
    const GCIText *lang_name,
    size_t lang_length,
    GCIDateTime *datetime);

GCI_API sword
GCIDateTimeFromArray(
    void *hndl,
    GCIError *errhp,
    const ub1 *inarray,
    ub4 *len,
    ub1 type,
    GCIDateTime *datetime,
    const GCIInterval *reftz,
    ub1 fsprec);

GCI_API sword GCIStmtPrepare2 (
    GCISvcCtx *svchp,
    GCIStmt **stmthp,
    GCIError *errhp,
    const GCIText *stmttext,
    ub4 stmt_len,
    const GCIText *key,
    ub4 keylen,
    ub4 language,
    ub4 mode
);

GCI_API sword GCIThreadClose(
    void *hndl,
    GCIError *err,
    GCIThreadHandle *tHnd
);

GCI_API sword GCIThreadCreate(
    void *hndl,
    GCIError *err,
    void (*start)(void *),
    void *arg,
    GCIThreadId *tid,
    GCIThreadHandle *tHnd
);

GCI_API sword GCIThreadHndDestroy(
    void *hndl,
    GCIError *err,
    GCIThreadHandle **thnd
);

GCI_API sword GCIThreadHndInit(
    void *hndl,
    GCIError *err,
    GCIThreadHandle **thnd
);

GCI_API sword GCIThreadIdDestroy(
    void *hndl,
    GCIError *err,
    GCIThreadId **tid
);

GCI_API sword GCIThreadIdInit(
    void *hndl,
    GCIError *err,
    GCIThreadId **tid
);

GCI_API sword GCIThreadInit(
    void *hndl,
    GCIError *err
);

GCI_API sword GCIThreadJoin(
    void *hndl,
    GCIError *err,
    GCIThreadHandle *tHnd
);

GCI_API sword GCIThreadMutexAcquire(
    void *hndl,
    GCIError *err,
    GCIThreadMutex *mutex
);

GCI_API sword GCIThreadMutexDestroy(
    void *hndl,
    GCIError *err,
    GCIThreadMutex **mutex
);

GCI_API sword GCIThreadMutexInit(
    void *hndl,
    GCIError *err,
    GCIThreadMutex **mutex
);

GCI_API sword GCIThreadMutexRelease(
    void *hndl,
    GCIError *err,
    GCIThreadMutex *mutex
);

GCI_API void GCIThreadProcessInit();

GCI_API sword GCIThreadTerm(
    void *hndl,
    GCIError *err
);

GCI_API sword GCIThreadIdSame(
    void *hndl,
    GCIError *err,
    GCIThreadId *tid1,
    GCIThreadId *tid2,
    boolean *result
);

GCI_API sword GCIThreadIdGet(
    void *hndl,
    GCIError *err,
    GCIThreadId *tid
);

GCI_API sword GCIThreadIdNull(
    void *hndl,
    GCIError *err,
    GCIThreadId *tid,
    boolean *result
);

GCI_API sword GCIThreadIdSet(
    void *hndl,
    GCIError *err,
    GCIThreadId *tidDest,
    GCIThreadId *tidSrc
);

GCI_API sword GCIThreadIdSetNull(
    void *hndl,
    GCIError *err,
    GCIThreadId *tid
);

GCI_API sword GCIStmtRelease(
    GCIStmt *stmtp,
    GCIError *errhp,
    const GCIText *key,
    ub4 key_len,
    ub4 mode
);

GCI_API sword GCIPing(GCISvcCtx *svchp,
    GCIError *errhp,
    ub4 mode
);
GCI_API ub2 GCINlsCharSetNameToId(
    void *hndl,
    const GCIText *name
);

GCI_API sword GCIEnvNlsCreate(
    GCIEnv **envp,
    ub4 mode,
    void *ctxp,
    void *(*malocfp)(
        void *ctxp,
        size_t size
    ),
    void *(*ralocfp)(
        void *ctxp,
        void *memptr,
        size_t newsize
    ),
    void (*mfreefp)(
        void *ctxp,
        void *memptr
    ),
    size_t xtramem_sz,
    void **usrmempp,
    ub2 charset,
    ub2 ncharset
);

GCI_API sword GCIRowidToChar(
    GCIRowid *rowidDesc,
    GCIText *outbfp,
    ub2 *outbflp,
    GCIError *errhp
);

GCI_API sword GCIStmtFetch2(
    GCIStmt *stmtp,
    GCIError *errhp,
    ub4 nrows,
    ub2 orientation,
    sb4 scrollOffset,
    ub4 mode
);

GCI_API sword GCISessionGet(
    GCIEnv *envhp,
    GCIError *errhp,
    GCISvcCtx **svchp,
    GCIAuthInfo *authhp,
    GCIText *poolName,
    ub4 poolName_len,
    const GCIText *tagInfo,
    ub4 tagInfo_len,
    GCIText **retTagInfo,
    ub4 *retTagInfo_len,
    boolean *found,
    ub4 mode
);

GCI_API sword GCIConnectionPoolCreate(
    GCIEnv *envhp,
    GCIError *errhp,
    GCICPool *poolhp,
    GCIText **poolName,
    sb4 *poolNameLen,
    const GCIText *dblink,
    sb4 dblinkLen,
    ub4 connMin,
    ub4 connMax,
    ub4 connIncr,
    const GCIText *poolUserName,
    sb4 poolUserLen,
    const GCIText *poolPassword,
    sb4 poolPassLen,
    ub4 mode
);

GCI_API sword GCIConnectionPoolDestroy(
    GCICPool *poolhp,
    GCIError *errhp,
    ub4 mode
);

GCI_API sword GCISessionRelease(
    GCISvcCtx *svchp,
    GCIError *errhp,
    GCIText *tag,
    ub4 tag_len,
    ub4 mode
);
GCI_API sword GCIStmtGetBindInfo(
    GCIStmt     *stmtp,
    GCIError    *errhp,
    ub4          size,
    ub4          startloc,
    sb4         *found,
    GCIText     *bvnp[],
    ub1          bvnl[],
    GCIText     *invp[],
    ub1          inpl[],
    ub1          dupl[],
    GCIBind     *hndl[]
);
GCI_API sword GCIStmtExecDirect(
    GCISvcCtx           *svchp,
    ub1                 *sql,
    GCIError            *errhp,
    ub4                 *iters,
    ub4                 *rowoff,
    const GCISnapshot   *snap_in,
    GCISnapshot         *snap_out,
    ub4                 mode
);
#define GCI_CPOOL            0x0200  /* Attach using server handle from pool */
#define GCI_SELF_HANDLE 1           /*TODO not find in the GCI env. could be removed. */
#ifdef __cplusplus
}
#endif

#endif
