#include<stdio.h>
#include<stdlib.h>
#include<string.h>

#include "load.h"

int main()
{
    int rc = 0;
    int i;
    fhinstance *instance;
    char *ip = "172.16.2.196";
    char *port = "29662";
    char *username = "root";
    char *password = "111111";
    char *servername = "ol_gbasedbt1210_20231220155402";
    char *dbname = "root";
    char *load = "load from '/home/whf/load.txt' insert into load_test (col_int, col_blob, col_clob, col_text, col_varchar, col_varchar2, col_nvarchar)";
    char *unload = "UNLOAD TO '/home/whf/unload.txt' DELIMITER '|' select * from load_test;";
    long long row_count = 0;
    char *sqlmode = "sqlmode=oracle";
    int err_code;
    char err_msg[256];
    int err_msg_len = 0;

    printf("BEGIN!\n");

    rc = gbs_load_alloc(&instance);
    if (rc != 0)
    {
        printf("error1:gbs_load_alloc\n");
        return 0;
    }

    rc = gbs_load_initialize(instance, ip, port, servername, dbname, username, password, sqlmode);
    if (rc != 0)
    {
        gbs_get_diag(instance, &err_code, err_msg, 256, &err_msg_len);
        printf("error2:gbs_load_initialize err_code = %d, err_msg = %s, err_msg_len = %d\n", err_code, err_msg, err_msg_len);
        return 0;
    }

    rc = gbs_load_execute(instance, load, &row_count);
    if (rc != 0)
    {
        gbs_get_diag(instance, &err_code, err_msg, 256, &err_msg_len);
        printf("error3:gbs_load_execute err_code = %d, err_msg = %s, err_msg_len = %d\n", err_code, err_msg, err_msg_len);
        return 0;
    }
    printf("Loaded successfully row_count:%d\n", row_count);

    rc = gbs_load_execute(instance, unload, &row_count);
    if (rc != 0)
    {
        gbs_get_diag(instance, &err_code, err_msg, 256, &err_msg_len);
        printf("error4:gbs_load_execute err_code = %d, err_msg = %s, err_msg_len = %d\n", err_code, err_msg, err_msg_len);
        return 0;
    }
    printf("Unloaded successfully row_count:%d\n", row_count);

    rc = gbs_load_uninitialize(instance);
    if (rc != 0)
    {
        gbs_get_diag(instance, &err_code, err_msg, 256, &err_msg_len);
        printf("error5:gbs_load_uninitialize err_code = %d, err_msg = %s, err_msg_len = %d\n", err_code, err_msg, err_msg_len);
        return 0;
    }

    rc = gbs_load_free(instance);
    if (rc != 0)
    {
        printf("error6:gbs_load_free\n");
        return 0;
    }

    printf("SUCCESS!\n");


    return 0;
}
