/***************************************************************************
 *	GBase 8s GCI Interface test 
 *      Author:xuliya
 *      Date:2018-04-11
 *
 *  Description:    Test GCIInterval for support "char cut"
 *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gci.h"

#define SELSQL_LEN     25
#define ERRMSG_LEN     200

char *createchartable = "create table charcut (str1 char(10))";
char *dropchartable = "drop table charcut";
//char *inserttable = "insert into charcut(str1)  values('0123456')";
char *inserttable = "insert into charcut(str1)  values(?)";
char * selectcharcut = "select str1 from charcut";

//logout db
int logdb(GCIEnv **envhp1,GCIError **errhp1,GCISvcCtx **svchp1)
{
	int rc = GCI_SUCCESS;
	
	///connect db
	GCIEnv *envhp= NULL;
	GCISvcCtx *svchp= NULL;
	GCIError *errhp = NULL;
	GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";

	/*  STEP 1. Get data source name from command line (or use default)
	 **          Allocate the environment handle and set ODBC version
	 **          Allocate the connection handle
	 **          Establish the database connection
	 **          Allocate the statement handle
	 **          Drop demo database if it already exists
	 */
	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
				0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}

	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
				GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}	

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
				GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}
	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
				pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{

		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto logdbEXIT;
	}
	*envhp1 = envhp;
	*errhp1 = errhp;
	*svchp1 = svchp;


	fprintf (stdout, "Step 1 done...connected to database.\n");

logdbEXIT:
	*envhp1 = envhp;
	*errhp1 = errhp;
	*svchp1 = svchp;	
	return rc;
}


//create the lob test key
int createtable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp,char *sql)
{

	int rc = 0;
	GCIStmt *stmt = NULL;	
        stmt = NULL;
	//alloc the stmt handle
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto createlobtableEXIT;
	}
#if 1
	rc = GCIStmtPrepare(stmt, errhp, (GCIText *)sql, strlen(sql), 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createtable stmt prepare -- !!\n");
		goto createlobtableEXIT;
	}
	if ((rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS)) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto createlobtableEXIT;
	}
	#endif
	printf("===============================\n");
        createlobtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;
}

int insertchartable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
        int rc = 0;
        GCIStmt *stmt = NULL;
        GCIBind *Bindp[5];
        
         //char s[50] ="012345678";
        //char s[50] ="012345678ʱ";
       char s[50] ="01234?8";
       // char s[50] ="012345678";
        //char s[50] ="012345";
       // char s[50] ="012345";
	printf("=============s len %d\n",	strlen(s));
        printf("=============s= %s\n",       s);
       //յ11λַ
       s[10]=0;
       //ڵ10ַ
        //s[3]=0xce;
	
        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
                                GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
        {
                fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
                goto insertmultithreadtableEXIT;
        }


        rc = GCIStmtPrepare(stmt, errhp, (GCIText *)inserttable, strlen(inserttable) + 1, 0, GCI_DEFAULT);
        if(GCI_SUCCESS != rc)
        {
                fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
                goto insertmultithreadtableEXIT;
        }
#if 1   
        if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(char *)s, 49,SQLT_CHR,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    //    if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(char *)s, 10,SQLT_CHR,GCI_DEFAULT))
        {
            printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
            goto insertmultithreadtableEXIT;
 }

        rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
                                GCI_COMMIT_ON_SUCCESS);
        if(rc)
        {
                goto insertmultithreadtableEXIT;
        }

#else
#endif
        printf("insert char successful\n");

        insertmultithreadtableEXIT:
        GCIHandleFree(stmt, GCI_HTYPE_STMT);
        return rc;
}


int droptable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp,char *dropsql)
{
	int rc = 0;
	GCIStmt *stmt;	
        stmt = NULL;
	//alloc the stmt handle
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test droptable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto droplobtableEXIT;
	}

	rc = GCIStmtPrepare(stmt, errhp, (GCIText *)dropsql, strlen(dropsql) , 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in droptable stmt prepare -- !!\n");
		goto droplobtableEXIT	;
	}
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto droplobtableEXIT;
	}

droplobtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;

}


int main (long argc,
		char* argv[])
{
	ub4			i, in;

	ub1         verInfoBuffer[SELSQL_LEN];
	ub4			verInfoLen;
	ub1         majorVer[3];
	ub4      	isUdoEnabled;
	int rc = 0;
	/* Handles */
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;
	GCIStmt *stmthp1 = NULL;
	GCIStmt *stmthp2 = NULL;
	int fd = 0;

	
 	rc = logdb(&envhp,&errhp,&svchp);
	if(rc)
	{
		
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto EXIT;
	}
	rc = droptable(envhp,svchp,errhp,dropchartable);
	rc = createtable(envhp,svchp,errhp,createchartable);	
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf (stdout, "create table failure.\n");
		goto EXIT;
	}	
	fprintf (stdout, "create table success.\n");
	

        rc = insertchartable(envhp,svchp,errhp);
        if(rc)
        {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "insert char table \nError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
                fprintf (stdout, "insert table failure.\n");
                goto EXIT;
        }

	fprintf (stdout,"\nHit <Enter> to continue...");
	in = getchar ();

EXIT:

	/* CLEANUP: Close the statement handle
	 **          Free the statement handle
	 **          Disconnect from the datasource
	 **          Free the connection and environment handles
	 **          Exit
	 */
	if(stmthp1)
		GCIHandleFree((dvoid *)stmthp1, GCI_HTYPE_STMT);

	if(stmthp2)
		GCIHandleFree((dvoid *)stmthp2, GCI_HTYPE_STMT);

	GCILogoff(svchp, errhp);

	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);

	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);


	fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
	in = getchar ();

	return (rc);
}

