/***************************************************************************
 *	Licensed Materials - Property of GBase
 *
 *
 *	"Restricted Materials of GBase"
 *
 *
 *
 *	GBase 8s GCI Interface demo
 *
 *
 *	Copyright GBase Corporation 2015 All rights reserved.
 *    Title:          test_datconvert.c
 *
 *  Description:    To retrieve results from the database and display it. 
 *                  This example also illustrates the fact
 *                  that the same client functions can use row and column
 *                  store buffer.
 *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gci.h"

#define SELSQL_LEN     25
#define ERRMSG_LEN     200
char *createdattable = "create table datconvert (dat_id int primary key,date_time timestamp,d1 datetime year to second,d2 datetime year to fraction(5),d3 datetime year to day,d4 datetime hour to second,d5 date,dec1 dec(3,0),dec2 dec(5,0),dec3 dec(7,0),c1 char(100),c2 varchar(100),c3 lvarchar(1000),\
daaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaad int)";
char *createdectable = "create table decconvert (dat_id int primary key,dec1 dec(3,0),dec2 dec(5,0),dec3 dec(10,0),dec4 dec(20,0))";
char *createfloattable = "create table decconvert1 (dat_id int primary key,dec1 dec(7),dec2 dec(16),dec3 dec(32),f1 float(24),f2 float(50))";
char *insertdatadec1table = "insert into  decconvert1(dat_id,dec1,dec2,f1,f2) values(?,?,?,?,?)";
char *selectdatadec1table = "select dat_id,dec1,dec2,f1,f2 from decconvert1";
char *dropflttable1 =  "drop table decconvert1 ";

char *dropdattable = "drop table datconvert";
char *dropdectable = "drop table decconvert";
char *insertdatadectable = "insert into  decconvert(dat_id,dec1,dec2,dec3,dec4) values(?,?,?,?,?)";

//char *insertdatadattable = "insert into  datconvert(dat_id,date_time) values(?,?)";
char *insertdatadattable = "insert into  datconvert(dat_id,d2) values(?,?)";
char *insertdata2dattable = "insert into  datconvert(dat_id,date_time) values(?,?)"; //'1999-01-01'
char *updatedatadattable = "update datconvert set date_time= ? where dat_id = ?";

	
char * selectdatetime = "select sysdate from sysmaster:sysdual";
char * selectdatconvert = "select dat_id,date_time,d3,d4,d5 ,c1,c2,c3,\
daaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaad from datconvert";
char * selectdecconvert = "select dat_id,dec1,dec2,dec3,dec4 from decconvert";

char * selecttestdatetime = "select to_date('201608300000','YYYYMMDDHHMI') as dm_datetime";
char * selecttestdatetime1 = "select dat_id,date_time ,d4,d5 from datconvert where dat_id >6000 ";

char *createflttable =  "create table fltconvert (dat_id int primary key,r1 real,r2 float,r3 double precision)";
char *insertflttable =  "insert into fltconvert values(?,?,?,?)";
char *updateflttable =  "update fltconvert set r1=? ,r2 = ? r3 = ? where dat_id = ?";
char *deleteflttable =  "delete from fltconvert where dat_id=?";
char *dropflttable =  "drop table fltconvert ";

char *selectflttable =  "select * from fltconvert ";


int logdb(GCIEnv **envhp1,GCIError **errhp1,GCISvcCtx **svchp1)
{
	int rc = GCI_SUCCESS;
	
	///connect db
	GCIEnv *envhp= NULL;
	GCISvcCtx *svchp= NULL;
	GCIError *errhp = NULL;
	GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";

	/*  STEP 1. Get data source name from command line (or use default)
	 **          Allocate the environment handle and set ODBC version
	 **          Allocate the connection handle
	 **          Establish the database connection
	 **          Allocate the statement handle
	 **          Drop demo database if it already exists
	 */
	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
				0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}

	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
				GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}	

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
				GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}
	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
				pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto logdbEXIT;
	}
	*envhp1 = envhp;
	*errhp1 = errhp;
	*svchp1 = svchp;


	fprintf (stdout, "Step 1 done...connected to database.\n");

logdbEXIT:
		*envhp1 = envhp;
	*errhp1 = errhp;
	*svchp1 = svchp;	
	return rc;
}
int dropdatconverttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt;	
	//alloc the stmt handle
	//stmt
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto droplobtableEXIT;
	}

	rc = GCIStmtPrepare(stmt, errhp, dropdattable, strlen(dropdattable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto droplobtableEXIT	;
	}
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto droplobtableEXIT;
	}
	GCIHandleFree(stmt, GCI_HTYPE_STMT);
	stmt = NULL;
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto droplobtableEXIT;
	}

	rc = GCIStmtPrepare(stmt, errhp, dropdectable, strlen(dropdectable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto droplobtableEXIT	;
	}
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto droplobtableEXIT;
	}
	
droplobtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;

}
int dropfltconverttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt;	
	//alloc the stmt handle
	//stmt
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto droplobtableEXIT;
	}

	rc = GCIStmtPrepare(stmt, errhp, dropflttable, strlen(dropflttable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto droplobtableEXIT	;
	}
	//鿴
	fprintf(stdout, "break test!!\n");
	rc = GCIBreak(stmt,errhp);
        if (rc)
        {
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto droplobtableEXIT;
            
        }
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto droplobtableEXIT;
	}

	
droplobtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;

}

int dropflt1converttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt;	
	//alloc the stmt handle
	//stmt
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto droplobtableEXIT;
	}

	rc = GCIStmtPrepare(stmt, errhp, dropflttable1, strlen(dropflttable1) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto droplobtableEXIT	;
	}
	//鿴
	fprintf(stdout, "break test!!\n");
	rc = GCIBreak(stmt,errhp);
        if (rc)
        {
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto droplobtableEXIT;
            
        }
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto droplobtableEXIT;
	}

	
droplobtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;

}

int createfltconverttable(GCIEnv *envhp,GCISvcCtx *svchp,
		GCIError *errhp)
{

	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	//stmt
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto createlobtableEXIT;
	}

#if 1
	rc = GCIStmtPrepare(stmt, errhp, createflttable, strlen(createflttable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createflttable stmt prepare -- !!\n");
		goto createlobtableEXIT;
	}
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto createlobtableEXIT;
	}
	#endif


createlobtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;
}
int createflt1converttable(GCIEnv *envhp,GCISvcCtx *svchp,
		GCIError *errhp)
{

	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	//stmt
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto createlobtableEXIT;
	}

#if 1
	rc = GCIStmtPrepare(stmt, errhp, createfloattable, strlen(createfloattable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createflttable stmt prepare -- !!\n");
		goto createlobtableEXIT;
	}
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto createlobtableEXIT;
	}
	#endif


createlobtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;
}
//create the lob test key
int createdatconverttable(GCIEnv *envhp,GCISvcCtx *svchp,
		GCIError *errhp)
{

	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	//stmt
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto createlobtableEXIT;
	}

#if 1
	rc = GCIStmtPrepare(stmt, errhp, createdattable, strlen(createdattable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto createlobtableEXIT;
	}
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto createlobtableEXIT;
	}
	#endif
	GCIHandleFree(stmt, GCI_HTYPE_STMT);
	stmt = NULL;
	//decconvert stmt
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto createlobtableEXIT;
	}

#if 1
	rc = GCIStmtPrepare(stmt, errhp, createdectable, strlen(createdectable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto createlobtableEXIT;
	}
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto createlobtableEXIT;
	}
	#endif	
createlobtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;
}
int selectdatconverttablebyrow(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	GCIDefine *Definep[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num = 0;
	GCIDate d;
	char *dat;
	long *pitem_num;
	GCIDate *datetimestr = NULL;
	sb4 starown = 0;

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	pbuf = malloc(100*(7+sizeof(long)));
	if(NULL == pbuf)
	{
		goto SUCCESS_EXIT;	
	}
	pitem_num = (long *)pbuf;
	dat = pbuf +sizeof(long);
	
	rc = GCIStmtPrepare(stmt, errhp, selectdatconvert, strlen(selectdatconvert) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtPrepare selecttest datetime prepare -- !!\n");
		goto SUCCESS_EXIT;
	}
#if 1	

	if (rc = GCIDefineByPos(stmt, &Definep[4], errhp, 1, (dvoid *)pitem_num,(sb4)sizeof(long), (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[3], errhp, 2, (dvoid *)dat,(sb4)7, (ub2)SQLT_DAT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	

	if (rc = GCIDefineArrayOfStruct(Definep[4], errhp,15, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}

	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);	
    	        goto SUCCESS_EXIT;
	}
		

	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmt, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);

		if(starown == rownum)
			break;

		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving row number %d \ndat:%d %d %d %d %d %d %d\n", i + 1,dat[0 +i *15],dat[1 + i *15],dat[2+ i *15],dat[3+ i *15],dat[4+ i *15],dat[5+ i *15],dat[6+ i *15]);
		}
		starown = rownum;
	}
#else	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	int offset = 0;
	for(i = 0;i < 100;i++)
	{	

		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);
	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	

#endif	

	printf("insertwithbindsql recs\n");
	
SUCCESS_EXIT:
	if(pbuf)
		free(pbuf);
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}

///֤datetime year to second timedate
int selectdatconverttable3(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	GCIDefine *Definep[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num = 0;
	GCIDate d;
	char dat[16*100];
	char dat4[16*100];
	char dat5[16*100];
	sb4 colnum11 = 0;
	long aitem_num[100];
	GCIDate *datetimestr = NULL;
	char *colname = {0};
	char *coltypename = {0};
	GCIParam *param = NULL;
	ub2 type = 0;
	sb4 starown = 0;

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	pbuf = malloc(100*(sizeof(GCIDate)+sizeof(long)));
	if(NULL == pbuf)
	{
		goto SUCCESS_EXIT;	
	}
	rc = GCIStmtPrepare(stmt, errhp, selecttestdatetime1, strlen(selecttestdatetime1) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtPrepare selecttest datetime prepare -- !!\n");
		goto SUCCESS_EXIT;
	}
#if 1	

	if (rc = GCIDefineByPos(stmt, &Definep[4], errhp, 1, (dvoid *)aitem_num,(sb4)sizeof(long), (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[3], errhp, 2, (dvoid *)dat,(sb4)16, (ub2)SQLT_DAT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[4], errhp, 3, (dvoid *)dat4,(sb4)sizeof(long), (ub2)SQLT_DAT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[3], errhp, 4, (dvoid *)dat5,(sb4)16, (ub2)SQLT_DAT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}		

	if (rc = GCIAttrGet (stmt, GCI_HTYPE_STMT,&colnum11, 0,GCI_ATTR_NUM_COLS,errhp) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}		
	printf("selectdatconverttable2 show the colname :colnum %d\n",colnum11);

	for(i = 0;i< colnum11;i++)
	{
		rc = GCIParamGet((CONST dvoid *)stmt,(ub4)GCI_HTYPE_STMT,(GCIError *)errhp,(dvoid **)&param,(ub4)i+1);
		
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&type, 0,GCI_ATTR_DATA_TYPE,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&coltypename, 0,GCI_ATTR_TYPE_NAME,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}			
		fprintf(stdout, "selectdatconverttable2 show the colname %s coltype %d col type %s\n",colname,type,coltypename);
		memset(colname,0 ,sizeof(colname));
	}
		
	/*
	if (rc = GCIDefineArrayOfStruct(Definep[4], errhp,15, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	*/
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);	
    	        goto SUCCESS_EXIT;
	}
		
	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmt, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);

		if(starown == rownum)
			break;

		if(rownum > 100)
			break;
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving row number 1 %d \ndat:%d %d %d %d %d %d %d\n", i + 1,dat[0 +i *16],dat[1 + i *16],dat[2+ i *16],dat[3+ i *16],dat[4+ i *16],dat[5+ i *16],dat[6+ i *16]);
			fprintf(stdout, "\tRetrieving row number  2%d \ndat:%d %d %d %d %d %d %d\n", i + 1,dat4[0 +i *16],dat4[1 + i *16],dat4[2+ i *16],dat4[3+ i *16],dat4[4+ i *16],dat4[5+ i *16],dat4[6+ i *16]);
			fprintf(stdout, "\tRetrieving row number  3%d \ndat:%d %d %d %d %d %d %d\n", i + 1,dat5[0 +i *16],dat5[1 + i *16],dat5[2+ i *16],dat[3+ i *16],dat5[4+ i *16],dat5[5+ i *16],dat5[6+ i *16]);
			
		}
		starown = rownum;
	}
#else	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	int offset = 0;
	for(i = 0;i < 100;i++)
	{	

		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);
	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	

#endif	

	printf("insertwithbindsql recs\n");
	
SUCCESS_EXIT:
	if(pbuf)
		free(pbuf);
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}


int selectdatconverttable2(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	GCIDefine *Definep[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num = 0;
	GCIDate d;
	char dat[16*100];
	long aitem_num[100];
	char *colname = {0};
	char *coltypename = {0};
	GCIParam *param = NULL;
	ub2 type = 0;
	ub4 datasize = 0;
	sb4 starown = 0;
	sb4 colnum11 = 0;

	GCIDate *datetimestr = NULL;
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	pbuf = (char *)malloc(100*(sizeof(GCIDate)+sizeof(long)));
	if(NULL == pbuf)
	{
		goto SUCCESS_EXIT;	
	}
	rc = GCIStmtPrepare(stmt, errhp,(GCIText *) selectdatconvert, strlen(selectdatconvert) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtPrepare selecttest datetime prepare -- !!\n");
		goto SUCCESS_EXIT;
	}
#if 1	

	if (rc = GCIDefineByPos(stmt, &Definep[4], errhp, 1, (dvoid *)aitem_num,(sb4)sizeof(long), (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[3], errhp, 2, (dvoid *)dat,(sb4)16, (ub2)SQLT_DAT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	

	if (rc = GCIAttrGet (stmt, GCI_HTYPE_STMT,&colnum11, 0,GCI_ATTR_NUM_COLS,errhp) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}		
	printf("selectdatconverttable2 show the colname :colnum %d\n",colnum11);

	for(i = 0;i< colnum11;i++)
	{
		rc = GCIParamGet((CONST dvoid *)stmt,(ub4)GCI_HTYPE_STMT,(GCIError *)errhp,(dvoid **)&param,(ub4)i+1);
		
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&type, 0,GCI_ATTR_DATA_TYPE,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&coltypename, 0,GCI_ATTR_TYPE_NAME,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}			
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&datasize, 0,GCI_ATTR_DATA_SIZE,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}			        
		fprintf(stdout, "selectdatconverttable2 show the colname %s coltype %d col type %s,datasize %d\n",colname,type,coltypename,datasize);
		memset(colname,0 ,sizeof(colname));
	}
		
	/*
	if (rc = GCIDefineArrayOfStruct(Definep[4], errhp,15, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	*/
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, " GCIStmtExecute+++ exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);	
    	        goto SUCCESS_EXIT;
	}

        rc = GCIStmtFetch(stmt, errhp, 0, GCI_FETCH_NEXT, 0);
        printf("======== fetch 0 row data %d\n",rc);            

	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmt, errhp, 10, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);

		if(rownum > 100)
			break;
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving row number %d \ndat:%d %d %d %d %d %d %d\n", i + 1,dat[0 +i *16],dat[1 + i *16],dat[2+ i *16],dat[3+ i *16],dat[4+ i *16],dat[5+ i *16],dat[6+ i *16]);
		}
		starown = rownum;
	}
#else	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	int offset = 0;
	for(i = 0;i < 100;i++)
	{	

		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);
	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	

#endif	

	printf("insertwithbindsql recs\n");
	
SUCCESS_EXIT:
	if(pbuf)
		free(pbuf);
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}
int selectdecconverttable11(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	GCIDefine *Definep[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long *item_num = NULL;
	float *dec1 = NULL;
	double *dec2 = NULL;
	float *dec3 = NULL;	
	double *dec4 = NULL;	
	long *inditem = NULL;
	long *inddec1 = NULL;
	long *inddec2 = NULL;
	long *inddec3 = NULL;
	long *inddec4 = NULL;
	sb4 colnum11 = 0;
	char *colname = {0};
	char *coltypename = {0};
	GCIParam *param = NULL;
	ub2 type = 0;
	sb2 precision = 0;
	sb2 scale = 0;
	sb1 scale1 = 0;
	sb4 starown = 0;
	int num = -1;
	char strchar[20];
	char * ptrss = (char *)&num;
	item_num = (long *)malloc(100*sizeof(long));
	dec1 = (float *)malloc(100*sizeof(float));
	dec2 = (double *)malloc(100*sizeof(double));
	dec3 = (float *)malloc(100*sizeof(float));
	dec4 = (double *)malloc(100*sizeof(double));	

	inditem  = (long *)malloc(100*sizeof(long));	
	inddec1 = (long *)malloc(100*sizeof(long));	
	inddec2 = (long *)malloc(100*sizeof(long));	
	inddec3 = (long *)malloc(100*sizeof(long));	
	inddec4 = (long *)malloc(100*sizeof(long));	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	rc = GCIStmtPrepare(stmt, errhp, selectdatadec1table, strlen(selectdatadec1table) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtPrepare selecttest datetime prepare -- !!\n");
		goto SUCCESS_EXIT;
	}
#if 1	

	if (rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)item_num,(sb4)sizeof(long), (ub2)SQLT_INT,
				(dvoid *)inditem, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[1], errhp, 2, (dvoid *)dec1,(sb4)0, (ub2)SQLT_BFLOAT,
				(dvoid *)inddec1, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[2], errhp, 3, (dvoid *)dec2,(sb4)0, (ub2)SQLT_BDOUBLE,
				(dvoid *)inddec2, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[3], errhp, 4, (dvoid *)dec3,(sb4)0, (ub2)SQLT_IBFLOAT,
				(dvoid *)inddec3, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}		
	if (rc = GCIDefineByPos(stmt, &Definep[4], errhp, 5, (dvoid *)dec4,(sb4)0, (ub2)SQLT_IBDOUBLE,
				(dvoid *)inddec4, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}		

	if (rc = GCIAttrGet (stmt, GCI_HTYPE_STMT,&colnum11, 0,GCI_ATTR_NUM_COLS,errhp) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	printf("selectdecconverttable2 show the colname :colnum %d\n",colnum11);
        
	for(i = 0;i< colnum11;i++)
	{
		rc = GCIParamGet((CONST dvoid *)stmt,(ub4)GCI_HTYPE_STMT,(GCIError *)errhp,(dvoid **)&param,(ub4)i+1);
		
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&type, 0,GCI_ATTR_DATA_TYPE,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&precision, 0,GCI_ATTR_PRECISION,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
        	if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&scale, 0,GCI_ATTR_SCALE,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
        
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&coltypename, 0,GCI_ATTR_TYPE_NAME,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}			
                scale1 = scale;
		fprintf(stdout, "selectdatconverttable2 show the colname %s coltype %d col type %s,COL precision %d,scale %d\n",colname,type,coltypename,precision,scale1);
		memset(colname,0 ,sizeof(colname));
	}
		
	/*
	if (rc = GCIDefineArrayOfStruct(Definep[4], errhp,15, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	*/
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);	
    	        goto SUCCESS_EXIT;
	}
		
	sprintf(strchar,"%ld",*(int *)ptrss);
	printf("==================num %ld ,%s,%d,%ld\n",num,strchar,sizeof(int),*(long *)ptrss);

	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmt, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_PREFETCH_ROWS, errhp);

		if(starown == rownum)
			break;

		if(rownum > 100)
			break;
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\titem number %ld \n",item_num[i]);
			fprintf(stdout, "\tdec1 %f \n",dec1[i]);
			fprintf(stdout, "\tdec2 %lf \n",dec2[i]);			
			fprintf(stdout, "\tdec3 %f \n",dec4[i]);
			fprintf(stdout, "\tdec4 %15.15lf \n",dec4[i]);			
			
		}
		starown = rownum;
	}

#else	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	int offset = 0;
	for(i = 0;i < 100;i++)
	{	

		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);
	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	

#endif	

	printf("insertwithbindsql recs\n");
	
SUCCESS_EXIT:
	if(pbuf)
		free(pbuf);
	if(item_num)
		free(item_num);
	if(dec1)
		free(dec1);
	if(dec2)
		free(dec2);
	if(dec3)
		free(dec3);
	if(dec4)
		free(dec4);
	if(inditem)
		free(inditem);
	if(inddec1)
		free(inddec1);
	if(inddec2)
		free(inddec2);
	if(inddec3)
		free(inddec3);
	if(inddec4)
		free(inddec4);	
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}

int selectdecconverttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	GCIDefine *Definep[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long *item_num = NULL;
	char *dec1 = NULL;
	short *dec2 = NULL;
	int *dec3 = NULL;	
	long *dec4 = NULL;	
	long *inditem = NULL;
	long *inddec1 = NULL;
	long *inddec2 = NULL;
	long *inddec3 = NULL;
	long *inddec4 = NULL;
	sb4 colnum11 = 0;
	char *colname = {0};
	char *coltypename = {0};
	GCIParam *param = NULL;
	ub2 type = 0;
	int num = -1;
	char strchar[20];
	char * ptrss = (char *)&num;
	sb4 starown = 0;

	item_num = (long *)malloc(100*sizeof(long));
	dec1 = malloc(100*sizeof(char));
	dec2 = (short *)malloc(100*sizeof(short));
	dec3 = (int *)malloc(100*sizeof(int));
	dec4 = (long *)malloc(100*sizeof(long));	

	inditem  = (long *)malloc(100*sizeof(long));	
	inddec1 = (long *)malloc(100*sizeof(long));	
	inddec2 = (long *)malloc(100*sizeof(long));	
	inddec3 = (long *)malloc(100*sizeof(long));	
	inddec4 = (long *)malloc(100*sizeof(long));	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	rc = GCIStmtPrepare(stmt, errhp, selectdecconvert, strlen(selectdecconvert) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtPrepare selecttest datetime prepare -- !!\n");
		goto SUCCESS_EXIT;
	}
#if 1	

	if (rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)item_num,(sb4)sizeof(long), (ub2)SQLT_INT,
				(dvoid *)inditem, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[1], errhp, 2, (dvoid *)dec1,(sb4)sizeof(char), (ub2)SQLT_INT,
				(dvoid *)inddec1, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[2], errhp, 3, (dvoid *)dec2,(sb4)sizeof(short), (ub2)SQLT_INT,
				(dvoid *)inddec2, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[3], errhp, 4, (dvoid *)dec3,(sb4)sizeof(int), (ub2)SQLT_INT,
				(dvoid *)inddec3, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}		
	if (rc = GCIDefineByPos(stmt, &Definep[4], errhp, 5, (dvoid *)dec4,(sb4)sizeof(long), (ub2)SQLT_INT,
				(dvoid *)inddec4, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}		

	if (rc = GCIAttrGet (stmt, GCI_HTYPE_STMT,&colnum11, 0,GCI_ATTR_NUM_COLS,errhp) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	printf("selectdecconverttable2 show the colname :colnum %d\n",colnum11);

	for(i = 0;i< colnum11;i++)
	{
		rc = GCIParamGet((CONST dvoid *)stmt,(ub4)GCI_HTYPE_STMT,(GCIError *)errhp,(dvoid **)&param,(ub4)i+1);
		
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&type, 0,GCI_ATTR_DATA_TYPE,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&coltypename, 0,GCI_ATTR_TYPE_NAME,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}			
		fprintf(stdout, "selectdatconverttable2 show the colname %s coltype %d col type %s\n",colname,type,coltypename);
		memset(colname,0 ,sizeof(colname));
	}
		
	/*
	if (rc = GCIDefineArrayOfStruct(Definep[4], errhp,15, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	*/
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);	
    	        goto SUCCESS_EXIT;
	}

	sprintf(strchar,"%ld",*(int *)ptrss);
	printf("==================num %ld ,%s,%d,%ld\n",num,strchar,sizeof(int),*(long *)ptrss);

	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmt, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_PREFETCH_ROWS, errhp);

		if(starown == rownum)
			break;

		if(rownum > 100)
			break;
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\titem number %ld \n",item_num[i]);
			fprintf(stdout, "\tdec1 %d \n",dec1[i]);
			fprintf(stdout, "\tdec2 %d \n",dec2[i]);			
			fprintf(stdout, "\tdec3 %d \n",dec3[i]);
			fprintf(stdout, "\tdec4 %ld \n",dec4[i]);			
			
		}
		starown = rownum;
	}

#else	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	int offset = 0;
	for(i = 0;i < 100;i++)
	{	

		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);
	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	

#endif	

	printf("insertwithbindsql recs\n");
	
SUCCESS_EXIT:
	if(pbuf)
		free(pbuf);
	if(item_num)
		free(item_num);
	if(dec1)
		free(dec1);
	if(dec2)
		free(dec2);
	if(dec3)
		free(dec3);
	if(dec4)
		free(dec4);
	if(inditem)
		free(inditem);
	if(inddec1)
		free(inddec1);
	if(inddec2)
		free(inddec2);
	if(inddec3)
		free(inddec3);
	if(inddec4)
		free(inddec4);	
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}

int selectfltconverttable1(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	GCIDefine *Definep[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long *item_num = NULL;
	float *dec1 = NULL;
	double *dec2 = NULL;
	double *dec3 = NULL;	
	long *dec4 = NULL;	
	ub2 *inditem = NULL;
	ub2 *inddec1 = NULL;
	ub2 *inddec2 = NULL;
	ub2 *inddec3 = NULL;
	ub2 *inddec4 = NULL;

	ub2 *lenitem = NULL;
	ub2 *lendec1 = NULL;
	ub2 *lendec2 = NULL;
	ub2 *lendec3 = NULL;
	ub2 *lendec4 = NULL;
	sb4 starown = 0;
	int num = -1;
	char strchar[20];
	char * ptrss = (char *)&num;

	item_num = (long *)malloc(100*sizeof(long));
	dec1 = malloc(100*sizeof(float));
	dec2 = (double *)malloc(100*sizeof(double));
	dec3 = (double *)malloc(100*sizeof(double));

	inditem  = (ub2 *)malloc(100*sizeof(ub2));	
	inddec1 = (ub2 *)malloc(100*sizeof(ub2));	
	inddec2 = (ub2 *)malloc(100*sizeof(ub2));	
	inddec3 = (ub2 *)malloc(100*sizeof(ub2));	

	lenitem  = (ub2 *)malloc(100*sizeof(ub2));	
	lendec1 = (ub2 *)malloc(100*sizeof(ub2));	
	lendec2 = (ub2 *)malloc(100*sizeof(ub2));	
	lendec3 = (ub2 *)malloc(100*sizeof(ub2));	

	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	rc = GCIStmtPrepare(stmt, errhp, selectflttable, strlen(selectflttable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtPrepare selecttest datetime prepare -- !!\n");
		goto SUCCESS_EXIT;
	}
#if 1	

	if (rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)item_num,(sb4)sizeof(long), (ub2)SQLT_INT,
				(dvoid *)inditem, (ub2 *)lenitem, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[1], errhp, 2, (dvoid *)dec1,(sb4)sizeof(float), (ub2)SQLT_FLT,
				(dvoid *)inddec1, (ub2 *)lendec1, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[2], errhp, 3, (dvoid *)dec2,(sb4)sizeof(double), (ub2)SQLT_FLT,
				(dvoid *)inddec2, (ub2 *)lendec2, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[3], errhp, 4, (dvoid *)dec3,(sb4)sizeof(double), (ub2)SQLT_FLT,
				(dvoid *)inddec3, (ub2 *)lendec3, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}		

	
	/*
	if (rc = GCIDefineArrayOfStruct(Definep[4], errhp,15, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	*/
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);	
    	        goto SUCCESS_EXIT;
	}
		
	sprintf(strchar,"%ld",*(int *)ptrss);
	printf("==================num %ld ,%s,%d,%ld\n",num,strchar,sizeof(int),*(long *)ptrss);

	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmt, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(starown == rownum)
			break;

		if(rownum > 100)
			break;
                GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\titem number %ld len %d %d\n",item_num[i],lenitem[i],inditem[i]);
			fprintf(stdout, "\tdec1 %f %d %d\n",dec1[i],lendec1[i],inddec1[i]);
			fprintf(stdout, "\tdec2 %lf  %d %d\n",dec2[i],lendec2[i],inddec2[i]);			
			fprintf(stdout, "\tdec3 %lf %d %d\n",dec3[i],lendec3[i],inddec3[i]);
		}
		starown = rownum;
               GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);        
               fprintf(stdout, "selectfltconverttable1GCI_ATTR_ROWS_FETCHED %d\n",rownum);              
	}

#else	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	int offset = 0;
	for(i = 0;i < 100;i++)
	{	

		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);
	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	

#endif	

	printf("insertwithbindsql recs\n");
	
SUCCESS_EXIT:
	if(pbuf)
		free(pbuf);
	if(item_num)
		free(item_num);
	if(dec1)
		free(dec1);
	if(dec2)
		free(dec2);
	if(dec3)
		free(dec3);
	if(dec4)
		free(dec4);
	if(inditem)
		free(inditem);
	if(inddec1)
		free(inddec1);
	if(inddec2)
		free(inddec2);
	if(inddec3)
		free(inddec3);
	if(inddec4)
		free(inddec4);	
	if(lenitem)
		free(lenitem);
	if(lendec1)
		free(lendec1);
	if(lendec2)
		free(lendec2);
	if(lendec3)
		free(lendec3);
	if(lendec4)
		free(lendec4);		
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}

int selectfltconverttable2(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	GCIDefine *Definep[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long *item_num = NULL;
	float *dec1 = NULL;
	double *dec2 = NULL;
	double *dec3 = NULL;	
	long *dec4 = NULL;	
	ub2 *inditem = NULL;
	ub2 *inddec1 = NULL;
	ub2 *inddec2 = NULL;
	ub2 *inddec3 = NULL;
	ub2 *inddec4 = NULL;

	ub2 *lenitem = NULL;
	ub2 *lendec1 = NULL;
	ub2 *lendec2 = NULL;
	ub2 *lendec3 = NULL;
	ub2 *lendec4 = NULL;
	sb4 colnum11 = 0;
	char *colname = {0};
	char *coltypename = {0};
	GCIParam *param = NULL;
	ub2 type = 0;
	int num = -1;
	char strchar[20];
	char * ptrss = (char *)&num;
	sb4 starown = 0;
	int datasize = ((sizeof(long )+ sizeof(float)+sizeof(double)+sizeof(double) + 8));

	pbuf = malloc(datasize*100);
	item_num = (long *)pbuf;
	inditem  = (ub2 *)(item_num+1);	
	dec1 = (float *)(inditem + 1);
	inddec1 = (ub2 *)(dec1 +1); 
	dec2 = (double *)(inddec1 + 1);
	inddec2 = (ub2*)(dec2 + 1);		
	dec3 = (double *)(inddec2 + 1);
	inddec3 = (ub2 *)(dec3 + 1);
	
	lenitem  = (ub2 *)malloc(100*sizeof(ub2));	
	lendec1 = (ub2 *)malloc(100*sizeof(ub2));	
	lendec2 = (ub2 *)malloc(100*sizeof(ub2));	
	lendec3 = (ub2 *)malloc(100*sizeof(ub2));	

	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	rc = GCIStmtPrepare(stmt, errhp, selectflttable, strlen(selectflttable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtPrepare selecttest datetime prepare -- !!\n");
		goto SUCCESS_EXIT;
	}
#if 1	

	if (rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)item_num,(sb4)sizeof(long), (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)lenitem, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[1], errhp, 2, (dvoid *)dec1,(sb4)sizeof(float), (ub2)SQLT_FLT,
				(dvoid *)0, (ub2 *)lendec1, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[2], errhp, 3, (dvoid *)dec2,(sb4)sizeof(double), (ub2)SQLT_FLT,
				(dvoid *)0, (ub2 *)lendec2, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[3], errhp, 4, (dvoid *)dec3,(sb4)sizeof(double), (ub2)SQLT_FLT,
				(dvoid *)0, (ub2 *)lendec3, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}		
	rc = GCIDefineArrayOfStruct(Definep[0], errhp,datasize, datasize, 0, 0);
	rc = GCIDefineArrayOfStruct(Definep[1], errhp,datasize, datasize, 0, 0);
	rc = GCIDefineArrayOfStruct(Definep[2], errhp,datasize, datasize, 0, 0);
	rc = GCIDefineArrayOfStruct(Definep[3], errhp,datasize, datasize, 0, 0);
		
	
	if (rc = GCIAttrGet (stmt, GCI_HTYPE_STMT,&colnum11, 0,GCI_ATTR_NUM_COLS,errhp) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}

	printf("selectfltconverttable1 show the colname :colnum %d\n",colnum11);

	for(i = 0;i< colnum11;i++)
	{
		rc = GCIParamGet((CONST dvoid *)stmt,(ub4)GCI_HTYPE_STMT,(GCIError *)errhp,(dvoid **)&param,(ub4)i+1);
		
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&type, 0,GCI_ATTR_DATA_TYPE,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&coltypename, 0,GCI_ATTR_TYPE_NAME,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}			
		fprintf(stdout, "selectdatconverttable2 show the colname %s coltype %d col type %s\n",colname,type,coltypename);
		memset(colname,0 ,sizeof(colname));
	}
		
	/*
	if (rc = GCIDefineArrayOfStruct(Definep[4], errhp,15, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	*/
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);	
    	        goto SUCCESS_EXIT;
	}

	sprintf(strchar,"%ld",*(int *)ptrss);
	printf("==================num %ld ,%s,%d,%ld\n",num,strchar,sizeof(int),*(long *)ptrss);

	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmt, errhp, 2, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(starown == rownum)
			break;

               printf("=========rownum %d\n",rownum);
               GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);        
               fprintf(stdout, "selectfltconverttable2 GCI_ATTR_ROWS_FETCHED %d\n",rownum);                 
		if(rownum > 100)
			break;
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\titem number %ld len %d no %d\n",*(long *)((char *)item_num + i*datasize),lenitem[i],(int)(*(short *)((char *)inditem+i*datasize)));
			fprintf(stdout, "\tdec1 %f %d no %d\n",*(float *)((char *)dec1 +i*datasize),lendec1[i],*(short *)((char *)inddec1 + i*datasize));
			fprintf(stdout, "\tdec2 %lf  %d no %d\n",*(double *)((char *)dec2 +i*datasize),lendec2[i],*(short *)((char *)inddec2 + i*datasize));			
			fprintf(stdout, "\tdec3 %lf %d no %d\n",*(double *)((char *)dec3 +i*datasize),lendec3[i],*(short *)((char *)inddec3 + i*datasize));		
			
		}
		starown = rownum;
        
      
	}

#else	

#endif	

	printf("insertwithbindsql recs\n");
	
SUCCESS_EXIT:
	if(pbuf)
		free(pbuf);

	if(lenitem)
		free(lenitem);
	if(lendec1)
		free(lendec1);
	if(lendec2)
		free(lendec2);
	if(lendec3)
		free(lendec3);
	if(lendec4)
		free(lendec4);		
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}

int selectfltconverttable3(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	GCIDefine *Definep[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long *item_num = NULL;
	float *dec1 = NULL;
	double *dec2 = NULL;
	double *dec3 = NULL;	
	long *dec4 = NULL;	
	ub2 *inditem = NULL;
	ub2 *inddec1 = NULL;
	ub2 *inddec2 = NULL;
	ub2 *inddec3 = NULL;
	ub2 *inddec4 = NULL;

	ub2 *lenitem = NULL;
	ub2 *lendec1 = NULL;
	ub2 *lendec2 = NULL;
	ub2 *lendec3 = NULL;
	ub2 *lendec4 = NULL;
	int datasize = 0;
	sb4 colnum11 = 0;
	char *colname = {0};
	char *coltypename = {0};
	GCIParam *param = NULL;
	ub2 type = 0;
	int num = -1;
	char strchar[20];
	char * ptrss = (char *)&num;
	sb4 starown = 0;

	datasize = (sizeof(long )+ sizeof(float)+sizeof(double)+sizeof(double) + 8+2 +8+2);
	pbuf = malloc(datasize*100);
	item_num = (long *)pbuf;
     lenitem = (ub2 *)(item_num+1);
	inditem  = (ub2 *)(lenitem+1);	
    
	dec1 = (float *)(inditem + 1);
    lendec1=  (ub2 *)(dec1 + 1);
	inddec1 = (ub2 *)(lendec1 +1); 
    
	dec2 = (double *)(inddec1 + 1);
    lendec2=  (ub2 *)(dec2 + 1);    
	inddec2 = (ub2*)(lendec2 + 1);		
    
	dec3 = (double *)(inddec2 + 1);
        lendec3=  (ub2 *)(dec3 + 1);   
	inddec3 = (ub2 *)(lendec3 + 1);
	

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	rc = GCIStmtPrepare(stmt, errhp, selectflttable, strlen(selectflttable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtPrepare selecttest datetime prepare -- !!\n");
		goto SUCCESS_EXIT;
	}
#if 1	

	if (rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)item_num,(sb4)sizeof(long), (ub2)SQLT_INT,
				(dvoid *)inditem, (ub2 *)lenitem, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[1], errhp, 2, (dvoid *)dec1,(sb4)sizeof(float), (ub2)SQLT_FLT,
				(dvoid *)inddec1, (ub2 *)lendec1, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[2], errhp, 3, (dvoid *)dec2,(sb4)sizeof(double), (ub2)SQLT_FLT,
				(dvoid *)inddec2, (ub2 *)lendec2, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[3], errhp, 4, (dvoid *)dec3,(sb4)sizeof(double), (ub2)SQLT_FLT,
				(dvoid *)inddec3, (ub2 *)lendec3, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}		
	rc = GCIDefineArrayOfStruct(Definep[0], errhp,datasize, datasize,datasize, 0);
	rc = GCIDefineArrayOfStruct(Definep[1], errhp,datasize, datasize,datasize, 0);
	rc = GCIDefineArrayOfStruct(Definep[2], errhp,datasize, datasize,datasize, 0);
	rc = GCIDefineArrayOfStruct(Definep[3], errhp,datasize, datasize,datasize, 0);
		
	
	if (rc = GCIAttrGet (stmt, GCI_HTYPE_STMT,&colnum11, 0,GCI_ATTR_NUM_COLS,errhp) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}

	printf("selectfltconverttable1 show the colname :colnum %d\n",colnum11);

	for(i = 0;i< colnum11;i++)
	{
		rc = GCIParamGet((CONST dvoid *)stmt,(ub4)GCI_HTYPE_STMT,(GCIError *)errhp,(dvoid **)&param,(ub4)i+1);
		
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&type, 0,GCI_ATTR_DATA_TYPE,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&coltypename, 0,GCI_ATTR_TYPE_NAME,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}			
		fprintf(stdout, "selectdatconverttable2 show the colname %s coltype %d col type %s\n",colname,type,coltypename);
		memset(colname,0 ,sizeof(colname));
	}
		
	/*
	if (rc = GCIDefineArrayOfStruct(Definep[4], errhp,15, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	*/
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);	
    	        goto SUCCESS_EXIT;
	}

	sprintf(strchar,"%ld",*(int *)ptrss);
	printf("==================num %ld ,%s,%d,%ld\n",num,strchar,sizeof(int),*(long *)ptrss);

	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmt, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(starown == rownum)
			break;

		if(rownum > 100)
			break;
   
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\titem number %ld len %d no %d\n",*(long *)((char *)item_num + i*datasize),(*(short *)((char *)lenitem+i*datasize)),(int)(*(short *)((char *)inditem+i*datasize)));
			fprintf(stdout, "\tdec1 %f %d no %d\n",*(float *)((char *)dec1 +i*datasize),(*(short *)((char *)lendec1+i*datasize)),*(short *)((char *)inddec1 + i*datasize));
			fprintf(stdout, "\tdec2 %lf  %d no %d\n",*(double *)((char *)dec2 +i*datasize),(*(short *)((char *)lendec2+i*datasize)),*(short *)((char *)inddec2 + i*datasize));			
			fprintf(stdout, "\tdec3 %lf %d no %d\n",*(double *)((char *)dec3 +i*datasize),(*(short *)((char *)lendec3+i*datasize)),*(short *)((char *)inddec3 + i*datasize));		
			
		}
        
               GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);        
               fprintf(stdout, "GCI_ATTR_ROWS_FETCHED %d\n",rownum);            
        
		starown = rownum;
	}

#else	

#endif	

	printf("insertwithbindsql recs\n");
	
SUCCESS_EXIT:
	if(pbuf)
		free(pbuf);


	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}


int selectfltconverttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	GCIDefine *Definep[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long *item_num = NULL;
	float *dec1 = NULL;
	double *dec2 = NULL;
	double *dec3 = NULL;	
	double *dec4 = NULL;	
	ub2 *inditem = NULL;
	ub2 *inddec1 = NULL;
	ub2 *inddec2 = NULL;
	ub2 *inddec3 = NULL;
	ub2 *inddec4 = NULL;

	ub2 *lenitem = NULL;
	ub2 *lendec1 = NULL;
	ub2 *lendec2 = NULL;
	ub2 *lendec3 = NULL;
	ub2 *lendec4 = NULL;
	sb4 starown = 0;
	int num = -1;
	char strchar[20];
	char * ptrss = (char *)&num;

	item_num = (long *)malloc(100*sizeof(long));
	dec1 = malloc(100*sizeof(float));
	dec2 = (double *)malloc(100*sizeof(double));
	dec3 = (double *)malloc(100*sizeof(double));

	inditem  = (ub2 *)malloc(100*sizeof(ub2));	
	inddec1 = (ub2 *)malloc(100*sizeof(ub2));	
	inddec2 = (ub2 *)malloc(100*sizeof(ub2));	
	inddec3 = (ub2 *)malloc(100*sizeof(ub2));	

	lenitem  = (ub2 *)malloc(100*sizeof(ub2));	
	lendec1 = (ub2 *)malloc(100*sizeof(ub2));	
	lendec2 = (ub2 *)malloc(100*sizeof(ub2));	
	lendec3 = (ub2*)malloc(100*sizeof(ub2));	

	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	rc = GCIStmtPrepare(stmt, errhp, selectflttable, strlen(selectflttable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtPrepare selecttest datetime prepare -- !!\n");
		goto SUCCESS_EXIT;
	}
#if 1	

	if (rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)item_num,(sb4)sizeof(long), (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)lenitem, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[1], errhp, 2, (dvoid *)dec1,(sb4)sizeof(float), (ub2)SQLT_FLT,
				(dvoid *)0, (ub2 *)lendec1, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[2], errhp, 3, (dvoid *)dec2,(sb4)sizeof(double), (ub2)SQLT_FLT,
				(dvoid *)0, (ub2 *)lendec2, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineByPos(stmt, &Definep[3], errhp, 4, (dvoid *)dec3,(sb4)sizeof(double), (ub2)SQLT_FLT,
				(dvoid *)0, (ub2 *)lendec3, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}		

	/*
	if (rc = GCIDefineArrayOfStruct(Definep[4], errhp,15, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	*/
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);	
    	        goto SUCCESS_EXIT;
	}
		
	sprintf(strchar,"%ld",*(int *)ptrss);
	printf("==================num %ld ,%s,%d,%ld\n",num,strchar,sizeof(int),*(long *)ptrss);

	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmt, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(starown == rownum)
			break;

		if(rownum > 100)
			break;
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\titem number %ld len %d %d\n",item_num[i],lenitem[i],inditem[i]);
			fprintf(stdout, "\tdec1 %f %d %d\n",dec1[i],lendec1[i],inddec1[i]);
			fprintf(stdout, "\tdec2 %lf  %d %d\n",dec2[i],lendec2[i],inddec2[i]);			
			fprintf(stdout, "\tdec3 %lf %d %d\n",dec3[i],lendec3[i],inddec3[i]);
		}
		starown = rownum;
               GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);        
               fprintf(stdout, "selectfltconverttable2 GCI_ATTR_ROWS_FETCHED %d\n",rownum);          
	}

#else	

#endif	

	printf("insertwithbindsql recs\n");
	
SUCCESS_EXIT:
	if(pbuf)
		free(pbuf);
	if(item_num)
		free(item_num);
	if(dec1)
		free(dec1);
	if(dec2)
		free(dec2);
	if(dec3)
		free(dec3);
	if(dec4)
		free(dec4);
	if(inditem)
		free(inditem);
	if(inddec1)
		free(inddec1);
	if(inddec2)
		free(inddec2);
	if(inddec3)
		free(inddec3);
	if(inddec4)
		free(inddec4);	
	if(lenitem)
		free(lenitem);
	if(lendec1)
		free(lendec1);
	if(lendec2)
		free(lendec2);
	if(lendec3)
		free(lendec3);
	if(lendec4)
		free(lendec4);		
	if(stmt)
		GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}



int selectdatconverttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	GCIDefine *Definep[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num = 0;
	GCIDate d;
	char dat[7*100];
	GCIDate *datetimestr = NULL;
	char *colname = {0};
	GCIParam *param = NULL;
	ub2 type = 0;
    ub4 datasize = 0;
	sb4 starown = 0;
	sb4 colnum11 = 0;

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	pbuf = malloc(100*(sizeof(GCIDate)+sizeof(long)));
	if(NULL == pbuf)
	{
		goto SUCCESS_EXIT;	
	}
	rc = GCIStmtPrepare(stmt, errhp, selecttestdatetime, strlen(selecttestdatetime) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtPrepare selecttest datetime prepare -- !!\n");
		goto SUCCESS_EXIT;
	}

	if (rc = GCIAttrGet (stmt, GCI_HTYPE_STMT,&colnum11, 0,GCI_ATTR_NUM_COLS,errhp) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}	

	printf("show the colname :colnum %d\n",colnum11);

	for(i = 0;i< colnum11;i++)
	{
		rc = GCIParamGet((CONST dvoid *)stmt,(ub4)GCI_HTYPE_STMT,(GCIError *)errhp,(dvoid **)&param,(ub4)i+1);
		
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}	
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&type, 0,GCI_ATTR_DATA_TYPE,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}			
		if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&datasize, 0,GCI_ATTR_DATA_SIZE,errhp) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

			fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
			goto SUCCESS_EXIT;
		}			        
		fprintf(stdout, "show the colname %s coltype %d datasize %d\n",colname,type,datasize);
        
		memset(colname,0 ,sizeof(colname));
	}
	
#if 1	
	if (rc = GCIDefineByPos(stmt, &Definep[4], errhp, 1, (dvoid *)dat,(sb4)sizeof(dat), (ub2)SQLT_DAT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

		goto SUCCESS_EXIT;
	}	
	if (rc = GCIDefineArrayOfStruct(Definep[4], errhp,7, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);	
    	        goto SUCCESS_EXIT;
	}
		
	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmt, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(starown == rownum)
			break;

		if(rownum > 10)
			break;
		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving row number %d \ndat:%d %d %d %d %d %d %d\n", i + 1,dat[0],dat[1],dat[2],dat[3],dat[4],dat[5],dat[6]);
		}
		starown = rownum;
               GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);        
               fprintf(stdout, "selectdatconverttable GCI_ATTR_ROWS_FETCHED %d\n",rownum);          
	}
#else	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	int offset = 0;
	for(i = 0;i < 100;i++)
	{	

		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);
	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	

#endif	

	printf("insertwithbindsql recs\n");
	
SUCCESS_EXIT:
	if(pbuf)
		free(pbuf);
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}
int insertfltconverttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num[100] = {0};
	char dec1[100] = {0};
	short dec2[100] = {0};
	long dec3[100] = {0};	
	long dec4[100] = {0};	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	}
	pbuf = malloc(100*(sizeof(GCIDate) + sizeof(long)));
	if(NULL == pbuf)
	{
		goto insertmultithreadtableEXIT;	
	}
	rc = GCIStmtPrepare(stmt, errhp, insertflttable, strlen(insertflttable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}
#if 1	
	if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)item_num,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	


	if(rc = GCIBindByPos(stmt,&Bindp[1],errhp,2,(dvoid *)dec1,(sb4)sizeof(char),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	if(rc = GCIBindByPos(stmt,&Bindp[2],errhp,3,(dvoid *)dec2,(sb4)sizeof(short),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	

	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,4,(dvoid *)dec3,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}
        printf("pos 5 %d\n",sizeof(long));	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,5,(dvoid *)dec4,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}

	for(i = 0;i < 100;i++)
	{
		item_num[i] = i+1;
		dec1[i] = i;
		dec2[i] = 10001 + i;
		dec3[i] = -1 ;
		dec4[i] = 10001000100010001 + i ;
		//execute
		
	}
    //test execute iters param =0; if 0only insert one row 
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		printf("GCIStmtExecute error %d\n",i);
		goto insertmultithreadtableEXIT;
	}

#else	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	int offset = 0;
	for(i = 0;i < 100;i++)
	{	

		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);
	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	

#endif	

	printf("insertwithbindsql dectable 100 recs\n");
	
insertmultithreadtableEXIT:
    if (pbuf)
        free(pbuf);
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}
int insertdecconverttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num[100] = {0};
	char dec1[100] = {0};
	short dec2[100] = {0};
	long dec3[100] = {0};	
	long dec4[100] = {0};	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	}
	pbuf = malloc(100*(sizeof(GCIDate) + sizeof(long)));
	if(NULL == pbuf)
	{
		goto insertmultithreadtableEXIT;	
	}
	rc = GCIStmtPrepare(stmt, errhp, insertdatadectable, strlen(insertdatadectable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}
#if 1	
	if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)item_num,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	


	if(rc = GCIBindByPos(stmt,&Bindp[1],errhp,2,(dvoid *)dec1,(sb4)sizeof(char),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	if(rc = GCIBindByPos(stmt,&Bindp[2],errhp,3,(dvoid *)dec2,(sb4)sizeof(short),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	

	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,4,(dvoid *)dec3,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}
        printf("pos 5 %d\n",sizeof(long));	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,5,(dvoid *)dec4,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}

	for(i = 0;i < 100;i++)
	{
		item_num[i] = i+1;
		dec1[i] = i;
		dec2[i] = 10001 + i;
		dec3[i] = -1 ;
		dec4[i] = 10001000100010001 + i ;
		//execute
		
	}
    //test execute iters param =0; if 0only insert one row 
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		printf("GCIStmtExecute error %d\n",i);
		goto insertmultithreadtableEXIT;
	}

#else	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	int offset = 0;
	for(i = 0;i < 100;i++)
	{	

		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);
	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	

#endif	

	printf("insertwithbindsql dectable 100 recs\n");
	
insertmultithreadtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
    if  (pbuf)
        free(pbuf);
	return rc;	
}
//float test
int insertfltconverttable1(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num[100] = {0};
	float dec1[100] = {0};
	double dec2[100] = {0};
	float dec3[100] = {0};	
	double dec4[100] = {0};	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	}

	rc = GCIStmtPrepare(stmt, errhp, insertdatadec1table, strlen(insertdatadec1table) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}
#if 1	
	if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)item_num,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	


	if(rc = GCIBindByPos(stmt,&Bindp[1],errhp,2,(dvoid *)dec1,(sb4)1,SQLT_BFLOAT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	if(rc = GCIBindByPos(stmt,&Bindp[2],errhp,3,(dvoid *)dec2,(sb4)1,SQLT_BDOUBLE,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	

	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,4,(dvoid *)dec3,(sb4)1,SQLT_IBFLOAT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}

	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,5,(dvoid *)dec4,(sb4)1,SQLT_IBDOUBLE,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}

	for(i = 0;i < 10;i++)
	{
		item_num[i] = i+1;
		dec1[i] = 1.234567;
		dec2[i] = 123456790123456 + i;
		dec3[i] = 1.2345672222 ;
                dec4[i] = 1.23456790123456 + i;
		//execute
		
	}
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)10, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		printf("GCIStmtExecute error %d\n",i);
		goto insertmultithreadtableEXIT;
	}

#else	

#endif	

	printf("insertwithbindsql dectable 100 recs\n");
	
insertmultithreadtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}
int insertdatconverttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num[2] = {0};
	GCIDate d[2];
	GCIDate *datetimestr = NULL;
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	}
	pbuf = malloc(100*(sizeof(GCIDate) + sizeof(long)));
	if(NULL == pbuf)
	{
		goto insertmultithreadtableEXIT;	
	}
	rc = GCIStmtPrepare(stmt, errhp, insertdatadattable, strlen(insertdatadattable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}
#if 1	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)item_num,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	

	datetimestr = &d[0];
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)datetimestr,(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	for(i = 0;i < 5;i++)
	{
		datetimestr = &d[0];
		datetimestr->GCIDateDD = i+ 10;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;
		datetimestr = &d[1];
		item_num[0] = i+1;
		datetimestr->GCIDateDD = i+ 10 + 1;
		datetimestr->GCIDateMM = 5;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 20;
		datetimestr->GCIDateTime.GCITimeMI = 45 + 1+i;
		datetimestr->GCIDateTime.GCITimeSS = 50;
		item_num[1] = i + 10 +1;		
		//execute
		rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
		if(rc)
		{
			printf("GCIStmtExecute error %d\n",i);
			goto insertmultithreadtableEXIT;
		}
		
	}
#else	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	int offset = 0;
	for(i = 0;i < 100;i++)
	{	

		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);
	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	

#endif	

	printf("insertwithbindsql recs\n");
	
insertmultithreadtableEXIT:
	if(pbuf)
		free(pbuf);
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}
int insertdatconvert4table(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num[2] = {0};
	long *pitem_num = NULL;
	
	GCIDate d[2];
	GCIDate *datetimestr = NULL;
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	}
	pbuf = malloc(100*(sizeof(GCIDate) + sizeof(long)));

	if(NULL == pbuf)
	{
		goto insertmultithreadtableEXIT;	
	}
	
	pitem_num = (long *)pbuf;
	datetimestr = (GCIDate *)(pbuf + sizeof(long));
	
	rc = GCIStmtPrepare(stmt, errhp, insertdatadattable, strlen(insertdatadattable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}
#if 1	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pitem_num,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	

	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)datetimestr,(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	rc =  GCIBindArrayOfStruct(Bindp[4],errhp,(8+sizeof(GCIDate)),0,0,0);
	rc =  GCIBindArrayOfStruct(Bindp[3],errhp,(8+sizeof(GCIDate)),0,0,0);	
	
	for(i = 0;i < 5;i++)
	{
		pitem_num = (long *)pbuf;
		datetimestr = (GCIDate *)(pitem_num+1);
		datetimestr->GCIDateDD = i+ 10;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2018;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;
		*pitem_num = i+500+1;
		pitem_num = (long *)(pbuf + 8+sizeof(GCIDate));
		
		datetimestr = (GCIDate *)(pitem_num+1);
		datetimestr->GCIDateDD = i+ 10 + 1;
		datetimestr->GCIDateMM = 5;
		datetimestr->GCIDateYYYY = 2019;
		datetimestr->GCIDateTime.GCITimeHH = 20;
		datetimestr->GCIDateTime.GCITimeMI = 45 + 1+i;
		datetimestr->GCIDateTime.GCITimeSS = 50;
		*pitem_num = i + 300 +1;		
		
		//execute
		rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)2, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
		if(rc)
		{
			printf("GCIStmtExecute error %d\n",i);
			goto insertmultithreadtableEXIT;
		}
		
	}
#else	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	int offset = 0;
	for(i = 0;i < 100;i++)
	{	

		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);
	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	

#endif	

	printf("insertwithbindsql recs\n");
	
insertmultithreadtableEXIT:
	if(pbuf)
		free(pbuf);
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}
int insertdatconvert2table(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num[2] = {0};
	char d[700];
	char *datetimestr = NULL;
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	}
	pbuf = malloc(100*(sizeof(GCIDate) + sizeof(long)));
	if(NULL == pbuf)
	{
		goto insertmultithreadtableEXIT;	
	}
	rc = GCIStmtPrepare(stmt, errhp, insertdatadattable, strlen(insertdatadattable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}
#if 1	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)item_num,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	

	datetimestr = d;
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)datetimestr,(sb4)7,SQLT_DAT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	for(i = 0;i < 10;i++)
	{
		datetimestr = d;
		datetimestr[0] = 120;
		datetimestr[1] = 116;
		datetimestr[2] = 4;
		datetimestr[3] = i + 1;
		datetimestr[4] = 15;
		datetimestr[5] = 20 + i;
		datetimestr[6] = 50;		
		item_num[0] = 100 +  i+1;

		datetimestr = &d[7];
		datetimestr[0] = 120;
		datetimestr[1] = 115;
		datetimestr[2] = 5;
		datetimestr[3] = i + 1;
		datetimestr[4] = 15;
		datetimestr[5] = 10 + i;
		datetimestr[6] = 30;		
		item_num[1] = 200 +  i+1;
		
		//execute
		rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)2, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
		if(rc)
		{
			printf("GCIStmtExecute error %d\n",i);
			goto insertmultithreadtableEXIT;
		}
		
	}
#else	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	int offset = 0;
	for(i = 0;i < 100;i++)
	{	

		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);
	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	

#endif	

	printf("insertwithbindsql recs\n");
	
insertmultithreadtableEXIT:
	if(pbuf)
		free(pbuf);
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}
int insertdatconvert3table(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num[2] = {0};
	char d[1200];
	long *pitem_num = NULL;
 	char *datetimestr = NULL;
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	}
	pitem_num = (long *)d;
	datetimestr = (d + sizeof(long));
	
	rc = GCIStmtPrepare(stmt, errhp, insertdatadattable, strlen(insertdatadattable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}
#if 1	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pitem_num,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	

	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)datetimestr,(sb4)8,SQLT_DAT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			
	rc =  GCIBindArrayOfStruct(Bindp[4],errhp,(8+sizeof(long)),0,0,0);
	rc =  GCIBindArrayOfStruct(Bindp[3],errhp,(8+sizeof(long)),0,0,0);	
	if(rc)
	{
	    printf("GCIBindArrayOfStruct  bind 2 parameter error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			
	
	for(i = 0;i < 10;i++)
	{
		pitem_num = (long *)d;
		datetimestr = (char *)(pitem_num+ 1);
		datetimestr[0] = 120;
		datetimestr[1] = 114;
		datetimestr[2] = 4;
		datetimestr[3] = i + 1;
		datetimestr[4] = 15;
		datetimestr[5] = 20 + i;
		datetimestr[6] = 50;		

		*pitem_num = 1000 +  i+1;
		pitem_num = (long *)(d + (sizeof(long) + 8));
		datetimestr =  (char *)(pitem_num+ 1);
		datetimestr[0] = 120;
		datetimestr[1] = 117;
		datetimestr[2] = 5;
		datetimestr[3] = i + 1;
		datetimestr[4] = 15;
		datetimestr[5] = 10 + i;
		datetimestr[6] = 30;		
		*(pitem_num) = 2000 +  i+1;
		
		//execute
		rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)2, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
		if(rc)
		{
			printf("GCIStmtExecute error %d\n",i);
			goto insertmultithreadtableEXIT;
		}
		
	}
#else	


#endif	

	printf("insertwithbindsql recs\n");
	
insertmultithreadtableEXIT:
	if(pbuf)
		free(pbuf);
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}
//date timeͲ
int insertdatconvert5table(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num[2] = {0};
	char d[1200];
	char d4[1200];
	char d5[1200];	
	
	long *pitem_num = NULL;
 	char *datetimestr = NULL;
	char *datestr = NULL;
	char *timestr = NULL;
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	}
	pitem_num = (long *)item_num;
	datetimestr = (d );
	timestr = d4;
	datestr = d5;
	
	rc = GCIStmtPrepare(stmt, errhp, insertdata2dattable, strlen(insertdata2dattable) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}
#if 1	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pitem_num,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	

	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)datetimestr,(sb4)8,SQLT_DAT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}
/*	if(rc = GCIBindByPos(stmt,&Bindp[1],errhp,2,(dvoid *)datestr,(sb4)8,SQLT_DAT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	

		
	if(rc = GCIBindByPos(stmt,&Bindp[2],errhp,2,(dvoid *)timestr,(sb4)8,SQLT_DAT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	*/	

	if(rc)
	{
	    printf("GCIBindArrayOfStruct  bind 2 parameter error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			
	
	for(i = 0;i < 10;i++)
	{
		datetimestr[0] = 100;
		datetimestr[1] = 101;
		datetimestr[2] = 4;
		datetimestr[3] = i + 1;
		datetimestr[4] = 15;
		datetimestr[5] = 20 + i;
		datetimestr[6] = 50;		

		*pitem_num = 6000 +  i+1;


		datestr[0] = 199;
		datestr[1] = 199;
		datestr[2] = 1+i;
		datestr[3] = 1 + 1+i;
		datestr[4] = 0;
		datestr[5] = 0;
		datestr[6] = 0;	

		//execute
		rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
		if(rc)
		{
			printf("GCIStmtExecute error %d\n",i);
			goto insertmultithreadtableEXIT;
		}
		
	}
#else	
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	int offset = 0;
	for(i = 0;i < 100;i++)
	{	

		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);
	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	

#endif	

	printf("insertwithbindsql recs\n");
	
insertmultithreadtableEXIT:
	if(pbuf)
		free(pbuf);
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}
int insertafctable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num[100] = {0};
	char dec1[100] = {0};
	short dec2[100] = {0};
	long dec3[100] = {0};	
	long dec4[100] = {0};	
	char ch[10]={'i',127,127,127,'i','i','I','I','I','I'};


        char *createtablesql = "create table if not exists ct (c char(1))";
        
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	}
	pbuf = malloc(100*(sizeof(GCIDate) + sizeof(long)));
	if(NULL == pbuf)
	{
		goto insertmultithreadtableEXIT;	
	}
	rc = GCIStmtPrepare(stmt, errhp,createtablesql, strlen(createtablesql) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}
    	//test execute iters param =0; if 0only insert one row 
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,GCI_COMMIT_ON_SUCCESS);
        if (rc)
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtExecute stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}         
	rc = GCIStmtPrepare(stmt, errhp, "insert into ct values(?)", strlen("insert into ct values(?)") + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}
#if 1	
	if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)ch,(sb4)1,SQLT_AFC,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	


	    //test execute iters param =0; if 0only insert one row 
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)10, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		printf("GCIStmtExecute error %d\n",i);
		goto insertmultithreadtableEXIT;
	}

#else	

#endif	

	printf("insertwithbindsql cttable 100 recs\n");
	
insertmultithreadtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	

}
int createttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	char *tc;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIDefine *Definep[5];
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	}
#if 1
    tc = "CREATE TABLE SCADA_ANALOG_DAY2018(ATTR_OID NUMBER(21) NOT NULL,ATTR_TIME \
    TIMESTAMP(0) NOT NULL,MAX_VALUE FLOAT(24),MAX_VALUE_TIME TIMESTAMP(0),\
    MIN_VALUE FLOAT(24),MIN_VALUE_TIME TIMESTAMP(0),AVG_VALUE FLOAT(24),\
    AVGMAX_RATE FLOAT(24),SUM_VALUE FLOAT(24),PRIMARY KEY(ATTR_OID,ATTR_TIME)) \
    FRAGMENT BY EXPRESSION partition par_2018_01 (ATTR_TIME < '2018-02-01 00:00:00\
    ') in his,partition par_2018_02 (ATTR_TIME < '2018-03-01 00:00:00') in his,\
    partition par_2018_03 (ATTR_TIME < '2018-04-01 00:00:00') in his,partition \
    par_2018_04 (ATTR_TIME < '2018-05-01 00:00:00') in his,partition par_2018_05 (\
    ATTR_TIME < '2018-06-01 00:00:00') in his,partition par_2018_06 (ATTR_TIME < '\
    2018-07-01 00:00:00') in his,partition par_2018_07 (ATTR_TIME < '2018-08-01 00\
    :00:00') in his,partition par_2018_08 (ATTR_TIME < '2018-09-01 00:00:00') in \
    his,partition par_2018_09 (ATTR_TIME < '2018-10-01 00:00:00') in his,\
    partition par_2018_10 (ATTR_TIME < '2018-11-01 00:00:00') in his,partition \
    par_2018_11 (ATTR_TIME < '2018-12-01 00:00:00') in his,partition par_2018_12 (\
    ATTR_TIME < '2019-01-01 00:00:00') in his,remainder in his";
#else
 char *tc = "CREATE TABLE SCADA_ANALOG_DAY2018(ATTR_OID NUMBER(21) NOT NULL,ATTR_TIME \
    TIMESTAMP(0) NOT NULL,MAX_VALUE FLOAT(24),MAX_VALUE_TIME TIMESTAMP(0),\
    MIN_VALUE FLOAT(24),MIN_VALUE_TIME TIMESTAMP(0),AVG_VALUE FLOAT(24),\
    AVGMAX_RATE FLOAT(24),SUM_VALUE FLOAT(24),PRIMARY KEY(ATTR_OID,ATTR_TIME)) \
    FRAGMENT BY EXPRESSION partition par_2018_01 (ATTR_TIME < '2018-02-01 00:00:00\
    ') in his,partition par_2018_02 (ATTR_TIME < '2018-03-01 00:00:00') in his,\
    partition par_2018_03 (ATTR_TIME < '2018-04-01 00:00:00') in his,partition \
    par_2018_04 (ATTR_TIME < '2018-05-01 00:00:00') in his,partition par_2018_05 (\
    ATTR_TIME < '2018-06-01 00:00:00') in his,partition par_2018_06 (ATTR_TIME < '\
    2018-07-01 00:00:00') in his,partition par_2018_07 (ATTR_TIME < '2018-08-01 00:00:00') in his,remainder in his";
#endif

	rc = GCIStmtPrepare(stmt, errhp, tc, strlen(tc), 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}
 
   
        //test execute iters param =0; if 0only insert one row 
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		
		goto insertmultithreadtableEXIT;

	}
	printf("CREATE TABLE SCADA_ANALOG_DAY2018 ok %d\n",rc);
 
	
insertmultithreadtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}
int selfloattable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIDefine *Definep[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num[100] = {0};
	char dec1[100] = {0};
	short dec2[100] = {0};
	long dec3[100] = {0};	
	long dec4[100] = {0};	
	char ch[100] = {1,1};
	char ch1[1000] = {0,0};
	char testse[1024] ;
	char *colname = {0};
	char *coltypename = {0};
	GCIParam *param = NULL;
	ub2 type = 0;
	sb2 precision = 0;
	sb2 scale = 0;
	sb1 scale1 = 0;
	float ftest[1024];
	ub4 rows = 0;
	sb4 starown = 0;
	sb4 colnum11 = 0;

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	}

    strcpy(testse,"select * from floattest");



	rc = GCIStmtPrepare(stmt, errhp, testse, strlen(testse), 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}

        if (rc = GCIAttrGet (stmt, GCI_HTYPE_STMT,&colnum11, 0,GCI_ATTR_NUM_COLS,errhp) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
            fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
            goto insertmultithreadtableEXIT;
        }

        printf("selectdecconverttable2 show the colname :colnum %d\n",colnum11);

            
        for(i = 0;i< colnum11;i++)
        {
            rc = GCIParamGet((CONST dvoid *)stmt,(ub4)GCI_HTYPE_STMT,(GCIError *)errhp,(dvoid **)&param,(ub4)i+1);
            
            if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
                fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
                goto insertmultithreadtableEXIT;
            }   
            if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&type, 0,GCI_ATTR_DATA_TYPE,errhp) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
                fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
                goto insertmultithreadtableEXIT;
            }   
            if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&precision, 0,GCI_ATTR_PRECISION,errhp) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
                fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
                goto insertmultithreadtableEXIT;
            }   
                if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&scale, 0,GCI_ATTR_SCALE,errhp) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
                fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
                goto insertmultithreadtableEXIT;
            }   
            
            if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&coltypename, 0,GCI_ATTR_TYPE_NAME,errhp) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
                fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
                goto insertmultithreadtableEXIT;
            }           
                    scale1 = scale;
            fprintf(stdout, "selectdatconverttable2 show the colname %s coltype %d col type %s,COL precision %d,scale %d\n",colname,type,coltypename,precision,scale1);
            memset(colname,0 ,sizeof(colname));
        }

        memset(ftest,0,sizeof(ftest));

        if ((rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)ftest,(sb4)4, (ub2)SQLT_FLT,
                        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        
                goto insertmultithreadtableEXIT;
            }   

             
        //test execute iters param =0; if 0only insert one row 
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		
		goto insertmultithreadtableEXIT;

	}

        GCIAttrGet(stmt, GCI_HTYPE_STMT, &rows, 0, GCI_ATTR_ROW_COUNT, errhp);
        fprintf(stdout, "prefetch ftest GCI_ATTR_ROW_COUNT %d\n",rows);  


	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmt, errhp, 1024, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto insertmultithreadtableEXIT;	
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
              fprintf(stdout, "SCADA_ANALOG201806 GCI_ATTR_ROW_COUNT %d\n",rownum);          

		if(starown == rownum)
			break;


		starown = rownum;
               GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);        
               fprintf(stdout, "SCADA_ANALOG201806 GCI_ATTR_ROWS_FETCHED %d\n",rownum);          
        for(i = 0;i < rownum;i++)
        {
            fprintf(stdout, "ftest ============================ %.50f\n",ftest[i]);          
        }
	}


	printf("selafctable cttable 100 recs\n");
	
insertmultithreadtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}

int selafctable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIDefine *Definep[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num[100] = {0};
	char dec1[100] = {0};
	short dec2[100] = {0};
	long dec3[100] = {0};	
	long dec4[100] = {0};	
	char ch[100] = {1,1};
	char ch1[1000] = {0,0};
	char *colname = {0};
	char *coltypename = {0};
	sb4 colnum11 = 0;
	GCIParam *param = NULL;
	ub2 type = 0;
	sb2 precision = 0;
	sb2 scale = 0;
	sb1 scale1 = 0;
	long oid = 0;
	int valuei = 0;
	int qualityi = 0;
	char testse[1024] ;
	char timestr[100];
	int processi = 0;
	sb4 starown = 0;
	ub4 rows = 0;
	char *t1 =	"\nSELECT ATTR_OID, ATTR_TIME, VALUE, QUALITY, PROCESS FROM ";
	char *t2 = "( ";
	char *t3 = "(SELECT * FROM SCADA_ANALOG201806 WHERE ";
	char *t4 = "ATTR_TIME >= TO_DATE('2018-06-02 00:00:00','YYYY-MM-DD HH24:MI:SS') ";
	char *t5 = "AND ATTR_TIME <= TO_DATE('2018-06-02 10:07:04','YYYY-MM-DD HH24:MI:SS') ";
	char *t6 = "AND (ATTR_OID = 15481128392065025) ) ";
	char * t7 = ") ORDER BY ATTR_OID, ATTR_TIME";

	sprintf(testse,"%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n",t1,t2,t3,t4,t5,t6,t7);
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	}

	rc = GCIStmtPrepare(stmt, errhp, testse, strlen(testse), 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}

        if (rc = GCIAttrGet (stmt, GCI_HTYPE_STMT,&colnum11, 0,GCI_ATTR_NUM_COLS,errhp) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
            fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
            goto insertmultithreadtableEXIT;
        }       

        printf("selectdecconverttable2 show the colname :colnum %d\n",colnum11);
            
        for(i = 0;i< colnum11;i++)
        {
            rc = GCIParamGet((CONST dvoid *)stmt,(ub4)GCI_HTYPE_STMT,(GCIError *)errhp,(dvoid **)&param,(ub4)i+1);
            
            if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
                fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
                goto insertmultithreadtableEXIT;
            }   
            if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&type, 0,GCI_ATTR_DATA_TYPE,errhp) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
                fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
                goto insertmultithreadtableEXIT;
            }   
            if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&precision, 0,GCI_ATTR_PRECISION,errhp) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
                fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
                goto insertmultithreadtableEXIT;
            }   
                if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&scale, 0,GCI_ATTR_SCALE,errhp) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
                fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
                goto insertmultithreadtableEXIT;
            }   
            
            if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&coltypename, 0,GCI_ATTR_TYPE_NAME,errhp) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
                fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
                goto insertmultithreadtableEXIT;
            }           
                    scale1 = scale;
            fprintf(stdout, "selectdatconverttable2 show the colname %s coltype %d col type %s,COL precision %d,scale %d\n",colname,type,coltypename,precision,scale1);
            memset(colname,0 ,sizeof(colname));
        }

        if ((rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)&oid,(sb4)8, (ub2)SQLT_INT,
                        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        
                goto insertmultithreadtableEXIT;
            }   

        if ((rc = GCIDefineByPos(stmt, &Definep[0], errhp, 2, (dvoid *)timestr,(sb4)100, (ub2)SQLT_CHR,
                        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        
                goto insertmultithreadtableEXIT;
            }   

    if ((rc = GCIDefineByPos(stmt, &Definep[0], errhp, 3, (dvoid *)&valuei,(sb4)4, (ub2)SQLT_INT,
                    (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
            goto insertmultithreadtableEXIT;
        }

        if ((rc = GCIDefineByPos(stmt, &Definep[0], errhp, 4, (dvoid *)&qualityi,(sb4)4, (ub2)SQLT_INT,
                        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        
                goto insertmultithreadtableEXIT;
            }   

        if ((rc = GCIDefineByPos(stmt, &Definep[0], errhp, 5, (dvoid *)&processi,(sb4)4, (ub2)SQLT_INT,
                        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        
                goto insertmultithreadtableEXIT;
            }               
        //test execute iters param =0; if 0only insert one row 
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		
		goto insertmultithreadtableEXIT;

	}

        GCIAttrGet(stmt, GCI_HTYPE_STMT, &rows, 0, GCI_ATTR_ROW_COUNT, errhp);
        fprintf(stdout, "prefetch SCADA_ANALOG201806 GCI_ATTR_ROW_COUNT %d\n",rows);  
        fprintf(stdout, "prefetch SCADA_ANALOG201806 oid %ld\n",oid);  


	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmt, errhp, 1, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto insertmultithreadtableEXIT;	
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
              fprintf(stdout, "SCADA_ANALOG201806 GCI_ATTR_ROW_COUNT %d\n",rownum);          

		if(starown == rownum)
			break;

		starown = rownum;
               GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);        
               fprintf(stdout, "SCADA_ANALOG201806 GCI_ATTR_ROWS_FETCHED %d\n",rownum);          
	}


	rc = GCIStmtPrepare(stmt, errhp, "select c,'ddd' from  ct", strlen("select * from  ct") + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}
#if 1	
	if ((rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)ch,(sb4)1, (ub2)SQLT_AFC,
					(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
		{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
	
			goto insertmultithreadtableEXIT;
		}	
    if ((rc = GCIDefineByPos(stmt, &Definep[0], errhp, 2, (dvoid *)ch1,(sb4)100, (ub2)SQLT_CHR,
                    (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    
            goto insertmultithreadtableEXIT;
        }   

     colnum11 = 0;
    if (rc = GCIAttrGet (stmt, GCI_HTYPE_STMT,&colnum11, 0,GCI_ATTR_NUM_COLS,errhp) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }       
   // char *colname = {0};
    //char *coltypename = {0};
    printf("selectdecconverttable2 show the colname :colnum %d\n",colnum11);

    param = NULL;
     type = 0;
         precision = 0;
         scale = 0;
         scale1 = 0;
        
    for(i = 0;i< colnum11;i++)
    {
        rc = GCIParamGet((CONST dvoid *)stmt,(ub4)GCI_HTYPE_STMT,(GCIError *)errhp,(dvoid **)&param,(ub4)i+1);
        
        if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

            fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
            goto insertmultithreadtableEXIT;
        }   
        if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&type, 0,GCI_ATTR_DATA_TYPE,errhp) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

            fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
            goto insertmultithreadtableEXIT;
        }   
        if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&precision, 0,GCI_ATTR_PRECISION,errhp) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

            fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
            goto insertmultithreadtableEXIT;
        }   
            if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&scale, 0,GCI_ATTR_SCALE,errhp) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

            fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
            goto insertmultithreadtableEXIT;
        }   
        
        if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&coltypename, 0,GCI_ATTR_TYPE_NAME,errhp) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

            fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
            goto insertmultithreadtableEXIT;
        }           
                scale1 = scale;
        fprintf(stdout, "selectdatconverttable2 show the colname %s coltype %d col type %s,COL precision %d,scale %d\n",colname,type,coltypename,precision,scale1);
        memset(colname,0 ,sizeof(colname));
    }

	    //test execute iters param =0; if 0only insert one row 
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		
		goto insertmultithreadtableEXIT;

	}

	starown = 0;

	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if ((rc = GCIStmtFetch(stmt, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto insertmultithreadtableEXIT;	
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(starown == rownum)
			break;

		for(i=0; i<rownum; i++)
		{	
			fprintf(stdout, "\tRetrieving row number %c,%c\n",ch[i],ch[i+1]);
		}
		starown = rownum;
               GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);        
               fprintf(stdout, "selafctable GCI_ATTR_ROWS_FETCHED %d\n",rownum);          
	}
#else	

#endif	

	printf("selafctable cttable 100 recs\n");
	
insertmultithreadtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}

/*
 * This function allocates the row and collection buffers, passes
 * them to the do_select_storebyxxx() function, along with an appropriate select
 * statement and then frees all allocated handles.
 */
int main (long argc,
		char* argv[])
{
	ub4			i, in;

	ub1         verInfoBuffer[SELSQL_LEN];
	ub4			verInfoLen;
	ub1         majorVer[3];
	ub4      	isUdoEnabled;
	int rc = 0;
	/* Handles */
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;
	GCIStmt *stmthp1 = NULL;
	GCIStmt *stmthp2 = NULL;
	int fd = 0;


//write to txt
//test for 50w updates

	
 	rc = logdb(&envhp,&errhp,&svchp);
	if(rc)
	{
		goto EXIT;
	}

	rc = dropdatconverttable(envhp,svchp,errhp);
	rc = createdatconverttable(envhp,svchp,errhp);
	if(rc)
	{
		fprintf (stdout, "create lob table failure.\n");
		goto EXIT;
	}	
/*
	rc = dropfltconverttable(envhp,svchp,errhp);
	rc = createfltconverttable(envhp,svchp,errhp);
    	rc = dropflt1converttable(envhp,svchp,errhp);
        rc = createflt1converttable(envhp,svchp,errhp);
    	rc = dropflt1converttable(envhp,svchp,errhp);
        rc = createflt1converttable(envhp,svchp,errhp);        
	fprintf (stdout, "selectdatconverttablebycol test ++++++++++++++++++++.\n");	

*/
	fprintf (stdout, "create lob table success.\n");
	rc = insertdatconverttable(envhp,svchp,errhp);
/*
	rc = insertdatconvert2table(envhp,svchp,errhp);
	rc = insertdatconvert3table(envhp,svchp,errhp);
	rc = insertdatconvert4table(envhp,svchp,errhp);	
	rc = insertdatconvert5table(envhp,svchp,errhp);	
	if(rc)
	{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf (stdout, "insertdatconvert2table failure.\n");
		goto EXIT;
	}	
	rc = insertfltconverttable(envhp,svchp,errhp);	
	if(rc)
	{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		fprintf (stdout, "insertfltconverttable1 failure.\n");
		goto EXIT;
	}		

	rc = insertdecconverttable(envhp,svchp,errhp);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "insertdecconverttable fail \nError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto EXIT;
	}	
    	fprintf(stdout, "================== insertdecconverttable success =============\n");
	rc = selectdecconverttable(envhp,svchp,errhp);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "selectdecconverttable \nError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto EXIT;
	}	
	rc = selectfltconverttable(envhp,svchp,errhp);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "selectdecconverttable \nError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto EXIT;
	}	
    //for (;;)
    {
	rc = 	selectdatconverttable2(envhp,svchp,errhp);
	if(rc)
	{
		fprintf (stdout, "selectdatconverttable2 failure.\n");
	}    

	//rc = 	selectdatconverttable(envhp,svchp,errhp);
	if(rc)
	{
		fprintf (stdout, "selectdatconverttable failure.\n");
		goto EXIT;
	}	
	fprintf (stdout, "selectdatconverttablebycol test ++++++++++++++++++++.\n");	
	rc = 	selectdatconverttable2(envhp,svchp,errhp);
	if(rc)
	{
		fprintf (stdout, "selectdatconverttable2 failure.\n");
		goto EXIT;
	}
	fprintf (stdout, "selectdatconverttablebyrow test ++++++++++++++++++++.\n");	
	rc = 	selectdatconverttablebyrow(envhp,svchp,errhp);
	if(rc)
	{
		fprintf (stdout, "selectdatconverttablebyrow failure.\n");
		goto EXIT;
	}	
	fprintf (stdout, "selectdatconverttable3 test ++++++++++++++++++++.\n");
    rc = selectdatconverttable3(envhp,svchp,errhp);
    if (rc)
    {
        fprintf (stdout, "selectdatconverttable3 failure.\n");
        goto EXIT;    
    }	
	//rc = insertdatconverttable(envhp,svchp,errhp);
	rc = selectfltconverttable1(envhp,svchp,errhp);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "selectdecconverttable \nError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto EXIT;
	}		
	rc = selectfltconverttable2(envhp,svchp,errhp);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "selectdecconverttable \nError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto EXIT;
	}		
	
	rc = selectfltconverttable3(envhp,svchp,errhp);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "selectdecconverttable \nError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto EXIT;
	}		
//	rc = updatedatconverttable(envhp,svchp,errhp);
  //      rc = insertfltconverttable1(envhp,svchp,errhp);
        if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "insertfltconverttable1 \nError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto EXIT;
	}		        
        rc = selectdecconverttable11(envhp,svchp,errhp);
        if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "selectdecconverttable11 \nError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto EXIT;
	}		    

	//rc = insertafctable(envhp,svchp,errhp);
        if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "insertafctable \nError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto EXIT;
	}		
	//rc = selafctable(envhp,svchp,errhp);
        if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "selafctable \nError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto EXIT;
	}			
    rc = selfloattable(envhp,svchp,errhp);
    {
    	sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "selafctable \nError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto EXIT;

    }
}
	rc = createttable(envhp,svchp,errhp);
        if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "createttable \nError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto EXIT;
	}				
	fprintf (stdout,"\nHit <Enter> to continue...");
*/
	in = getchar ();

EXIT:

	/* CLEANUP: Close the statement handle
	 **          Free the statement handle
	 **          Disconnect from the datasource
	 **          Free the connection and environment handles
	 **          Exit
	 */
	if(stmthp1)
		GCIHandleFree((dvoid *)stmthp1, GCI_HTYPE_STMT);

	if(stmthp2)
		GCIHandleFree((dvoid *)stmthp2, GCI_HTYPE_STMT);

	GCILogoff(svchp, errhp);

	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);

	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);


	fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
	in = getchar ();

	return (rc);
}

