/***************************************************************************
*    Licensed Materials - Property of GBase
*    "Restricted Materials of GBase"
*    GBase 8s GCI Interface demo
*
*
*    Copyright GBase Corporation 2015 All rights reserved.
*    Title:          test_datconvert.c
*
*  Description:    To test GCIDateTime&GCIInterval
*
****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gci.h"

#define SELSQL_LEN     25
#define ERRMSG_LEN     200
char *createdtttable = "create table dtt (id int primary key,date_time timestamp,d1 datetime year to second,d2 datetime year to fraction(5),d3 datetime year to day,d4 datetime hour to second,d5 date)";
char *dropdtttable = "drop table dtt";
char *insertdtttable = "insert into  dtt(id,date_time,d1,d2,d3,d4,d5) values(?,?,?,?,?,?,?)";
//char *insertdtttable = "insert into  dtt(id,d4,d5,d1) values(?,?,?,?)";
char *selectdatadtt = "select * from dtt";

char *updatedatadattable = "update dtt set date_time= ? where id = ?";

char *createintervaltable = "create table intervalt (id int primary key,\
                            i1 interval year  to month,\
                            i2 interval day  to fraction(3),\
                            i3 interval hour to hour,\
                            i4 interval month to month,\
                            i5 interval year to year,\
                            i6 interval day to day,\
                            i7 interval hour to fraction(5),\
                            i8 interval minute to minute\
                            )";
char *insertdataintervaltable = "insert into  intervalt(id,i1,i2,i3,i4,i5,i6,i7,i8) values(?,?,?,?,?,?,?,?,?)";
char *selectdataintervaldtt = "select * from intervalt";

char *dropintervalable = "drop table intervalt";
char *updateintervaltable = "update intervalt set i1= ? where id = ?";


char *createbdtttable = "create table bdtt (id int primary key,date_time timestamp)";
char *dropbdtttable = "drop table bdtt";
char *insertbdtttable = "insert into  bdtt(id,date_time) values(?,?)";
char *selectdatabdtt = "select * from bdtt";


int logdb(GCIEnv **envhp1,GCIError **errhp1,GCISvcCtx **svchp1)
{
    int rc = GCI_SUCCESS;

    ///connect db
    GCIEnv *envhp= NULL;
    GCISvcCtx *svchp= NULL;
    GCIError *errhp = NULL;
    GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";

    GCItext *user = (GCItext*)"gbasedbt";
    GCItext *pswd = (GCItext*)"Big4ifmx";
    /*
    GCItext *user = (GCItext*)"root";
    GCItext *pswd = (GCItext*)"redgbs";
    */

    /*  STEP 1. Get data source name from command line (or use default)
    **          Allocate the environment handle and set ODBC version
    **          Allocate the connection handle
    **          Establish the database connection
    **          Allocate the statement handle
    **          Drop demo database if it already exists
    */
    /* initialize the mode to be the threaded and object environment */
    if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
        0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
        goto logdbEXIT;
    }

    /* allocate an error handle */
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
        GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
        goto logdbEXIT;
    }

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
        GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
        goto logdbEXIT;
    }
    if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
        pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
        goto logdbEXIT;
    }
    *envhp1 = envhp;
    *errhp1 = errhp;
    *svchp1 = svchp;


    fprintf (stdout, "Step 1 done...connected to database.\n");

logdbEXIT:
    *envhp1 = envhp;
    *errhp1 = errhp;
    *svchp1 = svchp;
    return rc;
}


//create the lob test key
int createtable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp,char *sql)
{

    int rc = 0;
    GCIStmt *stmt = NULL;
    //alloc the stmt handle
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto createlobtableEXIT;
    }
#if 1
    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)sql, strlen(sql), 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in createtable stmt prepare -- !!\n");
        goto createlobtableEXIT;
    }
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto createlobtableEXIT;
    }
#endif
createlobtableEXIT:
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}

int droptable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp,char *dropsql)
{
    int rc = 0;
    GCIStmt *stmt;
    //alloc the stmt handle
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test droptable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto droplobtableEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)dropsql, strlen(dropsql) , 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in droptable stmt prepare -- !!\n");
        goto droplobtableEXIT;
    }
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto droplobtableEXIT;
    }

droplobtableEXIT:
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;

}


int selectdtttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
    int rc = 0;
    GCIStmt *stmt = NULL;
    //alloc the stmt handle
    GCIDefine *Definep[6];
    char *pbuf = NULL;
    long loop = 0;
    long i = 0;
    long item_num = 0;
    GCIDateTime *ad[6];
	sb4 starown;

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto SUCCESS_EXIT;
    }

    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[0] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
        goto SUCCESS_EXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[1] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 1.\nExiting!!\n");
        goto SUCCESS_EXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[2] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 2.\nExiting!!\n");
        goto SUCCESS_EXIT;
    }

    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[3] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 3.\nExiting!!\n");
        goto SUCCESS_EXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[4] , GCI_DTYPE_TIME, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 4.\nExiting!!\n");
        goto SUCCESS_EXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[5] , GCI_DTYPE_DATE, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 5.\nExiting!!\n");
        goto SUCCESS_EXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)selectdatadtt, strlen(selectdatadtt), 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in GCIStmtPrepare selectdatadtt datetime prepare -- !!\n");
        goto SUCCESS_EXIT;
    }
#if 1

    if (rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)&item_num,(sb4)sizeof(long), (ub2)SQLT_INT,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto SUCCESS_EXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[1], errhp, 2, (dvoid *)&ad[0],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_TIMESTAMP,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto SUCCESS_EXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[2], errhp, 3, (dvoid *)&ad[1],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_TIMESTAMP,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto SUCCESS_EXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[2], errhp, 4, (dvoid *)&ad[2],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_TIMESTAMP,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto SUCCESS_EXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[3], errhp, 5, (dvoid *)&ad[3],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_TIMESTAMP,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto SUCCESS_EXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[4], errhp, 6, (dvoid *)&ad[4],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_TIME,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto SUCCESS_EXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[5], errhp, 7, (dvoid *)&ad[5],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_DATE,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto SUCCESS_EXIT;
    }

    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS);
    if(rc)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto SUCCESS_EXIT;
    }

    starown = 0;

    while(1)
    {
        ub4 rownum = 0;
	    int i;
        sb2 year = 0;
        ub1 month = 0;
        ub1 day = 0;
        ub1 h;
        ub1 min;
        ub1 sec;
        ub4 frac;

        if ((rc = GCIStmtFetch(stmt, errhp, 1, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
        {
            fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
            rc = GCI_SUCCESS;
            goto SUCCESS_EXIT;
            break;
        }
        GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

        if(starown == rownum)
            break;

        GCIDateTimeGetDate(envhp, errhp, ad[0], &year, &month, &day);
        GCIDateTimeGetTime(envhp, errhp, ad[0], &h, &min, &sec,&frac);
        fprintf(stdout,"====datetime0 %d-%d-%d %d:%d:%d.f%d\n",year,month,day,h,min,sec,frac);

        GCIDateTimeGetDate(envhp, errhp, ad[1], &year, &month, &day);
        GCIDateTimeGetTime(envhp, errhp, ad[1], &h, &min, &sec,&frac);
        fprintf(stdout,"====datetime1 %d-%d-%d %d:%d:%d.f%d\n",year,month,day,h,min,sec,frac);

        GCIDateTimeGetDate(envhp, errhp, ad[2], &year, &month, &day);
        GCIDateTimeGetTime(envhp, errhp, ad[2], &h, &min, &sec,&frac);
        fprintf(stdout,"====datetime2 %d-%d-%d %d:%d:%d.f%d\n",year,month,day,h,min,sec,frac);

        GCIDateTimeGetDate(envhp, errhp, ad[3], &year, &month, &day);
        GCIDateTimeGetTime(envhp, errhp, ad[3], &h, &min, &sec,&frac);
        fprintf(stdout,"====datetime3 %d-%d-%d %d:%d:%d.f%d\n",year,month,day,h,min,sec,frac);

        GCIDateTimeGetTime(envhp, errhp, ad[4], &h, &min, &sec,&frac);
        fprintf(stdout,"====datetime4 %d:%d:%d.f%d\n",h,min,sec,frac);

        GCIDateTimeGetDate(envhp, errhp, ad[5], &year, &month, &day);
        fprintf(stdout,"====datetime5 %d-%d-%d %d:%d:%d.f%d\n",year,month,day);

        starown = rownum;
    }
#endif

    printf("select dtt recs\n");

SUCCESS_EXIT:


    for (loop=0;loop <6;loop++)
    {/*gcidatetime all */
        GCIDescriptorFree(ad[loop],GCI_DTYPE_TIMESTAMP);
    }

    if(pbuf)
        free(pbuf);
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}

int selectbdtttablebyrow(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
    int rc = 0;
    GCIStmt *stmt = NULL;
    //alloc the stmt handle
    GCIDefine *Definep[2];

    char *pbuf = NULL;
    long loop = 0;
    long i = 0;
    long rowlen = 0;
    long *pitem_num = NULL;
    GCIDateTime **ad = NULL;

    short *ind_item = NULL;
    short *ind_d = NULL;

    short *rlen_item = NULL;
    short *rlen_d = NULL;
	sb4 starown;
    rowlen = sizeof(long )+sizeof(GCIDateTime *)+sizeof(short)*4;

    pbuf = (char *)malloc(rowlen*2);

    if (NULL == pbuf)
    {
        fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
        goto SUCCESS_EXIT;
    }

    pitem_num = (long *)pbuf;
    ad = (GCIDateTime **)(pitem_num +1);

    ind_item = (short *)(ad + 1);
    ind_d = (short *)(ind_item  + 1);

    rlen_item = (short *)(ind_d  + 1);
    rlen_d = (short *)(rlen_item  + 1);

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto SUCCESS_EXIT;
    }

    for (i = 0;i < 2;i++)
    {
        rc = GCIDescriptorAlloc(envhp,(dvoid **)((char *)ad +  rowlen * i), GCI_DTYPE_TIMESTAMP, 0, NULL);
        if (rc)
        {
            fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
            goto SUCCESS_EXIT;
        }
    }
    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)selectdatabdtt, strlen(selectdatabdtt), 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in GCIStmtPrepare selectdatadtt datetime prepare -- !!\n");
        goto SUCCESS_EXIT;
    }
#if 1

    if (rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)pitem_num,(sb4)sizeof(long), (ub2)SQLT_INT,
        (dvoid *)ind_item, (ub2 *)rlen_item, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto SUCCESS_EXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[1], errhp, 2, (dvoid *)ad,(sb4)sizeof(GCIDateTime *), (ub2)SQLT_TIMESTAMP,
        (dvoid *)ind_d, (ub2 *)rlen_d, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto SUCCESS_EXIT;
    }
    if (rc = GCIDefineArrayOfStruct(Definep[0], errhp,rowlen, rowlen, rowlen, 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
        goto SUCCESS_EXIT;
    }
    if (rc = GCIDefineArrayOfStruct(Definep[1], errhp,rowlen, rowlen, rowlen, 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
        goto SUCCESS_EXIT;
    }

    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS);
    if(rc)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto SUCCESS_EXIT;
    }

    starown = 0;

    while(1)
    {
        ub4 rownum = 0;
		int i;
        sb2 year = 0;
        ub1 month = 0;
        ub1 day = 0;
        ub1 h;
        ub1 min;
        ub1 sec;
        ub4 frac;

        if ((rc = GCIStmtFetch(stmt, errhp, 2, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
        {
            fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
            rc = GCI_SUCCESS;
            goto SUCCESS_EXIT;
            break;
        }
        GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

        if(starown == rownum)
            break;

        GCIDateTimeGetDate(envhp, errhp, *ad, &year, &month, &day);
        GCIDateTimeGetTime(envhp, errhp, *ad, &h, &min, &sec,&frac);
        fprintf(stdout,"====datetime0 %d-%d-%d %d:%d:%d.f%d\n",year,month,day,h,min,sec,frac);

        GCIDateTimeGetDate(envhp, errhp, *(GCIDateTime **)((char *)ad+rowlen), &year, &month, &day);
        GCIDateTimeGetTime(envhp, errhp, *(GCIDateTime **)((char *)ad+rowlen), &h, &min, &sec,&frac);
        fprintf(stdout,"====datetime1 %d-%d-%d %d:%d:%d.f%d\n",year,month,day,h,min,sec,frac);


        starown = rownum;
    }
#endif

    printf("select bdtt recs\n");

SUCCESS_EXIT:

    for (loop=0;loop <2;loop++)
    {/*gcidatetime all */
        GCIDescriptorFree(*(GCIDateTime **)((char *)ad + rowlen*loop),GCI_DTYPE_TIMESTAMP);
    }
    if(pbuf)
        free(pbuf);


    if (stmt)
        GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}

int selectbdtttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
    int rc = 0;
    GCIStmt *stmt = NULL;
    //alloc the stmt handle
    GCIDefine *Definep[6];
    char *pbuf = NULL;
    long loop = 0;
    long i = 0;
    long item_num[2] = {0};
    GCIDateTime *ad[2];
	sb4 starown = 0;

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto SUCCESS_EXIT;
    }

    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[0] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
        goto SUCCESS_EXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[1] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 1.\nExiting!!\n");
        goto SUCCESS_EXIT;
    }


    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)selectdatabdtt, strlen(selectdatabdtt), 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in GCIStmtPrepare selectdatadtt datetime prepare -- !!\n");
        goto SUCCESS_EXIT;
    }
#if 1

    if (rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)&item_num,(sb4)sizeof(long), (ub2)SQLT_INT,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto SUCCESS_EXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[1], errhp, 2, (dvoid *)&ad[0],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_TIMESTAMP,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto SUCCESS_EXIT;
    }

    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS);
    if(rc)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto SUCCESS_EXIT;
    }

    starown = 0;

    while(1)
    {
        ub4 rownum = 0;
        int i;
        sb2 year = 0;
        ub1 month = 0;
        ub1 day = 0;
        ub1 h;
        ub1 min;
        ub1 sec;
        ub4 frac;

        if ((rc = GCIStmtFetch(stmt, errhp, 2, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
        {
            fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
            rc = GCI_SUCCESS;
            goto SUCCESS_EXIT;
            break;
        }
        GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

        if(starown == rownum)
            break;

        GCIDateTimeGetDate(envhp, errhp, ad[0], &year, &month, &day);
        GCIDateTimeGetTime(envhp, errhp, ad[0], &h, &min, &sec,&frac);
        fprintf(stdout,"====datetime0 %d-%d-%d %d:%d:%d.f%d\n",year,month,day,h,min,sec,frac);

        GCIDateTimeGetDate(envhp, errhp, ad[1], &year, &month, &day);
        GCIDateTimeGetTime(envhp, errhp, ad[1], &h, &min, &sec,&frac);
        fprintf(stdout,"====datetime1 %d-%d-%d %d:%d:%d.f%d\n",year,month,day,h,min,sec,frac);


        starown = rownum;
    }
#endif

    printf("select bdtt recs\n");

SUCCESS_EXIT:
    if(pbuf)
        free(pbuf);

    for (loop=0;loop <2;loop++)
    {/*gcidatetime all */
        GCIDescriptorFree(ad[loop],GCI_DTYPE_TIMESTAMP);
    }
    if (stmt)
        GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}

int insertbdtttablefbyrow(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
    int rc = 0;
    GCIStmt *stmt = NULL;
    //alloc the stmt handle
    GCIBind *Bindp[7];
    char *pbuf = NULL;
    long loop = 0;
    long i = 0;
#define _rownummax_ 20
    long *item_num = NULL;
    long rowlen = 0;

    GCIDateTime **ad = NULL;

    rowlen = sizeof(long )+sizeof(GCIDateTime **);

    pbuf = (char *)malloc(rowlen*_rownummax_);
    item_num = (long *)pbuf;
    ad = (GCIDateTime **)(item_num + 1);

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }

    for (i = 0;i <_rownummax_;i++)
    {
        rc = GCIDescriptorAlloc(envhp,(dvoid **)(GCIDateTime **)((char *)ad + rowlen * i), GCI_DTYPE_TIMESTAMP, 0, NULL);
        if (rc)
        {
            fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
            goto insertmultithreadtableEXIT;
        }
    }

    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)insertbdtttable, strlen(insertbdtttable) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insertdtttable stmt prepare -- !!\n");
        goto insertmultithreadtableEXIT;
    }
#if 1
    if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)item_num,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }

    if(rc = GCIBindByPos(stmt,&Bindp[1],errhp,2,(dvoid *)ad,(sb4)sizeof(GCIDateTime *),SQLT_TIMESTAMP,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }

    rc =  GCIBindArrayOfStruct(Bindp[0],errhp,(rowlen),0,0,0);
    rc =  GCIBindArrayOfStruct(Bindp[1],errhp,(rowlen),0,0,0);

    for (loop =0 ;loop < 5;loop++)
    {
        for(i = 0;i < 20;i++)
        {
            GCIDateTimeConstruct(envhp,errhp,*((GCIDateTime **)((char *)ad + rowlen * i)),2000+i + loop *10,2,2+i,1+i,i,22+i,0,NULL,0);
            /**/
            *(long *)((char *)item_num + rowlen*i) = loop*20 + i + 1000;
        }
        /***/
        //execute
        rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)20, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
            GCI_COMMIT_ON_SUCCESS);
        if(rc)
        {
            printf("GCIStmtExecute error %d\n",i);
            goto insertmultithreadtableEXIT;
        }

    }
#endif

    printf("insertbdttwithbindsql recs\n");

insertmultithreadtableEXIT:
    for (loop=0;loop <20;loop++)
    {/*gcidatetime all */
        GCIDescriptorFree(*((GCIDateTime **)((char *)ad + rowlen*loop)),GCI_DTYPE_TIMESTAMP);
    }
    if (pbuf)
        free(pbuf);
    if (stmt)
        GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}


int insertbdtttablef(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
    int rc = 0;
    GCIStmt *stmt = NULL;
    //alloc the stmt handle
    GCIBind *Bindp[7];
    char *pbuf = NULL;
    long loop = 0;
    long i = 0;
    long item_num[20] = {0};

    GCIDateTime *ad[20];

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }

    for (i = 0;i <20;i++)
    {
        rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[i] , GCI_DTYPE_TIMESTAMP, 0, NULL);
        if (rc)
        {
            fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
            goto insertmultithreadtableEXIT;
        }
    }

    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)insertbdtttable, strlen(insertbdtttable) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insertdtttable stmt prepare -- !!\n");
        goto insertmultithreadtableEXIT;
    }
#if 1
    if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)item_num,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }

    if(rc = GCIBindByPos(stmt,&Bindp[1],errhp,2,(dvoid *)&ad,(sb4)sizeof(GCIDateTime *),SQLT_TIMESTAMP,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }

    for (loop =0 ;loop < 5;loop++)
    {
        for(i = 0;i < 20;i++)
        {
            GCIDateTimeConstruct(envhp,errhp,ad[i],2000+i + loop *10,2,2+i,1+i,22+i,22+i,0,NULL,0);
            /**/
            item_num[i] = loop*20 + i + 1;
        }
        /***/
        //execute
        rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)20, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
            GCI_COMMIT_ON_SUCCESS);
        if(rc)
        {
            printf("GCIStmtExecute error %d\n",i);
            goto insertmultithreadtableEXIT;
        }

    }
#endif

    printf("insertbdttwithbindsql recs\n");

insertmultithreadtableEXIT:
    for (loop=0;loop <20;loop++)
    {/*gcidatetime all */
        GCIDescriptorFree(ad[loop],GCI_DTYPE_TIMESTAMP);
    }
    if (stmt)
        GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}

int insertdtttablef(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
    int rc = 0;
    GCIStmt *stmt = NULL;
    //alloc the stmt handle
    GCIBind *Bindp[7];
    char *pbuf = NULL;
    long loop = 0;
    long i = 0;
    long item_num = {0};

    GCIDateTime *ad[6];

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }

    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[0] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[1] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 1.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[2] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 2.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }

    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[3] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 3.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[4] , GCI_DTYPE_TIME, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 4.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[5] , GCI_DTYPE_DATE, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 5.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)insertdtttable, strlen(insertdtttable) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insertdtttable stmt prepare -- !!\n");
        goto insertmultithreadtableEXIT;
    }
#if 1
    if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)&item_num,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
#if 1
    if(rc = GCIBindByPos(stmt,&Bindp[1],errhp,2,(dvoid *)&ad[0],(sb4)sizeof(GCIDateTime *),SQLT_TIMESTAMP,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }

    if(rc = GCIBindByPos(stmt,&Bindp[2],errhp,3,(dvoid *)&ad[1],(sb4)sizeof(GCIDateTime *),SQLT_TIMESTAMP,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 3 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }


    if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,4,(dvoid *)&ad[2],(sb4)sizeof(GCIDateTime *),SQLT_TIMESTAMP,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 4 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
#if 1
    if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,5,(dvoid *)&ad[3],(sb4)sizeof(GCIDateTime *),SQLT_TIMESTAMP,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 5 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    /**/
    if(rc = GCIBindByPos(stmt,&Bindp[5],errhp,6,(dvoid *)&ad[4],(sb4)sizeof(GCIDateTime *),SQLT_TIME,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 6 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[6],errhp,7,(dvoid *)&ad[5],(sb4)sizeof(GCIDateTime *),SQLT_DATE,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 7 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
#endif
#endif
    for(i = 0;i < 5;i++)
    {
        GCIDateTimeConstruct(envhp,errhp,ad[0],1999+i,1+i,1+i,11+i,11+i,11+i,111,NULL,0);
        GCIDateTimeConstruct(envhp,errhp,ad[1],1999+i,2+i,1+i,12+i,11+i,11+i,111,NULL,0);
        GCIDateTimeConstruct(envhp,errhp,ad[2],1999+i,3+i,1+i,13+i,11+i,11+i,123456789,NULL,0);
        GCIDateTimeConstruct(envhp,errhp,ad[3],1999+i,4+i,1+i,14+i,11+i,11+i,111,NULL,0);
        GCIDateTimeConstruct(envhp,errhp,ad[4],1999+i,5+i,1+i,15+i,11+i,11+i,111,NULL,0);
        GCIDateTimeConstruct(envhp,errhp,ad[5],1999+i,6+i,1+i,16+i,11+i,11+i,111,NULL,0);/**/
        item_num = i+1;

        //execute
        rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
            GCI_COMMIT_ON_SUCCESS);
        if(rc)
        {
            printf("GCIStmtExecute error %d\n",i);
            goto insertmultithreadtableEXIT;
        }

    }
#endif

    printf("insertdttwithbindsql recs\n");

insertmultithreadtableEXIT:
    for (loop=0;loop <6;loop++)
    {/*gcidatetime all */
        GCIDescriptorFree(ad[loop],GCI_DTYPE_TIMESTAMP);
    }
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}
int insertdtttablebyrow(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
    int rc = 0;
    GCIStmt *stmt = NULL;
    //alloc the stmt handle
    GCIBind *Bindp[7];
    char *pbuf = NULL;
    long loop = 0;
    long i = 0;
    long item_num = {0};

    GCIDateTime *ad[6];

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }

    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[0] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[1] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 1.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[2] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 2.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }

    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[3] , GCI_DTYPE_TIMESTAMP, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 3.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[4] , GCI_DTYPE_TIME, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 4.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&ad[5] , GCI_DTYPE_DATE, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 5.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }


    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)insertdtttable, strlen(insertdtttable) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
        goto insertmultithreadtableEXIT;
    }
#if 1
    if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)&item_num,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }

    if(rc = GCIBindByPos(stmt,&Bindp[1],errhp,2,(dvoid *)&ad[0],(sb4)sizeof(GCIDateTime *),SQLT_TIMESTAMP,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[2],errhp,3,(dvoid *)&ad[1],(sb4)sizeof(GCIDateTime *),SQLT_TIMESTAMP,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,4,(dvoid *)&ad[2],(sb4)sizeof(GCIDateTime *),SQLT_TIMESTAMP,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,5,(dvoid *)&ad[3],(sb4)sizeof(GCIDateTime *),SQLT_TIMESTAMP,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[5],errhp,6,(dvoid *)&ad[4],(sb4)sizeof(GCIDateTime *),SQLT_TIMESTAMP,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[6],errhp,7,(dvoid *)&ad[5],(sb4)sizeof(GCIDateTime *),SQLT_TIMESTAMP,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }


    for(i = 0;i < 5;i++)
    {
        GCIDateTimeConstruct(envhp,errhp,ad[0],1999+i,1+i,1+i,11+i,11+i,11+i,11111,NULL,0);
        item_num = i+1;

        //execute
        rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
            GCI_COMMIT_ON_SUCCESS);
        if(rc)
        {
            printf("GCIStmtExecute error %d\n",i);
            goto insertmultithreadtableEXIT;
        }

    }
#endif

    printf("insertdttwithbindsql recs\n");

insertmultithreadtableEXIT:
    for (loop=0;loop <6;loop++)
    {/*gcidatetime all */
        GCIDescriptorFree(ad[loop],0);
    }
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}

int insertintervaltable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
    int rc = 0;
    GCIStmt *stmt = NULL;
    //alloc the stmt handle
    GCIBind *Bindp[10];
    char *pbuf = NULL;
    long loop = 0;
    long i = 0;
    long item_num = 0;
    GCIInterval *aI[9] = {0};

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }

    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[0] , GCI_DTYPE_INTERVAL_YM, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[1] , GCI_DTYPE_INTERVAL_DS, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 1.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[2] , GCI_DTYPE_INTERVAL_DS, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 2.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }

    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[3] , GCI_DTYPE_INTERVAL_YM, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 3.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[4] , GCI_DTYPE_INTERVAL_YM, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 4.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[5] , GCI_DTYPE_INTERVAL_DS, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 5.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[6] , GCI_DTYPE_INTERVAL_DS, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 4.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[7] , GCI_DTYPE_INTERVAL_DS, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 5.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)insertdataintervaltable, strlen(insertdataintervaltable) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
        goto insertmultithreadtableEXIT;
    }
#if 1
    if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)&item_num,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }


    if(rc = GCIBindByPos(stmt,&Bindp[1],errhp,2,(dvoid *)&aI[0],(sb4)sizeof(GCIInterval *),SQLT_INTERVAL_YM,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[2],errhp,3,(dvoid *)&aI[1],(sb4)sizeof(GCIInterval *),SQLT_INTERVAL_DS,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,4,(dvoid *)&aI[2],(sb4)sizeof(GCIInterval *),SQLT_INTERVAL_DS,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }

    if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,5,(dvoid *)&aI[3],(sb4)sizeof(GCIInterval *),SQLT_INTERVAL_YM,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[5],errhp,6,(dvoid *)&aI[4],(sb4)sizeof(GCIInterval *),SQLT_INTERVAL_YM,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[6],errhp,7,(dvoid *)&aI[5],(sb4)sizeof(GCIInterval *),SQLT_INTERVAL_DS,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }

    if(rc = GCIBindByPos(stmt,&Bindp[7],errhp,8,(dvoid *)&aI[6],(sb4)sizeof(GCIInterval *),SQLT_INTERVAL_DS,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[8],errhp,9,(dvoid *)&aI[7],(sb4)sizeof(GCIInterval *),SQLT_INTERVAL_DS,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    /*
    rc =  GCIBindArrayOfStruct(Bindp[4],errhp,(8+sizeof(GCIDate)),0,0,0);
    rc =  GCIBindArrayOfStruct(Bindp[3],errhp,(8+sizeof(GCIDate)),0,0,0);
    */

    for(i = 0;i < 5;i++)
    {
        item_num = i+1;

        GCIIntervalSetYearMonth(envhp,errhp,4,2,aI[0]);                 //year-month
        GCIIntervalSetDaySecond(envhp,errhp,-1,-2,-3,-4,-511,aI[1]);      //day-second
        GCIIntervalSetDaySecond(envhp,errhp,-3,-7,-8,-9,-10,aI[2]);     //hour-hour
        GCIIntervalSetYearMonth(envhp,errhp,-7,-12,aI[3]);              //month-month
        GCIIntervalSetYearMonth(envhp,errhp,-13,-14,aI[4]);             //year-year
        GCIIntervalSetDaySecond(envhp,errhp,-15,-16,-17,-18,-19,aI[5]); //day-day
        GCIIntervalSetDaySecond(envhp,errhp,3,21,22,23,24,aI[6]);       //hour-second
        GCIIntervalSetDaySecond(envhp,errhp,0,1,-27,28,-29,aI[7]);      //minute-minute

        //execute
        rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
            GCI_COMMIT_ON_SUCCESS);
        if(rc)
        {
            printf("GCIStmtExecute error %d\n",i);
            goto insertmultithreadtableEXIT;
        }

    }
#else
    if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
        goto insertmultithreadtableEXIT;
    }

    int offset = 0;
    for(i = 0;i < 100;i++)
    {

        *(long *)(pbuf + offset) = i + i;
        offset += sizeof(long);
        datetimestr = pbuf + offset;
        datetimestr->GCIDateDD = i+ 20;
        datetimestr->GCIDateMM = 4;
        datetimestr->GCIDateYYYY = 2016;
        datetimestr->GCIDateTime.GCITimeHH = 10;
        datetimestr->GCIDateTime.GCITimeMI = 45 + i;
        datetimestr->GCIDateTime.GCITimeSS = 55;

        offset += sizeof(GCIDate);
    }

    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto insertmultithreadtableEXIT;
    }

#endif

    printf("insertwithbindsql recs\n");

insertmultithreadtableEXIT:

    for (loop=0;loop <8;loop++)
    {/*gcidatetime all */
        GCIDescriptorFree(aI[loop],GCI_DTYPE_INTERVAL_DS);
    }

    if(pbuf)
        free(pbuf);
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}

int selectintervaltable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
    int rc = 0;
    GCIStmt *stmt = NULL;
    //alloc the stmt handle
    GCIDefine *Definep[10];
    char *pbuf = NULL;
    long loop = 0;
    long i = 0;
    long item_num = 0;
    GCIInterval *aI[9] = {0};
	sb4 starown;

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }

    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[0] , GCI_DTYPE_INTERVAL_YM, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[1] , GCI_DTYPE_INTERVAL_DS, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 1.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[2] , GCI_DTYPE_INTERVAL_DS, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 2.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }

    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[3] , GCI_DTYPE_INTERVAL_YM, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 3.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[4] , GCI_DTYPE_INTERVAL_YM, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 4.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[5] , GCI_DTYPE_INTERVAL_DS, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 5.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[6] , GCI_DTYPE_INTERVAL_DS, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 4.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[7] , GCI_DTYPE_INTERVAL_DS, 0, NULL);
    if (rc)
    {
        fprintf(stdout, "Error 5.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }


    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)selectdataintervaldtt, strlen(selectdataintervaldtt) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
        goto insertmultithreadtableEXIT;
    }
#if 1
    if (rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)&item_num,(sb4)sizeof(long), (ub2)SQLT_INT,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto insertmultithreadtableEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[1], errhp, 2, (dvoid *)&aI[0],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_INTERVAL_YM,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto insertmultithreadtableEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[2], errhp, 3, (dvoid *)&aI[1],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_INTERVAL_DS,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto insertmultithreadtableEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[3], errhp, 4, (dvoid *)&aI[2],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_INTERVAL_DS,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto insertmultithreadtableEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[4], errhp, 5, (dvoid *)&aI[3],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_INTERVAL_YM,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto insertmultithreadtableEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[5], errhp, 6, (dvoid *)&aI[4],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_INTERVAL_YM,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto insertmultithreadtableEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[6], errhp, 7, (dvoid *)&aI[5],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_INTERVAL_DS,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto insertmultithreadtableEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[7], errhp, 8, (dvoid *)&aI[6],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_INTERVAL_DS,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto insertmultithreadtableEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &Definep[8], errhp, 9, (dvoid *)&aI[7],(sb4)sizeof(GCIDateTime *), (ub2)SQLT_INTERVAL_DS,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto insertmultithreadtableEXIT;
    }

    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS);
    if(rc)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto insertmultithreadtableEXIT;
    }

    starown = 0;

    while(1)
    {
        ub4 rownum = 0;
		int i;
        sb4 year = 0;
        sb4 month = 0;
        sb4 day = 0;
        sb4 h;
        sb4 min;
        sb4 sec;
        sb4 frac;

        if ((rc = GCIStmtFetch(stmt, errhp, 1, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
        {
            fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
            rc = GCI_SUCCESS;
            goto insertmultithreadtableEXIT;
            break;
        }
        GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

        if(starown == rownum)
            break;
        if (rc == GCI_ERROR)
        {
            printf("+++++++++++++++++++\n",rc);
            goto insertmultithreadtableEXIT;;
        }

        GCIIntervalGetYearMonth(envhp, errhp, &year, &month, aI[0]);
        fprintf(stdout,"====interval %d-%d\n",year,month);
        GCIIntervalGetDaySecond(envhp, errhp, &day, &h,&min,&sec,&frac, aI[1]);
        fprintf(stdout,"====interva2 %d %d:%d:%d.f%d\n",day,h,min,sec,frac);

        GCIIntervalGetDaySecond(envhp, errhp, &day, &h,&min,&sec,&frac, aI[2]);
        fprintf(stdout,"====interva3 %d %d:%d:%d.f%d\n",day,h,min,sec,frac);

        GCIIntervalGetYearMonth(envhp, errhp, &year, &month, aI[3]);
        fprintf(stdout,"====interva4 %d-%d\n",year,month);

        GCIIntervalGetYearMonth(envhp, errhp, &year, &month, aI[4]);
        fprintf(stdout,"====interva5 %d-%d\n",year,month);

        GCIIntervalGetDaySecond(envhp, errhp, &day, &h,&min,&sec,&frac, aI[5]);
        fprintf(stdout,"====interva6 %d %d:%d:%d.f%d\n",day,h,min,sec,frac);

        GCIIntervalGetDaySecond(envhp, errhp, &day, &h,&min,&sec,&frac, aI[6]);
        fprintf(stdout,"====interva7 %d %d:%d:%d.f%d\n",day,h,min,sec,frac);

        GCIIntervalGetDaySecond(envhp, errhp, &day, &h,&min,&sec,&frac, aI[7]);
        fprintf(stdout,"====interva8 %d %d:%d:%d.f%d\n",day,h,min,sec,frac);


        fprintf(stdout,"==========================================\n");

        starown = rownum;
    }
#endif

    printf("select dtt recs\n");

insertmultithreadtableEXIT:
    if(pbuf)
        free(pbuf);

    for (loop=0;loop <8;loop++)
    {/*gcidatetime all */
        GCIDescriptorFree(aI[loop],GCI_DTYPE_INTERVAL_DS);
    }

    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}

/*
* This function allocates the row and collection buffers, passes
* them to the do_select_storebyxxx() function, along with an appropriate select
* statement and then frees all allocated handles.
*/
int main (long argc,
    char* argv[])
{
    ub4 i, in;

    ub1 verInfoBuffer[SELSQL_LEN];
    ub4 verInfoLen;
    ub1 majorVer[3];
    ub4 isUdoEnabled;
    int rc = 0;
    /* Handles */
    GCIEnv *envhp = NULL;
    GCISvcCtx *svchp = NULL;
    GCIError *errhp = NULL;
    GCIStmt *stmthp1 = NULL;
    GCIStmt *stmthp2 = NULL;
    int fd = 0;
	char dsc[30];
    GCIInterval *aI[9] = {0};
    //write to txt
    //test for 50w updates

    rc = logdb(&envhp,&errhp,&svchp);
    if(rc)
    {
        goto EXIT;
    }
    for (;;)
    {
#if 0
        rc = droptable(envhp,svchp,errhp,dropdtttable);
        rc = droptable(envhp,svchp,errhp,dropintervalable);
        rc = createtable(envhp,svchp,errhp,createdtttable);
        rc = createtable(envhp,svchp,errhp,createintervaltable);
        ///rc = droptable(envhp,svchp,errhp,dropbdtttable);
        //rc = createtable(envhp,svchp,errhp,createbdtttable);
        if(rc)
        {
            ub1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            fprintf (stdout, "insertdatconvert2table failure.\n");
            goto EXIT;
        }
        fprintf (stdout, "create table success.\n");
        rc = insertdtttablef(envhp,svchp,errhp);
        if(rc)
        {
            ub1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            fprintf (stdout, "insertdatconvert2table failure.\n");
            goto EXIT;
        }
        //rc = droptable(envhp,svchp,errhp,dropdtttable);
        rc = selectdtttable(envhp,svchp,errhp);
        if(rc)
        {
            fprintf (stdout, "selectdatconverttable failure.\n");
            goto EXIT;
        }


        rc = insertintervaltable(envhp,svchp,errhp);
        if(rc)
        {
            ub1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            fprintf (stdout, "insertdatconvert2table failure.\n");
            goto EXIT;
        }

        ///fprintf (stdout, "insertintervaltable test ++++++++++++++++++++.\n");
        rc = selectintervaltable(envhp,svchp,errhp);
        if(rc)
        {
            fprintf (stdout, "selectdatconverttable failure.\n");
            goto EXIT;
        }
#endif
#if 1
        rc = droptable(envhp,svchp,errhp,dropbdtttable);
        rc = createtable(envhp,svchp,errhp,createbdtttable);
        fprintf (stdout, "insertbdtt test ++++++++++++++++++++.\n");
        rc = insertbdtttablef(envhp,svchp,errhp);
        if(rc)
        {
            ub1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            fprintf (stdout, "insertbdtttablef failure.\n");
            goto EXIT;
        }


        fprintf (stdout, "selectbdtt test ++++++++++++++++++++.\n");
        rc = selectbdtttable(envhp,svchp,errhp);
        if(rc)
        {
            fprintf (stdout, "selectdatconverttable failure.\n");
            goto EXIT;
        }
        fprintf (stdout, "insertbdtttablefbyrow test ++++++++++++++++++++.\n");
        rc = insertbdtttablefbyrow(envhp,svchp,errhp);
        if(rc)
        {
            ub1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            fprintf (stdout, "insertdatconvert2table failure.\n");
            goto EXIT;
        }
        rc = selectbdtttablebyrow(envhp,svchp,errhp);
        if(rc)
        {
            fprintf (stdout, "selectbdtttablebyrow failure.\n");
            goto EXIT;
        }
        fprintf (stdout, "selectdtttable test ++++++++++++++++++++.\n");
#endif
        rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[0] , GCI_DTYPE_INTERVAL_YM, 0, NULL);
        if (rc)
        {
            fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
            goto EXIT;
        }
        rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[1] , GCI_DTYPE_INTERVAL_DS, 0, NULL);
        if (rc)
        {
            fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
            goto EXIT;
        }
        rc = GCIDescriptorAlloc(envhp,(dvoid **)&aI[2] , GCI_DTYPE_INTERVAL_DS, 0, NULL);
        if (rc)
        {
            fprintf(stdout, "type %d\nExiting!!\n",GCI_DTYPE_DATE);
            goto EXIT;
        }

        sprintf(dsc,"%4d %02d:%02d:%02d",223,2,2,2);

        rc = GCIIntervalFromText(svchp, errhp, (const GCIText *)"2-9",strlen("2-9"), aI[0]);
        rc = GCIIntervalFromText(svchp, errhp, (const GCIText *)"22 11:11:11.000",strlen("22 11:11:11.000"), aI[1]);
        rc = GCIIntervalFromText(svchp, errhp, (const GCIText *)dsc,strlen(dsc), aI[2]);

        rc = GCIIntervalFromText(svchp, errhp, (const GCIText *)"222-9",strlen("222-9"), aI[0]);
        rc = GCIIntervalFromText(svchp, errhp, (const GCIText *)"22 11:11:11. 000",strlen("22 11:11:11. 000"), aI[1]);
        rc = GCIIntervalFromText(svchp, errhp, (const GCIText *)dsc,strlen(dsc), aI[2]);

        GCIDescriptorFree(aI[0],GCI_DTYPE_INTERVAL_YM);
        GCIDescriptorFree(aI[1],GCI_DTYPE_INTERVAL_DS);
        GCIDescriptorFree(aI[2],GCI_DTYPE_INTERVAL_DS);
    }

    fprintf (stdout,"\nHit <Enter> to continue...");
    in = getchar ();

EXIT:

    /* CLEANUP: Close the statement handle
    **          Free the statement handle
    **          Disconnect from the datasource
    **          Free the connection and environment handles
    **          Exit
    */
    if(stmthp1)
        GCIHandleFree((dvoid *)stmthp1, GCI_HTYPE_STMT);

    if(stmthp2)
        GCIHandleFree((dvoid *)stmthp2, GCI_HTYPE_STMT);

    GCILogoff(svchp, errhp);

    if(svchp)
        GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);

    if(errhp)
        GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

    if(envhp)
        GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);


    fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
    in = getchar ();

    return (rc);
}