#include "gci.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <errno.h>

#include <fcntl.h>
#define SQLMSG 			sb1 errmsg[256] = {0}, errstate[256] = {0};\
		sb4 errcode;\
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);\
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);		\
		     printf("GCIStmtExecute  merge failed!\n\n");

#define SELSQL_LEN     25
#define ERRMSG_LEN     200

//char *createmultidatasql = "create table millionupdate(data_id bigint primary key,data_0_0 int,data_0_1 int)";
char * selectSql="select data_id,data_0_0 from gci_demodb:gbasedbt.millionupdate where gci_demodb:gbasedbt.millionupdate.data_0_0<:1 and  gci_demodb:gbasedbt.millionupdate.data_0_0>:2";

sb2 aInd[100];
sb2 aInd1[100];
	
int logdb(GCIEnv **envhp1,GCIError **errhp1,GCISvcCtx **svchp1)
{
	int rc = GCI_SUCCESS;
	
	///connect db
	GCIEnv *envhp= NULL;
	GCISvcCtx *svchp= NULL;
	GCIError *errhp = NULL;
	GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";

	/*  STEP 1. Get data source name from command line (or use default)
	 **          Allocate the environment handle and set ODBC version
	 **          Allocate the connection handle
	 **          Establish the database connection
	 **          Allocate the statement handle
	 **          Drop demo database if it already exists
	 */
	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
				0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}

	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
				GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}	

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
				GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}
	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
				pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto logdbEXIT;
	}
	*envhp1 = envhp;
	*errhp1 = errhp;
	*svchp1 = svchp;


	fprintf (stdout, "Step 1 done...connected to database.\n");

logdbEXIT:
	return rc;
}

int selectMillionByCol(GCISvcCtx *svchp,GCIStmt *stmthp,GCIError *errhp)
{
    int rc =0;
	int i=0;
	const int  MILLIONRECORDS = 100;
	
	sb8 * dataid = (sb8 *)malloc(sizeof(sb8) * MILLIONRECORDS);
	sb4 * data00 = (sb4 *)malloc(sizeof(sb4) * MILLIONRECORDS);
	GCIDefine *bndhp[2];
	sb4 starown;

	memset(dataid, 0, sizeof(sb8) * MILLIONRECORDS);
	memset(data00, 0, sizeof(sb4) * MILLIONRECORDS);
	if (rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)dataid, (sb4)sizeof(sb8), (ub2)SQLT_INT,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
	    printf("GCIDefineByPos 1 failed. rc=%d \n",rc);
	    return rc;
	}
	
    if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 2, (dvoid *)data00, (sb4)sizeof(sb4), (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
	    printf("GCIDefineByPos 2 failed. rc=%d \n",rc);
        return rc;
    }
	
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_DEFAULT) != GCI_SUCCESS)
	{
	    printf("GCIStmtExecute  failed. rc=%d \n",rc);
        return rc;
	}
	
    starown = 0;

	while(1) 
	{
		ub4 rownum = 0;

		if ((rc = GCIStmtFetch(stmthp, errhp, MILLIONRECORDS, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep Da jlaksjdf done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			break;
		}
		rc = GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		printf("rownum %d\n",rownum);
		if((-1 == rownum )||(starown == rownum))
			break;
			
		for( i=0; i<rownum; i++)
		{	
			if(i%5000==0)
			    printf("row number：%d  data_id: %ld  data_0_0: %d \n",i,*(sb8*)(dataid + i),*(data00+i));
		}
		
		starown = rownum;
	}
	
	free(dataid);
	free(data00);
	return rc;
}


int selectMillionByRow(GCISvcCtx *svchp,GCIStmt *stmthp,GCIError *errhp)
{
    int rc =0;
	int i=0;
	const int  MILLIONRECORDS = 100;
	
	int rowsize = sizeof(sb8) + sizeof(sb4);
	sb1 *buff = (sb1 *)malloc(rowsize * MILLIONRECORDS);
	
	sb8 * dataid = (sb8 *)buff;
	sb4 * data00 = (sb4 *)((sb1 *)dataid+sizeof(sb8));
	GCIDefine *bndhp[2];
	sb4 starown;

    memset(buff, 0, rowsize * MILLIONRECORDS); 
	if (rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)dataid, (sb4)sizeof(sb8), (ub2)SQLT_INT,
			(dvoid *)aInd, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
	    printf("GCIDefineByPos 1 failed. rc=%d \n",rc);
	    return rc;
	}
	
    if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 2, (dvoid *)data00, (sb4)sizeof(sb4), (ub2)SQLT_INT,
				(dvoid *)aInd1, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
	    printf("GCIDefineByPos 2 failed. rc=%d \n",rc);
        return rc;
    }
	
	//ArrayOfStruct
	if (rc = GCIDefineArrayOfStruct(bndhp[0], errhp, rowsize, 0, 0, 0) != GCI_SUCCESS)
	{
	    printf("GCIDefineArrayOfStruct 1 failed. rc=%d \n",rc);
        return rc;	    
	}
	
	if (rc = GCIDefineArrayOfStruct(bndhp[1], errhp, rowsize, 0, 0, 0) != GCI_SUCCESS)
	{
	    printf("GCIDefineArrayOfStruct 2 failed. rc=%d \n",rc);
        return rc;	    
	}
	
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_DEFAULT) != GCI_SUCCESS)
	{
	    printf("GCIStmtExecute  failed. rc=%d \n",rc);
        return rc;
	}

	starown = 0;
	
	while(1) 
	{
		ub4 rownum = 0;
		if ((rc = GCIStmtFetch(stmthp, errhp, MILLIONRECORDS, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep Da jlaksjdf done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			break;
		}
		
		GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(starown == rownum)
			break;

		for(i=0; i<rownum; i++)
		{	
			if(i%1==0)
			    printf("row number：%d  data_id: %ld  data_0_0: %d \n",i,*(sb8 *)((sb1*)dataid + i*rowsize),*(sb4*)((sb1*)data00+i*rowsize));
			
		}

		starown = rownum;
	}
	
	free(buff);
	
	return rc;
}
int main(long argc,char* argv[])
{
    /* Declare varia[]bles */

	ub4			i, in;

	ub1         verInfoBuffer[SELSQL_LEN];
	ub4			verInfoLen;
	ub1         majorVer[3];
	ub4      	isUdoEnabled;
	int rc = 0;
	/* Handles */
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;
	GCIStmt *stmthp = NULL;
	char *pbuf=NULL;
	GCIBind * bndhp[2];

	rc = logdb(&envhp,&errhp,&svchp);
	if(rc)
	{
	    printf("logdb failed. rc=%d \n",rc);
		return rc;
	}
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		printf("GCIHandleAlloc failed. rc=%d \n",rc);
		return rc;
	}
	
	if(rc = GCIStmtPrepare(stmthp, errhp, (GCIText *)selectSql, sizeof(selectSql), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{	
	    printf("GCIStmtPrepare failed. rc=%d \n",rc);
		return rc;
	}
	
	////TODO::绑定参数变量
	
	pbuf=NULL;
	pbuf = (char *)malloc(sizeof(int)+sizeof(int));
	*(int *)(pbuf) = 80005;
	*(int *)(pbuf+sizeof(int))=80000;
	
	GCIBindByPos(stmthp, &bndhp[0], errhp, 1,
		(dvoid *) pbuf, sizeof(int), SQLT_INT,
		(dvoid *) 0, (ub2 *)0, (ub2 *)0,
		(ub4) 0, (ub4 *) 0, (ub4) GCI_DEFAULT);
	
	GCIBindByPos(stmthp, &bndhp[1], errhp, 2,
		(dvoid *)(pbuf+sizeof(int)), sizeof(int), SQLT_INT,
		(dvoid *) 0, (ub2 *)0, (ub2 *)0,
		(ub4) 0, (ub4 *) 0, (ub4) GCI_DEFAULT);
		
//	GCIBindArrayOfStruct(bndhp[0],errhp, 8, 0, 0, 0);
//	GCIBindArrayOfStruct(bndhp[1],errhp, 8, 0, 0, 0);
	
	
    //rc=selectMillionByCol(svchp,stmthp,errhp);
    rc=selectMillionByRow(svchp,stmthp,errhp);
	
	
	if(stmthp)
		GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
	
	GCILogoff(svchp, errhp);

	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);

	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);
	
     return 0;
}