/***************************************************************************
* *       Licensed Materials - Property of GBase
* *
* *
* *       "Restricted Materials of GBase"
* *
* *
* *
* *       GBase 8s GCI Interface demo
* *
* *
* *       (C) Copyright GBase Corporation 2015 All rights reserved.
* *
* *
* *
* *
* *
* *  Title:          test_dirpath.c
* *
* *  Description:    Test the Dirpath Function of the Interface.
* *
* *
* ***************************************************************************
* */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gci.h"

#define MAXCOL 5
#define MAXROW 5
#define ROWBATCH 5

typedef struct _ColAttr_t
{
    ub4 data_offset;
    ub4 data_size;
    char *col_name;
    ub4 data_type;
    int *indp;
}ColAttr_t;

#define BUFF__LEN 200
#define BYTE__LEN 100
typedef struct
{
    long order_num;
    int cust_num;
    char order_date[BUFF__LEN];
    char order_byte[BYTE__LEN];
    int item_num;
    char order_char[2];
}orderStruct;


int do_select_storebycol(GCISvcCtx *svchp,
    GCIStmt *stmthp,
    GCIError *errhp)
{
    int rc = 0;

    sb8 *ordernum = (sb8 *)malloc(sizeof(sb8) * 100);
    sb4 *custnum = (sb4 *)malloc(sizeof(sb4) * 100);
    sb1 *order_byte = (sb1 *)malloc(BYTE__LEN * 100);
    sb1 *order_date = (sb1 *)malloc(BUFF__LEN * 100);
    GCIDefine *bndhp[4];
	sb4 starown;

    memset(ordernum, 0, sizeof(sb8) * 100);
    memset(custnum, 0, sizeof(sb4) * 100);
    memset(order_byte, 0,BYTE__LEN * 100);
    memset(order_date, 0,BUFF__LEN * 100);
    if (rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)ordernum, (sb4)sizeof(sb8), (ub2)SQLT_INT,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 1 failed.\nExiting!!\n");
        goto EXIT;
    }

    if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 2, (dvoid *)custnum, (sb4)sizeof(sb4), (ub2)SQLT_INT,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
        goto EXIT;
    }
    if (rc = GCIDefineByPos(stmthp, &bndhp[2], errhp, 3, (dvoid *)order_date, (sb4)BUFF__LEN, (ub2)SQLT_CHR,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
        goto EXIT;
    }
    if (rc = GCIDefineByPos(stmthp, &bndhp[3], errhp, 4, (dvoid *)order_byte, (sb4)BYTE__LEN, (ub2)SQLT_BIN,
        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
        goto EXIT;
    }

    fprintf (stdout, "\tStep A done...GCIDefineByPos: Define handle by pos success.\n");
    /*
    if (rc = GCIDefineArrayOfStruct(bndhp[0], errhp, 2*sizeof(sb4)+, 0, 0, 0) != GCI_SUCCESS)
    {
    fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 1 failed.\nExiting!!\n");
    goto EXIT;
    }

    if (rc = GCIDefineArrayOfStruct(bndhp[1], errhp, 2*sizeof(sb4), 0, 0, 0) != GCI_SUCCESS)
    {
    fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 2 failed.\nExiting!!\n");
    goto EXIT;
    }
    if (rc = GCIDefineArrayOfStruct(bndhp[1], errhp, 2*sizeof(sb4), 0, 0, 0) != GCI_SUCCESS)
    {
    fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct 2 failed.\nExiting!!\n");
    goto EXIT;
    }
    */
    fprintf (stdout, "\tStep B done...GCIDefineArrayOfStruct: Define array of struct success.\n");

    if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_DEFAULT) != GCI_SUCCESS)
    {
        fprintf(stdout, "\tError in Step C -- GCIStmtExecute: execute select statement failed.\nExiting!!\n");
        goto EXIT;
    }

    fprintf (stdout, "\tStep C done...GCIStmtExecute: Execute select statement success.\n");

    starown = 0;

    while(1)
    {
        ub4 rownum = 0;
		int i,j;
        if (rc = GCIStmtFetch(stmthp, errhp, 100, GCI_FETCH_NEXT, 0) == GCI_NO_DATA)
        {
            fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
            rc = GCI_SUCCESS;
            goto SUCCESS_EXIT;
            break;
        }
        GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);

        if(starown == rownum)
            break;

        for(i=0; i<rownum; i++)
        {
            fprintf(stdout, "\tRetrieving row number %d:\n", i + 1);
            fprintf(stdout, "\t\torder_num -- %ld\n", *(ordernum + i));
            fprintf(stdout, "\t\tcustom_num -- %d\n",*(custnum + i));
            fprintf(stdout, "\t\torder_date -- %s\n",(order_date + i*BUFF__LEN));
            fprintf(stdout, "\t\torder_byte -- \n");
            j = 0;
            for(j =0;j < BYTE__LEN;j++)
            {
                fprintf(stdout, "%d ",order_byte[j+i*BYTE__LEN]);
            }
            fprintf(stdout, "\n ");
        }
        starown = rownum;
    }


SUCCESS_EXIT:

    fprintf (stdout, "\tStep D done...GCIStmtFetch: Retrieve the results success.\n");

EXIT:
    free(ordernum);
    free(custnum);
    free(order_byte);

    return rc; /* no error */
}

//set the offset of the buffer
void InitColOffset(ColAttr_t *col, ub2 cols, ub4 *record_size)
{
    ub4 offset = 0;
    int i;

    for(i=0; i<cols; i++)
    {
        col[i].data_offset = offset;
        offset += col[i].data_size;
    }
    *record_size = offset;
}

//set the attribution of the dirpathctx
sword SetTableInfo(GCIDirPathCtx * dpctx,
    const char *tableName,
    sb4 colNum, ub1 inputType,
    const char *schema,
    const char *dateMask,
    GCIError *errhp,
    ColAttr_t *col)

{
    int rc = GCI_SUCCESS;
    GCIParam *colDesc;
    int i = 0, pos;
    ub4 buf_size;
    ub2 dtype = SQLT_CHR;
    GCIParam *colLstDesc;

    fprintf(stdout, "\n!!!Begin set the attribution of the dirpathctx handle.\n");

    if(rc = GCIAttrSet(dpctx, GCI_HTYPE_DIRPATH_CTX, (dvoid *)tableName,
        strlen(tableName), GCI_ATTR_NAME, errhp) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIAttrSet: set table name failed.\nExiting!!\n");
        goto EXIT1;
    }

    if(rc = GCIAttrSet(dpctx, GCI_HTYPE_DIRPATH_CTX, (dvoid *)&colNum,
        0,GCI_ATTR_NUM_COLS,errhp) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIAttrSet: set collumn number failed.\nExiting!!\n");
        goto EXIT1;
    }

    if(schema && strlen(schema) != 0)
    {
        if(rc = GCIAttrSet(dpctx, GCI_HTYPE_DIRPATH_CTX, (dvoid *)schema,
            strlen(schema), GCI_ATTR_SCHEMA_NAME, errhp) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 3 -- GCIAttrSet: set schema name failed.\nExiting!!\n");
            goto EXIT1;
        }
    }

    if(rc = GCIAttrSet(dpctx, GCI_HTYPE_DIRPATH_CTX, (dvoid *)dateMask,
        strlen(dateMask), GCI_ATTR_DATEFORMAT, errhp) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIAttrSet: set data format failed.\nExiting!!\n");
        goto EXIT1;
    }

    if(rc = GCIAttrSet(dpctx, GCI_HTYPE_DIRPATH_CTX, (dvoid *)&inputType,
        0, GCI_ATTR_DIRPATH_INPUT, errhp) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIAttrSet: set input type failed.\nExiting!!\n");
        goto EXIT1;
    }

    if(rc = GCIAttrGet(dpctx, GCI_HTYPE_DIRPATH_CTX, (dvoid *)&colLstDesc,
        0, GCI_ATTR_LIST_COLUMNS, errhp) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIAttrGet: get the parameter list of column failed.\nExiting!!\n");
        goto EXIT1;
    }

    for(i = 0, pos = 1; i<colNum; i++, pos++)
    {
        if(rc = GCIParamGet(colLstDesc, GCI_DTYPE_PARAM, errhp,
            (dvoid **)&colDesc, pos) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 3 -- GCIAttrGet: get the parameter list of column failed.\nExiting!!\n");
            goto EXIT1;
        }

        if(rc = GCIAttrSet(colDesc, GCI_DTYPE_PARAM, col[i].col_name,
            strlen(col[i].col_name), GCI_ATTR_NAME, errhp) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 3 -- GCIAttrSet: set column name in the descriptor failed.\nExiting!!\n");
            goto EXIT1;
        }

        if(inputType == GCI_DIRPATH_INPUT_STREAM)
        {
            if(rc = GCIAttrSet(colDesc, GCI_DTYPE_PARAM, (dvoid *)&col[i].data_type,
                0, GCI_ATTR_DATA_TYPE, errhp) != GCI_SUCCESS)
            {
                fprintf(stdout, "Error in Step 3 -- GCIAttrSet: set data type in the descriptor failed.\nExiting!!\n");
                goto EXIT1;
            }
        }
        else
        {
            if(rc =  GCIAttrSet(colDesc, GCI_DTYPE_PARAM, (dvoid *)&dtype,
                0, GCI_ATTR_DATA_TYPE, errhp))
            {
                fprintf(stdout, "Error in Step 3 -- GCIAttrSet: set data type in the descriptor failed.\nExiting!!\n");
                goto EXIT1;
            }
        }

        if(rc = GCIAttrSet(colDesc, GCI_DTYPE_PARAM, (dvoid *)&col[i].data_size,
            0, GCI_ATTR_DATA_SIZE, errhp) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 3 -- GCIAttrSet: set data size in the descriptorfailed.\nExiting!!\n");
            goto EXIT1;
        }

        GCIDescriptorFree(colDesc, GCI_DTYPE_PARAM);
    }

    buf_size = 1*5048;

    if(rc = GCIAttrSet(dpctx, GCI_HTYPE_DIRPATH_CTX, (dvoid *)&buf_size,
        0, GCI_ATTR_BUF_SIZE, errhp) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIAttrSet: set buffer size in the desciptor failed.\nExiting!!\n");
        goto EXIT1;
    }

EXIT1:

    colLstDesc = NULL;

    return rc;
}

int dirploadmulti(GCIDirPathCtx *pCtx,GCIDirPathColArray *parray,GCIDirPathStream*pstr,GCIError *errhp,ColAttr_t *col,int num)
{
    int rc = 0;
    int rowoff = 0;
    orderStruct orders[MAXROW];
    int loop1 = 0;
    int rowindex = 0;
    int nrows = 0;

    if(rc = GCIAttrGet(parray, GCI_HTYPE_DIRPATH_COLUMN_ARRAY,
        (dvoid *)&nrows, 0, GCI_ATTR_NUM_ROWS, errhp) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIAttrGet: get the number of rows in the column array failed.\nExiting!!\n");
        goto EXIT;
    }


    if(rc = GCIDirPathColArrayReset(parray, errhp) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 4 -- GCIDirPathColArrayReset: reset the column array failed.\nExting!!\n");
        goto EXIT;
    }

    if(rc = GCIDirPathStreamReset(pstr, errhp) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 4 -- GCIDirPathStreamReset: reset the stream failed.\nExiting!!\n");
        goto EXIT;
    }    

    for(rowoff=0; rowoff<num; rowoff++)
    {
        orders[rowoff].order_num = num + 900+rowoff;
        orders[rowoff].cust_num = num + 100+rowoff;
        strcpy(orders[rowoff].order_date,"01/31/2023");
        orders[rowoff].item_num = 1003;
        for(loop1 = 0;loop1 < BYTE__LEN;loop1++)
        {
            orders[rowoff].order_byte[loop1] = rowoff + 2 + num;
        }
    }
    if (nrows >= num)
        nrows = num;

    while(1)
    {
        if(rc = GCIAttrGet(parray, GCI_HTYPE_DIRPATH_COLUMN_ARRAY,
            (dvoid *)&rowindex, 0, GCI_ATTR_ROW_COUNT, errhp) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 3 -- GCIAttrGet: get the number of rows in the column array failed.\nExiting!!\n");
            goto EXIT;
        }
        if(rowindex  >= num)
        {
            break;
        }

        for(rowoff = rowindex; (rowoff < (rowindex + ROWBATCH))&&(rowoff < nrows); rowoff++)
        {
            if(rc = GCIDirPathColArrayEntrySet(parray, errhp, rowoff, 0,
                (void *)&(orders[rowoff].order_num),
                col[0].data_size,
                GCI_DIRPATH_COL_COMPLETE) != GCI_SUCCESS)
            {
                fprintf(stdout, "Error in Step 4 -- GCIDirPathcolArrayEntrySet: set the first column value failed.\nExiting!!\n");
                goto EXIT;
            }

            if(rc = GCIDirPathColArrayEntrySet(parray, errhp, rowoff, 1,
                (void *)&(orders[rowoff].cust_num),
                col[1].data_size,
                GCI_DIRPATH_COL_NULL) != GCI_SUCCESS)
            {
                fprintf(stdout, "Error in Step 4 -- GCIDirPathcolArrayEntrySet: set the second column value failed.\nExiting!!\n");
                goto EXIT;
            }
            if(rc = GCIDirPathColArrayEntrySet(parray, errhp, rowoff, 2,
                (void *)(orders[rowoff].order_date),
                col[2].data_size,
                GCI_DIRPATH_COL_COMPLETE) != GCI_SUCCESS)
            {
                fprintf(stdout, "Error in Step 4 -- GCIDirPathcolArrayEntrySet: set the second column value failed.\nExiting!!\n");
                goto EXIT;
            }
            if(rc = GCIDirPathColArrayEntrySet(parray, errhp, rowoff,3,
                (void *)&(orders[rowoff].item_num),
                col[3].data_size,
                GCI_DIRPATH_COL_NULL) != GCI_SUCCESS)
            {
                fprintf(stdout, "Error in Step 4 -- GCIDirPathcolArrayEntrySet: set the second column value failed.\nExiting!!\n");
                goto EXIT;
            }
            if(rc = GCIDirPathColArrayEntrySet(parray, errhp, rowoff,4,
                (void *)(orders[rowoff].order_byte),
                col[4].data_size,
                GCI_DIRPATH_COL_NULL) != GCI_SUCCESS)
            {
                fprintf(stdout, "Error in Step 4 -- GCIDirPathcolArrayEntrySet: set the second column value failed.\nExiting!!\n");
                goto EXIT;
            }
        }

        if ((rc = GCIDirPathColArrayToStream(parray, pCtx, pstr, errhp, num, 0)) == GCI_NEED_DATA)
        {
            continue;
        }
        else if (rc == GCI_ERROR)
        {

            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            fprintf(stdout, "Error in Step 4 -- GCIDirPathColArrayToStream: transfer the collumn array to stream failed.\nExiting!!\n");
            goto EXIT;
        }
        else if (rc == GCI_SUCCESS)
        {
            break;
        }
    }

    if ((rc = GCIDirPathLoadStream(pCtx, pstr, errhp))  == GCI_NEED_DATA)
    {
        printf("GCIDirPathLoadStream need data!\n");
    }
    else if (rc == GCI_ERROR)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        fprintf(stdout, "Error in Step 4 -- GCIDirPathLoadStream: load the stream failed.\nExiting!!\n");
        goto EXIT;
    }    

    if(rc = GCIDirPathDataSave(pCtx, errhp, GCI_DIRPATH_DATASAVE_FINISH) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 4 -- GCIDirPathDataSave: save data failed.\nExiting!!\n");
        goto EXIT;
    }

    if(rc = GCIDirPathFinish(pCtx, errhp) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 4 -- GCIDirPathFinish: finish the dirpath failed.\nExiting!!\n");
        goto EXIT;
    }

EXIT :

    return rc;
}
int main(long argc,
    char* argv[])
{
    GCItext *tablename = (GCItext*)"dir_path";
    GCItext *schema = "";
    GCItext *datemask = (GCItext*)"yyyy-mm-dd";
    sb4 colnum = MAXCOL;
    ub4 in;
    ub4 nrows= 0;
    ub4 rows=5;
    ub4 rows_temp;
    ub4 rows_pre=0;
    ub4 rowoff, coloff;
    orderStruct orders[MAXROW];
    ColAttr_t col[6];
    ub1         sqlStmt[1000] = {0};

    /*DirPath handle*/
    GCIDirPathCtx * dpctx = NULL;
    GCIDirPathColArray * dpca = NULL;
    GCIDirPathStream * dpstr = NULL;
    //GCIParam * coldesc;

    /* Handles */
    GCIEnv *envhp = NULL;
    GCISvcCtx *svchp = NULL;
    GCIError *errhp = NULL;
    GCIStmt *stmthp = NULL;
    int rc = GCI_SUCCESS;
    GCItext *dbname = (GCItext*)"gci_demodb";
    GCItext *user = (GCItext*)"gbasedbt";
    GCItext *pswd = (GCItext*)"Big4ifmx";
	int colNumAll;
    int loop1;
    /*  STEP 1. Get data source name from command line (or use default)
    **          Allocate the environment handle and set ODBC version
    **          Allocate the connection handle
    **          Establish the database connection
    **          Allocate the statement handle
    **          Drop demo database if it already exists
    */

    /* initialize the mode to be the threaded and object environment */
    if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
        0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
        goto EXIT;
    }

    /* allocate an error handle */
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
        GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
        goto EXIT;
    }

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
        GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
        goto EXIT;
    }

    if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
        pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
        goto EXIT;
    }

    fprintf (stdout, "Step 1 done...connected to database.\n");

    fprintf (stdout, "\n!!!Begin SELECT and retrieve RAW results stored by row buffer.\n");

#if 1
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 2 -- GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
        goto EXIT;
    }

    memset(sqlStmt, 0, 1000);
    sprintf(sqlStmt, "SELECT order_num, cust_num FROM dir_path");

    if(rc = GCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
        goto EXIT;
    }

    /* Retrieve databse rows containing a list */
    if (do_select_storebycol (svchp, stmthp, errhp))
    {
        fprintf (stdout, "Error in Step 2...select and retrieve results failed.\nExiting!!\n");
        goto EXIT;
    }

    fprintf (stdout, "Step 2 done...select and retrieve results success.\n");

    GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);

#endif

    /* STEP 3. Allocate the dirpath related handle
    **         Set the attribute of the handle
    **         Get the attribute of the handle
    **         Set the data into the buffer
    **         Write the buffer into the table
    */

    fprintf(stdout, "\n!!!Begin DirPath function and save the data into the talble.\n");
    col[0].data_offset = sizeof(sb8);
    col[0].data_size = sizeof(sb8);
    col[0].col_name = "order_num";
    col[0].data_type = SQLT_INT;

    col[1].data_offset = sizeof(sb4);
    col[1].data_size = sizeof(sb4);
    col[1].col_name = "cust_num";
    col[1].data_type = SQLT_INT;

    col[2].data_offset = BUFF__LEN;
    col[2].data_size = BUFF__LEN;
    col[2].col_name = "order_date";
    col[2].data_type = SQLT_CHR;

    col[3].data_offset = sizeof(sb4);;
    col[3].data_size = sizeof(sb4);;
    col[3].col_name = "item_num";
    col[3].data_type = SQLT_INT;

    col[4].data_offset = BYTE__LEN;
    col[4].data_size = BYTE__LEN;
    col[4].col_name = "order_byte";
    col[4].data_type = SQLT_BIN;

    col[5].data_offset = 2;
    col[5].data_size = 2;
    col[5].col_name = "order_char";
    col[5].data_type = SQLT_CHR;
    colNumAll = 6;
    loop1 = 0;

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&dpctx,
        (ub4)GCI_HTYPE_DIRPATH_CTX, (size_t)0, (dvoid **)0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIHandleAlloc: allocate dirpathctx handle failed.\nExiting!!\n");
        goto EXIT;
    }

    if(rc = SetTableInfo(dpctx, tablename, colNumAll, GCI_DIRPATH_INPUT_STREAM,
        schema, datemask, errhp, col) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIAttrSet: set the attribution of the dirpathctx handle failed.\nExiting!!\n");
        goto EXIT;
    }

    if(rc = GCIDirPathPrepare(dpctx, svchp, errhp) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIDirPathPrepare: prepare the dirpathctx handle failed.\nExiting!!\n");
        goto EXIT;
    }

    if(rc = GCIHandleAlloc((dvoid *)dpctx, (dvoid **)&dpca, GCI_HTYPE_DIRPATH_COLUMN_ARRAY,
        (size_t)0, (dvoid **)0) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        fprintf(stdout, "Error in Step 4 -- GCIDirPathColArrayToStream: transfer the collumn array to stream failed.\nExiting!!\n");

        fprintf(stdout, "Error in Step 3 -- GCIHandleAlloc: allocate the column array handle failed.\nExiting!!\n");
        goto EXIT;
    }

    if(rc = GCIHandleAlloc(dpctx, (dvoid **)&dpstr, GCI_HTYPE_DIRPATH_STREAM,
        (size_t)0, (dvoid **)0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIHandleAlloc: allocate the stream handle failed.\nExiting!!\n");
        goto EXIT;
    }

    if(rc = GCIAttrGet(dpca, GCI_HTYPE_DIRPATH_COLUMN_ARRAY,
        (dvoid *)&nrows, 0, GCI_ATTR_NUM_ROWS, errhp) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIAttrGet: get the number of rows in the column array failed.\nExiting!!\n");
        goto EXIT;
    }

    fprintf(stdout, "Step 3 done...set the table info success.\n");

    /*STEP 4. Set the values of the orders array for the new rows to be inserted
    **        Bind the orders array to dirpath column array
    */
    for(rowoff=0; rowoff<MAXROW; rowoff++)
    {
        orders[rowoff].order_num = 10000000000900+rowoff;
        orders[rowoff].cust_num = 101+rowoff;
        strcpy(orders[rowoff].order_date,"01/31/2023");
        orders[rowoff].item_num = 1003;
        for(loop1 = 0;loop1 < BYTE__LEN;loop1++)
        {
            orders[rowoff].order_byte[loop1] = rowoff + 2;
        }
        strcpy(orders[rowoff].order_char,"a");
    }

    while(rows)
    {
        if(rows > nrows)
        {
            rows_temp = nrows;
            rows -= nrows;
        }
        else
        {
            rows_temp = rows;
            rows = 0;
        }

        if(rc = GCIDirPathColArrayReset(dpca, errhp) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 4 -- GCIDirPathColArrayReset: reset the column array failed.\nExting!!\n");
            goto EXIT;
        }

        if(rc = GCIDirPathStreamReset(dpstr, errhp) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 4 -- GCIDirPathStreamReset: reset the stream failed.\nExiting!!\n");
            goto EXIT;
        }
        printf("rows_temp %d,%d\n",rows_temp,nrows);

        for(rowoff = 0; rowoff < rows_temp; rowoff++)
        {
            if(rc = GCIDirPathColArrayEntrySet(dpca, errhp, rowoff, 0,
                (void *)&(orders[rowoff+rows_pre].order_num),
                col[0].data_size,
                GCI_DIRPATH_COL_COMPLETE) != GCI_SUCCESS)
            {
                fprintf(stdout, "Error in Step 4 -- GCIDirPathcolArrayEntrySet: set the first column value failed.\nExiting!!\n");
                goto EXIT;
            }

            if(rc = GCIDirPathColArrayEntrySet(dpca, errhp, rowoff, 1,
                (void *)&(orders[rowoff+rows_pre].cust_num),
                col[1].data_size,
                GCI_DIRPATH_COL_COMPLETE) != GCI_SUCCESS)
            {
                fprintf(stdout, "Error in Step 4 -- GCIDirPathcolArrayEntrySet: set the second column value failed.\nExiting!!\n");
                goto EXIT;
            }
            if(rc = GCIDirPathColArrayEntrySet(dpca, errhp, rowoff, 2,
                (void *)(orders[rowoff+rows_pre].order_date),
                col[2].data_size,
                GCI_DIRPATH_COL_COMPLETE) != GCI_SUCCESS)
            {
                fprintf(stdout, "Error in Step 4 -- GCIDirPathcolArrayEntrySet: set the second column value failed.\nExiting!!\n");
                goto EXIT;
            }
            if(rc = GCIDirPathColArrayEntrySet(dpca, errhp, rowoff,3,
                (void *)&(orders[rowoff+rows_pre].item_num),
                col[3].data_size,
                GCI_DIRPATH_COL_COMPLETE) != GCI_SUCCESS)
            {
                fprintf(stdout, "Error in Step 4 -- GCIDirPathcolArrayEntrySet: set the second column value failed.\nExiting!!\n");
                goto EXIT;
            }
            if(rc = GCIDirPathColArrayEntrySet(dpca, errhp, rowoff,4,
                (void *)(orders[rowoff+rows_pre].order_byte),
                col[4].data_size,
                GCI_DIRPATH_COL_COMPLETE) != GCI_SUCCESS)
            {
                fprintf(stdout, "Error in Step 4 -- GCIDirPathcolArrayEntrySet: set the second column value failed.\nExiting!!\n");
                goto EXIT;
            }
            if(rc = GCIDirPathColArrayEntrySet(dpca, errhp, rowoff,5,
                (void *)(orders[rowoff+rows_pre].order_char),
                col[5].data_size,
                GCI_DIRPATH_COL_COMPLETE) != GCI_SUCCESS)
            {
                fprintf(stdout, "Error in Step 4 -- GCIDirPathcolArrayEntrySet: set the second column value failed.\nExiting!!\n");
                goto EXIT;
            }
        }

        if(rc = GCIDirPathColArrayToStream(dpca, dpctx, dpstr, errhp, rows_temp, 0)!= GCI_NEED_DATA)
        {

        }
        else if (rc == GCI_ERROR)
        {

            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            fprintf(stdout, "Error in Step 4 -- GCIDirPathColArrayToStream: transfer the collumn array to stream failed.\nExiting!!\n");
            goto EXIT;
        }
        rows_pre += rows_temp;

        if(rc = GCIDirPathLoadStream(dpctx, dpstr, errhp) != GCI_NEED_DATA)
        {

        }
        else if (rc == GCI_ERROR)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 1, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            fprintf(stdout, "Error in Step 4 -- GCIDirPathLoadStream: load the stream failed.\nExiting!!\n");
            goto EXIT;
        }
    }

    if(rc = GCIDirPathDataSave(dpctx, errhp, GCI_DIRPATH_DATASAVE_FINISH) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 4 -- GCIDirPathDataSave: save data failed.\nExiting!!\n");
        goto EXIT;
    }

    if(rc = GCIDirPathFinish(dpctx, errhp) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 4 -- GCIDirPathFinish: finish the dirpath failed.\nExiting!!\n");
        goto EXIT;
    }

    fprintf(stdout, "Step 4 done...Dirpath function success.\n");
    fprintf (stdout, "\n!!!Begin SELECT and retrieve DirPath results stored by row buffer.\n");

    dirploadmulti(dpctx, dpca, dpstr, errhp, col, 5);
    memset(sqlStmt, 0, 1000);
    sprintf(sqlStmt, "SELECT order_num, cust_num,order_date,order_byte FROM dir_path where order_num > 9");

    /* Allocate the statement handle */
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 5 -- GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
        goto EXIT;
    }

    if(rc = GCIStmtPrepare(stmthp, errhp, sqlStmt, strlen(sqlStmt), 0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 5 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
        goto EXIT;
    }

    /* Retrieve databse rows containing a list */
    if (do_select_storebycol (svchp, stmthp, errhp))
    {
        fprintf (stdout, "Error in Step 5...select and retrieve results failed.\nExiting!!\n");
        goto EXIT;
    }

    fprintf (stdout, "Step 5 done...select and retrieve results success, no data found.\n");

    GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
    /* Allocate the statement handle */
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
        goto EXIT;
    }

#if 1
    fprintf (stdout, "\n!!!Begin DELETE the DirPath result\n");

    memset(sqlStmt, 0, 1000);
    sprintf(sqlStmt, "DELETE FROM dir_path");

    if(rc = GCIStmtPrepare(stmthp, errhp, sqlStmt, sizeof(sqlStmt), 0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 6 -- GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
        goto EXIT;
    }


    if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        fprintf(stdout, "Error in Step 6 -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
        goto EXIT;
    }
#endif
    fprintf (stdout, "Step 6 done...GCIStmtExecute: Execute delete statement success, delete the records.\n");

EXIT:

    /* CLEANUP: Close the statement handle
    **          Free the statement handle
    **          Disconnect from the datasource
    **          Free the connection and environment handles
    **          Exit
    */

    if(stmthp)
        GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);

    if(dpca)
        GCIHandleFree((dvoid *)dpca, GCI_HTYPE_DIRPATH_COLUMN_ARRAY);

    if(dpstr)
        GCIHandleFree((dvoid *)dpstr, GCI_HTYPE_DIRPATH_STREAM);

    if(dpctx)
        GCIHandleFree((dvoid *)dpctx, GCI_HTYPE_DIRPATH_CTX);

    GCILogoff(svchp, errhp);

    if(svchp)
        GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);

    if(errhp)
        GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

    if(envhp)
        GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);

    fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
    in = getchar ();

    return (rc);
}