/***************************************************************************
 *	Licensed Materials - Property of GBase
 *
 *
 *	"Restricted Materials of GBase"
 *
 *
 *
 *	GBase 8s GCI Interface demo
 *
 *
 *	Copyright GBase Corporation 2015 All rights reserved.
 *    Title:          test_datconvert.c
 *
 *  Description:    To retrieve results from the database and display it. 
 *                  This example also illustrates the fact
 *                  that the same client functions can use row and column
 *                  store buffer.
 *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>

///////////////////
FILE *sqlfile = NULL;
FILE *msgfile = NULL;
char dbtooldir[1204];
/////////////////


#define MAX_USER_LEN 64
#define MAX_PASS_LEN 128
#define MAX_SERVER_LEN 128
#define MAX_DBNAME_LEN 128
#define MAX_NAME_LEN 40
#define MAX_ENUM_VALUE_LEN 40
#define CMD_MAGIC 0x5555aaaa
#define MAX_CMD_TOKEN_BUF 8192

typedef long HANDLEPTR;
#define impprintf printf
#define stricmp strcasecmp
#define stristr	                strcasestr
char CMDTOKEN[][MAX_NAME_LEN]=
{
	"      ",
	"file",
	"buffer",
	"indexes",
	"rows",
	"ignore",
	"log",
	"statistics",
	"tables",
	"full",
	"fromuser",
	"touser",
	"constraints",
	""
};
///////////

typedef enum
{
	CMD_TYPE_FULL = 1,
	CMD_TYPE_DBS_USER,	
	CMD_TYPE_DBS_FROMUSER,	
	CMD_TYPE_DBS_TOUSER,	
	CMD_TYPE_DBS_FROMUSER_B,	
	CMD_TYPE_TABLES_USER,	
	CMD_TYPE_TABLES_FROMUSER,	
	CMD_TYPE_TABLES_TOUSER,
	CMD_TYPE_TABLES_FROMUSER_B,
	CMD_TYPE_INVALID,
	
}E_CMDTYPE;
typedef enum
{
	TYPE_CHAR = 0,
	TYPE_BOOL,		
	TYPE_INT,			
	TYPE_ENUM,
	TYPE_INVALID
}E_Valuetype;

 typedef struct
{
	char value[MAX_ENUM_VALUE_LEN];
}T_tEnumValue;
typedef enum
{
	TOKEN_ID_USER  = 0,
	TOKEN_ID_FILE ,
	TOKEN_ID_BUFFER,
	TOKEN_ID_INDEXES ,
	TOKEN_ID_ROWS,
	TOKEN_ID_IGNORE ,
	TOKEN_ID_LOG,
	TOKEN_ID_STATISTICS ,
	TOKEN_ID_TABLES,
	TOKEN_ID_FULL ,
	TOKEN_ID_FROMUSER,
	TOKEN_ID_TOUSERS,
	TOKEN_ID_CONSTAINTS,
	TOKEN_ID_INVALID,
	
}E_TokenID;


typedef struct
{
	char *key;
	char *paramvalue;
	void *next;
	
}T_CmdToken;

typedef struct
{
	char *next;
	char *paramvalue;
	int     repeat;	
	int     touserrepeat;
}T_valuelist;



typedef struct
{
	int magic;
	int ptype;
	int valuetype;
	int paramnum;
	T_valuelist *valueslist;
	T_valuelist *valueslast;
	int repeatnum;
	int islast;
	
}T_CmdParam;

#define TOKEN_ARRAY_NUM 20
typedef struct
{
	int magic;
	char user[MAX_USER_LEN];
	char password[MAX_PASS_LEN];
	char servername[MAX_SERVER_LEN];
	int paramnum;
	T_CmdParam *ptCmdParam;
	T_CmdToken tokenarr[TOKEN_ARRAY_NUM];
	char Errmsg[8192];
	
}T_CmdParse;

typedef int (*checkfunc)(T_valuelist *value,int index,HANDLEPTR *handle);
typedef int (*checkparsefunc)(T_valuelist *value,int index,HANDLEPTR *handle);

 T_tEnumValue g_atStatistics[] = 
{
	"ESTIMATE",
	"COMPUTE",
	"NONE",
	"",
};
T_tEnumValue g_atBool[] = 
{
	"Y",
	"N",
	"",
};


typedef struct
{
	char cmdname[MAX_NAME_LEN];
	int cmdtype;
	int cmdshenglue;
	T_tEnumValue *valueEnum;
	
	checkfunc  checkfunc;
	checkparsefunc checkcontext;
	int    cmdnum;
	int    cmdrepeat;
	
}T_tCmdDesc;




static int CheckCmdBoolValue(T_valuelist *value,int index,HANDLEPTR *handle);
static int CheckCmdEnumValue(T_valuelist *value,int index,HANDLEPTR *handle);
static int CheckCmdIntValue(T_valuelist *value,int index,HANDLEPTR *handle);
static int CheckCmdFileParsed(T_valuelist *value,int index,HANDLEPTR *handle);
static int CheckCmdToUserParsed(T_valuelist *value,int index,HANDLEPTR *handle);
static int CheckCmdFromUserParsed(T_valuelist *value,int index,HANDLEPTR *handle);
static int CheckCmdFullSec(T_valuelist *value,int index ,HANDLEPTR *handle);
static int CheckCmdTablesParsed(T_valuelist *value,int index ,HANDLEPTR *handle);
static int CheckCmdIgnoreParsed(T_valuelist *value,int index,HANDLEPTR *handle);
static int CheckCmdLogParsed(T_valuelist *value,int index,HANDLEPTR *handle);
T_tCmdDesc g_atCmdDesc[]=
{
  	{"      ",    TYPE_CHAR,0,    NULL,                  NULL,NULL,   TOKEN_ID_USER                                   },
  	{"file",         TYPE_CHAR,0,    NULL,                  NULL,CheckCmdFileParsed,   TOKEN_ID_FILE },
  	{"buffer",    TYPE_INT,    1,     NULL,                 CheckCmdIntValue,NULL,   TOKEN_ID_BUFFER        },
  	{"indexes", TYPE_BOOL, 1,     g_atBool,           CheckCmdEnumValue,NULL,  TOKEN_ID_INDEXES  },
  	{"rows",     TYPE_BOOL, 1,    g_atBool,            CheckCmdEnumValue,NULL, TOKEN_ID_ROWS      },
  	{"ignore",    TYPE_BOOL,1,     g_atBool,           CheckCmdEnumValue,CheckCmdIgnoreParsed,  TOKEN_ID_IGNORE   },
  	{"log",         TYPE_CHAR,1,    NULL,                   NULL,CheckCmdLogParsed, TOKEN_ID_LOG                                     },
  	{"statistics",TYPE_ENUM, 1 ,  g_atStatistics,    CheckCmdEnumValue,NULL, TOKEN_ID_STATISTICS },
  	{"tables",     TYPE_CHAR,1,   NULL,                   NULL,CheckCmdTablesParsed,  TOKEN_ID_TABLES                                   },
  	{"full",          TYPE_BOOL,1,   g_atBool,            CheckCmdEnumValue,CheckCmdFullSec,  TOKEN_ID_FULL           },
  	{"fromuser",TYPE_CHAR, 1,  NULL,                  NULL,CheckCmdFromUserParsed,   TOKEN_ID_FROMUSER                              },
  	{"touser",    TYPE_CHAR,1,   NULL,                  NULL,CheckCmdToUserParsed,   TOKEN_ID_TOUSERS                                 }, 
  	{"constraints",TYPE_BOOL,1,g_atBool,           CheckCmdEnumValue,NULL,   TOKEN_ID_CONSTAINTS},
  	{"",            TYPE_INVALID,1, NULL,                  NULL,NULL,   TOKEN_ID_INVALID                                   },
};

int CheckCmdEnumValue(T_valuelist *value,int index,HANDLEPTR*handle)
{
	T_tCmdDesc *ptCmdDes = NULL;
	int loop = 0;
	int msglen = 0;
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);

	if(!handle||!(*handle))
	{
		return -1;
	}
		
	if(index >= TOKEN_ID_INVALID)
	{
		return -1;
	}
	if (!value)
	{
		sprintf(ptParse->Errmsg,"no value set for [%s] \n ",g_atCmdDesc[index].cmdname);
		return -1;
	}
	ptCmdDes = &g_atCmdDesc[index];
	
	if (value&&value->paramvalue&&strlen(value->paramvalue)&&ptCmdDes->valueEnum)
	{
		while(strlen(ptCmdDes->valueEnum[loop].value))
		{
			if(stricmp(ptCmdDes->valueEnum[loop].value,value->paramvalue) == 0)
			{
				return 0;
			}
			loop++;
		}
		loop = 0;
		sprintf(ptParse->Errmsg,"%s value must be:\n ",g_atCmdDesc[index].cmdname);
		while(strlen(ptCmdDes->valueEnum[loop].value))
		{
			msglen = strlen(ptParse->Errmsg);
			sprintf(&ptParse->Errmsg[msglen],"%s|",ptCmdDes->valueEnum[loop].value);
			loop++;
		}		
		msglen = strlen(ptParse->Errmsg);
		strcat(ptParse->Errmsg,"\n");
		
		return -1;
	}
	if (value->paramvalue&&(strlen(value->paramvalue) == 0))
	{
		loop = 0;
		sprintf(ptParse->Errmsg,"%s value must be:\n ",g_atCmdDesc[index].cmdname);
		while(strlen(ptCmdDes->valueEnum[loop].value))
		{
			msglen = strlen(ptParse->Errmsg);
			sprintf(&ptParse->Errmsg[msglen],"%s|",ptCmdDes->valueEnum[loop].value);
			loop++;
		}		
		msglen = strlen(ptParse->Errmsg);
		strcat(ptParse->Errmsg,"\n");
		
		return -1;
	}
	
	return -1;
}

int CheckCmdIntValue(T_valuelist *value,int index,HANDLEPTR *handle)
{
	T_tCmdDesc *ptCmdDes = NULL;
	int loop = 0;
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);

	if(!handle||!(*handle))
	{
		return -1;
	}
	
	if(value&&strlen(value->paramvalue))
	{
		for(loop = 0;loop < strlen(value->paramvalue);loop++)
		{
			if((value->paramvalue[loop] >=  '0')&&(value->paramvalue[loop] <= '9'))
			{
				continue;
			}
			else
			{
				sprintf(ptParse->Errmsg,"%s not a number!\n ",g_atCmdDesc[index].cmdname);
				return -1;
			}
		}
		if(loop == strlen(value->paramvalue))
		{
			return 0;
		}
	}
	strcpy(ptParse->Errmsg,"buffer_size not set value!\n ");
	return -1;
}
int CheckCmdFileParsed(T_valuelist *value,int index,HANDLEPTR *handle)
{
	T_tCmdDesc *ptCmdDes = NULL;
	int loop = 0;
	char full = 0;
	T_valuelist *ptValue = NULL;
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);
	char *ptr = NULL;
	
	if(!handle||!(*handle))
	{
		return -1;
	}
	if(!value&&(strlen(value->paramvalue) == 0))
	{
		strcpy(ptParse->Errmsg,"no file value set!\n ");
		return -1;
	}
	if(ptParse->ptCmdParam[TOKEN_ID_FILE].paramnum == 0)
	{
		strcpy(ptParse->Errmsg,"no file set!\n ");
		return -1;
	}
	else	if(ptParse->ptCmdParam[TOKEN_ID_FILE].paramnum > 1)
	{
		strcpy(ptParse->Errmsg,"cannot set multiple files!\n ");
		return -1;
	}

	//check the filename if format is '*.dmp'
	ptr = stristr(value->paramvalue,".dmp");
	if (NULL == ptr)
	{
		strcpy(ptParse->Errmsg,"invalid file name! must be the '*.dmp' format\n ");
		return -1;		
	}
	else
	{
		if (strlen(ptr)!= 4)
		{
			strcpy(ptParse->Errmsg,"invalid file name! must be the '*.dmp' format\n ");
			return -1;		
		}
	}

	if(ptParse->ptCmdParam[TOKEN_ID_FULL].magic)
	{
		ptValue = ptParse->ptCmdParam[TOKEN_ID_FULL].valueslist;
		if(stricmp(ptValue->paramvalue,"N") == 0)
		{
			if((ptParse->ptCmdParam[TOKEN_ID_FROMUSER].magic == CMD_MAGIC)||(ptParse->ptCmdParam[TOKEN_ID_TOUSERS].magic == CMD_MAGIC))
			{
				return 0;
			}
			else
			{
				strcpy(ptParse->Errmsg,"if [full] is n, fromuser or touser must be set!\n ");
				return -1;
			}
		}
		else
		{//y
			return 0;
		}
	}
	
	if((ptParse->ptCmdParam[TOKEN_ID_TABLES].magic == CMD_MAGIC)||(ptParse->ptCmdParam[TOKEN_ID_FROMUSER].magic == CMD_MAGIC)||(ptParse->ptCmdParam[TOKEN_ID_TOUSERS].magic == CMD_MAGIC))
	{
		return 0;
	}
	else
	{
		strcpy(ptParse->Errmsg,"if [full] is default or [full] is n,need set  one of the {tables,fromuser or touser }!\n ");
		return -1;
	}	
	
	return 0;
	
}
int CheckCmdIgnoreParsed(T_valuelist *value,int index,HANDLEPTR *handle)
{
	T_tCmdDesc *ptCmdDes = NULL;
	int loop = 0;
	char full = 0;
	T_valuelist *ptValue = NULL;
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);
	char *ptr = NULL;

	if(!handle||!(*handle))
	{
		return -1;
	}

	return 0;
	
}
int CheckCmdLogParsed(T_valuelist *value,int index,HANDLEPTR *handle)
{
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);
	char *ptr = NULL;

	if(!handle||!(*handle))
	{
		return -1;
	}
	if(ptParse->ptCmdParam[TOKEN_ID_LOG].magic == CMD_MAGIC)
	{
		if(ptParse->ptCmdParam[TOKEN_ID_LOG].paramnum == 0)
		{
			return 0;
		}
		else	if(ptParse->ptCmdParam[TOKEN_ID_LOG].paramnum > 1)
		{
			strcpy(ptParse->Errmsg,"must be only one log file.!\n");
			return -1;
		}
		else
		{
			return 0;
		}
	}
	return 0;
}
int CheckCmdTablesParsed(T_valuelist *value,int index,HANDLEPTR *handle)
{
	T_tCmdDesc *ptCmdDes = NULL;
	int loop = 0;
	char full = 0;
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);

	if(!handle||!(*handle))
	{
		return -1;
	}
	
	if(!value&&(strlen(value->paramvalue) == 0))
	{
		strcpy(ptParse->Errmsg,"no tables value set!\n ");
		return -1;
	}
	if(ptParse->ptCmdParam[TOKEN_ID_TABLES].paramnum == 0)
	{
		strcpy(ptParse->Errmsg,"no tables value set!\n ");
		return -1;
	}
	else
	{
		return 0;
	}
}
int CheckCmdToUserParsed(T_valuelist *value,int index,HANDLEPTR *handle)
{
	T_tCmdDesc *ptCmdDes = NULL;
	int loop = 0;
	char full = 0;
	T_valuelist *ptValue = NULL;
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);

	if(!handle||!(*handle))
	{
		return -1;
	}
	impprintf("CheckCmdToUserParsed\n");
	if((ptParse->ptCmdParam[TOKEN_ID_FULL].magic == CMD_MAGIC)&&(ptParse->ptCmdParam[TOKEN_ID_FULL].paramnum))
	{
		ptValue = 	ptParse->ptCmdParam[TOKEN_ID_FULL].valueslist;
		if(ptValue&&(stricmp(ptValue->paramvalue,"Y") == 0))
		{
			strcpy(ptParse->Errmsg,"import full, cannot set the fromuser ,touser or tables!\n ");
			return -1;			
		}
	}
	
	if((ptParse->ptCmdParam[TOKEN_ID_FROMUSER].magic == CMD_MAGIC)&&(ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum == 0))
	{
		strcpy(ptParse->Errmsg,"no fromuser set!\n ");
		return -1;
	}
	else if(ptParse->ptCmdParam[TOKEN_ID_FROMUSER].magic != CMD_MAGIC)
	{
		strcpy(ptParse->Errmsg,"no fromuser set!\n ");
		return -1;
		
	}

	return 0;

}
int CheckCmdFromUserParsed(T_valuelist *value,int index,HANDLEPTR *handle)
{
	T_tCmdDesc *ptCmdDes = NULL;
	int loop = 0;
	char full = 0;
	T_valuelist *ptValue = NULL;
	T_valuelist *ptValue1= NULL;
	T_valuelist *ptValue2= NULL;
	T_valuelist *ptValue3= NULL;
	T_valuelist *ptValue4= NULL;	
	int loop1 = 0;
	int samedb = 0;
	int *bytemap = NULL;
	int *bytemap1 = NULL;	
	int rc = 0;
	
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);

	if (!handle||!(*handle))
	{
		return -1;
	}
	
	if (!value && (strlen(value) == 0))
	{
		strcpy(ptParse->Errmsg,"no FromUser's value set!\n ");
		return -1;
	}

	if (ptParse->ptCmdParam[TOKEN_ID_FULL].paramnum)
	{
		ptValue = 	ptParse->ptCmdParam[TOKEN_ID_FULL].valueslist;
		if(ptValue&&(stricmp(ptValue->paramvalue,"Y") == 0))
		{
			strcpy(ptParse->Errmsg,"import full, cannot set the fromuser ,touser or tables!\n ");
			return -1;			
		}
	}

	ptValue = 	ptParse->ptCmdParam[TOKEN_ID_FROMUSER].valueslist;
	bytemap = (int *)malloc(ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum*sizeof(int));
	memset(bytemap,0,ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum*sizeof(int));

	bytemap1 = (int *)malloc(ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum*sizeof(int));
	memset(bytemap1,0,ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum*sizeof(int));	
	
	for (loop = 0;loop < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum;loop++)
	{
		if (ptValue == NULL)
			break;
		ptValue2 = ptValue->next;		
		while (ptValue&&ptValue2)
		{
			impprintf("1 loop %d value %s %s\n",loop,ptValue->paramvalue,ptValue2->paramvalue );
			if (stricmp(ptValue->paramvalue,ptValue2->paramvalue) == 0 )
			{
				if (ptValue->repeat == 0) 
				{
					ptValue2->repeat = loop + 1;
					bytemap[loop] = loop + 1;
				}
				else
				{
					ptValue2->repeat = ptValue->repeat;
					bytemap[loop] = ptValue->repeat;
				}
			}
			
			ptValue2 = ptValue2 ->next;
		}
		//printf("\nbytemap loop %d,%d\n",loop,ptValue->repeat);
		if (ptValue->repeat == 0) 
		{
			ptValue->repeat = loop + 1;
			bytemap[loop] = loop + 1;
		}
		else if (bytemap[loop] == 0)
		{
			bytemap[loop] = ptValue->repeat ;
		}
		impprintf("\nbytemap loop %d,%d\n",loop,ptValue->repeat);
		ptValue = ptValue->next;
	}
	
	//printf the fromuser repeat situation
	ptValue = 	ptParse->ptCmdParam[TOKEN_ID_FROMUSER].valueslist;
	for (loop = 0;loop < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum;loop++)
	{
		if (ptValue)
		{
			impprintf("\nbytemap %d,",bytemap[loop]);
			ptValue->repeat = 0;//reset 0
		}
		ptValue = ptValue->next;
	}

	if ((ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum >= 1) &&
		 (ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum >= 1) )
	{
		ptValue = 	ptParse->ptCmdParam[TOKEN_ID_FROMUSER].valueslist;
		ptValue1 = ptParse->ptCmdParam[TOKEN_ID_TOUSERS].valueslist;
		//check the condition which fromuser = touser,record in bytemap1
		for (loop = 0;loop < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum;loop++)
		{
			if (NULL == ptValue)
				break;		
			
			ptValue->repeat = 0;//reset 0
			if (ptValue1 && ptValue->paramvalue 
				&& ptValue1->paramvalue && 
				(stricmp(ptValue->paramvalue,ptValue1->paramvalue) == 0 ))
			{
				bytemap1[loop] = bytemap[loop];
			}
			else
				bytemap1[loop] = 0;

			ptValue = ptValue->next;
			if (ptValue1)
				ptValue1 =  ptValue1->next;			
		}
		
		for (loop = 0;loop < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum;loop++)
		{
			impprintf("\nbytemap1 %d,",bytemap1[loop]);
		}
		//check fromuser = touser condition if repeat
		ptValue = 	ptParse->ptCmdParam[TOKEN_ID_FROMUSER].valueslist;
		ptValue1 = 	ptParse->ptCmdParam[TOKEN_ID_TOUSERS].valueslist;
		for (loop = 0;loop < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum;loop++)
		{
			if (NULL == ptValue)
				break;			
			ptValue2 = ptValue->next;	
		
			if (NULL == ptValue2)
				break;		
			if(ptValue1 == NULL)
			{
				break;
			}
			ptValue3 = ptValue1->next;
			
			impprintf("ptValue1->repeat %s %s,%d %d\n",ptValue->paramvalue,ptValue2->paramvalue,strlen(ptValue->paramvalue),strlen(ptValue2->paramvalue));
			while (ptValue)
			{
				if (ptValue2 == NULL)
				{
					break;
				}
				else if (ptValue3 == NULL)
				{
					break;					
				}
				else	if (stricmp(ptValue->paramvalue,ptValue2->paramvalue) == 0 )
				{
					if (stricmp(ptValue1->paramvalue,ptValue3->paramvalue) != 0)
					{

					}
					else
					{
						ptValue2->repeat = 1;
					}
					
					impprintf("ptValue2->repeat %d %s\n",ptValue2->repeat,ptValue2->paramvalue);
				}
				
				ptValue2 = ptValue2 ->next;
				ptValue3 = ptValue3->next;
			}

			ptValue = ptValue->next;
			ptValue1 =  ptValue1->next;
		}
		//if touser < fromuser,fromuser will be the dbname,check it if repeat
		if (ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum)
		{
			ptValue = ptParse->ptCmdParam[TOKEN_ID_FROMUSER].valueslist;
			for(loop = 0;loop < ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum; loop++)
			{
				if(ptValue)
					ptValue = ptValue->next;
				else
				{
					rc = -1;
					strcpy(ptParse->Errmsg,"FromUser value error!\n");
					goto EXIT;
				}
			}
			if(!ptValue)
			{
				rc = -1;
				strcpy(ptParse->Errmsg,"FromUser value error!\n");
				goto EXIT;
			}				
			
			for (;loop < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum;loop++)
			{
				//first check the bytemap1
				for(loop1 = 0;loop1 < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum;loop1++)
				{
					if ((0 != bytemap1[loop1]) &&(bytemap1[loop1] == bytemap[loop]))
					{
						ptValue->repeat = 1;
						break;
					}
					else
					{
					}
				}
				//not in bytemap1,then check repeat in bytemap
				if (loop1 == ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum)
				{
					ptValue1 = ptValue->next;
					loop1 = loop + 1;
					for(;loop1 < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum;loop1++)
					{
						if(ptValue1 == NULL)
							break;
						if ((0 != bytemap[loop1]) &&(bytemap[loop1] == bytemap[loop]))
						{
							ptValue1->repeat = 1;
						}
						else
						{
						}
						ptValue1 = ptValue1->next;
					}
				}
				if (ptValue)
					ptValue = ptValue->next;
				else
				{
					rc = -1;
					strcpy(ptParse->Errmsg,"FromUser value error!\n");
					goto EXIT;
				}
					
			}
			
		}
	}
	if (ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum == 0)
	{
		ptValue = ptParse->ptCmdParam[TOKEN_ID_FROMUSER].valueslist;
		for (loop = 0;loop < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum;loop++)
		{
			if(ptValue == NULL)
				break;
			ptValue1 = ptValue->next;
			loop1 = loop + 1;
			for (;loop1 < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum;loop1++)
			{
				if (ptValue1 == NULL)
					break;
				if ((0 != bytemap[loop1]) &&(bytemap[loop1] == bytemap[loop]))
				{
					ptValue1->repeat = 1;
				}
				else
				{
				}
				ptValue1 = ptValue1->next;
			}		
			ptValue = ptValue->next;
		}
	}
	//printf the repeat situation
	ptValue = 	ptParse->ptCmdParam[TOKEN_ID_FROMUSER].valueslist;
	for (loop = 0;loop < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum;loop++)
	{
		if(ptValue)
		{
			impprintf("\nrepeat %d",ptValue->repeat);
			ptValue = ptValue->next;
		}
		else
			break;


	}

EXIT:
	if(bytemap1)
		free(bytemap1);
	bytemap1 = NULL;
	if(bytemap)
		free(bytemap);
	bytemap = NULL;	
	
	return rc;

}
int CheckCmdFullSec(T_valuelist *value,int index ,HANDLEPTR *handle)
{
	T_tCmdDesc *ptCmdDes = NULL;
	int loop = 0;
	char full = 0;
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);

	if(!handle||!(*handle))
	{
		return -1;
	}
	
	if(!value||!value->paramvalue)
	{
		return -1;
	}
	full = stricmp(value->paramvalue,"Y");
	if(!full)
	{//y
		if(ptParse->ptCmdParam[TOKEN_ID_TABLES].paramnum)
		{
			strcpy(ptParse->Errmsg,"import full, cannot set the fromuser ,touser or tables!\n ");		
			return -1;
		}
		else	if(ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum)
		{
			strcpy(ptParse->Errmsg,"import full, cannot set the fromuser ,touser or tables!\n ");		
			return -1;
		}
		else 	if(ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum)
		{
			strcpy(ptParse->Errmsg,"import full, cannot set the fromuser ,touser or tables!\n ");		
			return -1;
		}
		else
		{	
			return 0;
		}
	}
	else
	{
		if((ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum)
			||(ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum))
		{
			return 0;
		}
		else	
		{
			strcpy(ptParse->Errmsg,"if full set N,must set the fromuser ,touser!\n ");		
			return -1;			
		}
	}

}


int CmdParseInit(int tokennum,HANDLEPTR*handle)
{
	int loop = 0;
	T_CmdParse *ptparam = NULL;
	
	loop = tokennum;
	if(loop)
	{	
		ptparam = (T_CmdParse *)malloc(sizeof(T_CmdParse));
		memset(ptparam,0,sizeof(T_CmdParse));
		ptparam->ptCmdParam = (T_CmdParam *)malloc(sizeof(T_CmdParam)*loop);
		memset(ptparam->ptCmdParam,0,sizeof(T_CmdParam)*loop);
		ptparam->magic = CMD_MAGIC;
		ptparam->paramnum = tokennum;
		*handle = ptparam;
		
		return 0;
	}
	else
	{
		impprintf("no memory!\n");
		return -1;
	}
}
char *successwarning = "\nImport terminated successfully without warnings.\n";
int printsuccess(void *fp,char *juzi)
{
	fprintf(fp,juzi);
	impprintf("\n%s",successwarning);
}
int CmdParseFree(HANDLEPTR *handle)
{
	T_CmdParse *ptCmdParse = NULL;
	T_CmdParam *ptParam = NULL; 
	T_valuelist *ptvalue = NULL;
	int loop = 0;
	
	if(!handle||!(*handle))
	{
		impprintf("NULL handle \n");
		return -1;
	}

	ptCmdParse = *handle;
	if(ptCmdParse->magic == CMD_MAGIC)
	{
		for(loop = 0;loop < ptCmdParse->paramnum;loop++)
		{
			ptParam = &ptCmdParse->ptCmdParam[loop];

			while(ptParam->valueslist)
			{
				ptvalue =ptParam->valueslist;		
				if(ptvalue->paramvalue)
				{
					free(ptvalue->paramvalue);
					ptvalue->paramvalue = NULL;
				}
				ptParam->valueslist = ptvalue->next;
				ptvalue->next= NULL;
				free(ptvalue);
			}
		}
		if(ptCmdParse->ptCmdParam)
			free(ptCmdParse->ptCmdParam);
		ptCmdParse->ptCmdParam = NULL;
		if(ptCmdParse)
			free(ptCmdParse);
		*handle = NULL;
	}
	else
	{
		impprintf("mem magic error!\n");
		return -1;
	}
	
	return 0;
}

int getfilelist()
{
	return 0;
}


int getuserid(char *user,char*pass,char *server,HANDLEPTR handle)
{
	
	return 0;
}

/*

 * This function allocates the row and collection buffers, passes
 * them to the do_select_storebyxxx() function, along with an appropriate select
 * statement and then frees all allocated handles.
 */
char *findequalkey(char *ch,int len,char **pos,char **pos1)
{
	char *ptr = NULL;
	char *ptr1 = NULL;	
	int state = 0;
	
	if(!ch||!len)
		return NULL;
	ptr1 = ch;
	
	while(1)
	{
		if(*ptr1 == '=')
		{
			break;
		}
		if((ptr1 == (ch + len))||(*ptr1 == '\0'))
		{
			return NULL;
		}
		ptr1++;
	}

	if(pos)
		*pos = ptr1;
	if(pos1)
		*pos1 = ptr1;
	
	if(ptr1 == ch)
		return NULL;
	
	ptr = ptr1;
	ptr -- ;
	while(1)
	{
	
		switch(state)
		{
		case 0:
			if (*ptr == ' ')
			{
				if(pos1)
					*pos1 = ptr;			
				ptr--;

				continue;
			}
			else	if (*ptr == '=')
			{
				return NULL;
			}
			if(ch == ptr)
			{
				return NULL;
			}
			else
			{
				//ptr--;
				state = 1;
			}
			
		case 1:
			if((*ptr == ' ')||(*ptr == '\t'))
			{
				ptr++;
				return ptr;
			}
			else	if(ch == ptr)
			{
				return ptr;
			}
			else if (*ptr == '=')
			{
				return ptr++;
			}
			else
			{
				ptr--;
			}
			
		}
	}	
	
	return NULL;
}
char *valuetrim(char *ch,int len)
{
	char *ptr = NULL;
	char *ptr1 = NULL;
	int state = 0;	
	ptr = ch;
	ptr1 = ch + len;
	while(1)
	{
		switch(state)
		{
		case 0:
			if((*ptr == ' ')||(*ptr == '\t'))
			{
				ptr++;
				if(ch == ptr1)
				{
					return NULL;
				}					
				continue;
			}
			else
			{
				state = 1;
			}
		
		case 1:
			if((*ptr == ' ')||(*ptr == '\t'))
			{
				return ptr;
			}
			else
			{
				ptr++;
			}
			if(ch == ptr1)
			{
				return ptr;
			}			
		}
	}	
	return NULL;
}
int importopt(char *dbname,char *tabname,char *curuser,char *utype,char *dbspace,int pagesize,int isrows)
{
	impprintf("importopt ok!\n");
	return 0;
}
char *findequalvalue(char *ch,int len,char **pos)
{
	char *ptr = NULL;
	char *posvalue = NULL;
	ptr = findequalkey(ch,len,&posvalue,NULL);
	if(ptr)
	{
		return ptr;
	}
	else
	{
		if(posvalue)
			return posvalue;	
		else
			return NULL;		
	}
}
int OpenLogFile(HANDLEPTR *handle)
{
	T_valuelist *ptValue = NULL;
	T_CmdParam *ptCmdLogParam = NULL;
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);

	if(!handle||!(*handle))
		return -1;
	

	if(ptParse->ptCmdParam[TOKEN_ID_LOG].magic == CMD_MAGIC)
	{
		ptValue = ptParse->ptCmdParam[TOKEN_ID_LOG].valueslist;
		if(ptValue&&ptValue->paramvalue&&strlen(ptValue->paramvalue))
		{
			if(msgfile)
			{
				fclose(msgfile);
				msgfile = NULL;
			}
			
			if((msgfile = fopen(ptValue->paramvalue,"w")) == -1)
			{
				printf("open log file failed!\n");
				return -1;
			}
			return 0;
		}
	}

	return -1;
}
void SET_NEXTCHAIN(T_CmdParse *ptParse,int type,T_valuelist *ptvalue) 
{

	if(!ptParse)
		return ;
	if(type >= TOKEN_ID_INVALID)
		return ;
	
	if((NULL == ptParse->ptCmdParam[type].valueslist)||(NULL == ptParse->ptCmdParam[type].valueslast))
	{
		ptvalue->next = NULL;
		ptParse->ptCmdParam[type].valueslist = ptvalue;
		ptParse->ptCmdParam[type].valueslast = ptvalue;
		ptvalue->repeat = 0;		
	}
	else
	{
		ptParse->ptCmdParam[type].valueslast->next = ptvalue;
		ptvalue->next = NULL;
		ptParse->ptCmdParam[type].valueslast = ptvalue;
		ptvalue->repeat = 0;		
		/*
		ptvalue->next = ptParse->ptCmdParam[type].valueslist;
		ptParse->ptCmdParam[type].valueslist = ptvalue;*/

	}
}
//if keys no = exist, return failed
int findtokennouse(HANDLEPTR *handle ,char *ptr,int pos,int valuelen,int type)
{
	int i = 0;
	int rc = 0;
	int len = valuelen - pos;
	int state = 0;
	int loop = 0;
	int count = 0;
	char tempptr[2048];
	T_CmdParam *ptParam = NULL;
	
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);

	if ( !handle|| !(*handle))
		return 0;
	ptParam  = &ptParse->ptCmdParam[type];
	printf("invalid charactor ===%d %d\n",type,ptParam->islast);
	if(ptParam->magic != CMD_MAGIC)
	{
		return 0;
	}
	if (len <= 0)
		return 0;

	
	
	count = (sizeof(CMDTOKEN)/MAX_NAME_LEN);
	while (1)
	{
		if ((i > len)||(loop >= 2028))
			return 0;
		
		switch (state)
		{
		case 0:
			if (*ptr == ' ')
			{
				ptr++;
				i++;
				continue;
			}
			else if(*ptr == '\0')
			{	
				goto EXIT;
			}
			else
			{
				state = 1;
			}
			
			break;
		case 1:
			if (*ptr == '\0')
			{
				goto EXIT;
			}
			else 	if (*ptr != ' ')
			{
				tempptr[loop] = *ptr;
				loop++;			
			}
			else
			{
				tempptr[loop] = '\0';
				if(ptParam->islast)
				{
					for (rc = 0;rc < count;rc++)
					{
						if (strlen(CMDTOKEN[rc]) &&(stricmp(tempptr,CMDTOKEN[rc]) == 0))					
						{
							sprintf(ptParse->Errmsg,"key [%s] no use in the cmdline \n",CMDTOKEN[rc]);
							return -1;
						}
					}
				}
				else
				{
					sprintf(ptParse->Errmsg,"invalid charactor %s \n",tempptr);
					printf("invalid charactor %s \n",tempptr);
					return -1;
				}
				loop = 0;
				tempptr[loop] = '\0';
				state = 0;
			}			
			ptr++;
			i++;			
			break;
		}
	}
EXIT:
	if(loop)
	{
		tempptr[loop] = '\0';
		if(ptParam->islast)
		{
			for (rc = 0;rc < count;rc++)
			{
				if (strlen(CMDTOKEN[rc]) &&(stricmp(tempptr,CMDTOKEN[rc]) == 0))					
				{
					sprintf(ptParse->Errmsg,"key [%s] no use in the cmdline \n",CMDTOKEN[rc]);
					return -1;
				}
			}
		}
		else
		{
			sprintf(ptParse->Errmsg,"invalid charactor %s \n",tempptr);
			printf("invalid charactor 1 %s \n",tempptr);
			return -1;
		}
	}
	return 0;
}
/* parsefile
 *    function:,get file the value,only one.
 */	
int parsefile(char *value,int type,HANDLEPTR*handle)
{
	char *ptr = NULL;
	char *ptr1 = NULL;
	int i = 0;
	int rc = 0;
	int valuelen = 0;
	int loop = 0;
	int state = 0;
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);
	T_valuelist *ptvalue = NULL;
	char tmpptr[MAX_CMD_TOKEN_BUF] = {0};
	
	if(!value||!handle||!(*handle))
		return -1;

	ptParse->ptCmdParam[type].ptype = type;
	ptParse->ptCmdParam[type].magic = CMD_MAGIC;
	ptr = value;
	ptr1 = value;
	valuelen = strlen(value);
	
	while(1)
	{
		if(loop > MAX_CMD_TOKEN_BUF)
		{
			rc = -1;
			sprintf(ptParse->Errmsg,"[%s] value is too long!\n",CMDTOKEN[type]);
			goto EXIT;			
		}	
		if(i >=valuelen)
		{
			if(strlen(tmpptr) )
			{//cuowu
				tmpptr[loop] = '\0';
				ptvalue = malloc(sizeof(T_valuelist));
				
				if(ptvalue)
				{
					SET_NEXTCHAIN(ptParse,type,ptvalue);
					ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
					if(ptvalue->paramvalue)
						strcpy(ptvalue->paramvalue,tmpptr);

					ptParse->ptCmdParam[type].paramnum++;						
					impprintf("i >=valuelen %s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
				
				}				
				loop = 0;
				tmpptr[loop] = '\0';									

			}
			break;
		}
		
		switch(state)
		{
		case 0:
			if(*ptr == ' ')
			{//you wenti
				ptr++;
				i++;
				continue;			
			}
			else
			{
				state = 1;
			}
			break;
		case 1:
			
			if (*ptr == ',')
			{//only one value,cannot have ,
				rc = -1;
				impprintf("==============1\n");
				strcpy(ptParse->Errmsg,"file can not set multi value!\n");
				goto EXIT;
 			}
			else if (*ptr == '.')
			{//.hao liuzhe
				tmpptr[loop] = *ptr;
				loop++;			
				state = 2;
			}
			else if (*ptr == ' ')
			{//kongge buyao
				state = 3;
			}
			else if (*ptr != '\0')
			{
				tmpptr[loop] = *ptr;
				loop++;
			}
			else
			{
				tmpptr[loop] = '\0';
				ptvalue = malloc(sizeof(T_valuelist));
				if(ptvalue)
				{
					SET_NEXTCHAIN(ptParse,type,ptvalue);
					ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
					if(ptvalue->paramvalue)
						strcpy(ptvalue->paramvalue,tmpptr);

					ptParse->ptCmdParam[type].paramnum++;						
					impprintf("%s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
				}		
				loop = 0;
				tmpptr[loop] = '\0';
				goto EXIT;
			}
			ptr++;
			i++;			
			break;
		case 2:
			if (*ptr == ',')
			{//only one value,cannot have ,
				rc = -1;
				impprintf("==============1\n");
				strcpy(ptParse->Errmsg,"file can not set multi value!\n");
				goto EXIT;
 			}
			else if (*ptr == '.')
			{
				rc = -1;
				impprintf("==============2\n");
				strcpy(ptParse->Errmsg,"invalid file name!\n");
				goto EXIT;			
			}
			else if (*ptr == ' ')
			{//kongge jiu over le
				tmpptr[loop] = '\0';
				ptvalue = malloc(sizeof(T_valuelist));
				if(ptvalue)
				{
					SET_NEXTCHAIN(ptParse,type,ptvalue);
					ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
					if(ptvalue->paramvalue)
						strcpy(ptvalue->paramvalue,tmpptr);

					ptParse->ptCmdParam[type].paramnum++;						
					impprintf("%s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
				}		
				loop = 0;
				tmpptr[loop] = '\0';
				state = 4;
			}
			else if (*ptr != '\0')
			{
				tmpptr[loop] = *ptr;
				loop++;
			}
			else
			{//jieshufu ye over le
				tmpptr[loop] = '\0';
				ptvalue = malloc(sizeof(T_valuelist));
				if(ptvalue)
				{
					SET_NEXTCHAIN(ptParse,type,ptvalue);
					ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
					if(ptvalue->paramvalue)
						strcpy(ptvalue->paramvalue,tmpptr);

					ptParse->ptCmdParam[type].paramnum++;						
					impprintf("%s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
				}		
				loop = 0;
				tmpptr[loop] = '\0';
				goto EXIT;			
			}
			ptr++;
			i++;					
			break;
		case 3:
			if (*ptr == ',')
			{//only one value,cannot have ,
				rc = -1;
				impprintf("==============1\n");
				strcpy(ptParse->Errmsg,"file can not set multi value!\n");
				goto EXIT;
 			}
			else 	if (*ptr == '.')
			{//only one value,cannot have ,
				state = 2;
				tmpptr[loop] = *ptr;
				loop++;	
 			}
			else if (*ptr == ' ')
			{//tiaoguo
			
			}
			else if (*ptr != '\0')
			{
				rc = -1;
				impprintf("==============3\n");
				strcpy(ptParse->Errmsg,"invalid file name!\n");
				goto EXIT;				
			}
			else
			{//jieshufu ye over le
				tmpptr[loop] = '\0';
				ptvalue = malloc(sizeof(T_valuelist));
				if(ptvalue)
				{
					SET_NEXTCHAIN(ptParse,type,ptvalue);
					ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
					if(ptvalue->paramvalue)
						strcpy(ptvalue->paramvalue,tmpptr);

					ptParse->ptCmdParam[type].paramnum++;						
					impprintf("%s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
				}		
				loop = 0;
				tmpptr[loop] = '\0';
				goto EXIT;			
			}

			ptr++;
			i++;		
			break;
		case 4:
			if (*ptr == ',')
			{//only one value,cannot have ,
				rc = -1;
				impprintf("==============1\n");
				strcpy(ptParse->Errmsg,"file can not set multi value!\n");
				goto EXIT;
 			}
			else 	if (*ptr == ' ')
			{//only one value,cannot have ,

 			}
			else 
			{//tiaoguo
				impprintf("==============4\n");
				goto EXIT;				
			}

			ptr++;
			i++;		
			
			break;
		}

	}
EXIT:
	if ((rc == 0)&&(i <  valuelen))
	{
		rc = findtokennouse(handle,ptr,i,valuelen,type);
	}	
	return rc;
}

//tables name values parser
int parsetables(char *value,int type,HANDLEPTR *handle)
{
	char *ptr = NULL;
	char *ptr1 = NULL;
	int i = 0;
	int rc = 0;
	int valuelen = 0;
	int loop = 0;
	int state = 0;
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);
	T_valuelist *ptvalue = NULL;
	char tmpptr[256] = {0};
	
	if(!value||!handle||!(*handle))
		return -1;

	ptParse->ptCmdParam[type].ptype = type;
	ptParse->ptCmdParam[type].magic = CMD_MAGIC;
	
	ptr = value;
	ptr1 = value;
	valuelen = strlen(value);
	
	while(1)
	{
		if(i >=valuelen)
		{
			if(strlen(tmpptr))
			{//cuowu
				tmpptr[loop] = '\0';
				ptvalue = malloc(sizeof(T_valuelist));
				
				if(ptvalue)
				{
					SET_NEXTCHAIN(ptParse,type,ptvalue);
					ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
					if(ptvalue->paramvalue)
						strcpy(ptvalue->paramvalue,tmpptr);

					ptParse->ptCmdParam[type].paramnum++;						
					impprintf("i >=valuelen %s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
				
				}				
				loop = 0;
				tmpptr[loop] = '\0';									

			}
			break;
		}
		
		switch(state)
		{
		case 0:
			if(*ptr == ' ')
			{//you wenti 
				ptr++;
				i++;
				continue;			
			}
			else
			{
				state = 1;
			}
			break;
		case 1:
			
			if(*ptr == ',')
			{
				if(strlen(tmpptr) == 0)
				{//cuowu
					rc = -1;
					impprintf("==============3\n");				
					goto EXIT;
				}
				else
				{//found a value
					tmpptr[loop] = '\0';
					ptvalue = malloc(sizeof(T_valuelist));
					
					if(ptvalue)
					{
						SET_NEXTCHAIN(ptParse,type,ptvalue);
						ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
						if(ptvalue->paramvalue)
							strcpy(ptvalue->paramvalue,tmpptr);

						ptParse->ptCmdParam[type].paramnum++;						
						impprintf("%s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
					
					}				
					loop = 0;
					tmpptr[loop] = '\0';					
				}	
			}
			else if(*ptr != ' ') 
			{
				if(*ptr == '.')
				{
					rc = -1;
					strcpy(ptParse->Errmsg,"imp cannot set table value with db.table \n");
					goto EXIT;
				}
				tmpptr[loop] = *ptr;
				loop++;
			}
			else
			{
				tmpptr[loop] = '\0';
				ptvalue = malloc(sizeof(T_valuelist));
				if(ptvalue)
				{
					SET_NEXTCHAIN(ptParse,type,ptvalue);
					ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
					if(ptvalue->paramvalue)
						strcpy(ptvalue->paramvalue,tmpptr);

					ptParse->ptCmdParam[type].paramnum++;						
					impprintf("%s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
				}		
				loop = 0;
				tmpptr[loop] = '\0';
				state = 2;
			}
			ptr++;
			i++;			
			break;
		case 2:
			if(*ptr == ' ')
			{//you wenti 
				ptr++;
				i++;
				continue;			
			}
			else if(*ptr == ',')
			{
				ptr++;
				i++;
				state = 0;
			}
			else
			{//over
				rc = 0;
				goto EXIT;
			}
			break;
			
		}

	}
EXIT:
	if(i  < valuelen)
	{
		rc = findtokennouse(handle,ptr,i,valuelen,type);
	}	
	return rc;
}

int parsefromuser(char *value,int type,HANDLEPTR*handle)
{
	char *ptr = NULL;
	char *ptr1 = NULL;
	int i = 0;
	int rc = 0;
	int valuelen = 0;
	int loop = 0;
	int state = 0;
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);
	T_valuelist *ptvalue = NULL;
	char tmpptr[256] = {0};
	
	if(!value||!handle||!(*handle))
		return -1;

	ptParse->ptCmdParam[type].ptype = type;
	ptParse->ptCmdParam[type].magic = CMD_MAGIC;
	ptr = value;
	ptr1 = value;
	valuelen = strlen(value);
	
	while(1)
	{
		if(i >=valuelen)
		{
			if(strlen(tmpptr) )
			{//cuowu
				tmpptr[loop] = '\0';
				ptvalue = malloc(sizeof(T_valuelist));
				
				if(ptvalue)
				{
					SET_NEXTCHAIN(ptParse,type,ptvalue);
					ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
					if(ptvalue->paramvalue)
						strcpy(ptvalue->paramvalue,tmpptr);

					ptParse->ptCmdParam[type].paramnum++;						
					impprintf("i >=valuelen %s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
				
				}				
				loop = 0;
				tmpptr[loop] = '\0';									

			}
			break;
		}
		
		switch(state)
		{
		case 0:
			if(*ptr == ' ')
			{//you wenti 
				ptr++;
				i++;
				continue;			
			}
			else
			{
				state = 1;
			}
			break;
		case 1:
			
			if(*ptr == ',')
			{
				if(strlen(tmpptr) == 0)
				{//cuowu
					rc = -1;
					impprintf("==============3\n");				
					goto EXIT;
				}
				else
				{//found a value
					tmpptr[loop] = '\0';
					ptvalue = malloc(sizeof(T_valuelist));
					
					if(ptvalue)
					{
						SET_NEXTCHAIN(ptParse,type,ptvalue);
						ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
						if(ptvalue->paramvalue)
							strcpy(ptvalue->paramvalue,tmpptr);

						ptParse->ptCmdParam[type].paramnum++;						
						impprintf("%s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
						
					
					}				
					loop = 0;
					tmpptr[loop] = '\0';					
				}	
			}
			else if(*ptr != ' ') 
			{
				tmpptr[loop] = *ptr;
				loop++;
			}
			else
			{
				tmpptr[loop] = '\0';
				ptvalue = malloc(sizeof(T_valuelist));
				if(ptvalue)
				{
					SET_NEXTCHAIN(ptParse,type,ptvalue);
					ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
					if(ptvalue->paramvalue)
						strcpy(ptvalue->paramvalue,tmpptr);

					ptParse->ptCmdParam[type].paramnum++;						
								impprintf("%s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
				}		
				loop = 0;
				tmpptr[loop] = '\0';
				state = 2;
			}
			ptr++;
			i++;			
			break;
		case 2:
			if(*ptr == ' ')
			{//you wenti 
				ptr++;
				i++;
				continue;			
			}
			else if(*ptr == ',')
			{
				ptr++;
				i++;
				state = 0;
			}
			else
			{//over
				rc = 0;
				goto EXIT;
			}
			break;
			
		}

	}
	
EXIT:
	if(i  < valuelen)
	{
		rc = findtokennouse(handle,ptr,i,valuelen,type);
	}
	return rc;
}
//
int parseboolvalue(char *value,int type,HANDLEPTR*handle)
{
	int loop = 0;
	int i = 0;
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);
	T_valuelist *ptvalue = NULL;
	int state = 0;
	char tmpptr[1024] = {0};
	char *ptr = NULL;
	char *ptr1 = NULL;
	int valuelen = 0;
	int rc = 0;

	if(!value||!handle||!(*handle))
		return -1;
	
	ptvalue = malloc(sizeof(T_valuelist));

	ptParse->ptCmdParam[type].ptype = type;
	ptParse->ptCmdParam[type].magic = CMD_MAGIC;	
	ptr = value;
	ptr1 = value;
	valuelen = strlen(value);
	impprintf("==============bool %s\n",ptr);	
	while(1)
	{
		if(i >=valuelen)
		{
			if(strlen(tmpptr) )
			{//cuowu
				tmpptr[loop] = '\0';
				ptvalue = malloc(sizeof(T_valuelist));
				
				if(ptvalue)
				{
					SET_NEXTCHAIN(ptParse,type,ptvalue);
					ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
					if(ptvalue->paramvalue)
						strcpy(ptvalue->paramvalue,tmpptr);

					ptParse->ptCmdParam[type].paramnum++;						
					impprintf("i >=valuelen %s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
				
				}				
				loop = 0;
				tmpptr[loop] = '\0';									

			}
			break;
		}
		
		switch(state)
		{
		case 0:
			if(*ptr == ' ')
			{//you wenti 
				ptr++;
				i++;
				continue;			
			}
			else
			{
				state = 1;
			}
			break;
		case 1:
			
			if(*ptr == ' ')
			{

				tmpptr[loop] = '\0';
				if(strlen(tmpptr) == 0)
				{
					impprintf("===========bool err %d %d\n",loop,i);
					rc = -1;
					goto EXIT;
				}
				ptvalue = malloc(sizeof(T_valuelist));
				
				if(ptvalue)
				{
					SET_NEXTCHAIN(ptParse,type,ptvalue);
					ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
					if(ptvalue->paramvalue)
						strcpy(ptvalue->paramvalue,tmpptr);

					ptParse->ptCmdParam[type].paramnum++;						
					impprintf("%s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
				
				}				
				loop = 0;
				tmpptr[loop] = '\0';		
				state = 2;
				break;

			}
			else
			{
				tmpptr[loop] = *ptr;
				loop++;
			}
			
			ptr++;
			i++;			
			break;
		case 2:
			goto EXIT;
			break;
		}
		
	}
	//if continue?	
	
EXIT:
	if(i  < valuelen)
	{
		rc = findtokennouse(handle,ptr,i,valuelen,type);
	}
	return rc;
}
int parsecharvalue(char *value,int type,HANDLEPTR*handle)
{
	int loop = 0;
	int i = 0;
	T_CmdParse *ptParse = (T_CmdParse *)(*handle);
	T_valuelist *ptvalue = NULL;
	int state = 0;
	char tmpptr[1024] = {0};
	char *ptr = NULL;
	char *ptr1 = NULL;
	int valuelen = 0;
	int rc = 0;

	if(!value||!handle||!(*handle))
		return -1;
	
	ptvalue = malloc(sizeof(T_valuelist));

	ptParse->ptCmdParam[type].ptype = type;
	ptParse->ptCmdParam[type].magic = CMD_MAGIC;	
	ptr = value;
	ptr1 = value;
	valuelen = strlen(value);
	impprintf("==============bool %s\n",ptr);	
	while(1)
	{
		if(i >=valuelen)
		{
			if(strlen(tmpptr) )
			{//cuowu
				tmpptr[loop] = '\0';
				ptvalue = malloc(sizeof(T_valuelist));
				
				if(ptvalue)
				{
					SET_NEXTCHAIN(ptParse,type,ptvalue);
					ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
					if(ptvalue->paramvalue)
						strcpy(ptvalue->paramvalue,tmpptr);

					ptParse->ptCmdParam[type].paramnum++;						
					impprintf("i >=valuelen %s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
				
				}				
				loop = 0;
				tmpptr[loop] = '\0';									

			}
			break;
		}
		
		switch(state)
		{
		case 0:
			if(*ptr == ' ')
			{//you wenti 
				ptr++;
				i++;
				continue;			
			}
			else
			{
				state = 1;
			}
			break;
		case 1:
			
			if(*ptr == ' ')
			{

				tmpptr[loop] = '\0';
				if(strlen(tmpptr) == 0)
				{
					impprintf("===========bool err %d %d\n",loop,i);
					rc = -1;
					goto EXIT;
				}
				ptvalue = malloc(sizeof(T_valuelist));
				
				if(ptvalue)
				{
					SET_NEXTCHAIN(ptParse,type,ptvalue);
					ptvalue->paramvalue= malloc(strlen(tmpptr) + 1);
					if(ptvalue->paramvalue)
						strcpy(ptvalue->paramvalue,tmpptr);

					ptParse->ptCmdParam[type].paramnum++;						
					impprintf("%s %d\n",ptvalue->paramvalue,ptParse->ptCmdParam[type].paramnum);
				
				}				
				loop = 0;
				tmpptr[loop] = '\0';		
				state = 2;
				break;

			}
			else
			{
				tmpptr[loop] = *ptr;
				loop++;
			}
			
			ptr++;
			i++;			
			break;
		case 2:
			goto EXIT;
			break;
		}
		
	}
	//if continue?	
	
EXIT:
	if(i  < valuelen)
	{
		rc = findtokennouse(handle,ptr,i,valuelen,type);
	}
	return rc;

}
int doconnectdb(char *user ,char *password,char *servername)
{
	impprintf("connect user %s pass %s servername %s \n",user,password,servername);
	return 0;
}
int dodisconnectdb(char *user ,char *password,char *servername)
{
	impprintf("disconnect user %s pass %s servername %s \n",user,password,servername);
	return 0;
}
int doseldb(char *dbname)
{
	impprintf("dbname %s \n",dbname);
	return 0;
}

int logprintf(char *buf)
{
	impprintf("%s\n",buf);
	return 0;
}


int dbsqlfile(char *buf,int buflen,char *dbname,char *filestr)
{

	
	return 0;
}
int tabsqlfile(char *buf,int buflen,char *dbname,char *tabname,char *filestr)
{
	
	return 0;
}





int GetDbNameFromPath(char *path,char *dbname)
{
	char *ptr = NULL;
	int len = 0;

	if((NULL == path)||(NULL == dbname))
	{
		return -1;
	}

	len = strlen(path);

	if((0 == len)&&(len > MAX_DBNAME_LEN))
		return -1;
	ptr = path + len -4;
	if(stricmp(ptr,".exp") == 0)
	{
		strncpy(dbname,path,len -4);
	}
	else
		return -1;
	
	return 0;		
}
int GetTbNameFromPath(char *path)
{
	char *ptr = NULL;
	int len = 0;

	if(NULL == path)
	{
		return -1;
	}

	len = strlen(path);

	if((0 == len)&&(len > MAX_DBNAME_LEN))
		return -1;
	ptr = path + len -4;
	if(stricmp(ptr,".sql") == 0)
	{
		return 0;		
	}
	else
		return -1;
	
}
int ImpScanExpFile(HANDLEPTR*handle,char *dirpath,char * utype,char *curuser,int *importCode)
{
	T_CmdParse *ptParse = *handle;
	T_CmdParam *ptCmdParam = NULL;
	T_valuelist *ptValue = NULL;
	char connstr[2048];
	char tbname[MAX_DBNAME_LEN + 1];
	int rc = 0;
	DIR * dir = NULL;
	struct dirent * ptr = NULL;
	
	if(!handle||!(*handle)||!dirpath)
		return -1;

	//file
	ptCmdParam = &ptParse->ptCmdParam[TOKEN_ID_FILE];

	if(ptCmdParam&&(ptCmdParam->paramnum == 1))
	{
		ptValue = ptCmdParam->valueslist;
	}

	if((dir = opendir(ptValue->paramvalue)) == NULL)
	{
		rc = -1;
		goto EXIT;
	}

	while((ptr = readdir(dir)) !=NULL)
	{
		if((strcmp(ptr->d_name,".") == 0)||(strcmp(ptr->d_name,"..") == 0))
			continue;
		else if(ptr->d_type == 8)
		{
			rc = GetTbNameFromPath(ptr->d_name);
			if(rc == 0)
			{
			      //ļ
				if(ptParse->user)
				{
					sprintf(connstr,"%s/%s.exp/%s.sql",ptValue->paramvalue, dirpath,dirpath);
					sprintf(dbtooldir,"%s/%s.exp",ptValue->paramvalue, dirpath);
				}
				else
				{
					impprintf("import failed !\n");
					rc = -1;
					goto EXIT;
				}
				if(sqlfile)
				{
					fclose(sqlfile);
					sqlfile = NULL;
				}				
				//ļ
				if (!(sqlfile = fopen(connstr, "r")))
				{//scan sql file
					continue;
				}
				else
				{
					rc = importopt(ptParse->user,NULL,curuser,utype,NULL,0,0);
					if(rc)
					{
						rc = -1;
						//**
					}		
					else
					{
						*importCode = 0;
					}
				}			
			}
			else
			{
				continue;
			}
		}
		else if(ptr->d_type = 10)
			continue;
		else if(ptr->d_type == 4)
			continue;
	}
	closedir(dir);


EXIT:
	if(sqlfile)
		fclose(sqlfile);
	sqlfile = NULL;
	if(dir)
		closedir(dir);	
	dir = NULL;
	return rc;	
}

int ImpDoFull(HANDLEPTR*handle,char * utype,char *curuser,int *importCode)
{
	T_CmdParse *ptParse = *handle;
	T_CmdParam *ptCmdParam = NULL;
	T_valuelist *ptValue = NULL;
	char connstr[2048];
	int cmdtype = 0;
	char dbname[MAX_DBNAME_LEN + 1];
	int rc = 0;
	DIR * dir = NULL;
	struct dirent * ptr = NULL;
	
	if(!handle||!(*handle))
		return -1;

	//file
	ptCmdParam = &ptParse->ptCmdParam[TOKEN_ID_FILE];

	if(ptCmdParam&&(ptCmdParam->paramnum == 1))
	{
		ptValue = ptCmdParam->valueslist;
	}

	if((dir = opendir(ptValue->paramvalue)) == NULL)
	{
		rc = -1;
		goto EXIT;
	}

	while((ptr = readdir(dir)) !=NULL)
	{
		if((strcmp(ptr->d_name,".") == 0)||(strcmp(ptr->d_name,"..") == 0))
			continue;
		else if(ptr->d_type == 8)
			continue;
		else if(ptr->d_type = 10)
			continue;
		else if(ptr->d_type == 4)
		{
			rc = GetDbNameFromPath(ptr->d_name,dbname);
			if(rc)
			{
				continue;
			}
			else
			{
			      //ļ
				if(ptParse->user)
				{
					sprintf(connstr,"%s/%s.exp/%s.sql",ptValue->paramvalue, dbname,dbname);
					sprintf(dbtooldir,"%s/%s.exp",ptValue->paramvalue, dbname);
				}
				else
				{
					impprintf("import failed !\n");
					return -1;
				}
				if(sqlfile)
				{
					fclose(sqlfile);
					sqlfile = NULL;
				}				
				//ļ
				if (!(sqlfile = fopen(connstr, "r")))
				{//scan sql file
					rc = ImpScanExpFile(handle,dbname,utype,curuser,importCode);
				}
				else
				{
					rc = importopt(ptParse->user,NULL,curuser,utype,NULL,0,0);
					if(rc)
					{
						rc = -1;
						//**
					}			
					else
					{
						*importCode = 0;
					}
				}
			}
			
		}
		else
		{
			exit(-1);
		}
	}


EXIT:	
	if(sqlfile)
		fclose(sqlfile);
	sqlfile = NULL;
	if(dir)
		closedir(dir);	
	dir = NULL;
	return rc;	
		
	
}

int ImpDoDbsUser(HANDLEPTR*handle,char * utype,char *curuser,int *importCode)
{
	//
	T_CmdParse *ptParse = *handle;
	T_CmdParam *ptCmdParam = NULL;
	T_valuelist *ptValue = NULL;
	char connstr[2048];
	int cmdtype = 0;
	int rc = 0;
	if(!handle||!(*handle))
		return -1;

	//file
	ptCmdParam = &ptParse->ptCmdParam[TOKEN_ID_FILE];

	if(ptCmdParam&&(ptCmdParam->paramnum == 1))
	{
		ptValue = ptCmdParam->valueslist;
	}
        //ļ
	if(ptParse->user&&ptValue)
	{
		sprintf(connstr,"%s/%s.exp/%s.sql",ptValue->paramvalue, ptParse->user,ptParse->user);
		sprintf(dbtooldir,"%s/%s.exp",ptValue->paramvalue, ptParse->user);
	}
	else
	{
		impprintf("import failed !\n");
		return -1;
	}
	if(sqlfile)
	{
		fclose(sqlfile);
		sqlfile = NULL;
	}	
	//ļ
	if (!(sqlfile = fopen(connstr, "r")))
	{
		impprintf("cannot open the file %s\n",connstr);
		return -1;	
	}

	rc = importopt(ptParse->user,NULL,curuser,utype,NULL,0,0);
	if(rc)
	{
		rc = -1;
		goto EXIT;
	}

EXIT:	
	if(sqlfile)
		fclose(sqlfile);
	sqlfile = NULL;

	return rc;
}

int ImpDoDbsFromUser(HANDLEPTR*handle,char * utype,char *curuser,int *importCode)
{
	//
	T_CmdParse *ptParse = *handle;
	T_CmdParam *ptCmdParam = NULL;
	T_CmdParam *ptCmdFromUser = NULL;	
	T_valuelist *ptValue = NULL;
	T_valuelist *ptValue1 = NULL;
	char connstr[2048];
	int cmdtype = 0;
	int rc = 0;
	int loop = 0;
	
	if(!handle||!(*handle))
		return -1;
	
	*importCode = -1;
	//file
	ptCmdParam = &ptParse->ptCmdParam[TOKEN_ID_FILE];

	if(ptCmdParam&&(ptCmdParam->paramnum == 1))
	{
		ptValue = ptCmdParam->valueslist;
	}
	ptCmdFromUser =  &ptParse->ptCmdParam[TOKEN_ID_FROMUSER];
	ptValue1 = ptCmdFromUser->valueslist;
	for(loop= 0;loop < ptCmdFromUser->paramnum;loop++)
	{
		
		if(ptValue1->repeat)
		{
			impprintf("cannot open the file ,repeat imp %s\n",connstr);
			sprintf(ptParse->Errmsg,"database imp one time!",ptValue1->paramvalue);				
			impprintf("%s\n",ptParse->Errmsg);
			
			ptValue1 = ptValue1->next;

			continue;
		}		
	        //ļ
		if(ptParse->user&&ptValue&&ptValue1)
		{
			sprintf(connstr,"%s.tar/%s.exp/%s.sql",ptValue->paramvalue,ptValue1->paramvalue,ptValue1->paramvalue);
			sprintf(dbtooldir,"%s.tar/%s.exp",ptValue->paramvalue, ptValue1->paramvalue);			
		}
		else
		{
			printf("import failed !\n");
			rc = -1;
			goto EXIT;
		}

		//ļ
		if(sqlfile)
		{
			fclose(sqlfile);
			sqlfile = NULL;
		}
		if (!(sqlfile = fopen(connstr, "r")))
		{
			impprintf("cannot open the file %s\n",connstr);
			sprintf(ptParse->Errmsg,"%s not exists!",ptValue1->paramvalue);
			rc =  -1;	
			goto EXIT;
		}
		
		rc = importopt(ptValue1->paramvalue,NULL,curuser,utype,NULL,0,0);
		if(rc)
		{
			rc = -1;
			goto EXIT;
		}
		else
		{
			*importCode = 0;//һγɹɹ
		}
		ptValue1 = ptValue1->next;
	}

EXIT:	
	if(sqlfile)
		fclose(sqlfile);
	
	sqlfile = NULL;

	return 0;
}	
	
int ImpDoDbsToUser(HANDLEPTR*handle,char * utype,char *curuser,int *importCode)
{
	//
	T_CmdParse *ptParse = *handle;
	T_CmdParam *ptCmdParam = NULL;
	T_CmdParam *ptCmdFromUser = NULL;	
	T_CmdParam *ptCmdToUser = NULL;	
	T_valuelist *ptValue = NULL;
	T_valuelist *ptValue1 = NULL;
	T_valuelist *ptValue2 = NULL;	
	char connstr[2048];
	int cmdtype = 0;
	int rc = 0;
	int loop = 0;
	
	if(!handle||!(*handle))
		return -1;
	
	*importCode = -1;
	//file
	ptCmdParam = &ptParse->ptCmdParam[TOKEN_ID_FILE];

	if(ptCmdParam&&(ptCmdParam->paramnum == 1))
	{
		ptValue = ptCmdParam->valueslist;
	}
	ptCmdFromUser =  &ptParse->ptCmdParam[TOKEN_ID_FROMUSER];
	ptCmdToUser	 =   &ptParse->ptCmdParam[TOKEN_ID_TOUSERS];
	
	ptValue1 = ptCmdFromUser->valueslist;
	ptValue2 = ptCmdToUser->valueslist;	
	for(loop= 0;loop < ptCmdFromUser->paramnum;loop++)
	{
		impprintf("ptValue1->repeat %d ,%s\n",ptValue1->repeat,ptValue1->paramvalue);
		if(ptValue1->repeat)
		{
			impprintf("cannot open the file ,repeat imp %s\n",connstr);
			sprintf(ptParse->Errmsg,"database imp one time!",ptValue1->paramvalue);				
			impprintf("%s\n",ptParse->Errmsg);
			
			ptValue1 = ptValue1->next;
			ptValue2 = ptValue2->next;		
			continue;
		}		
	        //ļ
		if(ptParse->user&&ptValue&&ptValue1&&ptValue2)
		{
			sprintf(connstr,"%s.tar/%s.exp/%s.sql",ptValue->paramvalue,ptValue1->paramvalue,ptValue1->paramvalue);
			sprintf(dbtooldir,"%s.tar/%s.exp",ptValue->paramvalue, ptValue1->paramvalue);					
		}
		else
		{
			impprintf("import param error.import failed !\n");
			rc = -1;
			goto EXIT;
		}

		//ļ
		if(sqlfile)
		{
			fclose(sqlfile);
			sqlfile = NULL;
		}
		if (!(sqlfile = fopen(connstr, "r")))
		{
			impprintf("cannot open the file %s\n",connstr);
			rc =  -1;	
			goto EXIT;
		}
		
		rc = importopt(ptValue2->paramvalue,NULL,curuser,utype,NULL,0,0);
		if(rc)
		{
			rc = -1;
			goto EXIT;
		}
		else
		{
			*importCode = 0;//һγɹɹ
		}
		ptValue1 = ptValue1->next;
		ptValue2 = ptValue2->next;
	}

EXIT:	
	if(sqlfile)
		fclose(sqlfile);
	
	sqlfile = NULL;

	return 0;
}		
int ImpDoDbsToUserB(HANDLEPTR*handle,char * utype,char *curuser,int *importCode)
{
	//
	T_CmdParse *ptParse = *handle;
	T_CmdParam *ptCmdParam = NULL;
	T_CmdParam *ptCmdFromUser = NULL;	
	T_CmdParam *ptCmdToUser = NULL;	
	T_valuelist *ptValue = NULL;
	T_valuelist *ptValue1 = NULL;
	T_valuelist *ptValue2 = NULL;	
	char connstr[2048];
	int cmdtype = 0;
	int rc = 0;
	int loop = 0;
	
	if(!handle||!(*handle))
		return -1;
	
	*importCode = -1;
	//file
	ptCmdParam = &ptParse->ptCmdParam[TOKEN_ID_FILE];

	if(ptCmdParam&&(ptCmdParam->paramnum == 1))
	{
		ptValue = ptCmdParam->valueslist;
	}
	ptCmdFromUser =  &ptParse->ptCmdParam[TOKEN_ID_FROMUSER];
	ptCmdToUser	 =   &ptParse->ptCmdParam[TOKEN_ID_TOUSERS];
	
	ptValue1 = ptCmdFromUser->valueslist;
	ptValue2 = ptCmdToUser->valueslist;	
	for(loop= 0;loop < ptCmdFromUser->paramnum;loop++)
	{

		impprintf("ptValue1->repeat %d ,%s\n",ptValue1->repeat,ptValue1->paramvalue);
		if(ptValue1->repeat)
		{
			impprintf("cannot open the file ,repeat imp %s\n",connstr);
			sprintf(ptParse->Errmsg,"database imp one time!",ptValue1->paramvalue);				
			impprintf("%s\n",ptParse->Errmsg);
			
			ptValue1 = ptValue1->next;
			if(ptValue2)
				ptValue2 = ptValue2->next;	
			continue;
		}			
	        //ļ
		if(ptParse->user&&ptValue&&ptValue1)
		{
			sprintf(connstr,"%s.tar/%s.exp/%s.sql",ptValue->paramvalue,ptValue1->paramvalue,ptValue1->paramvalue);
			sprintf(dbtooldir,"%s.tar/%s.exp",ptValue->paramvalue, ptValue1->paramvalue);					
		}
		else
		{
			impprintf("import param error.import failed !\n");
			rc = -1;
			goto EXIT;
		}

		//ļ
		if(sqlfile)
		{
			fclose(sqlfile);
			sqlfile = NULL;
		}
		if (!(sqlfile = fopen(connstr, "r")))
		{
			impprintf("cannot open the file %s\n",connstr);
			rc =  -1;	
			goto EXIT;
		}
		if(ptValue2)
			rc = importopt(ptValue2->paramvalue,NULL,curuser,utype,NULL,0,0);
		else
			rc = importopt(ptValue1->paramvalue,NULL,curuser,utype,NULL,0,0);
		if(rc)
		{
			rc = -1;
			goto EXIT;
		}
		else
		{
			*importCode = 0;//һγɹɹ
		}
		ptValue1 = ptValue1->next;
		if(ptValue2)
			ptValue2 = ptValue2->next;
	}

EXIT:	
	if(sqlfile)
		fclose(sqlfile);
	
	sqlfile = NULL;

	return 0;
}	
int ImpDoTablesUser(HANDLEPTR*handle,char * utype,char *curuser,int *importCode)
{
	//
	T_CmdParse *ptParse = *handle;
	T_CmdParam *ptCmdParam = NULL;
	T_CmdParam *ptCmdTablesParam = NULL;
	T_valuelist *ptValue = NULL;
	T_valuelist *ptValue1 = NULL;
	char connstr[2048];
	int cmdtype = 0;
	int rc = 0;
	int loop = 0;
	
	if(!handle||!(*handle))
		return -1;

	*importCode  = -1;
	//file
	ptCmdParam = &ptParse->ptCmdParam[TOKEN_ID_FILE];

	if(ptCmdParam&&(ptCmdParam->paramnum == 1))
	{
		ptValue = ptCmdParam->valueslist;
	}
	ptCmdTablesParam = &ptParse->ptCmdParam[TOKEN_ID_TABLES];
		ptValue1 = ptCmdTablesParam->valueslist;	
	for(loop = 0;loop < ptCmdTablesParam->paramnum;loop ++)
	{

	        //ļ
		if(ptParse->user&&ptValue&&ptValue1)
		{
			sprintf(connstr,"%s.tar/%s.exp/%s.sql",ptValue->paramvalue, ptParse->user,ptValue1->paramvalue);
			sprintf(dbtooldir,"%s.tar/%s.exp",ptValue->paramvalue, ptParse->user);				
		}
		else
		{
			impprintf("import failed !\n");
			return -1;
		}
		//ļ
		if(sqlfile)
		{
			fclose(sqlfile);
			sqlfile = NULL;
		}		
		//ļ
		if (!(sqlfile = fopen(connstr, "r")))
		{
			impprintf("cannot open the file %s\n",connstr);
			return -1;	
		}
		
		rc = importopt(ptParse->user,NULL,curuser,utype,NULL,0,0);
		if(rc)
		{
			rc = -1;
			goto EXIT;
		}
		else
		{
			*importCode = 0; 
		}
		ptValue1 = ptValue1->next;
	}
EXIT:	
	if(sqlfile)
		fclose(sqlfile);
	sqlfile = NULL;
	
	*importCode = rc; //ӿֻһ˲
	return rc;

	return 0;
}
int ImpDoTablesFromUser(HANDLEPTR*handle,char * utype,char *curuser,int *importCode)
{
	//
	T_CmdParse *ptParse = *handle;
	T_CmdParam *ptCmdParam = NULL;
	T_CmdParam *ptCmdFromUser = NULL;	
	T_CmdParam *ptCmdTables = NULL;		
	T_valuelist *ptValue = NULL;
	T_valuelist *ptValue1 = NULL;
	T_valuelist *ptValue2 = NULL;
	char connstr[2048];
	int cmdtype = 0;
	int rc = 0;
	int loop = 0;
	int loop1= 0;	
	
	if(!handle||!(*handle))
		return -1;
	
	*importCode = -1;
	//file
	ptCmdParam = &ptParse->ptCmdParam[TOKEN_ID_FILE];

	if(ptCmdParam&&(ptCmdParam->paramnum == 1))
	{
		ptValue = ptCmdParam->valueslist;
	}
	ptCmdFromUser =  &ptParse->ptCmdParam[TOKEN_ID_FROMUSER];
	ptCmdTables =   &ptParse->ptCmdParam[TOKEN_ID_TABLES];
	ptValue1 = ptCmdFromUser->valueslist;
	for(loop= 0;loop < ptCmdFromUser->paramnum;loop++)
	{
		impprintf("ptValue1->repeat %d ,%s\n",ptValue1->repeat,ptValue1->paramvalue);
		if(ptValue1->repeat)
		{
			impprintf("cannot open the file ,repeat imp %s\n",connstr);
			sprintf(ptParse->Errmsg,"database imp one time!",ptValue1->paramvalue);				
			impprintf("%s\n",ptParse->Errmsg);
			
			ptValue1 = ptValue1->next;
			continue;
		}	
	       	ptValue2 = ptCmdTables->valueslist;
	        //ļ
	        for(loop1= 0;loop1 < ptCmdTables->paramnum;loop1++)
	        {

			if(ptParse->user&&ptValue&&ptValue1)
			{
				sprintf(connstr,"%s.tar/%s.exp/%s.sql",ptValue->paramvalue,ptValue1->paramvalue,ptValue2->paramvalue);
				sprintf(dbtooldir,"%s.tar/%s.exp",ptValue->paramvalue, ptValue1->paramvalue);						
			}
			else
			{
				impprintf("import failed !\n");
				rc = -1;
				goto EXIT;
			}
			//ļ
			if(sqlfile)
			{
				fclose(sqlfile);
				sqlfile = NULL;
			}
			if (!(sqlfile = fopen(connstr, "r")))
			{
				impprintf("cannot open the file %s\n",connstr);
				rc =  -1;	
				goto EXIT;
			}
			
			rc = importopt(ptParse->user,NULL,curuser,utype,NULL,0,0);
			if(rc)
			{
				rc = -1;
				goto EXIT;
			}
			else
			{
				*importCode = 0;//һγɹɹ
			}
			ptValue2 = ptValue2->next;
	        }
		ptValue1 = ptValue1->next;

	}

EXIT:	
	if(sqlfile)
		fclose(sqlfile);
	
	sqlfile = NULL;

	return 0;
}

char *GetFileDir(HANDLEPTR*handle)
{
	T_CmdParse *ptParse = *handle;
	T_valuelist *ptValue = NULL;
	T_CmdParam *ptCmdParam = NULL;
	
	if(!handle||!(*handle))
		return NULL;
	
	ptCmdParam = &ptParse->ptCmdParam[TOKEN_ID_FILE];	
	if(ptCmdParam&&(ptCmdParam->paramnum == 1))
	{
		ptValue = ptCmdParam->valueslist;
	}
	else
	{
		ptValue = NULL;
	}

	if(ptValue&&ptValue->paramvalue&&strlen(ptValue->paramvalue))
	{
		return ptValue->paramvalue;
	}
	else
	{
		return NULL;
	}
}

ImpDoTablesToUser(HANDLEPTR*handle,int utype,char curuser,int *importCode)
{

	T_CmdParse *ptParse = *handle;
	T_CmdParam *ptCmdParam = NULL;
	T_CmdParam *ptCmdFromUser = NULL;	
	T_CmdParam *ptCmdToUser = NULL;	
	T_CmdParam *ptCmdTables = NULL;		
	T_valuelist *ptValue = NULL;
	T_valuelist *ptValue1 = NULL;
	T_valuelist *ptValue2 = NULL;	
	T_valuelist *ptValue3 = NULL;	
	char connstr[2048];
	int cmdtype = 0;
	int rc = 0;
	int loop = 0;
	int loop1 = 0;
	
	if(!handle||!(*handle))
		return -1;
	
	*importCode = -1;
	//file
	ptCmdParam = &ptParse->ptCmdParam[TOKEN_ID_FILE];

	if(ptCmdParam&&(ptCmdParam->paramnum == 1))
	{
		ptValue = ptCmdParam->valueslist;
	}
	ptCmdFromUser =  &ptParse->ptCmdParam[TOKEN_ID_FROMUSER];
	ptCmdToUser	 =   &ptParse->ptCmdParam[TOKEN_ID_TOUSERS];
	ptCmdTables = &ptParse->ptCmdParam[TOKEN_ID_TABLES];

	ptValue1 = ptCmdFromUser->valueslist;
	ptValue2 = ptCmdToUser->valueslist;
	for(loop= 0;loop < ptCmdFromUser->paramnum;loop++)
	{
		if(!ptValue1||!ptValue2||!ptValue)
		{
			impprintf("import ok!\n");
			rc = -1;
			goto EXIT;
		}
		impprintf("ptValue1->repeat %d ,%s\n",ptValue1->repeat,ptValue1->paramvalue);
		if(ptValue1->repeat)
		{
			impprintf("cannot open the file ,repeat imp %s\n",connstr);
			sprintf(ptParse->Errmsg,"database imp one time!",ptValue1->paramvalue);				
			impprintf("%s\n",ptParse->Errmsg);
			
			ptValue1 = ptValue1->next;
			ptValue2 = ptValue2->next;
			continue;
		}	
		
		for(loop1 = 0;loop1 < ptCmdTables->paramnum;loop1++)
		{
			ptValue3  = ptCmdTables->valueslist;
			//ļ
			if(ptParse->user&&ptValue&&ptValue1&&ptValue2&&ptValue3)
			{
				sprintf(connstr,"%s.tar/%s.exp/%s.sql",ptValue->paramvalue,ptValue1->paramvalue,ptValue3->paramvalue);
				
			}
			else
			{
				impprintf("import param error.import failed !\n");
				rc = -1;
				goto EXIT;
			}
			//ļ
			if(sqlfile)
			{
				fclose(sqlfile);
				sqlfile = NULL;
			}
			if (!(sqlfile = fopen(connstr, "r")))
			{
				impprintf("cannot open the file %s\n",connstr);
				rc =  -1;	
				goto EXIT;
			}
			
			rc = importopt(ptValue2->paramvalue,NULL,curuser,utype,NULL,0,0);
			if(rc)
			{
				rc = -1;
				goto EXIT;
			}
			else
			{
				*importCode = 0;//һγɹɹ
			}
			ptValue3 = ptValue3->next;
		}
		ptValue1 = ptValue1->next;
		ptValue2 = ptValue2->next;
	}

EXIT:	
	if(sqlfile)
		fclose(sqlfile);
	
	sqlfile = NULL;
	return 0;
}
int ImpDoTablesToUserB(HANDLEPTR*handle,int utype,char curuser,int *importCode)
{

	T_CmdParse *ptParse = *handle;
	T_CmdParam *ptCmdParam = NULL;
	T_CmdParam *ptCmdFromUser = NULL;	
	T_CmdParam *ptCmdToUser = NULL;	
	T_CmdParam *ptCmdTables = NULL;		
	T_valuelist *ptValue = NULL;
	T_valuelist *ptValue1 = NULL;
	T_valuelist *ptValue2 = NULL;	
	T_valuelist *ptValue3 = NULL;	
	char connstr[2048];
	int cmdtype = 0;
	int rc = 0;
	int loop = 0;
	int loop1 = 0;
	
	if(!handle||!(*handle))
		return -1;
	
	*importCode = -1;
	//file
	ptCmdParam = &ptParse->ptCmdParam[TOKEN_ID_FILE];

	if(ptCmdParam&&(ptCmdParam->paramnum == 1))
	{
		ptValue = ptCmdParam->valueslist;
	}
	ptCmdFromUser =  &ptParse->ptCmdParam[TOKEN_ID_FROMUSER];
	ptCmdToUser	 =   &ptParse->ptCmdParam[TOKEN_ID_TOUSERS];
	ptCmdTables = &ptParse->ptCmdParam[TOKEN_ID_TABLES];

	ptValue1 = ptCmdFromUser->valueslist;
	ptValue2 = ptCmdToUser->valueslist;
	for(loop= 0;loop < ptCmdFromUser->paramnum;loop++)
	{

		if(!ptValue1||!ptValue)
		{
			impprintf("import ok!\n");
			rc = -1;
			
			goto EXIT;
		}
		impprintf("ptValue1->repeat %d ,%s\n",ptValue1->repeat,ptValue1->paramvalue);
		if(ptValue1->repeat)
		{
			impprintf("cannot open the file ,repeat imp %s\n",connstr);
			sprintf(ptParse->Errmsg,"database imp one time!",ptValue1->paramvalue);				
			impprintf("%s\n",ptParse->Errmsg);
			
			ptValue1 = ptValue1->next;
			if(ptValue2)
				ptValue2 = ptValue2->next;
			continue;
		}	

		ptValue3  = ptCmdTables->valueslist;			//ļ	
		for(loop1 = 0;loop1 < ptCmdTables->paramnum;loop1++)
		{
			if(ptParse->user&&ptValue&&ptValue1&&ptValue3)
			{
				sprintf(connstr,"%s.tar/%s.exp/%s.sql",ptValue->paramvalue,ptValue1->paramvalue,ptValue3->paramvalue);
				
			}
			else
			{
				impprintf("import param error.import failed !\n");
				rc = -1;
				goto EXIT;
			}
			//ļ
			if(sqlfile)
			{
				fclose(sqlfile);
				sqlfile = NULL;
			}
			if (!(sqlfile = fopen(connstr, "r")))
			{
				impprintf("cannot open the file %s\n",connstr);
				rc =  -1;	
				goto EXIT;
			}
			if(ptValue2)
				rc = importopt(ptValue2->paramvalue,NULL,curuser,utype,NULL,0,0);
			else
				rc = importopt(ptValue1->paramvalue,NULL,curuser,utype,NULL,0,0);
			if(rc)
			{
				rc = -1;
				goto EXIT;
			}
			else
			{
				*importCode = 0;//һγɹɹ
			}
			ptValue3 = ptValue3->next;
		}
		ptValue1 = ptValue1->next;
		if(ptValue2)
			ptValue2 = ptValue2->next;
	}

EXIT:	
	if(sqlfile)
		fclose(sqlfile);
	
	sqlfile = NULL;
	return 0;
}

int IMPCmdDo(HANDLEPTR*handle,char * utype,char *curuser,int *importCode)
{
	int rc = 0;
	T_CmdParse *ptParse = *handle;
	char connstr[128];
	int cmdtype = 0;
	T_valuelist *ptvalue = NULL;
	DIR * dir = NULL;
	struct dirent * ptr = NULL;
	int ret = 0;
	
	if(!handle||!(*handle))
		return -1;

	//tar -xf $file -C $file.tar
	ptvalue = ptParse->ptCmdParam[TOKEN_ID_FILE].valueslist;
	char temp[1024];
	if(ptvalue&&ptvalue->paramvalue)
		sprintf(temp,"%s.tar",ptvalue->paramvalue);
	else
		return -1;
	
       	if ((dir = opendir(ptvalue->paramvalue)) == NULL)
	{
		sprintf(temp,"mkdir %s.tar",ptvalue->paramvalue);
		impprintf("%s\n",temp);

  	        ret  = system(temp);
		if (ret)
		{
			sprintf(ptParse->Errmsg,"Can not open the file %s\n",ptvalue->paramvalue);
			return -1;
		}
				
		sprintf(temp,"tar -xf %s -C %s.tar ",ptvalue->paramvalue,ptvalue->paramvalue);
		printf("%s\n",temp);

               ret = system(temp);
	        if(ret)
			printf("rc 1 %d\n",rc);
		printf("rc  %d\n",rc);			
	}
	else
	{
		closedir(dir);
		dir = NULL;
	}	
	
	//鿴Ƿfull
	cmdtype = CMD_TYPE_INVALID;
	//жtablesfromuser &touser
	if(ptParse->ptCmdParam[TOKEN_ID_FULL].paramnum)
	{//жǷΪY
		if(stricmp(ptParse->ptCmdParam[TOKEN_ID_FULL].valueslist->paramvalue,"Y") == 0)
		{
			cmdtype = CMD_TYPE_FULL;
		}
		else
		{
			cmdtype = CMD_TYPE_INVALID;
		}
	}
	if(cmdtype == CMD_TYPE_FULL)
	{
	}
	else if(ptParse->ptCmdParam[TOKEN_ID_TABLES].paramnum == 0)
	{
		if((ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum == 0)&&(ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum  == 0))
		{
			cmdtype = CMD_TYPE_DBS_USER;//ʹuserΪdb
		}
		else	if(ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum == 0)
		{
			cmdtype = CMD_TYPE_DBS_FROMUSER;//û
		}
		else if(ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum == 0)
		{
			rc =-1;
			strcpy(ptParse->Errmsg,"fromuser must set ,if set the touser !");
			goto EXIT;
		}
		else if(ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum == ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum)
		{
			cmdtype = CMD_TYPE_DBS_TOUSER;//û			
		}
		else if(ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum)
		{
			cmdtype = CMD_TYPE_DBS_FROMUSER_B;	
		}				
		else
		{
			cmdtype = CMD_TYPE_DBS_TOUSER;//û		
		}
	}
	else
	{
		if((ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum == 0)&&(ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum  == 0))
		{
			cmdtype = CMD_TYPE_TABLES_USER;//ʹuserΪdb
		}
		else	if(ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum == 0)
		{
			cmdtype = CMD_TYPE_TABLES_FROMUSER;//û
		}
		else if(ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum == 0)
		{
			rc =-1;
			strcpy(ptParse->Errmsg,"fromuser must set ,if set the touser !");
			goto EXIT;
		}
		else if(ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum == ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum)
		{
			cmdtype = CMD_TYPE_TABLES_TOUSER;//û			
		}
		else if(ptParse->ptCmdParam[TOKEN_ID_TOUSERS].paramnum < ptParse->ptCmdParam[TOKEN_ID_FROMUSER].paramnum)
		{
			cmdtype = CMD_TYPE_TABLES_FROMUSER_B;	
		}				
		else
		{
			cmdtype = CMD_TYPE_TABLES_TOUSER;//û		
		}
	}
		
	switch(cmdtype)
	{
	case CMD_TYPE_FULL:
		ImpDoFull(handle,utype,curuser,importCode);
		break;
	case CMD_TYPE_DBS_USER:
		ImpDoDbsUser(handle,utype,curuser,importCode);		
		impprintf("entire db import from user db to user\n");		
		break;
	case CMD_TYPE_DBS_FROMUSER:
		ImpDoDbsFromUser(handle,utype,curuser,importCode);				
		impprintf("entire db import from fromdb to fromdb \n");				
		break;
	case CMD_TYPE_DBS_TOUSER:
		ImpDoDbsToUser(handle,utype,curuser,importCode);				
		impprintf("entire db import from fromdb to touser\n");				
		break;
		
	case CMD_TYPE_TABLES_USER:
		ImpDoTablesUser(handle,utype,curuser,importCode);				
		impprintf("tables in db user import from user db to user \n");				
		break;
	case CMD_TYPE_TABLES_FROMUSER:
		ImpDoTablesFromUser(handle,utype,curuser,importCode);						
		impprintf("tables in db fromuser  import from fromuser db to fromuser \n");				
		break;
	case CMD_TYPE_TABLES_TOUSER:
		ImpDoTablesToUser(handle,utype,curuser,importCode);								
		impprintf("tables in db fromuser  import from fromuser db to touser \n");						
		break;		
	case CMD_TYPE_DBS_FROMUSER_B:
		ImpDoDbsToUserB(handle,utype,curuser,importCode);								
		impprintf("tables in db fromuser  import from fromuser db to touser \n");						
		break;	
	case CMD_TYPE_TABLES_FROMUSER_B:
		ImpDoTablesToUserB(handle,utype,curuser,importCode);								
		impprintf("tables in db fromuser  import from fromuser db to touser \n");						
		break;	
		
	default:
		strcpy(ptParse->Errmsg,"unknown cmd!\n");
		break;
		
	}
	
EXIT:	

	return rc;
}
void IMPMemFree(T_CmdToken *tokenarr,int num,HANDLEPTR handle)
{	
	int i = 0;
	for(i = 0;i< num;i++)
	{
		if(tokenarr[i].key)
			free(tokenarr[i].key);
		if(tokenarr[i].paramvalue)
			free(tokenarr[i].paramvalue);
		tokenarr[i].key = 0;
		tokenarr[i].paramvalue = 0;
	}
	CmdParseFree(&handle);
}

int IMPCmdCheck(HANDLEPTR*handle)
{
	int loop = 0;
	int i = 0;
	T_CmdParse *ptParse = *handle;
	T_valuelist *ptvalue = NULL;

	int rc = 0;
	
	if(!handle||!(*handle))
		return -1;

	for(i = 1;i < ptParse->paramnum;i++)
	{
		if(g_atCmdDesc[i].cmdshenglue)
		{
			continue;
		}
		else
		{
			if((ptParse->ptCmdParam[i].magic == CMD_MAGIC)&&(ptParse->ptCmdParam[i].paramnum> 0))
			{
				continue;
			}
			else
			{
				sprintf(ptParse->Errmsg,"the key [%s] not exists!%d %d\n",g_atCmdDesc[i].cmdname,i,ptParse->paramnum);
				return -1;
			}
		}
	}

			
	for(i = 1;i < ptParse->paramnum;i++)
	{
		if(ptParse->ptCmdParam[i].paramnum)	
		{
			if(g_atCmdDesc[i].checkcontext&&(ptParse->ptCmdParam[i].magic == CMD_MAGIC))
			{
				ptvalue = ptParse->ptCmdParam[i].valueslist;
				rc = g_atCmdDesc[i].checkcontext(ptvalue,i,handle);
				if(rc)
				{
					return rc;
				}
			}
		}
	}

	return 0;
}
int IMPCmdParse(T_CmdToken *pttoken,int tokencount,HANDLEPTR*handle)
{
	int loop = 0;
	int i = 0;
	T_CmdParse *ptParse = *handle;
	T_valuelist *ptvalue = NULL;
	int rc = 0;
	for(loop = 0 ;loop <tokencount;loop++ )
	{
		for(i = 0;i < ptParse->paramnum;i++)
		{
			if(0 == stricmp(pttoken[loop].key,CMDTOKEN[i]))
			{
				if ((loop+1) == tokencount)
				{
					ptParse->ptCmdParam[i].islast = 1;
					printf("last key %d %d %d\n",i,loop,tokencount);
				}
				else
				{
					ptParse->ptCmdParam[i].islast = 0;
				}
				ptParse->ptCmdParam[i].repeatnum++;
				if(ptParse->ptCmdParam[i].repeatnum > 1)
				{
					sprintf(ptParse->Errmsg,"%s set repeat %d!\n",g_atCmdDesc[i].cmdname,ptParse->ptCmdParam[i].repeatnum );
					return -1;
				}
				impprintf("cmd key %s %d %s %d\n",pttoken[loop].key,strlen(pttoken[loop].key),CMDTOKEN[i],strlen(CMDTOKEN[i]));			
				
				switch(i)
				{
				case 0:
					//no userid
					break;
				case 1://file,only one
					rc = parsefile(pttoken[loop].paramvalue,1,handle);
					break;
				case 2://buffer no opt
					rc = parsecharvalue(pttoken[loop].paramvalue,2,handle);
					break;
				case 3://indexes always yes
					rc = parseboolvalue(pttoken[loop].paramvalue,3,handle);
					break;
				case 4://rows always yes
					rc = 	parseboolvalue(pttoken[loop].paramvalue,4,handle);		
					break;
				case 5://ignore always yes
					rc = parseboolvalue(pttoken[loop].paramvalue,5,handle);
					break;
				case 6://log path
					rc = parsefromuser(pttoken[loop].paramvalue,6,handle);
					break;
				case 7://statistics ..no opt
					rc = parsefromuser(pttoken[loop].paramvalue,7,handle);
					break;
				case 8://tables	 multi
					rc = parsetables(pttoken[loop].paramvalue,8,handle);				
					break;
				case 9://full
					rc = parseboolvalue(pttoken[loop].paramvalue,9,handle);
					break;
				case 10://fromuser
					rc = parsefromuser(pttoken[loop].paramvalue,10,handle);					
					break;
				case 11://touser
					rc = parsefromuser(pttoken[loop].paramvalue,11,handle);					
					break;
				case 12://constraints,always yes
					rc = parseboolvalue(pttoken[loop].paramvalue,12,handle);					
					break;
				default:
					break;
				}
				if(rc)
				{
					impprintf("++++++++++++++\n");
					return rc;
				}
				if(g_atCmdDesc[i].checkfunc)
				{
					rc = g_atCmdDesc[i].checkfunc(ptParse->ptCmdParam[i].valueslist,i,handle);
					if(rc)
					{
						impprintf("++++++++++++++ check failed\n");
						return -1;	
					}
				}
				break;
			}
		}
		if(i == ptParse->paramnum)
		{
			sprintf(ptParse->Errmsg,"cannot support the key %s\n",pttoken[loop].key);
			return -1;
		}
	}
	rc = IMPCmdCheck(handle);
	return rc;
}

int main (long argc,
		char* argv[])
{
	int			i, in;
	HANDLEPTR handle = 0;
	T_CmdParse *ptParse = NULL;
	char *ap = NULL;
	char *ptr = NULL;
	char *pos1 = NULL;
	int loop = 0;
	int state = 0;
	int arglen = 0;
	in = sizeof(CMDTOKEN)/MAX_NAME_LEN;
	T_CmdToken *tokenarr = NULL;
	char utype;
	char curuser[128];
	char connstr[256];
	
	int importCode;

	
	CmdParseInit(in,&handle);
	ptParse = (T_CmdParse *)handle;
	int rc = 0;
   	//first is the userid
	tokenarr = ptParse->tokenarr;
	memset((char *)tokenarr,0,sizeof(tokenarr));
	ap = argv[1];
	arglen = strlen(argv[1]);		
	impprintf("argv 1 len %d,argv 1 %s\n",arglen,argv[1]);
	while(1)
	{
		if(ap > (argv[1] + arglen))
		{
			impprintf("state %ld %ld\n",ap,argv[1] + arglen);
			if(1 == state)
			{
				ptParse->password[loop]	 = '\0';
				if(strlen(ptParse->password)&&strlen(ptParse->user))
				{
					break;
				}
				else
				{
					strcpy(ptParse->Errmsg,"passwor or user is null!\n");
					return -1;
				}
			}
			else if(2 == state)
			{
				ptParse->servername[loop] = '\0';
				if(strlen(ptParse->user)&&strlen(ptParse->password))
				{
					break;
				}
				else
				{
					strcpy(ptParse->Errmsg,"passwor or user is null!\n");				
					return -1;
				}				
			}
			else if(0 == state)
			{
				strcpy(ptParse->Errmsg,"userid format is user/password@servername!\n");			
				return -1;
			}
			else if(3 == state)
			{
				if(strlen(ptParse->servername)&&strlen(ptParse->user)&&strlen(ptParse->password))
				{
					break;
				}
				else
				{
					strcpy(ptParse->Errmsg,"servername passwor or user is null!\n");				
					return -1;
				}
			}
			else
			{
				strcpy(ptParse->Errmsg,"userid format is user/password@servername!\n");
				return -1;
			}
		}
		switch(state)
		{
		case 0:
			if(loop >= MAX_USER_LEN)
			{
				strcpy(ptParse->Errmsg,"error :the user name length > 64!\n");
				return -1;
			}
			if((*ap != '/')&&(*ap != ' ')&&(ap != (argv[1] + arglen)))
			{
				ptParse->user[loop]	 = *ap;
				loop ++;
			}
			else
			{
				ptParse->user[loop]	 = '\0';
				state = 1;
				loop = 0;
			}

			ap++;				
			break;
		case 1:
			if(loop >= MAX_PASS_LEN)
			{
				strcpy(ptParse->Errmsg,"error :the password length > 64!\n");
				return -1;
			}

			if((*ap != '@')&&(*ap != ' ')&&(ap != (argv[1] + arglen)))
			{
				ptParse->password[loop]	 = *ap;
				loop ++;
			}
			else
			{
				ptParse->password[loop]	 = '\0';
				state = 2;
				loop = 0;
			}

			ap++;
			break;
		case 2:
			if(loop >= MAX_SERVER_LEN)
			{
				strcpy(ptParse->Errmsg,"error :the server name length > 64!\n");
				return -1;
			}
			if((ap < (argv[1] + arglen))&&(*ap != ' '))
			{
				ptParse->servername[loop]	 = *ap;
				loop ++;
			}
			else
			{
				ptParse->servername[loop]	 = '\0';
				state = 3;
				loop = 0;
			}
			ap++;				
			break;
		}
			
	}
		
	impprintf("user : %s \npassword: %s \nservername %s\n",ptParse->user,ptParse->password,ptParse->servername);
	#define CMD_LINE_MAX 2018
    char cmdline[CMD_LINE_MAX] = {0};
	FILE *fp = stdout;
	fprintf(stdout,"test fprintf\n");
	fprintf(fp,"test fprintf\n");
    arglen = 0;
    for (i = 2; i < argc; i++)
    {
    	sprintf(&cmdline[arglen]," %s",argv[i]);
    	arglen += strlen(argv[i]);	
	arglen ++;
    } 
    if(arglen >= CMD_LINE_MAX)
    {
	impprintf("cmd line too long >2018 %d\n",arglen);
	return -1;
    }

    impprintf("cmd line  %s argc %d %d\n",cmdline,argc,arglen);

    //for(i = 0;i < arglen;i++)
    if(strlen(cmdline) == 0)
		return 0;
		
	ap = cmdline;
	char *pos = 0;
	char * ptr1 = NULL;
	pos1 = NULL;
	int tokenpos = 0;

	ptr = findequalkey(ap,arglen,&pos,&pos1);
	if (ptr&&(ptr > cmdline))
	{
		ptr --;
		while(ptr)
		{	
			if (*ptr == ' ')
			{
				ptr --;
				break;
			}
			else if (ptr == cmdline)
			{
				break;
			}
			else
			{
				strcpy(ptParse->Errmsg,"invalid characator between userid and the key");
				printf("%s\n",ptParse->Errmsg);
				return -1;
			}
			
		}
	}
	else
	{
		strcpy(ptParse->Errmsg,"no key param!\n");
		printf("%s\n",ptParse->Errmsg);
	
		return -1;
	}
	ptr = NULL;
	pos = pos1 = NULL;
int 	loop11 = 0;
	while(1)	
	{
		if(tokenpos >= TOKEN_ARRAY_NUM)
		{
			strcpy(ptParse->Errmsg,"comand line keys too much!");
			return -1;
		}
		ptr = findequalkey(ap,arglen,&pos,&pos1);
		if(ptr)
		{//key
			if(pos < ptr)
			{
				impprintf("error = pos\n");
				break;
			}
			tokenarr[tokenpos].key = malloc(pos1 - ptr + 1);
			impprintf("%d\n",pos1 - ptr );
			if(tokenarr[tokenpos].key)
			{
				memset(tokenarr[tokenpos].key,0,pos1 - ptr + 1);
				strncpy(tokenarr[tokenpos].key,ptr,pos1 - ptr );
			}
			else
				break;
			pos++;//jump the '='
			if( *pos == '\0')
			{
				impprintf("no value of [%s]\n",tokenarr[tokenpos].key);
				return -1;		
			}
			else
				ptr1 = findequalvalue(pos,(arglen - (pos -ptr) -1),NULL);
			loop11 = 0;
			while (ptr1> (pos + loop11))
			{
				if (*(pos + loop11) == ' ')
				{
					loop11++;
					continue;
				}
				else
					 break;
			}
			
			if (ptr1 == (pos + loop11))
			{
				impprintf("no key value %s,%s\n",ptr1  ,pos);
				return -1;
			}
			if(ptr1)
			{
				tokenarr[tokenpos].paramvalue = malloc(ptr1 - pos + 1);
				if(tokenarr[tokenpos].paramvalue)
				{
					memset(tokenarr[tokenpos].paramvalue,0,ptr1 - pos + 1);
					strncpy(tokenarr[tokenpos].paramvalue,pos,(ptr1 - pos));	
				}
				else
					break;
				ap  = ptr1;
				arglen = arglen - (ptr1 - ap);
				impprintf("%d|%s|%s\n",tokenpos,tokenarr[tokenpos].key,tokenarr[tokenpos].paramvalue);				
				tokenpos++;
			}
			else
			{//no '='
				
				ptr1 = pos + arglen - (pos - ap);//valuetrim(pos,arglen - (pos - ap));
				if(!ptr1)
				{
					tokenarr[tokenpos].paramvalue = NULL;
				}
				else
				{
					tokenarr[tokenpos].paramvalue = malloc((ptr1 - pos ) + 1);
					if(tokenarr[tokenpos].paramvalue)
					{
						memset(tokenarr[tokenpos].paramvalue,0,ptr1 - pos + 1);
						strncpy(tokenarr[tokenpos].paramvalue,pos,( (ptr1 - pos)));	
					}
					else
						break;
				}
				impprintf("end  %d |%s|%s\n",tokenpos,tokenarr[tokenpos].key,tokenarr[tokenpos].paramvalue);
				tokenpos++;
				break;

			}
		}
		else
		{//value
			impprintf("cmd syntax error! \n");
			return -1;
		}

	}

	rc = IMPCmdParse(tokenarr,tokenpos,&handle);
	if(rc)
	{
		impprintf("error :%s \n",ptParse->Errmsg);
		CmdParseFree(&handle);
		goto EXIT;
	}
	//main content
	//*connect db*/
	if(strlen(ptParse->servername))
	{
		sprintf(connstr,"@%s",ptParse->servername);
	}
	else
	{
		sprintf(connstr,"%s",ptParse->user);//LOCAL
	}
	//connect
	
	rc = IMPCmdDo(&handle,&utype,curuser,&importCode);
	if(rc)
	{
		impprintf("IMPCmdDo failed \n");
	}
	//disconnect
	//
EXIT:	
	IMPMemFree(tokenarr,20,handle);
	return (rc);
}

