

/***************************************************************************
 *	Licensed Materials - Property of GBase
 *
 *
 *	"Restricted Materials of GBase"
 *
 *
 *
 *	GBase 8s GCI Interface demo
 *
 *
 *	Copyright GBase Corporation 2015 All rights reserved.
 *
 *
 *
 *
 *
 *  Title:          test_lobproc.c
 *
 *  Description:    To test the operation about the proc
 table desc
 
 *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gci.h"
#define SELSQL_LEN              25
#define ERRMSG_LEN              200
char * procexecsql = "begin testproc; end;";
char * procexecsql1 = "begin testproc1(1); end;";
static unsigned char * SQL_CREATE = (unsigned char *) "CREATE TABLE item ( \
                   item_num    INTEGER primary key,\
                          description VARCHAR(20),\
                          stock        SMALLINT,\
                          ship_unit   VARCHAR(10),\
                          unit_price  DECIMAL(5,2),\
                          advert      VARCHAR(200))";
char * dropproctablesql = "drop table item";

int createtestproctable(GCIEnv * envhp, GCIError * errhp, GCISvcCtx * svchp)
{
    int rc = 0;
    GCIStmt * stmt = NULL;

    if (rc = GCIHandleAlloc((dvoid *) envhp, (dvoid * *) &stmt, 
        GCI_HTYPE_STMT, 0, (dvoid * *) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto createtestproctableEXIT;
    }
    rc = GCIStmtPrepare(stmt, errhp, SQL_CREATE, strlen(SQL_CREATE) + 1, 0, GCI_DEFAULT);
    if (GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
        goto createtestproctableEXIT;
    }
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4) 0, (ub4) 0, (CONST GCISnapshot *) 0, (GCISnapshot *) 0, 
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] =
        {
            0
        },
        errstate[256] =
        {
            0
        };
        sb4 errcode;

        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto createtestproctableEXIT;
    }

createtestproctableEXIT:

    /* CLEANUP: Close the statement handle
     **          Free the statement handle
     **          Disconnect from the datasource
     **          Free the connection and environment handles
     **          Exit
     */
    if (stmt) GCIHandleFree((dvoid *) stmt, GCI_HTYPE_STMT);
}

int droptestproctable(GCIEnv * envhp, GCIError * errhp, GCISvcCtx * svchp)
{
    int rc = 0;
    GCIStmt * stmt = NULL;

    if (rc = GCIHandleAlloc((dvoid *) envhp, (dvoid * *) &stmt, 
        GCI_HTYPE_STMT, 0, (dvoid * *) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto createtestproctableEXIT;
    }
    rc = GCIStmtPrepare(stmt, errhp, dropproctablesql, strlen(dropproctablesql) + 1, 0, GCI_DEFAULT);
    if (GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
        goto createtestproctableEXIT;
    }
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4) 0, (ub4) 0, (CONST GCISnapshot *) 0, (GCISnapshot *) 0, 
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] ={0},
        errstate[256] =
        {
            0
        };
        sb4 errcode;

        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto createtestproctableEXIT;
    }

createtestproctableEXIT:

    /* CLEANUP: Close the statement handle
     **          Free the statement handle
     **          Disconnect from the datasource
     **          Free the connection and environment handles
     **          Exit
     */
    if (stmt) GCIHandleFree((dvoid *) stmt, GCI_HTYPE_STMT);
}

int testprocnamedesc(GCIEnv * envhp, GCIError * errhp, GCISvcCtx * svchp, char * proc_name)
{
    int rc = 0;
    GCIDescribe * desc = NULL;
    GCIStmt * stmt = NULL;
    GCIParam * procparam = NULL;
    GCIParam * param_list = NULL;
    GCIParam * arg = NULL;
    int nums_progs = 0;
    char * name = NULL;
    int namelen = 0;
    ub2 type = 0;
    sb2 precision = 0;
    ub1 scale = 0;
    int numargs = 0;
    int j = 0;

    printf("testprocnamedesc test begin ...\n");
    rc = GCIHandleAlloc((dvoid *) envhp, (dvoid * *) &desc, (ub4) GCI_HTYPE_DESCRIBE, (size_t) 0, (dvoid * *) 0);
    if (GCI_SUCCESS != rc)
    {
        printf("get the desc handle failedd\n");
        goto testprocnamedescEXIT;
    }
    if (rc = GCIHandleAlloc((dvoid *) envhp, (dvoid * *) &stmt, 
        GCI_HTYPE_STMT, 0, (dvoid * *) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto testprocnamedescEXIT;
    }

    //printf("testprocnamedesc desc handle ok ...%d,%d\n",desc,(ub1 *)svchp->dbc);	
    //ʼ
    rc = GCIDescribeAny(svchp, errhp, (dvoid *) proc_name, (ub4) strlen(proc_name), (ub1) GCI_OTYPE_NAME, 
        (ub1) GCI_DEFAULT, (ub1) GCI_PTYPE_PROC, desc);
    if (rc)
    {
        fprintf(stdout, "Error in test testprocnamedesc- GCIDescribeAny: get proc handle failed.\nExiting!!\n");
        goto testprocnamedescEXIT;
    }
    fprintf(stdout, "succ in test testprocnamedesc- get proc obj ok !!\n");
    rc = GCIAttrGet((CONST dvoid *) desc, (ub4) GCI_HTYPE_DESCRIBE, (dvoid *) &procparam, (ub4 *) 0, 
        (ub4) GCI_ATTR_PARAM, (GCIError *) errhp);
    if (rc)
    {
        fprintf(stdout, "Error in test testprocnamedesc- GCIAttrGet: get pkg param failed.\nExiting!!\n");
        goto testprocnamedescEXIT;
    }
    fprintf(stdout, "succ in test testprocnamedesc- get proc param ok!!\n");
    rc = GCIAttrGet((CONST dvoid *) procparam, (ub4) GCI_DTYPE_PARAM, (dvoid *) &name, (ub4 *) &namelen, 
        (ub4) GCI_ATTR_NAME, (GCIError *) errhp);
    if (rc)
    {
        fprintf(stdout, "Error in test testprocnamedesc- GCIDescribeAny: get progs name failed.\nExiting!!\n");
        goto testprocnamedescEXIT;
    }
    fprintf(stdout, "succ in test testprocnamedesc- get progs name %s !!\n", name);
    rc = GCIAttrGet((CONST dvoid *) procparam, (ub4) GCI_DTYPE_PARAM, (dvoid *) &param_list, (ub4 *) 0, 
        (ub4) GCI_ATTR_LIST_ARGUMENTS, (GCIError *) errhp);
    if (rc)
    {
        fprintf(stdout, "Error in test testprocnamedesc- GCIDescribeAny: get prog param_list failed.\n");
        goto testprocnamedescEXIT;
    }
    fprintf(stdout, "in test testprocnamedesc- GCIDescribeAny: get prog param_list ok\n");
    rc = GCIAttrGet((CONST dvoid *) param_list, (ub4) GCI_DTYPE_PARAM, (dvoid *) &numargs, (ub4 *) 0, 
        (ub4) GCI_ATTR_NUM_PARAMS, (GCIError *) errhp);
    if (rc)
    {
        fprintf(stdout, "Error in test testprocnamedesc- GCIDescribeAny: get prog param_list numargs failed.\n");
        goto testprocnamedescEXIT;
    }
    fprintf(stdout, "in test testprocnamedesc- GCIDescribeAny: get prog param_list numargs %d\n", numargs);
    fprintf(stdout, "in test testprocnamedesc- get param_list's param begin \n");

    for (j = 0; j < numargs; j++)
    {
        fprintf(stdout, "in test testprocnamedesc- get param_list's param %d\n", j);
        rc = GCIParamGet((CONST dvoid *) param_list, (ub4) GCI_DTYPE_PARAM, (GCIError *) errhp, (dvoid * *) &arg, 
            (ub4) j + 1);
        if (rc)
        {
            fprintf(stdout, "Error in test testprocnamedesc-GCIParamGet  get prog's param pos %d  failed.\nExiting!!\n",
                 
                j + 1);
            goto testprocnamedescEXIT;
        }
        fprintf(stdout, "succ in test testprocnamedesc- GCIParamGet  get prog's param pos %d  . !!\n", j + 1);
        rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &name, (ub4 *) 0, (ub4) GCI_ATTR_NAME, 
            (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test testprocnamedesc- get prog's param %d name failed !!.\nExiting!!\n", 
                j + 1);
            goto testprocnamedescEXIT;
        }
        fprintf(stdout, "succ in test testprocnamedesc- get prog's param %d ::name %s !!\n", j + 1, name);
        rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &type, (ub4 *) 0, 
            (ub4) GCI_ATTR_DATA_TYPE, (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test testprocnamedesc- get prog's param %d name failed !!.\nExiting!!\n", 
                j + 1);
            goto testprocnamedescEXIT;
        }
        fprintf(stdout, "succ in test testprocnamedesc- get prog's param %d ::type %d !!\n", j + 1, type);
        rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &precision, (ub4 *) 0, 
            (ub4) GCI_ATTR_PRECISION, (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test testprocnamedesc- get prog's param %d name failed !!.\nExiting!!\n", 
                j + 1);
            goto testprocnamedescEXIT;
        }
        fprintf(stdout, "succ in test testprocnamedesc- get prog's param %d ::precision %d !!\n", j + 1, precision);
        rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &scale, (ub4 *) 0, (ub4) GCI_ATTR_SCALE,
             
            (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test testprocnamedesc- get prog's param %d name failed !!.\nExiting!!\n", 
                j + 1);
            goto testprocnamedescEXIT;
        }
        fprintf(stdout, "succ in test testprocnamedesc- get prog's param %d ::scale %d !!\n", j + 1, scale);
        rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &name, (ub4 *) 0, 
            (ub4) GCI_ATTR_TYPE_NAME, (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test getprocdesc- get prog's param %d name failed !!.\nExiting!!\n", j + 1);
            goto testprocnamedescEXIT;
        }
        fprintf(stdout, "succ in test getprocdesc- get prog's param %d ::type name %s !!\n", j + 1, name);
        fprintf(stdout, "============================================\n", j + 1, name);
    }

testprocnamedescEXIT:

    /* CLEANUP: Close the statement handle
     **          Free the statement handle
     **          Disconnect from the datasource
     **          Free the connection and environment handles
     **          Exit
     */
    if (desc) GCIHandleFree((dvoid *) desc, GCI_HTYPE_DESCRIBE);
    if (stmt) GCIHandleFree((dvoid *) stmt, GCI_HTYPE_STMT);
    fprintf(stdout, "that is end of testing proc obj!!\n");
}

int testtablenamedesc(GCIEnv * envhp, GCIError * errhp, GCISvcCtx * svchp, char * proc_name)
{
    int rc = 0;
    GCIDescribe * desc = NULL;
    GCIStmt * stmt = NULL;
    GCIParam * procparam = NULL;
    GCIParam * param_list = NULL;
    GCIParam * arg = NULL;
    int nums_progs = 0;
    char * name = NULL;
    int namelen = 0;
    ub2 type = 0;
    sb2 precision = 0;
    ub1 scale = 0;
    ub2 numargs = 0;
    int j = 0;

    printf("testprocnamedesc test begin ...\n");
    rc = GCIHandleAlloc((dvoid *) envhp, (dvoid * *) &desc, (ub4) GCI_HTYPE_DESCRIBE, (size_t) 0, (dvoid * *) 0);
    if (GCI_SUCCESS != rc)
    {
        printf("get the desc handle failedd\n");
        goto testprocnamedescEXIT;
    }
    if (rc = GCIHandleAlloc((dvoid *) envhp, (dvoid * *) &stmt, 
        GCI_HTYPE_STMT, 0, (dvoid * *) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto testprocnamedescEXIT;
    }

    //printf("testprocnamedesc desc handle ok ...%d,%d\n",desc,(ub1 *)svchp->dbc);	
    //ʼ
    rc = GCIDescribeAny(svchp, errhp, (dvoid *) proc_name, (ub4) strlen(proc_name), (ub1) GCI_OTYPE_NAME, 
        (ub1) GCI_DEFAULT, (ub1) GCI_PTYPE_TABLE, desc);
    if (rc)
    {
        fprintf(stdout, "Error in test testprocnamedesc- GCIDescribeAny: get proc handle failed.\nExiting!!\n");
        goto testprocnamedescEXIT;
    }
    fprintf(stdout, "succ in test testprocnamedesc- get proc obj ok !!\n");
    rc = GCIAttrGet((CONST dvoid *) desc, (ub4) GCI_HTYPE_DESCRIBE, (dvoid *) &procparam, (ub4 *) 0, 
        (ub4) GCI_ATTR_PARAM, (GCIError *) errhp);
    if (rc)
    {
        fprintf(stdout, "Error in test testprocnamedesc- GCIAttrGet: get pkg param failed.\nExiting!!\n");
        goto testprocnamedescEXIT;
    }
    fprintf(stdout, "succ in test testprocnamedesc- get proc param ok!!\n");
    rc = GCIAttrGet((CONST dvoid *) procparam, (ub4) GCI_DTYPE_PARAM, (dvoid *) &param_list, (ub4 *) 0, 
        (ub4) GCI_ATTR_LIST_COLUMNS, (GCIError *) errhp);
    if (rc)
    {
        fprintf(stdout, "Error in test testprocnamedesc- GCIDescribeAny: get prog param_list failed.\n");
        goto testprocnamedescEXIT;
    }
    fprintf(stdout, "in test testprocnamedesc- GCIDescribeAny: get prog param_list ok\n");
    rc = GCIAttrGet((CONST dvoid *) param_list, (ub4) GCI_DTYPE_PARAM, (dvoid *) &numargs, (ub4 *) 0, 
        (ub4) GCI_ATTR_NUM_COLS, (GCIError *) errhp);
    if (rc)
    {
        fprintf(stdout, "Error in test testprocnamedesc- GCIDescribeAny: get prog param_list numargs failed.\n");
        goto testprocnamedescEXIT;
    }
    fprintf(stdout, "in test testprocnamedesc- GCIDescribeAny: get prog param_list numargs %d\n", numargs);
    fprintf(stdout, "in test testprocnamedesc- get param_list's param begin \n");

    for (j = 0; j < numargs; j++)
    {
        fprintf(stdout, "in test testprocnamedesc- get param_list's param %d\n", j);
        rc = GCIParamGet((CONST dvoid *) param_list, (ub4) GCI_DTYPE_PARAM, (GCIError *) errhp, (dvoid * *) &arg, 
            (ub4) j + 1);
        if (rc)
        {
            fprintf(stdout, "Error in test testprocnamedesc-GCIParamGet  get prog's param pos %d  failed.\nExiting!!\n",
                 
                j + 1);
            goto testprocnamedescEXIT;
        }
        fprintf(stdout, "succ in test testprocnamedesc- GCIParamGet  get prog's param pos %d  . !!\n", j + 1);
        rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &name, (ub4 *) 0, (ub4) GCI_ATTR_NAME, 
            (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test testprocnamedesc- get prog's param %d name failed !!.\nExiting!!\n", 
                j + 1);
            goto testprocnamedescEXIT;
        }
        fprintf(stdout, "succ in test testprocnamedesc- get prog's param %d ::name %s !!\n", j + 1, name);
        rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &type, (ub4 *) 0, 
            (ub4) GCI_ATTR_DATA_TYPE, (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test testprocnamedesc- get prog's param %d name failed !!.\nExiting!!\n", 
                j + 1);
            goto testprocnamedescEXIT;
        }
        fprintf(stdout, "succ in test testprocnamedesc- get prog's param %d ::type %d !!\n", j + 1, type);
        rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &precision, (ub4 *) 0, 
            (ub4) GCI_ATTR_PRECISION, (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test testprocnamedesc- get prog's param %d name failed !!.\nExiting!!\n", 
                j + 1);
            goto testprocnamedescEXIT;
        }
        fprintf(stdout, "succ in test testprocnamedesc- get prog's param %d ::precision %d !!\n", j + 1, precision);
        rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &precision, (ub4 *) 0, 
            (ub4) GCI_ATTR_DATA_SIZE, (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test testprocnamedesc- get prog's param %d name failed !!.\nExiting!!\n", 
                j + 1);
            goto testprocnamedescEXIT;
        }
        fprintf(stdout, "succ in test testprocnamedesc- get prog's param %d ::data_size %d !!\n", j + 1, precision);
        rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &scale, (ub4 *) 0, (ub4) GCI_ATTR_SCALE,
             
            (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test testprocnamedesc- get prog's param %d name failed !!.\nExiting!!\n", 
                j + 1);
            goto testprocnamedescEXIT;
        }
        fprintf(stdout, "succ in test testprocnamedesc- get prog's param %d ::scale %d !!\n", j + 1, scale);
        rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &name, (ub4 *) 0, 
            (ub4) GCI_ATTR_TYPE_NAME, (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test getprocdesc- get prog's param %d name failed !!.\nExiting!!\n", j + 1);
            goto testprocnamedescEXIT;
        }
        fprintf(stdout, "succ in test getprocdesc- get prog's param %d ::type name %s !!\n", j + 1, name);
        fprintf(stdout, "============================================\n", j + 1, name);
    }

testprocnamedescEXIT:

    /* CLEANUP: Close the statement handle
     **          Free the statement handle
     **          Disconnect from the datasource
     **          Free the connection and environment handles
     **          Exit
     */
    if (desc) GCIHandleFree((dvoid *) desc, GCI_HTYPE_DESCRIBE);
    if (stmt) GCIHandleFree((dvoid *) stmt, GCI_HTYPE_STMT);
    fprintf(stdout, "that is end of testing proc obj!!\n");
    return rc;
}

//static char *proc_name = "testproc"
int testprintallprocname(GCIEnv * envhp, GCIError * errhp, GCISvcCtx * svchp)
{
    int rc = 0;
    GCIDescribe * desc = NULL;
    GCIStmt * stmt = NULL;
    char * pkg_name = "test";
    GCIParam * package = NULL;
    GCIParam * subprogs = NULL;
    int nums_progs = 0;
    int i = 0;
    GCIParam * routine = NULL;
    GCIParam * param_list = NULL;
    GCIParam * arg = NULL;
    ub2 type = 0;
    char * name = NULL;
    ub4 namelen = 0;
    ub4 numargs = 0;
    sb2 precision = 0;
    ub1 scale = 0;

    printf("testprintallprocname entry %d %d\n", envhp, svchp);
    rc = GCIHandleAlloc((dvoid *) envhp, (dvoid * *) &desc, (ub4) GCI_HTYPE_DESCRIBE, (size_t) 0, (dvoid * *) 0);
    if (GCI_SUCCESS != rc)
    {
        printf("get the desc handle failedd\n");
        goto testprintallprocnameEXIT;
    }
    printf("testprintallprocname handle alloc desc %d\n", desc);
    if (rc = GCIHandleAlloc((dvoid *) envhp, (dvoid * *) &stmt, 
        GCI_HTYPE_STMT, 0, (dvoid * *) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto testprintallprocnameEXIT;
    }
    printf("testprintallprocname handle stmt %d\n", stmt);

    //ʼ
    rc = GCIDescribeAny(svchp, errhp, (dvoid *) pkg_name, (ub4) strlen(pkg_name), (ub1) GCI_OTYPE_NAME, 
        (ub1) GCI_DEFAULT, (ub1) GCI_PTYPE_PKG, desc);
    if (rc)
    {
        sb1 errmsg[256] =
        {
            0
        },
        errstate[256] =
        {
            0
        };
        sb4 errcode;

        fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get pkg handle failed.\nExiting!!\n");
        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto testprintallprocnameEXIT;
    }
    printf("testprintallprocname GCIAttrGet GCI_HTYPE_DESCRIBE 's GCI_ATTR_PARAM  \n");
    rc = GCIAttrGet((CONST dvoid *) desc, (ub4) GCI_HTYPE_DESCRIBE, (dvoid *) &package, (ub4 *) 0, 
        (ub4) GCI_ATTR_PARAM, (GCIError *) errhp);
    if (rc)
    {
        fprintf(stdout, "Error in test getprocdesc- GCIAttrGet: get pkg param failed.\nExiting!!\n");
        goto testprintallprocnameEXIT;
    }
    if (package) fprintf(stdout, "succ in test getprocdesc- get package param ok %d!!\n", package);
    rc = GCIAttrGet((CONST dvoid *) package, (ub4) GCI_DTYPE_PARAM, (dvoid *) &subprogs, (ub4 *) 0, 
        (ub4) GCI_ATTR_LIST_SUBPROGRAMS, (GCIError *) errhp);
    if (rc)
    {
        fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get pkg handle failed.\nExiting!!\n");
        goto testprintallprocnameEXIT;
    }
    fprintf(stdout, "succ in test getprocdesc- get package param GCI_ATTR_LIST_SUBPROGRAMS ok!!\n");
    rc = GCIAttrGet((CONST dvoid *) subprogs, (ub4) GCI_DTYPE_PARAM, (dvoid *) &nums_progs, (ub4 *) 0, 
        (ub4) GCI_ATTR_NUM_PARAMS, (GCIError *) errhp);
    if (rc)
    {
        fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get progs nums failed.\nExiting!!\n");
        goto testprintallprocnameEXIT;
    }
    fprintf(stdout, "succ in test getprocdesc- get package param GCI_ATTR_LIST_SUBPROGRAMS's nums %d !!\n", 
        nums_progs);

    for (i = 1; i <= nums_progs; i++)
    {
        rc = GCIParamGet((CONST dvoid *) subprogs, (ub4) GCI_DTYPE_PARAM, (GCIError *) errhp, (dvoid * *) &routine, 
            (ub4) i);
        if (rc)
        {
            fprintf(stdout, "Error in test getprocdesc-GCIParamGet  get progs param pos %d  failed.\nExiting!!\n", i);
            goto testprintallprocnameEXIT;
        }
        rc = GCIAttrGet((CONST dvoid *) routine, (ub4) GCI_DTYPE_PARAM, (dvoid *) &type, (ub4 *) 0, 
            (ub4) GCI_ATTR_PTYPE, (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get progs nums failed.\nExiting!!\n");
            goto testprintallprocnameEXIT;
        }
        rc = GCIAttrGet((CONST dvoid *) routine, (ub4) GCI_DTYPE_PARAM, (dvoid *) &name, (ub4 *) &namelen, 
            (ub4) GCI_ATTR_NAME, (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get progs name failed.\nExiting!!\n");
            goto testprintallprocnameEXIT;
        }
        fprintf(stdout, "testprintallprocname progs name  == %s,type = %d,pos = %d!!\n", name, type, i);
    }

testprintallprocnameEXIT:
    if (desc) GCIHandleFree(desc, GCI_HTYPE_DESCRIBE);
    if (stmt) GCIHandleFree((dvoid *) stmt, GCI_HTYPE_STMT);
    fprintf(stdout, "printf all procedures quit!\n");
    return rc;
}

//static char *pkg_name = "test";
//static char *proc_name = "testproc"
int testprocdesc(GCIEnv * envhp, GCIError * errhp, GCISvcCtx * svchp, char * pkg_name, char * proc_name)
{
    int rc = 0;
    GCIDescribe * desc = NULL;
    GCIStmt * stmt = NULL;
    GCIParam * package = NULL;
    GCIParam * subprogs = NULL;
    int nums_progs = 0;
    int i = 0;
    GCIParam * routine = NULL;
    GCIParam * param_list = NULL;
    GCIParam * arg = NULL;
    ub2 type = 0;
    char * name = NULL;
    char * ctypename = NULL;
    ub4 typenamelen = 0;
    ub4 namelen = 0;
    ub4 numargs = 0;
    ub4 precision = 0;
    ub4 scale = 0;

    rc = GCIHandleAlloc((dvoid *) envhp, (dvoid * *) &desc, (ub4) GCI_HTYPE_DESCRIBE, (size_t) 0, (dvoid * *) 0);
    if (GCI_SUCCESS != rc)
    {
        printf("get the desc handle failedd\n");
        goto getprocdescEXIT;
    }
    if (rc = GCIHandleAlloc((dvoid *) envhp, (dvoid * *) &stmt, 
        GCI_HTYPE_STMT, 0, (dvoid * *) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto getprocdescEXIT;
    }

    //ʼ
    rc = GCIDescribeAny(svchp, errhp, (dvoid *) pkg_name, (ub4) strlen(pkg_name), (ub1) GCI_OTYPE_NAME, 
        (ub1) GCI_DEFAULT, (ub1) GCI_PTYPE_PKG, desc);
    if (GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get pkg handle failed.\nExiting!!\n");
        goto getprocdescEXIT;
    }
    rc = GCIAttrGet((CONST dvoid *) desc, (ub4) GCI_HTYPE_DESCRIBE, (dvoid *) &package, (ub4 *) 0, 
        (ub4) GCI_ATTR_PARAM, (GCIError *) errhp);
    if (GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in test getprocdesc- GCIAttrGet: get pkg param failed.\nExiting!!\n");
        goto getprocdescEXIT;
    }
    fprintf(stdout, "succ in test getprocdesc- get package param ok!!\n");
    rc = GCIAttrGet((CONST dvoid *) package, (ub4) GCI_DTYPE_PARAM, (dvoid *) &subprogs, (ub4 *) 0, 
        (ub4) GCI_ATTR_LIST_SUBPROGRAMS, (GCIError *) errhp);
    if (GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get pkg GCI_ATTR_LIST_SUBPROGRAMS param failed.\nExiting!!\n");
        goto getprocdescEXIT;
    }
    fprintf(stdout, "succ in test getprocdesc- get package param GCI_ATTR_LIST_SUBPROGRAMS ok!!\n");
    rc = GCIAttrGet((CONST dvoid *) subprogs, (ub4) GCI_DTYPE_PARAM, (dvoid *) &nums_progs, (ub4 *) 0, 
        (ub4) GCI_ATTR_NUM_PARAMS, (GCIError *) errhp);
    if (GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get progs nums failed.\nExiting!!\n");
        goto getprocdescEXIT;
    }
    fprintf(stdout, "succ in test getprocdesc- get package param GCI_ATTR_LIST_SUBPROGRAMS's nums %d !!\n", 
        nums_progs);


    for (i = 1; i <= nums_progs; i++)
    {
        int j = 0;
        rc = GCIParamGet((CONST dvoid *) subprogs, (ub4) GCI_DTYPE_PARAM, (GCIError *) errhp, (dvoid * *) &routine, 
            (ub4) i);
        if (rc)
        {
            fprintf(stdout, "Error in test getprocdesc-GCIParamGet  get progs param pos %d  failed.\nExiting!!\n", i);
            goto getprocdescEXIT;
        }
        fprintf(stdout, "succ in test getprocdesc- GCIParamGet  get progs param pos %d  failed. !!\n", i);
        rc = GCIAttrGet((CONST dvoid *) routine, (ub4) GCI_DTYPE_PARAM, (dvoid *) &type, (ub4 *) 0, 
            (ub4) GCI_ATTR_PTYPE, (GCIError *) errhp);
        if (rc)
        {
            fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get progs nums failed.\nExiting!!\n");
            goto getprocdescEXIT;
        }
        fprintf(stdout, "succ in test getprocdesc- get package param GCI_ATTR_LIST_SUBPROGRAMS's type %d !!\n", type);
        if (GCI_PTYPE_PROC == type)
        {
            rc = GCIAttrGet((CONST dvoid *) routine, (ub4) GCI_DTYPE_PARAM, (dvoid *) &name, (ub4 *) &namelen, 
                (ub4) GCI_ATTR_NAME, (GCIError *) errhp);
            if (rc)
            {
                fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get progs name failed.\nExiting!!\n");
                goto getprocdescEXIT;
            }
            fprintf(stdout, "succ in test getprocdesc- get progs name %s : !!\n", name);
            if (strcmp(name, proc_name) == 0)
            { //name matched
                rc = GCIAttrGet((CONST dvoid *) routine, (ub4) GCI_DTYPE_PARAM, (dvoid *) &param_list, (ub4 *) 0, 
                    (ub4) GCI_ATTR_LIST_ARGUMENTS, (GCIError *) errhp);
                if (rc)
                {
                    fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get prog param_list failed.\n");
                    goto getprocdescEXIT;
                }
                fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get prog param_list ok\n");
                rc = GCIAttrGet((CONST dvoid *) param_list, (ub4) GCI_DTYPE_PARAM, (dvoid *) &numargs, (ub4 *) 0, 
                    (ub4) GCI_ATTR_NUM_PARAMS, (GCIError *) errhp);
                if (rc)
                {
                    fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get prog param_list failed.\n");
                    goto getprocdescEXIT;
                }
                fprintf(stdout, "Error in test getprocdesc- GCIDescribeAny: get prog param_list ok\n");

                for (j = 0; j < numargs; j++)
                {
                    rc = GCIParamGet((CONST dvoid *) param_list, (ub4) GCI_DTYPE_PARAM, (GCIError *) errhp, 
                        (dvoid * *) &arg, (ub4) j + 1);
                    if (rc)
                    {
                        fprintf(stdout, "Error in test getprocdesc-GCIParamGet  get prog's param pos %d  failed.\nExiting!!\n",
                             
                            j + 1);
                        goto getprocdescEXIT;
                    }

                    //fprintf(stdout, "succ in test getprocdesc- GCIParamGet  get prog's param pos %d  . !!\n",j+ 1);
                    rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &name, (ub4 *) 0, 
                        (ub4) GCI_ATTR_NAME, (GCIError *) errhp);
                    if (rc)
                    {
                        fprintf(stdout, "Error in test getprocdesc- get prog's param %d name failed !!.\nExiting!!\n",
                             
                            j + 1);
                        goto getprocdescEXIT;
                    }
                    fprintf(stdout, "succ in test getprocdesc- get prog's param %d ::name %s !!\n", j + 1, name);
                    rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &type, (ub4 *) 0, 
                        (ub4) GCI_ATTR_DATA_TYPE, (GCIError *) errhp);
                    if (rc)
                    {
                        fprintf(stdout, "Error in test getprocdesc- get prog's param %d name failed !!.\nExiting!!\n",
                             
                            j + 1);
                        goto getprocdescEXIT;
                    }

                    //fprintf(stdout, "succ in test getprocdesc- get prog's param %d ::type %d !!\n",j+1,type);
                    rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &precision, (ub4 *) 0, 
                        (ub4) GCI_ATTR_PRECISION, (GCIError *) errhp);
                    if (rc)
                    {
                        fprintf(stdout, "Error in test getprocdesc- get prog's param %d name failed !!.\nExiting!!\n",
                             
                            j + 1);
                        goto getprocdescEXIT;
                    }

                    //fprintf(stdout, "succ in test getprocdesc- get prog's param %d ::precision %d !!\n",j+1,precision);		
                    rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &scale, (ub4 *) 0, 
                        (ub4) GCI_ATTR_SCALE, (GCIError *) errhp);
                    if (rc)
                    {
                        fprintf(stdout, "Error in test getprocdesc- get prog's param %d name failed !!.\nExiting!!\n",
                             
                            j + 1);
                        goto getprocdescEXIT;
                    }

                    //fprintf(stdout, "succ in test getprocdesc- get prog's param %d ::scale %d !!\n",j+1,scale);	
                    rc = GCIAttrGet((CONST dvoid *) arg, (ub4) GCI_DTYPE_PARAM, (dvoid *) &ctypename, (ub4 *) 0,
                        (ub4) GCI_ATTR_TYPE_NAME, (GCIError *) errhp);
                    if (rc)
                    {
                        fprintf(stdout, "Error in test getprocdesc- get prog's param %d name failed !!.\nExiting!!\n",
                             
                            j + 1);
                        goto getprocdescEXIT;
                    }
                    fprintf(stdout, "succ in test getprocdesc- get prog's param %d ::type name %s ,precision %d,scale %d,type %d!!\n",
                         
                        j + 1, ctypename, precision, scale, type);
                    fprintf(stdout, "======================================================================\n");
                }
                break;
            }
            else 
            {
                fprintf(stdout, "Error in test getprocdesc- get progs name do not match %s %s!!\n", name, proc_name);
            }
        }
    }

getprocdescEXIT:

    /* CLEANUP: Close the statement handle
     **          Free the statement handle
     **          Disconnect from the datasource
     **          Free the connection and environment handles
     **        
     Exit*/
    if (desc) GCIHandleFree((dvoid *) desc, GCI_HTYPE_DESCRIBE);
    if (stmt) GCIHandleFree((dvoid *) stmt, GCI_HTYPE_STMT);
    fprintf(stdout, "that is end of testing pkg obj!!\n");
}

int logdb(GCIEnv * *envhp1, GCIError * *errhp1, GCISvcCtx * *svchp1)
{
    int rc = GCI_SUCCESS;

    ///connect db
    GCIEnv * envhp = NULL;
    GCISvcCtx * svchp = NULL;
    GCIError * errhp = NULL;
    GCItext * dbname = (GCItext *) "gci_demodb";
    GCItext * user = (GCItext *) "gbasedbt";
    GCItext * pswd = (GCItext *) "Big4ifmx";

    /*  STEP 1. Get data source name from command line (or use default)
     **          Allocate the environment handle and set ODBC version
     **          Allocate the connection handle
     **          Establish the database connection
     **          Allocate the statement handle
     **          Drop demo database if it already exists
     */
    /* initialize the mode to be the threaded and object environment */
    if (rc = GCIEnvCreate(&envhp, GCI_THREADED | GCI_OBJECT, (dvoid *) 0, 
        0, 0, 0, (size_t) 0, (dvoid * *) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
        goto logdbEXIT;
    }

    /* allocate an error handle */
    if (rc = GCIHandleAlloc((dvoid *) envhp, (dvoid * *) &errhp, 
        GCI_HTYPE_ERROR, 0, (dvoid * *) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
        goto logdbEXIT;
    }
    *envhp1 = envhp;
    *errhp1 = errhp;
    if (rc = GCILogon(envhp, errhp, &svchp, user, (ub4) strlen((char *) user), 
        pswd, (ub4) strlen((char *) pswd), dbname, (ub4) strlen((char *) dbname)) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
        goto logdbEXIT;
    }
    *svchp1 = svchp;

    /* Get version information from the database server
       If version < 9.x (not UDO enabled), exit with error message */
    /*
       if(rc = GCIServerVersion(svchp, errhp, verInfoBuffer, SELSQL_LEN, GCI_DEFAULT) != GCI_SUCCESS)
       {
       fprintf(stdout, "Error in Step 1 -- GCIServerVersion: get database server version failed\nExiting!!\n");
       goto EXIT;
       }    

       if ((strncmp ((char *) verInfoBuffer, "09", 2)) < 0 )
       {
       fprintf (stdout, "\n** This test can only be run against UDO-enabled database server -- version 9 or higher **\
        n");
       goto EXIT;
       }
       */
    fprintf(stdout, "Step 1 done...connected to database.\n");

logdbEXIT:
    return rc;
}

/*
 * This function allocates the row and collection buffers, passes
 * them to the do_select_storebyxxx() function, along with an appropriate select
 * statement and then frees all allocated handles.
 */
int main(long argc, 
    char * argv[])
{
    /* Declare varia[]bles */
    ub4 i, in;
    ub1 verInfoBuffer[SELSQL_LEN];
    ub4 verInfoLen;
    ub1 majorVer[3];
    ub4 isUdoEnabled;
    int rc = 0;

    /* Handles */
    GCIEnv * envhp = NULL;
    GCISvcCtx * svchp = NULL;
    GCIError * errhp = NULL;
    GCIStmt * stmthp1 = NULL;
    GCIStmt * stmthp2 = NULL;

    rc = logdb(&envhp, &errhp, &svchp);             //logon
    if (rc)
    {
        printf("logdb error !\n");
        goto EXIT;
    }
    droptestproctable(envhp, errhp, svchp);
    createtestproctable(envhp, errhp, svchp);
    fprintf(stdout, "\n print all proc name...\n");
    testprintallprocname(envhp, errhp, svchp);
    fprintf(stdout, "\nHit <Enter> to continue...");
    in = getchar();

    //get the proc
    fprintf(stdout, "\n no param proc test...\n");
    testprocnamedesc(envhp, errhp, svchp, "test");
    fprintf(stdout, "\nHit <Enter> to continue...");
    in = getchar();
    fprintf(stdout, "\n have params in the proc...");
    testprocnamedesc(envhp, errhp, svchp, "testproc");

    //get the pkg
    fprintf(stdout, "\n param pkg  in test  find testproc...\n");
    testprocdesc(envhp, errhp, svchp, "test", "testproc");
    testprocdesc(envhp, errhp, svchp, "test", "testproc1");
    rc = testtablenamedesc(envhp, errhp, svchp, "item");
    if (rc != GCI_SUCCESS)
    {
        sb1 errmsg[256] ={0},errstate[256] ={0};
        sb4 errcode;

        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        printf("==========testtablenamedesc===\n");
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    }
    rc = testtablenamedesc(envhp, errhp, svchp, "decconvert1");
    if (rc != GCI_SUCCESS)
    {
        sb1 errmsg[256] ={0},        errstate[256] ={            0        };
        sb4 errcode;

        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        printf("==========testtablenamedesc===\n");
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    }

    rc = testtablenamedesc(envhp, errhp, svchp, "tv");
    if (rc != GCI_SUCCESS)
    {
        sb1 errmsg[256] ={0},        errstate[256] ={            0        };
        sb4 errcode;

        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        printf("==========view===\n");
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
    }



    fprintf(stdout, "\nHit <Enter> to continue...");
    in = getchar();
    droptestproctable(envhp, errhp, svchp);
    fprintf(stdout, "\nHit <Enter> to continue...");
    in = getchar();

EXIT:

    /* CLEANUP: Close the statement handle
     **          Free the statement handle
     **          Disconnect from the datasource
     **          Free the connection and environment handles
     **          Exit
     */
    if (stmthp1) GCIHandleFree((dvoid *) stmthp1, GCI_HTYPE_STMT);
    if (stmthp2) GCIHandleFree((dvoid *) stmthp2, GCI_HTYPE_STMT);
    GCILogoff(svchp, errhp);
    if (svchp) GCIHandleFree((dvoid *) svchp, GCI_HTYPE_SVCCTX);
    if (errhp) GCIHandleFree((dvoid *) errhp, GCI_HTYPE_ERROR);
    if (envhp) GCIHandleFree((dvoid *) envhp, GCI_HTYPE_ENV);
    fprintf(stdout, "\n\nHit <Enter> to terminate the program...\n\n");
    in = getchar();
    return (rc);
}

