/***************************************************************************
*    Licensed Materials - Property of GBase
*
*
*    "Restricted Materials of GBase"
*
*
*
*    GBase 8s GCI Interface demo
*
*
*    Copyright GBase Corporation 2015 All rights reserved.
*
*
*
*
*
*  Title:          test_lobwrite.c
*
*  Description:    To write lob data in poll mode;then read it,compare;last update.
table desc:
index int
blob
blob
clob
clob
*
****************************************************************************/
#include "gci.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include "stdint.h"
#ifdef WIN32
    #include <WinSock.h>
#else
    #include <dirent.h>
    #include <unistd.h>
#endif
#define SQLMSG	GetErr()
//\      sb1 errmsg[256] = {0}, errstate[256] = {0};\
    sb4 errcode;\
    GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);\
    fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);\
    printf("GCIStmtExecute  merge failed!\n\n");
//#include "gcitype.h"

#define SELSQL_LEN     25
#define ERRMSG_LEN     200

//test the datetime datatype 
char *createdatetimesql  = "create table testdatetimetable(item_num int primary key,d1 datetime year to second)";
char *insertdatetimetablesql = "insert into testdatetimetable(item_num,d1) values(?,?)";
char *createtimestamptablesql = "create table testtimestamptable(item_num int primary key,d1 timestamp(5))";
char *inserttimestamptablesql = "insert into testtimestamptable(item_num,d1) values(?,?)";
char *selectdatetimetablesql = "select d1 from  testdatetimetable;";
char *selecttimestamptablesql = "select d1 from  testtimestamptable";

char *dropdatetimetablesql = "drop table testdatetimetable";
char *droptimestamptablesql = "drop table testtimestamptable";
char *deletedatetimedatasql = "delete from testdatetimetable;";

char *createlobtablesql = "create table testlobtable(item_num bigint primary key,t1 char(10),lob1 BLOB,num1 int,t2 varchar(10),lob2 BLOB,lob3 CLOB,lob4 CLOB);";
char *insertlobtablesqlora = "insert into TESTLOBTABLE  (item_num,t1,lob1,num1,t2,lob2,lob3,lob4)  values(113716534852976651,?,empty_blob(),1,?,empty_blob(),empty_clob(),empty_clob())";
//char *insertlobtablesqlora = "insert into \"TESTLOBTABLE\"  (item_num,t1,lob1,num1,t2,lob2,lob3,lob4)  values(113716534852976651,'t1',empty_blob(),1,'t2',empty_blob(),empty_clob(),empty_clob())";

char *insertnulllobtablesqlora = "insert into TESTLOBTABLE  (item_num,lob1,num1,lob2,lob3,lob4) values(113716534852976652,NULL,1,NULL,NULL,NULL)";

//char *insertlobtablesqlora = "insert into testlobtable values(1,empty_blob(),1,empty_blob(),empty_clob(),empty_clob());";
char *insertlobtablesqlora1 = "insert into testlobtable values(:=sdf,empty_blob(),:=1,empty_blob(),empty_Clob(),empty_clob())";
//char *insertlobtablesql = "insert into testlobtable (item_num) values(?)";//,?,?,?,?)";
char *insertlobtablesql = "insert into testlobtable (item_num,lob1,lob2,lob3,lob4) values(?,?,?,?,?)";
char *insertlobtablesql1 = "insert into TESTLOBTABLE (item_num,lob1,num1,lob2,lob3,lob4) values(113716534852976653,?,1,?,?,?)";

//char *selectlobdatasql = "select lob1,lob2,lob3,lob4 from testlobtable where item_num = 113716534852976651 for update;";
char *selectlobdatasql = "select lob1,lob2,lob3,lob4 from testlobtable where item_num = ? ";

char *selectnotupdatelobdatasql = "select lob1,lob2,lob3,lob4 from testlobtable where item_num = ? ";

char *selectforupdatelobdatasql = "select lob1 from testlobtable where item_num =  113716534852976651 for update\n ";

char *droplobtablesql = "drop table testlobtable";
char *deletelobdatasql = "delete from testlobtable;";


char *lobdata1file = "./item_1.txt";
char *lobdata2file = "./item_2.txt";
char *lobdata3file = "./item_3.txt";
char *lobdata4file = "./item_4.txt";

char *blobdata1file = "./item_1";
char *blobdata2file = "./item_2";
char *blobdata3file = "./item_3";
char *blobdata4file = "./item_4";

//testlobtable ,the lob phase type.beginning from 1

ub2 au2lobtype[] = {0,SQLT_BLOB,SQLT_BLOB,SQLT_CLOB,SQLT_CLOB};

unsigned char lobbuf1[4][2300000];
unsigned char lobbuf2[4][2300000];
int lob1len[4];
int lob2len[4];
GCIError *errhp = NULL;
#define writebufcount  2300000
#define writebufcount1  23000000
unsigned char readlobbuf[writebufcount + 1];
unsigned char writelobbuf[writebufcount + 1];
ub1 u1IsCreatelobtable = 0;
#define get_now_time(a) memset(&(a),0,sizeof((a)));gettimeofday(&(a),NULL)
// 
#define get_time_cut(a,b) ((b).tv_sec * 1000 + (b).tv_usec / 1000) - ((a).tv_sec * 1000 + (a).tv_usec / 1000)
void GetErr(){
	sb1 errmsg[256] = {0}, errstate[256] = {0};
	sb4 errcode;
	GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode,(GCIText *) errmsg, 256, GCI_HTYPE_ERROR);
	printf("Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

}
#ifdef WIN32
int gettimeofday(struct timeval *tv,struct timezone *tz){
	FILETIME ft;
	ULARGE_INTEGER uliTime;
	uint64_t ullTime;
	static const uint64_t EPOCH_DIFFERENCE = 116444736000000000ULL;
	GetSystemTimeAsFileTime(&ft);

	uliTime.LowPart = ft.dwLowDateTime;
	uliTime.HighPart=ft.dwHighDateTime;
	ullTime=uliTime.QuadPart;

	ullTime -= EPOCH_DIFFERENCE;
	ullTime /=10;

	tv->tv_sec = ullTime / 1000000;
	tv->tv_usec = ullTime % 1000000;
}
#endif

int deletedatetimetable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
    int rc = 0;
    GCIStmt *stmt;

    //alloc the stmt handle
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto dropdatetimetableEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, deletedatetimedatasql, strlen(deletedatetimedatasql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
        goto dropdatetimetableEXIT    ;
    }
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto dropdatetimetableEXIT;
    }

dropdatetimetableEXIT:
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;

}
//ɾ
int dropdatetimetable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
    int rc = 0;
    GCIStmt *stmt;
    //alloc the stmt handle
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto dropdatetimetableEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, dropdatetimetablesql, strlen(dropdatetimetablesql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
        goto dropdatetimetableEXIT    ;
    }
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto dropdatetimetableEXIT;
    }
dropdatetimetableEXIT:
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;

}
int droptimestamptable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
    int rc = 0;
    GCIStmt *stmt;
    //alloc the stmt handle
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test droptimestamptable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto dropdatetimetableEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, droptimestamptablesql, strlen(droptimestamptablesql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in droptimestamptable stmt prepare -- !!\n");
        goto dropdatetimetableEXIT    ;
    }
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "droptimestamptable Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto dropdatetimetableEXIT;
    }
dropdatetimetableEXIT:
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;

}
//ɾ

int droplobtable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
    int rc = 0;
    GCIStmt *stmt;
    //alloc the stmt handle
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto droplobtableEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, deletelobdatasql, strlen(deletelobdatasql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
        goto droplobtableEXIT    ;
    }
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto droplobtableEXIT;
    }
    rc = GCIStmtPrepare(stmt, errhp, droplobtablesql, strlen(droplobtablesql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
        goto droplobtableEXIT    ;
    }
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto droplobtableEXIT;
    }
droplobtableEXIT:
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;

}
//create the lob test key
int createdatetimetable(GCIEnv *envhp,GCISvcCtx *svchp,
    GCIError *errhp)
{

    int rc = 0;
    GCIStmt *stmt = NULL;
    //alloc the stmt handle
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto createlobtableEXIT;
    }

#if 1
    rc = GCIStmtPrepare(stmt, errhp, createdatetimesql, strlen(createdatetimesql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
        goto createlobtableEXIT;
    }
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto createlobtableEXIT;
    }
#endif
createlobtableEXIT:
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}
//create the lob test key
int createtimestamptable(GCIEnv *envhp,GCISvcCtx *svchp,
    GCIError *errhp)
{

    int rc = 0;
    GCIStmt *stmt = NULL;
    //alloc the stmt handle
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createtimestamptable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto createlobtableEXIT;
    }

#if 1
    rc = GCIStmtPrepare(stmt, errhp, createtimestamptablesql, strlen(createtimestamptablesql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in createtimestamptable stmt prepare -- !!\n");
        goto createlobtableEXIT;
    }
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "createtimestamptable Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto createlobtableEXIT;
    }
#endif
createlobtableEXIT:
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}

//create the lob test key
int createlobtable(GCIEnv *envhp,GCISvcCtx *svchp,
    GCIError *errhp)
{

    int rc = 0;
    GCIStmt *stmt = NULL;
    //alloc the stmt handle
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto createlobtableEXIT;
    }

#if 1
    rc = GCIStmtPrepare(stmt, errhp, createlobtablesql, strlen(createlobtablesql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
        goto createlobtableEXIT;
    }
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto createlobtableEXIT;
    }
#endif
createlobtableEXIT:
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}

//read the lob data
int readlobdatafromfile(char *pchFileName,char *buf,int *datalen)
{
    FILE *fp = NULL;
    int iFileLen = 0;
    fp = fopen(pchFileName,"r");

    *datalen = 0;
    while(!feof(fp)&&fp)
    {
        iFileLen = fread(buf+iFileLen,1,4096,fp);
        if(iFileLen < 4096)
        {
            *datalen += iFileLen;
            return 0;
        }
        *datalen += iFileLen;
    }
    fclose(fp);
    return 0;
}


/********************************************************************
1.get the stmt handle
2.prepare the select stmt,for find the lob data where item_num==1
3.get the lob desc handle.in fact  before bind the col
4.bind parameter for select stmt
5.execute the select
6.bind the col for lob data
7.fetch lob data
8.GCILobGetLength and read lob data,and compare the data with data in buf
*********************************************************************/
int testTrimlobdata(GCIEnv *envhp,GCIError *errhp,GCISvcCtx *svchp,long long item_num1)
{

    int rc = 0;
    GCILobLocator *alob[4] = {NULL,NULL,NULL,NULL};
    GCIStmt *stmt;
    //long long item_num = 113716534852976651;
    long long item_num = item_num1;
    //int item_num = 1;
    GCIBind *Bindp[5];
    GCIDefine *defnp[4];
    int i = 0;
    int lobtype[] = {SQLT_BLOB,SQLT_BLOB,SQLT_CLOB,SQLT_CLOB};

    sb4 starown = 0;
    int actwritelen = 0;
    ub4    amtp = 1;//ΪinputڵһãgciãΪ
    int writelen = 0;
    int offset = 0;

    //alloc the stmt handle
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto testreadlobdataEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, selectnotupdatelobdatasql, strlen(selectnotupdatelobdatasql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testreadlobdataEXIT;
    }
    fprintf (stdout, "GCIStmtPrepare read  lob table select success.\n");
    //get the handle of lob
    //get lob desc
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&alob[0] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&alob[1] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&alob[2] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&alob[3] , GCI_DTYPE_LOB, 0, NULL);
    /*  STEP C. Execut the select statement    
    */
#if 1
    //bind parameter
    if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)&item_num,(sb4)sizeof(item_num),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("in select lobdataGCI:BindByPos p2 error!\n\n");
        goto testreadlobdataEXIT;
    }
#endif
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto testreadlobdataEXIT;
    }
    fprintf (stdout, "GCIStmtExecute read  lob table select success.\n");
    /**Bind the result set columns -
    **          --  col1 = lobindex
    bind col of below
    **              col2 = lob1  blob
    **              col3 = lob2  blob
    **              col4 = lob3  clob
    **              col4 = lob4  clob     
    */
    for(i = 0;i < 4;i++)
    {
        if (rc = GCIDefineByPos(stmt, &defnp[i], errhp, i+1, (dvoid *)&alob[i],8 , (ub2)au2lobtype[i+ 1],
            (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            goto testreadlobdataEXIT;
        }
    }

    fprintf (stdout, "GCIDefineByPos bind col select success.\n");
    //fetch the lob data,only one record
    while(1) 
    {
        ub4 rownum = 0;
        if (rc = GCIStmtFetch(stmt, errhp, 1, GCI_FETCH_NEXT, 0) == GCI_NO_DATA)
        {
            fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found again...%d\n",starown);
            rc = GCI_SUCCESS;
            //goto testreadlobdataEXIT;
            break;
        }
        GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
        fprintf (stdout, "GCIStmtFetch  select a record.\n");
        if(starown == rownum)
            break;

        //        starown = rownum;
        starown++;
    }
    //жrownumǶ,ĳӦwhile
    fprintf (stdout, "begin read lob data with polling mode.\n");

    //write with poll mode 
    for(i = 0;i < 4;i++)
    {
        //if (actwritelen)
        {
            GCILobTrim( svchp,  errhp, alob[i], 1);
        }
    }

testreadlobdataEXIT:
    for(i = 0;i < 4;i++)
    {
        if(alob[i])
        {
            GCIDescriptorFree(alob[i], GCI_DTYPE_LOB);
        }
    }
    if (stmt)
        GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;

}



/********************************************************************
1.get the stmt handle
2.prepare the select stmt,for find the lob data where item_num==1
3.get the lob desc handle.in fact  before bind the col
4.bind parameter for select stmt
5.execute the select
6.bind the col for lob data
7.fetch lob data
8.GCILobGetLength and read lob data,and compare the data with data in buf
*********************************************************************/
int testreadlobdata(GCIEnv *envhp,GCIError *errhp,GCISvcCtx *svchp,long long item_num1)
{

    int rc = 0;
    GCILobLocator *alob[4] = {NULL,NULL,NULL,NULL};
    GCIStmt *stmt;
    //long long item_num = 113716534852976651;
    long long item_num = item_num1;
    //int item_num = 1;
    GCIBind *Bindp[5];
    GCIDefine *defnp[4];
    int lobtype[] = {SQLT_BLOB,SQLT_BLOB,SQLT_CLOB,SQLT_CLOB};
    sb4 starown = 0;
    int actwritelen = 0;
    ub4    amtp = 1;//ΪinputڵһãgciãΪ
    int writelen = 0;
    int offset = 1;
    int i = 0;

    //alloc the stmt handle
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto testreadlobdataEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, selectnotupdatelobdatasql, strlen(selectnotupdatelobdatasql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testreadlobdataEXIT;
    }
    fprintf (stdout, "GCIStmtPrepare read  lob table select success.\n");
    //get the handle of lob
    //get lob desc
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&alob[0] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&alob[1] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&alob[2] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp,(dvoid **)&alob[3] , GCI_DTYPE_LOB, 0, NULL);
    /*  STEP C. Execut the select statement    
    */
#if 1
    //bind parameter
    if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)&item_num,(sb4)sizeof(item_num),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("in select lobdataGCI:BindByPos p2 error!\n\n");
        goto testreadlobdataEXIT;
    }
#endif
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto testreadlobdataEXIT;
    }
    fprintf (stdout, "GCIStmtExecute read  lob table select success.\n");
    /**Bind the result set columns -
    **          --  col1 = lobindex
    bind col of below
    **              col2 = lob1  blob
    **              col3 = lob2  blob
    **              col4 = lob3  clob
    **              col4 = lob4  clob     
    */
    for(i = 0;i < 4;i++)
    {
        if (rc = GCIDefineByPos(stmt, &defnp[i], errhp, i+1, (dvoid *)&alob[i],8 , (ub2)au2lobtype[i+ 1],
            (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            goto testreadlobdataEXIT;
        }
    }

    fprintf (stdout, "GCIDefineByPos bind col select success.\n");
    //fetch the lob data,only one record
    while(1) 
    {
        ub4 rownum = 0;
        if (rc = GCIStmtFetch(stmt, errhp, 1, GCI_FETCH_NEXT, 0) == GCI_NO_DATA)
        {
            fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found again...%d\n",starown);
            rc = GCI_SUCCESS;
            //goto testreadlobdataEXIT;
            break;
        }
        GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
        fprintf (stdout, "GCIStmtFetch  select a record.\n");
        if(starown == rownum)
            break;

        //        starown = rownum;
        starown++;
    }
    //жrownumǶ,ĳӦwhile
    fprintf (stdout, "begin read lob data with polling mode.\n");

    //write with poll mode 
    for(i = 0;i < 4;i++)
    {
        amtp = 1;//ΪinputڵһãgciãΪ
        writelen = 0;
        //get the length for the lob data
        rc = GCILobGetLength(svchp, errhp, alob[i], &actwritelen);
        if(rc != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "GCILobGetLength Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

            goto testreadlobdataEXIT;
        }
        fprintf (stdout, "========GCILobGetLength   %d %d \n",actwritelen,i);

        offset = 1;
        //polling read
        while(actwritelen)
        {

            if(actwritelen > writebufcount)
            {
                writelen = writebufcount;
            }
            else
            {
                writelen = actwritelen;
            }
            actwritelen -= writelen;
            printf("read lob datalen %d \n",writelen);
            rc =  GCILobRead(svchp,errhp,alob[i], &amtp, offset,readlobbuf,writelen,NULL,NULL,0,0);
            if((rc != GCI_SUCCESS) &&( rc != GCI_SUCCESS_WITH_INFO))
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

                goto testreadlobdataEXIT;
            }
            if(lobtype[i] == SQLT_CLOB)
            {
                if(strncmp(readlobbuf,lobbuf2[i] + offset,writelen))
                {
                    printf("read lob data is not same.lob record 1 at lobdata %d\n",i+1);
                }
                else
                {
                    printf("read lob data is same.lob record 1 at lobdata %d\n",i+1);
                }
            }
            else if(lobtype[i] == SQLT_BLOB)
            {
                if(memcmp(readlobbuf,lobbuf2[i] + offset,writelen))
                {
                    printf("read lob data is not same.lob record 1 at lobdata %d\n",i+1);
                }
                else
                {
                    printf("read lob data is same.lob record 1 at lobdata %d\n",i+1);
                }
            }
            else
            {
                printf("alob[i]->lobType p1 error!\n\n");
                goto testreadlobdataEXIT;
            }

            offset += amtp;
        }
    }

testreadlobdataEXIT:
    for(i = 0;i < 4;i++)
    {
        if(alob[i])
        {
            GCIDescriptorFree(alob[i], GCI_DTYPE_LOB);
        }
    }
    if (stmt)
        GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;

}

/********************************************************************
1.get the stmt handle
2.prepare the select stmt,for find the lob data where item_num==1
3.get the lob desc handle.in fact  before bind the col
4.bind parameter for select stmt
5.execute the select
6.bind the col for lob data
7.write lob data
8.read the lob data and compare
*********************************************************************/
int testupdatelobdata(GCIEnv *envhp,GCIError *errhp,GCISvcCtx *svchp)
{
    int rc = 0;
    GCILobLocator *alob[4] = {NULL,NULL,NULL,NULL};
    GCIStmt *stmt;
    long long item_num = 113716534852976651;
    GCIBind *Bindp[5];
    GCIDefine *defnp[4];
    int lobtype[] = {SQLT_BLOB,SQLT_BLOB,SQLT_CLOB,SQLT_CLOB};
    int actwritelen = 0;
    ub4    amtp = 1;//ΪinputڵһãgciãΪ
    int writelen = 0;
    int offset = 0;
    int i =0;
    sb4 starown = 0;

    printf("============================================\n");
    //ļȡ
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto testupdatelobdataEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, selectforupdatelobdatasql, strlen(selectforupdatelobdatasql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testupdatelobdataEXIT;
    }
    rc = GCIDescriptorAlloc((CONST dvoid *)envhp,(dvoid **)&alob[3] , (CONST ub4)GCI_DTYPE_LOB, 0, NULL);
    /*  STEP C. Execut the select statement
    */
    //bind parameter
    if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)&item_num,(sb4)sizeof(item_num),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("in select lobdataGCI:BindByPos p2 error!\n\n");
        goto testupdatelobdataEXIT;
    }
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto testupdatelobdataEXIT;
    }
    //bind col pos
    if (rc = GCIDefineByPos(stmt, &defnp[0], errhp, 1, (dvoid *)&alob[3],8, (ub2)SQLT_BLOB,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        printf("Bind p1 error!\n\n");
        goto testupdatelobdataEXIT;
    }

    //write,the same as update
    printf("update lobdata begin!\n\n");

    //write with poll mode 
    for(i = 0;i < 1;i++)
    {
        amtp = 1;//ΪinputڵһãgciãΪ
        writelen = 0;
        actwritelen = lob1len[i];
        offset = 1;

        while(actwritelen)
        {

            if(actwritelen > writebufcount)
            {
                writelen = writebufcount;
            }
            else
            {
                writelen = actwritelen;
            }
            actwritelen -= writelen;

            if(lobtype[i] == SQLT_CLOB)
            {

                strncpy(writelobbuf,lobbuf1[i] + offset,writelen);
                writelobbuf[writelen] = '\0';

            }
            else if(lobtype[i] == SQLT_BLOB)
            {
                printf("memcpy buf!\n\n");
                memcpy(writelobbuf,lobbuf1[i] + offset,writelen);
            }
            else
            {
                printf("Bind p1 error!\n\n");
                goto testupdatelobdataEXIT;
            }
            printf("memcpy buf write!\n\n");
            rc =  GCILobWrite(svchp,errhp,alob[3], &amtp, offset,writelobbuf,writelen,0,NULL,NULL,0,0);
            offset += amtp;
        }
        if (actwritelen == 0)
        {
            writelen = 0;
            rc =  GCILobWrite(svchp,errhp,alob[3], &amtp, offset,writelobbuf,writelen,0,NULL,NULL,0,0);
        }
    }
    GCIDescriptorFree( alob[3], GCI_DTYPE_LOB);
    alob[3] = NULL;
    //
    printf("begin to read for compare\n");
    rc = GCIDescriptorAlloc(envhp,(void **)&alob[0] , GCI_DTYPE_LOB, 0, NULL);
    //read and compare
    rc = GCIStmtPrepare(stmt, errhp, selectforupdatelobdatasql, strlen(selectforupdatelobdatasql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testupdatelobdataEXIT;
    }
    /*  STEP C. Execut the select statement    

    //bind parameter
    if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)&item_num,(sb4)sizeof(item_num),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
    printf("in select lobdataGCI:BindByPos p2 error!\n\n");
    goto testupdatelobdataEXIT;
    }*/
    if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto testupdatelobdataEXIT;
    }
    //bind col pos
    if (rc = GCIDefineByPos(stmt, &defnp[0], errhp, 1, (dvoid *)&alob[0], 4, (ub2)SQLT_BLOB,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        printf("Bind p1 error!\n\n");
        goto testupdatelobdataEXIT;
    }

    fprintf (stdout, "GCIDefineByPos bind col select success.\n");
    //fetch the lob data
    while(1) 
    {
        ub4 rownum = 0;
        if (rc = GCIStmtFetch(stmt, errhp, 1, GCI_FETCH_NEXT, 0) == GCI_NO_DATA)
        {
            fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found again...\n");
            rc = GCI_SUCCESS;
            //goto testreadlobdataEXIT;
            break;
        }
        GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
        fprintf (stdout, "GCIStmtFetch  select a record.\n");
        if(starown == rownum)
            break;

        starown = rownum;
    }
    //read and compare
    actwritelen = 0;
    amtp = 1;//ΪinputڵһãgciãΪ
    writelen = 0;
    offset = 1;
    //write with poll mode 
    for(i = 0;i < 1;i++)
    {
        amtp = 1;//ΪinputڵһãgciãΪ
        writelen = 0;
        //get the length for the lob data
        rc = GCILobGetLength(svchp, errhp, alob[0], &actwritelen);
        if(rc != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

            return rc;
        }
        offset = 1;
        //getlength
        printf("==== actwritelen %d,write len %d\n",actwritelen,lob1len[0]);
        while(actwritelen)
        {

            if(actwritelen > 4096)
            {
                writelen = 4096;
            }
            else
            {
                writelen = actwritelen;
            }
            actwritelen -= writelen;

            rc =  GCILobRead(svchp,errhp,alob[0], &amtp, offset,readlobbuf,writelen,NULL,NULL,0,0);
            if (rc )
            {
                printf("GCILobRead p1 error!\n\n");
                goto testupdatelobdataEXIT;
            }
            if(lobtype[i] == SQLT_CLOB)
            {
                if(strncmp(readlobbuf,lobbuf1[i] + offset,writelen))
                {
                    printf("read lob data is not same update.lob record 1 at lobdata %d\n",i+1);
                }
                else
                {
                    //printf("read lob data is same.lob record 1 at lobdata %d\n",i+1);
                }
            }
            else if(lobtype[i] == SQLT_BLOB)
            {
                if(memcmp(readlobbuf,lobbuf1[i] + offset,writelen))
                {
                    printf("read lob data is not same in update.lob record 1 at lobdata %d\n",i+1);
                }
                else
                {
                    //printf("read lob data is same.lob record 1 at lobdata %d\n",i+1);
                }
            }
            else
            {
                printf("alob[i]->lobType p1 error!\n\n");
                goto testupdatelobdataEXIT;
            }

            offset += amtp;
        }
    }
    printf("============================================update ok\n");
    //GCIDescriptorFree(alob[0] , GCI_SELF_HANDLE);
testupdatelobdataEXIT:
    for(i = 0;i < 4;i++)
    {
        if(alob[i])
        {
            GCIDescriptorFree(alob[i], GCI_DTYPE_LOB);
        }
    }

    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;
}
int testdatetime(GCIEnv *envhp,GCIError *errhp,GCISvcCtx *svchp)
{
    int rc = 0;
    GCIStmt *stmt;
    int item_num = 2;
    GCIBind *Bindp[5];
    GCIDefine *defnp[4];
    GCIDate d;
    GCIDate *datetimestr = NULL;
    int i = 0;
    sb4 starown = 0;
    datetimestr = &d;
    //ļȡ
    //stmt prepare
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto testdatetimeEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, insertdatetimetablesql, strlen(insertdatetimetablesql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testdatetimeEXIT;
    }
    printf("prepare insert stmt success!\n\n");
    if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)&item_num,(sb4)sizeof(item_num),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind parameter itemnum error!\n\n");
        goto testdatetimeEXIT;
    }
    printf("GCIBindByPos bind parameter itemnum success!\n\n");
    if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,2,(dvoid *)datetimestr,(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos bind parameter itemnum error!\n\n");
        goto testdatetimeEXIT;
    }
    printf("GCIBindByPos bind parameter d1 success!\n\n");
    for(i = 0;i < 4;i++)
    {
        datetimestr->GCIDateDD = i+ 20;
        datetimestr->GCIDateMM = 4;
        datetimestr->GCIDateYYYY = 2016;
        datetimestr->GCIDateTime.GCITimeHH = 10;
        datetimestr->GCIDateTime.GCITimeMI = 45 + i;
        datetimestr->GCIDateTime.GCITimeSS = 55;
        item_num += i;
        //execute
        rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
            GCI_COMMIT_ON_SUCCESS);
        if(rc)
        {
            printf("GCIStmtExecute error %d\n",i);
            goto testdatetimeEXIT;
        }

    }
    printf("prepare insert stmt success!\n\n");
    //select
    rc = GCIStmtPrepare(stmt, errhp, selectdatetimetablesql, strlen(selectdatetimetablesql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testdatetimeEXIT;
    }
    //execute
    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testdatetimeEXIT;
    }

    printf("prepare select stmt success!\n\n");

    /* if (rc = GCIDefineByPos(stmt, &defnp[0], errhp, 1, (dvoid *)&item_num, 4, (ub2)SQLT_INT,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
    printf("GCIDefineByPos   select lobdata col1 error!\n\n");
    goto testdatetimeEXIT;
    }*/
    if (rc = GCIDefineByPos(stmt, &defnp[1], errhp, 1, (dvoid *)datetimestr, (sb4)sizeof(GCIDate), (ub2)SQLT_ODT,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        printf("GCIDefineByPos   select lobdata col2 error!\n\n");
        goto testdatetimeEXIT;
    }

    while(1) 
    {
        ub4 rownum = 0;

        if (rc = GCIStmtFetch(stmt, errhp, 1, GCI_FETCH_NEXT, 0) == GCI_NO_DATA)
        {
            fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
            rc = GCI_SUCCESS;
            goto testdatetimeEXIT;
            break;
        }

        fprintf(stdout, "\tRetrieving row number %d:\n", i+1);
        fprintf(stdout, "\t\tdatetime %d-%d-%d %d:%d:%d\n", datetimestr->GCIDateYYYY,datetimestr->GCIDateMM,datetimestr->GCIDateDD,datetimestr->GCIDateTime.GCITimeHH,datetimestr->GCIDateTime.GCITimeMI,datetimestr->GCIDateTime.GCITimeSS);

        i++;
    }

testdatetimeEXIT:
    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;

}
int testtimestamp(GCIEnv *envhp,GCIError *errhp,GCISvcCtx *svchp)
{
    int rc = 0;
    GCIStmt *stmt;
    int item_num = 2;
    GCIBind *Bindp[5];
    GCIDefine *defnp[4];
    GCIDate d;
    GCIDate *datetimestr = NULL;
    int i = 0;
    char gcidatetimestamp[30];
    sb4 starown = 0;
    datetimestr = &d;
    //ļȡ
    //stmt prepare
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write testtimestamp-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto testtimestampEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, inserttimestamptablesql, strlen(inserttimestamptablesql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insert testtimestamp prepare -- !!\n");
        goto testtimestampEXIT;
    }
    printf("prepare insert stmt success!--------------------------\n\n");
    if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)&item_num,(sb4)sizeof(item_num),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos testtimestamp parameter itemnum error!\n\n");
        goto testtimestampEXIT;
    }
    printf("GCIBindByPos testtimestamp parameter itemnum success!\n\n");
    if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,2,(dvoid *)gcidatetimestamp,(sb4)sizeof(gcidatetimestamp),SQLT_CHR,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos testtimestamp parameter itemnum error!\n\n");
        goto testtimestampEXIT;
    }
    printf("GCIBindByPos testtimestamp parameter d1 success!\n\n");
    for(i = 0;i < 4;i++)
    {
        item_num += i;

        sprintf(gcidatetimestamp,"%d-%s-%d %d:%d:%d.%d",2017,"01",25,14,17,15+i,i+1000);
        //execute
        rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
            GCI_COMMIT_ON_SUCCESS);
        if(rc)
        {
            printf("GCIStmtExecute testtimestamperror %d\n",i);
            goto testtimestampEXIT;
        }

    }
    rc = GCIStmtPrepare(stmt, errhp, inserttimestamptablesql, strlen(inserttimestamptablesql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insert testtimestamp prepare -- !!\n");
        goto testtimestampEXIT;
    }
    printf("prepare insert stmt success!\n\n");
    if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)&item_num,(sb4)sizeof(item_num),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos testtimestamp parameter itemnum error!\n\n");
        goto testtimestampEXIT;
    }
    printf("GCIBindByPos testtimestamp parameter itemnum success!\n\n");
    if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,2,(dvoid *)datetimestr,(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("GCIBindByPos testtimestamp parameter itemnum error!\n\n");
        goto testtimestampEXIT;
    }
    printf("GCIBindByPos testtimestamp parameter d1 success!\n\n");
    for(i = 1;i < 5;i++)
    {
        datetimestr->GCIDateDD = i+ 20;
        datetimestr->GCIDateMM = 4;
        datetimestr->GCIDateYYYY = 2016;
        datetimestr->GCIDateTime.GCITimeHH = 10;
        datetimestr->GCIDateTime.GCITimeMI = 45 + i;
        datetimestr->GCIDateTime.GCITimeSS = 55;
        item_num += i*2;
        //execute
        rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
            GCI_COMMIT_ON_SUCCESS);
        if(rc)
        {
            printf("GCIStmtExecute testtimestamperror %d\n",i);
            goto testtimestampEXIT;
        }

    }
    printf("prepare testtimestampinsert stmt success!\n\n");
    //select
    rc = GCIStmtPrepare(stmt, errhp, selecttimestamptablesql, strlen(selecttimestamptablesql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in testtimestamp sel stmt prepare -- !!\n");
        goto testtimestampEXIT;
    }
    //execute
    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testtimestampEXIT;
    }

    printf("testtimestamp prepare select stmt success!\n\n");

    /* if (rc = GCIDefineByPos(stmt, &defnp[0], errhp, 1, (dvoid *)&item_num, 4, (ub2)SQLT_INT,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
    printf("GCIDefineByPos   select lobdata col1 error!\n\n");
    goto testdatetimeEXIT;
    }*/
    datetimestr = &d;
    if (rc = GCIDefineByPos(stmt, &defnp[1], errhp, 1, (dvoid *)datetimestr, (sb4)sizeof(GCIDate), (ub2)SQLT_ODT,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        printf("testtimestamp GCIDefineByPos   select lobdata col2 error!\n\n");
        goto testtimestampEXIT;
    }

    while(1) 
    {
        ub4 rownum = 0;

        if (rc = GCIStmtFetch(stmt, errhp, 1, GCI_FETCH_NEXT, 0) == GCI_NO_DATA)
        {
            fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
            rc = GCI_SUCCESS;
            //goto testtimestampEXIT;
            break;
        }
        //        GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);


        fprintf(stdout, "\ttesttimestampRetrieving no string ---row number %d:\n", i+1);
        fprintf(stdout, "\t\ttesttimestampdatetime no string ---  %d-%d-%d %d:%d:%d\n", datetimestr->GCIDateYYYY,datetimestr->GCIDateMM,datetimestr->GCIDateDD,datetimestr->GCIDateTime.GCITimeHH,datetimestr->GCIDateTime.GCITimeMI,datetimestr->GCIDateTime.GCITimeSS);

        i++;
    }

    printf("prepare testtimestampinsert stmt success!_+_+_+_+_+_+2\n\n");
    //select
    rc = GCIStmtPrepare(stmt, errhp, selecttimestamptablesql, strlen(selecttimestamptablesql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in testtimestamp sel stmt prepare -- !!\n");
        goto testtimestampEXIT;
    }
    //execute
    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testtimestampEXIT;
    }

    printf("testtimestamp prepare select stmt success!+++++++++++1\n\n");

    /* if (rc = GCIDefineByPos(stmt, &defnp[0], errhp, 1, (dvoid *)&item_num, 4, (ub2)SQLT_INT,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
    printf("GCIDefineByPos   select lobdata col1 error!\n\n");
    goto testdatetimeEXIT;
    }*/
    //datetimestr = &d;
    if (rc = GCIDefineByPos(stmt, &defnp[2], errhp, 1, (dvoid *)gcidatetimestamp, (sb4)sizeof(gcidatetimestamp), (ub2)SQLT_CHR,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        printf("testtimestamp GCIDefineByPos   select lobdata col2 error!\n\n");
        goto testtimestampEXIT;
    }
    printf("testtimestamp prepare select stmt success!+++++++++++2\n\n");
    starown = 0;

    while(1) 
    {
        ub4 rownum = 0;

        if (rc = GCIStmtFetch(stmt, errhp, 1, GCI_FETCH_NEXT, 0) == GCI_NO_DATA)
        {
            fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
            rc = GCI_SUCCESS;
            goto testtimestampEXIT;
            break;
        }
        //        GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

        printf("testtimestamp prepare select stmt success!+++++++++++3\n\n");
        fprintf(stdout, "\ttesttimestampRetrieving string ====row number %d:\n", i+1);
        fprintf(stdout, "\t\ttesttimestampdatetime string   =====%s\n", gcidatetimestamp);

        i++;
    }

testtimestampEXIT:
    if(stmt)
        GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc;

}
/********************************************************************
1.get the stmt handle
2.insert prepare the select stmt, item_num = 2
3.exec
4.select prepare
5.bind parameter for select stmt
6.execute the select
7.bind the col for lob data
8.write lob data
*********************************************************************/
int testorasqlwritelobdata(GCIEnv *envhp,GCIError *errhp,GCISvcCtx *svchp)
{
    int rc = 0;
    GCILobLocator *alob[4] = {NULL,NULL,NULL,NULL};
    GCIStmt *stmt;
    long long item_num = 113716534852976651;
    //long long item_num = 1;
    GCIBind *Bindp[5];
    GCIDefine *defnp[4];
    int lobtype[] = {SQLT_BLOB,SQLT_BLOB,SQLT_CLOB,SQLT_CLOB};
    char t1[] = "t1";
    char t2[] = "t2";
    int i  = 0;
    int actwritelen = 0;
    ub4    amtp = 1;//ΪinputڵһãgciãΪ
    int writelen = 0;
    int offset = 0;

    //ļȡ
    //stmt prepare
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto testorawritelobdataEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, insertlobtablesqlora, strlen(insertlobtablesqlora) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        SQLMSG;
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testorawritelobdataEXIT;
    }
#if 1
    if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,1,(dvoid *)t1,(sb4)3,SQLT_CHR,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("Bind p1 error!\n\n");
        goto testorawritelobdataEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,2,(dvoid *)t2,(sb4)3,SQLT_CHR,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("Bind p1 error!\n\n");
        goto testorawritelobdataEXIT;
    }
#endif
    printf("lob write GCIStmtPrepare ok\n");
    //execute
    printf("lob write \n");
    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS);

    if(rc != GCI_SUCCESS)
    {
        SQLMSG;
        printf("GCIStmtExecute  insert gci lob data sql string error!\n\n");
        goto testorawritelobdataEXIT;
    }

    //free(Bindp[4]);bindpھͷʱͳһͷ
    /////////////////////////////insert a null lobdata overing
    //get lob desc
    rc = GCIDescriptorAlloc(envhp, (void **)&alob[0] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp, (void **)&alob[1] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp, (void **)&alob[2] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp, (void **)&alob[3] , GCI_DTYPE_LOB, 0, NULL);

    //select for update prepare
    rc = GCIStmtPrepare(stmt, errhp, selectlobdatasql, strlen(selectlobdatasql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testorawritelobdataEXIT;
    }
#if 1
    if(rc = GCIBindByPos(stmt,&Bindp[2],errhp,1,(dvoid *)&item_num,(sb4)sizeof(item_num),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("Bind p1 error!\n\n");
        goto testorawritelobdataEXIT;
    }

#endif
    //execute
    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS);

    if(rc != GCI_SUCCESS)
    {
        printf("GCIStmtExecute select error!\n\n");
        goto testorawritelobdataEXIT;
    }

    //bind col pos
    if (rc = GCIDefineByPos(stmt, &defnp[0], errhp, 1, (dvoid *)&alob[0], 4, (ub2)SQLT_BLOB,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        printf("Bind p1 error!\n\n");
        goto testorawritelobdataEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &defnp[1], errhp, 2, (dvoid *)&alob[1], 4, (ub2)SQLT_BLOB,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        printf("Bind p1 error!\n\n");
        goto testorawritelobdataEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &defnp[2], errhp, 3, (dvoid *)&alob[2], 4, (ub2)SQLT_CLOB,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        printf("Bind p1 error!\n\n");
        goto testorawritelobdataEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &defnp[3], errhp, 4, (dvoid *)&alob[3], 4, (ub2)SQLT_CLOB,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        printf("Bind p1 error!\n\n");
        goto testorawritelobdataEXIT;
    }

    rc = GCIStmtFetch(stmt, errhp, 0, GCI_FETCH_NEXT, 0);
    if(rc != GCI_SUCCESS)
    {
        printf("GCIStmtFetch select error!\n\n");
        goto testorawritelobdataEXIT;
    }

    printf("printf write with mode begin!\n\n");

    //write with poll mode 

    for(i = 0;i < 4;i++)
    {
        struct timeval a;
        struct timeval b;

        amtp = 1;//ΪinputڵһãgciãΪ
        writelen = 0;
        actwritelen = lob2len[i];
        offset = 1;

        printf("printf write with mode begin %d!\n\n",actwritelen);
        while(actwritelen)
        {

            if(actwritelen > writebufcount)
            {
                writelen = writebufcount;
            }
            else
            {
                writelen = actwritelen;
            }
            actwritelen -= writelen;

            if(lobtype[i] == SQLT_CLOB)
            {
                strncpy(writelobbuf,lobbuf2[i] + offset,writelen);
                writelobbuf[writelen] = '\0';

            }
            else if(lobtype[i] == SQLT_BLOB)
            {
                memcpy(writelobbuf,lobbuf2[i] + offset,writelen);
            }
            else
            {
                printf("Bind p1 error!\n\n");
                goto testorawritelobdataEXIT;
            }
            get_now_time(a);
            rc =  GCILobWrite(svchp,errhp,alob[i], &amtp, offset,writelobbuf,writelen,0,NULL,NULL,0,0);
            if(!rc)
            {
                printf("printf write with mode begin %d!\n\n",actwritelen);
            }
            else
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
                goto testorawritelobdataEXIT;
            }
            get_now_time(b);
            printf("printf write size %d!,timecount %d\n\n",actwritelen,get_time_cut(a,b));
            offset += amtp;
        }
    }

    printf("printf write gci success!\n\n");
testorawritelobdataEXIT:
    //ͷŸдйصľڴ
    for(i = 0;i < 4;i++)
    {
        if(alob[i])
        {
            GCIDescriptorFree(alob[i], GCI_DTYPE_LOB);
            alob[i] = NULL;
        }
    }

    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    stmt = NULL;
    return rc;
}

/********************************************************************
1.get the stmt handle
2.insert prepare the select stmt, item_num = 2
3.exec
4.select prepare
5.bind parameter for select stmt
6.execute the select
7.bind the col for lob data
8.write lob data
*********************************************************************/
int testsqlwritelobdata(GCIEnv *envhp,GCIError *errhp,GCISvcCtx *svchp)
{
    int rc = 0;
    GCILobLocator *alob[4] = {NULL,NULL,NULL,NULL};
    GCIStmt *stmt;
    long long item_num = 113716534852976652;
    //long long item_num = 1;
    GCIBind *Bindp[5];
    GCIDefine *defnp[4];
    int lobtype[] = {SQLT_BLOB,SQLT_BLOB,SQLT_CLOB,SQLT_CLOB};
    int i    = 0;
    int actwritelen = 0;
    ub4 amtp = 1;//ΪinputڵһãgciãΪ
    int writelen = 0;
    int offset = 0;

    //ļȡ
    //stmt prepare
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto testorawritelobdataEXIT;
    }

    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)insertnulllobtablesqlora, strlen(insertnulllobtablesqlora) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        SQLMSG;
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testorawritelobdataEXIT;
    }
    printf("lob write GCIStmtPrepare ok\n");
    //execute
    printf("lob write \n");
    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS);

    if(rc != GCI_SUCCESS)
    {
        SQLMSG;
        printf("GCIStmtExecute  insert gci lob data sql string error!\n\n");
        goto testorawritelobdataEXIT;
    }

    //free(Bindp[4]);bindpھͷʱͳһͷ
    /////////////////////////////insert a null lobdata overing
    //get lob desc
    rc = GCIDescriptorAlloc(envhp, (void **)&alob[0] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp, (void **)&alob[1] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp, (void **)&alob[2] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp, (void **)&alob[3] , GCI_DTYPE_LOB, 0, NULL);

    //select for update prepare
    rc = GCIStmtPrepare(stmt, errhp, selectlobdatasql, strlen(selectlobdatasql) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testorawritelobdataEXIT;
    }
#if 1
    if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)&item_num,(sb4)sizeof(item_num),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("Bind p1 error!\n\n");
        goto testorawritelobdataEXIT;
    }
#endif
    //execute
    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS);

    if(rc != GCI_SUCCESS)
    {
        printf("GCIStmtExecute select error!\n\n");
        goto testorawritelobdataEXIT;
    }

    //bind col pos
    if (rc = GCIDefineByPos(stmt, &defnp[0], errhp, 1, (dvoid *)&alob[0], 4, (ub2)SQLT_BLOB,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        printf("Bind p1 error!\n\n");
        goto testorawritelobdataEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &defnp[1], errhp, 2, (dvoid *)&alob[1], 4, (ub2)SQLT_BLOB,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        printf("Bind p1 error!\n\n");
        goto testorawritelobdataEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &defnp[2], errhp, 3, (dvoid *)&alob[2], 4, (ub2)SQLT_CLOB,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        printf("Bind p1 error!\n\n");
        goto testorawritelobdataEXIT;
    }
    if (rc = GCIDefineByPos(stmt, &defnp[3], errhp, 4, (dvoid *)&alob[3], 4, (ub2)SQLT_CLOB,(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        printf("Bind p1 error!\n\n");
        goto testorawritelobdataEXIT;
    }

    rc = GCIStmtFetch(stmt, errhp, 0, GCI_FETCH_NEXT, 0);
    if(rc != GCI_SUCCESS)
    {
        printf("GCIStmtFetch select error!\n\n");
        goto testorawritelobdataEXIT;
    }

    printf("printf write with mode begin!\n\n");

    //write with poll mode 

    for(i = 0;i < 4;i++)
    {
        struct timeval a;
        struct timeval b;

        amtp = 1;//ΪinputڵһãgciãΪ
        writelen = 0;
        actwritelen = lob2len[i];
        offset = 1;
        printf("printf write with mode begin %d!\n\n",actwritelen);
        while(actwritelen)
        {

            if(actwritelen > writebufcount)
            {
                writelen = writebufcount;
            }
            else
            {
                writelen = actwritelen;
            }
            actwritelen -= writelen;

            if(lobtype[i] == SQLT_CLOB)
            {
                strncpy(writelobbuf,lobbuf2[i] + offset,writelen);
                writelobbuf[writelen] = '\0';

            }
            else if(lobtype[i] == SQLT_BLOB)
            {
                memcpy(writelobbuf,lobbuf2[i] + offset,writelen);
            }
            else
            {
                printf("Bind p1 error!\n\n");
                goto testorawritelobdataEXIT;
            }
            get_now_time(a);
            rc =  GCILobWrite(svchp,errhp,alob[i], &amtp, offset,writelobbuf,writelen,0,NULL,NULL,0,0);
            if(!rc)
            {
                printf("printf write with mode begin %d!\n\n",actwritelen);
            }
            else
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
                goto testorawritelobdataEXIT;
            }
            get_now_time(b);
            printf("printf write size %d!,timecount %d\n\n",actwritelen,get_time_cut(a,b));
            offset += amtp;
        }
    }

    printf("printf write gci success!\n\n");
testorawritelobdataEXIT:
    //ͷŸдйصľڴ
    for(i = 0;i < 4;i++)
    {
        if(alob[i])
        {
            GCIDescriptorFree(alob[i], GCI_DTYPE_LOB);
            alob[i] = NULL;
        }
    }

    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    stmt = NULL;
    return rc;
}



typedef struct{
    int device_ctrl_cmd;
    char station_id[5];
    char cmd_valid_time[15];

}device_control_t;
int testmergedata(GCIEnv *envhp,GCIError *errhp,GCISvcCtx *svchp)
{
    int rc = 0;
    GCILobLocator *alob[4] = {NULL,NULL,NULL,NULL};
    GCIStmt *stmt;
    long long item_num = 113716534852976651;
    //long long item_num = 1;
    GCIBind *Bindp[5];
    GCIDefine *defnp[4];
    int lobtype[] = {SQLT_BLOB,SQLT_BLOB,SQLT_CLOB,SQLT_CLOB};
    device_control_t tDev;//using (select sysdate from sysmaster:sysdual) d 
    int i = 0;
    char *mergesql = "merge into device_control as  t using (select count(*) from device_control ) d   on (t.device_ctrl_cmd = 10) when matched then update set t.device_ctrl_cmd=5 ,t.cmd_valid_time= 20170110043710 when not matched then insert values(?,?,to_number('20170110043711'))";//;?,?,to_number('20170110043721'));"//when matched then update set device_ctrl_cmd=5 ,cmd_valid_time=d.cmd_valid_time
    //"merge into device_control as t using (select cmd_valid_time from device_control where device_ctrl_cmd = 3 ) as d   on (1) when matched then update set device_ctrl_cmd=3 ,cmd_valid_time=d.sysdate ";//;?,?,to_number('20170110043721'));" //when matched then update set t.device_ctrl_cmd=5 ,t.cmd_valid_time=d.cmd_valid_time 
    //"merge into device_control as t using (select sysdate from sysmaster:sysdual) as d   on (t.station_id=?) when matched then update set device_ctrl_cmd=? ,cmd_valid_time=? when not matched then insert values(?,?,to_number(d.sysdate))";
    //      "merge into device_control as t using (select * from sysmaster:sysdual) as d   on (t.station_id=1) when matched then update set device_ctrl_cmd=2 ,cmd_valid_time='20170110043720' when not matched then insert values(2,'3',to_number('20170110043720'))";
    //    char *mergesql = "select * from device_control ";

    //select for update prepare
    //ļȡ
    //stmt prepare
    //stmt
    for(i = 0;i < 10000;i++)
    {
        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
            GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
            return GCI_ERROR;
        }


        rc = GCIStmtPrepare(stmt, errhp, mergesql, strlen(mergesql) , 0, GCI_DEFAULT);
        if(GCI_SUCCESS != rc)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

            fprintf(stdout, "Error in merge stmt prepare -- !!\n");
            return GCI_ERROR;
        }


        if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,2,(dvoid *)tDev.station_id,(sb4)sizeof(tDev.station_id),SQLT_CHR,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
        {
            printf("Bind p1 error!\n\n");
            return GCI_ERROR;
        }

        if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)&tDev.device_ctrl_cmd,(sb4)sizeof(int),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
        {
            printf("Bind p2 error!\n\n");
            return GCI_ERROR;
        }
#if 0     
        if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,3,(dvoid *)tDev.cmd_valid_time,(sb4)strlen(tDev.cmd_valid_time),SQLT_CHR,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
        {
            printf("Bind p3 error!\n\n");
            return GCI_ERROR;
        }
        if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,4,(dvoid *)tDev.station_id,(sb4)strlen(tDev.station_id),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
        {
            printf("Bind p4 error!\n\n");
            return GCI_ERROR;
        }
        if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,5,(dvoid *)&tDev.device_ctrl_cmd,(sb4)sizeof(tDev.device_ctrl_cmd),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
        {
            printf("Bind p5 error!\n\n");
            return GCI_ERROR;
        }
        //     if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,6,(dvoid *)tDev.cmd_valid_time,(sb4)strlen(tDev.cmd_valid_time),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
        {
            //        printf("Bind p6 error!\n\n");
            //                   return GCI_ERROR;
        }
#endif


        //ȡǰʱ
        sprintf(tDev.station_id ,"%d", i+10);
        tDev.device_ctrl_cmd = i+10;

        rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
            GCI_COMMIT_ON_SUCCESS);

        if(rc != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            printf("GCIStmtExecute  merge failed!\n\n");
            return GCI_ERROR;
        }
        //GCIStmtReset(stmt,0);
        GCIHandleFree((dvoid *)stmt, GCI_HTYPE_STMT);
    }
    //
    printf("exec merge ok %d\n",i);
    return rc;
}
int logdb(GCIEnv **envhp1,GCIError **errhp1,GCISvcCtx **svchp1)
{
    int rc = GCI_SUCCESS;

    ///connect db
    GCIEnv *envhp= NULL;
    GCISvcCtx *svchp= NULL;
    GCIError *errhp = NULL;
    GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";
    GCItext *user = (GCItext*)"gbasedbt";
    GCItext *pswd = (GCItext*)"Big4ifmx";

    /*  STEP 1. Get data source name from command line (or use default)
    **          Allocate the environment handle and set ODBC version
    **          Allocate the connection handle
    **          Establish the database connection
    **          Allocate the statement handle
    **          Drop demo database if it already exists
    */
    /* initialize the mode to be the threaded and object environment */
    if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
        0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
        goto logdbEXIT;
    }

    /* allocate an error handle */
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
        GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
        goto logdbEXIT;
    }

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
        GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
        goto logdbEXIT;
    }

    if(rc = GCILogon2(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
        pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname),1) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
        goto logdbEXIT;
    }
    *envhp1 = envhp;
    *errhp1 = errhp;
    *svchp1 = svchp;


    fprintf (stdout, "Step 1 done...connected to database.\n");

logdbEXIT:
    return rc;
}


/*test lobempty*/
int testlobempty(GCIEnv *envhp,GCIError *errhp,GCISvcCtx *svchp)
{
    int rc = 0;
    GCILobLocator *alob[4] = {NULL,NULL,NULL,NULL};
    GCIStmt *stmt;
    long long item_num = 113716534852976653;
    //long long item_num = 1;
    GCIBind *Bindp[5];
    GCIDefine *defnp[4];
    boolean isLobInit = FALSE;
    int actwritelen = 0;
    ub4 amtp = 1;//ΪinputڵһãgciãΪ
    int writelen = 0;
    int offset = 0;
    int i    = 0;
    int lobtype[] = {SQLT_BLOB,SQLT_BLOB,SQLT_CLOB,SQLT_CLOB};
    char *updateempty = "update testlobtable set lob1 = empty_blob() where item_num =1";

    //ļȡ
    //stmt prepare
    //stmt
    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in test write lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
        goto testorawritelobdataEXIT;
    }

    //free(Bindp[4]);bindpھͷʱͳһͷ
    /////////////////////////////insert a null lobdata overing
    //get lob desc
    rc = GCIDescriptorAlloc(envhp, (void **)&alob[0] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp, (void **)&alob[1] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp, (void **)&alob[2] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCIDescriptorAlloc(envhp, (void **)&alob[3] , GCI_DTYPE_LOB, 0, NULL);
    rc = GCILobLocatorIsInit(envhp,errhp,alob[0],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("00000 lob 0 lobinit %d\n",isLobInit);
    }
    rc = GCILobLocatorIsInit(envhp,errhp,alob[1],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("00000 lob 1 lobinit %d\n",isLobInit);
    }
    rc = GCILobLocatorIsInit(envhp,errhp,alob[2],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("00000 lob 2 lobinit %d\n",isLobInit);
    }
    rc = GCILobLocatorIsInit(envhp,errhp,alob[3],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("00000 lob 3 lobinit %d\n",isLobInit);
    }

    rc = GCILobIsOpen(svchp,errhp,alob[0],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("00000 lob 0 lobopen %d\n",&isLobInit);
    }
    rc = GCILobIsOpen(svchp,errhp,alob[1],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("00000 lob 1 lobopen %d\n",&isLobInit);
    }
    rc = GCILobIsOpen(svchp,errhp,alob[2],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("00000 lob 2 lobopen %d\n",&isLobInit);
    }
    rc = GCILobIsOpen(svchp,errhp,alob[3],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("00000 lob 3 lobopen %d\n",isLobInit);
    }

    rc = GCIAttrSet(alob[0],GCI_DTYPE_LOB,NULL,0,GCI_ATTR_LOBEMPTY,errhp);
    rc = GCIAttrSet(alob[1],GCI_DTYPE_LOB,NULL,0,GCI_ATTR_LOBEMPTY,errhp);
    rc = GCIAttrSet(alob[2],GCI_DTYPE_LOB,NULL,0,GCI_ATTR_LOBEMPTY,errhp);
    rc = GCIAttrSet(alob[3],GCI_DTYPE_LOB,NULL,0,GCI_ATTR_LOBEMPTY,errhp);
    rc = GCILobLocatorIsInit(envhp,errhp,alob[0],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("11111 lob 0 lobinit %d\n",isLobInit);
    }
    rc = GCILobLocatorIsInit(envhp,errhp,alob[1],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("11111 lob 1 lobinit %d\n",isLobInit);
    }
    rc = GCILobLocatorIsInit(envhp,errhp,alob[2],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("11111 lob 2 lobinit %d\n",isLobInit);
    }
    rc = GCILobLocatorIsInit(envhp,errhp,alob[3],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("11111 lob 3 lobinit %d\n",isLobInit);
    }
    rc = GCILobIsOpen(svchp,errhp,alob[0],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("11111 lob 0 lobopen %d\n",isLobInit);
    }
    rc = GCILobIsOpen(svchp,errhp,alob[1],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("11111 lob 1 lobopen %d\n",isLobInit);
    }
    rc = GCILobIsOpen(svchp,errhp,alob[2],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("11111 lob 2 lobopen %d\n",isLobInit);
    }
    rc = GCILobIsOpen(svchp,errhp,alob[3],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("11111 lob 3 lobopen %d\n",isLobInit);
    }


    rc = GCIStmtPrepare(stmt, errhp, insertlobtablesql1, strlen(insertlobtablesql1) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        SQLMSG;
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testorawritelobdataEXIT;
    }


    printf("lob write GCIStmtPrepare ok\n");
    //bind parameter
    if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)&alob[0],(sb4)sizeof(void *),SQLT_BLOB,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("in select lobdataGCI:BindByPos p2 error!\n\n");
        goto testorawritelobdataEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[1],errhp,2,(dvoid *)&alob[1],(sb4)sizeof(void *),SQLT_BLOB,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("in select lobdataGCI:BindByPos p2 error!\n\n");
        goto testorawritelobdataEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[2],errhp,3,(dvoid *)&alob[2],(sb4)sizeof(void *),SQLT_CLOB,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("in select lobdataGCI:BindByPos p2 error!\n\n");
        goto testorawritelobdataEXIT;
    }
    if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,4,(dvoid *)&alob[3],(sb4)sizeof(void *),SQLT_CLOB,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
    {
        printf("in select lobdataGCI:BindByPos p2 error!\n\n");
        goto testorawritelobdataEXIT;
    }

    //execute
    printf("lob write \n");
    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
        GCI_COMMIT_ON_SUCCESS);

    if(rc != GCI_SUCCESS)
    {
        SQLMSG;
        printf("GCIStmtExecute  insert gci lob data sql string error!\n\n");
        goto testorawritelobdataEXIT;
    }

    //write with poll mode 

    for(i = 0;i < 4;i++)
    {
        struct timeval a;
        struct timeval b;

        amtp = 1;//ΪinputڵһãgciãΪ
        writelen = 0;
        actwritelen = lob2len[i];
        offset = 1;
        printf("printf write with mode begin %d!\n\n",actwritelen);
        while(actwritelen)
        {

            if(actwritelen > writebufcount)
            {
                writelen = writebufcount;
            }
            else
            {
                writelen = actwritelen;
            }
            actwritelen -= writelen;

            if(lobtype[i] == SQLT_CLOB)
            {
                strncpy(writelobbuf,lobbuf2[i] + offset,writelen);
                writelobbuf[writelen] = '\0';

            }
            else if(lobtype[i] == SQLT_BLOB)
            {
                memcpy(writelobbuf,lobbuf2[i] + offset,writelen);
            }
            else
            {
                printf("Bind p1 error!\n\n");
                goto testorawritelobdataEXIT;
            }
            get_now_time(a);
            rc =  GCILobWrite(svchp,errhp,alob[i], &amtp, offset,writelobbuf,writelen,0,NULL,NULL,0,0);
            if(!rc)
            {
                printf("printf write with mode begin %d!\n\n",actwritelen);
            }
            else
            {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
                goto testorawritelobdataEXIT;
            }
            get_now_time(b);
            printf("printf write size %d!,timecount %d\n\n",actwritelen,get_time_cut(a,b));
            offset += amtp;
        }
    }

    rc = GCILobLocatorIsInit(envhp,errhp,alob[0],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("22222 lob 0 lobinit %d\n",isLobInit);
    }
    rc = GCILobLocatorIsInit(envhp,errhp,alob[1],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("22222 lob 1 lobinit %d\n",isLobInit);
    }
    rc = GCILobLocatorIsInit(envhp,errhp,alob[2],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("22222 lob 2 lobinit %d\n",isLobInit);
    }
    rc = GCILobLocatorIsInit(envhp,errhp,alob[3],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("22222 lob 3 lobinit %d\n",isLobInit);
    }
    rc = GCILobIsOpen(svchp,errhp,alob[0],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("22222 lob 0 lobopen %d\n",isLobInit);
    }
    rc = GCILobIsOpen(svchp,errhp,alob[1],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("11111 lob 1 lobopen %d\n",isLobInit);
    }
    rc = GCILobIsOpen(svchp,errhp,alob[2],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("22222 lob 2 lobopen %d\n",isLobInit);
    }
    rc = GCILobIsOpen(svchp,errhp,alob[3],&isLobInit);
    if (rc == GCI_SUCCESS)
    {
        printf("22222 lob 3 lobopen %d\n",isLobInit);
    }

    rc = GCILobClose(svchp,errhp,alob[0]);
    if (rc == GCI_SUCCESS)
    {
        printf("22222 lob 0 lobclose %d\n",isLobInit);
    }
    rc = GCILobClose(svchp,errhp,alob[1]);
    if (rc == GCI_SUCCESS)
    {
        printf("22222 lob 1 lobclose %d\n",isLobInit);
    }
    rc = GCILobClose(svchp,errhp,alob[2]);
    if (rc == GCI_SUCCESS)
    {
        printf("22222 lob 2 lobclose %d\n",isLobInit);
    }
    rc = GCILobClose(svchp,errhp,alob[3]);
    if (rc == GCI_SUCCESS)
    {
        printf("22222 lob 3 lobclose %d\n",isLobInit);
    }
    printf("printf write gci success!\n\n");


    printf("printf updateempty gci convert ==============!\n\n");

    rc = GCIStmtPrepare(stmt, errhp, updateempty, strlen(updateempty) + 1, 0, GCI_DEFAULT);
    if(GCI_SUCCESS != rc)
    {
        SQLMSG;
        fprintf(stdout, "Error in insert stmt prepare -- !!\n");
        goto testorawritelobdataEXIT;
    }

testorawritelobdataEXIT:
    //ͷŸдйصľڴ
    for(i = 0;i < 4;i++)
    {
        if(alob[i])
        {
            GCIDescriptorFree(alob[i], GCI_DTYPE_LOB);
            alob[i] = NULL;
        }
    }

    GCIHandleFree(stmt, GCI_HTYPE_STMT);
    stmt = NULL;
    return rc;


    return rc;

}

/*
* This function allocates the row and collection buffers, passes
* them to the do_select_storebyxxx() function, along with an appropriate select
* statement and then frees all allocated handles.
*/


#define test_buffer_len   100000
#define test_buffer_len1  20000000
#define test_buffer_len2 2000000
char read_buffer[test_buffer_len1];
int main (long argc,
    char* argv[])
{
    /* Declare varia[]bles */

    ub4            i, in;

    ub1         verInfoBuffer[SELSQL_LEN];
    ub4            verInfoLen;
    ub1         majorVer[3];
    ub4          isUdoEnabled;
    int rc = 0;

    ub1    *        selectStmt = "SELECT \"advert\" FROM item WHERE item_num = 1004";

    /* Handles */
    GCIEnv *envhp = NULL;
    GCISvcCtx *svchp = NULL;
    GCIError *errhp = NULL;
    GCIStmt *stmthp1 = NULL;
    GCIStmt *stmthp2 = NULL;
    int fd = 0;

    int read_size = 0;
    int status = 0;
    char *    lo_file_name1 = "2.txt";
    //write to txt
    //test for 50w updates


    rc = logdb(&envhp,&errhp,&svchp);
    if(rc)
    {
        goto EXIT;
    }
    //rc = testmergedata(envhp,errhp,svchp);
    //return rc;
#if 1
    //ļȡ
    readlobdatafromfile(blobdata1file,lobbuf1[0],&lob1len[0]);
    lob1len[0]     = 0;
    printf("lobbuf1[0] data len is %d ,file name %s\n",lob1len[0],blobdata1file);
    readlobdatafromfile(blobdata2file,lobbuf1[1],&lob1len[1]);
    printf("lobbuf1[1] data len is %d ,file name %s\n",lob1len[1],blobdata2file);
    readlobdatafromfile(blobdata3file,lobbuf2[0],&lob2len[0]);
    printf("lobbuf2[0] data len is %d ,file name %s\n",lob2len[0],blobdata3file);
    readlobdatafromfile(blobdata4file,lobbuf2[1],&lob2len[1]);
    printf("lobbuf2[1] data len is %d ,file name %s\n",lob2len[1],blobdata4file);

    readlobdatafromfile(lobdata1file,lobbuf1[2],&lob1len[2]);
    printf("lobbuf1[2] data len is %d ,file name %s\n",lob1len[2],lobdata1file);
    readlobdatafromfile(lobdata2file,lobbuf1[3],&lob1len[3]);
    printf("lobbuf1[3 data len is %d ,file name %s\n",lob1len[3],lobdata2file);
    readlobdatafromfile(lobdata3file,lobbuf2[2],&lob2len[2]);
    printf("lobbuf2[2] data len is %d ,file name %s\n",lob2len[2],lobdata3file);
    readlobdatafromfile(lobdata4file,lobbuf2[3],&lob2len[3]);
    printf("lobbuf2[3] data len is %d ,file name %s\n",lob2len[3],lobdata4file);
    // for(;;)    
    {
        rc = droplobtable(envhp,svchp,errhp);
        rc = createlobtable(envhp,svchp,errhp);
        if(rc)
        {
            fprintf (stdout, "create lob table failure.\n");
            goto EXIT;
        }
        fprintf (stdout, "create lob table success.\n");

        rc = testorasqlwritelobdata(envhp,errhp,svchp);
        if(rc)
        {
            fprintf (stdout, "test gci insert lob data failed!.\n");
            goto EXIT;
        }
        fprintf (stdout, "test gci insert lob data table successs.\n");
        //readlobdata
        fprintf (stdout, "read lob table begin.\n");
        rc=    testreadlobdata(envhp,errhp,svchp,113716534852976651);
        if(rc)
        {
            goto EXIT;
        }
        fprintf (stdout, "read lob table success.\n");
        //updatelob data
        rc = testupdatelobdata(envhp,errhp,svchp);
        if(rc)
        {
            goto EXIT;
        }
        //null lob data write
        printf("--------------------null lob write  113716534852976652\n");
        rc = testsqlwritelobdata(envhp,errhp,svchp);
        if(rc)
        {
            goto EXIT;
        }
        rc =  testreadlobdata(envhp,errhp,svchp,113716534852976651);
        /*
        rc = droplobtable(envhp,svchp,errhp);
        if(rc)
        {
        goto EXIT;
        }
        */
        printf("--------------------testreadlobdata 113716534852976652\n");
        rc =  testreadlobdata(envhp,errhp,svchp,113716534852976652);
        if (rc )
        {
            goto EXIT;
        }
        fprintf (stdout, "Step 3 done...select and retrieve results stored by row buffer success.\n");
        printf("--------------------empty lob write 113716534852976653\n");
        rc = testlobempty(envhp,errhp,svchp);
        if(rc)
        {
            goto EXIT;
        }
        GCITransCommit(svchp, errhp,0 );
        printf("--------------------trim lob 113716534852976652\n");
        rc =  testTrimlobdata(envhp,errhp,svchp,113716534852976652);
        if (rc)
        {
            goto EXIT;
        }
        printf("--------------------after trim lob then read 113716534852976652\n");
        rc =  testreadlobdata(envhp,errhp,svchp,113716534852976652);
        if (rc )
        {
            goto EXIT;
        }
#if 0
        //#else
        rc = dropdatetimetable(envhp,svchp,errhp);
        rc = createdatetimetable(envhp,svchp,errhp);
        rc = droptimestamptable(envhp,svchp,errhp);
        rc = createtimestamptable(envhp,svchp,errhp);
        if(rc)
        {
            fprintf (stdout, "create createtimestamptable table failure.\n");
            goto EXIT;
        }

        rc = testdatetime(envhp,errhp,svchp);

        if(rc != GCI_SUCCESS)
        {
            printf("GCIStmtExecute select error!\n\n");
            goto EXIT;
        }
        rc = testtimestamp(envhp,errhp,svchp);

        if(rc != GCI_SUCCESS)
        {
            printf("GCIStmtExecute select error!\n\n");
            goto EXIT;
        }
#endif
#endif
        if(stmthp1)
            GCIHandleFree((dvoid *)stmthp1, GCI_HTYPE_STMT);

        if(stmthp2)
            GCIHandleFree((dvoid *)stmthp2, GCI_HTYPE_STMT);

        rc =  GCILogoff(svchp, errhp);
        if (rc)
        {
            printf("--------------------gci logoff failed!\n");
        }

        if(svchp)
            GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);

        if(errhp)
            GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

        if(envhp)
            GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);


        //repeat read lob obj
        rc = logdb(&envhp,&errhp,&svchp);
        if(rc)
        {
            goto EXIT;
        }
        rc =  testreadlobdata(envhp,errhp,svchp,113716534852976651);
        if (rc )
        {
            goto EXIT;
        }
        /**/
        printf("--------------------another read testreadlobdata 113716534852976652\n");
        rc =  testreadlobdata(envhp,errhp,svchp,113716534852976652);
        if (rc )
        {
            goto EXIT;
        }
    }

    fprintf (stdout,"\nHit <Enter> to continue...");
    in = getchar ();

EXIT:

    /* CLEANUP: Close the statement handle
    **          Free the statement handle
    **          Disconnect from the datasource
    **          Free the connection and environment handles
    **          Exit
    */
    if(stmthp1)
        GCIHandleFree((dvoid *)stmthp1, GCI_HTYPE_STMT);

    if(stmthp2)
        GCIHandleFree((dvoid *)stmthp2, GCI_HTYPE_STMT);

    GCILogoff(svchp, errhp);

    if(svchp)
        GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);

    if(errhp)
        GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

    if(envhp)
        GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);


    fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
    in = getchar ();

    return (rc);
}
