/***************************************************************************
*    Licensed Materials - Property of GBase
*
*
*    "Restricted Materials of GBase"
*
*
*
*    GBase 8s GCI Interface demo
*
*
*    (C) Copyright GBase Corporation 2015 All rights reserved.
*
*
*
*
*
*  Title:          test_logon_dblink.c
*
*  Description:    Test logon database with ip_addr:port/dbname@dbserver format.
*                  
*
***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gci.h"

int main(long         argc,
         char*        argv[])
{
    GCIEnv *envhp;
    GCIError *errhp;
    GCISvcCtx *svchp;
    CONST GCIText *username = "root";
    ub4 uname_len;
    CONST GCIText *password = "111111";
    ub4 passwd_len;
    CONST GCIText *dbname = "172.16.2.198:14900/gci_demodb@ol_gbasedbt1210_4";
    ub4 dbname_len;
    dvoid *tmp;
    GCIStmt *stmthp;
    sword rc = GCI_SUCCESS;

    GCIInitialize((ub4) GCI_THREADED | GCI_OBJECT, (dvoid *)0, (dvoid * (*)(void*, size_t)) 0, (dvoid * (*)(void*, void*, size_t)) 0,  (void (*)(void*, void*)) 0 );

    GCIHandleAlloc((dvoid *) NULL, (dvoid **)&envhp, (ub4)GCI_HTYPE_ENV, 52, (dvoid **)&tmp);

    GCIEnvInit(&envhp, (ub4)GCI_DEFAULT, 21, (dvoid **)&tmp);

    GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp, (ub4)GCI_HTYPE_ERROR, 52, (dvoid **)&tmp);

    GCIHandleAlloc( (dvoid *) envhp, (dvoid **) &stmthp, (ub4) GCI_HTYPE_STMT, 50, (dvoid **) &tmp);

    rc = GCILogon(envhp, errhp, &svchp, username, (ub4)strlen((char*)username), password, (ub4)strlen((char*)password), dbname, (ub4)strlen((char*)dbname));
    if (rc != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCILogon: logon from database failed.\nExiting!!\n");
        goto Exit;
    }

    char *sql_create = "create table testzjl (id INTEGER)";
    rc = GCIStmtPrepare(stmthp, errhp, (GCItext*)sql_create, strlen(sql_create), GCI_NTV_SYNTAX, GCI_DEFAULT);
    if (rc != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 2 -- GCIStmtPrepare: prepare sql statement failed.\nExiting!!\n");
        goto Exit;
    }
    rc = GCIStmtExecute(svchp, stmthp, errhp, 1, 0, NULL, NULL, GCI_DEFAULT);
    if (rc != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 3 -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
        goto Exit;
    }

    char *sql_drop = "drop table testzjl";
    rc = GCIStmtPrepare(stmthp, errhp, (GCItext*)sql_drop, strlen(sql_drop), GCI_NTV_SYNTAX, GCI_DEFAULT);
    if (rc != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 4 -- GCIStmtPrepare: prepare sql statement failed.\nExiting!!\n");
        goto Exit;
    }
    rc = GCIStmtExecute(svchp, stmthp, errhp, 1, 0, NULL, NULL, GCI_DEFAULT);
    if (rc != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 5 -- GCIStmtExecute: execute sql statement failed.\nExiting!!\n");
        goto Exit;
    }

    rc = GCITransCommit(svchp, errhp, 0);
    if (rc != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 6 -- GCITransCommit: commit failed.\nExiting!!\n");
        goto Exit;
    }

    rc = GCILogoff(svchp, errhp);
    if (rc != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 7 -- GCILogoff: logoff from database failed.\nExiting!!\n");
        goto Exit;
    }

    fprintf (stdout,"\n\nTest logon with ip_addr:port/dbname@dbserver format success....\n\n");

Exit:
    if (stmthp)
    {
        GCIHandleFree((dvoid *) stmthp, (ub4) GCI_HTYPE_STMT);
    }
    if (errhp)
    {
        GCIHandleFree((dvoid *)errhp, (ub4) GCI_HTYPE_ERROR);
    }
    if (envhp)
    {
        GCIHandleFree((dvoid *)envhp, (ub4) GCI_HTYPE_ENV);
    }

    fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
    char in = getchar ();
    
    return 0;
}
