/***************************************************************************
 *	Licensed Materials - Property of GBase
 *
 *
 *	"Restricted Materials of GBase"
 *
 *
 *
 *	GBase 8s GCI Interface demo
 *
 *
 *	Copyright GBase Corporation 2015 All rights reserved.
 *    Title:          test_datconvert.c
 *
 *  Description:    To retrieve results from the database and display it. 
 *                  This example also illustrates the fact
 *                  that the same client functions can use row and column
 *                  store buffer.
 *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef WIN32
    #include <WinSock.h>
    #include <WinNT.h>
#endif
#include <math.h>
#include "gci.h"
#include "stdint.h"

#define SELSQL_LEN     25
#define ERRMSG_LEN     200
char *createdattable = "create table if not exists afctest (a char(20),b int,c varchar(200))";

char *selectdatadec1table = "select a from afctest";
char *selectdatadec1table1 = "select a,b,c from afctest";

char *dropflttable1 =  "drop table if exists afctest ";
char *deletetable =  "delete from afctest while b =:1";
char *deletetable1 =  "delete from afctest while b >:1";

char *insertdatadectable = "insert into  afctest(a,b,c) values(:1,:2,:3)";
char *updatedatadattable = "update afctest set a=:1 where :2=b";

#define get_now_time(a) memset(&(a),0,sizeof((a)));gettimeofday(&(a),NULL)
	// 
#define get_time_cut(a,b) ((b).tv_sec * 1000 + (b).tv_usec / 1000) - ((a).tv_sec * 1000 + (a).tv_usec / 1000)

#ifdef WIN32
int gettimeofday(struct timeval *tv,struct timezone *tz){
	FILETIME ft;
	ULARGE_INTEGER uliTime;
	uint64_t ullTime;
	static const uint64_t EPOCH_DIFFERENCE = 116444736000000000ULL;
	GetSystemTimeAsFileTime(&ft);

	uliTime.LowPart = ft.dwLowDateTime;
	uliTime.HighPart=ft.dwHighDateTime;
	ullTime=uliTime.QuadPart;

	ullTime -= EPOCH_DIFFERENCE;
	ullTime /=10;

	tv->tv_sec = ullTime / 1000000;
	tv->tv_usec = ullTime % 1000000;

}
#endif

int logdb(GCIEnv **envhp1,GCIError **errhp1,GCISvcCtx **svchp1)
{
	int rc = GCI_SUCCESS;
	
	///connect db
	GCIEnv *envhp= NULL;
	GCISvcCtx *svchp= NULL;
	GCIError *errhp = NULL;
	GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";

	/*  STEP 1. Get data source name from command line (or use default)
	 **          Allocate the environment handle and set ODBC version
	 **          Allocate the connection handle
	 **          Establish the database connection
	 **          Allocate the statement handle
	 **          Drop demo database if it already exists
	 */
	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
				0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}

	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
				GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}	

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
				GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}
	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
				pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto logdbEXIT;
	}
	*envhp1 = envhp;
	*errhp1 = errhp;
	*svchp1 = svchp;


	fprintf (stdout, "Step 1 done...connected to database.\n");

logdbEXIT:
		*envhp1 = envhp;
	*errhp1 = errhp;
	*svchp1 = svchp;	
	return rc;
}
int dropdatconverttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp,GCIStmt * stmt,char *sql)
{
	int rc = 0;

	rc = GCIStmtPrepare(stmt, errhp, sql, strlen(sql) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto droplobtableEXIT	;
	}
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto droplobtableEXIT;
	}
	
droplobtableEXIT:
	return rc;

}
int selectdatconverttablebyrow(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp,GCIStmt *stmt,char *sql)
{
	int rc = 0;
    //alloc the stmt handle	
    GCIDefine *Definep[5];
	long i = 0;
	char *ac = NULL;
	int *bi = NULL;
	char *cc = NULL;
    sb2 ind[3][100] = {0};
	sb4 starown = 0;
    char *pbuf = NULL;
    int len = 4+20+200;
    pbuf = malloc(len *100);
    if (pbuf)
    {
        goto SUCCESS_EXIT;
    }
    ac = pbuf;
    bi = (int *)(pbuf +20);
    cc = pbuf + 20+4;


	rc = GCIStmtPrepare(stmt, errhp, sql, strlen(sql), 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtPrepare selecttest datetime prepare -- !!\n");
		goto SUCCESS_EXIT;
	}
    if ((rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)ac,(sb4)20, (ub2)SQLT_AFC,
                    (dvoid *)ind[0], (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto SUCCESS_EXIT;
    }   
    if ((rc = GCIDefineByPos(stmt, &Definep[1], errhp, 2, (dvoid *)bi,(sb4)4, (ub2)SQLT_INT,
                       (dvoid *)ind[1], (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
   {
       sb1 errmsg[256] = {0}, errstate[256] = {0};
       sb4 errcode;
       GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
       fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

       goto SUCCESS_EXIT;
   }   
    if ((rc = GCIDefineByPos(stmt, &Definep[2], errhp, 3, (dvoid *)cc,(sb4)200, (ub2)SQLT_CHR,
                       (dvoid *)ind[2], (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
   {
       sb1 errmsg[256] = {0}, errstate[256] = {0};
       sb4 errcode;
       GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
       fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

       goto SUCCESS_EXIT;
   }   


	if (rc = GCIDefineArrayOfStruct(Definep[0], errhp,len, 6, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	} 

	if (rc = GCIDefineArrayOfStruct(Definep[1], errhp,len, 6, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	} 
	if (rc = GCIDefineArrayOfStruct(Definep[2], errhp,len, 6, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	} 

	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);	
    	        goto SUCCESS_EXIT;
	}
		

	while(1) 
	{
		ub4 rownum = 0;
		if ((rc = GCIStmtFetch(stmt, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
	rc = GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);
    if (rc)
    {
        break;
    }
	
    	for(i=0; i<rownum; i++)
    	{	
            char printfac[21] = {0};
            memcpy(printfac,(ac + len*i),20);
            printfac[20] = '\0';

            printf("afc 3 col 1s arraystruct test %d: %s\n",i,printfac);              

            printf("afc 3 col 2 arraystruct test %d: %d\n",i,*(int *)((char *)bi + i*len));  
		}
	}

	printf("insertwithbindsql recs\n");
	
SUCCESS_EXIT:
    if (pbuf)
        free(pbuf);

	return rc;	
}

int selectdatconverttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp,GCIStmt *stmt,char *sql)
{
	int rc = 0;
    //alloc the stmt handle	
    GCIDefine *Definep[5];
	long i = 0;
	char ac[100][20] = {0};
	int bi[100] = {0};	
	char cc[100][200] = {0};
    sb2 ind[3][100] = {0};
	sb4 starown = 0;

	rc = GCIStmtPrepare(stmt, errhp, (GCIText*)sql, strlen(sql), 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtPrepare selecttest datetime prepare -- !!\n");
		goto SUCCESS_EXIT;
	}
    if ((rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)ac,(sb4)20, (ub2)SQLT_AFC,
                    (dvoid *)ind[0], (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0,(GCIText*)  errstate, &errcode,(GCIText*) errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto SUCCESS_EXIT;
    }   
    if ((rc = GCIDefineByPos(stmt, &Definep[1], errhp, 2, (dvoid *)bi,(sb4)4, (ub2)SQLT_INT,
                       (dvoid *)ind[1], (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
   {
       sb1 errmsg[256] = {0}, errstate[256] = {0};
       sb4 errcode;
       GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
       fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

       goto SUCCESS_EXIT;
   }   
    if ((rc = GCIDefineByPos(stmt, &Definep[2], errhp, 3, (dvoid *)cc,(sb4)200, (ub2)SQLT_CHR,
                       (dvoid *)ind[2], (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
   {
       sb1 errmsg[256] = {0}, errstate[256] = {0};
       sb4 errcode;
       GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
       fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

       goto SUCCESS_EXIT;
   }   


	if (rc = GCIDefineArrayOfStruct(Definep[0], errhp,20, 6, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	} 

	if (rc = GCIDefineArrayOfStruct(Definep[1], errhp,4, 6, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	} 
	if (rc = GCIDefineArrayOfStruct(Definep[2], errhp,200, 6, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	} 

	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
					GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);	
    	        goto SUCCESS_EXIT;
	}
		

	while(1) 
	{
		ub4 rownum = 0;
		if ((rc = GCIStmtFetch(stmt, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;	
			break;
		}
	rc = GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);
    if (rc)
    {
        break;
    }
	
    	for(i=0; i<rownum; i++)
    	{	
            char printfac[21] = {0};
            memcpy(printfac,ac[i],20);
            printfac[20] = '\0';

            printf("afc 3 col 1s arraystruct test %d: %s\n",i,printfac);              

            printf("afc 3 col 2 arraystruct test %d: %d\n",i,bi[i]);  
		}
	}

	printf("insertwithbindsql recs\n");
	
SUCCESS_EXIT:
	return rc;	
}
//char insertsql[] = "insert into  sca_other_warn (occur_time,key_id,bv_id,st_id,bay_id,resp_area,meas_type,restrain_flag,meas_value,status,content,reserv_int1,reserv_int2,customized_group,confirm_status) values (TO_DATE('2018-06-26 10:15:03', 'yyyy-mm-dd hh24:mi:ss'),184929059698900992,-1,-1,-1,-1,-1,0,-1.000000,25,'20180626  10:15:03       test111 㼯ˢ (xa1fes4ж)',0,0,-1, 4)  ; insert into  sca_other_warn (occur_time,key_id,bv_id,st_id,bay_id,resp_area,meas_type,restrain_flag,meas_value,status,content,reserv_int1,reserv_int2,customized_group,confirm_status) values (TO_DATE('2018-06-26 10:15:03', 'yyyy-mm-dd hh24:mi:ss'),184929059698900993,-1,-1,-1,-1,-1,0,-1.000000,25,'20180626  10:15:03       test111 㼯ˢ (xa1fes2ж)',0,0,-1, 4)  ; ";


char insertsql[] = "insert into  proc_warn_info (occur_time,node_id,app_no,proc_alias,status,content,customized_group,confirm_status) values (TO_DATE('2018-06-26 10:15:02', 'yyyy-mm-dd hh24:mi:ss'),%ld,105000,'isw_direct_alarm_recv',6,'2018-06-26 10:15:02      xa1pas1\tscada_isw\t408661\tisw_direct_alarm_recv\t˳\t:ʵʱ̬',5, 4)  ;";
#if 0

insert into  proc_warn_info (occur_time,node_id,app_no,proc_alias,status,content,customized_group,confirm_status) values (TO_DATE('2018-06-26 10:15:02', 'yyyy-mm-dd hh24:mi:ss'),45035996273704980,105000,'isw_direct_alarm_recv',6,'2018-06-26 10:15:02      xa1pas1\tscada_isw\t408661\tisw_direct_alarm_recv\tquit\t:real time state',5, 4)  ;\
insert into  proc_warn_info (occur_time,node_id,app_no,proc_alias,status,content,customized_group,confirm_status) values (TO_DATE('2018-06-26 10:15:02', 'yyyy-mm-dd hh24:mi:ss'),45035996273704981,105000,'isw_direct_alarm_recv',6,'2018-06-26 10:15:02      xa1pas1\tscada_isw\t408661\tisw_direct_alarm_recv\tquit\t:real time state',5, 4)  ;\
insert into  proc_warn_info (occur_time,node_id,app_no,proc_alias,status,content,customized_group,confirm_status) values (TO_DATE('2018-06-26 10:15:02', 'yyyy-mm-dd hh24:mi:ss'),45035996273704982,105000,'isw_direct_alarm_recv',6,'2018-06-26 10:15:02      xa1pas1\tscada_isw\t408661\tisw_direct_alarm_recv\tquit\t:real time state',5, 4)  ;\
insert into  proc_warn_info (occur_time,node_id,app_no,proc_alias,status,content,customized_group,confirm_status) values (TO_DATE('2018-06-26 10:15:02', 'yyyy-mm-dd hh24:mi:ss'),45035996273704983,105000,'isw_direct_alarm_recv',6,'2018-06-26 10:15:02      xa1pas1\tscada_isw\t408661\tisw_direct_alarm_recv\tquit\t:real time state',5, 4)  ;\
insert into  proc_warn_info (occur_time,node_id,app_no,proc_alias,status,content,customized_group,confirm_status) values (TO_DATE('2018-06-26 10:15:02', 'yyyy-mm-dd hh24:mi:ss'),45035996273704984,105000,'isw_direct_alarm_recv',6,'2018-06-26 10:15:02      xa1pas1\tscada_isw\t408661\tisw_direct_alarm_recv\tquit\t:real time state',5, 4)  ;\
insert into  proc_warn_info (occur_time,node_id,app_no,proc_alias,status,content,customized_group,confirm_status) values (TO_DATE('2018-06-26 10:15:02', 'yyyy-mm-dd hh24:mi:ss'),45035996273704985,105000,'isw_direct_alarm_recv',6,'2018-06-26 10:15:02      xa1pas1\tscada_isw\t408661\tisw_direct_alarm_recv\tquit\t:real time state',5, 4)  ;
#endif
long posid =45035996273704973;

int insertbulktest1(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp,GCIStmt *stmt)
{
    char *sqlbuf = NULL;
    
    long sqllen = 0;
    int rc = 0;
    int loop = 0;
    struct timeval a;
    struct timeval b;

    get_now_time(a);
    sqllen = strlen(insertsql) + 100;
    sqlbuf = malloc(sqllen *1000);
    sqllen = 0;

#if 1
    for (loop = 0;loop < 600;loop++)
    {
        sprintf(sqlbuf,insertsql,posid);
        posid++;
        sqllen = strlen(sqlbuf);

#endif


	rc = GCIStmtPrepare(stmt, errhp, sqlbuf, strlen(sqlbuf), 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{

        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");

		goto insertbulktestEXIT;
	}

    //test execute iters param =0; if 0only insert one row 
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");

		goto insertbulktestEXIT;
	}
}
    get_now_time(b);

    printf("timecount %d\n\n",get_time_cut(a,b));

insertbulktestEXIT:
    if (sqlbuf)
      //  free(sqlbuf);
    sqlbuf = NULL;

    return rc;

   
}


int insertbulktest(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp,GCIStmt *stmt)
{
    char *sqlbuf = NULL;
    
    long sqllen = 0;
    int rc = 0;
    int loop = 0;
    struct timeval a;
    struct timeval b;
    sqllen = strlen(insertsql) + 100;
    sqlbuf = malloc(sqllen *1000);
    sqllen = 0;
#if 1
    for (loop = 0;loop < 600;loop++)
    {
        sprintf(sqlbuf+sqllen,insertsql,posid);
        posid++;
        sqllen = strlen(sqlbuf);
    }
#endif
    get_now_time(a);

	rc = GCIStmtPrepare(stmt, errhp, sqlbuf, strlen(sqlbuf), 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{

        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");

		goto insertbulktestEXIT;
	}
    /*  
    get_now_time(b);            
                   printf("timecount %d\n\n",get_time_cut(a,b));

*/
    //test execute iters param =0; if 0only insert one row 
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");

		goto insertbulktestEXIT;
	}

    get_now_time(b);            
                   printf("timecount %d\n\n",get_time_cut(a,b));

insertbulktestEXIT:
    if (sqlbuf)
      //  free(sqlbuf);
    sqlbuf = NULL;

    return rc;

   
}

int insertfltconverttable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp,GCIStmt *stmt,char *sql)
{
	int rc = 0;
	//alloc the stmt handle
	GCIBind *Bindp[5];

	char ac[100][20] ;
	int bi[100] = {0};
	char cc[100][200];
    sb2 ind[3][100] ;
    int i = 0;

	int len = (4 + 20+200);

	rc = GCIStmtPrepare(stmt, errhp, sql, strlen(sql), 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}

	if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)ac,(sb4)20,SQLT_AFC,ind[0],NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	


	if(rc = GCIBindByPos(stmt,&Bindp[1],errhp,2,(dvoid *)bi,(sb4)4,SQLT_INT,ind[1],NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}			

	if(rc = GCIBindByPos(stmt,&Bindp[2],errhp,3,(dvoid *)cc,(sb4)200,SQLT_CHR,ind[2],NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind 3 parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	

	rc =  GCIBindArrayOfStruct(Bindp[0],errhp,20,6,0,0);
	rc =  GCIBindArrayOfStruct(Bindp[1],errhp,4,6,0,0);	
	rc =  GCIBindArrayOfStruct(Bindp[3],errhp,200,6,0,0);	

	for(i = 0;i < 100;i++)
	{
		bi[i] = i;
#ifdef WIN32
		_snprintf(cc[i],200,"ǵ%d̫,llllllllllllllllllllllllllllllllllllllllllllllllllllllll01234567890",i);
		_snprintf(ac[i],20,"ǵ%d̫,01234567890",i);
#else
		snprintf(cc[i],200,"ǵ%d̫,llllllllllllllllllllllllllllllllllllllllllllllllllllllll01234567890",i);
		snprintf(ac[i],20,"ǵ%d̫,01234567890",i);
#endif
        ac[i][19] = 'O';
		//execute
	}
    //test execute iters param =0; if 0only insert one row 
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		printf("GCIStmtExecute error %d\n",i);
		goto insertmultithreadtableEXIT;
	}


	printf("insertwithbindsql dectable 100 recs\n");
	
insertmultithreadtableEXIT:

	return rc;	
}
int selafctable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp,GCIStmt *stmt,char *sql)
{
	int rc = 0;
	GCIDefine *Definep[5];
	long i = 0;
	char ac[100][20] = {0,0};
    sb2 ind[100] = {0};
    sb4 colnum11 = 0;
    char *colname = {0};
    char *coltypename = {0};
    GCIParam *param = NULL;
    ub2 type = 0;
    sb2 precision = 0;
    sb2 scale = 0;
    sb1 scale1 = 0;

	rc = GCIStmtPrepare(stmt, errhp, sql, strlen(sql), 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}

    if (rc = GCIAttrGet (stmt, GCI_HTYPE_STMT,&colnum11, 0,GCI_ATTR_NUM_COLS,errhp) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
        goto insertmultithreadtableEXIT;
    }       

    printf("selafctable show the colname :colnum %d\n",colnum11);

    for(i = 0;i< colnum11;i++)
    {
        rc = GCIParamGet((CONST dvoid *)stmt,(ub4)GCI_HTYPE_STMT,(GCIError *)errhp,(dvoid **)&param,(ub4)i+1);
        
        if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&colname, 0,GCI_ATTR_NAME,errhp) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

            fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
            goto insertmultithreadtableEXIT;
        }   
        if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&type, 0,GCI_ATTR_DATA_TYPE,errhp) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

            fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
            goto insertmultithreadtableEXIT;
        }   
        if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&precision, 0,GCI_ATTR_PRECISION,errhp) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

            fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
            goto insertmultithreadtableEXIT;
        }   
            if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&scale, 0,GCI_ATTR_SCALE,errhp) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

            fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
            goto insertmultithreadtableEXIT;
        }   
        
        if (rc = GCIAttrGet (param, GCI_DTYPE_PARAM,&coltypename, 0,GCI_ATTR_TYPE_NAME,errhp) != GCI_SUCCESS)
        {
            sb1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "do_select_ext_test Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

            fprintf(stdout, "\tError in Step A -- GCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
            goto insertmultithreadtableEXIT;
        }           
                scale1 = scale;
        fprintf(stdout, "selectdatconverttable2 show the colname %s coltype %d col type %s,COL precision %d,scale %d\n",colname,type,coltypename,precision,scale1);
        memset(colname,0 ,sizeof(colname));
    }

    if ((rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)ac,(sb4)20, (ub2)SQLT_AFC,
                    (dvoid *)ind, (ub2 *)0, (ub2 *)0, GCI_DEFAULT)) != GCI_SUCCESS)
    {
        sb1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

        goto insertmultithreadtableEXIT;
    }   
	if (rc = GCIDefineArrayOfStruct(Definep[0], errhp,0, 2, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	} 
    //test execute iters param =0; if 0only insert one row 
	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS);
	if(rc)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode, (GCIText *)errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		
		goto insertmultithreadtableEXIT;

	}

	while(1) 
	{
		ub4 rownum = 0;
		if ((rc = GCIStmtFetch(stmt, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto insertmultithreadtableEXIT;	
			break;
		}
		rc = GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
              fprintf(stdout, "GCI_ATTR_ROW_COUNT %d\n",rownum);          

		rc = GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROWS_FETCHED, errhp);
              fprintf(stdout, "GCI_ATTR_ROWS_FETCHED %d\n",rownum);          

        if (rc)
        {
            break;
        }
        for (i = 0;i < rownum;i++)
        {
            char printfac[21] = {0};
            memcpy(printfac,ac[i],20);
            printfac[20] = '\0';
            printf("afc single col arraystruct test %d: %s\n",i,printfac);        
        }
	}

insertmultithreadtableEXIT:
	return rc;	
}

/*
 * This function allocates the row and collection buffers, passes
 * them to the do_select_storebyxxx() function, along with an appropriate select
 * statement and then frees all allocated handles.
 */
int main (long argc,
		char* argv[])
{
	ub4			i, in;

	ub1         verInfoBuffer[SELSQL_LEN];
	ub4			verInfoLen;
	ub1         majorVer[3];
	ub4      	isUdoEnabled;
	int rc = 0;
	/* Handles */
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;
	GCIStmt *stmthp1 = NULL;
	GCIStmt *stmthp2 = NULL;
    //for (;;)
    {
 	rc = logdb(&envhp,&errhp,&svchp);
	if(rc)
	{
		goto EXIT;
	}
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp1,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto EXIT;
	}    
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp2,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto EXIT;
	}    
#if 0    
	rc = dropdatconverttable(envhp,svchp,errhp,stmthp1,dropflttable1);
	rc = dropdatconverttable(envhp,svchp,errhp,stmthp1,createdattable);
	if(rc)
	{
		fprintf (stdout, "create table failure.\n");
		goto EXIT;
	}	
    rc = insertfltconverttable(envhp,svchp,errhp,stmthp1,insertdatadectable);
    if(rc)
    {
        fprintf (stdout, "insertfltconverttable table failure.\n");
        goto EXIT;
    }   
    rc = selectdatconverttablebyrow(envhp,svchp,errhp,stmthp1,selectdatadec1table1);
    if(rc)
    {
        fprintf (stdout, "creselectdatconverttablebyrowate table failure.\n");
        goto EXIT;
    }   
    rc = selafctable(envhp,svchp,errhp,stmthp1,selectdatadec1table);
    if(rc)
    {
        fprintf (stdout, "selafctable table failure.\n");
        goto EXIT;
    }   

    rc = selectdatconverttable(envhp,svchp,errhp,stmthp1,selectdatadec1table1);
    if(rc)
    {
        fprintf (stdout, "selectdatconverttable 1 table failure.\n");
        goto EXIT;
    }   
#endif
    rc  =   insertbulktest(envhp,svchp,errhp,stmthp1);
    if(rc)
    {
        fprintf (stdout, "insertbulktest 1 table failure.\n");
        goto EXIT1;
    }   

goto EXIT1;

EXIT:
    GCILogoff(svchp, errhp);

	if(envhp)
        GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);
    }
EXIT1:

	/* CLEANUP: Close the statement handle
	 **          Free the statement handle
	 **          Disconnect from the datasource
	 **          Free the connection and environment handles
	 **          Exit
	 */


	GCILogoff(svchp, errhp);

	if(envhp)
        GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);

	fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
	in = getchar ();

	return (rc);
}

