/***************************************************************************
*	Licensed Materials - Property of GBase
*
*
*	"Restricted Materials of GBase"
*
*
*
*	GBase 8s GCI Interface demo
*
*
*	Copyright GBase Corporation 2015 All rights reserved.
*
*
*
*
*
*  Title:          test_smoke.c
*
*  Description:    To show how to use the transaction function of the 
*                  database. 
*                  
*
***************************************************************************
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "gci.h"
#include "test_smoke.h"

#define SELSQL_LEN     25
#define ERRMSG_LEN     200


int
read_from_loc(GCISvcCtx *svchp,
                GCIError *errhp,
                GCILobLocator *lobp)
{
        ub1 *buf;
        ub4 amtp;
        ub4 lenp=100;
        ub4 readsize = 0;
        sb4 err;

        err = GCILobGetLength(svchp, errhp, lobp, &lenp);
        if(err != GCI_SUCCESS)
        {
                sb1 errmsg[256] = {0}, errstate[256] = {0};
                sb4 errcode;
                GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
                fprintf(stdout, "\t\tError code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);

                return err;
        }
	fprintf (stdout, "length = %d\t", lenp);

        buf = (ub1 *)malloc(sizeof(ub1)*(lenp+1));
        buf[lenp] = '\0';

        do
        {
                amtp = 1;
                err = GCILobRead(svchp, errhp, lobp, &amtp,0,
                                buf+readsize,lenp-readsize,NULL,
                                NULL,0,0);

                if(err == GCI_SUCCESS || err == GCI_NEED_DATA)
                        readsize += amtp;
        }while(err == GCI_NEED_DATA);

        fprintf (stdout, "contents = %s\n", buf);

        free(buf);

        return GCI_SUCCESS;
}

int do_select_multitype_t1(GCIEnv *envhp,
			GCISvcCtx *svchp,
			GCIStmt *stmthp,
			GCIError *errhp)
{
	int rc = 0, i = 0;
	int number = 0;
	sb1  *result_a = (sb1 *)malloc(sizeof(sb1) * 20 * 100);
	sb1  *result_b = (sb1 *)malloc(sizeof(sb1) * 20 * 100);
	sb1  *result_c = (sb1 *)malloc(sizeof(sb1) * 20 * 100);
	sb8  *result_d = (sb8 *)malloc(sizeof(sb8) * 100);
	sb8  *result_e = (sb8 *)malloc(sizeof(sb8) * 100);
	sb8  *result_f = (sb8 *)malloc(sizeof(sb8) * 100);
	sb4  *result_g = (sb4 *)malloc(sizeof(sb4) * 100);
	sb4  *result_h = (sb4 *)malloc(sizeof(sb4) * 100);
	float  *result_i = (float *)malloc(sizeof(float) * 100);
	sb8  *result_j = (sb8 *)malloc(sizeof(sb8) * 100);
	GCILobLocator *blob[100] = { (GCILobLocator *)0 };
	GCILobLocator *clob[100] = { (GCILobLocator *)0 };
	GCIDate result_m[100];

	sb2  null_blob[100] = {0};
	sb2  null_clob[100] = {0};

	GCIDefine *bndhp[13];
	sb4 starown = 0;

	memset(result_a, 0, sizeof(sb1) * 20 * 100);
	memset(result_b, 0, sizeof(sb1) * 20 * 100);
	memset(result_c, 0, sizeof(sb1) * 20 * 100);
	memset(result_d, 0, sizeof(sb8) * 100);
	memset(result_e, 0, sizeof(sb8) * 100);
	memset(result_f, 0, sizeof(sb8) * 100);
	memset(result_g, 0, sizeof(sb4) * 100);
	memset(result_h, 0, sizeof(sb4) * 100);
	memset(result_i, 0, sizeof(float) * 100);
	memset(result_j, 0, sizeof(sb8) * 100);

	for (i = 0; i < 100; i++)
	{
		if (rc = GCIDescriptorAlloc(envhp, (dvoid **)&blob[i], GCI_DTYPE_LOB, 0, NULL) != GCI_SUCCESS)
		{
			fprintf(stdout, "\tAllocByBlob: alloc failed.\nExiting!!\n");
			goto EXIT;
		}

        	if (rc = GCIDescriptorAlloc(envhp, (dvoid **)&clob[i], GCI_DTYPE_LOB, 0, NULL) != GCI_SUCCESS)
		{
			fprintf(stdout, "\tAllocByClob: alloc failed.\nExiting!!\n");
			goto EXIT;
		}
	}

	if (rc = GCIDefineByPos(stmthp, &bndhp[0], errhp, 1, (dvoid *)result_a, (sb1)20, (ub2)SQLT_STR,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tGCIDefineByPos: define handle by pos 1 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[1], errhp, 2, (dvoid *)result_b, (sb1)20, (ub2)SQLT_STR,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tGCIDefineByPos: define handle by pos 2 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[2], errhp, 3, (dvoid *)result_c, (sb1)20, (ub2)SQLT_STR,
			(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tGCIDefineByPos: define handle by pos 3 failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[3], errhp, 4, (dvoid *)result_d, (sb8)sizeof(sb8), (ub2)SQLT_INT,
                        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
        {
                fprintf(stdout, "\tGCIDefineByPos: define handle by pos 4 failed.\nExiting!!\n");
                goto EXIT;
        }

	if (rc = GCIDefineByPos(stmthp, &bndhp[4], errhp, 5, (dvoid *)result_e, (sb8)sizeof(sb8), (ub2)SQLT_INT,
                        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
        {
                fprintf(stdout, "\tGCIDefineByPos: define handle by pos 5 failed.\nExiting!!\n");
                goto EXIT;
        }

	if (rc = GCIDefineByPos(stmthp, &bndhp[5], errhp, 6, (dvoid *)result_f, (sb8)sizeof(sb8), (ub2)SQLT_INT,
                        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
        {
                fprintf(stdout, "\tGCIDefineByPos: define handle by pos 6 failed.\nExiting!!\n");
                goto EXIT;
        }
	
	if (rc = GCIDefineByPos(stmthp, &bndhp[6], errhp, 7, (dvoid *)result_g, (sb4)sizeof(sb4), (ub2)SQLT_INT,
                        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
        {
                fprintf(stdout, "\tGCIDefineByPos: define handle by pos 7 failed.\nExiting!!\n");
                goto EXIT;
        }

	if (rc = GCIDefineByPos(stmthp, &bndhp[7], errhp, 8, (dvoid *)result_h, (sb4)sizeof(sb4), (ub2)SQLT_INT,
                        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
        {
                fprintf(stdout, "\tGCIDefineByPos: define handle by pos 8 failed.\nExiting!!\n");
                goto EXIT;
        }

	if (rc = GCIDefineByPos(stmthp, &bndhp[8], errhp, 9, (dvoid *)result_i, (sb8)sizeof(float), (ub2)SQLT_FLT,
                        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
        {
                fprintf(stdout, "\tGCIDefineByPos: define handle by pos 9 failed.\nExiting!!\n");
                goto EXIT;
        }

	if (rc = GCIDefineByPos(stmthp, &bndhp[9], errhp, 10, (dvoid *)result_j, (sb8)sizeof(sb8), (ub2)SQLT_INT,
                        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
        {
                fprintf(stdout, "\tGCIDefineByPos: define handle by pos 10 failed.\nExiting!!\n");
                goto EXIT;
        }

	if (rc = GCIDefineByPos(stmthp, &bndhp[10], errhp, 11, (dvoid *)blob, 4, (ub2)SQLT_BLOB,
                        (dvoid *)null_blob, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
        {
                fprintf(stdout, "\tGCIDefineByPos: define handle by pos 11 failed.\nExiting!!\n");
                goto EXIT;
        }

	if (rc = GCIDefineByPos(stmthp, &bndhp[11], errhp, 12, (dvoid *)clob, 4, (ub2)SQLT_CLOB,
                        (dvoid *)null_clob, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
        {
                fprintf(stdout, "\tGCIDefineByPos: define handle by pos 12 failed.\nExiting!!\n");
                goto EXIT;
        }

	if (rc = GCIDefineByPos(stmthp, &bndhp[12], errhp, 13, (dvoid *)result_m, (sb4)sizeof(GCIDate), (ub2)SQLT_ODT,
                        (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
        {
                fprintf(stdout, "\tGCIDefineByPos: define handle by pos 13 failed.\nExiting!!\n");
                goto EXIT;
        }

	fprintf (stdout, "\tGCIDefineByPos: Define handle by pos success.\n");
	
	if (rc = GCIStmtExecute(svchp, stmthp, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
			GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tGCIStmtExecDirect: execute select statement failed.\nExiting!!\n");
		goto EXIT;
	}
	
	fprintf (stdout, "\tGCIStmtExecDirect: Execute select statement success.\n");
	

	while(1) 
	{
		ub4 rownum = 0;
		int i;

		if (rc = GCIStmtFetch(stmthp, errhp, 1, GCI_FETCH_NEXT, 0) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tGCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;		
			break;
		}
		GCIAttrGet(stmthp, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
		
		if(starown == rownum)
			break;
			
		for(i=0; i<rownum-starown; i++)
		{	
			fprintf(stdout, "\tRetrieving row number %d:\n", ++number);
			fprintf(stdout, "\t\ta -- %s\n", result_a + i * 20);
			fprintf(stdout, "\t\tb -- %s\n", result_b + i * 20);
			fprintf(stdout, "\t\tc -- %s\n", result_c + i * 20);
			fprintf(stdout, "\t\td -- %ld\n", *(result_d + i));
			fprintf(stdout, "\t\te -- %ld\n", *(result_e + i));
			fprintf(stdout, "\t\tf -- %ld\n", *(result_f + i));
			fprintf(stdout, "\t\tg -- %d\n", *(result_g + i));
			fprintf(stdout, "\t\th -- %d\n", *(result_h + i));
			fprintf(stdout, "\t\ti -- %f\n", *(result_i + i));
			fprintf(stdout, "\t\tj -- %ld\n", *(result_j + i));
			if (null_blob[i] == -1)
			{
				fprintf(stdout, "\t\tk -- null\n");
			}
			else
			{
				fprintf(stdout, "\t\tk -- ");
				if (read_from_loc(svchp, errhp, blob[i]) != GCI_SUCCESS)
					goto EXIT;
			}
			if (null_clob[i] == -1)
			{
				fprintf(stdout, "\t\tl -- null\n");
			}
			else
			{
                        	fprintf(stdout, "\t\tl -- ");
				if (read_from_loc(svchp, errhp, clob[i]) != GCI_SUCCESS)
					goto EXIT;
			}
			fprintf(stdout, "\t\tm -- %d-%d-%d %d:%d:%d\n", result_m[i].GCIDateYYYY,result_m[i].GCIDateMM,result_m[i].GCIDateDD,result_m[i].GCIDateTime.GCITimeHH,result_m[i].GCIDateTime.GCITimeMI,result_m[i].GCIDateTime.GCITimeSS);
		}
		
		starown = rownum;
	}

SUCCESS_EXIT:
	
    fprintf (stdout, "\tGCIStmtFetch: Retrieve the results success.\n");

EXIT:
	free(result_a);	
	free(result_b);	
	free(result_c);
	free(result_d);
	free(result_e);
	free(result_f);
	free(result_g);
	free(result_h);
	free(result_i);
	free(result_j);
	for (i = 0; i < 100 ; i++)
	{
		if(blob[i])
        	{
        		GCIDescriptorFree(blob[i], GCI_DTYPE_LOB);
                	blob[i] = NULL;
		}
		if(clob[i])
                {
                        GCIDescriptorFree(clob[i], GCI_DTYPE_LOB);
                        clob[i] = NULL;
                }
        }
	
    return rc;
}

int do_select_item(GCISvcCtx *svchp,
		       GCIStmt *stmthp,
		       GCIError *errhp)
{
	int rc = 0;
	return rc;
}

int do_select_orders(GCISvcCtx *svchp,
	               GCIStmt *stmthp,
		       GCIError *errhp)
{
	int rc = 0;
	return rc;
}

/* This function start a transaction to edit the database then use the 
 * do_select_storebycol() function to show the result of the commit 
 * function and rollback function.
 */
int main (long argc,
          char* argv[])
{
	/* Declare variables */

    	ub4	i, in;

    	ub1     ServerSession[20];
    	ub1     verInfoBuffer[SELSQL_LEN];
    	ub4	verInfoLen;
    	ub1     majorVer[3];
    	ub4     isUdoEnabled;
	ub1     insertStmt[BUFFER_LEN];
   
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;
	GCIStmt *stmthp = NULL;

	int rc = GCI_SUCCESS;

	GCItext *dbname = (GCItext*)"smoketest";//"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";

    	/*  STEP 1. Get data source name from command line (or use default)
    	**          Allocate the environment handle and set ODBC version
    	**          Allocate the connection handle
    	**          Establish the database connection
    	**          Allocate the statement handle
    	**          Drop demo database if it already exists
    	*/
    

	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
			0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
			GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto EXIT;
	}	
	
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
			GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto EXIT;
	}
#if 1
	if(rc = GCILogonNoDb(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
			pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
		fprintf(stdout, "GCILogon: logon to database failed.\nExiting!!\n");
		goto EXIT;
	}
#endif	

#if 1
if(rc = GCIStmtExecDirect(svchp, (ub1*) "DROP DATABASE IF EXISTS smoketest", errhp, 0, 0, 0, 0, GCI_DEFAULT))
	{
        	fprintf (stdout, "GCIDropdb: drop database failed..\n");
		goto EXIT;
	}

	fprintf (stdout, "\nCreate database and tables\n");
	for (i = 0; i < NUM_DBCREATE_STMTS; i++)
        {
            fprintf (stdout, "Executing stmt %d of %d\n", i+1, NUM_DBCREATE_STMTS);
            if(rc = GCIStmtExecDirect(svchp, createUdoDbStmts[i], errhp, 0, 0, 0, 0, GCI_DEFAULT) != GCI_SUCCESS)
            {
                     sb1 errmsg[256] = {0}, errstate[256] = {0};
                     sb4 errcode;
                     GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
                     fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
                     fprintf(stdout, "setp 1 GCIStmtExecDirect: direct execute statement failed\nExiting!!\n");
                     goto EXIT;
            }
        }
	#endif


	#if 1
	fprintf (stdout, "Prepare data for customer\n");
	for (i = 0; i < NUM_MULTITYPE; i++)
    	{
        	fprintf (stdout, "Inserting row # %d\n", i+1);
	        memset(insertStmt, 0, BUFFER_LEN);
	        strcpy ((char *) insertStmt, (char *) insertDBStmts[0]);
	        strcat ((char *) insertStmt, (char *) udoCust[i]);
        
	        fprintf(stdout,"%s\n",insertStmt);
		
		if(rc = GCIStmtExecDirect(svchp, insertStmt, errhp, 0, 0, 0, 0, GCI_DEFAULT) != GCI_SUCCESS)
        	{
			sb1 errmsg[256] = {0}, errstate[256] = {0};
			sb4 errcode;
			GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
			fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
                        fprintf(stdout, "step 2 GCIStmtExecDirect: direct execute statement failed\nExiting!!\n");
                        goto EXIT;
                }
		GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
        	stmthp = NULL;

	}
	#endif

	#if 1
	
	fprintf (stdout, "\nupdate multitype_t1 set c='gbase8s' where a='ta'\n");
        if (rc = GCIStmtExecDirect(svchp, (ub1*) "update multitype_t1 set c='gbase8s' where a='ta'", errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,GCI_DEFAULT) != GCI_SUCCESS)
        {
                fprintf(stdout, "GCIStmtExecDirect: execute sql statement failed.\nExiting!!\n");
                goto EXIT;

        }

	        if(rc = GCITransCommit(svchp, errhp, (ub4)0) != GCI_SUCCESS)
		        {
			                fprintf (stdout, "commit transaction failed.\nExiting!!\n");
				                goto EXIT;
					        }
	        fprintf (stdout, "End commit transaction.\n");	


		fprintf (stdout, "select * from multitype_t1 where a='ta'\n");
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if(rc = GCIStmtPrepare(stmthp, errhp, "select * from multitype_t1 where a='ta'", sizeof("select * from multitype_t1 where a='ta'"), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}
        
	if (do_select_multitype_t1(envhp, svchp, stmthp, errhp))
	{
		fprintf(stdout, "select and retrieve results stored by column buffer failed.\nExiting!!\n");
		goto EXIT;
	}

	GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);

	stmthp = NULL;
	fprintf (stdout, "select and retrieve RAW results stored by column buffer success.\n");
	
	fprintf (stdout, "\ninsert in trans and commit\n");
	fprintf (stdout, "Begin start and commit transaction, insert into values('ra','rb','rc',99999,99999,99999,-66,-66,12.3,-45,null,null,'6-1-1 12:34:56.908');\n");
#endif
#if 1
#if 1
	if(rc = GCITransStart(svchp, errhp, 60, GCI_TRANS_NEW) != GCI_SUCCESS)
	{
    		fprintf(stdout, "start transaction failed.\nExiting!!\n");
		goto EXIT;
	}
#endif
#if 1
	if (rc = GCIStmtExecDirect(svchp, (ub1 *)"insert into multitype_t1 values('ra','rb','rc',99999,99999,99999,-66,-66,12.3,-45,null,null,'6-1-1 12:34:56.908')", errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
	        GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "GCIStmtExecDirect: execute sql statement failed.\nExiting!!\n");
		goto EXIT;
	}	
#endif
#if 1
	fprintf (stdout, "Begin commit transaction.\n");
	if(rc = GCITransCommit(svchp, errhp, (ub4)0) != GCI_SUCCESS)
	{
		fprintf (stdout, "commit transaction failed.\nExiting!!\n");
		goto EXIT;
	}
	fprintf (stdout, "End commit transaction.\n");
#endif	
#endif
#if 1
	fprintf (stdout, "select * from multitype_t1 where a='ra';\n");
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}	
    
        if(rc = GCIStmtPrepare(stmthp, errhp, "select * from multitype_t1 where a='ra'", sizeof("select * from multitype_t1 where a='ra'"), 0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}
	
	if (do_select_multitype_t1(envhp, svchp, stmthp, errhp))
	{
		fprintf (stdout, "select and retrieve results stored by column buffer failed.\nExiting!!\n");	
		goto EXIT;
	}
	GCITransCommit(svchp, errhp, (ub4)0) ;
	GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
	stmthp = NULL;
	fprintf (stdout, "select and retrieve insertt results stored by column buffer success.\n");

	fprintf (stdout, "\nupdate in trans and rollback\n");
        fprintf (stdout, "Begin start and rollback transaction, update multitype_t1 set e=88888 where a='ra'\n");
#if 1
	if(rc = GCITransStart(svchp, errhp, 60, GCI_TRANS_NEW) != GCI_SUCCESS)
        {
	        fprintf(stdout, "start transaction failed.\nExiting!!\n");
		goto EXIT;
	}

	if (rc = GCIStmtExecDirect(svchp, (ub1 *)"update multitype_t1 set e=88888 where a='ra'", errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,GCI_DEFAULT) != GCI_SUCCESS)
	{
		fprintf(stdout, "GCIStmtExecDirect: execute sql statement failed.\nExiting!!\n");
	       	goto EXIT;
										        
	}

	fprintf (stdout, "Rollback transaction.\n");
        if(rc = GCITransRollback(svchp, errhp, (ub4)0) != GCI_SUCCESS)
	{
		fprintf (stdout, "rollback transaction failed.\nExiting!!\n");
		goto EXIT;

	}
	fprintf (stdout, "End rollback transaction.\n");

	fprintf (stdout, "select * from multitype_t1 where a='ra';\n");
        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp, GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
        fprintf(stdout, "GCIHandleAlloc: allocate stmp handle failed.\nExiting!!\n");
	goto EXIT;
        }

	if(rc = GCIStmtPrepare(stmthp, errhp, "select * from multitype_t1 where a='ra'", sizeof("select * from multitype_t1 where a='ra'"), 0, GCI_DEFAULT) != GCI_SUCCESS)
        {
		fprintf(stdout, "GCIStmtPrepare: prepare stmp handle failed.\nExiting!!\n");
		goto EXIT;
	}
	if (do_select_multitype_t1(envhp, svchp, stmthp, errhp))
	{
		fprintf (stdout, "select and retrieve results stored by column buffer failed.\nExiting!!\n");
		goto EXIT;
	}
	GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
	stmthp = NULL;
	fprintf (stdout, "select and retrieve insertt results stored by column buffer success.\n");

#endif
#endif
		if(rc = GCIStmtExecDirect(svchp, (ub1*)"close database", errhp, 0, 0, 0, 0, GCI_DEFAULT))
        {
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
                fprintf (stdout, "GCIClosedb: close database failed..\n");
                goto EXIT;
        }
	if(rc = GCIStmtExecDirect(svchp, (ub1*)"DROP DATABASE IF EXISTS gci_trans_db", errhp, 0, 0, 0, 0, GCI_DEFAULT))
        {
                fprintf (stdout, "GCIDropdb: drop database failed..\n");
                goto EXIT;
        }

EXIT:

    /* CLEANUP: Close the statement handle
    **          Free the statement handle
    **          Disconnect from the datasource
    **          Free the connection and environment handles
    **          Exit
    */

	
    if(stmthp)
    {	    
	GCIHandleFree((dvoid *)stmthp, GCI_HTYPE_STMT);
	stmthp = NULL;
    }
	
    GCILogoff(svchp, errhp);
		
    if(svchp)
	GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);
	
    if(errhp)
	GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);
	
    if(envhp)
	GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);
	
    fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
    in = getchar ();
    
    return (rc);
}
