/***************************************************************************
*	Licensed Materials - Property of GBase
*
*
*	"Restricted Materials of GBase"
*
*
*
*	GBase 8s GCI Interface demo
*
*
*	(C) Copyright GBase Corporation 2015 All rights reserved.
*
*
*
*
*
*  Title:          test_dbcreate.h
*
*  Description:    Header file for test_dbcreate.c 
*                  Contains the arrays containg the SQL statements to 
*                  create the sample database and arrays of the data to 
*                  be loaded
*
***************************************************************************
*/


#define NUM_DBCREATE_STMTS      3	
#define NUM_INSERT_STMTS	3

#define NUM_MULTITYPE	        2	
#define NUM_ITEMS			4
#define NUM_ORDERS			9

#define BUFFER_LEN     1000

#include "gci.h"




/*********************************************************************************
**
**  SQL STATEMENT BUFFERS
**
**********************************************************************************
*/

/*  SQL Statements for creating the sample database for UDO enabled
**  database servers (version number > 9)
*/

ub1 createUdoDbStmts[NUM_DBCREATE_STMTS][BUFFER_LEN] = 
     {	"create database smoketest with log;",
	"database smoketest;",
	"create table multitype_t1(a NCHAR(20),\
				   b CHAR(20),\
				   c CHARACTER(20),\
				   d INT8,\
				   e Bigint,\
				   f Bigserial,\
				   g INT,\
				   h INTEGER,\
				   i FLOAT,\
				   j BIGINT,\
				   k Blob,\
	 			   l Clob,\
				   m DATETIME year to fraction);"				       
     };



/*  SQL Statements for creating the sample database for non-UDO enabled
**  database servers (version number < 9)
*/

ub1 createNonUdoDbStmts[NUM_DBCREATE_STMTS][BUFFER_LEN] = 
     {"create database smoketest with log;",
      "database smoketest;",
      "create table multitype_t1(a NCHAR(20),b CHAR(20),c CHARACTER(20),d INT8,e Bigint,f Bigserial,g INT,h INTEGER,i FLOAT,j BIGINT,k Blob);"     
     };



/*  SQL Statements for inserting data into the sample database 
*/

ub1 insertDBStmts[NUM_INSERT_STMTS][BUFFER_LEN] = 
     {"INSERT INTO multitype_t1 VALUES "
     };





/*********************************************************************************
**
**  DATA BUFFERS -- table 'CUSTOMER'
**
**********************************************************************************
*/

/*  Array containing values to be inserted into the 'customer' table for UDO 
**  enabled database servers (version number > 9)
*/


ub1 udoCust[NUM_MULTITYPE][BUFFER_LEN] = 
    {"('ta','tb','tc',-9223372036854775807,-9223372036854775807,-9223372036854775807,-2147483647,-2147483647,15.100009,-9223372036854775807,\
     null, null,'6-1-1 12:34:56.908')",
     "('ba','bb','bc',9223372036854775807,9223372036854775807,9223372036854775807,2147483647,2147483647,15.100009,9223372036854775807,null,\
     null,'6-1-1 12:34:56.908')"	    
    };



/*  Array containing values to be inserted into the 'customer' table for non-UDO 
**  enabled database servers (version number < 9)
*/


ub1 nonUdoCust[NUM_MULTITYPE][BUFFER_LEN] = 
    {"('ta','tb','tc',-9223372036854775807,-9223372036854775807,-9223372036854775807,-2147483647,-2147483647,15.100009,-9223372036854775807,\
     null,null,'6-1-1 12:34:56.908')",
     "('ba','bb','bc',9223372036854775807,9223372036854775807,9223372036854775807,2147483647,2147483647,15.100009,9223372036854775807,null,\
     null,'6-1-1 12:34:56.908')"};


