#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gci.h"
#define SELSQL_LEN     25
#define ERRMSG_LEN     200

#define SQLMSG                  ub1 errmsg[256] = {0}, errstate[256] = {0};\
				sb4 errcode;\
                                GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);\
                                fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
char *createdattable = "create table datconvert (id int,times date)";
char *insertdatadattable = "insert into datconvert values(1,01-01-1999)";
//char *insertdatadattable = "insert into datconvert values(1,NULL)";
char * selectdatconvert = "select id,times from datconvert where 1=1";

int logdb(GCIEnv **envhp1,GCIError **errhp1,GCISvcCtx **svchp1)
{
     int rc = GCI_SUCCESS;
     GCIEnv *envhp= NULL;
     GCISvcCtx *svchp= NULL;
     GCIError *errhp = NULL;
     GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";
     GCItext *user = (GCItext*)"gbasedbt";
     GCItext *pswd = (GCItext*)"Big4ifmx";

     if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
                             0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
     {
            fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
            goto logdbEXIT;
     }
     if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
                             GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
     {
            fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
            goto logdbEXIT;
     }


      if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
                              pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
     {
              fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
              goto logdbEXIT;
     }

     *envhp1 = envhp;
     *errhp1 = errhp;
     *svchp1 = svchp;

     fprintf (stdout, "Step 1 done...connected to database.\n");
logdbEXIT:
          *envhp1 = envhp;
          *errhp1 = errhp;
          *svchp1 = svchp;
          return rc;
}
char *createsql = "create table if not exists tcore (t varchar(50))";
char *selectcore = "select t from tcore";
char *insertcore = "insert into tcore(t) values(?)";
int createtable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp,char *sql)
{
	int rc = 0;
	GCIStmt *stmt = NULL;
    char *pbuf = NULL;
    long loop = 0;
    long i = 0;
    long item_num = 0;

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
                    GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
        goto EXIT;
    }   

    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)sql, strlen(sql) + 1, 0, GCI_DEFAULT);  
    
    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
                GCI_COMMIT_ON_SUCCESS);
    
    if(rc)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto EXIT;
    }


EXIT:
    if (stmt)
        GCIHandleFree(stmt, GCI_HTYPE_STMT);
    return rc; 
}

int insertcoretable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp,char *sql)
{
	int rc = 0;
	GCIStmt *stmt = NULL;
    GCIBind *Bindp[1] ={0};
    char *pbuf = NULL;
    long loop = 0;
    long i = 0;
    long item_num = 0;

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
                    GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
        goto EXIT;
    }   

    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)sql, strlen(sql) + 1, 0, GCI_DEFAULT); 
    if(rc)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto EXIT;
    } 
    pbuf = (char *)malloc(50*20);
    if (!pbuf)
        goto EXIT;

   	if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)pbuf,(sb4)50,SQLT_CHR,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
        {
            printf("in select lobdataGCI:BindByPos p2 error!\n\n");
            goto EXIT;
        }
    memset(pbuf,0,50*20);

    for (i= 0;i< 12;i++)
    {
        sprintf(pbuf+50*i,"test %d",i);
    }
    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)12, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
                GCI_COMMIT_ON_SUCCESS);
    
    if(rc)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto EXIT;
    }


EXIT:
    if (stmt)
        GCIHandleFree(stmt, GCI_HTYPE_STMT);
    if (pbuf)
        free(pbuf);
    pbuf = NULL;
    return rc; 
}

int testselectcore(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;
    GCIDefine *Definep[1] = {0};
    char *pbuf = NULL;
    long loop = 0;
    long i = 0;
    long item_num = 0;
    sb2 ind[20];
	sb4 starown;

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
                    GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
        goto EXIT;
    }   
    pbuf = (char *)malloc(50*20);
    if (!pbuf)
        goto EXIT;
    memset(&ind,0,sizeof(int));
    memset(pbuf,0,1000);

    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)selectcore, strlen(selectcore) + 1, 0, GCI_DEFAULT);

    if (rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)pbuf,(sb4)50, (ub2)SQLT_AFC,
                (dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto EXIT;
    }
    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
                GCI_COMMIT_ON_SUCCESS);

    if(rc)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto EXIT;
    }

 	starown = 0;

	while(1)
	{
		ub4 rownum = 0;
		if ((rc = GCIStmtFetch(stmt, errhp, 20, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto EXIT;
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
        printf("+++++++++++++++++++++%d\n",rownum);


		if(starown == rownum)
			break;

		starown = rownum;
	}   

EXIT:
    if (stmt)
         GCIHandleFree(stmt, GCI_HTYPE_STMT);
    if (pbuf)
        free(pbuf);
    pbuf = NULL;

    return rc;
}
int testselectcore1(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;
    GCIDefine *Definep[1] = {0};
    char *pbuf = NULL;
    long loop = 0;
    long i = 0;
    long item_num = 0;
    sb2 ind[20];
	sb4 starown = 0;

    if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
                    GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
    {
        fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
        goto EXIT;
    }   
    pbuf = (char *)malloc(50*20);
    if (!pbuf)
        goto EXIT;
    memset(&ind,0,sizeof(int));
    memset(pbuf,0,1000);

    rc = GCIStmtPrepare(stmt, errhp, (GCIText *)selectcore, strlen(selectcore) + 1, 0, GCI_DEFAULT);

    if (rc = GCIDefineByPos(stmt, &Definep[0], errhp, 1, (dvoid *)pbuf,(sb4)50, (ub2)SQLT_AFC,
                (dvoid *)ind, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto EXIT;
    }
    rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
                GCI_COMMIT_ON_SUCCESS);

    if(rc)
    {
        ub1 errmsg[256] = {0}, errstate[256] = {0};
        sb4 errcode;
        GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
        fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
        goto EXIT;
    }

 	starown = 0;

	while(1)
	{
		ub4 rownum = 0;
		if ((rc = GCIStmtFetch(stmt, errhp, 20, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto EXIT;
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);
        printf("+++++++++++++++++++++%d\n",rownum);


		if(starown == rownum)
			break;

		starown = rownum;
	}   

EXIT:
    if (stmt)
         GCIHandleFree(stmt, GCI_HTYPE_STMT);
    if (pbuf)
        free(pbuf);
    pbuf = NULL;

    return rc;
}


int selectdatconverttablebyrow(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;
	GCIBind *Bindp[5];
	GCIDefine *Definep[5];
	char *pbuf = NULL;
	long loop = 0;
	long i = 0;
	long item_num = 0;
	GCIDate d;
	char *dat;
	long *pitem_num;
	GCIDate *datetimestr = NULL;
	sb4 starown;

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}
	pbuf = (char *)malloc(100*(7+sizeof(long)));
	if(NULL == pbuf)
	{
		goto SUCCESS_EXIT;
	}
	pitem_num = (long *)pbuf;
	dat = pbuf +sizeof(long);
	rc = GCIStmtPrepare(stmt, errhp, (GCIText *)selectdatconvert, strlen(selectdatconvert) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in GCIStmtPrepare selecttest datetime prepare -- !!\n");
		goto SUCCESS_EXIT;
	}
#if 1
	if (rc = GCIDefineByPos(stmt, &Definep[4], errhp, 1, (dvoid *)pitem_num,(sb4)sizeof(long), (ub2)SQLT_INT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto SUCCESS_EXIT;
	}
	if (rc = GCIDefineByPos(stmt, &Definep[3], errhp, 2, (dvoid *)dat,(sb4)7, (ub2)SQLT_DAT,
				(dvoid *)0, (ub2 *)0, (ub2 *)0, GCI_DEFAULT) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto SUCCESS_EXIT;
	}

	if (rc = GCIDefineArrayOfStruct(Definep[4], errhp,15, 0, 0, 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "\tError in Step B -- GCIDefineArrayOfStruct: define array of struct dat failed.\nExiting!!\n");
		goto SUCCESS_EXIT;
	}

	rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
			GCI_COMMIT_ON_SUCCESS);

	if(rc)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, " selectdatconverttable exec Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto SUCCESS_EXIT;
	}

	starown = 0;

	while(1)
	{
		int i;
		ub4 rownum = 0;
		if ((rc = GCIStmtFetch(stmt, errhp, 100, GCI_FETCH_NEXT, 0)) == GCI_NO_DATA)
		{
			fprintf (stdout, "\tStep D done...GCIStmtFetch: No data found...\n");
			rc = GCI_SUCCESS;
			goto SUCCESS_EXIT;
			break;
		}
		GCIAttrGet(stmt, GCI_HTYPE_STMT, &rownum, 0, GCI_ATTR_ROW_COUNT, errhp);

		if(starown == rownum)
			break;

		if(rownum > 10)
			break;
		for(i=0; i<rownum; i++)
		{
			fprintf(stdout, "\tRetrieving row number %d \ndat:%d %d %d %d %d %d %d\n", i + 1,dat[0 +i *15],dat[1 + i *15],dat[2+ i *15],dat[3+ i *15],dat[4+ i *15],dat[5+ i *15],dat[6+ i *15]);
		}
		starown = rownum;
	}
#else
	if(rc = GCIBindByPos(stmt,&Bindp[4],errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
		printf("GCIBindByPos bind 1 parameter itemnum error!\n\n");
		goto insertmultithreadtableEXIT;
	}
	if(rc = GCIBindByPos(stmt,&Bindp[3],errhp,2,(dvoid *)(pbuf+sizeof(long)),(sb4)sizeof(GCIDate),SQLT_ODT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
		printf("GCIBindByPos bind 2 parameter itemnum error!\n\n");
		goto insertmultithreadtableEXIT;
	}
	int offset = 0;
	for(i = 0;i < 100;i++)
	{
		*(long *)(pbuf + offset) = i + i;
		offset += sizeof(long);
		datetimestr = pbuf + offset;
		datetimestr->GCIDateDD = i+ 20;
		datetimestr->GCIDateMM = 4;
		datetimestr->GCIDateYYYY = 2016;
		datetimestr->GCIDateTime.GCITimeHH = 10;
		datetimestr->GCIDateTime.GCITimeMI = 45 + i;
		datetimestr->GCIDateTime.GCITimeSS = 55;

		offset += sizeof(GCIDate);

	}

	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)100, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		ub1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}
#endif
	printf("insertwithbindsql recs\n");

SUCCESS_EXIT:
	if(pbuf)
		free(pbuf);
	GCIHandleFree(stmt, GCI_HTYPE_STMT);
	return rc;
}

int main (long argc,
		char* argv[])
{
	  ub4                     i, in;
	  ub1         verInfoBuffer[SELSQL_LEN];
	  ub4                     verInfoLen;
	  ub1         majorVer[3];
	  ub4             isUdoEnabled;
	  ub1         insertStmt[500];
	  int rc = 0;
     
	  GCIEnv *envhp = NULL;
	  GCISvcCtx *svchp = NULL;
	  GCIError *errhp = NULL;
	  GCIStmt *stmthp1 = NULL;
	  GCIStmt *stmthp2 = NULL;
	  int fd = 0;
    int loop = 0;
          GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";
	  GCItext *user = (GCItext*)"gbasedbt";
	  GCItext *pswd = (GCItext*)"Big4ifmx";
      for (loop = 0;loop < 100;loop++)
      {
        rc = logdb(&envhp,&errhp,&svchp);
        if(rc)
        {
            ub1 errmsg[256] = {0}, errstate[256] = {0};
            sb4 errcode;
            GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
            fprintf(stdout, "select GCIDefineByPos Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
            goto EXIT;

        }
#if 1
        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp1,
                        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
            goto EXIT;
        }
        if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp2,
                        GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
        {
            fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
            goto EXIT;
        }
#endif
        GCILogoff(svchp, errhp);
        if(envhp)
            GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);

        }

         rc = logdb(&envhp,&errhp,&svchp);
         if(rc)
         {
             goto EXIT;
         }
         if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp1,
                         GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
         {
             fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
             goto EXIT;
         }
         if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmthp2,
                         GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
         {
             fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
             goto EXIT;
         }
    
    for (;;)
    { 
        char *truncatesql = "truncate table tcore ";

		rc = createtable(envhp,svchp,errhp, createsql);
        rc = createtable(envhp,svchp,errhp,truncatesql);
        rc = insertcoretable(envhp,svchp,errhp, insertcore);
        rc = testselectcore(envhp,svchp,errhp);
        rc = testselectcore1(envhp,svchp,errhp);
    }
        
EXIT:
	   if(stmthp1)
		   GCIHandleFree((dvoid *)stmthp1, GCI_HTYPE_STMT);
	   if(stmthp2)
		   GCIHandleFree((dvoid *)stmthp2, GCI_HTYPE_STMT);
	   GCILogoff(svchp, errhp);
	   if(svchp)
		    GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);
	   if(errhp)
		    GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);
	    if(envhp)
		    GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);
	    fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
	    in = getchar ();
	    return (rc);

}