/***************************************************************************
 *	Licensed Materials - Property of GBase
 *
 *
 *	"Restricted Materials of GBase"
 *
 *
 *
 *	GBase 8s GCI Interface demo
 *
 *
 *	Copyright GBase Corporation 2015 All rights reserved.
 *
 *
 *
 *
 *
 *  Title:          test_lobwrite.c
 *
 *  Description:    To write lob data in poll mode;then read it,compare;last update.
 table desc:
     index int
     blob
     blob
     clob
     clob
 *
 ****************************************************************************/


#include "gci.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <errno.h>

#ifdef WIN32
    #include <WinSock.h>
#else
    #include <dirent.h>
    #include <unistd.h>
#endif
#include "stdint.h"
#include <fcntl.h>
#define SQLMSG	GetErr()/*(\
	sb1 errmsg[256] = {0}, errstate[256] = {0}; \
	sb4 errcode; \
	GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR); \
	printf("Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
*/
//#include "gcitype.h"

#define SELSQL_LEN     25
#define ERRMSG_LEN     200




char *createmultidatasql = "create table millionupdate(data_id bigint primary key,data_0_0 int,data_0_1 int)";
char *dropmultidatasql = "drop table millionupdate";
char *deletemultidatasql = "delete from millionupdate";
char *updatewithbindsql = "update millionupdate set data_0_0 = ? where data_id = ?";
char *insertwithbindsql = "insert into millionupdate(data_id) values(?)";
GCIError *errhp = NULL;


#define data_id_base 10000000000001
#define get_now_time(a) memset(&(a),0,sizeof((a)));gettimeofday(&(a),NULL)
	
	// ¼ÆËãÊ±¼ä²îÖµ
#define get_time_cut(a,b) ((b).tv_sec * 1000 + (b).tv_usec / 1000) - ((a).tv_sec * 1000 + (a).tv_usec / 1000)
void GetErr(){
	sb1 errmsg[256] = {0}, errstate[256] = {0};
	sb4 errcode;
	GCIErrorGet(errhp, 0, (GCIText *)errstate, &errcode,(GCIText *) errmsg, 256, GCI_HTYPE_ERROR);
	printf("Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
}
#ifdef WIN32
int gettimeofday(struct timeval *tv,struct timezone *tz){
	FILETIME ft;
	ULARGE_INTEGER uliTime;
	uint64_t ullTime;
	static const uint64_t EPOCH_DIFFERENCE = 116444736000000000ULL;
	GetSystemTimeAsFileTime(&ft);

	uliTime.LowPart = ft.dwLowDateTime;
	uliTime.HighPart=ft.dwHighDateTime;
	ullTime=uliTime.QuadPart;

	ullTime -= EPOCH_DIFFERENCE;
	ullTime /=10;

	tv->tv_sec = ullTime / 1000000;
	tv->tv_usec = ullTime % 1000000;
}
#endif

//ɾ����
int dropmultithreadtable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt;	
	//alloc the stmt handle
	//����stmt�����
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto droplobtableEXIT;
	}

	rc = GCIStmtPrepare(stmt, errhp, dropmultidatasql, strlen(dropmultidatasql) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto droplobtableEXIT	;
	}
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)0, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto droplobtableEXIT;
	}

droplobtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;

}

//create the lob test key
int createmultithreadtable(GCIEnv *envhp,GCISvcCtx *svchp,
		GCIError *errhp)
{

	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	//����stmt�����
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto createlobtableEXIT;
	}

#if 1
	rc = GCIStmtPrepare(stmt, errhp, createmultidatasql, strlen(createmultidatasql) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto createlobtableEXIT;
	}
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto createlobtableEXIT;
	}
	#endif
createlobtableEXIT:
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;
}

int insertmultithreadtable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp;
	long *pbuf = NULL;
	long loop = 0;
	struct timeval a;
	struct timeval b;

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto insertmultithreadtableEXIT;
	}

	rc = GCIStmtPrepare(stmt, errhp, insertwithbindsql, strlen(insertwithbindsql) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto insertmultithreadtableEXIT;
	}
	//��
	pbuf = (long *)malloc(1000000*sizeof(long));
	if(rc = GCIBindByPos(stmt,&Bindp,errhp,1,(dvoid *)pbuf,(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind parameter itemnum error!\n\n");
	    goto insertmultithreadtableEXIT;
	}	
	for(loop = 0;loop < 1000000;loop++)
	{
		pbuf[loop] = loop + data_id_base;
	}
	get_now_time(a);	
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)1000000, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		goto insertmultithreadtableEXIT;
	}	
	get_now_time(b);	
	printf("insertwithbindsql time %d ms 1000000 recs\n",get_time_cut(a,b));
	
insertmultithreadtableEXIT:
	if(pbuf)
		free(pbuf);
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	return rc;	
}
#define REC_NUM 100000
int updatemultithreadtable(GCIEnv *envhp,GCISvcCtx *svchp,GCIError *errhp)
{
	int rc = 0;
	GCIStmt *stmt = NULL;	
	//alloc the stmt handle
	GCIBind *Bindp[2];
	char  *pbuf = NULL;
	long loop = 0;
	long offset = 0;
	struct timeval a;
	struct timeval b;
	struct timeval c;
	struct timeval d;

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&stmt,
				GCI_HTYPE_STMT, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in test createlobtable lobtest-- GCIHandleAlloc: allocate stmt handle failed.\nExiting!!\n");
		goto updatemultithreadtableEXIT;
	}

	rc = GCIStmtPrepare(stmt, errhp, updatewithbindsql, strlen(updatewithbindsql) + 1, 0, GCI_DEFAULT);
	if(GCI_SUCCESS != rc)
	{
		fprintf(stdout, "Error in createlobtable stmt prepare -- !!\n");
		goto updatemultithreadtableEXIT;
	}
	//��
	pbuf = (char *)malloc(1000000*(sizeof(long) + sizeof(int)));

	if(rc = GCIBindByPos(stmt,&Bindp[1],errhp,2,(dvoid *)(pbuf+sizeof(int)),(sb4)sizeof(long),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind parameter itemnum error!\n\n");
	    goto updatemultithreadtableEXIT;
	}
	if(rc = GCIBindByPos(stmt,&Bindp[0],errhp,1,(dvoid *)pbuf,(sb4)sizeof(int),SQLT_INT,NULL,NULL,NULL,0,NULL,GCI_DEFAULT))
	{
	    printf("GCIBindByPos bind parameter itemnum error!\n\n");
	    goto updatemultithreadtableEXIT;
	}	
	GCIBindArrayOfStruct(Bindp[0],errhp, 12, 0, 0, 0);
	GCIBindArrayOfStruct(Bindp[1],errhp, 12, 0, 0, 0);
	offset = 0;
	for(loop = 0;loop < REC_NUM;loop++)
	{
		*(int *)(pbuf+offset) = loop ;
		*(long *)(pbuf+offset + sizeof(int)) = loop + data_id_base;
		offset += sizeof(long) + sizeof(int);
	}
	printf("data00 %d,dataid %ld\n",*(int *)(pbuf+12),*(long *)(pbuf+16));
	get_now_time(a);
	if (rc = GCIStmtExecute(svchp, stmt, errhp, (ub4)REC_NUM, (ub4)0, (CONST GCISnapshot*)0, (GCISnapshot*)0,
				GCI_COMMIT_ON_SUCCESS) != GCI_SUCCESS)
	{
		sb1 errmsg[256] = {0}, errstate[256] = {0};
		sb4 errcode;
		GCIErrorGet(errhp, 0, errstate, &errcode, errmsg, 256, GCI_HTYPE_ERROR);
		fprintf(stdout, "Error code ----- %d\nError state ---- %s\nError message -- %s\n", errcode, errstate, errmsg);
		if(rc = GCITransRollback(svchp, errhp, (ub4)0) != GCI_SUCCESS)
		{
			fprintf (stdout, "Error in updatemultithreadtable...roolback transaction failed.\nExiting!!\n");

		}	
		goto updatemultithreadtableEXIT;
	}	
	get_now_time(b);	
	printf("updatewithbindsql time %d ms %d  for rec num\n",get_time_cut(a,b),REC_NUM);
	get_now_time(c);
	if(rc = GCITransCommit(svchp, errhp, (ub4)0) != GCI_SUCCESS)
	{
		fprintf (stdout, "Error in Step 3...commit transaction failed.\nExiting!!\n");
	}
	get_now_time(d);	
	printf("updatewithbindsql time %d ms %d  for rec num\n",get_time_cut(c,d),REC_NUM);
	
updatemultithreadtableEXIT:
	if(pbuf)
		free(pbuf);
	pbuf = NULL;
	GCIHandleFree(stmt, GCI_HTYPE_STMT);	
	
	return rc;	
}
int logdb(GCIEnv **envhp1,GCIError **errhp1,GCISvcCtx **svchp1)
{
	int rc = GCI_SUCCESS;
	
	///connect db
	GCIEnv *envhp= NULL;
	GCISvcCtx *svchp= NULL;
	GCIError *errhp = NULL;
	GCItext *dbname = (GCItext*)"gci_demodb";//"gci_demodb";
	GCItext *user = (GCItext*)"gbasedbt";
	GCItext *pswd = (GCItext*)"Big4ifmx";

	/*  STEP 1. Get data source name from command line (or use default)
	 **          Allocate the environment handle and set ODBC version
	 **          Allocate the connection handle
	 **          Establish the database connection
	 **          Allocate the statement handle
	 **          Drop demo database if it already exists
	 */
	/* initialize the mode to be the threaded and object environment */
	if(rc = GCIEnvCreate(&envhp, GCI_THREADED|GCI_OBJECT, (dvoid *)0,
				0, 0, 0, (size_t) 0, (dvoid **)0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIEnvCreate: create env handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}

	/* allocate an error handle */
	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&errhp,
				GCI_HTYPE_ERROR, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate error handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}	

	if(rc = GCIHandleAlloc((dvoid *)envhp, (dvoid **)&svchp,
				GCI_HTYPE_SVCCTX, 0, (dvoid **) 0) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCIHandleAlloc: allocate svcctx handle failed.\nExiting!!\n");
		goto logdbEXIT;
	}
	if(rc = GCILogon(envhp, errhp, &svchp, user, (ub4)strlen((char*)user),
				pswd, (ub4)strlen((char*)pswd), dbname, (ub4)strlen((char*)dbname)) != GCI_SUCCESS)
	{
		fprintf(stdout, "Error in Step 1 -- GCILogon: logon to database failed.\nExiting!!\n");
		goto logdbEXIT;
	}
	*envhp1 = envhp;
	*errhp1 = errhp;
	*svchp1 = svchp;


	fprintf (stdout, "Step 1 done...connected to database.\n");

logdbEXIT:
		*envhp1 = envhp;
	*errhp1 = errhp;
	*svchp1 = svchp;	
	return rc;
}
/*
 * This function allocates the row and collection buffers, passes
 * them to the do_select_storebyxxx() function, along with an appropriate select
 * statement and then frees all allocated handles.
 */

int main (long argc,
		char* argv[])
{
	/* Declare varia[]bles */

	ub4			i, in;

	ub1         verInfoBuffer[SELSQL_LEN];
	ub4			verInfoLen;
	ub1         majorVer[3];
	ub4      	isUdoEnabled;
	int rc = 0;
	/* Handles */
	GCIEnv *envhp = NULL;
	GCISvcCtx *svchp = NULL;
	GCIError *errhp = NULL;
	GCIStmt *stmthp1 = NULL;
	GCIStmt *stmthp2 = NULL;
	int fd = 0;


//write to txt
//test for 50w updates

	
 	rc = logdb(&envhp,&errhp,&svchp);
	if(rc)
	{
		goto EXIT;
	}
	
	rc = dropmultithreadtable(envhp,svchp,errhp);
	rc = createmultithreadtable(envhp,svchp,errhp);
	if(rc)
	{
		fprintf (stdout, "create lob table failure.\n");
		goto EXIT;
	}	
	fprintf (stdout, "create lob table success.\n");
	
	rc = insertmultithreadtable(envhp,svchp,errhp);
	for(i = 0;i < 1;i++)
	{
		printf("++++++++++++++++++++++++++++++++++%d\n",i);
		rc = updatemultithreadtable(envhp,svchp,errhp);
	}
//	rc = fetchmillondata(envhp,svchp,errhp);
	fprintf (stdout,"\nHit <Enter> to continue...");
	in = getchar ();

EXIT:

	/* CLEANUP: Close the statement handle
	 **          Free the statement handle
	 **          Disconnect from the datasource
	 **          Free the connection and environment handles
	 **          Exit
	 */
	if(stmthp1)
		GCIHandleFree((dvoid *)stmthp1, GCI_HTYPE_STMT);

	if(stmthp2)
		GCIHandleFree((dvoid *)stmthp2, GCI_HTYPE_STMT);

	GCILogoff(svchp, errhp);

	if(svchp)
		GCIHandleFree((dvoid *)svchp, GCI_HTYPE_SVCCTX);

	if(errhp)
		GCIHandleFree((dvoid *)errhp, GCI_HTYPE_ERROR);

	if(envhp)
		GCIHandleFree((dvoid *)envhp, GCI_HTYPE_ENV);


	fprintf (stdout,"\n\nHit <Enter> to terminate the program...\n\n");
	in = getchar ();

	return (rc);
}
