#ifndef _GCIERROR_H
#define _GCIERROR_H

#define GCI_BIND_ERROR                      1001
#define GCI_DEFINE_ERROR                    1002
#define GCI_ATTRGET_ERROR                   1003
#define GCI_ATTRSET_ERROR                   1004
#define GCI_HANDLEALLOC_ERROR               1005
#define GCI_HANDLEFREE_ERROR                1006

#define GCI_ENVCREATE_ERROR                 1007
#define GCI_LOGONNODB_ERROR                 1009
#define GCI_LOGOFF_ERROR                    1010
#define GCI_SERVERATTACH_ERROR              1011
#define GCI_SERVERATTACH_MESSAGE            "Dblink is NULL"
#define GCI_SESSIONEND_ERROR                28                      // CONVERT TO THE ORA ERROR:your session has been killed
#define GCI_SESSIONBEGIN_ERROR              1013
#define GCI_SERVERVERSION_ERROR             1008                    // conflict  erease the GCI_LOGON_ERROR

#define GCI_TRANSCOMMIT_ERROR               1015
#define GCI_TRANSSTART_ERROR                1016
#define GCI_TRANSROLLBACK_ERROR             1017
#define GCI_STMTPREPARE_ERROR               1018
#define GCI_STMTEXECUTE_ERROR               1019
#define GCI_STMTFETCH_ERROR                 1020

#define GCI_DESCALLOC_ERROR                 1021
#define GCI_DESCFREE_ERROR                  1022
#define GCI_PARAMGET_ERROR                  1023
#define GCI_PARAMSET_ERROR                  1024
#define GCI_DESCANY_ERROR                   1025

#define GCI_DIRPATH_LOADSTREAM_ERROR        1026
#define GCI_LOB_GETLENGTH_ERROR             1027
#define GCI_LOB_READ_ERROR                  1028
#define GCI_LOG_WRITE_ERROR                 1029
#define GCI_LOG_PROCDESC_ERROR              1030

#define GCI_DB_CONNECT_ERROR                3114
#define GCI_DB_CONNECT_ERROR_MSG            "Connection not open"
#define GCI_NOT_LOGGED_ON                   1012                    // conflict
#define GCI_SHUTDOWN_IN_PROGRESS            1014                    // conflict
#define GCI_DATETIME_CONVERT                1040                    // new

#define GCI_SERVERDETACH_ERROR              9998
#define GCI_TRANSSTOP_ERROR                 9999

#define GCI_ERROR_BASE                      900000                  // db error base
#define GCI_S_ERROR_BASE                    800000                  // gci error self base

#define GCI_SQLDONE_ERR_CODE                -439                    // sqldone() server is currently processing an SQL request
#define GCI_LOB_EBAD_ARG                    -7420                   // argument (%s) is invalid, error code in esqlc.

#define GCI_INVAL_HANDLE_ERR_MSG            "Invalid handle."
#define GCI_INVAL_HANDLE_ERR_CODE           GCI_S_ERROR_BASE + 1

#define GCI_USERNAME_LEN_ERR_MSG            "the length of the username is 0."
#define GCI_USERNAME_LEN_ERR_CODE           GCI_S_ERROR_BASE + 2

#define GCI_USERNAMELEN_LEN_ERR_MSG         "the length of the username is not equal."
#define GCI_USERNAMELEN_LEN_ERR_CODE        GCI_S_ERROR_BASE + 3

#define GCI_PASSWORD_LEN_ERR_MSG            "the length of the password is 0."
#define GCI_PASSWORD_LEN_ERR_CODE           GCI_S_ERROR_BASE + 4

#define GCI_PASSWORDLEN_LEN_ERR_MSG         "the length of the password is not equal."
#define GCI_PASSWORDLEN_LEN_ERR_CODE        GCI_S_ERROR_BASE + 5

#define GCI_DBNAME_LEN_ERR_MSG              "the length of the dbname is 0."
#define GCI_DBNAME_LEN_ERR_CODE             GCI_S_ERROR_BASE + 6

#define GCI_DBNAMELEN_LEN_ERR_MSG           "the length of the dbname is not equal."
#define GCI_DBNAMELEN_LEN_ERR_CODE          GCI_S_ERROR_BASE + 7

#define GCI_OPASSWD_LEN_ERR_MSG             "the length of the old password is 0."
#define GCI_OPASSWD_LEN_ERR_CODE            GCI_S_ERROR_BASE + 8

#define GCI_OPASSWDLEN_LEN_ERR_MSG          "the length of the old password is not equal."
#define GCI_OPASSWDLEN_LEN_ERR_CODE         GCI_S_ERROR_BASE + 9

#define GCI_NPASSWD_LEN_ERR_MSG             "the length of the new password is 0."
#define GCI_NPASSWD_LEN_ERR_CODE            GCI_S_ERROR_BASE + 10

#define GCI_NPASSWDLEN_LEN_ERR_MSG          "the length of the new password is not equal."
#define GCI_NPASSWDLEN_LEN_ERR_CODE         GCI_S_ERROR_BASE + 11

#define GCI_MODE_ERR_MSG                    "currently, only the GCI_DEFAULT mode is supported."
#define GCI_MODE_ERR_CODE                   GCI_S_ERROR_BASE + 12

#define GCI_GET_GBASEDBTSERVER_ERR_MSG      "get gbase database server error, please set the environment variable GBASEDBTSERVER, parameter or gci.conf."
#define GCI_GET_GBASEDBTSERVER_ERR_CODE     GCI_S_ERROR_BASE + 13

#define GCI_BINDNAME_LEN_ERR_MSG            "the length of the binding name is 0."
#define GCI_BINDNAME_LEN_ERR_CODE           GCI_S_ERROR_BASE + 14

#define GCI_BINDNAMELEN_LEN_ERR_MSG         "the length of the binding name is not equal."
#define GCI_BINDNAMELEN_LEN_ERR_CODE        GCI_S_ERROR_BASE + 15

#define GCI_BINDNAME_VALUE_LEN_ERR_MSG      "the length of the binding name value is 0."
#define GCI_BINDNAME_VALUE_LEN_ERR_CODE     GCI_S_ERROR_BASE + 16

#define GCI_BINDNAME_FORMAT_ERR_MSG         "the bingind name is not in the correct format."
#define GCI_BINDNAME_FORMAT_ERR_CODE        GCI_S_ERROR_BASE + 17

#define GCI_BIND_ERROR_MSG                  "the binding name does not exist."

#define GCI_SQL_LEN_ERR_MSG                 "the sql to be prepared is empty or the sql length is 0."
#define GCI_SQL_LEN_ERR_CODE                GCI_S_ERROR_BASE + 18

#define GCI_STORALLO_ERR_MSG                "failed to allocate memory."
#define GCI_STORALLO_ERR_CODE               GCI_S_ERROR_BASE + 19

#define GCI_SQLSYN_ERR_MSG                  "sql statement syntax error."
#define GCI_SQLSYN_ERR_CODE                 GCI_S_ERROR_BASE + 20

#define GCI_SQLCONV_ERR_MSG                 "sql conversion failure."
#define GCI_SQLCONV_ERR_CODE                GCI_S_ERROR_BASE + 21

#define GCI_CONN_IS_INAVAILD_ERR_MSG        "The current connection is invalid."
#define GCI_CONN_IS_INAVAILD_ERR_CODE       GCI_S_ERROR_BASE + 22

#define GCI_CONN_ID_ERR_MSG                 "Could not get the connection id."
#define GCI_CONN_ID_ERR_CODE                GCI_S_ERROR_BASE + 23

#define GCI_LOGON2_DELIMIDENT_ERR_MSG       "Please setup the DELIMIDENT environment variable to support this."
#define GCI_LOGON2_DELIMIDENT_ERR_CODE      GCI_S_ERROR_BASE + 24

#define GCI_NOTSUPPORT_ERR_MSG              "Do not support this mode, would be support it in the future."
#define GCI_NOTSUPPORT_ERR_CODE             GCI_S_ERROR_BASE + 25

#define GCI_INVAL_HANDLE_TYPE_ERR_MSG       "Invaid handle type."
#define GCI_INVAL_HANDLE_TYPE_ERR_CODE      GCI_S_ERROR_BASE + 26

#define GCI_BUFFER_ERR_MSG                  "The buffer is null."
#define GCI_BUFFER_ERR_CODE                 GCI_S_ERROR_BASE + 27

#define GCI_BUFFER_SIZE_ERR_MSG             "The buffer size is 0."
#define GCI_BUFFER_SIZE_ERR_CODE            GCI_S_ERROR_BASE + 28

#define GCI_UNSUPPORTED_HANDLE_ERR_MSG      "Unsupported handle."
#define GCI_UNSUPPORTED_HANDLE_ERR_CODE     GCI_S_ERROR_BASE + 29

#define GCI_AMOUNT_ERR_MSG                  "The amtp should not be null."
#define GCI_AMOUNT_ERR_CODE                 GCI_S_ERROR_BASE + 30

#define GCI_PIECE_ERR_MSG                   "Invalid piece value."
#define GCI_PIECE_ERR_CODE                  GCI_S_ERROR_BASE + 31

#define GCI_CHARSET_FORM_ERR_MSG            "Invalid character set form value."
#define GCI_CHARSET_FORM_ERR_CODE           GCI_S_ERROR_BASE + 33

#define GCI_BUFFLEN_OVERFLOW_ERR_MSG        "Buffer len is bigger than 2G."
#define GCI_BUFFLEN_OVERFLOW_ERR_CODE       GCI_S_ERROR_BASE + 34

#define GCI_FETCH_MORE_LOBS_ERR_MSG         "for lob object, please fetch one row each time. currently we do not support fetching multi row."
#define GCI_FETCH_MORE_LOBS_ERR_CODE        GCI_S_ERROR_BASE + 1050

#define GCI_BIND_ADDRESS_ERR_MSG            "the value address could not be null."
#define GCI_BIND_ADDRESS_ERR_CODE           GCI_S_ERROR_BASE + 36

#define GCI_BIND_LEN_ERR_MSG                "the value size could not be 0."
#define GCI_BIND_LEN_ERR_CODE               GCI_S_ERROR_BASE + 37

#define GCI_DESCRIBE_OBJ_ERR_MSG            "the object address could not be null."
#define GCI_DESCRIBE_OBJ_ERR_CODE           GCI_S_ERROR_BASE + 38

#define GCI_DESCRIBE_OBJ_LEN_ERR_MSG        "the object name size could not be 0."
#define GCI_DESCRIBE_OBJ_LEN_ERR_CODE       GCI_S_ERROR_BASE + 39

#define GCI_LOB_CREATE_ERR_MSG              "create lob specification failed."

#define GCI_ILLEGAL_ATTR_TYPE_ERR_MSG       "illegal attribute type."
#define GCI_ILLEGAL_ATTR_TYPE_ERR_CODE      GCI_S_ERROR_BASE + 40

#define GCI_DIRPATH_LEN_ERR_MSG             "data length is bigger than the max length."
#define GCI_DIRPATH_LEN_ERR_CODE            GCI_S_ERROR_BASE + 41

#define GCI_DIRPATH_ROWNUM_ERR_MSG          "row number is bigger than the max row number."
#define GCI_DIRPATH_ROWNUM_ERR_CODE         GCI_S_ERROR_BASE + 42

#define GCI_DIRPATH_COLIDX_ERR_MSG          "column index is bigger than the max column index."
#define GCI_DIRPATH_COLIDX_ERR_CODE         GCI_S_ERROR_BASE + 43

#define GCI_DIRPATH_COLFLAG_ERR_MSG         "currently, do not support GCI_DIRPATH_COL_PARTIAL."
#define GCI_DIRPATH_COLFLAG_ERR_CODE        GCI_S_ERROR_BASE + 44

#define GCI_DIRPATH_COLFLAG_INVALID_ERR_MSG  "invalid column flag."
#define GCI_DIRPATH_COLFLAG_INVALID_ERR_CODE GCI_S_ERROR_BASE + 45

#define GCI_DIRPATH_DATA_ERR_MSG            "data length is 0 or data buffer is NULL."
#define GCI_DIRPATH_DATA_ERR_CODE           GCI_S_ERROR_BASE + 46

#define GCI_DIRPATH_ACTION_ERR_MSG          "invalid action."
#define GCI_DIRPATH_ACTION_ERR_CODE         GCI_S_ERROR_BASE + 47

#define GCI_DIRPATH_BUFFSIZE_ERR_MSG        "buffer size is not big enough for dir path."
#define GCI_DIRPATH_BUFFSIZE_ERR_CODE       GCI_S_ERROR_BASE + 48

#define GCI_DIRPATH_SQL_ERR_MSG             "sql statement is too long, greater than 32000 bytes."
#define GCI_DIRPATH_SQL_ERR_CODE            GCI_S_ERROR_BASE + 49

#define GCI_MEMORY_ERR_MSG                  "memory allocate failed."
#define GCI_MEMORY_ERR_CODE                 GCI_S_ERROR_BASE + 50

#define GCI_SQLT_TYPE_ERR_MSG               "the external data type %d will be supported soon."
#define GCI_SQLT_TYPE_ERR_CODE              GCI_S_ERROR_BASE + 51

#define GCI_LOB_CLOSE_ERR_MSG               "cannot perform operation on an unopened file or LOB."
#define GCI_LOB_CLOSE_ERR_CODE              GCI_S_ERROR_BASE + 22289

#define GCI_LOB_SVCHP_ERR_MSG               "locator must have been a locator that was obtained from the server specified by svchp."
#define GCI_LOB_SVCHP_ERR_CODE              GCI_S_ERROR_BASE + 52

#define GCI_LOB_TYPE_ERR_MSG                "both the source and the destination LOB locators must be of the same type."
#define GCI_LOB_TYPE_ERR_CODE               GCI_S_ERROR_BASE + 53

#define GCI_LOB_ADDRESS_ERR_MSG             "the parameter address is null."
#define GCI_LOB_ADDRESS_ERR_CODE            GCI_S_ERROR_BASE + 54

#define GCI_LOB_OPEN_ERR_MSG                "cannot perform operation on an opened file or LOB."
#define GCI_LOB_OPEN_ERR_CODE               GCI_S_ERROR_BASE + 55

#define GCI_LOB_MODE_ERR_MSG                "invalid mode value."
#define GCI_LOB_MODE_ERR_CODE               GCI_S_ERROR_BASE + 56

#define GCI_LOB_OFFSET_ERR_MSG              "illegal parameter value in OCI lob function."
#define GCI_LOB_OFFSET_ERR_CODE             GCI_S_ERROR_BASE + 24801

#define GCI_NOT_A_DATE_ERR_MSG              "not a date."
#define GCI_NOT_A_DATE_ERR_CODE             GCI_S_ERROR_BASE + 57

#define GCI_YEAR_MONTH_DAY_ERR_MSG          "the year or month or day could not be null."
#define GCI_YEAR_MONTH_DAY_ERR_CODE         GCI_S_ERROR_BASE + 58

#define GCI_HOUR_MIN_SEC_FSEC_ERR_MSG       "the hour or minute or second or fraction could not be null."
#define GCI_HOUR_MIN_SEC_FSEC_ERR_CODE      GCI_S_ERROR_BASE + 59

#define GCI_GETTIME_DATE_ERR_MSG            "specified field not found in datetime or interval."
#define GCI_GETTIME_DATE_ERR_CODE           GCI_S_ERROR_BASE + 60

#define GCI_THREAD_HANDLE_ERR_MSG           "thread handle is null."
#define GCI_THREAD_HANDLE_ERR_CODE          GCI_S_ERROR_BASE + 61

#define GCI_LOB_CHUNK_ERR_MSG               "The chunk size should not be null."
#define GCI_LOB_CHUNK_ERR_CODE              GCI_S_ERROR_BASE + 62

#define GCI_LOB_LENGTH_ERR_MSG              "The length should not be null."
#define GCI_LOB_LENGTH_ERR_CODE             GCI_S_ERROR_BASE + 63

#define GCI_LOB_GBSUB8_ERR_MSG              "The parameter value is bigger than MINSB4MAXVAL."
#define GCI_LOB_GBSUB8_ERR_CODE             GCI_S_ERROR_BASE + 64

#define GCI_LOB_AMOUNT_NULL_ERR_MSG         "The amount address is null."
#define GCI_LOB_AMOUNT_NULL_ERR_CODE        GCI_S_ERROR_BASE + 65

#define GCI_LOB_INVALID_TYPE_ERR_MSG        "Invalid lob type."
#define GCI_LOB_INVALID_TYPE_ERR_CODE       GCI_S_ERROR_BASE + 66

#define GCI_LOB_DURATION_ERR_MSG            "Invalid duration of the temporary LOB."
#define GCI_LOB_DURATION_ERR_CODE           GCI_S_ERROR_BASE + 67

#define GCI_LOB_RELEASE_ERR_MSG             "Frees a temporary LOB failed."

#define GCI_LOB_FREE_TEMP_ERR_MSG           "The LOB locator passed in the locp parameter does not point to a temporary."
#define GCI_LOB_FREE_TEMP_ERR_CODE          GCI_S_ERROR_BASE + 68

#define GCI_LOB_UPDATE_NULL_ERR_MSG         "Update empty lob to null column error."
#define GCI_LOB_UPDATE_NULL_ERR_CODE        GCI_S_ERROR_BASE + 69

#define GCI_ENV_VARIABLE_MISSING_ERR_MSG    "Missing env variable GBASEDBTDIR, please export it to csdk install path."
#define GCI_ENV_VARIABLE_MISSING_ERR_CODE   GCI_S_ERROR_BASE + 70

#define GCI_INTERVAL_OUTOF_RANGE_ERR_MSG    "interval out of range."
#define GCI_INTERVAL_OUTOF_RANGE_ERR_CODE   GCI_S_ERROR_BASE + 71

#define GCI_INTE_LITERAL_INVALID_ERR_MSG    "the literal string is invalid."
#define GCI_INTE_LITERAL_INVALID_ERR_CODE   GCI_S_ERROR_BASE + 72

#define GCI_INTE_LI_TYPE_INVALID_ERR_MSG    "the literal type is invalid."
#define GCI_INTE_LI_TYPE_INVALID_ERR_CODE   GCI_S_ERROR_BASE + 73

#define GCI_INTVL_DS_DAY_OUT_RANGE_MSG      "the day is out of range(0 to 999999999)."
#define GCI_INTVL_DS_DAY_OUT_RANGE_CODE     GCI_S_ERROR_BASE + 74

#define GCI_INTVL_DS_HOUR_OUT_RANGE_MSG     "the hour is out of range(0 to 23)."
#define GCI_INTVL_DS_HOUR_OUT_RANGE_CODE    GCI_S_ERROR_BASE + 75

#define GCI_INTVL_DS_MINUTE_OUT_RANGE_MSG   "the minute is out of range(0 to 59)."
#define GCI_INTVL_DS_MINUTE_OUT_RANGE_CODE  GCI_S_ERROR_BASE + 77

#define GCI_INTVL_DS_SECOND_OUT_RANGE_MSG   "the second is out of range(0 to 59)."
#define GCI_INTVL_DS_SECOND_OUT_RANGE_CODE  GCI_S_ERROR_BASE + 78

#define GCI_INTVL_DS_FRAC_OUT_RANGE_MSG     "the fraction is out of range(0 to 999999)."
#define GCI_INTVL_DS_FRAC_OUT_RANGE_CODE    GCI_S_ERROR_BASE + 80

#define GCI_INTVL_YM_YEAR_OUT_RANGE_MSG     "the year is out of range(0 to 9999)."
#define GCI_INTVL_YM_YEAR_OUT_RANGE_CODE    GCI_S_ERROR_BASE + 81

#define GCI_INTVL_YM_MONTH_OUT_RANGE_MSG    "the month is out of range (0 to 11)."
#define GCI_INTVL_YM_MONTH_OUT_RANGE_CODE   GCI_S_ERROR_BASE + 82

#define GCI_DATETIME_TIMEZONE_ERR_MSG       "datetime does not contain a time zone."
#define GCI_DATETIME_TIMEZONE_ERR_CODE      GCI_S_ERROR_BASE + 83

#define GCI_HOUR_MIN_ERR_MSG                "the hour or minute could not be null."
#define GCI_HOUR_MIN_ERR_CODE               GCI_S_ERROR_BASE + 84

#define GCI_NUMBER_IS_NULL_ERR_MSG          "the number could not be null."
#define GCI_NUMBER_IS_NULL_ERR_CODE         GCI_S_ERROR_BASE + 85

#define GCI_NUMBER_IS_OUT_OF_RANGE_ERR_MSG  "the number is out of range."
#define GCI_NUMBER_IS_OUT_OF_RANGE_ERR_CODE GCI_S_ERROR_BASE + 86

#define GCI_NUMBER_INVALID_SIGN_ERR_MSG     "Invalid sign flag value is passed in inum_s_flag."
#define GCI_NUMBER_INVALID_SIGN_ERR_CODE    GCI_S_ERROR_BASE + 87

#define GCI_NUMBER_INTEGER_IS_NULL_ERR_MSG  "the integer could not be null."
#define GCI_NUMBER_INTEGER_IS_NULL_ERR_CODE GCI_S_ERROR_BASE + 88

#define GCI_INTEGER_IS_OUT_OF_RANGE_ERR_MSG "the integer is out of range."
#define GCI_INTEGER_IS_OUT_OF_RANGE_ERR_CODE GCI_S_ERROR_BASE + 89

#define GCI_NUMBER_REAL_IS_NULL_ERR_MSG     "the real could not be null."
#define GCI_NUMBER_REAL_IS_NULL_ERR_CODE    GCI_S_ERROR_BASE + 90

#define GCI_NUMBER_RNUMLEN_IS_ZERO_ERR_MSG  "rnum_length could not be 0."
#define GCI_NUMBER_RNUMLEN_IS_ZERO_ERR_CODE GCI_S_ERROR_BASE + 91

#define GCI_REAL_IS_OUT_OF_RANGE_ERR_MSG    "the REAL is out of range."
#define GCI_REAL_IS_OUT_OF_RANGE_ERR_CODE   GCI_S_ERROR_BASE + 92

#define GCI_NUMBER_RES_LEN_IS_ZERO_ERR_MSG  "rsl_length could not be 0."
#define GCI_NUMBER_RES_LEN_IS_ZERO_ERR_CODE GCI_S_ERROR_BASE + 93

#define GCI_NUMBER_CMP_RES_UNKNOWN_ERR_MSG  "Number Compare result is DECUNKNOWN."
#define GCI_NUMBER_CMP_RES_UNKNOWN_ERR_CODE GCI_S_ERROR_BASE + 97

#define GCI_STRING_PARAM_NULL_ERR_MSG       "the string could not be null."
#define GCI_STRING_PARAM_NULL_ERR_CODE      GCI_S_ERROR_BASE + 100

#define GCI_STRING_ALLOCATED_FAILED_ERR_MSG "allocate string memory failed."
#define GCI_STRING_ALLOCATED_FAILED_ERR_CODE GCI_S_ERROR_BASE + 101

#define GCI_LOB_INVALID_OFFSET_ERR_MSG      "source offset is beyond the end of the source LOB."
#define GCI_LOB_INVALID_OFFSET_ERR_CODE     GCI_S_ERROR_BASE + 22994

#define GCI_BIND_CALLBACK_ERR_MSG           "the input callback function is null."
#define GCI_BIND_CALLBACK_ERR_CODE          GCI_S_ERROR_BASE + 102

#define GCI_ILLEGAL_PIECE_ERR_MSG           "illegal piecewise operation attempted."
#define GCI_ILLEGAL_PIECE_ERR_CODE          GCI_S_ERROR_BASE + 24370

#define GCI_STRING_TRUNC_ERR_MSG            "input data len is longer than the max len of the column."
#define GCI_STRING_TRUNC_ERR_CODE           GCI_S_ERROR_BASE + 103

#define GCI_NON_PIECE_PARAM_ERR_MSG         "the param does not support piece operation."
#define GCI_NON_PIECE_PARA_ERR_CODE         GCI_S_ERROR_BASE + 104

#define GCI_BIND_CALLBACK_OUT_ERR_MSG       "the output callback function is not supported."
#define GCI_BIND_CALLBACK_OUT_ERR_CODE      GCI_S_ERROR_BASE + 105

#define GCI_OPEN_FILE_ERR_MSG               "piece operation, open file %s failed."
#define GCI_OPEN_FILE_ERR_CODE              GCI_S_ERROR_BASE + 106

#define GCI_LOB_COLUMN_DATATYPE_ERR_MSG     "for clob and blob column, please use SQLT_CLOB or SQLT_BLOB data type."
#define GCI_LOB_COLUMN_DATATYPE_ERR_CODE    GCI_S_ERROR_BASE + 107

#define GCI_CALLBACK_ERR_MSG                "user defined callback error."
#define GCI_CALLBACK_ERR_CODE               GCI_S_ERROR_BASE + 24343

#define GCI_FILESIZE_ERR_MSG                "get file %s size error."
#define GCI_FILESIZE_ERR_CODE               GCI_S_ERROR_BASE + 108

#define GCI_ID_LEN_ERR_MSG                  "identifier len is too long(MAXIDSIZE is 127)."
#define GCI_ID_LEN_ERR_CODE                 GCI_S_ERROR_BASE + 109

#define GCI_DATA_EXEC_INVALID_LENGTH_ERR_MSG "invalid length for piece."
#define GCI_DATA_EXEC_INVALID_LENGTH_ERR_CODE GCI_S_ERROR_BASE + 110

#define GCI_GETPIECE_PARAM_IS_NULL_ERR_MSG  "GCIStmtGetPieceInfo invalid param."
#define GCI_GETPIECE_PARAM_IS_NULL_ERR_CODE GCI_S_ERROR_BASE + 111

#define GCI_SETPIECE_PARAM_IS_NULL_ERR_MSG  "GCIStmtSetPieceInfo invalid param."
#define GCI_SETPIECE_PARAM_IS_NULL_ERR_CODE GCI_S_ERROR_BASE + 112

#define GCI_POOLNAME_ADDRESS_ERR_MSG        "the poolName address is null."
#define GCI_POOLNAME_ADDRESS_ERR_CODE       GCI_S_ERROR_BASE + 113

#define GCI_POOLNAMELEN_ADDRESS_ERR_MSG     "the poolNameLen address is null."
#define GCI_POOLNAMELEN_ADDRESS_ERR_CODE    GCI_S_ERROR_BASE + 114

#define GCI_DBLINK_ADDRESS_ERR_MSG          "the dblink address is null."
#define GCI_DBLINK_ADDRESS_ERR_CODE         GCI_S_ERROR_BASE + 115

#define GCI_POOLUSERNAME_ADDRESS_ERR_MSG    "the poolUserName address is null."
#define GCI_POOLUSERNAME_ADDRESS_ERR_CODE   GCI_S_ERROR_BASE + 116

#define GCI_POOLPASSWORD_ADDRESS_ERR_MSG    "the poolPassword address is null."
#define GCI_POOLPASSWORD_ADDRESS_ERR_CODE   GCI_S_ERROR_BASE + 117

#define GCI_POOL_MODE_ERR_MSG               "invalid mode value."
#define GCI_POOL_MODE_ERR_CODE              GCI_S_ERROR_BASE + 118

#define GCI_POOL_CONNMAX_ERR_MSG            "invalid connMax value, its value should be greater than or equal to 1."
#define GCI_POOL_CONNMAX_ERR_CODE           GCI_S_ERROR_BASE + 119

#define GCI_POOL_PARAMTER_ERR_MSG           "invalid connMin, connIncr value, they cannot both be equal to 0."
#define GCI_POOL_PARAMTER_ERR_CODE          GCI_S_ERROR_BASE + 120

#define GCI_POOL_CONNMIN_ERR_MSG            "invalid connMin value, it cannot be greater than connMax."
#define GCI_POOL_CONNMIN_ERR_CODE           GCI_S_ERROR_BASE + 121

#define GCI_POOL_MANAGETHREAD_ERR_MSG       "failed to create the connection pool management thread."
#define GCI_POOL_MANAGETHREAD_ERR_CODE      GCI_S_ERROR_BASE + 122

#define GCI_POOL_CONNMIN_CONNINCR_ERR_MSG   "connMin plus connIncr cannot be greater than connMax."
#define GCI_POOL_CONNMIN_CONNINCR_ERR_CODE  GCI_S_ERROR_BASE + 123

#define GCI_POOL_USERNAME_ERR_MSG           "the user name is inconsistent with that of the connection pool."
#define GCI_POOL_USERNAME_ERR_CODE          GCI_S_ERROR_BASE + 124

#define GCI_POOL_PASSWORD_ERR_MSG           "the password is inconsistent with that of the connection pool."
#define GCI_POOL_PASSWORD_ERR_CODE          GCI_S_ERROR_BASE + 125

#define GCI_POOL_BUSY_ERR_MSG               "all connections in the connection pool are busy."
#define GCI_POOL_BUSY_ERR_CODE              GCI_S_ERROR_BASE + 126

#define GCI_POOL_NOT_FUND_ERR_MSG           "the connection pool was not fund."
#define GCI_POOL_NOT_FUND_ERR_CODE          GCI_S_ERROR_BASE + 127

#define GCI_POOL_REINIT_ERR_MSG             "reinitialize failed,beacase the number of busy connections in the connection pool exceeded the maximum number of connections."
#define GCI_POOL_REINIT_ERR_CODE            GCI_S_ERROR_BASE + 128

#define GCI_INTER_DATET_NOT_COMPAR_ERR_MSG  "the intervals or datetimes are not mutually comparable."
#define GCI_INTER_DATET_NOT_COMPAR_ERR_CODE GCI_S_ERROR_BASE + 129

#define GCI_DATETIME_INCON_DATATYPE_ERR_MSG "inconsistent datatypes: expected %s got %s."
#define GCI_DATETIME_INCON_DATATYPE_ERR_CODE GCI_S_ERROR_BASE + 130

#define GCI_STMTGETBINDINFO_STARTLOC_ERR_MSG "The value of startloc is greater then found or invalid."
#define GCI_STMTGETBINDINFO_STARTLOC_ERR_CODE GCI_S_ERROR_BASE + 131

#define GCI_GET_SESSION_NAMENULL_ERR_MSG    "length specified for null connect string."
#define GCI_GET_SESSION_NAMENULL_ERR_CODE   GCI_S_ERROR_BASE + 132

#define GCI_GET_SESSION_NAMELENZERO_ERR_MSG "no connection pool to associate server handle."
#define GCI_GET_SESSION_NAMELENZERO_ERR_CODE GCI_S_ERROR_BASE + 133

#define GCI_GET_SESSION_MODENULL_ERR_MSG    "TNS:could not resolve the connect identifier specified."
#define GCI_GET_SESSION_MODENULL_ERR_CODE   GCI_S_ERROR_BASE + 134

#define GCI_GET_SESSION_MODE_ERR_MSG        "bad value for mode."
#define GCI_GET_SESSION_MODE_ERR_CODE       GCI_S_ERROR_BASE + 135

#define GCI_DSN_OPEN_CONFIG_ERR_MSG         "cannot open config file, please check the env vairable $GCICLIENTDIR."
#define GCI_DSN_OPEN_CONFIG_ERR_CODE        GCI_S_ERROR_BASE + 136

#define GCI_DSN_NAME_UNSET_ERR_MSG          "in dsn mode, please pass dsn name to connection related API, such as GCILogon .etc."
#define GCI_DSN_NAME_UNSET_ERR_CODE         GCI_S_ERROR_BASE + 137

#define GCI_DSN_CONFIG_FILE_ERR_MSG         "config file path is invalid, please check the env vairable $GCICLIENTDIR."
#define GCI_DSN_CONFIG_FILE_ERR_CODE        GCI_S_ERROR_BASE + 138

#define GCI_DSN_SERVER_ERR_MSG              "dsn_server_name in specified dsn section of gci.conf file is empty."
#define GCI_DSN_SERVER_ERR_CODE             GCI_S_ERROR_BASE + 140

#define GCI_NEED_DATABASE_ERR_MSG           "database name is empty, please pass it in connect related API, such as GCILogon .etc or setup it in gci.conf."
#define GCI_NEED_DATABASE_ERR_CODE          GCI_S_ERROR_BASE + 141

#define GCI_CONN_POOL_ID_ERR_MSG            "Could not get the connect pool id."
#define GCI_CONN_POOL_ID_ERR_CODE           GCI_S_ERROR_BASE + 142

#define GCI_OPEN_HOST_FILE_ERR_MSG          "open sqlhost file failed."
#define GCI_OPEN_HOST_FILE_ERR_CODE         GCI_S_ERROR_BASE + 144

#define GCI_DBLINK_FORMAT_ERR_MSG           "dblink format is not correct, it should be ip_addr:port/dbname@dbserver."
#define GCI_DBLINK_FORMAT_ERR_CODE          GCI_S_ERROR_BASE + 145

#define GCI_LOBTRIM_LEN_ERR_MSG             "newlen should not be greater than the current LOB length."
#define GCI_LOBTRIM_LEN_ERR_CODE            GCI_S_ERROR_BASE + 146

#define GCI_STMTGETBINDINFO_FOUND_ERR_MSG   "the found address is null."
#define GCI_STMTGETBINDINFO_FOUND_ERR_CODE  GCI_S_ERROR_BASE + 147

#define GCI_STMTGETBINDINFO_BVNP_ERR_MSG    "the bvnp address is null."
#define GCI_STMTGETBINDINFO_BVNP_ERR_CODE   GCI_S_ERROR_BASE + 148

#define GCI_STMTGETBINDINFO_BVNL_ERR_MSG    "the bvnl address is null."
#define GCI_STMTGETBINDINFO_BVNL_ERR_CODE   GCI_S_ERROR_BASE + 149

#define GCI_STMTGETBINDINFO_INVP_ERR_MSG    "the invp address is null."
#define GCI_STMTGETBINDINFO_INVP_ERR_CODE   GCI_S_ERROR_BASE + 150

#define GCI_STMTGETBINDINFO_INPL_ERR_MSG    "the inpl address is null."
#define GCI_STMTGETBINDINFO_INPL_ERR_CODE   GCI_S_ERROR_BASE + 151

#define GCI_STMTGETBINDINFO_DUPL_ERR_MSG    "the dupl address is null."
#define GCI_STMTGETBINDINFO_DUPL_ERR_CODE   GCI_S_ERROR_BASE + 152

#define GCI_DATETIME_NOT_RECOGNIZED_ERR_MSG "date format not recognized."
#define GCI_DATETIME_NOT_RECOGNIZED_ERR_CODE GCI_S_ERROR_BASE + 153

#define GCI_DATETIME_REGION_FAILED_ERR_MSG  "this region is currently not supported."
#define GCI_DATETIME_REGION_FAILED_ERR_CODE GCI_S_ERROR_BASE + 154

#define GCI_DATETIME_STRING_TOO_LONG_ERR_MSG "string is too long for internal buffer."
#define GCI_DATETIME_STRING_TOO_LONG_ERR_CODE GCI_S_ERROR_BASE + 155

#define GCI_DATETIME_CLASS_INVALID_ERR_MSG   "the datetime class is invalid."
#define GCI_DATETIME_CLASS_INVALID_ERR_CODE  GCI_S_ERROR_BASE + 156

#define GCI_INTERVAL_DIVISOR_ZERO_ERR_MSG    "divisor is equal to zero."
#define GCI_INTERVAL_DIVISOR_ZERO_ERR_CODE  GCI_S_ERROR_BASE + 157

#define GCI_INTERVAL_INCONSISTENT_ERR_MSG    "inconsistent datatypes: expected %s got %s."
#define GCI_INTERVAL_INCONSISTENT_ERR_CODE  GCI_S_ERROR_BASE + 158

#define GCI_TIMEZONE_OVERFLOW_ERR_MSG       "Overflow occurred on a datetime or interval operation"
#define GCI_TIMEZONE_OVERFLOW_ERR_CODE      GCI_S_ERROR_BASE + 159

#define GCI_DATETIME_CONVERT_ERR_MSG        "the intervals or datetimes are not mutually comparable"
#define GCI_DATETIME_CONVERT_ERR_CODE       GCI_S_ERROR_BASE + 160

#define GCI_TRACEFUN_ILLEGAL_DIRECT_ERR_MSG   "Illegal direct invocation of logical log function."
#define GCI_TRACEFUN_ILLEGAL_DIRECT_ERR_CODE  GCI_S_ERROR_BASE + 137

#define GCI_TRACEFUN_LOG_FILE_NULL_ERR_MSG    "Failed to open the logical log file."
#define GCI_TRACEFUN_LOG_FILE_NULL_ERR_CODE   GCI_S_ERROR_BASE + 138

#define GCI_TRACEFUN_FWRITE_FAIL_ERR_MSG      "Failed to write logical log to the logical log file."
#define GCI_TRACEFUN_FWRITE_FAIL_ERR_CODE     GCI_S_ERROR_BASE + 139

#define GCI_MISS_ESQLC_DATA_TYPE_ERR_MSG    "miss esqlc data type:%d. extended data type:%d."
#define GCI_MISS_ESQLC_DATA_TYPE_ERR_CODE   GCI_S_ERROR_BASE + 140

#define GCI_CONFUNC_ERR_BASE_MESSAGE        "convert function error."
#define GCI_CONFUNC_ERR_BASE                700000

#define GCI_CONFUNC_DATE_DATETIME_ERROR     721100
#define GCI_CONFUNC_INTERVAL_ERROR          721200
#define GCI_CONFUNC_INTERVAL_MAX_ERROR      721300

#define GCI_CONFUNC_UINT_OVERFLOW_MESSAGE   "The value returned from database is bigger than the max value of unsigned int."
#define GCI_CONFUNC_UINT_OVERFLOW_ERROR     GCI_CONFUNC_ERR_BASE + 1

#define GCI_CONFUNC_TOOSAMLL_BUFFER_MESSAGE "buffer too small, assignment error."
#define GCI_CONFUNC_TOOSMALL_BUFFER_ERROR   GCI_CONFUNC_ERR_BASE + 3

#define GCI_CONFUNC_OUTOF_RANGE_MESSAGE     "Numeric value out of range."
#define GCI_CONFUNC_OUTOF_RANGE_ERROR       GCI_CONFUNC_ERR_BASE + 4

#define GCI_CONFUNC_RIGHT_TRUNCATE_MESSAGE  "String data right truncation."
#define GCI_CONFUNC_RIGHT_TRUNCATE_ERROR    GCI_CONFUNC_ERR_BASE + 5

#define GCI_CONFUNC_MISS_FUNC_MESSAGE       "miss convert function, external data type:%d, internal data type:%d."
#define GCI_CONFUNC_MISS_FUNC_ERROR         GCI_CONFUNC_ERR_BASE + 6

#define GCI_CONFUNC_DTIME_CON_FAILED_MSG    "datetime convert failed."
#define GCI_CONFUNC_DTIME_CON_FAILED_ERROR   GCI_CONFUNC_ERR_BASE + 7

#define GCI_CONFUNC_INVALID_CHARACTER_MSG   "invalid character value for cast specification."
#define GCI_CONFUNC_INVALID_CHARACTER_ERROR  GCI_CONFUNC_ERR_BASE + 8

#endif
