#ifndef _GBS_FAST_LOAD_H
#define _GBS_FAST_LOAD_H

#define GBS_SUCCESS 0                      /* maps to SQL_SUCCESS of SAG CLI */
#define GBS_SUCCESS_WITH_INFO 1             /* maps to SQL_SUCCESS_WITH_INFO */
#define GBS_NO_DATA 100                               /* maps to SQL_NO_DATA */
#define GBS_ERROR -1                                    /* maps to SQL_ERROR */

typedef struct fhinstance fhinstance;

int gbs_load_alloc(
    fhinstance **instance
);

int gbs_load_free(
    fhinstance *instance
);

int gbs_load_initialize(
    fhinstance *instance,
    char *ip_address,
    char *port,
    char *server_name,
    char *db_name,
    char *uid,
    char *pwd,
    char *sqlmode
);

int gbs_load_uninitialize(
    fhinstance *instance
);

int gbs_load_execute(
    fhinstance *instance,
    char *command,
    long long *row_count
);

int gbs_get_diag(
    fhinstance *instance,
    int *err_code,
    char *err_msg,
    int buf_sz,
    int *msg_len
);

#define GBS_ERROR_BASE 90000

#define GBS_INVALID_PARAM_CODE    GBS_ERROR_BASE + 1
#define GBS_INVALID_PARAM_MSG     "invalide parameter."

#define GBS_SQLHOST_FILE_CODE     GBS_ERROR_BASE + 2
#define GBS_SQLHOST_FILE_MSG      "could not generate sqlhost file."

#define GBS_CONN_NAME_CODE        GBS_ERROR_BASE + 3
#define GBS_CONN_NAME_MSG         "could not generate connection name."

#define GBS_GET_CWD_CODE          GBS_ERROR_BASE + 4
#define GBS_GET_CWD_MSG           "get current working directory failed."

#define GBS_CHANGE_DIR_CODE       GBS_ERROR_BASE + 5
#define GBS_CHANGE_DIR_MSG        "change directory failed."

#define GBS_ALLOCATE_MEM_CODE     GBS_ERROR_BASE + 6
#define GBS_ALLOCATE_MEM_MSG      "allocate memory failed."

#define GBS_CREATE_LOB_FILE_CODE  GBS_ERROR_BASE + 7
#define GBS_CREATE_LOB_FILE_MSG   "create local lob file failed."

#define GBS_INVALIDE_HANDLE_CODE  GBS_ERROR_BASE + 8
#define GBS_INVALIDE_HANDLE_MSG   "invalide handle."

#define GBS_PUTC_FAILED_CODE      GBS_ERROR_BASE + 9
#define GBS_PUTC_FAILED_MSG       "writes the character to stream failed."


#endif // _GBS_FAST_LOAD_H