#!/bin/bash
#################################################
# filename: install_gls.sh
# function: language package for GBase 8s GLS
# write by: liaojinqing@gbase.cn 2022-04-20
#################################################
export LANG=C
loginfo(){
  echo -e "[$(date +'%Y-%m-%d %H:%M:%S')] $*"
}
WORKDIR=$(pwd)
GLSFILE="GBase8s_GLS_Language.tar.gz"

# check env
if [ ! x"$(whoami)" = "xroot" ]; then
  loginfo "Must run as root !" 
  exit 100
fi

if [ ! -f ${GLSFILE} ]; then
  loginfo "${GLSFILE} not exits."
  exit 101
fi

if [ ! -d /GBASEDBTTMP ]; then
  loginfo "GBase 8s database server not exists."
  [ ! -f /GBASEDBTTMP/.infxdirs ] && loginfo "GBase 8s install path not found."
  read -p "Enter path to install: " READPATH
  if [ ! -f ${READPATH}/bin/glfiles ]; then
    loginfo "${READPATH} not contain GBase 8s Server or CSDK."
    exit 101
  fi
  DBTPATH=${READPATH}
else
  NUMINST=$(cat /GBASEDBTTMP/.infxdirs | wc -l)
  loginfo "They is(are) ${NUMINST} install(s) found in this server."
  cat /GBASEDBTTMP/.infxdirs
  DBTPATH=$(head -n 1 /GBASEDBTTMP/.infxdirs)
  while true
  do
    read -p "Enter path to install: " READPATH 
    while read FILEPATH
    do
      if [ x"${READPATH}" = x"${FILEPATH}" ]; then
        DBTPATH=${FILEPATH}
        break
      fi
    done < /GBASEDBTTMP/.infxdirs
    if [ x"${READPATH}" = x"${DBTPATH}" ]; then
      break
    fi
  done
fi

loginfo "Backup ${DBTPATH}/gls"
tar cf ${WORKDIR}/tmp_gls.tar ${DBTPATH}/gls >>/dev/null 2>&1

loginfo "Unpackage GLSFILE."
tar zxf ${WORKDIR}/${GLSFILE} -C ${DBTPATH}/gls >>/dev/null 2>&1
if [ ! $? -eq 0 ]; then
  loginfo "GBase 8s language package install error !"
  if [ -f ${WORKDIR}/tmp_gls.tar ]; then
    tar xf ${WORKDIR}/tmp_gls.tar -C ${DBTPATH}/gls
  fi
  exit 1
fi

loginfo "Change permission for dir."
if [ -f ${DBTPATH}/gls/chdir.sh ]; then
  cd ${DBTPATH}/gls && sh ${DBTPATH}/gls/chdir.sh
  rm -Rf ${DBTPATH}/gls/chdir.sh
fi

loginfo "Change permission for file."
if [ -f ${DBTPATH}/gls/chfile.sh ]; then
  cd ${DBTPATH}/gls && sh ${DBTPATH}/gls/chfile.sh
  rm -Rf ${DBTPATH}/gls/chfile.sh
fi

loginfo "Clean temp files."
if [ -f ${WORKDIR}/tmp_gls.tar ]; then
  rm -Rf ${WORKDIR}/tmp_gls.tar
fi

if [ -f ${WORKDIR}/${GLSFILE} ]; then
  rm -Rf ${WORKDIR}/${GLSFILE}
fi

cd ${WORKDIR}
loginfo "Finish install."

exit 0
