/*
  +----------------------------------------------------------------------+
  | (C) Copyright IBM Corporation 2006.                                  |
  +----------------------------------------------------------------------+
  |                                                                      |
  | Licensed under the Apache License, Version 2.0 (the "License"); you  |
  | may not use this file except in compliance with the License. You may |
  | obtain a copy of the License at                                      |
  | http://www.apache.org/licenses/LICENSE-2.0                           |
  |                                                                      |
  | Unless required by applicable law or agreed to in writing, software  |
  | distributed under the License is distributed on an "AS IS" BASIS,    |
  | WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or      |
  | implied. See the License for the specific language governing         |
  | permissions and limitations under the License.                       |
  +----------------------------------------------------------------------+
  | Authors: Rick McGuire, Dan Scott, Krishna Raman, Kellen Bombardier,  |
  | Ambrish Bhargava, Rahul Priyadarshi                                  |
  +----------------------------------------------------------------------+
*/

#ifndef PHP_PDO_GBASEDBT_H
#define PHP_PDO_GBASEDBT_H

#define PDO_GBASEDBT_VERSION "1.3.6"

extern zend_module_entry pdo_gbasedbt_module_entry;
#define phpext_pdo_gbasedbt_ptr &pdo_gbasedbt_module_entry

#ifdef PHP_WIN32
#define PHP_PDO_GBASEDBT_API __declspec(dllexport)
#else
#define PHP_PDO_GBASEDBT_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

PHP_MINIT_FUNCTION(pdo_gbasedbt);
PHP_MSHUTDOWN_FUNCTION(pdo_gbasedbt);
PHP_RINIT_FUNCTION(pdo_gbasedbt);
PHP_RSHUTDOWN_FUNCTION(pdo_gbasedbt);
PHP_MINFO_FUNCTION(pdo_gbasedbt);

/*PHP_FUNCTION(confirm_pdo_gbasedbt_compiled);*/	/* For testing, remove later. */

/* 
	Declare any global variables you may need between the BEGIN
	and END macros here:     

ZEND_BEGIN_MODULE_GLOBALS(pdo_gbasedbt)
	long  global_value;
	char *global_string;
ZEND_END_MODULE_GLOBALS(pdo_gbasedbt)
*/

/*
	In every utility function you add that needs to use variables 
	in php_pdo_gbasedbt_globals, call TSRMLS_FETCH(); after declaring other 
	variables used by that function, or better yet, pass in TSRMLS_CC
	after the last function argument and declare your utility function
	with TSRMLS_DC after the last declared argument.  Always refer to
	the globals in your function as PDO_GBASEDBT_G(variable).  You are 
	encouraged to rename these macros something shorter, see
	examples in any other php module directory.
*/

#ifdef ZTS
#define PDO_GBASEDBT_G(v) TSRMG(pdo_gbasedbt_globals_id, zend_pdo_gbasedbt_globals *, v)
#else
#define PDO_GBASEDBT_G(v) (pdo_gbasedbt_globals.v)
#endif

#endif	/* PHP_PDO_GBASEDBT_H */
