if test "$PHP_PDO" != "no"; then

PHP_ARG_WITH(pdo-gbasedbt, for GBasedbt driver for PDO,
[  --with-pdo-gbasedbt[=DIR] Include PDO GBasedbt support, DIR is the base
                            GBasedbt install directory, defaults to ${GBASEDBTDIR:-nothing}.])

if test "$PHP_PDO_GBASEDBT" != "no"; then

  if test -n "$PHP_PDO_GBASEDBT" -a "$PHP_PDO_GBASEDBT" != "yes"; then
    GBASEDBTDIR="$PHP_PDO_GBASEDBT"
  else
    if test "$GBASEDBTDIR" = ""; then
      AC_MSG_ERROR([GBASEDBTDIR environment variable is not set. Please use --with-pdo-gbasedbt=<DIR> or set the GBASEDBTDIR environment variable.])
    fi
  fi

  AC_MSG_CHECKING([for PDO includes])
  if test -f $abs_srcdir/include/php/ext/pdo/php_pdo_driver.h; then
    pdo_inc_path=$abs_srcdir/ext
  elif test -f $abs_srcdir/ext/pdo/php_pdo_driver.h; then
    pdo_inc_path=$abs_srcdir/ext
  elif test -f $prefix/include/php/ext/pdo/php_pdo_driver.h; then
    pdo_inc_path=$prefix/include/php/ext
  elif test -f $phpincludedir/ext/pdo/php_pdo_driver.h; then
    pdo_inc_path=$phpincludedir/ext
  else
    AC_MSG_ERROR([Cannot find php_pdo_driver.h.])
  fi
  AC_MSG_RESULT($pdo_inc_path)

  dnl Don't forget to add additional source files here
  php_pdo_gbasedbt_sources_core="pdo_gbasedbt.c gbasedbt_driver.c gbasedbt_statement.c"

  AC_MSG_CHECKING([for includes and libraries])
 
  if test -d "$GBASEDBTDIR"; then
    if test ! -d "$GBASEDBTDIR/incl/cli"; then
       AC_MSG_ERROR([Cannot find GBase Client SDK includes in $GBASEDBTDIR/inc/cli])
    fi  
    if test ! -d "$GBASEDBTDIR/incl/esql"; then
       AC_MSG_ERROR([Cannot find ESQL/C includes in $GBASEDBTDIR/inc/esql])
    fi  
    if test ! -d "$GBASEDBTDIR/$PHP_LIBDIR"; then
       AC_MSG_ERROR([Cannot find GBasedbt libraries in $GBASEDBTDIR/$PHP_LIBDIR])
    fi  
    if test ! -d "$GBASEDBTDIR/$PHP_LIBDIR/cli"; then
       AC_MSG_ERROR([Cannot find GBase Client SDK libraries in $GBASEDBTDIR/$PHP_LIBDIR/cli])
    fi  
    if test ! -d "$GBASEDBTDIR/$PHP_LIBDIR/esql"; then
       AC_MSG_ERROR([Cannot find ESQL/C libraries in $GBASEDBTDIR/$PHP_LIBDIR/esql])
    fi  
  else
    AC_MSG_ERROR([GBasedbt base installation directory '$GBASEDBTDIR' doesn't exist.])
  fi
 
  AC_MSG_RESULT($GBASEDBTDIR)

  PHP_ADD_INCLUDE($GBASEDBTDIR/incl/cli)
  PHP_ADD_INCLUDE($GBASEDBTDIR/incl/esql)
  dnl PHP_ADD_INCLUDE($GBASEDBTDIR/incl/<whatever include directory you need>)
  PHP_ADD_LIBPATH($GBASEDBTDIR/$PHP_LIBDIR, PDO_GBASEDBT_SHARED_LIBADD)
  PHP_ADD_LIBPATH($GBASEDBTDIR/$PHP_LIBDIR/cli, PDO_GBASEDBT_SHARED_LIBADD)
  PHP_ADD_LIBPATH($GBASEDBTDIR/$PHP_LIBDIR/esql, PDO_GBASEDBT_SHARED_LIBADD)

  dnl Check if thread safety flags are needed
  if test "$enable_experimental_zts" = "yes"; then
    IFX_ESQL_FLAGS="-thread"   
    CPPFLAGS="$CPPFLAGS -DIFX_THREAD"
  else
    IFX_ESQL_FLAGS=""
  fi

  IFX_LIBS=`THREADLIB=POSIX $GBASEDBTDIR/bin/esql $IFX_ESQL_FLAGS -libs`
  IFX_LIBS=`echo $IFX_LIBS | sed -e 's/Libraries to be used://g' -e 's/esql: error -55923: No source or object file\.//g'`

  dnl Seems to get rid of newlines.
  dnl According to Perls DBD-GBasedbt, might contain these strings.

  case "$host_alias" in
    *aix*)
      CPPFLAGS="$CPPFLAGS -D__H_LOCALEDEF";;
  esac

  AC_MSG_CHECKING([GBasedbt version])
  IFX_VERSION=[`$GBASEDBTDIR/bin/esql -V | grep "ESQL Version" | sed -ne '1 s/\(.*\)ESQL Version \([0-9]*\)\.\([0-9]*\).*/\2\3/p'`]
  AC_MSG_RESULT($IFX_VERSION)
  AC_DEFINE_UNQUOTED(IFX_VERSION, $IFX_VERSION, [ ])

  if test $IFX_VERSION -ge 900; then
    AC_DEFINE(HAVE_IFX_IUS,1,[ ])
dnl    IFX_ESQL_FLAGS="$IFX_ESQL_FLAGS -EDHAVE_IFX_IUS"
dnl  else
dnl    IFX_ESQL_FLAGS="$IFX_ESQL_FLAGS -EUHAVE_IFX_IUS"
  fi

  PHP_NEW_EXTENSION(pdo_gbasedbt, $php_pdo_gbasedbt_sources_core, $ext_shared,,-I$pdo_inc_path)

  PHP_ADD_MAKEFILE_FRAGMENT

  PHP_ADD_LIBRARY_DEFER(ifcli, 1, PDO_GBASEDBT_SHARED_LIBADD)
  PHP_ADD_LIBRARY_DEFER(ifdmr, 1, PDO_GBASEDBT_SHARED_LIBADD)
  

  for i in $IFX_LIBS; do
    case "$i" in
      *.o)
        IFX_LIBOBJS="$IFX_LIBOBJS $i"
        PHP_ADD_LIBPATH($ext_builddir, PDO_GBASEDBT_SHARED_LIBADD)
dnl        PHP_ADD_LIBRARY_DEFER(pdo_gbasedbt, 1, PDO_GBASEDBT_SHARED_LIBADD)
        ;;
      -lm)
        ;;
      -lc)
        ;;
      -l*)
        lib=`echo $i | cut -c 3-`
        PHP_ADD_LIBRARY_DEFER($lib, 1, PDO_GBASEDBT_SHARED_LIBADD)
        ;;
      *.a)
        case "`uname -s 2>/dev/null`" in
          UnixWare | SCO_SV | UNIX_SV)
            DLIBS="$DLIBS $i"
            ;;
          *)
            ac_dir="`echo $i|sed 's#[^/]*$##;s#\/$##'`"
            ac_lib="`echo $i|sed 's#^/.*/$PHP_LIBDIR##g;s#\.a##g'`"
            DLIBS="$DLIBS -L$ac_dir -l$ac_lib"
            ;;
        esac
        ;;
    esac
  done

  PHP_SUBST(PDO_GBASEDBT_SHARED_LIBADD)
  PHP_SUBST(GBASEDBTDIR)
  PHP_SUBST(IFX_LIBOBJS)
  PHP_SUBST(IFX_ESQL_FLAGS)

fi

fi
