/*
  +----------------------------------------------------------------------+
  | (C) Copyright IBM Corporation 2006.                                  |
  +----------------------------------------------------------------------+
  |                                                                      |
  | Licensed under the Apache License, Version 2.0 (the "License"); you  |
  | may not use this file except in compliance with the License. You may |
  | obtain a copy of the License at                                      |
  | http://www.apache.org/licenses/LICENSE-2.0                           |
  |                                                                      |
  | Unless required by applicable law or agreed to in writing, software  |
  | distributed under the License is distributed on an "AS IS" BASIS,    |
  | WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or      |
  | implied. See the License for the specific language governing         |
  | permissions and limitations under the License.                       |
  +----------------------------------------------------------------------+
  | Authors: Rick McGuire, Dan Scott, Krishna Raman, Kellen Bombardier,  |
  | Ambrish Bhargava, Rahul Priyadarshi                                  |
  +----------------------------------------------------------------------+
*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#endif

#include "php.h"
#include "php_ini.h"
#include "ext/standard/info.h"
#include "pdo/php_pdo_driver.h"
#include "php_pdo_gbasedbt.h"
#include "php_pdo_gbasedbt_int.h"

/* If you declare any globals in php_pdo_gbasedbt.h uncomment this:
ZEND_DECLARE_MODULE_GLOBALS(pdo_gbasedbt)
*/

/* True global resources - no need for thread safety here */
static int le_pdo_gbasedbt;
extern pdo_driver_t pdo_gbasedbt_driver;	/* the registration table */

/* {{{ pdo_gbasedbt_functions[]
 *
 * Every user visible function must have an entry in pdo_gbasedbt_functions[].
 */
zend_function_entry pdo_gbasedbt_functions[] =
{
	PHP_FE_END	
//	PHP_FE(confirm_pdo_gbasedbt_compiled, NULL)	/* For testing, remove later. */
//	{
//		NULL, NULL, NULL
//	}	/* Must be the last line in pdo_gbasedbt_functions[] */
};
/* }}} */

/* {{{ pdo_gbasedbt_deps
 */
#if ZEND_MODULE_API_NO >= 20041225
static zend_module_dep pdo_gbasedbt_deps[] = {
	ZEND_MOD_REQUIRED("pdo")
	{NULL, NULL, NULL}
};
#endif
/* }}} */

/* {{{ pdo_gbasedbt_module_entry
 */
zend_module_entry pdo_gbasedbt_module_entry =
{
#if ZEND_MODULE_API_NO >= 20041225
	STANDARD_MODULE_HEADER_EX, NULL,
	pdo_gbasedbt_deps,
#else
	STANDARD_MODULE_HEADER,
#endif
	"pdo_gbasedbt",
	pdo_gbasedbt_functions,
	PHP_MINIT(pdo_gbasedbt),
	PHP_MSHUTDOWN(pdo_gbasedbt),
	PHP_RINIT(pdo_gbasedbt),        /* Replace with NULL if there's nothing to do at request start */
	PHP_RSHUTDOWN(pdo_gbasedbt),    /* Replace with NULL if there's nothing to do at request end */
	PHP_MINFO(pdo_gbasedbt),
	PDO_GBASEDBT_VERSION,   /* Replace with version number for your extension */
	STANDARD_MODULE_PROPERTIES
};
/* }}} */

#ifdef COMPILE_DL_PDO_GBASEDBT
ZEND_GET_MODULE(pdo_gbasedbt)
#endif

/* {{{ PHP_INI
 */
/* Remove comments and fill if you need to have entries in php.ini
PHP_INI_BEGIN()
	STD_PHP_INI_ENTRY("pdo_gbasedbt.global_value",      "42", PHP_INI_ALL, OnUpdateLong, global_value, zend_pdo_gbasedbt_globals, pdo_gbasedbt_globals)
	STD_PHP_INI_ENTRY("pdo_gbasedbt.global_string", "foobar", PHP_INI_ALL, OnUpdateString, global_string, zend_pdo_gbasedbt_globals, pdo_gbasedbt_globals)
PHP_INI_END()
*/
/* }}} */

/* {{{ php_pdo_gbasedbt_init_globals
 */
/* Uncomment this function if you have INI entries
static void php_pdo_gbasedbt_init_globals(zend_pdo_gbasedbt_globals *pdo_gbasedbt_globals)
{
	pdo_gbasedbt_globals->global_value = 0;
	pdo_gbasedbt_globals->global_string = NULL;
}
*/
/* }}} */

/* {{{ PHP_MINIT_FUNCTION
 */
PHP_MINIT_FUNCTION(pdo_gbasedbt)
{
	/* If you have INI entries, uncomment these lines
	ZEND_INIT_MODULE_GLOBALS(pdo_gbasedbt, php_pdo_gbasedbt_init_globals, NULL);
	REGISTER_INI_ENTRIES();
	*/

	
	php_pdo_register_driver(&pdo_gbasedbt_driver);
	return TRUE;  
}
/* }}} */

/* {{{ PHP_MSHUTDOWN_FUNCTION
 */
PHP_MSHUTDOWN_FUNCTION(pdo_gbasedbt)
{
	/* uncomment this line if you have INI entries
	UNREGISTER_INI_ENTRIES();
	*/
	 
	php_pdo_unregister_driver(&pdo_gbasedbt_driver);
	return TRUE;
}
/* }}} */

/* Remove if there's nothing to do at request start */
/* {{{ PHP_RINIT_FUNCTION
 */
PHP_RINIT_FUNCTION(pdo_gbasedbt)
{
	return TRUE;
}
/* }}} */

/* Remove if there's nothing to do at request end */
/* {{{ PHP_RSHUTDOWN_FUNCTION
 */
PHP_RSHUTDOWN_FUNCTION(pdo_gbasedbt)
{
	return TRUE;
}
/* }}} */

/* {{{ PHP_MINFO_FUNCTION
 */
PHP_MINFO_FUNCTION(pdo_gbasedbt)
{
	php_info_print_table_start();
	php_info_print_table_header(2, "pdo_gbasedbt support", "enabled");
	php_info_print_table_row(2, "Module release", PDO_GBASEDBT_VERSION);
	php_info_print_table_end();

	/* Remove comments if you have entries in php.ini
	DISPLAY_INI_ENTRIES();
	*/
}
/* }}} */


/* Remove the following function when you have succesfully modified config.m4
   so that your module can be compiled into PHP, it exists only for testing
   purposes. */

/* Every user-visible function in PHP should document itself in the source */
/* {{{ proto string confirm_pdo_gbasedbt_compiled(string arg)
   Return a string to confirm that the module is compiled in */
/*PHP_FUNCTION(confirm_pdo_gbasedbt_compiled)
{
	char *arg = NULL;
	int arg_len, len;
	char string[256];

	if (zend_parse_parameters(ZEND_NUM_ARGS() , "s", &arg, &arg_len) == FALSE)
	{
		return;
	}

	len = sprintf(string, "Congratulations! You have successfully modified ext/%.78s/config.m4. Module %.78s is now compiled into PHP.", "pdo_gbasedbt", arg);
#if PHP_MAJOR_VERSION >= 7
	RETURN_STRINGL(string, len);
#else
	RETURN_STRINGL(string, len, 1);
#endif
}*/
/* }}} */
