/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.lang.ref.WeakReference;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.firebirdsql.ds.FBPooledConnection;
import org.firebirdsql.ds.PooledConnectionHandler;
import org.firebirdsql.ds.XAConnectionHandler;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBSQLException;

public class FBXAConnection
extends FBPooledConnection
implements XAConnection {
    private WeakReference mc;

    public FBXAConnection(AbstractConnection connection) {
        super(connection);
        this.mc = new WeakReference<FBManagedConnection>(connection.getManagedConnection());
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this.getManagedConnection().getXAResource();
    }

    @Override
    protected void resetConnection() throws SQLException {
        if (!this.inDistributedTransaction()) {
            this.connection.setAutoCommit(true);
        }
    }

    @Override
    protected PooledConnectionHandler createConnectionHandler() {
        return new XAConnectionHandler(this.connection, this);
    }

    protected boolean inDistributedTransaction() throws SQLException {
        return this.getManagedConnection().inDistributedTransaction();
    }

    private FBManagedConnection getManagedConnection() throws SQLException {
        FBManagedConnection managedConnection = (FBManagedConnection)this.mc.get();
        if (managedConnection == null) {
            throw new FBSQLException("Managed Connection is null, connection unavailable", "08003");
        }
        return managedConnection;
    }
}

