/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscSvcHandle;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;

public final class isc_svc_handle_impl
implements IscSvcHandle {
    private int handle;
    private List warnings = new ArrayList();
    private boolean invalid = true;
    Socket socket;
    public XdrOutputStream out;
    public XdrInputStream in;
    private int resp_object;
    private long resp_blob_id;
    private byte[] resp_data;

    @Override
    public boolean isValid() {
        return !this.invalid;
    }

    void invalidate() throws IOException {
        this.in.close();
        this.out.close();
        this.socket.close();
        this.in = null;
        this.out = null;
        this.socket = null;
        this.invalid = true;
    }

    public void setHandle(int rdb_id) {
        this.handle = rdb_id;
        this.invalid = false;
    }

    public int getHandle() {
        this.checkValidity();
        return this.handle;
    }

    public long getResp_blob_id() {
        return this.resp_blob_id;
    }

    public void setResp_blob_id(long resp_blob_id) {
        this.resp_blob_id = resp_blob_id;
    }

    public byte[] getResp_data() {
        return this.resp_data;
    }

    public void setResp_data(byte[] resp_data) {
        this.resp_data = resp_data;
    }

    public int getResp_object() {
        return this.resp_object;
    }

    public void setResp_object(int resp_object) {
        this.resp_object = resp_object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getWarnings() {
        this.checkValidity();
        List list = this.warnings;
        synchronized (list) {
            return new ArrayList(this.warnings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWarning(GDSException warning) {
        this.checkValidity();
        List list = this.warnings;
        synchronized (list) {
            this.warnings.add(warning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() {
        this.checkValidity();
        List list = this.warnings;
        synchronized (list) {
            this.warnings.clear();
        }
    }

    @Override
    public boolean isNotValid() {
        return this.invalid;
    }

    private void checkValidity() {
        if (this.invalid) {
            throw new IllegalStateException("This database handle is invalid and cannot be used anymore.");
        }
    }
}

